/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: CollectionUtil.c,v 1.4 1994/08/12 03:17:38 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"


void Collection_Free(colp)
     COLLECTION *colp;
{
  if (colp == NULL)
    {
      FatalError(E_FREECOLLECTION,
		 "Attempt to free NULL collection.\n");
    }
  if ((PROGRAM_ErrorNo == E_NULL) && (COLLECTION_Name(colp) != NULL))
    String_Free(COLLECTION_Name(colp));
  if ((PROGRAM_ErrorNo == E_NULL) && (COLLECTION_Path(colp) != NULL))
    String_Free(COLLECTION_Path(colp));
#if 0
  /* temporararily commented out till all these routines are written */
  /* $$$FREE UP ALLOCATED SPACE$$$ */
  if ((PROGRAM_ErrorNo == E_NULL) && (COLLECTION_HintDB(colp) != NULL))
    HintDB_Free(COLLECTION_HintDB(colp));
#endif 0
  if ((PROGRAM_ErrorNo == E_NULL) && (COLLECTION_CommandList(colp) != NULL))
    StringArray_Free(COLLECTION_CommandList(colp));
  if ((PROGRAM_ErrorNo == E_NULL) && (COLLECTION_Image(colp) != NULL))
    FileSystemImage_Free(COLLECTION_Image(colp));
  if ((PROGRAM_ErrorNo == E_NULL) && (COLLECTION_TargetDB(colp) != NULL))
    TargetDB_Free(COLLECTION_TargetDB(colp));
  if (PROGRAM_ErrorNo == E_NULL)
    (void)free((void *)colp);

  return;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Collection/RCS/CollectionUtil.c,v $ */
