/***********************************************************
        Copyright 1991 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Header: /afs/andrew.cmu.edu/system/src/local/depot2/020/src/cmd/hintservice/RCS/hintservice.c,v 1.5 1995/05/11 13:45:53 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

#include "depotlib.h"
#include "util.h"
#include "DepotErrorCodes.h"
#include "FileSystemImage.h"
#include "Hint.h"
#include "HintService.h"

static char VersionString[] = "hintservice: $Revision: 1.5 $ $Date: 1995/05/11 13:45:53 $";
static char *UsageString[] =
{
  "hintservice -set location -image imagefilename hintprefix",
  "hintservice -set location -file filename hintprefix",
  "hintservice -unset location hintprefix",
  "hintservice -get location path",
  "hintservice -getall location subtreepath",
  "hintservice -help",
};
static unsigned NOptions = sizeof(UsageString) / sizeof(UsageString[0]);

static void 
Usage(fp)
     FILE *fp;
{
  register char **up;
  register unsigned i;

  (void) fprintf(fp, "%s\n", VersionString);
  (void) fprintf(fp, "%s\n", getversion_libdepot());
  for (i = 0, up = UsageString; i < NOptions; i++, up++) {
    fputs("\t", fp);
    fputs(*up, fp);
    fputs("\n", fp);
  }
}

/* main entry point
 */
main(argc, argv)
     int argc;
     char **argv;
{
  FILE *out = stdout;
  register HINTDB hp;
  FILESYSTEMIMAGE *fsimage;
  HINT *hintp;
  HINTDB hintdb;
  char *path;
  char *hintlocation;

  if (argc < 2) {
    FatalError(E_USAGE, "Error on command line: no arguments\n");
  } else {
    if (strcmp(argv[1], "-set") == 0) {
      if (argc < 4) {
	FatalError(E_USAGE,
		   "Error on command line: wrong number of arguments.\n");
      } else {
	hintlocation = argv[2];
	hintdb = NULL;
	if (strcmp(argv[3], "-image") == 0) {
	  if (argc != 6) {
	    FatalError(E_USAGE,
		     "Error on command line: wrong number of arguments.\n");
	  } else {		/* argc == 6 */
	    /* get all hints from filesystemimage */
	    fsimage = FileSystemImage_Read(argv[4]);
	    if (PROGRAM_ErrorNo == E_NULL)
	      hintdb = Hint_CollectAllHints(fsimage);
	    if (PROGRAM_ErrorNo == E_NULL)
	      hintdb = HintDB_SetPathPrefix(hintdb, argv[5]);
	  }
	} else if (strcmp(argv[3], "-file") == 0) {
	  if (argc != 6) {
	    FatalError(E_USAGE,
		     "Error on command line: wrong number of arguments.\n");
	  } else {		/* argc == 6 */
	    /* get hints from filename */
	    fsimage = FileSystemImage_Build(argv[4]);
	    if (PROGRAM_ErrorNo == E_NULL)
	      hintdb = Hint_CollectAllHints(fsimage);
	    if (PROGRAM_ErrorNo == E_NULL)
	      hintdb = HintDB_SetPathPrefix(hintdb, argv[5]);
	  }
	} else {
	  FatalError(E_USAGE,
		     "Bad command line option %s\n", argv[3]);
	}
	/* set hint info in hintlocation */
	if (PROGRAM_ErrorNo == E_NULL) {
	  if (hintdb != NULL) {
	    for (hp = hintdb;
		 (PROGRAM_ErrorNo == E_NULL) && (*hp != NULL);
		 hp++)
	      (void) HintService_SetHint(*hp, hintlocation);
	  }
	}
      }
    } else if (strcmp(argv[1], "-unset") == 0) {
      if (argc != 4) {
	FatalError(E_USAGE,
		   "Error on command line: wrong number of arguments.\n");
      } else {			/* argc == 4 */
	/* unset related hints at location */
	hintlocation = argv[2];
	path = argv[3];
	(void) HintService_UnsetRelatedHints(path, hintlocation);
      }
    } else if (strcmp(argv[1], "-get") == 0) {
      if (argc != 4) {
	FatalError(E_USAGE,
		   "Error on command line: wrong number of arguments.\n");
      } else {			/* argc == 4 */
	hintlocation = argv[2];
	path = argv[3];
	hintp = HintService_GetHint(path, hintlocation);
	if (hintp == NULL) {
	  fprintf(out, "No hints for %s at location %s\n",
		  path, hintlocation);
	} else {
	  if (PROGRAM_ErrorNo == E_NULL)
	    hintdb = HintDB_InsertHint(NULL /* hintdb */ ,
				       hintp, FALSE /* OverWrite */ );
	  if (PROGRAM_ErrorNo == E_NULL)
	    (void) HintDB_Write(out, hintdb);
	}
      }
    } else if (strcmp(argv[1], "-getall") == 0) {
      if (argc != 4) {
	FatalError(E_USAGE,
		   "Error on command line: wrong number of arguments.\n");
      } else {			/* argc == 4 */
	hintlocation = argv[2];
	path = argv[3];
	hintdb = HintService_GetRelatedHints(path, hintlocation);
	if (PROGRAM_ErrorNo == E_NULL) {
	  if (hintdb == NULL) {
	    fprintf(out, "No hints for %s at location %s\n",
		    path, hintlocation);
	  } else
	    (void) HintDB_Write(out, hintdb);
	}
      }
    } else if (strcmp(argv[1], "-help") == 0)
      Usage(stdout);
    else {
      FatalError(E_USAGE,
		 "Bad command line option %s\n", argv[1]);
    }
  }

  if (PROGRAM_ErrorNo == E_USAGE)
    Usage(stderr);

  exit(PROGRAM_ErrorNo);
}



/*
 * $Log: hintservice.c,v $
 * Revision 1.5  1995/05/11  13:45:53  ww0r
 * ran gindent
 *
 * Revision 1.4  1994/05/24  18:36:27  ww0r
 * add more version info when usage is called
 *
 * Revision 1.3  1994/04/07  15:21:41  ww0r
 * - header consolidation into depotlib.h
 * - use installed headers
 *
 * Revision 1.2  1993/09/03  19:01:27  sohan
 * Provided for file system images having "/" for the top level node
 *
 * Revision 1.1  1993/06/30  16:48:07  sohan
 * Initial revision
 *
 *
 */
