.\"
.\" $Header: /afs/andrew/system/src/local/depot2/009/RCS/PREFERENCEDB.man,v 1.1 1993/09/20 21:22:02 sohan Exp $
.\" $Source: /afs/andrew/system/src/local/depot2/009/RCS/PREFERENCEDB.man,v $
.\"
.\"/***********************************************************
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"******************************************************************/
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH PREFERENCEDB 7
.SH Name
PREFERENCE, PREFERENCEDB - preferences database and its elements
.SH Description
The
.PN PREFERENCEDB
structure is used to represent the preferences database, whose elements are
.PN PREFERENCE
structures.
The components of
.PN PREFERENCE
are:
.nf
typedef struct Preference
{
	int optionid;
	u_short type;
	char *operand;
	union
	  {
	    int ival;
	    unsigned uval;
	    Boolean boolval;
	    char *strval;
	    STRINGARRAY *strarrval;
	  } value;
} PREFERENCE;

typedef PREFERENCE ***PREFERENCEDB;

#define PREFERENCE_OptionID(pp) ((pp)->optionid)
#define PREFERENCE_Type(pp) ((pp)->type)
#define PREFERENCE_Operand(pp) ((pp)->operand)
#define PREFERENCE_IVal(pp) ((pp)->value.ival)
#define PREFERENCE_UVal(pp) ((pp)->value.uval)
#define PREFERENCE_BoolVal(pp) ((pp)->value.boolval)
#define PREFERENCE_StrVal(pp) ((pp)->value.strval)
#define PREFERENCE_StrArrVal(pp) ((pp)->value.strarrval)
#define PREFERENCE_StrSetVal(pp) ((pp)->value.strarrval)
#define PREFERENCE_SentenceVal(pp) ((pp)->value.strarrval)
.fi

.SH Author
Sohan C. Ramakrishna-Pillai
.SH See Also
depot.pref(5)
