.\"
.\" $Header: /afs/andrew/system/src/local/depot2/009/RCS/DEPOTCONFDB.man,v 1.1 1993/09/20 21:21:59 sohan Exp $
.\" $Source: /afs/andrew/system/src/local/depot2/009/RCS/DEPOTCONFDB.man,v $
.\"
.\"/***********************************************************
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"******************************************************************/
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH DEPOTCONFDB 7
.SH Name
DEPOTCONFDB, DEPOTCONF - depot.conf database and its elements
.SH Description
The
.PN DEPOTCONFDB
structure is used to represent the depot.conf database, whose elements are
.PN DEPOTCONF
structures.
The components of
.PN DEPOTCONF
are:
.nf
typedef struct DepotConf
{
	char *collection_name;
	u_short spec;
	STRINGARRAY *confvalues;
} DEPOTCONF;

typedef DEPOTCONF **DEPOTCONFDB;


#define DEPOTCONF_CollectionName(dcp) ((dcp)->collection_name)
#define DEPOTCONF_Spec(dcp) ((dcp)->spec)
#define DEPOTCONF_ConfValue(dcp) ((dcp)->confvalues)

#define DEPOTCONFDB_Info(dbp) ((dbp)->info)
#define DEPOTCONFDB_Next(dbp) ((dbp)->next)
.fi

.SH Author
Sohan C. Ramakrishna-Pillai
.SH See Also
depot.conf(5)
