.\"
.\" $Header: /afs/andrew/system/src/local/depot2/009/RCS/Depot.man,v 1.1 1993/09/20 21:22:37 sohan Exp $
.\" $Source: /afs/andrew/system/src/local/depot2/009/RCS/Depot.man,v $
.\"
.\"/***********************************************************
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"******************************************************************/
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH Depot 3
.SH Name
Depot - perform depot operation on a target directory
.SH Syntax
.nf
.B #include <compress.h>
.B #include <util.h>
.B #include <Error.h>
.B #include <Lock.h>
.B #include <Depot.h>
.PP
.B int Depot (\fITargetPath, UpdateMode, LockAction, CollectionList\fP)
.br
.B char *\fITargetPath\fP;
.B unsigned \fIUpdateMode\fP;
.B unsigned \fILockAction\fP;
.B STRINGSET *\fICollectionList\fP;
.fi
.SH Description
The
.PN Depot
routine performs the depot operations specified by flags in
\fIUpdateMode\fP and \fILockAction\fP upon the directory specified in
\fITargetPath\fP.
.SH Arguments
.IP \fITargetPath\fR 15
is the address of a string of ASCII characters representing a path name,
terminated by a null character.  The path name identifies the target directory
upon which the depot operations are to be performed.
.IP \fIUpdateMode\fP
defines the depot operations to be performed on the
target directory. This argument is formed by ORing a combination of
the following values:
.RS
.IP M_LOCKONLY 1.25i
Perform lock-related operations only, ignoring all other update requests.
.IP M_SHOWACTIONSONLY 1.25i
Show update actions without actually performing the action.
.IP M_BUILD 1.25i
Build the target directory from scratch.
.IP M_DELETE 1.25i
Delete the specified collections.
.IP M_REPAIR 1.25i
Repair the target directory to fix any potentail corruption since the last run.
.IP M_VERBOSE 1.25i
Verbose mode, show update actions.
.IP M_UPDATEALLCOLLECTIONS 1.25i
Update all collections which may be found on the target directory's searchpath.
.IP M_LISTEDCOLLECTIONSONLY 1.25i
Use only collections explicitly specified in \fICollectionList\fP.
.IP M_IMPLICITLOCKINGALLOWED 1.25i
Explicit locking not required by owner of lock.
.RE
.IP \fILockAction\fP
is used only when the M_LOCKACTIONSONLY flag of \fIUpdateMode\fP is set.
It defines the kind of lock-related operation to be performed on the
target directory. This argument is formed by ORing a valid combination of
the following values:
.RS
.IP L_LOCK 1.25i
Lock the target directory.
.IP L_UNLOCK 1.25i
Unlock the target directory.
.IP L_PICKLOCK 1.25i
Pick the lock, forcing the locking operation even if locked by somebody else.
.IP L_QUERYLOCK 1.25i
Query for the owner of the lock.
.RE
.IP \fICollectionList\fP
is a
.MS STRINGSET 7
listing the names of collections to be used by depot while
performing the requested depot operation upon the target directory.
.SH Return Values
Upon successful completion, a value of 0 is returned. If any error occurs,
the global variable PROGRAM_ErrorNo is set and its value is returned.
.SH See Also
depot(1)
.SH Author
Sohan C. Ramakrishna-Pillai
