/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;
import java.math.BigInteger;

public class BigIntegerBinding
extends TupleBinding<BigInteger> {
    @Override
    public BigInteger entryToObject(TupleInput tupleInput) {
        return tupleInput.readBigInteger();
    }

    @Override
    public void objectToEntry(BigInteger bigInteger, TupleOutput tupleOutput) {
        tupleOutput.writeBigInteger(bigInteger);
    }

    @Override
    protected TupleOutput getTupleOutput(BigInteger bigInteger) {
        return BigIntegerBinding.sizedOutput(bigInteger);
    }

    public static BigInteger entryToBigInteger(SDatabaseEntry sDatabaseEntry) {
        return BigIntegerBinding.entryToInput(sDatabaseEntry).readBigInteger();
    }

    public static void bigIntegerToEntry(BigInteger bigInteger, SDatabaseEntry sDatabaseEntry) {
        BigIntegerBinding.outputToEntry(BigIntegerBinding.sizedOutput(bigInteger).writeBigInteger(bigInteger), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput(BigInteger bigInteger) {
        int n = TupleOutput.getBigIntegerByteLength(bigInteger);
        return new TupleOutput(new byte[n]);
    }
}

