#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/*
 *	Shell-level interface to daemon(3)
 *
 *	Copyright Steven M. Bellovin, smb@cs.columbia.edu, 2009
 *	This program is licensed under a Creative Commons Attribution
 *	License: http://creativecommons.org/licenses/by/3.0/us/
 *	You are free to "copy, distribute, display, and perform the work" or
 *	to "make derivative works".
 *
 *	I do, however, request that any derivatives of this (trivial)
 *	routine be kept *simple*.  There are plenty of complicated
 *	ways to do this; the universe does not need another one...
 *
 */

static void
usage(const char *prog)
{
	(void) fprintf(stderr, "Usage: %s: [-c] [-f] [-h] command [args]\n", prog);
}

int
main(int argc, char *argv[])
{
	int	nochdir;
	int	noclose;
	int	i;

	nochdir = 0;
	noclose = 0;
	while ((i = getopt(argc, argv, "cfh")) != -1) {
		switch(i) {
		case 'c':
			nochdir = 1;
			break;
		case 'f':
			noclose = 1;
			break;
		case 'h':
			usage(*argv);
			exit(EXIT_SUCCESS);
		default:
			usage(*argv);
			exit(EXIT_FAILURE);
		}
	}
	if (optind == argc) {
		usage(*argv);
		return 2;
	}
	if (daemon(nochdir, noclose) != 0) {
		perror("daemon");
		return 3;
	}
	execvp(argv[optind], &argv[optind]);
	perror("exec");
	return 4;
}
