/*
Copyright 2023, dettus@dettus.net

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#ifndef	DATASTRUCTURES_H
#define	DATASTRUCTURES_H

// different decoders and audio drivers use different ways of denoting this info.
// so i am creating my own
typedef enum
{
	eAUDIO_ENCODING_NONE=0,
	eAUDIO_ENCODING_S16LE
} eAudioEncoding;


typedef struct _tAudioFormat
{
	int channels;
	int rate;
	eAudioEncoding encoding;
} tAudioFormat;


typedef struct _tPcmSink
{
	unsigned char *pAudioData;
	int audio_bytes_num;
	tAudioFormat audioFormat;
} tPcmSink;

typedef struct _tSongInfo
{
	char filename[1024];
	char songinfo[256];
	int len;
	int pos;
	int channels;
	int samplerate;
	int bitrate;
} tSongInfo;

typedef struct _tArguments
{
	int argc;
	char** argv;
} tArguments;

typedef enum
{
	eONOFF_OFF=0,
	eONOFF_ON
} eOnOff;

typedef enum
{
	ePRESSED_NONE=0,
// pressable elements in the main window
	ePRESSED_WINDOW_MAIN_CLUTTERBAR_O,
	ePRESSED_WINDOW_MAIN_CLUTTERBAR_A,
	ePRESSED_WINDOW_MAIN_CLUTTERBAR_I,
	ePRESSED_WINDOW_MAIN_CLUTTERBAR_D,
	ePRESSED_WINDOW_MAIN_CLUTTERBAR_V,
	ePRESSED_WINDOW_MAIN_EQUALIZER,
	ePRESSED_WINDOW_MAIN_PLAYLIST,
	ePRESSED_WINDOW_MAIN_PREV,
	ePRESSED_WINDOW_MAIN_PLAY,
	ePRESSED_WINDOW_MAIN_PAUSE,
	ePRESSED_WINDOW_MAIN_STOP,
	ePRESSED_WINDOW_MAIN_NEXT,
	ePRESSED_WINDOW_MAIN_OPEN,
	ePRESSED_WINDOW_MAIN_SHUFFLE,
	ePRESSED_WINDOW_MAIN_REPEAT,
	ePRESSED_WINDOW_MAIN_VOLUME,
	ePRESSED_WINDOW_MAIN_BALANCE,
	ePRESSED_WINDOW_MAIN_SONGPOS,
	ePRESSED_WINDOW_MAIN_NUMBERS,
	ePRESSED_WINDOW_MAIN_MENU,
	ePRESSED_WINDOW_MAIN_MINIMIZE,
	ePRESSED_WINDOW_MAIN_WINDOWSHADE,
	ePRESSED_WINDOW_MAIN_EXIT,



	ePRESSED_WINDOW_EQUALIZER_ONOFF,
	ePRESSED_WINDOW_EQUALIZER_AUTO,
	ePRESSED_WINDOW_EQUALIZER_PRESET,
	ePRESSED_WINDOW_EQUALIZER_20DB_RESET,
	ePRESSED_WINDOW_EQUALIZER_0DB_RESET,
	ePRESSED_WINDOW_EQUALIZER_M20DB_RESET,
	ePRESSED_WINDOW_EQUALIZER_PREAMP,
	ePRESSED_WINDOW_EQUALIZER_60HZ,
	ePRESSED_WINDOW_EQUALIZER_170HZ,
	ePRESSED_WINDOW_EQUALIZER_310HZ,
	ePRESSED_WINDOW_EQUALIZER_600HZ,
	ePRESSED_WINDOW_EQUALIZER_1KHZ,
	ePRESSED_WINDOW_EQUALIZER_3KHZ,
	ePRESSED_WINDOW_EQUALIZER_6KHZ,
	ePRESSED_WINDOW_EQUALIZER_12KHZ,
	ePRESSED_WINDOW_EQUALIZER_14KHZ,
	ePRESSED_WINDOW_EQUALIZER_16KHZ,
	ePRESSED_WINDOW_EQUALIZER_SHADE,
	ePRESSED_WINDOW_EQUALIZER_CLOSE,

	ePRESSED_WINDOW_PLAYLIST_ADD,
	ePRESSED_WINDOW_PLAYLIST_REMOVE,
	ePRESSED_WINDOW_PLAYLIST_SELECTION,
	ePRESSED_WINDOW_PLAYLIST_MISCELLANEOUS,
	ePRESSED_WINDOW_PLAYLIST_LIST,
	ePRESSED_WINDOW_PLAYLIST_RESIZE,

	ePRESSED_WINDOW_PLAYLIST_ADD_FILE,
	ePRESSED_WINDOW_PLAYLIST_ADD_DIR,
	ePRESSED_WINDOW_PLAYLIST_ADD_URL,

	ePRESSED_WINDOW_PLAYLIST_MISC_REMOVE_BUTTON,
	ePRESSED_WINDOW_PLAYLIST_CROP_BUTTON,
	ePRESSED_WINDOW_PLAYLIST_REMOVE_FILE,
	ePRESSED_WINDOW_PLAYLIST_REMOVE_ALL,

	ePRESSED_WINDOW_PLAYLIST_INVERT_SELECTION,
	ePRESSED_WINDOW_PLAYLIST_SELECT_NONE,
	ePRESSED_WINDOW_PLAYLIST_SELECT_ALL,

	ePRESSED_WINDOW_PLAYLIST_SORT_LIST,
	ePRESSED_WINDOW_PLAYLIST_FILE_INFO,
	ePRESSED_WINDOW_PLAYLIST_MISC_OPTIONS,
	
	ePRESSED_WINDOW_PLAYLIST_NEW_LIST,
	ePRESSED_WINDOW_PLAYLIST_SAVE_LIST,
	ePRESSED_WINDOW_PLAYLIST_LOAD_LIST,

	ePRESSED_WINDOW_PLAYLIST_PREVIOUS,
	ePRESSED_WINDOW_PLAYLIST_PLAY,
	ePRESSED_WINDOW_PLAYLIST_PAUSE,
	ePRESSED_WINDOW_PLAYLIST_STOP,
	ePRESSED_WINDOW_PLAYLIST_NEXT,
	ePRESSED_WINDOW_PLAYLIST_OPEN,
	ePRESSED_WINDOW_PLAYLIST_PAGEUP,
	ePRESSED_WINDOW_PLAYLIST_PAGEDOWN,

	ePRESSED_WINDOW_PLAYLIST_MAIN,
	ePRESSED_WINDOW_PLAYLIST_SCROLLBAR,
	ePRESSED_WINDOW_PLAYLIST_CLOSE,


	ePRESSED_EXTRA_VOLUME_UP,
	ePRESSED_EXTRA_VOLUME_DOWN,
	ePRESSED_EXTRA_BALANCE_LEFT,
	ePRESSED_EXTRA_BALANCE_RIGHT
} ePressable;

typedef struct _tPressableBoundingBox
{
	ePressable pressable;
	int posx;
	int posy;
	int dimx;
	int dimy;
} tPressableBoundingBox;


#define	RETVAL_DONE		0xffff
#define	RETVAL_OK_CONTINUE	1
#define	RETVAL_OK		0
#define	RETVAL_NOK		-1
#define	RETVAL_NOK_COMMANDLINE	-2
#define	RETVAL_NOK_INVALID_PTR	-3
#define	RETVAL_NOK_FILENOTFOUND	-4


// data type for the callback functions
typedef int (*cbPrefPopulate)(void *userdata);
typedef int (*cbPrefApply)(void *userdata);

#endif
