/*

Copyright 2023, dettus@dettus.net

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*/
#include "theme_elements.h"
// the information in this file was taken from the "Winamp 2.X skinnig tutorial" Version 1.5.0, copyright by Fyre

const tSources cSources[SOURCES_NUM]=
{
	{.filename="AVS.BMP",     .width= 97,.height=188,.sourceid=AVS_BMP     },
	{.filename="BALANCE.BMP", .width= 68,.height=433,.sourceid=BALANCE_BMP },
	{.filename="CBUTTONS.BMP",.width=136,.height= 36,.sourceid=CBUTTONS_BMP},
	{.filename="EQ_EX.BMP",   .width=275,.height= 82,.sourceid=EQ_EX_BMP   },
	{.filename="EQMAIN.BMP",  .width=275,.height=315,.sourceid=EQMAIN_BMP  },
	{.filename="MAIN.BMP",    .width=275,.height=116,.sourceid=MAIN_BMP    },
	{.filename="MB.BMP",      .width=234,.height=119,.sourceid=MB_BMP      },
	{.filename="MONOSTER.BMP",.width= 58,.height= 24,.sourceid=MONOSTER_BMP},
	{.filename="NUMBERS.BMP", .width= 99,.height= 13,.sourceid=NUMBERS_BMP },
	{.filename="PLAYPAUS.BMP",.width= 42,.height=  9,.sourceid=PLAYPAUS_BMP},
	{.filename="PLEDIT.BMP",  .width=280,.height=186,.sourceid=PLEDIT_BMP  },
	{.filename="POSBAR.BMP",  .width=307,.height= 10,.sourceid=POSBAR_BMP  },
	{.filename="SHUFREP.BMP", .width= 92,.height= 85,.sourceid=SHUFREP_BMP },
	{.filename="TEXT.BMP",    .width=155,.height= 74,.sourceid=TEXT_BMP    },
	{.filename="TITLEBAR.BMP",.width=344,.height= 87,.sourceid=TITLEBAR_BMP},
	{.filename="VOLUME.BMP",  .width= 68,.height=433,.sourceid=VOLUME_BMP  }
};


const tElementSource cElementSources[ELEMENTS_NUM]={
// from avs.bmp
	{.sourcefile=AVS_BMP,	.startx= 0,.starty= 0,.dimx=  9,.dimy=  9,.id=AVS_CLOSE_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=AVS_BMP,	.startx=15,.starty= 0,.dimx= 50,.dimy= 15,.id=AVS_UPPER_LEFT_CORNER	,.destx= -1,.desty= -1},
	{.sourcefile=AVS_BMP,	.startx=66,.starty=15,.dimx= 14,.dimy= 15,.id=AVS_TOP_FILLER		,.destx= -1,.desty= -1},
	{.sourcefile=AVS_BMP,	.startx=81,.starty= 0,.dimx= 16,.dimy= 15,.id=AVS_UPPER_RIGHT_CORNER	,.destx= -1,.desty= -1},
	{.sourcefile=AVS_BMP,	.startx= 0,.starty=16,.dimx=  7,.dimy=172,.id=AVS_LEFT_FILLER		,.destx= -1,.desty= -1},
	{.sourcefile=AVS_BMP,	.startx= 8,.starty=16,.dimx=  6,.dimy=172,.id=AVS_RIGHT_FILLER		,.destx= -1,.desty= -1},
	{.sourcefile=AVS_BMP,	.startx=15,.starty=16,.dimx= 50,.dimy=  5,.id=AVS_LOWER_LEFT_CORNER	,.destx= -1,.desty= -1},
	{.sourcefile=AVS_BMP,	.startx=66,.starty=16,.dimx= 14,.dimy=  5,.id=AVS_BOTTOM_FILLER		,.destx= -1,.desty= -1},
	{.sourcefile=AVS_BMP,	.startx=81,.starty=16,.dimx= 16,.dimy=  5,.id=AVS_LOWER_RIGHT_CORNER	,.destx= -1,.desty= -1},

// from balance.bmp
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=  0,.dimx= 38,.dimy= 13,.id=BALANCE_CENTERED		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty= 15,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER0		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty= 30,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER1		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty= 45,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER2		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty= 60,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER3		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty= 75,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER4		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty= 90,.dimx= 38,.dimy= 13,.id=BALANCE_24LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=105,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER5		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=120,.dimx= 38,.dimy= 13,.id=BALANCE_33LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=135,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER6		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=150,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER7		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=165,.dimx= 38,.dimy= 13,.id=BALANCE_40LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=180,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER8		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=195,.dimx= 38,.dimy= 13,.id=BALANCE_49LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=210,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER9		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=225,.dimx= 38,.dimy= 13,.id=BALANCE_58LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=240,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER10		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=255,.dimx= 38,.dimy= 13,.id=BALANCE_66LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=270,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER11		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=285,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER12		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=300,.dimx= 38,.dimy= 13,.id=BALANCE_74LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=315,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER13		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=330,.dimx= 38,.dimy= 13,.id=BALANCE_82LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=345,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER14		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=360,.dimx= 38,.dimy= 13,.id=BALANCE_91LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=375,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER15		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=390,.dimx= 38,.dimy= 13,.id=BALANCE_FILLER16		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  9,.starty=405,.dimx= 38,.dimy= 13,.id=BALANCE_100LEFTORRIGHT		,.destx=177,.desty= 57},
	{.sourcefile=BALANCE_BMP,.startx=  0,.starty=422,.dimx= 14,.dimy= 11,.id=BALANCE_SLIDER_PRESSED		,.destx= -1,.desty= 58},
	{.sourcefile=BALANCE_BMP,.startx= 15,.starty=422,.dimx= 14,.dimy= 11,.id=BALANCE_SLIDER_UNPRESSED	,.destx= -1,.desty= 58},

// from cbuttons.bmp
	{.sourcefile=CBUTTONS_BMP,.startx=  0,.starty=  0,.dimx= 23,.dimy= 18,.id=CBUTTONS_PREV_BUTTON_UNPRESSED,.destx= 16,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx= 23,.starty=  0,.dimx= 23,.dimy= 18,.id=CBUTTONS_PLAY_BUTTON_UNPRESSED,.destx= 39,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx= 46,.starty=  0,.dimx= 23,.dimy= 18,.id=CBUTTONS_PAUSE_BUTTON_UNPRESSED,.destx=62,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx= 69,.starty=  0,.dimx= 23,.dimy= 18,.id=CBUTTONS_STOP_BUTTON_UNPRESSED,.destx= 85,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx= 92,.starty=  0,.dimx= 22,.dimy= 18,.id=CBUTTONS_NEXT_BUTTON_UNPRESSED,.destx=108,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx=114,.starty=  0,.dimx= 22,.dimy= 16,.id=CBUTTONS_OPEN_BUTTON_UNPRESSED,.destx=136,.desty= 89},
	{.sourcefile=CBUTTONS_BMP,.startx=  0,.starty= 18,.dimx= 23,.dimy= 18,.id=CBUTTONS_PREV_BUTTON_PRESSED	,.destx= 16,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx= 23,.starty= 18,.dimx= 23,.dimy= 18,.id=CBUTTONS_PLAY_BUTTON_PRESSED	,.destx= 39,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx= 46,.starty= 18,.dimx= 23,.dimy= 18,.id=CBUTTONS_PAUSE_BUTTON_PRESSED	,.destx= 62,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx= 69,.starty= 18,.dimx= 23,.dimy= 18,.id=CBUTTONS_STOP_BUTTON_PRESSED	,.destx= 85,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx= 92,.starty= 18,.dimx= 22,.dimy= 18,.id=CBUTTONS_NEXT_BUTTON_PRESSED	,.destx=108,.desty= 88},
	{.sourcefile=CBUTTONS_BMP,.startx=114,.starty= 16,.dimx= 22,.dimy= 16,.id=CBUTTONS_OPEN_BUTTON_PRESSED	,.destx=136,.desty= 89},

// from eq_ex.bmp	
	{.sourcefile=EQ_EX_BMP,   .startx=  0,.starty=  0,.dimx=275,.dimy= 14,.id=EQEX_EQUALIZER_WINDOWSHADE_ACTIVE	,.destx=  0,.desty=  0},
	{.sourcefile=EQ_EX_BMP,   .startx= 61,.starty=  4,.dimx= 97,.dimy=  7,.id=EQEX_VOLUMECONTROL_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx=164,.starty=  4,.dimx= 42,.dimy=  7,.id=EQEX_BALANCECONTROL_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx=  0,.starty= 15,.dimx=275,.dimy= 14,.id=EQEX_EQUALIZER_WINDOWSHADE_INACTIVE	,.destx=  0,.desty=  0},
	{.sourcefile=EQ_EX_BMP,   .startx= 61,.starty= 19,.dimx= 97,.dimy=  7,.id=EQEX_VOLUMECONTROL_INACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx=164,.starty= 19,.dimx= 42,.dimy=  7,.id=EQEX_BALANCECONTROL_INACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx=  1,.starty= 30,.dimx=  3,.dimy=  7,.id=EQEX_VOLUMESLIDER_LOW		,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx=  4,.starty= 30,.dimx=  3,.dimy=  7,.id=EQEX_VOLUMESLIDER_MEDIUM	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx=  7,.starty= 30,.dimx=  3,.dimy=  7,.id=EQEX_VOLUMESLIDER_HIGH	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx= 11,.starty= 30,.dimx=  3,.dimy=  7,.id=EQEX_BALANCESLIDER_LEFT	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx= 14,.starty= 30,.dimx=  3,.dimy=  7,.id=EQEX_BALANCESLIDER_MIDDLE	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx= 17,.starty= 30,.dimx=  3,.dimy=  7,.id=EQEX_BALANCESLIDER_RIGHT	,.destx= -1,.desty= -1},
	{.sourcefile=EQ_EX_BMP,   .startx=  1,.starty= 38,.dimx=  9,.dimy=  9,.id=EQEX_WINDOWSHADE_BUTTON_PRESSED	,.destx=263,.desty=  4},
	{.sourcefile=EQ_EX_BMP,   .startx= 11,.starty= 38,.dimx=  9,.dimy=  9,.id=EQEX_CLOSEBUTTON_UNPRESSED	,.destx=263,.desty=  4},
	{.sourcefile=EQ_EX_BMP,   .startx=  1,.starty= 47,.dimx=  9,.dimy=  9,.id=EQEX_MAXIMIZEBUTTON_PRESSED	,.destx=254,.desty=  3},
	{.sourcefile=EQ_EX_BMP,   .startx= 11,.starty= 47,.dimx=  9,.dimy=  9,.id=EQEX_CLOSEBUTTON_PRESSED	,.destx=-11,.desty=  3},

// from eqmain.bmp
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=  0,.dimx=275,.dimy= 14,.id=EQMAIN_EQUALIZER_TITLEBAR	,.destx=  0,.desty=  0},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty= 14,.dimx=275,.dimy=102,.id=EQMAIN_EQUALIZER_MAIN_DISPLAY	,.destx=  0,.desty= 14},
	{.sourcefile=EQMAIN_BMP,  .startx= 86,.starty= 16,.dimx=113,.dimy= 20,.id=EQMAIN_EQUALIZER_MINIDISPLAY	,.destx= 86,.desty= 16},
	{.sourcefile=EQMAIN_BMP,  .startx= 14,.starty= 18,.dimx= 25,.dimy= 12,.id=EQMAIN_EQUALIZER_ON		,.destx= 14,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx= 39,.starty= 18,.dimx= 33,.dimy= 12,.id=EQMAIN_AUTOMATIC_EQUALIZATION	,.destx= 39,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx=217,.starty= 18,.dimx= 44,.dimy= 12,.id=EQMAIN_OPEN_PRESET_MENU	,.destx=217,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx= 42,.starty= 33,.dimx= 26,.dimy= 20,.id=EQMAIN_20DB_RESET		,.destx= 42,.desty= 33},
	{.sourcefile=EQMAIN_BMP,  .startx= 21,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_PREAMP_BAR		,.destx= 21,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx= 78,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_60HZ_BAR		,.destx= 78,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx= 96,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_170HZ_BAR		,.destx= 96,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=114,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_310HZ_BAR		,.destx=114,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=132,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_600HZ_BAR		,.destx=132,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=150,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_1KHZ_BAR		,.destx=150,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=168,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_3KHZ_BAR		,.destx=168,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=186,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_6KHZ_BAR		,.destx=186,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=204,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_12KHZ_BAR		,.destx=204,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=222,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_14KHZ_BAR		,.destx=222,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=240,.starty= 38,.dimx= 14,.dimy= 63,.id=EQMAIN_16KHZ_BAR		,.destx=240,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx= 42,.starty= 65,.dimx= 26,.dimy= 20,.id=EQMAIN_0DB_RESET		,.destx= 42,.desty= 65},
	{.sourcefile=EQMAIN_BMP,  .startx= 42,.starty= 92,.dimx= 26,.dimy= 20,.id=EQMAIN_M20DB_RESET		,.destx= 42,.desty= 92},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=116,.dimx=  9,.dimy=  9,.id=EQMAIN_CLOSE_BUTTON_UNPRESSED	,.destx=-11,.desty= 3},	
	{.sourcefile=EQMAIN_BMP,  .startx= 10,.starty=119,.dimx= 25,.dimy= 12,.id=EQMAIN_EQUALIZER_OFF_UNPRESSED,.destx= 14,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx= 35,.starty=119,.dimx= 33,.dimy= 12,.id=EQMAIN_AUTO_OFF_UNPRESSED	,.destx= 39,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx= 69,.starty=119,.dimx= 25,.dimy= 12,.id=EQMAIN_EQUALIZER_ON_UNPRESSED	,.destx= 14,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx= 94,.starty=119,.dimx= 33,.dimy= 12,.id=EQMAIN_AUTO_ON_UNPRESSED	,.destx= 39,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx=128,.starty=119,.dimx= 25,.dimy= 12,.id=EQMAIN_EQUALIZER_OFF_PRESSED	,.destx= 14,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx=153,.starty=119,.dimx= 33,.dimy= 12,.id=EQMAIN_AUTO_OFF_PRESSED	,.destx= 39,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx=187,.starty=119,.dimx= 25,.dimy= 12,.id=EQMAIN_EQUALIZER_ON_PRESSED	,.destx= 14,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx=212,.starty=119,.dimx= 33,.dimy= 12,.id=EQMAIN_AUTO_ON_PRESSED	,.destx= 39,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=125,.dimx=  9,.dimy=  9,.id=EQMAIN_CLOSE_BUTTON_PRESSED		,.destx= -11,.desty=  3},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=134,.dimx=275,.dimy= 14,.id=EQMAIN_EQUALIZER_TITLEBAR_ACTIVE	,.destx=  0,.desty=  0},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=149,.dimx=275,.dimy= 14,.id=EQMAIN_EQUALIZER_TITLEBAR_INACTIVE	,.destx=  0,.desty=  0},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=164,.dimx= 11,.dimy= 11,.id=EQMAIN_EQUALIZER_SLIDER_UNPRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx= 13,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M2000DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx= 28,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M1875DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx= 43,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M1714DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx= 58,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M1571DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx= 73,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M1429DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx= 88,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M1286DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=103,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M1143DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=118,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M1000DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=133,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M0857DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=148,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M0714DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=163,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M0571DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=178,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M0428DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=193,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M0285DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=208,.starty=164,.dimx= 14,.dimy= 63,.id=EQMAIN_M0142DB_BAR		,.destx= -1,.desty= 38},
	{.sourcefile=EQMAIN_BMP,  .startx=224,.starty=164,.dimx= 44,.dimy= 12,.id=EQMAIN_PRESET_BUTTON_UNPRESSED,.destx=217,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=176,.dimx= 11,.dimy= 11,.id=EQMAIN_EQUALIZER_SLIDER_PRESSED,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=224,.starty=176,.dimx= 44,.dimy= 12,.id=EQMAIN_PRESET_BUTTON_PRESSED	,.destx=217,.desty= 18},
	{.sourcefile=EQMAIN_BMP,  .startx= 13,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P0142DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx= 28,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P0285DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx= 43,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P0428DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx= 58,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P0571DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx= 73,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P0714DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx= 88,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P0857DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=103,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P1000DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=118,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P1143DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=133,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P1286DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=148,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P1429DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=163,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P1571DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=178,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P1714DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=193,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P1857DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=208,.starty=229,.dimx= 14,.dimy= 63,.id=EQMAIN_P2000DB_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=293,.dimx=113,.dimy= 20,.id=EQMAIN_ACTUAL_EQUALIZER_MINIDISPLAY	,.destx= 86,.desty= 16},
	{.sourcefile=EQMAIN_BMP,  .startx=115,.starty=294,.dimx=  1,.dimy= 19,.id=EQMAIN_SPLINE_LINE		,.destx= -1,.desty= -1},
	{.sourcefile=EQMAIN_BMP,  .startx=  0,.starty=314,.dimx=113,.dimy=  1,.id=EQMAIN_PREAMP_LINE		,.destx= -1,.desty= -1},

// from main.bmp
	{.sourcefile=MAIN_BMP,    .startx=  0,.starty= 14,.dimx=275,.dimy=102,.id=MAIN_MAIN_DISPLAY		,.destx=  0,.desty= 14},
	{.sourcefile=MAIN_BMP,    .startx=111,.starty= 27,.dimx=154,.dimy=  6,.id=MAIN_SONG_INFO_DISPLAY	,.destx=111,.desty= 27},
	{.sourcefile=MAIN_BMP,    .startx=111,.starty= 43,.dimx= 15,.dimy=  6,.id=MAIN_KBPS_DISPLAY		,.destx=111,.desty= 43},
	{.sourcefile=MAIN_BMP,    .startx=156,.starty= 43,.dimx= 10,.dimy=  6,.id=MAIN_KHZ_DISPLAY		,.destx=156,.desty= 43},
	{.sourcefile=MAIN_BMP,    .startx= 24,.starty= 44,.dimx= 76,.dimy= 15,.id=MAIN_VISUALIZATION_WINDOW	,.destx= 24,.desty= 44},
	{.sourcefile=MAIN_BMP,    .startx=253,.starty= 91,.dimx= 13,.dimy= 15,.id=MAIN_INFO			,.destx=253,.desty= 91},

// from mb (minibrowser)
	{.sourcefile=MB_BMP,      .startx=  0,.starty=  0,.dimx= 25,.dimy= 20,.id=MB_UPPER_LEFT_CORNERPIECE_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx= 26,.starty=  0,.dimx=100,.dimy= 20,.id=MB_TITLEBAR_ACTIVE		,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=127,.starty=  0,.dimx= 25,.dimy= 20,.id=MB_TOP_FILLERS_ACTIVE		,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=153,.starty=  0,.dimx= 25,.dimy= 20,.id=MB_UPPER_RIGHT_CORNERPIECE_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=  0,.starty= 21,.dimx= 25,.dimy= 20,.id=MB_UPPER_LEFT_CORNERPIECE_INACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx= 26,.starty= 21,.dimx=100,.dimy= 20,.id=MB_TITLEBAR_INACTIVE		,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=127,.starty= 21,.dimx= 25,.dimy= 20,.id=MB_TOPFILLERS_INACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=153,.starty= 21,.dimx= 25,.dimy= 20,.id=MB_UPPER_RIGHT_CORNERPIECE_INACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=  0,.starty= 42,.dimx=125,.dimy= 38,.id=MB_BOTTOM_LEFT_CONTROLBAR	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=127,.starty= 42,.dimx= 11,.dimy= 29,.id=MB_LEFT_SIDE_FILLERS		,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=139,.starty= 42,.dimx=  8,.dimy= 29,.id=MB_RIGHT_SIDE_FILLERS		,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=148,.starty= 42,.dimx=  9,.dimy=  9,.id=MB_CLOSE_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=158,.starty= 42,.dimx= 15,.dimy= 18,.id=MB_BACK_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=173,.starty= 42,.dimx= 15,.dimy= 18,.id=MB_FORWARD_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=188,.starty= 42,.dimx= 15,.dimy= 18,.id=MB_STOP_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=203,.starty= 42,.dimx= 15,.dimy= 18,.id=MB_RELOAD_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=218,.starty= 42,.dimx= 15,.dimy= 18,.id=MB_OPTIONS_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=  9,.starty= 51,.dimx= 15,.dimy= 18,.id=MB_BACK_BUTTON_UNPRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx= 24,.starty= 51,.dimx= 15,.dimy= 18,.id=MB_FORWARD_BUTTON_UNPRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx= 39,.starty= 51,.dimx= 15,.dimy= 18,.id=MB_STOP_BUTTON_UNPRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx= 54,.starty= 51,.dimx= 15,.dimy= 18,.id=MB_RELOAD_BUTTON_UNPRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx= 69,.starty= 53,.dimx= 15,.dimy= 18,.id=MB_OPTIONS_BUTTON_UNPRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx= 92,.starty= 81,.dimx= 33,.dimy= 13,.id=MB_URL_DISPLAY_BAR_LEFT_END	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=  0,.starty= 81,.dimx=125,.dimy= 38,.id=MB_BOTTOM_RIGHT_CONTROL_BAR	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=127,.starty= 92,.dimx= 25,.dimy= 27,.id=MB_BOTTOM_FILLER		,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=  0,.starty= 92,.dimx=100,.dimy= 13,.id=MB_URL_DISPLAY_BAR_RIGHT_END	,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=127,.starty= 92,.dimx= 68,.dimy= 13,.id=MB_DISPLAY_BAR_FILLER		,.destx= -1,.desty= -1},
	{.sourcefile=MB_BMP,      .startx=107,.starty=102,.dimx= 18,.dimy= 17,.id=MB_RESIZE_CONTROL		,.destx= -1,.desty= -1},

// from monoster.bmp
	{.sourcefile=MONOSTER_BMP,.startx=  0,.starty=  0,.dimx= 29,.dimy= 12,.id=MONOSTER_STEREO_ACTIVE	,.destx=239,.desty= 41},
	{.sourcefile=MONOSTER_BMP,.startx= 29,.starty=  0,.dimx= 27,.dimy= 12,.id=MONOSTER_MONO_ACTIVE		,.destx=212,.desty= 41},
	{.sourcefile=MONOSTER_BMP,.startx=  0,.starty= 12,.dimx= 29,.dimy= 12,.id=MONOSTER_STEREO_INACTIVE	,.destx=239,.desty= 41},
	{.sourcefile=MONOSTER_BMP,.startx= 29,.starty= 12,.dimx= 27,.dimy= 12,.id=MONOSTER_MONO_INACTIVE	,.destx=212,.desty= 41},

// from numbers.bmp
	{.sourcefile=NUMBERS_BMP, .startx=  0,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_0			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx=  9,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_1			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 18,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_2			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 27,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_3			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 36,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_4			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 45,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_5			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 54,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_6			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 63,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_7			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 72,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_8			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 81,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_9			,.destx= -1,.desty= 26},
	{.sourcefile=NUMBERS_BMP, .startx= 90,.starty=  0,.dimx=  9,.dimy= 13,.id=NUMBERS_BLANK			,.destx= -1,.desty= 26},

// from playpause.bmp
	{.sourcefile=PLAYPAUS_BMP,.startx=  1,.starty=  0,.dimx=  8,.dimy=  9,.id=PLAYPAUSE_PLAY_INDICATOR	,.destx= 24,.desty= 18},
	{.sourcefile=PLAYPAUS_BMP,.startx=  9,.starty=  0,.dimx=  9,.dimy=  9,.id=PLAYPAUSE_PAUSE_INDICATOR	,.destx= 24,.desty= 18},
	{.sourcefile=PLAYPAUS_BMP,.startx= 18,.starty=  0,.dimx=  9,.dimy=  9,.id=PLAYPAUSE_STOP_INDICATOR	,.destx= 24,.desty= 18},
	{.sourcefile=PLAYPAUS_BMP,.startx= 27,.starty=  0,.dimx=  2,.dimy=  9,.id=PLAYPAUSE_FILLER		,.destx= 24,.desty= 18},
	{.sourcefile=PLAYPAUS_BMP,.startx= 36,.starty=  0,.dimx=  3,.dimy=  9,.id=PLAYPAUSE_START_OF_SONG_INDICATOR	,.destx= 24,.desty= 18},
	{.sourcefile=PLAYPAUS_BMP,.startx= 39,.starty=  0,.dimx=  3,.dimy=  9,.id=PLAYPAUSE_END_OF_SONG_INDICATOR,.destx= 24,.desty= 18},

// from pledit.bmp. all other windows had a gravity th the top left corner, this one has gravity to all sides.
	{.sourcefile=PLEDIT_BMP,  .startx=  0,.starty=  0,.dimx= 25,.dimy= 20,.id=PLEDIT_UPPER_LEFT_CORNERPIECE_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 26,.starty=  0,.dimx=100,.dimy= 20,.id=PLEDIT_PLAYLIST_TITLEBAR_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=127,.starty=  0,.dimx= 25,.dimy= 20,.id=PLEDIT_TOP_FILLERS_ACTIVE		,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=153,.starty=  0,.dimx= 25,.dimy= 20,.id=PLEDIT_UPPER_RIGHT_CORNERPIECE_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=179,.starty=  0,.dimx= 25,.dimy= 38,.id=PLEDIT_BOTTOM_FILLERS			,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=205,.starty=  0,.dimx= 75,.dimy= 38,.id=PLEDIT_VISUALIZATION_MINISCREEN	,.destx=-225,.desty=-38},
	{.sourcefile=PLEDIT_BMP,  .startx=  0,.starty= 21,.dimx= 25,.dimy= 20,.id=PLEDIT_UPPER_LEFT_CORNERPIECE_INACTIVE,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 26,.starty= 21,.dimx=100,.dimy= 20,.id=PLEDIT_PLAYLIST_TITLEBAR_INACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=127,.starty= 21,.dimx= 25,.dimy= 20,.id=PLEDIT_TOP_FILLERS_INACTIVE		,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=153,.starty= 21,.dimx= 25,.dimy= 20,.id=PLEDIT_UPPER_RIGHT_CORNERPIECE_INACTIVE,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=  0,.starty= 42,.dimx= 12,.dimy= 29,.id=PLEDIT_LEFT_SIDE_FILLERS		,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 31,.starty= 42,.dimx=  5,.dimy= 29,.id=PLEDIT_RIGHT_SIDE_FILLERS_LEFT_BAR	,.destx=-20,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 36,.starty= 42,.dimx=  8,.dimy= 29,.id=PLEDIT_RIGHT_SIDE_FILLERS_SCROLL_GROOVE,.destx=-15,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 44,.starty= 42,.dimx=  7,.dimy= 29,.id=PLEDIT_RIGHT_SIDE_FILLERS_RIGHT_BAR	,.destx= -7,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 52,.starty= 42,.dimx=  9,.dimy=  9,.id=PLEDIT_CLOSE_BUTTON_PRESSED		,.destx=-11,.desty=  3},
	{.sourcefile=PLEDIT_BMP,  .startx= 62,.starty= 42,.dimx=  9,.dimy=  9,.id=PLEDIT_WINDOWSHADE_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 72,.starty= 42,.dimx= 25,.dimy= 14,.id=PLEDIT_WINDOWSHADE_LEFT_END		,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 99,.starty= 42,.dimx= 50,.dimy= 14,.id=PLEDIT_WINDOWSHADE_RIGHT_END_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=150,.starty= 42,.dimx=  9,.dimy=  9,.id=PLEDIT_MAXIMIZE_BUTTON_PRESSED	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 52,.starty= 53,.dimx=  8,.dimy= 18,.id=PLEDIT_SCROLL_BUTTON_UNPRESSED	,.destx=-15,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 61,.starty= 53,.dimx=  8,.dimy= 18,.id=PLEDIT_SCROLL_BUTTON_PRESSED		,.destx=-15,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 72,.starty= 57,.dimx= 25,.dimy= 14,.id=PLEDIT_WINDOWSHADE_MIDDLE_FILLERS	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx= 99,.starty= 57,.dimx= 50,.dimy= 14,.id=PLEDIT_WINDOWSHADE_RIGHT_END_INACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=  0,.starty= 72,.dimx=125,.dimy= 38,.id=PLEDIT_BOTTOM_LEFT_CONTROL_BAR	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=126,.starty= 72,.dimx=150,.dimy= 38,.id=PLEDIT_BOTTOM_RIGHT_CONTROL_BAR	,.destx=-150,.desty=-38},
	{.sourcefile=PLEDIT_BMP,  .startx=261,.starty= 74,.dimx=  9,.dimy=  5,.id=PLEDIT_PAGE_UP_BUTTON			,.destx=-16,.desty=-36},
	{.sourcefile=PLEDIT_BMP,  .startx=261,.starty= 79,.dimx=  9,.dimy=  5,.id=PLEDIT_PAGE_DOWN_BUTTON		,.destx=-16,.desty=-31},
	{.sourcefile=PLEDIT_BMP,  .startx= 14,.starty= 80,.dimx= 22,.dimy= 18,.id=PLEDIT_ADD_BUTTON			,.destx= 14,.desty=-30},
	{.sourcefile=PLEDIT_BMP,  .startx= 43,.starty= 80,.dimx= 22,.dimy= 18,.id=PLEDIT_REMOVE_BUTTON			,.destx= 43,.desty=-30},
	{.sourcefile=PLEDIT_BMP,  .startx= 72,.starty= 80,.dimx= 22,.dimy= 18,.id=PLEDIT_SELECTION_BUTTON		,.destx= 72,.desty=-30},
	{.sourcefile=PLEDIT_BMP,  .startx=101,.starty= 80,.dimx= 22,.dimy= 18,.id=PLEDIT_MISCELLANEOUS_BUTTON		,.destx=101,.desty=-30},
	{.sourcefile=PLEDIT_BMP,  .startx=232,.starty= 80,.dimx= 22,.dimy= 18,.id=PLEDIT_LIST_BUTTON			,.destx=-44,.desty=-30},
	{.sourcefile=PLEDIT_BMP,  .startx=133,.starty= 82,.dimx= 90,.dimy=  6,.id=PLEDIT_TIME_STATUS_BUTTON		,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=257,.starty= 89,.dimx= 19,.dimy= 21,.id=PLEDIT_RESIZE_CONTROL			,.destx=-19,.desty=-23},
	{.sourcefile=PLEDIT_BMP,  .startx=132,.starty= 94,.dimx=  7,.dimy=  8,.id=PLEDIT_PREVIOUS_CONTROL		,.destx=-144,.desty=-16},
	{.sourcefile=PLEDIT_BMP,  .startx=140,.starty= 94,.dimx=  8,.dimy=  8,.id=PLEDIT_PLAY_CONTROL			,.destx=-136,.desty=-16},
	{.sourcefile=PLEDIT_BMP,  .startx=149,.starty= 94,.dimx=  9,.dimy=  8,.id=PLEDIT_PAUSE_CONTROL			,.destx=-127,.desty=-16},
	{.sourcefile=PLEDIT_BMP,  .startx=159,.starty= 94,.dimx=  9,.dimy=  8,.id=PLEDIT_STOP_CONTROL			,.destx=-117,.desty=-16},
	{.sourcefile=PLEDIT_BMP,  .startx=169,.starty= 94,.dimx=  7,.dimy=  8,.id=PLEDIT_NEXT_CONTROL			,.destx=-107,.desty=-16},
	{.sourcefile=PLEDIT_BMP,  .startx=177,.starty= 94,.dimx=  9,.dimy=  8,.id=PLEDIT_OPEN_CONTROL			,.destx=-99,.desty=-16},
	{.sourcefile=PLEDIT_BMP,  .startx=190,.starty= 95,.dimx= 19,.dimy=  6,.id=PLEDIT_CURRENT_TIME_DISPLAY_MINUTES	,.destx= -1,.desty= -1},
	{.sourcefile=PLEDIT_BMP,  .startx=212,.starty= 95,.dimx= 10,.dimy=  6,.id=PLEDIT_CURRENT_TIME_DISPLAY_SECONDS	,.destx= -1,.desty= -1},

	{.sourcefile=PLEDIT_BMP,  .startx=  0,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_ADD_URL_BUTTON_UNPRESSED	,.destx= 14,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 23,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_ADD_URL_BUTTON_PRESSED		,.destx= 14,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 48,.starty=111,.dimx=  3,.dimy= 54,.id=PLEDIT_DECORATION_BAR_ADD		,.destx= 11,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 54,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_REMOVE_ALL_BUTTON_UNPRESSED	,.destx= 43,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 77,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_REMOVE_ALL_BUTTON_PRESSED	,.destx= 43,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=100,.starty=111,.dimx=  3,.dimy= 72,.id=PLEDIT_DECORATION_BAR_REMOVE		,.destx= 40,.desty=-103+19},
	{.sourcefile=PLEDIT_BMP,  .startx=104,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_INVERT_SELECTION_BUTTON_UNPRESSED	,.destx= 72,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=127,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_INVERT_SELECTION_BUTTON_PRESSED,.destx= 72,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=150,.starty=111,.dimx=  3,.dimy= 54,.id=PLEDIT_DECORATION_BAR_SELECTION	,.destx= 69,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=154,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_SORT_LIST_BUTTON_UNPRESSED	,.destx=101,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=177,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_SORT_LIST_BUTTON_PRESSED	,.destx=101,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=200,.starty=111,.dimx=  3,.dimy= 54,.id=PLEDIT_DECORATION_BAR_MISC		,.destx= 98,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=204,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_NEW_LIST_BUTTON_UNPRESSED	,.destx=-44,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=227,.starty=111,.dimx= 22,.dimy= 18,.id=PLEDIT_NEW_LIST_BUTTON_PRESSED	,.destx=-44,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=250,.starty=111,.dimx=  3,.dimy= 54,.id=PLEDIT_DECORATION_BAR_LIST		,.destx=-47,.desty=-85+19},
	{.sourcefile=PLEDIT_BMP,  .startx=  0,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_ADD_DIR_BUTTON_UNPRESSED	,.destx= 14,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 23,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_ADD_DIR_BUTTON_PRESSED		,.destx= 14,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 54,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_CROP_BUTTON_UNPRESSED		,.destx= 43,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 77,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_CROP_BUTTON_PRESSED		,.destx= 43,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx=104,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_SELECT_NONE_BUTTON_UNPRESSED	,.destx= 72,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx=127,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_SELECT_NONE_BUTTON_PRESSED	,.destx= 72,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx=154,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_FILE_INFO_BUTTON_UNPRESSED	,.destx=101,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx=177,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_FILE_INFO_BUTTON_PRESSED	,.destx=101,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx=204,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_SAVE_LIST_BUTTON_UNPRESSED	,.destx=-44,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx=227,.starty=130,.dimx= 22,.dimy= 18,.id=PLEDIT_SAVE_LIST_BUTTON_PRESSED	,.destx=-44,.desty=-67+19},
	{.sourcefile=PLEDIT_BMP,  .startx=  0,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_ADD_FILE_BUTTON_UNPRESSED	,.destx= 14,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 23,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_ADD_FILE_BUTTON_PRESSED	,.destx= 14,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 54,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_REMOVE_FILE_BUTTON_UNPRESSED	,.destx= 43,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 77,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_REMOVE_FILE_BUTTON_PRESSED	,.destx= 43,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx=104,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_SELECT_ALL_BUTTON_UNPRESSED	,.destx= 72,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx=127,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_SELECT_ALL_BUTTON_PRESSED	,.destx= 72,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx=154,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_MISC_OPTIONS_BUTTON_UNPRESSED	,.destx=101,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx=177,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_MISC_OPTIONS_BUTTON_PRESSED	,.destx=101,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx=204,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_LOAD_LIST_BUTTON_UNPRESSED	,.destx=-44,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx=227,.starty=149,.dimx= 22,.dimy= 18,.id=PLEDIT_LOAD_LIST_BUTTON_PRESSED	,.destx=-44,.desty=-49+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 54,.starty=168,.dimx= 22,.dimy= 18,.id=PLEDIT_MISC_REMOVE_BUTTON_UNPRESSED	,.destx= 43,.desty=-103+19},
	{.sourcefile=PLEDIT_BMP,  .startx= 77,.starty=168,.dimx= 22,.dimy= 18,.id=PLEDIT_MISC_REMOVE_BUTTON_PRESSED	,.destx= 43,.desty=-103+19},

// from posbar.bmp
	{.sourcefile=POSBAR_BMP,  .startx=  0,.starty=  0,.dimx=248,.dimy= 10,.id=POSBAR_SONG_PROGRESS_BAR		,.destx= 16,.desty= 72},
	{.sourcefile=POSBAR_BMP,  .startx=248,.starty=  0,.dimx= 29,.dimy= 10,.id=POSBAR_SONG_SLIDER_UNPRESSED		,.destx= -1,.desty= 72},
	{.sourcefile=POSBAR_BMP,  .startx=278,.starty=  0,.dimx= 29,.dimy= 10,.id=POSBAR_SONG_SLIDER_PRESSED		,.destx= -1,.desty= 72},

// from shufrep.bmp
	{.sourcefile=SHUFREP_BMP, .startx=  0,.starty=  0,.dimx= 28,.dimy= 15,.id=SHUFREP_NO_REPEAT_UNPRESSED	,.destx=210,.desty= 89},
	{.sourcefile=SHUFREP_BMP, .startx= 28,.starty=  0,.dimx= 46,.dimy= 15,.id=SHUFREP_NO_SHUFFLE_UNPRESSED	,.destx=164,.desty= 89},
	{.sourcefile=SHUFREP_BMP, .startx=  0,.starty= 15,.dimx= 28,.dimy= 15,.id=SHUFREP_NO_REPEAT_PRESSED	,.destx=210,.desty= 89},
	{.sourcefile=SHUFREP_BMP, .startx= 28,.starty= 15,.dimx= 46,.dimy= 15,.id=SHUFREP_NO_SHUFFLE_PRESSED	,.destx=164,.desty= 89},
	{.sourcefile=SHUFREP_BMP, .startx=  0,.starty= 30,.dimx= 28,.dimy= 15,.id=SHUFREP_REPEAT_UNPRESSED	,.destx=210,.desty= 89},
	{.sourcefile=SHUFREP_BMP, .startx= 28,.starty= 30,.dimx= 46,.dimy= 15,.id=SHUFREP_SHUFFLE_UNPRESSED	,.destx=164,.desty= 89},
	{.sourcefile=SHUFREP_BMP, .startx=  0,.starty= 45,.dimx= 28,.dimy= 15,.id=SHUFREP_REPEAT_PRESSED	,.destx=210,.desty= 89},
	{.sourcefile=SHUFREP_BMP, .startx= 28,.starty= 45,.dimx= 46,.dimy= 15,.id=SHUFREP_SHUFFLE_PRESSED	,.destx=164,.desty= 89},
	{.sourcefile=SHUFREP_BMP, .startx=  0,.starty= 61,.dimx= 23,.dimy= 12,.id=SHUFREP_NO_EQUALIZER_UNPRESSED,.destx=219,.desty= 58},
	{.sourcefile=SHUFREP_BMP, .startx= 23,.starty= 61,.dimx= 23,.dimy= 12,.id=SHUFREP_NO_PLAYLIST_UNPRESSED	,.destx=242,.desty= 58},
	{.sourcefile=SHUFREP_BMP, .startx= 46,.starty= 61,.dimx= 23,.dimy= 12,.id=SHUFREP_NO_EQUALIZER_PRESSED	,.destx=219,.desty= 58},
	{.sourcefile=SHUFREP_BMP, .startx= 69,.starty= 61,.dimx= 23,.dimy= 12,.id=SHUFREP_NO_PLAYLIST_PRESSED	,.destx=242,.desty= 58},
	{.sourcefile=SHUFREP_BMP, .startx=  0,.starty= 73,.dimx= 23,.dimy= 12,.id=SHUFREP_EQUALIZER_UNPRESSED	,.destx=219,.desty= 58},
	{.sourcefile=SHUFREP_BMP, .startx= 23,.starty= 73,.dimx= 23,.dimy= 12,.id=SHUFREP_PLAYLIST_UNPRESSED	,.destx=242,.desty= 58},
	{.sourcefile=SHUFREP_BMP, .startx= 46,.starty= 73,.dimx= 23,.dimy= 12,.id=SHUFREP_EQUALIZER_PRESSED	,.destx=219,.desty= 58},
	{.sourcefile=SHUFREP_BMP, .startx= 69,.starty= 73,.dimx= 23,.dimy= 12,.id=SHUFREP_PLAYLIST_PRESSED	,.destx=242,.desty= 58},

// from text.bmp
	{.sourcefile=TEXT_BMP,    .startx=  0,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_A			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=  5,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_B			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 10,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_C			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 15,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_D			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 20,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_E			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 25,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_F			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 30,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_G			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 35,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_H			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 40,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_I			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 45,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_J			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 50,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_K			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 55,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_L			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 60,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_M			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 65,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_N			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 70,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_O			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 75,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_P			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 80,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_Q			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 85,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_R			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 90,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_S			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 95,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_T			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=100,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_U			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=105,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_V			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=110,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_W			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=115,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_X			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=120,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_Y			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=125,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_Z			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=130,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_QUOTATION_MARK		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=135,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_AT_SYMBOL		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=142,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_TIME_DISPLAY_BACKGROUND	,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=150,.starty=  0,.dimx=  5,.dimy=  6,.id=TEXT_TITLE_DISPLAY_SPACE	,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=  0,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_0			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=  5,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_1			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 10,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_2			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 15,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_3			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 20,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_4			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 25,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_5			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 30,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_6			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 35,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_7			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 40,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_8			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 45,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_9			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 50,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_ELLIPSIS			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 55,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_PERIOD			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 60,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_COLON			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 65,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_LEFT_PARENTHESIS		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 70,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_RIGHT_PARENTHESIS	,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 75,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_DASH			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 80,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_APOSTROPHE		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 85,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_EXCLAMATION_MARK		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 90,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_UNDERSCORE		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 95,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_PLUS_SYMBOL		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=100,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_BACK_SLASH		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=105,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_SLASH			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=110,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_LEFT_BRACKET		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=115,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_RIGHT_BRACKET		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=120,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_CARROT			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=125,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_AMPERSAND		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=130,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_PERCENT			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=135,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_COMMA			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=140,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_EQUAL			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=145,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_DOLLAR			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=150,.starty=  6,.dimx=  5,.dimy=  6,.id=TEXT_POUND			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=  0,.starty= 12,.dimx=  5,.dimy=  6,.id=TEXT_A_CIRCUMFLEX		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=  5,.starty= 12,.dimx=  5,.dimy=  6,.id=TEXT_O_UMLAUT			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 10,.starty= 12,.dimx=  5,.dimy=  6,.id=TEXT_A_UMLAUT			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 15,.starty= 12,.dimx=  5,.dimy=  6,.id=TEXT_QUESTION_MARK		,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx= 20,.starty= 12,.dimx=  5,.dimy=  6,.id=TEXT_ASTERISK			,.destx= -1,.desty= -1},
	{.sourcefile=TEXT_BMP,    .startx=100,.starty= 12,.dimx=  5,.dimy=  6,.id=TEXT_KBPS_DISPLAY_SPACE	,.destx= -1,.desty= -1},

// from titlebar.bmp
	{.sourcefile=TITLEBAR_BMP,.startx=  0,.starty=  0,.dimx=  9,.dimy=  9,.id=TITLEBAR_MENU_BUTTON_UNPRESSED	,.destx=  6,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx=  9,.starty=  0,.dimx=  9,.dimy=  9,.id=TITLEBAR_MINIMIZE_BUTTON_UNPRESSED	,.destx=244,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx= 18,.starty=  0,.dimx=  9,.dimy=  9,.id=TITLEBAR_EXIT_BUTTON_UNPRESSED	,.destx=264,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx= 27,.starty=  0,.dimx=275,.dimy= 14,.id=TITLEBAR_NORMAL_TITLEBAR_ACTIVE	,.destx=  0,.desty=  0},
	{.sourcefile=TITLEBAR_BMP,.startx=304,.starty=  0,.dimx=  8,.dimy= 43,.id=TITLEBAR_CLUTTERBAR_SHOWN		,.destx= 10,.desty= 22},
	{.sourcefile=TITLEBAR_BMP,.startx=312,.starty=  0,.dimx=  8,.dimy= 43,.id=TITLEBAR_CLUTTERBAR_HIDDEN		,.destx= 10,.desty= 22},
	{.sourcefile=TITLEBAR_BMP,.startx=  0,.starty=  9,.dimx=  9,.dimy=  9,.id=TITLEBAR_MENU_BUTTON_PRESSED		,.destx=  6,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx=  9,.starty=  9,.dimx=  9,.dimy=  9,.id=TITLEBAR_MINIMIZE_BUTTON_PRESSED	,.destx=244,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx= 18,.starty=  9,.dimx=  9,.dimy=  9,.id=TITLEBAR_EXIT_BUTTON_PRESSED		,.destx=264,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx= 27,.starty= 15,.dimx=275,.dimy= 14,.id=TITLEBAR_NORMAL_TITLEBAR_INACTIVE	,.destx=  0,.desty=  0},
	{.sourcefile=TITLEBAR_BMP,.startx=  0,.starty= 18,.dimx=  9,.dimy=  9,.id=TITLEBAR_WINDOWSHADE_BUTTON_UNPRESSED	,.destx=254,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx=  9,.starty= 18,.dimx=  9,.dimy=  9,.id=TITLEBAR_WINDOWSHADE_BUTTON_PRESSED	,.destx=254,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx=  0,.starty= 27,.dimx=  9,.dimy=  9,.id=TITLEBAR_MAXIMIZE_BUTTON_UNPRESSED	,.destx=254,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx=  9,.starty= 27,.dimx=  9,.dimy=  9,.id=TITLEBAR_MAXIMIZE_BUTTON_PRESSED	,.destx=254,.desty=  3},
	{.sourcefile=TITLEBAR_BMP,.startx= 27,.starty= 29,.dimx=275,.dimy= 14,.id=TITLEBAR_WINDOWSHADE_TITLEBAR_ACTIVE	,.destx= -1,.desty= -1},
	{.sourcefile=TITLEBAR_BMP,.startx=  0,.starty= 36,.dimx= 17,.dimy=  7,.id=TITLEBAR_SONG_PROGRESS_BAR		,.destx= -1,.desty= -1},
	{.sourcefile=TITLEBAR_BMP,.startx= 17,.starty= 36,.dimx=  9,.dimy=  7,.id=TITLEBAR_SONG_PROGRESS_CONTROLS	,.destx= -1,.desty= -1},
	{.sourcefile=TITLEBAR_BMP,.startx= 27,.starty= 42,.dimx=275,.dimy= 14,.id=TITLEBAR_WINDOWSHADE_TITLEBAR_INACTIVE,.destx= -1,.desty= -1},
	{.sourcefile=TITLEBAR_BMP,.startx=304,.starty= 44,.dimx=  8,.dimy= 43,.id=TITLEBAR_CLUTTERBAR_O_PRESSED		,.destx= 10,.desty= 22},
	{.sourcefile=TITLEBAR_BMP,.startx=312,.starty= 44,.dimx=  8,.dimy= 43,.id=TITLEBAR_CLUTTERBAR_A_PRESSED		,.destx= 10,.desty= 22},
	{.sourcefile=TITLEBAR_BMP,.startx=320,.starty= 44,.dimx=  8,.dimy= 43,.id=TITLEBAR_CLUTTERBAR_I_PRESSED		,.destx= 10,.desty= 22},
	{.sourcefile=TITLEBAR_BMP,.startx=328,.starty= 44,.dimx=  8,.dimy= 43,.id=TITLEBAR_CLUTTERBAR_D_PRESSED		,.destx= 10,.desty= 22},
	{.sourcefile=TITLEBAR_BMP,.startx=336,.starty= 44,.dimx=  8,.dimy= 43,.id=TITLEBAR_CLUTTERBAR_V_PRESSED		,.destx= 10,.desty= 22},
	{.sourcefile=TITLEBAR_BMP,.startx= 27,.starty= 57,.dimx=275,.dimy= 14,.id=TITLEBAR_ALTERNATIVE_TITLEBAR_ACTIVE	,.destx=  0,.desty=  0},
	{.sourcefile=TITLEBAR_BMP,.startx= 27,.starty= 72,.dimx=275,.dimy= 14,.id=TITLEBAR_ALTERNATIVE_TITLEBAR_INACTIVE,.destx=  0,.desty=  0},

// from volume.bmp
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=  0,.dimx= 68,.dimy= 13,.id=VOLUME_000_001		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty= 15,.dimx= 68,.dimy= 13,.id=VOLUME_003_005		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty= 30,.dimx= 68,.dimy= 13,.id=VOLUME_007_009		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty= 45,.dimx= 68,.dimy= 13,.id=VOLUME_011_013		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty= 60,.dimx= 68,.dimy= 13,.id=VOLUME_015_017		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty= 75,.dimx= 68,.dimy= 13,.id=VOLUME_019_021		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty= 90,.dimx= 68,.dimy= 13,.id=VOLUME_023_025		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=105,.dimx= 68,.dimy= 13,.id=VOLUME_027_029		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=120,.dimx= 68,.dimy= 13,.id=VOLUME_031			,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=135,.dimx= 68,.dimy= 13,.id=VOLUME_033_035		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=150,.dimx= 68,.dimy= 13,.id=VOLUME_037_039		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=165,.dimx= 68,.dimy= 13,.id=VOLUME_041_043		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=180,.dimx= 68,.dimy= 13,.id=VOLUME_045_047		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=195,.dimx= 68,.dimy= 13,.id=VOLUME_049_050		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=210,.dimx= 68,.dimy= 13,.id=VOLUME_052_054		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=225,.dimx= 68,.dimy= 13,.id=VOLUME_056_058		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=240,.dimx= 68,.dimy= 13,.id=VOLUME_060_062		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=255,.dimx= 68,.dimy= 13,.id=VOLUME_064			,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=270,.dimx= 68,.dimy= 13,.id=VOLUME_066_068		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=285,.dimx= 68,.dimy= 13,.id=VOLUME_070_072		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=300,.dimx= 68,.dimy= 13,.id=VOLUME_074_076		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=315,.dimx= 68,.dimy= 13,.id=VOLUME_078_080		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=330,.dimx= 68,.dimy= 13,.id=VOLUME_082_084		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=345,.dimx= 68,.dimy= 13,.id=VOLUME_086_088		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=360,.dimx= 68,.dimy= 13,.id=VOLUME_090_092		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=375,.dimx= 68,.dimy= 13,.id=VOLUME_094_096		,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=390,.dimx= 68,.dimy= 13,.id=VOLUME_098			,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=405,.dimx= 68,.dimy= 13,.id=VOLUME_100			,.destx=107,.desty= 57},
	{.sourcefile=VOLUME_BMP,  .startx=  0,.starty=422,.dimx= 14,.dimy= 11,.id=VOLUME_SLIDER_PRESSED		,.destx= -1,.desty= 58},
	{.sourcefile=VOLUME_BMP,  .startx= 15,.starty=422,.dimx= 14,.dimy= 11,.id=VOLUME_SLIDER_UNPRESSED	,.destx= -1,.desty= 58}
};


