/*
Copyright 2023, dettus@dettus.net

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef	GUI_HELPERS_H
#define	GUI_HELPERS_H

#include <gtk/gtk.h>
#include "datastructures.h"
#include "theme_manager.h"
#define	BOUNDING_BOX(id)	.posx=ELEMENT_DESTX(id),.posy=ELEMENT_DESTY(id),.dimx=ELEMENT_WIDTH(id),.dimy=ELEMENT_HEIGHT(id)
ePressable gui_helpers_find_pressable(tPressableBoundingBox *pBoundingBoxes,int num, double pressx,double pressy, GtkWidget* window,int defaultwidth,int defaultheight);
int gui_helpers_relative_value(int minvalue,int maxvalue,double minpos,double maxpos,int x0y1, double x,double y,GtkWidget* window,int defaultwidth,int defaultheight);
int gui_helpers_define_pressable_by_dimensions(tPressableBoundingBox *pPressableBoundingBox,ePressable pressable,int posx,int posy,int dimx,int dimy);
int gui_helpers_define_pressable_by_element(int width,int height,tPressableBoundingBox *pPressableBoundingBox,ePressable pressable,eElementID id);
int gui_helpers_undefine_pressable(tPressableBoundingBox *pPressableBoundingBox,ePressable pressable);


#endif
