/*
Copyright 2023, dettus@dettus.net

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
//
//
//
// THIS CODE WAS GENERATED BY THE PACK_DEFAULT_THEME TOOL //
//
//
//
#include "default_theme.h"
// i had a little fun with data structures here...
// each file is packed individually as a block
// each block starts with 8 bytes of verbatim input data
// the next byte is the one of two tags: VERBATIM_TAG and REPEAT_TAG.
// The VERBATIM_TAG is denoted by bit7=0. bits 6..0 are the amount of
// bytes which follow.
// The REPEAT_TAG is denoted by bit7=1.
//     repeat_bytes 14..8 are bits 6..0
//     repeat_bytes  7..0 are bits 7..0 of the next byte --> 15 bit
//                                             (maximum 32767 bytes)
//     the next 1..3 bytes are a previous position within the output
//     buffer. note that the repeat buffer might be overlapping with
//     the edge. (implicit run-length encoding)
const tDefaultThemePackedDir defaultThemePackedDir[TOTAL_NUM]={
	{.filename="BALANCE.BMP"   ,.start=0x00000000,.len=   88386},
	{.filename="CBUTTONS.BMP"  ,.start=0x00000591,.len=   14742},
	{.filename="EQMAIN.BMP"    ,.start=0x000007fd,.len=  260874},
	{.filename="EQ_EX.BMP"     ,.start=0x000016d2,.len=   67950},
	{.filename="MAIN.BMP"      ,.start=0x000019fa,.len=   96102},
	{.filename="MONOSTER.BMP"  ,.start=0x00001cf3,.len=    4278},
	{.filename="NUMBERS.BMP"   ,.start=0x00001e7e,.len=    3954},
	{.filename="PLAYPAUS.BMP"  ,.start=0x00001f7b,.len=    1206},
	{.filename="PLEDIT.BMP"    ,.start=0x00002010,.len=  156294},
	{.filename="PLEDIT.TXT"    ,.start=0x00002e3a,.len=      91},
	{.filename="POSBAR.BMP"    ,.start=0x00002e92,.len=    9294},
	{.filename="SHUFREP.BMP"   ,.start=0x00002f78,.len=   23514},
	{.filename="TEXT.BMP"      ,.start=0x00003441,.len=   34686},
	{.filename="TITLEBAR.BMP"  ,.start=0x00003721,.len=   89838},
	{.filename="VISCOLOR.TXT"  ,.start=0x00003e82,.len=     746},
	{.filename="VOLUME.BMP"    ,.start=0x00004072,.len=   88386},
	{.filename="cc-0-10.txt"   ,.start=0x00004657,.len=    7233}
};
const unsigned char defaultThemePacked[23191]={
	0x42,0x4d,0x42,0x59,0x01,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,0x28,	// 00000000
	0x00,0x00,0x00,0x44,0x00,0x00,0x00,0xb1,0x01,0x00,0x00,0x01,0x00,0x18,0x80,0x05,	// 00000010
	0x05,0x04,0x0c,0x59,0x01,0x00,0x80,0x05,0x05,0x80,0x0b,0x25,0x09,0x5a,0x57,0x50,	// 00000020
	0x5a,0x57,0x50,0x56,0x53,0x4c,0x80,0x1e,0x3c,0x04,0x58,0x55,0x4e,0x00,0x80,0x05,	// 00000030
	0x34,0x80,0x21,0x3c,0x80,0x09,0x5a,0x80,0x72,0x8d,0x05,0x40,0x3e,0x38,0x00,0x00,	// 00000040
	0x80,0x28,0x00,0xe0,0x80,0x2d,0x01,0x02,0x80,0x75,0x00,0x8d,0x06,0x7a,0x77,0x70,	// 00000050
	0x9a,0x97,0x90,0x80,0x1b,0x01,0xd4,0x05,0x7a,0x77,0x70,0x00,0x00,0x80,0x07,0x00,	// 00000060
	0x25,0x06,0x58,0x56,0x50,0x7a,0x77,0x70,0x80,0x1b,0x02,0x01,0x05,0x58,0x56,0x50,	// 00000070
	0x00,0x00,0x80,0x79,0x02,0x22,0x80,0x1e,0x01,0xd4,0x80,0x06,0x01,0xd4,0x80,0x0c,	// 00000080
	0x01,0xc8,0x80,0x21,0x02,0xca,0x81,0x56,0x02,0x22,0x80,0x06,0x00,0x36,0x80,0x27,	// 00000090
	0x02,0xb2,0x80,0x06,0x00,0x36,0x81,0x65,0x03,0xab,0x81,0x89,0x02,0xac,0x80,0xc9,	// 000000A0
	0x01,0xd1,0x80,0xcf,0x01,0x02,0x83,0x48,0x08,0x85,0x80,0x06,0x00,0x36,0x80,0x6c,	// 000000B0
	0x0c,0x45,0x82,0xbe,0x0b,0xeb,0x80,0x6c,0x01,0x56,0x05,0x40,0x3e,0x38,0x5a,0x57,	// 000000C0
	0x80,0x5e,0x02,0x21,0x06,0x09,0x38,0xa4,0x10,0x50,0xe0,0x80,0x60,0x10,0x47,0x06,	// 000000D0
	0x09,0x38,0xa4,0x00,0x00,0x00,0x80,0x60,0x0f,0xe4,0x80,0x63,0x10,0x47,0x80,0x06,	// 000000E0
	0x10,0x47,0x81,0x2f,0x10,0xad,0x80,0xc9,0x10,0x44,0x80,0xcc,0x0f,0x75,0x82,0x64,	// 000000F0
	0x0c,0x45,0x85,0x97,0x0a,0xad,0x06,0x0a,0x37,0xa0,0x12,0x4f,0xdb,0x80,0x60,0x1c,	// 00000100
	0x3b,0x05,0x0a,0x37,0xa0,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0x1c,0x3b,0x80,	// 00000110
	0x06,0x1c,0x3b,0x81,0x2f,0x1c,0xa1,0x80,0xc9,0x1c,0x38,0x88,0xc7,0x13,0x71,0x06,	// 00000120
	0x0c,0x36,0x9d,0x14,0x4d,0xd6,0x80,0x60,0x28,0x2f,0x05,0x0c,0x36,0x9d,0x00,0x00,	// 00000130
	0x80,0x61,0x10,0xaf,0x80,0x63,0x28,0x2f,0x80,0x06,0x28,0x2f,0x81,0x2f,0x28,0x95,	// 00000140
	0x80,0xc9,0x28,0x2c,0x88,0xc7,0x13,0x71,0x06,0x0d,0x35,0x99,0x16,0x4b,0xd1,0x80,	// 00000150
	0x60,0x34,0x23,0x05,0x0d,0x35,0x99,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0x34,	// 00000160
	0x23,0x80,0x06,0x34,0x23,0x81,0x2f,0x34,0x89,0x80,0xc9,0x34,0x20,0x88,0xc7,0x13,	// 00000170
	0x71,0x06,0x0e,0x33,0x95,0x17,0x4a,0xcb,0x80,0x60,0x40,0x17,0x05,0x0e,0x33,0x95,	// 00000180
	0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0x40,0x17,0x80,0x06,0x40,0x17,0x81,0x2f,	// 00000190
	0x40,0x7d,0x80,0xc9,0x40,0x14,0x88,0xc7,0x13,0x71,0x06,0x0f,0x32,0x90,0x19,0x48,	// 000001A0
	0xc6,0x80,0x60,0x4c,0x0b,0x05,0x0f,0x32,0x90,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,	// 000001B0
	0x63,0x4c,0x0b,0x80,0x06,0x4c,0x0b,0x81,0x2f,0x4c,0x71,0x80,0xc9,0x4c,0x08,0x88,	// 000001C0
	0xc7,0x13,0x71,0x06,0x11,0x31,0x8c,0x1a,0x47,0xc0,0x80,0x60,0x57,0xff,0x05,0x11,	// 000001D0
	0x31,0x8c,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0x57,0xff,0x80,0x06,0x57,0xff,	// 000001E0
	0x81,0x2f,0x58,0x65,0x80,0xc9,0x57,0xfc,0x88,0xc7,0x13,0x71,0x06,0x12,0x30,0x87,	// 000001F0
	0x1c,0x45,0xba,0x80,0x60,0x63,0xf3,0x05,0x12,0x30,0x87,0x00,0x00,0x80,0x61,0x10,	// 00000200
	0xaf,0x80,0x63,0x63,0xf3,0x80,0x06,0x63,0xf3,0x81,0x2f,0x64,0x59,0x80,0xc9,0x63,	// 00000210
	0xf0,0x88,0xc7,0x13,0x71,0x06,0x13,0x2e,0x83,0x1d,0x43,0xb3,0x80,0x60,0x6f,0xe7,	// 00000220
	0x05,0x13,0x2e,0x83,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0x6f,0xe7,0x80,0x06,	// 00000230
	0x6f,0xe7,0x81,0x2f,0x70,0x4d,0x80,0xc9,0x6f,0xe4,0x88,0xc8,0x67,0x1d,0x05,0x2d,	// 00000240
	0x7e,0x1e,0x41,0xad,0x80,0x60,0x7b,0xdb,0x05,0x13,0x2d,0x7e,0x00,0x00,0x80,0x61,	// 00000250
	0x10,0xaf,0x80,0x63,0x7b,0xdb,0x80,0x06,0x7b,0xdb,0x81,0x2f,0x7c,0x41,0x80,0xc9,	// 00000260
	0x7b,0xd8,0x88,0xc7,0x13,0x71,0x06,0x14,0x2c,0x78,0x20,0x3f,0xa6,0x80,0x60,0x87,	// 00000270
	0xcf,0x05,0x14,0x2c,0x78,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0x87,0xcf,0x80,	// 00000280
	0x06,0x87,0xcf,0x81,0x2f,0x88,0x35,0x80,0xc9,0x87,0xcc,0x88,0xc7,0x13,0x71,0x06,	// 00000290
	0x15,0x2a,0x73,0x21,0x3d,0x9e,0x80,0x60,0x93,0xc3,0x05,0x15,0x2a,0x73,0x00,0x00,	// 000002A0
	0x80,0x61,0x10,0xaf,0x80,0x63,0x93,0xc3,0x80,0x06,0x93,0xc3,0x81,0x2f,0x94,0x29,	// 000002B0
	0x80,0xc9,0x93,0xc0,0x88,0xc7,0x13,0x71,0x06,0x16,0x29,0x6d,0x22,0x3b,0x96,0x80,	// 000002C0
	0x60,0x9f,0xb7,0x05,0x16,0x29,0x6d,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0x9f,	// 000002D0
	0xb7,0x80,0x06,0x9f,0xb7,0x81,0x2f,0xa0,0x1d,0x80,0xc9,0x9f,0xb4,0x88,0xc7,0x13,	// 000002E0
	0x71,0x06,0x17,0x27,0x67,0x23,0x39,0x8e,0x80,0x60,0xab,0xab,0x05,0x17,0x27,0x67,	// 000002F0
	0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0xab,0xab,0x80,0x06,0xab,0xab,0x81,0x2f,	// 00000300
	0xac,0x11,0x80,0xc9,0xab,0xa8,0x88,0xc7,0x13,0x71,0x06,0x18,0x26,0x60,0x24,0x37,	// 00000310
	0x85,0x80,0x60,0xb7,0x9f,0x05,0x18,0x26,0x60,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,	// 00000320
	0x63,0xb7,0x9f,0x80,0x06,0xb7,0x9f,0x81,0x2f,0xb8,0x05,0x80,0xc9,0xb7,0x9c,0x88,	// 00000330
	0xc8,0xae,0xd5,0x05,0x24,0x5a,0x25,0x35,0x7d,0x80,0x60,0xc3,0x93,0x05,0x18,0x24,	// 00000340
	0x5a,0x00,0x00,0x80,0x61,0x10,0xaf,0x80,0x63,0xc3,0x93,0x80,0x06,0xc3,0x93,0x81,	// 00000350
	0x2f,0xc3,0xf9,0x80,0xc9,0xc3,0x90,0x88,0xc7,0x13,0x71,0x06,0x19,0x23,0x55,0x26,	// 00000360
	0x34,0x76,0x80,0x60,0xcf,0x87,0x05,0x19,0x23,0x55,0x00,0x00,0x80,0x61,0x10,0xaf,	// 00000370
	0x80,0x63,0xcf,0x87,0x80,0x06,0xcf,0x87,0x81,0x2f,0xcf,0xed,0x80,0xc9,0xcf,0x84,	// 00000380
	0x88,0xc8,0xc6,0xbd,0x05,0x22,0x50,0x26,0x32,0x70,0x80,0x60,0xdb,0x7b,0x05,0x19,	// 00000390
	0x22,0x50,0x00,0x00,0x80,0x62,0xcf,0xef,0x80,0x62,0xdb,0x7c,0x80,0x06,0xdb,0x7b,	// 000003A0
	0x81,0x2f,0xdb,0xe1,0x80,0xc9,0xdb,0x78,0x88,0xc8,0xc6,0xbd,0x05,0x21,0x4c,0x27,	// 000003B0
	0x31,0x6b,0x80,0x60,0xe7,0x6f,0x05,0x19,0x21,0x4c,0x00,0x00,0x80,0x61,0x10,0xaf,	// 000003C0
	0x80,0x63,0xe7,0x6f,0x80,0x06,0xe7,0x6f,0x81,0x2f,0xe7,0xd5,0x80,0xc9,0xe7,0x6c,	// 000003D0
	0x88,0xc7,0x13,0x71,0x06,0x1a,0x21,0x48,0x27,0x30,0x65,0x80,0x60,0xf3,0x63,0x05,	// 000003E0
	0x1a,0x21,0x48,0x00,0x00,0x80,0x62,0xe7,0xd7,0x80,0x62,0xf3,0x64,0x80,0x06,0xf3,	// 000003F0
	0x63,0x81,0x2f,0xf3,0xc9,0x80,0xc9,0xf3,0x60,0x88,0xc8,0xea,0x99,0x05,0x20,0x44,	// 00000400
	0x27,0x2f,0x60,0x80,0x60,0xff,0x57,0x05,0x1a,0x20,0x44,0x00,0x00,0x80,0x62,0xe7,	// 00000410
	0xd7,0x80,0x62,0x00,0xff,0x58,0x80,0x06,0x00,0xff,0x57,0x81,0x2f,0x00,0xff,0xbd,	// 00000420
	0x80,0xc9,0x00,0xff,0x54,0x88,0xc8,0x00,0xea,0x99,0x06,0x1f,0x40,0x28,0x2e,0x5a,	// 00000430
	0x28,0x80,0x5f,0x01,0x0b,0x4c,0x06,0x1a,0x1f,0x40,0x00,0x00,0x00,0x80,0x60,0x00,	// 00000440
	0x0f,0xe4,0x80,0x63,0x01,0x0b,0x4b,0x80,0x06,0x01,0x0b,0x4b,0x81,0x2f,0x01,0x0b,	// 00000450
	0xb1,0x80,0xc9,0x01,0x0b,0x48,0x88,0xc7,0x00,0x13,0x71,0x06,0x1b,0x1e,0x3b,0x28,	// 00000460
	0x2d,0x53,0x80,0x60,0x01,0x17,0x3f,0x06,0x1b,0x1e,0x3b,0x00,0x00,0x00,0x80,0x61,	// 00000470
	0x01,0x0b,0xb4,0x80,0x62,0x01,0x17,0x40,0x80,0x06,0x01,0x17,0x3f,0x81,0x2f,0x01,	// 00000480
	0x17,0xa5,0x80,0xc9,0x01,0x17,0x3c,0x88,0xc9,0x01,0x0e,0x75,0x06,0x35,0x29,0x2c,	// 00000490
	0x4c,0x29,0x2c,0x80,0x5e,0x01,0x23,0x35,0x06,0x1b,0x1e,0x35,0x00,0x00,0x00,0x80,	// 000004A0
	0x60,0x00,0x0f,0xe4,0x80,0x63,0x01,0x23,0x33,0x80,0x06,0x01,0x23,0x33,0x81,0x2f,	// 000004B0
	0x01,0x23,0x99,0x80,0xc9,0x01,0x23,0x30,0x88,0xc8,0x01,0x0e,0x75,0x06,0x1d,0x2f,	// 000004C0
	0x29,0x2b,0x44,0x29,0x80,0x5f,0x01,0x2f,0x28,0x06,0x1b,0x1d,0x2f,0x00,0x00,0x00,	// 000004D0
	0x80,0x61,0x01,0x23,0x9c,0x80,0x62,0x01,0x2f,0x28,0x80,0x06,0x01,0x2f,0x27,0x81,	// 000004E0
	0x2f,0x01,0x2f,0x8d,0x80,0xc9,0x01,0x2f,0x24,0x88,0xc8,0x01,0x0e,0x75,0x06,0x1c,	// 000004F0
	0x28,0x29,0x2a,0x3b,0x29,0x80,0x5f,0x01,0x3b,0x1c,0x06,0x1b,0x1c,0x28,0x00,0x00,	// 00000500
	0x00,0x80,0x61,0x01,0x23,0x9c,0x80,0x62,0x01,0x3b,0x1c,0x80,0x06,0x01,0x3b,0x1b,	// 00000510
	0x81,0x2f,0x01,0x3b,0x81,0x80,0xc9,0x01,0x3b,0x18,0x88,0xc7,0x00,0x13,0x71,0x06,	// 00000520
	0x1c,0x1b,0x20,0x2a,0x28,0x30,0x80,0x60,0x01,0x47,0x0f,0x06,0x1c,0x1b,0x20,0x00,	// 00000530
	0x00,0x00,0x80,0x60,0x00,0x0f,0xe4,0x80,0x63,0x01,0x47,0x0f,0x80,0x06,0x01,0x47,	// 00000540
	0x0f,0x81,0x2f,0x01,0x47,0x75,0x80,0xc9,0x01,0x47,0x0c,0x88,0xc8,0x01,0x3e,0x45,	// 00000550
	0x06,0x1a,0x14,0x2a,0x27,0x20,0x2a,0x80,0x5f,0x01,0x53,0x04,0x06,0x1c,0x1a,0x14,	// 00000560
	0x00,0x00,0x00,0x80,0x61,0x01,0x47,0x78,0x80,0x62,0x01,0x53,0x04,0x80,0x06,0x01,	// 00000570
	0x53,0x03,0x81,0x2f,0x01,0x53,0x69,0x80,0xc9,0x01,0x53,0x00,0x84,0xc8,0x00,0x13,	// 00000580
	0x71,0x42,0x4d,0x96,0x39,0x00,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,	// 00000590
	0x28,0x00,0x00,0x00,0x88,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x01,0x00,0x18,0x80,	// 000005A0
	0x05,0x04,0x04,0x60,0x39,0x00,0x00,0x80,0x10,0x24,0x06,0x09,0x38,0xa4,0x10,0x50,	// 000005B0
	0xe0,0x80,0x3c,0x39,0x04,0x00,0x00,0x00,0x10,0x80,0x3e,0x3a,0x80,0xcc,0x75,0x05,	// 000005C0
	0x09,0x38,0xa4,0x00,0x00,0x80,0x43,0x01,0x89,0x81,0x0b,0x00,0x7b,0x80,0x48,0x00,	// 000005D0
	0x72,0x85,0x22,0x01,0x89,0x80,0x12,0x01,0xc8,0x80,0x06,0x01,0x86,0x80,0x2d,0x00,	// 000005E0
	0x63,0x09,0x00,0x00,0x00,0x04,0x27,0x78,0x0d,0x45,0xc5,0x80,0x3c,0x00,0x54,0x80,	// 000005F0
	0x0f,0x01,0xc5,0x80,0x21,0x08,0x25,0x80,0x2d,0x03,0x0c,0x80,0x2a,0x00,0x63,0x80,	// 00000600
	0x12,0x00,0x33,0x80,0x1e,0x08,0x28,0x80,0x3f,0x00,0x36,0x80,0x18,0x00,0x36,0x80,	// 00000610
	0x0f,0x01,0xc8,0x80,0x09,0x01,0x86,0x80,0x36,0x08,0xa0,0x80,0x24,0x08,0x8b,0x80,	// 00000620
	0xa2,0x08,0xb5,0x80,0x0f,0x00,0x33,0x80,0x33,0x08,0xdf,0x80,0x45,0x00,0x7b,0x80,	// 00000630
	0x09,0x00,0x78,0x80,0x0c,0x01,0x86,0x80,0x3c,0x08,0xe5,0x80,0x1e,0x08,0x8b,0x80,	// 00000640
	0xa5,0x0a,0x4d,0x80,0x0c,0x00,0x33,0x80,0x7e,0x0a,0xfe,0x80,0x0f,0x01,0x86,0x80,	// 00000650
	0x42,0x08,0xe5,0x05,0x04,0x27,0x78,0x10,0x50,0x80,0xbb,0x0b,0xd2,0x80,0x09,0x00,	// 00000660
	0x33,0x80,0x60,0x08,0xdf,0x81,0xb6,0x0c,0xf6,0x81,0x98,0x0b,0x7c,0x81,0x9b,0x09,	// 00000670
	0xe4,0x81,0x35,0x08,0x4f,0x80,0x57,0x0e,0x4c,0x81,0x41,0x01,0xe3,0x80,0x2a,0x01,	// 00000680
	0x71,0x80,0x42,0x00,0x36,0x81,0x41,0x15,0x18,0x80,0x12,0x01,0x83,0x80,0x5a,0x16,	// 00000690
	0x6e,0x81,0x2f,0x16,0xc5,0x80,0x0c,0x01,0x83,0x80,0x5d,0x18,0x03,0x81,0x32,0x18,	// 000006A0
	0x5d,0x80,0x06,0x01,0x83,0x80,0x21,0x00,0x36,0x81,0x50,0x00,0x36,0x80,0x48,0x00,	// 000006B0
	0x75,0x06,0x58,0x56,0x50,0x7a,0x77,0x70,0x80,0x3c,0x1c,0xe9,0x05,0x00,0x00,0x00,	// 000006C0
	0x7a,0x77,0x80,0x3d,0x1c,0xeb,0x80,0xcf,0x1d,0x25,0x80,0x45,0x09,0x81,0x81,0x0e,	// 000006D0
	0x1d,0x2b,0x80,0x48,0x1d,0xf4,0x80,0x42,0x01,0x89,0x82,0xee,0x1e,0x7e,0x05,0x5a,	// 000006E0
	0x57,0x50,0x7a,0x77,0x80,0x3a,0x1c,0xeb,0x80,0x3f,0x23,0x04,0x81,0x1a,0x1d,0x22,	// 000006F0
	0x80,0x42,0x1d,0x2b,0x80,0x15,0x1c,0xe9,0x06,0xea,0xe7,0xe0,0xea,0xe7,0xe0,0x80,	// 00000700
	0x0c,0x1c,0xe9,0x05,0xbd,0xba,0xb4,0xea,0xe7,0x80,0x0d,0x24,0xf8,0x80,0x21,0x1d,	// 00000710
	0x1f,0x08,0xea,0xe7,0xe0,0xd5,0xd2,0xcb,0xa9,0xa7,0x80,0x25,0x1e,0x7d,0x80,0x1b,	// 00000720
	0x25,0x20,0x80,0x0c,0x24,0xf3,0x80,0x0f,0x25,0x7d,0x80,0x30,0x25,0x56,0x80,0x0f,	// 00000730
	0x25,0xc2,0x80,0x2a,0x1d,0x13,0x06,0xea,0xe7,0xe0,0xbd,0xba,0xb4,0x80,0x1e,0x24,	// 00000740
	0xe7,0x80,0x72,0x24,0x90,0x80,0x06,0x25,0x05,0x80,0x39,0x25,0x92,0x80,0x24,0x25,	// 00000750
	0x3b,0x80,0xa2,0x25,0x65,0x80,0x0f,0x26,0x04,0x80,0x60,0x25,0x8f,0x80,0x21,0x24,	// 00000760
	0xde,0x80,0x09,0x26,0x9a,0x80,0x3f,0x25,0x92,0x80,0x1e,0x25,0x3b,0x80,0xa5,0x26,	// 00000770
	0xfd,0x80,0x0c,0x26,0x04,0x80,0x7e,0x27,0xae,0x80,0x0c,0x28,0x2f,0x80,0x45,0x25,	// 00000780
	0x92,0x05,0xd5,0xd2,0xcb,0x7a,0x77,0x80,0xbb,0x28,0x82,0x80,0x09,0x26,0x04,0x80,	// 00000790
	0x7e,0x26,0x16,0x81,0x98,0x29,0xc4,0x81,0x98,0x28,0x2c,0x81,0x4d,0x26,0x94,0x80,	// 000007A0
	0x0f,0x29,0xc4,0x80,0x12,0x27,0x9c,0x81,0x7a,0x24,0xd2,0x80,0x0f,0x29,0xc4,0x80,	// 000007B0
	0x2d,0x2f,0xee,0x81,0x5f,0x23,0x58,0x80,0x09,0x26,0x9a,0x80,0x5d,0x31,0x83,0x81,	// 000007C0
	0x35,0x23,0x85,0x05,0xbd,0xba,0xb4,0xbd,0xba,0x80,0x5e,0x33,0x1a,0x81,0x6e,0x23,	// 000007D0
	0x85,0x81,0x41,0x1c,0xfb,0x80,0x3f,0x1c,0xe6,0x05,0x58,0x56,0x50,0x58,0x56,0x81,	// 000007E0
	0x4e,0x1c,0xe8,0x05,0x58,0x56,0x50,0x00,0x00,0x80,0x45,0x01,0x89,0x42,0x4d,0x0a,	// 000007F0
	0xfb,0x03,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,0x00,0x00,	// 00000800
	0x13,0x01,0x00,0x00,0x3b,0x01,0x00,0x00,0x01,0x00,0x18,0x80,0x05,0x05,0x04,0xd4,	// 00000810
	0xfa,0x03,0x00,0x80,0x05,0x05,0x80,0x0b,0x25,0x09,0x2a,0x27,0x20,0x2a,0x27,0x20,	// 00000820
	0x5a,0x57,0x50,0x81,0x47,0x39,0x05,0x2a,0x27,0x20,0x00,0x00,0x85,0x23,0x01,0x89,	// 00000830
	0x06,0x1c,0x1a,0x14,0x2a,0x27,0x20,0x81,0x4a,0x06,0xb1,0x0c,0x1c,0x1a,0x14,0x00,	// 00000840
	0x00,0x00,0x00,0x00,0x00,0x4d,0x8f,0x06,0x81,0xe0,0x01,0x89,0x81,0x4d,0x06,0xb1,	// 00000850
	0x80,0x0c,0x01,0x83,0x05,0x4a,0x8b,0x12,0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x46,	// 00000860
	0x87,0x1e,0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x43,0x84,0x2a,0x00,0x00,0x83,0x37,	// 00000870
	0x08,0x0c,0x05,0x40,0x80,0x35,0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x3d,0x7d,0x42,	// 00000880
	0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x39,0x7a,0x4d,0x00,0x00,0x83,0x37,0x08,0x0c,	// 00000890
	0x05,0x36,0x76,0x5a,0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x32,0x73,0x66,0x00,0x00,	// 000008A0
	0x83,0x37,0x08,0x0c,0x05,0x30,0x71,0x6e,0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x2d,	// 000008B0
	0x6d,0x7b,0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x2a,0x6a,0x86,0x00,0x00,0x83,0x37,	// 000008C0
	0x08,0x0c,0x05,0x25,0x66,0x92,0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x22,0x63,0x9f,	// 000008D0
	0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x1f,0x5f,0xaa,0x00,0x00,0x83,0x37,0x08,0x0c,	// 000008E0
	0x05,0x1c,0x5c,0xb7,0x00,0x00,0x83,0x37,0x08,0x0c,0x05,0x18,0x58,0xc3,0x00,0x00,	// 000008F0
	0x83,0x37,0x08,0x0c,0x05,0x16,0x56,0xce,0x00,0x00,0x83,0x37,0x04,0xd0,0x05,0x12,	// 00000900
	0x52,0xda,0x00,0x00,0x88,0x7d,0x42,0x42,0x05,0x5a,0x57,0x50,0x5a,0x57,0x80,0x25,	// 00000910
	0x4a,0xc3,0x82,0x4c,0x4a,0xbe,0x84,0x0b,0x49,0xfb,0x05,0x40,0x3e,0x38,0x00,0x00,	// 00000920
	0x80,0x0a,0x00,0x25,0x05,0x40,0x3e,0x38,0x5a,0x57,0x80,0x19,0x4a,0xde,0x82,0x40,	// 00000930
	0x51,0x42,0x80,0xcf,0x49,0xfb,0x80,0x0c,0x06,0xab,0x80,0x06,0x07,0xfe,0x80,0x1b,	// 00000940
	0x4a,0xdc,0x0f,0x00,0x00,0x00,0x1b,0x1c,0x2c,0x29,0x2a,0x40,0x29,0x2a,0x40,0x1b,	// 00000950
	0x1c,0x2c,0x80,0x22,0x54,0x8d,0x0b,0x1e,0x3b,0x28,0x2d,0x54,0x28,0x2d,0x54,0x1b,	// 00000960
	0x1e,0x3b,0x80,0x21,0x54,0x8d,0x0c,0x1a,0x20,0x46,0x27,0x30,0x62,0x27,0x30,0x62,	// 00000970
	0x1a,0x20,0x46,0x80,0x21,0x54,0x8d,0x0b,0x19,0x22,0x50,0x26,0x32,0x70,0x26,0x32,	// 00000980
	0x70,0x19,0x22,0x80,0x13,0x4a,0xea,0x80,0x0f,0x54,0x72,0x0c,0x18,0x24,0x58,0x25,	// 00000990
	0x35,0x7b,0x25,0x35,0x7b,0x18,0x24,0x58,0x80,0x22,0x55,0x41,0x0b,0x26,0x60,0x24,	// 000009A0
	0x37,0x85,0x24,0x37,0x85,0x18,0x26,0x60,0x80,0x21,0x54,0x8d,0x0c,0x17,0x27,0x67,	// 000009B0
	0x23,0x39,0x8e,0x23,0x39,0x8e,0x17,0x27,0x67,0x80,0x21,0x54,0x8d,0x0c,0x16,0x29,	// 000009C0
	0x6d,0x22,0x3b,0x96,0x22,0x3b,0x96,0x16,0x29,0x6d,0x80,0x21,0x54,0x8d,0x0c,0x15,	// 000009D0
	0x2a,0x73,0x21,0x3d,0x9e,0x21,0x3d,0x9e,0x15,0x2a,0x73,0x80,0x21,0x54,0x8d,0x0c,	// 000009E0
	0x14,0x2c,0x78,0x20,0x3f,0xa6,0x20,0x3f,0xa6,0x14,0x2c,0x78,0x80,0x21,0x54,0x8d,	// 000009F0
	0x0c,0x13,0x2e,0x83,0x1d,0x43,0xb3,0x1d,0x43,0xb3,0x13,0x2e,0x83,0x80,0x21,0x54,	// 00000A00
	0x8d,0x0c,0x11,0x31,0x8c,0x1a,0x47,0xc0,0x1a,0x47,0xc0,0x11,0x31,0x8c,0x80,0x21,	// 00000A10
	0x54,0x8d,0x0c,0x09,0x38,0xa4,0x10,0x50,0xe0,0x10,0x50,0xe0,0x09,0x38,0xa4,0x80,	// 00000A20
	0x15,0x54,0x8d,0x80,0xd2,0x53,0xaf,0x80,0x0f,0x0b,0x31,0x80,0x1e,0x54,0x90,0x80,	// 00000A30
	0x06,0x54,0xb1,0x80,0x06,0x54,0xb1,0x80,0x21,0x54,0x8d,0x80,0x06,0x54,0xde,0x80,	// 00000A40
	0x06,0x54,0xde,0x80,0x21,0x54,0x8d,0x80,0x06,0x55,0x0b,0x80,0x06,0x55,0x0b,0x80,	// 00000A50
	0x21,0x54,0x8d,0x80,0x06,0x55,0x38,0x80,0x06,0x55,0x38,0x80,0x21,0x54,0x8d,0x80,	// 00000A60
	0x06,0x55,0x65,0x80,0x06,0x55,0x65,0x80,0x21,0x54,0x8d,0x80,0x06,0x55,0x92,0x80,	// 00000A70
	0x06,0x55,0x92,0x80,0x21,0x54,0x8d,0x80,0x06,0x55,0xbf,0x80,0x06,0x55,0xbf,0x80,	// 00000A80
	0x21,0x54,0x8d,0x80,0x06,0x55,0xec,0x80,0x06,0x55,0xec,0x80,0x21,0x54,0x8d,0x80,	// 00000A90
	0x06,0x56,0x19,0x80,0x06,0x56,0x19,0x80,0x21,0x54,0x8d,0x80,0x06,0x56,0x46,0x80,	// 00000AA0
	0x06,0x56,0x46,0x80,0x21,0x54,0x8d,0x80,0x06,0x56,0x73,0x80,0x06,0x56,0x73,0x80,	// 00000AB0
	0x22,0x54,0xe7,0x80,0x05,0x56,0xa1,0x80,0x06,0x56,0xa0,0x80,0x21,0x54,0x8d,0x80,	// 00000AC0
	0x06,0x56,0xcd,0x80,0x06,0x56,0xcd,0x87,0x77,0x56,0xd6,0x80,0x12,0x57,0xc3,0x80,	// 00000AD0
	0x1b,0x57,0xe7,0x80,0x15,0x61,0x89,0x80,0x18,0x58,0x17,0x80,0x15,0x61,0x89,0x80,	// 00000AE0
	0x18,0x58,0x44,0x80,0x15,0x61,0x89,0x80,0x18,0x58,0x71,0x80,0x15,0x61,0x89,0x80,	// 00000AF0
	0x18,0x58,0x9e,0x80,0x15,0x61,0x89,0x80,0x18,0x58,0xcb,0x80,0x15,0x61,0x89,0x80,	// 00000B00
	0x18,0x58,0xf8,0x80,0x15,0x61,0x89,0x80,0x18,0x59,0x25,0x80,0x15,0x61,0x89,0x80,	// 00000B10
	0x18,0x59,0x52,0x80,0x15,0x61,0x89,0x80,0x18,0x59,0x7f,0x80,0x15,0x61,0x89,0x80,	// 00000B20
	0x18,0x59,0xac,0x80,0x15,0x61,0x89,0x80,0x18,0x59,0xd9,0x80,0x15,0x61,0x89,0x80,	// 00000B30
	0x18,0x5a,0x06,0x80,0xcf,0x01,0x83,0x89,0xd8,0x57,0xb1,0x83,0x3f,0x57,0xd5,0x80,	// 00000B40
	0x2a,0x61,0x8c,0x80,0x15,0x71,0xb5,0x80,0x1b,0x58,0x17,0x80,0x2a,0x61,0xe6,0x80,	// 00000B50
	0x15,0x71,0xb5,0x80,0x1b,0x58,0x71,0x80,0x2a,0x62,0x40,0x80,0x15,0x71,0xb5,0x80,	// 00000B60
	0x1b,0x58,0xcb,0x80,0x2a,0x62,0x9a,0x80,0x15,0x71,0xb5,0x80,0x1b,0x59,0x25,0x80,	// 00000B70
	0x2a,0x62,0xf4,0x80,0x15,0x71,0xb5,0x80,0x1b,0x59,0x7f,0x80,0x2a,0x63,0x4e,0x80,	// 00000B80
	0x15,0x71,0xb5,0x80,0x1b,0x59,0xd9,0x80,0x2a,0x63,0xa8,0x80,0x09,0x71,0xb5,0xbe,	// 00000B90
	0x5e,0x63,0xdb,0xdd,0xb4,0x61,0x89,0x83,0x39,0x00,0x54,0x81,0x83,0x33,0x00,0x51,	// 00000BA0
	0x42,0x90,0x38,0x00,0x44,0x49,0x0b,0x40,0x6c,0x14,0x4f,0x90,0x00,0x4f,0x90,0x00,	// 00000BB0
	0x40,0x6c,0x80,0x22,0x00,0x54,0x8c,0x80,0x2d,0x01,0x26,0xbd,0x0b,0x3b,0x62,0x14,	// 00000BC0
	0x49,0x83,0x0a,0x49,0x83,0x0a,0x3b,0x62,0x80,0x22,0x00,0x54,0x8c,0x0b,0x36,0x5a,	// 00000BD0
	0x14,0x45,0x78,0x10,0x45,0x78,0x10,0x36,0x5a,0x80,0x22,0x00,0x54,0x8c,0x0b,0x32,	// 00000BE0
	0x50,0x14,0x40,0x6c,0x14,0x40,0x6c,0x14,0x32,0x50,0x80,0x22,0x00,0x54,0x8c,0x0b,	// 00000BF0
	0x30,0x4c,0x14,0x3e,0x67,0x16,0x3e,0x67,0x16,0x30,0x4c,0x80,0x22,0x00,0x54,0x8c,	// 00000C00
	0x0b,0x2e,0x49,0x14,0x3c,0x63,0x17,0x3c,0x63,0x17,0x2e,0x49,0x80,0x22,0x00,0x54,	// 00000C10
	0x8c,0x0b,0x2c,0x45,0x14,0x3a,0x5e,0x18,0x3a,0x5e,0x18,0x2c,0x45,0x80,0x22,0x00,	// 00000C20
	0x54,0x8c,0x0b,0x2a,0x41,0x14,0x38,0x58,0x1a,0x38,0x58,0x1a,0x2a,0x41,0x80,0x22,	// 00000C30
	0x00,0x54,0x8c,0x0b,0x28,0x3c,0x14,0x36,0x52,0x1b,0x36,0x52,0x1b,0x28,0x3c,0x80,	// 00000C40
	0x22,0x00,0x54,0x8c,0x0b,0x26,0x37,0x14,0x34,0x4c,0x1c,0x34,0x4c,0x1c,0x26,0x37,	// 00000C50
	0x80,0x22,0x00,0x54,0x8c,0x0b,0x24,0x31,0x14,0x32,0x45,0x1d,0x32,0x45,0x1d,0x24,	// 00000C60
	0x31,0x80,0x22,0x00,0x54,0x8c,0x0b,0x21,0x2b,0x14,0x2f,0x3d,0x1e,0x2f,0x3d,0x1e,	// 00000C70
	0x21,0x2b,0x80,0x22,0x00,0x54,0x8c,0x0b,0x1f,0x24,0x14,0x2d,0x33,0x1f,0x2d,0x33,	// 00000C80
	0x1f,0x1f,0x24,0x80,0x16,0x00,0x54,0x8c,0x80,0xd2,0x00,0x53,0xaf,0x80,0x06,0x01,	// 00000C90
	0x26,0xc0,0x80,0x06,0x01,0x26,0xc0,0x80,0x21,0x00,0x54,0x8d,0x80,0x2d,0x01,0x29,	// 00000CA0
	0xf9,0x80,0x06,0x01,0x27,0x1a,0x80,0x06,0x01,0x27,0x1a,0x80,0x21,0x00,0x54,0x8d,	// 00000CB0
	0x80,0x06,0x01,0x27,0x47,0x80,0x06,0x01,0x27,0x47,0x80,0x24,0x01,0x26,0xc9,0x80,	// 00000CC0
	0x09,0x01,0x2a,0xad,0x80,0x21,0x00,0x54,0x8d,0x80,0x06,0x01,0x27,0xa1,0x80,0x06,	// 00000CD0
	0x01,0x27,0xa1,0x80,0x21,0x00,0x54,0x8d,0x80,0x06,0x01,0x27,0xce,0x80,0x06,0x01,	// 00000CE0
	0x27,0xce,0x80,0x21,0x00,0x54,0x8d,0x80,0x06,0x01,0x27,0xfb,0x80,0x06,0x01,0x27,	// 00000CF0
	0xfb,0x80,0x21,0x00,0x54,0x8d,0x80,0x06,0x01,0x28,0x28,0x80,0x06,0x01,0x28,0x28,	// 00000D00
	0x80,0x22,0x01,0x27,0x23,0x0b,0x52,0x1b,0x36,0x52,0x1b,0x36,0x52,0x1b,0x36,0x52,	// 00000D10
	0x1b,0x80,0x21,0x00,0x54,0x8d,0x80,0x06,0x01,0x28,0x82,0x80,0x06,0x01,0x28,0x82,	// 00000D20
	0x80,0x22,0x01,0x27,0x50,0x0b,0x45,0x1d,0x32,0x45,0x1d,0x32,0x45,0x1d,0x32,0x45,	// 00000D30
	0x1d,0x80,0x21,0x00,0x54,0x8d,0x80,0x06,0x01,0x28,0xdc,0x80,0x06,0x01,0x28,0xdc,	// 00000D40
	0x80,0x21,0x00,0x54,0x8d,0x80,0x06,0x01,0x29,0x09,0x80,0x06,0x01,0x29,0x09,0x87,	// 00000D50
	0x77,0x01,0x29,0x12,0x80,0x15,0x00,0x61,0x89,0x80,0x2d,0x01,0x33,0xad,0x80,0x18,	// 00000D60
	0x01,0x2a,0x53,0x80,0x15,0x00,0x61,0x89,0x80,0x18,0x01,0x2a,0x80,0x80,0x15,0x00,	// 00000D70
	0x61,0x89,0x80,0x18,0x01,0x2a,0xad,0x80,0x15,0x00,0x61,0x89,0x80,0x18,0x01,0x2a,	// 00000D80
	0xda,0x80,0x15,0x00,0x61,0x89,0x80,0x18,0x01,0x2b,0x07,0x80,0x15,0x00,0x61,0x89,	// 00000D90
	0x80,0x18,0x01,0x2b,0x34,0x80,0x15,0x00,0x61,0x89,0x80,0x18,0x01,0x2b,0x61,0x80,	// 00000DA0
	0x15,0x00,0x61,0x89,0x80,0x18,0x01,0x2b,0x8e,0x80,0x15,0x00,0x61,0x89,0x80,0x18,	// 00000DB0
	0x01,0x2b,0xbb,0x80,0x15,0x00,0x61,0x89,0x80,0x18,0x01,0x2b,0xe8,0x80,0x15,0x00,	// 00000DC0
	0x61,0x89,0x80,0x18,0x01,0x2c,0x15,0x80,0x15,0x00,0x61,0x89,0x80,0x18,0x01,0x2c,	// 00000DD0
	0x42,0x80,0xdb,0x00,0x63,0xd2,0x89,0xcc,0x01,0x29,0xf9,0x83,0x3f,0x01,0x2a,0x11,	// 00000DE0
	0x80,0x2a,0x01,0x33,0xc8,0x80,0x15,0x00,0x71,0xb5,0x80,0x1b,0x01,0x2a,0x53,0x80,	// 00000DF0
	0x2a,0x01,0x34,0x22,0x80,0x15,0x00,0x71,0xb5,0x80,0x1b,0x01,0x2a,0xad,0x80,0x2a,	// 00000E00
	0x01,0x34,0x7c,0x80,0x15,0x00,0x71,0xb5,0x80,0x1b,0x01,0x2b,0x07,0x80,0x2a,0x01,	// 00000E10
	0x34,0xd6,0x80,0x15,0x00,0x71,0xb5,0x80,0x1b,0x01,0x2b,0x61,0x80,0x2a,0x01,0x35,	// 00000E20
	0x30,0x80,0x15,0x00,0x71,0xb5,0x80,0x1b,0x01,0x2b,0xbb,0x80,0x2a,0x01,0x35,0x8a,	// 00000E30
	0x80,0x15,0x00,0x71,0xb5,0x80,0x1b,0x01,0x2c,0x15,0x80,0x2a,0x01,0x35,0xe4,0x80,	// 00000E40
	0xdb,0x00,0x73,0xfe,0xbd,0x8c,0x01,0x36,0xe9,0x98,0xf9,0x01,0x33,0xc5,0x80,0x0f,	// 00000E50
	0x00,0x51,0x42,0x80,0x8d,0x00,0x01,0x89,0x80,0x1b,0x01,0x9d,0x9a,0x80,0x06,0x00,	// 00000E60
	0x51,0x51,0x82,0x82,0x01,0x29,0xe7,0x80,0x09,0x00,0x56,0xca,0x80,0x75,0x01,0xa0,	// 00000E70
	0xdc,0x80,0x06,0x00,0x56,0xd3,0x80,0x18,0x00,0x01,0x89,0x06,0x7a,0x77,0x70,0x9a,	// 00000E80
	0x97,0x90,0x80,0x0f,0x01,0xa1,0x78,0x06,0x7a,0x77,0x70,0x00,0x00,0x00,0x82,0x85,	// 00000E90
	0x01,0x9e,0x54,0x80,0x7b,0x01,0xa0,0xdc,0x80,0x09,0x00,0x5a,0x0c,0x80,0x18,0x00,	// 00000EA0
	0x01,0x89,0x80,0x12,0x01,0xa1,0x78,0x80,0x06,0x01,0xa1,0x78,0x80,0x33,0x01,0xa1,	// 00000EB0
	0x8d,0x82,0x55,0x01,0x43,0xf4,0x80,0x1b,0x01,0xa4,0x7e,0x80,0x0f,0x01,0xa7,0x60,	// 00000EC0
	0x80,0x06,0x00,0x5a,0x03,0x80,0x09,0x01,0xa1,0x57,0x80,0x09,0x01,0xa4,0x93,0x80,	// 00000ED0
	0x06,0x00,0x56,0xca,0x80,0x0c,0x01,0xa7,0x81,0x80,0x0c,0x01,0xa7,0x66,0x80,0x21,	// 00000EE0
	0x01,0xa0,0xd3,0x80,0x21,0x01,0xa4,0x96,0x80,0x0c,0x00,0x4a,0xc1,0x80,0x39,0x01,	// 00000EF0
	0xa4,0xc3,0x82,0x6d,0x01,0xa1,0xc0,0x80,0x18,0x01,0xa7,0x69,0x80,0x12,0x01,0xa4,	// 00000F00
	0x12,0x80,0x15,0x01,0xaa,0xb7,0x80,0x1e,0x01,0xaa,0xd5,0x80,0x72,0x01,0xa4,0x8a,	// 00000F10
	0x82,0xf4,0x01,0xa8,0x38,0x80,0x12,0x00,0x4a,0xc1,0x82,0xa6,0x01,0xa8,0x02,0x80,	// 00000F20
	0x09,0x00,0x56,0xc7,0x80,0x12,0x01,0xb1,0x1d,0x80,0x0c,0x00,0x56,0xcd,0x80,0x12,	// 00000F30
	0x01,0xb1,0x2f,0x80,0x0c,0x01,0xa7,0x66,0x80,0x0c,0x01,0xb1,0x41,0x82,0xee,0x01,	// 00000F40
	0xaa,0xf9,0x80,0x18,0x01,0xb4,0x59,0x80,0x18,0x01,0xa7,0x63,0x80,0x12,0x01,0xa7,	// 00000F50
	0x60,0x80,0x21,0x01,0xa4,0x12,0x80,0x66,0x01,0xa7,0xd2,0x82,0x73,0x01,0xa4,0xfc,	// 00000F60
	0x80,0x84,0x01,0xb4,0x5f,0x82,0xb5,0x01,0xab,0x2f,0x80,0x15,0x01,0xb1,0x20,0x80,	// 00000F70
	0x0c,0x01,0xa7,0x81,0x80,0x18,0x01,0xba,0xe9,0x80,0x0c,0x01,0xa4,0x0c,0x80,0x0f,	// 00000F80
	0x01,0xa7,0x99,0x80,0x2d,0x01,0xa4,0x84,0x83,0x39,0x01,0xa1,0x75,0x83,0x3f,0x01,	// 00000F90
	0x9e,0x36,0x83,0x87,0x01,0x9a,0xfd,0x82,0x55,0x01,0x43,0xf4,0x06,0x58,0x56,0x50,	// 00000FA0
	0x7a,0x77,0x70,0x80,0x78,0x01,0xc7,0xac,0x06,0x58,0x56,0x50,0x00,0x00,0x00,0x80,	// 00000FB0
	0x18,0x00,0x01,0x89,0x80,0x15,0x01,0xc7,0xa9,0x80,0x06,0x01,0xc8,0x27,0x82,0x85,	// 00000FC0
	0x01,0x9e,0x54,0x80,0x7b,0x01,0xc7,0xac,0x80,0x06,0x01,0xc7,0xac,0x80,0x1e,0x01,	// 00000FD0
	0xa1,0x5a,0x80,0x18,0x01,0xcb,0x51,0x82,0x9d,0x01,0xc8,0x60,0x06,0xea,0xe7,0xe0,	// 00000FE0
	0x7a,0x77,0x70,0x80,0x0c,0x01,0xce,0x33,0x80,0x06,0x01,0xce,0x39,0x06,0xbd,0xba,	// 00000FF0
	0xb4,0xea,0xe7,0xe0,0x80,0x09,0x01,0xce,0x45,0x06,0xea,0xe7,0xe0,0xbd,0xba,0xb4,	// 00001000
	0x80,0x0f,0x01,0xce,0x4e,0x80,0x0c,0x01,0xce,0x36,0x80,0x0c,0x01,0xce,0x5d,0x80,	// 00001010
	0x36,0x01,0xcb,0x51,0x80,0x0c,0x00,0x4a,0xc1,0x82,0xbe,0x01,0xcb,0x93,0x80,0x0c,	// 00001020
	0x01,0xce,0x39,0x80,0x12,0x01,0xce,0x3f,0x80,0x15,0x01,0xce,0x30,0x80,0x15,0x01,	// 00001030
	0xd1,0x8a,0x82,0xf4,0x01,0xcb,0x5d,0x80,0x6f,0x01,0xd1,0x8d,0x80,0x12,0x00,0x4a,	// 00001040
	0xc1,0x80,0x33,0x01,0xa1,0x8a,0x82,0x58,0x01,0x33,0xc5,0x80,0x1b,0x01,0xce,0x21,	// 00001050
	0x80,0x09,0x01,0xce,0x60,0x80,0x12,0x01,0xd7,0xed,0x80,0x06,0x01,0xc7,0xac,0x80,	// 00001060
	0x06,0x01,0xce,0x51,0x80,0x12,0x01,0xd7,0xff,0x80,0x0c,0x01,0xce,0x36,0x80,0x0c,	// 00001070
	0x01,0xd8,0x11,0x82,0xee,0x01,0xcb,0x51,0x80,0x18,0x01,0xdb,0x29,0x80,0x18,0x01,	// 00001080
	0xce,0x33,0x80,0x12,0x01,0xce,0x30,0x80,0x1b,0x01,0xd1,0xc3,0x82,0xdf,0x01,0xce,	// 00001090
	0x9c,0x80,0x84,0x01,0xdb,0x2f,0x82,0xb5,0x01,0xcb,0x87,0x80,0x15,0x01,0xd7,0xf0,	// 000010A0
	0x80,0x0c,0x01,0xce,0x51,0x80,0x18,0x01,0xe1,0xb9,0x80,0x06,0x01,0xce,0x54,0x80,	// 000010B0
	0x12,0x01,0xce,0x4b,0x80,0x30,0x01,0xcb,0x51,0x80,0x30,0x01,0xc8,0x45,0x82,0x70,	// 000010C0
	0x01,0x26,0xbd,0x80,0x99,0x01,0xca,0xe5,0x80,0x30,0x01,0x9e,0x36,0x82,0x73,0x00,	// 000010D0
	0x51,0x42,0x80,0x9c,0x01,0xc7,0xa9,0x83,0x66,0x00,0x47,0x85,0x83,0x09,0x01,0xeb,	// 000010E0
	0xd9,0x83,0x4e,0x01,0xeb,0xd0,0x06,0x40,0x3e,0x38,0x40,0x3e,0x38,0x81,0x4d,0x01,	// 000010F0
	0xf2,0x5a,0x80,0x7b,0x01,0xeb,0xd9,0x81,0x20,0x01,0xf2,0x96,0x80,0x18,0x01,0x9d,	// 00001100
	0x9a,0x80,0x06,0x00,0x51,0x51,0x80,0x1e,0x01,0xf5,0x48,0x81,0x6e,0x01,0xeb,0xd0,	// 00001110
	0x09,0xb5,0xb2,0xac,0xea,0xe7,0xe0,0xea,0xe7,0xe0,0x80,0x15,0x01,0xf6,0xef,0x06,	// 00001120
	0xb5,0xb2,0xac,0x5a,0x57,0x50,0x80,0x06,0x01,0xf6,0xf8,0x80,0x12,0x01,0xf6,0xf8,	// 00001130
	0x80,0x09,0x01,0xe1,0xdd,0x80,0x0f,0x01,0xf7,0x2b,0x80,0x0f,0x01,0xf7,0x22,0x80,	// 00001140
	0x09,0x01,0xf7,0x13,0x81,0x29,0x01,0xed,0xe6,0x80,0x12,0x01,0xc7,0xa9,0x80,0x0c,	// 00001150
	0x01,0xc8,0x5a,0x80,0x1e,0x01,0xf8,0x87,0x81,0x6b,0x01,0xf2,0x4b,0x80,0x0c,0x01,	// 00001160
	0xf7,0x58,0x80,0x12,0x01,0xfa,0x2e,0x80,0x18,0x01,0xfa,0x46,0x80,0x12,0x01,0xfa,	// 00001170
	0x25,0x80,0x24,0x01,0xfa,0x2e,0x81,0x26,0x01,0xf4,0x22,0x80,0x18,0x01,0xca,0xe2,	// 00001180
	0x80,0x09,0x01,0xa1,0x8d,0x12,0x7a,0x77,0x70,0xb5,0xb3,0xac,0xa0,0x9d,0x97,0x7a,	// 00001190
	0x77,0x70,0xa0,0x9d,0x97,0xb5,0xb3,0xac,0x80,0x0f,0x01,0xa1,0x8a,0x81,0x68,0x01,	// 000011A0
	0xeb,0xd6,0x80,0x2a,0x01,0xfa,0x3a,0x80,0x21,0x01,0xfa,0x58,0x80,0x06,0x01,0xf7,	// 000011B0
	0x10,0x80,0x21,0x01,0xfa,0x7f,0x81,0x23,0x01,0xed,0xec,0x80,0x0c,0x01,0xce,0x4e,	// 000011C0
	0x80,0x09,0x01,0xce,0x60,0x80,0x0c,0x01,0xfb,0xd8,0x0c,0xa0,0x9d,0x97,0xea,0xe7,	// 000011D0
	0xe0,0xb5,0xb3,0xac,0xea,0xe7,0xe0,0x80,0x06,0x01,0xfb,0xe7,0x81,0x77,0x01,0xf8,	// 000011E0
	0xba,0x80,0x0f,0x01,0xfa,0x6d,0x80,0x15,0x01,0xfa,0x46,0x80,0x0f,0x01,0xf7,0x49,	// 000011F0
	0x80,0x1e,0x01,0xfa,0x25,0x80,0x0f,0x02,0x00,0xa6,0x80,0x0c,0x01,0xfd,0xb2,0x81,	// 00001200
	0x2c,0x01,0xfa,0x9d,0x80,0x0f,0x01,0xd8,0x35,0x80,0x0c,0x01,0xfb,0xd8,0x80,0x06,	// 00001210
	0x01,0xfb,0xe1,0x80,0x06,0x01,0xff,0x23,0x80,0x12,0x01,0xcb,0x93,0x81,0xb0,0x01,	// 00001220
	0xfc,0x02,0x80,0x09,0x01,0xf6,0xef,0x81,0x47,0x01,0xfd,0xbb,0x80,0x09,0x01,0xd8,	// 00001230
	0x0b,0x80,0x15,0x01,0xfb,0xcf,0x81,0x89,0x01,0xff,0x20,0x80,0x48,0x02,0x03,0xe5,	// 00001240
	0x80,0x15,0x01,0xf7,0x4f,0x82,0xdc,0x01,0xfa,0x8e,0x80,0x2a,0x01,0xf6,0xfe,0x80,	// 00001250
	0x0c,0x01,0xf7,0x10,0x80,0x0c,0x02,0x00,0xa0,0x80,0x21,0x01,0xf7,0x34,0x80,0x0f,	// 00001260
	0x02,0x01,0x09,0x82,0xca,0x01,0xf7,0x64,0x83,0x3c,0x01,0xf3,0xb6,0x85,0x13,0x01,	// 00001270
	0xed,0x3e,0x86,0xa2,0x00,0x44,0x49,0xad,0x1b,0x01,0xec,0x03,0x80,0x1b,0x01,0xf5,	// 00001280
	0x48,0x83,0x24,0x00,0x01,0x89,0x80,0x12,0x01,0xa0,0xd9,0x80,0x42,0x01,0xc1,0xaf,	// 00001290
	0x82,0xe8,0x00,0x01,0x89,0x12,0x10,0x50,0xe0,0x03,0x22,0x6c,0x07,0x32,0x94,0x10,	// 000012A0
	0x50,0xe0,0x07,0x32,0x94,0x03,0x22,0x6c,0x80,0x1e,0x01,0xa4,0x93,0x83,0x0f,0x02,	// 000012B0
	0x4d,0x11,0x06,0x07,0x32,0x94,0x00,0x00,0x00,0x80,0x09,0x02,0x53,0x5c,0x80,0x09,	// 000012C0
	0x01,0xa4,0x93,0x80,0xa8,0x02,0x49,0xba,0x80,0x09,0x01,0x9e,0x51,0x82,0x13,0x02,	// 000012D0
	0x53,0x74,0x80,0x60,0x02,0x4f,0xc0,0x80,0x0c,0x02,0x53,0x59,0x80,0x0f,0x01,0xa4,	// 000012E0
	0x90,0x80,0x45,0x01,0xc7,0xa9,0x80,0x5d,0x01,0xca,0xe2,0x80,0x0f,0x01,0xc8,0x5a,	// 000012F0
	0x80,0x45,0x01,0xa0,0xd9,0x80,0x5d,0x01,0xa4,0x12,0x80,0x09,0x00,0x56,0xd3,0x80,	// 00001300
	0x06,0x00,0x00,0x25,0x06,0x05,0x26,0x77,0x09,0x38,0xa4,0x80,0x3f,0x02,0x58,0x18,	// 00001310
	0x80,0x06,0x00,0x56,0xc7,0x80,0x57,0x02,0x58,0x5d,0x06,0x05,0x26,0x77,0x00,0x00,	// 00001320
	0x00,0x80,0xba,0x02,0x58,0x0c,0x80,0x75,0x02,0x52,0xff,0x80,0x48,0x01,0xca,0xe2,	// 00001330
	0x80,0x60,0x01,0xca,0xe2,0x80,0x0c,0x01,0xa1,0x8d,0x80,0x48,0x01,0xa4,0x51,0x80,	// 00001340
	0x60,0x01,0xa4,0x39,0x80,0x0c,0x02,0x57,0x5b,0x80,0x9f,0x02,0x58,0x18,0x80,0x0f,	// 00001350
	0x02,0x58,0x06,0x80,0xb1,0x02,0x5b,0x51,0x80,0x78,0x02,0x4f,0xc3,0x80,0x18,0x01,	// 00001360
	0xc7,0xac,0x80,0x0f,0x01,0xd8,0x11,0x80,0x21,0x01,0xd1,0xc0,0x80,0x24,0x01,0xdb,	// 00001370
	0x11,0x80,0x0f,0x01,0xd8,0x35,0x80,0x2d,0x01,0xd8,0x2c,0x80,0x21,0x02,0x5a,0x97,	// 00001380
	0x80,0x0f,0x01,0xb1,0x41,0x80,0x21,0x01,0xaa,0xf0,0x80,0x24,0x01,0xb4,0x41,0x80,	// 00001390
	0x0f,0x01,0xb1,0x65,0x80,0x2d,0x01,0xb1,0x5c,0x80,0x21,0x02,0x5b,0x48,0x80,0x06,	// 000013A0
	0x02,0x58,0xb7,0x80,0x06,0x02,0x58,0x15,0x80,0x06,0x00,0x56,0xc7,0x80,0x1b,0x02,	// 000013B0
	0x58,0x5a,0x80,0x21,0x02,0x5e,0xb7,0x80,0x06,0x00,0x56,0xc7,0x80,0x0c,0x02,0x5e,	// 000013C0
	0xa5,0x80,0x0c,0x02,0x58,0x57,0x80,0x0f,0x02,0x5e,0xf9,0x80,0x36,0x02,0x5b,0xe4,	// 000013D0
	0x80,0x99,0x02,0x5e,0xa5,0x80,0x78,0x02,0x4c,0x87,0x80,0x30,0x01,0xdb,0x11,0x80,	// 000013E0
	0x3c,0x02,0x5d,0x5b,0x80,0x0f,0x01,0xd1,0x87,0x80,0x0f,0x01,0xce,0x6f,0x80,0x1e,	// 000013F0
	0x01,0xd1,0xc3,0x80,0x21,0x02,0x5a,0x97,0x80,0x1e,0x01,0xb4,0x5f,0x80,0x36,0x02,	// 00001400
	0x5e,0x12,0x80,0x0f,0x01,0xaa,0xb7,0x80,0x0f,0x01,0xa7,0x9f,0x80,0x1e,0x01,0xa7,	// 00001410
	0x4e,0x80,0x21,0x02,0x5b,0x48,0x80,0x0c,0x02,0x5e,0xb1,0x80,0x48,0x02,0x5e,0xb1,	// 00001420
	0x80,0x0f,0x02,0x5e,0xb1,0x80,0x0f,0x02,0x62,0x3b,0x80,0x1e,0x02,0x5e,0xb7,0x80,	// 00001430
	0xba,0x02,0x61,0xc0,0x80,0x78,0x02,0x49,0x4b,0x83,0x9f,0x02,0x60,0x67,0x80,0x0c,	// 00001440
	0x01,0xce,0x54,0x80,0xa5,0x02,0x60,0xd6,0x80,0x0c,0x01,0xa7,0x84,0x80,0xa5,0x02,	// 00001450
	0x61,0x87,0x80,0x09,0x01,0xa0,0xd3,0x80,0xa8,0x02,0x62,0x35,0x80,0x4e,0x02,0x68,	// 00001460
	0xa4,0x80,0x5a,0x00,0x01,0x89,0x80,0x18,0x01,0xf8,0x87,0x83,0x21,0x02,0x60,0x61,	// 00001470
	0x80,0x1b,0x01,0xfb,0xde,0x83,0x27,0x02,0x6a,0x15,0x80,0x15,0x01,0xff,0x20,0x80,	// 00001480
	0x2a,0x02,0x5d,0x25,0x80,0x24,0x01,0xd8,0x35,0x80,0x30,0x02,0x5d,0x2b,0x80,0x12,	// 00001490
	0x01,0xe1,0xdd,0x80,0x4b,0x02,0x5d,0xb5,0x80,0x24,0x01,0xb1,0x65,0x80,0x30,0x02,	// 000014A0
	0x5d,0xdc,0x80,0x12,0x01,0xbb,0x0d,0x80,0x4b,0x02,0x5e,0x66,0x80,0x24,0x02,0x5f,	// 000014B0
	0x11,0x80,0x30,0x02,0x5e,0x8d,0x80,0x0c,0x01,0xa0,0xd0,0x80,0x51,0x02,0x5f,0x11,	// 000014C0
	0x80,0x8d,0x02,0x72,0x19,0x80,0x5d,0x02,0x6c,0xdf,0x80,0x15,0x02,0x02,0x5c,0x83,	// 000014D0
	0x24,0x02,0x59,0xe9,0x80,0x1e,0x02,0x70,0x75,0x83,0x1e,0x02,0x56,0xb3,0x80,0x1e,	// 000014E0
	0x02,0x6d,0x39,0x83,0x1e,0x00,0x01,0x89,0x80,0x1e,0x02,0x69,0xfd,0x86,0x5a,0x02,	// 000014F0
	0x46,0x87,0x89,0xbd,0x01,0xe8,0x9d,0xad,0x84,0x02,0x87,0x22,0x80,0x21,0x00,0x51,	// 00001500
	0x42,0x80,0x8a,0x01,0xeb,0xd9,0x80,0x36,0x02,0xbb,0x1e,0x81,0xe6,0x02,0xbb,0xc9,	// 00001510
	0x80,0x75,0x01,0xee,0xe5,0x80,0x21,0x00,0x54,0x7e,0x80,0x8d,0x01,0xee,0x82,0x80,	// 00001520
	0x33,0x02,0xbe,0x5d,0x81,0xe6,0x02,0xbf,0x05,0x80,0x78,0x02,0xbd,0xe5,0x80,0x1e,	// 00001530
	0x00,0x57,0xbd,0x80,0x8d,0x01,0xee,0x82,0x80,0x33,0x02,0xc1,0x99,0x81,0xe6,0x02,	// 00001540
	0xc2,0x41,0x80,0xcc,0x02,0xc1,0x21,0x80,0x09,0x00,0x06,0xb1,0x80,0x1b,0x02,0xc5,	// 00001550
	0x23,0x06,0x47,0x44,0x3d,0x5a,0x57,0x50,0x80,0x12,0x02,0xc5,0x44,0x83,0x00,0x02,	// 00001560
	0xc2,0x29,0x80,0x09,0x00,0x00,0x3c,0x80,0x12,0x02,0xc8,0x62,0x80,0x0f,0x00,0x00,	// 00001570
	0x3c,0x80,0x12,0x02,0xc8,0x80,0x82,0xc4,0x02,0xc2,0x29,0x80,0x0f,0x02,0xc5,0x29,	// 00001580
	0x80,0x2d,0x02,0xc5,0x0b,0x80,0x0f,0x02,0xc8,0x65,0x06,0x47,0x44,0x3d,0x2a,0x27,	// 00001590
	0x20,0x80,0x0c,0x02,0xc5,0x4d,0x80,0x0f,0x02,0xc8,0x86,0x80,0x3f,0x02,0xc5,0x59,	// 000015A0
	0x80,0x1b,0x02,0xcb,0x65,0x81,0xe6,0x02,0xcb,0xf5,0x80,0xdb,0x02,0xc7,0x99,0x80,	// 000015B0
	0x0f,0x02,0xc8,0x62,0x82,0xe2,0x02,0xc8,0x83,0x80,0x3c,0x01,0xeb,0xd9,0x80,0x06,	// 000015C0
	0x02,0xcb,0xb0,0x80,0x0f,0x00,0x61,0x80,0x80,0x18,0x02,0xc5,0x4d,0x83,0x12,0x02,	// 000015D0
	0xc5,0x56,0x83,0x39,0x02,0xc1,0xf0,0x83,0x03,0x02,0xc1,0xed,0x80,0x3c,0x02,0xcd,	// 000015E0
	0xfc,0x80,0x6f,0x02,0xc1,0xf0,0x80,0x18,0x02,0xc8,0x98,0x81,0xe6,0x02,0xdc,0x21,	// 000015F0
	0x87,0x0b,0x02,0xd4,0x89,0xb0,0xcc,0x02,0xd5,0x1c,0x80,0x12,0x02,0xcb,0xb0,0x83,	// 00001600
	0x2a,0x02,0xd2,0x3a,0x80,0x1e,0x02,0xc8,0x83,0x83,0x00,0x02,0xc8,0x92,0x80,0x3f,	// 00001610
	0x03,0x19,0x32,0x83,0x0f,0x02,0xcb,0xd1,0x82,0xfd,0x03,0x19,0x44,0x83,0x87,0x03,	// 00001620
	0x15,0xc9,0xc0,0xa1,0x02,0xd5,0x64,0x83,0x30,0x02,0xc5,0x29,0x80,0x15,0x02,0xc8,	// 00001630
	0x74,0x86,0x63,0x02,0xc8,0x6e,0x80,0x1b,0x03,0x6a,0x11,0x89,0x51,0x02,0xce,0xec,	// 00001640
	0x83,0x39,0x02,0xbe,0x5d,0x83,0x3c,0x02,0xbb,0x1e,0x83,0xf3,0x01,0xec,0x1e,0x81,	// 00001650
	0x56,0x02,0x49,0xba,0x80,0x9c,0x02,0xbb,0x2d,0x81,0x4a,0x01,0xee,0xc7,0x81,0x59,	// 00001660
	0x00,0x09,0xe7,0x91,0x3a,0x03,0x85,0xb6,0x80,0xae,0x02,0x53,0x74,0x81,0xb3,0x03,	// 00001670
	0x87,0x72,0x80,0x84,0x01,0x9d,0x9a,0x80,0x27,0x01,0xf3,0xaa,0x80,0x30,0x00,0x4a,	// 00001680
	0xb8,0x80,0xae,0x02,0x56,0xb0,0x81,0xb3,0x03,0x87,0x72,0x80,0x87,0x01,0xc7,0xa6,	// 00001690
	0x80,0x57,0x03,0x9d,0x14,0x80,0xab,0x02,0x59,0xef,0x81,0xb6,0x03,0x9e,0x16,0x80,	// 000016A0
	0x84,0x01,0xca,0xe5,0x9a,0x37,0x03,0xa0,0x50,0x83,0x39,0x03,0x9d,0x6b,0x83,0x3c,	// 000016B0
	0x03,0x9a,0x2c,0x84,0x11,0x03,0x83,0x88,0x8b,0xfd,0x02,0x88,0x15,0xaa,0x03,0x01,	// 000016C0
	0xf2,0x5a,0x42,0x4d,0x6e,0x09,0x01,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,	// 000016D0
	0x00,0x28,0x00,0x00,0x00,0x13,0x01,0x00,0x00,0x52,0x00,0x00,0x00,0x01,0x00,0x18,	// 000016E0
	0x80,0x05,0x05,0x04,0x38,0x09,0x01,0x00,0x80,0x05,0x05,0xd4,0x26,0x25,0x05,0x40,	// 000016F0
	0x3e,0x38,0x00,0x00,0x80,0x19,0x54,0x3e,0x80,0x1e,0x54,0x51,0x83,0x03,0x00,0x25,	// 00001700
	0x06,0x09,0x38,0xa4,0x10,0x50,0xe0,0x80,0x0c,0x57,0x93,0x05,0x09,0x38,0xa4,0x00,	// 00001710
	0x00,0x80,0x25,0x57,0x89,0x83,0x00,0x00,0x25,0x80,0x0f,0x57,0x93,0x80,0x06,0x57,	// 00001720
	0x93,0x80,0x0c,0x5a,0xc3,0x0f,0x03,0x22,0x6c,0x07,0x32,0x94,0x10,0x50,0xe0,0x07,	// 00001730
	0x32,0x94,0x03,0x22,0x6c,0x80,0x0c,0x5a,0xde,0x83,0x03,0x57,0xcc,0x05,0x03,0x22,	// 00001740
	0x6c,0x00,0x00,0x80,0x07,0x00,0x25,0x80,0x0f,0x5a,0xf9,0x80,0x06,0x5a,0xf3,0x05,	// 00001750
	0x00,0x00,0x00,0x07,0x32,0x80,0x07,0x5e,0x2b,0x83,0x0f,0x5a,0xfc,0x80,0x09,0x5e,	// 00001760
	0x08,0x80,0x06,0x5a,0xf9,0x80,0x0f,0x5a,0xde,0x80,0x0c,0x5e,0x26,0x80,0x0f,0x5a,	// 00001770
	0xdb,0x83,0x09,0x57,0xcc,0x80,0x09,0x61,0x50,0x83,0x30,0x5e,0x1a,0x83,0x36,0x5a,	// 00001780
	0xd2,0x83,0x39,0x57,0x90,0x83,0x3c,0x54,0x51,0x83,0x5d,0x54,0x51,0x06,0x58,0x56,	// 00001790
	0x50,0x7a,0x77,0x70,0x80,0x0c,0x74,0xcd,0x05,0x58,0x56,0x50,0x00,0x00,0x83,0x25,	// 000017A0
	0x57,0xc5,0x15,0x7a,0x77,0x70,0xb5,0xb3,0xac,0xa0,0x9d,0x97,0x7a,0x77,0x70,0xa0,	// 000017B0
	0x9d,0x97,0xb5,0xb3,0xac,0x7a,0x77,0x70,0x83,0x27,0x5a,0xff,0x80,0x06,0x78,0x0f,	// 000017C0
	0x09,0xea,0xe7,0xe0,0xb5,0xb3,0xac,0xea,0xe7,0xe0,0x80,0x06,0x78,0x0c,0x83,0x27,	// 000017D0
	0x5e,0x3b,0x80,0x06,0x74,0xcd,0x80,0x06,0x7b,0x4b,0x80,0x06,0x78,0x15,0x83,0x12,	// 000017E0
	0x7b,0x54,0x80,0x18,0x64,0x86,0x83,0x24,0x7b,0x42,0x83,0x36,0x77,0xee,0x83,0x39,	// 000017F0
	0x74,0xac,0x83,0x3f,0x54,0x51,0x83,0x39,0x00,0x25,0x80,0x06,0x74,0xca,0x05,0x58,	// 00001800
	0x56,0x50,0x58,0x56,0x80,0x10,0x91,0xc7,0x80,0x21,0x91,0xc2,0x83,0x00,0x00,0x25,	// 00001810
	0x80,0x0f,0x74,0xcd,0x80,0x0c,0x74,0xcd,0x80,0x21,0x94,0xfe,0x86,0x3f,0x92,0x01,	// 00001820
	0x06,0x5a,0x57,0x50,0x7a,0x77,0x70,0x80,0x12,0x9b,0x79,0x80,0x21,0x9b,0x76,0x89,	// 00001830
	0x78,0x92,0x01,0x83,0x3c,0x91,0xc5,0x86,0x78,0x00,0x25,0x05,0x5a,0x57,0x50,0x5a,	// 00001840
	0x57,0x83,0x2e,0xae,0xe3,0x80,0x12,0xae,0xd8,0x05,0x40,0x3e,0x38,0x40,0x3e,0x80,	// 00001850
	0x0d,0xb2,0x28,0x80,0x7b,0xae,0xe1,0x80,0x1b,0xb2,0x26,0x81,0x26,0x54,0x87,0x80,	// 00001860
	0x0f,0xb2,0x35,0x80,0x81,0x54,0x87,0x80,0x0f,0xb2,0xc2,0x80,0x78,0xb4,0x90,0x80,	// 00001870
	0x21,0xb2,0xc5,0x80,0x06,0xb2,0x35,0x80,0x1e,0xb5,0x14,0x80,0x2d,0xae,0xd8,0x09,	// 00001880
	0xb5,0xb2,0xac,0xea,0xe7,0xe0,0xea,0xe7,0xe0,0x80,0x15,0xb5,0x7a,0x06,0xb5,0xb2,	// 00001890
	0xac,0x5a,0x57,0x50,0x80,0x06,0xb5,0x83,0x80,0x12,0xb5,0x83,0x80,0x06,0xb5,0x80,	// 000018A0
	0x80,0x12,0xb5,0xb3,0x80,0x0f,0xb5,0xad,0x80,0x09,0xb5,0x9e,0x80,0x24,0xb1,0xf3,	// 000018B0
	0x06,0x1c,0x1a,0x14,0x2a,0x27,0x20,0x81,0x1a,0xb6,0x10,0x05,0x1c,0x1a,0x14,0x00,	// 000018C0
	0x00,0x80,0x0d,0xae,0xe0,0x80,0x7e,0xb6,0x0a,0x80,0x12,0xb7,0x2d,0x80,0x84,0xb1,	// 000018D0
	0x93,0x80,0x18,0x74,0xca,0x80,0x24,0xb8,0x4d,0x80,0x2a,0xb2,0x17,0x80,0x0c,0xb5,	// 000018E0
	0xe3,0x80,0x12,0xb8,0xb9,0x80,0x18,0xb8,0xd1,0x80,0x12,0xb8,0xb0,0x80,0x24,0xb8,	// 000018F0
	0xb9,0x80,0x21,0xb2,0x20,0x05,0x00,0x00,0x00,0x2a,0x27,0x81,0x1b,0xb6,0x12,0x80,	// 00001900
	0x06,0xb6,0x10,0x80,0x12,0xb7,0x30,0x80,0x8a,0xb9,0xee,0x80,0x84,0xb4,0x90,0x80,	// 00001910
	0x18,0x94,0xfe,0x80,0x09,0xb8,0x68,0x80,0x18,0x78,0x06,0x80,0x30,0xb5,0x4d,0x80,	// 00001920
	0x2a,0xb8,0xc5,0x80,0x21,0xb8,0xe3,0x80,0x06,0xb5,0x9b,0x80,0x21,0xb9,0x0a,0x80,	// 00001930
	0x1e,0xb1,0xf9,0x81,0xbf,0xb9,0x49,0x80,0x87,0xb1,0x90,0x06,0x7a,0x77,0x70,0xbd,	// 00001940
	0xba,0xb4,0x80,0x09,0xb5,0xb9,0x05,0xbd,0xba,0xb4,0x7a,0x77,0x80,0x0d,0xbb,0xa3,	// 00001950
	0x80,0x15,0x7b,0x45,0x80,0x33,0xb8,0x89,0x80,0x0f,0xb8,0xf8,0x80,0x15,0xb8,0xd1,	// 00001960
	0x80,0x0f,0xb5,0xd4,0x80,0x1e,0xb8,0xb0,0x80,0x0f,0xbf,0x31,0x80,0x0c,0xbc,0x3d,	// 00001970
	0x80,0x24,0xb9,0x28,0x05,0x5a,0x57,0x50,0x2a,0x27,0x81,0x1b,0xbf,0xc3,0x80,0x15,	// 00001980
	0xba,0x6c,0x80,0x7b,0xbf,0xc4,0x80,0x99,0xba,0xfc,0x80,0x06,0xbe,0xce,0x80,0x06,	// 00001990
	0xbe,0xda,0x80,0x0f,0xbb,0xa1,0x80,0x15,0x7e,0x81,0x80,0x78,0xbb,0xc5,0x80,0x09,	// 000019A0
	0xb5,0x7a,0x82,0x88,0xbc,0x46,0x80,0x09,0xc2,0x07,0x80,0x15,0xbb,0x9b,0x80,0x48,	// 000019B0
	0xbe,0xec,0x80,0x48,0xc2,0x70,0x80,0x15,0xb5,0xda,0x82,0xdc,0xb9,0x19,0x80,0x2a,	// 000019C0
	0xb5,0x89,0x80,0x0c,0xb5,0x9b,0x80,0x0c,0xbf,0x2b,0x80,0x21,0xb5,0xbf,0x80,0x0f,	// 000019D0
	0xbf,0x94,0x82,0xca,0xb5,0xef,0x83,0x3c,0xb2,0x41,0x83,0x21,0xaf,0x05,0x83,0x33,	// 000019E0
	0xae,0xea,0x89,0xb4,0x00,0x25,0xaa,0x30,0xae,0xe1,0x42,0x4d,0x66,0x77,0x01,0x00,	// 000019F0
	0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x13,0x01,0x00,	// 00001A00
	0x00,0x74,0x00,0x00,0x00,0x01,0x00,0x18,0x80,0x05,0x05,0x04,0x30,0x77,0x01,0x00,	// 00001A10
	0x80,0x05,0x05,0x83,0x4a,0x25,0x05,0x5a,0x57,0x50,0x5a,0x57,0x83,0x2e,0x03,0x77,	// 00001A20
	0x96,0xd7,0x03,0x6c,0x05,0x40,0x3e,0x38,0x00,0x00,0x81,0x51,0x00,0x25,0x05,0x40,	// 00001A30
	0x3e,0x38,0x5a,0x57,0x81,0xe1,0x04,0xfa,0x09,0x00,0x00,0x00,0x58,0x56,0x50,0x7a,	// 00001A40
	0x77,0x70,0x81,0x4a,0x20,0xc1,0x05,0x58,0x56,0x50,0x00,0x00,0x81,0xb1,0x03,0x74,	// 00001A50
	0x80,0x36,0x20,0x88,0x81,0x4d,0x20,0xc1,0x80,0x06,0x20,0xc1,0x80,0x12,0x03,0x72,	// 00001A60
	0x80,0x45,0x1d,0x7f,0x80,0x0f,0x1e,0xd5,0x80,0xe1,0x1d,0x7f,0x80,0x21,0x1e,0xd5,	// 00001A70
	0x05,0x2a,0x27,0x20,0x5a,0x57,0x80,0x0d,0x26,0xae,0x80,0x18,0x26,0xc1,0x81,0xbc,	// 00001A80
	0x23,0xa3,0x80,0x42,0x20,0xbb,0x80,0x12,0x22,0x0e,0x80,0xde,0x20,0xbb,0x80,0x24,	// 00001A90
	0x22,0x0e,0x81,0xe9,0x26,0xb5,0x80,0x51,0x25,0x0b,0x80,0xe1,0x23,0xf7,0x80,0x24,	// 00001AA0
	0x29,0xd0,0x80,0x0c,0x2d,0x2d,0x80,0x18,0x26,0xbe,0x80,0x0f,0x2d,0x30,0x83,0x09,	// 00001AB0
	0x2a,0x27,0x80,0x2d,0x26,0xb8,0x83,0x0f,0x2d,0x5d,0x80,0x12,0x2d,0x30,0x80,0x21,	// 00001AC0
	0x33,0xa8,0x83,0x06,0x2a,0x27,0x81,0xe6,0x23,0x79,0x81,0x65,0x2b,0xd7,0x80,0x24,	// 00001AD0
	0x3a,0x1d,0x83,0x15,0x2d,0x60,0x80,0x24,0x03,0x75,0x83,0x12,0x2d,0x5d,0x80,0x0c,	// 00001AE0
	0x2d,0x2d,0x05,0x47,0x44,0x3d,0x5a,0x57,0x80,0x0a,0x2d,0x29,0x80,0x0f,0x40,0xaa,	// 00001AF0
	0x83,0x18,0x3d,0x89,0x05,0x47,0x44,0x3d,0x2a,0x27,0x80,0x13,0x40,0xb2,0x83,0x24,	// 00001B00
	0x40,0xb9,0x80,0x18,0x40,0xad,0x86,0x60,0x43,0xf5,0x80,0x0c,0x43,0xdd,0x80,0x18,	// 00001B10
	0x4d,0x91,0x83,0x24,0x3d,0x89,0x80,0x15,0x33,0xab,0x81,0xbc,0x30,0x96,0x81,0x5f,	// 00001B20
	0x28,0x9e,0x81,0xda,0x3d,0x65,0x81,0x56,0x25,0x5f,0x80,0x09,0x43,0xdd,0x80,0x27,	// 00001B30
	0x3a,0x1d,0x80,0x09,0x40,0xa7,0x83,0x81,0x20,0x76,0x83,0x3c,0x1d,0x7f,0x99,0xe0,	// 00001B40
	0x03,0x9f,0x9c,0x41,0x5e,0x2f,0x80,0x8a,0x1d,0x7f,0x80,0x1e,0x1e,0xd5,0x82,0x94,	// 00001B50
	0x03,0x6c,0x80,0x87,0x20,0xbb,0x80,0x21,0x22,0x0e,0x80,0x12,0x03,0x6c,0x81,0x29,	// 00001B60
	0x1d,0x7f,0x81,0x59,0x1e,0xd5,0x80,0x8a,0x23,0xf7,0x80,0x30,0x98,0x16,0x06,0x00,	// 00001B70
	0x00,0x00,0x1c,0x1a,0x14,0x80,0x33,0x3a,0x1d,0x80,0xed,0x9b,0x88,0x05,0x1c,0x1a,	// 00001B80
	0x14,0x00,0x00,0x81,0x57,0x03,0x74,0x80,0xbd,0x9a,0xc8,0x81,0x20,0x9b,0x88,0x80,	// 00001B90
	0x06,0x2d,0x2d,0x9b,0x3c,0x9c,0xab,0x80,0xb7,0x97,0x8f,0x82,0x82,0x9e,0xbe,0x80,	// 00001BA0
	0xba,0x94,0x50,0x82,0x82,0x9e,0xbe,0x80,0xba,0x06,0x00,0x81,0x2c,0x9e,0xbe,0x81,	// 00001BB0
	0xb3,0x1e,0xd5,0x81,0x86,0xc1,0xf5,0x80,0x06,0x9c,0xa8,0x81,0xef,0x00,0x25,0x80,	// 00001BC0
	0x0c,0x1e,0xd5,0x81,0x3b,0x9e,0xac,0x80,0x24,0x3a,0x32,0x80,0x1e,0x26,0xc1,0x80,	// 00001BD0
	0x78,0xca,0x17,0x80,0x3c,0x3a,0x1a,0x80,0x1e,0x2d,0x39,0x05,0x47,0x44,0x3d,0x47,	// 00001BE0
	0x44,0x80,0x10,0x4d,0xab,0x80,0x48,0xca,0x9b,0x80,0x90,0x9c,0x27,0x81,0x62,0xc8,	// 00001BF0
	0xb8,0x80,0xc9,0xcc,0xbd,0x80,0x21,0x3a,0x17,0x80,0x09,0x40,0xa7,0x80,0x1e,0x57,	// 00001C00
	0x39,0x80,0xba,0xcb,0x2b,0x80,0x0f,0x9f,0xe4,0x81,0x59,0xc8,0xb8,0x80,0xf0,0x9b,	// 00001C10
	0x88,0x80,0x0f,0x57,0x69,0x80,0x30,0x57,0x39,0x82,0xfd,0xce,0x7c,0x80,0xf3,0x9f,	// 00001C20
	0x00,0x84,0xbf,0xd2,0x6c,0x80,0x12,0x47,0x0a,0x80,0x12,0x4d,0xa6,0x80,0x0f,0x2d,	// 00001C30
	0x57,0x80,0x45,0xd1,0x88,0x80,0x15,0x47,0x0a,0x80,0x0f,0x40,0xad,0x80,0xba,0xce,	// 00001C40
	0x6a,0x81,0xf8,0xd8,0x81,0x80,0x0f,0x47,0x0d,0x80,0x12,0x57,0x39,0x80,0x45,0xcb,	// 00001C50
	0x2e,0x80,0x21,0xda,0xdf,0x82,0xa6,0xd7,0xc4,0x80,0x0f,0x4d,0x9a,0x80,0x0f,0x57,	// 00001C60
	0x36,0x80,0x0c,0x2d,0x2a,0x80,0x06,0x40,0xa7,0x80,0x48,0xda,0x9a,0x80,0x12,0xe0,	// 00001C70
	0xe2,0x80,0x0c,0x43,0xd4,0x80,0xdb,0xd1,0x85,0x81,0xe6,0xdb,0xdb,0x80,0x0f,0x50,	// 00001C80
	0xd0,0x80,0x4b,0xcb,0x2e,0x80,0x21,0xe4,0x1b,0x81,0x14,0xde,0x36,0x81,0xad,0xd8,	// 00001C90
	0xd8,0x80,0x0f,0x33,0xae,0x80,0x0f,0x40,0xa7,0x83,0x00,0xda,0xa3,0x86,0x78,0xd3,	// 00001CA0
	0xef,0x8f,0x8a,0xea,0x93,0x06,0xea,0xe7,0xe0,0xea,0xe7,0xe0,0x86,0x72,0x00,0xfd,	// 00001CB0
	0x5f,0x93,0x68,0x00,0xfa,0x1d,0x9c,0x50,0x01,0x13,0xfd,0x81,0x23,0x00,0x9b,0x85,	// 00001CC0
	0x81,0xf5,0x00,0xcf,0x45,0x80,0x21,0x00,0xcb,0xe5,0x81,0x56,0x00,0x1d,0x7f,0x81,	// 00001CD0
	0xe6,0x00,0xc6,0xe4,0xb6,0x42,0x00,0x5e,0x0e,0x80,0xb1,0x00,0x06,0x00,0x83,0x50,	// 00001CE0
	0x00,0x00,0x25,0x42,0x4d,0xb6,0x10,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x36,0x00,	// 00001CF0
	0x00,0x00,0x28,0x00,0x00,0x00,0x3a,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x01,0x80,	// 00001D00
	0x05,0x15,0x04,0x00,0x00,0x80,0x10,0x80,0x06,0x04,0x80,0x0c,0x24,0x04,0x2a,0x27,	// 00001D10
	0x20,0x2a,0x80,0xa4,0x37,0x81,0x74,0x2e,0x09,0x5a,0x57,0x50,0x5a,0x57,0x50,0x47,	// 00001D20
	0x44,0x3d,0x80,0x09,0x02,0x4c,0x80,0x06,0x00,0x36,0x06,0x47,0x44,0x3d,0x5a,0x57,	// 00001D30
	0x50,0x80,0x06,0x02,0x61,0x80,0x0c,0x02,0x70,0x80,0x0c,0x02,0x6a,0x80,0x06,0x02,	// 00001D40
	0x6a,0x80,0x09,0x02,0x58,0x80,0x12,0x00,0x36,0x80,0x12,0x02,0x76,0x80,0x06,0x02,	// 00001D50
	0x58,0x80,0x18,0x02,0xaf,0x80,0x29,0x00,0xcf,0x80,0x09,0x02,0x61,0x80,0x12,0x03,	// 00001D60
	0x08,0x80,0x0f,0x02,0x73,0x80,0x18,0x03,0x1a,0x80,0x21,0x02,0x9a,0x80,0x24,0x03,	// 00001D70
	0x5f,0x80,0xd3,0x02,0xdf,0x80,0x0f,0x02,0x8e,0x80,0x0c,0x03,0x08,0x80,0x0f,0x04,	// 00001D80
	0x71,0x80,0x09,0x02,0xc1,0x80,0x0f,0x03,0x08,0x80,0x6e,0x03,0x44,0x80,0x0f,0x03,	// 00001D90
	0x44,0x80,0x51,0x03,0x11,0x80,0x06,0x02,0x6a,0x80,0xaa,0x04,0xc8,0x80,0x15,0x02,	// 00001DA0
	0x6d,0x80,0x41,0x04,0x27,0x80,0x09,0x02,0x70,0x80,0x0f,0x02,0x85,0x80,0x0c,0x06,	// 00001DB0
	0x78,0x80,0x06,0x02,0x58,0x80,0x45,0x02,0x82,0x80,0x18,0x06,0xdb,0x81,0x83,0x00,	// 00001DC0
	0xcf,0x82,0x10,0x00,0x42,0x09,0xea,0xe7,0xe0,0xea,0xe7,0xe0,0xae,0xab,0xa6,0x80,	// 00001DD0
	0x09,0x0a,0x8c,0x80,0x06,0x00,0x36,0x06,0xae,0xab,0xa6,0xea,0xe7,0xe0,0x80,0x06,	// 00001DE0
	0x0a,0xa1,0x80,0x0c,0x0a,0xb0,0x80,0x0c,0x0a,0xaa,0x80,0x06,0x0a,0xaa,0x80,0x09,	// 00001DF0
	0x0a,0x98,0x80,0x12,0x00,0x36,0x80,0x12,0x0a,0xb6,0x80,0x06,0x0a,0x98,0x80,0x18,	// 00001E00
	0x0a,0xef,0x80,0x29,0x00,0xcf,0x80,0x09,0x0a,0xa1,0x80,0x12,0x0b,0x48,0x80,0x0f,	// 00001E10
	0x0a,0xb3,0x80,0x18,0x0b,0x5a,0x80,0x21,0x0a,0xda,0x80,0x24,0x0b,0x9f,0x80,0xd3,	// 00001E20
	0x0b,0x1f,0x80,0x0f,0x0a,0xce,0x80,0x0c,0x0b,0x48,0x80,0x0f,0x0c,0xb1,0x80,0x09,	// 00001E30
	0x0b,0x01,0x80,0x0f,0x0b,0x48,0x80,0x6e,0x0b,0x84,0x80,0x0f,0x0b,0x84,0x80,0x51,	// 00001E40
	0x0b,0x51,0x80,0x06,0x0a,0xaa,0x80,0xaa,0x0d,0x08,0x80,0x15,0x0a,0xad,0x80,0x41,	// 00001E50
	0x0c,0x67,0x80,0x09,0x0a,0xb0,0x80,0x0f,0x0a,0xc5,0x80,0x0c,0x0e,0xb8,0x80,0x06,	// 00001E60
	0x0a,0x98,0x80,0x45,0x0a,0xc2,0x80,0x18,0x0f,0x1b,0x81,0x77,0x00,0xcf,0x42,0x4d,	// 00001E70
	0x72,0x0f,0x00,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,0x00,	// 00001E80
	0x00,0x63,0x00,0x00,0x00,0x0d,0x00,0x00,0x00,0x01,0x00,0x18,0x80,0x05,0x04,0x04,	// 00001E90
	0x3c,0x0f,0x00,0x00,0x80,0x10,0x24,0x09,0x2a,0x27,0x20,0xbd,0xbd,0xbd,0xea,0xe7,	// 00001EA0
	0xe0,0x80,0x0c,0x3c,0x06,0xbd,0xbd,0xbd,0x2a,0x27,0x20,0x80,0x12,0x4e,0x80,0x06,	// 00001EB0
	0x3c,0x80,0x0c,0x5d,0x80,0x0f,0x3c,0x80,0x18,0x69,0x80,0x36,0x4b,0x80,0x09,0x4b,	// 00001EC0
	0x80,0x36,0x39,0x80,0x1b,0x00,0x39,0x80,0x2a,0x00,0x8a,0x80,0x09,0x00,0x4e,0x80,	// 00001ED0
	0x06,0x00,0x33,0x80,0x1b,0x00,0x6f,0x80,0x48,0x00,0x54,0x80,0xba,0x01,0x77,0x80,	// 00001EE0
	0x15,0x01,0x56,0x80,0x15,0x00,0x5a,0x80,0x21,0x00,0x54,0x80,0x1e,0x01,0x41,0x80,	// 00001EF0
	0x2d,0x02,0x9a,0x80,0x2a,0x02,0xac,0x80,0x5d,0x03,0x0c,0x82,0xb2,0x02,0x73,0x80,	// 00001F00
	0x1b,0x00,0x3f,0x80,0x15,0x00,0x75,0x80,0x12,0x00,0x39,0x80,0x75,0x01,0x92,0x80,	// 00001F10
	0x1b,0x06,0x81,0x80,0x54,0x02,0x73,0x80,0x21,0x07,0x08,0x80,0x42,0x06,0x87,0x80,	// 00001F20
	0x33,0x01,0x23,0x80,0x96,0x02,0x31,0x80,0x51,0x02,0xfd,0x80,0x3f,0x03,0x78,0x80,	// 00001F30
	0x3c,0x08,0xc7,0x82,0x88,0x08,0x43,0x80,0x66,0x01,0x6b,0x80,0x21,0x08,0xd9,0x80,	// 00001F40
	0x4b,0x06,0x87,0x80,0x54,0x02,0x3d,0x80,0x48,0x00,0x39,0x80,0x24,0x01,0x23,0x80,	// 00001F50
	0x36,0x0c,0x5d,0x80,0x2d,0x06,0x81,0x80,0x24,0x00,0xd2,0x80,0x2a,0x00,0x39,0x80,	// 00001F60
	0x0f,0x01,0x56,0x81,0x26,0x0e,0x46,0x03,0x00,0x00,0x00,0x42,0x4d,0xb6,0x04,0x00,	// 00001F70
	0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x2a,0x00,	// 00001F80
	0x00,0x00,0x09,0x00,0x00,0x00,0x01,0x00,0x18,0x80,0x05,0x04,0x04,0x80,0x04,0x00,	// 00001F90
	0x00,0x80,0x10,0x24,0x09,0xea,0xe7,0xe0,0xae,0xab,0xa6,0x2a,0x27,0x20,0x80,0x12,	// 00001FA0
	0x3c,0x06,0xea,0xe7,0xe0,0xea,0xe7,0xe0,0x80,0x0c,0x4e,0x80,0x2a,0x60,0x80,0x12,	// 00001FB0
	0x24,0x80,0x04,0x0f,0x80,0x13,0x7c,0x80,0x06,0x51,0x80,0x15,0x39,0x80,0x1b,0x51,	// 00001FC0
	0x80,0x06,0x51,0x80,0x09,0xec,0x80,0x41,0x7b,0x80,0x15,0x00,0x36,0x80,0x6e,0x00,	// 00001FD0
	0xd1,0x80,0x12,0x00,0x36,0x80,0xeb,0x00,0xd1,0x80,0x66,0x00,0xbc,0x80,0x09,0x00,	// 00001FE0
	0x51,0x06,0x5a,0x57,0x50,0x5a,0x57,0x50,0x80,0x08,0x00,0xb1,0x80,0x69,0x00,0x39,	// 00001FF0
	0x80,0x14,0x03,0x22,0x80,0x2d,0x00,0x60,0x80,0x53,0x00,0x63,0x80,0x89,0x03,0xb6,	// 00002000
	0x42,0x4d,0x86,0x62,0x02,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,0x28,	// 00002010
	0x00,0x00,0x00,0x18,0x01,0x00,0x00,0xba,0x00,0x00,0x00,0x01,0x00,0x18,0x80,0x05,	// 00002020
	0x05,0x04,0x50,0x62,0x02,0x00,0x80,0x05,0x05,0x80,0xb0,0x25,0x06,0x58,0x56,0x50,	// 00002030
	0x7a,0x77,0x70,0x80,0x33,0xde,0x05,0x58,0x56,0x50,0x00,0x00,0x80,0x07,0x00,0x25,	// 00002040
	0x06,0x09,0x38,0xa4,0x10,0x50,0xe0,0x80,0x33,0x01,0x23,0x05,0x09,0x38,0xa4,0x00,	// 00002050
	0x00,0x82,0xc5,0x01,0x5c,0x80,0x36,0x00,0xde,0x80,0x06,0x00,0xde,0x80,0x09,0x00,	// 00002060
	0x25,0x80,0x36,0x01,0x23,0x80,0x06,0x01,0x23,0x86,0x96,0x01,0x5c,0x08,0x5a,0x57,	// 00002070
	0x50,0x5a,0x57,0x50,0x5a,0x57,0x80,0x0a,0x01,0x16,0x85,0xfd,0x08,0x04,0x05,0xea,	// 00002080
	0xe7,0xe0,0x7a,0x77,0x80,0x0a,0x11,0x48,0x80,0x06,0x11,0x55,0x80,0x09,0x11,0x52,	// 00002090
	0x09,0xbd,0xba,0xb4,0x7a,0x77,0x70,0xbd,0xba,0xb4,0x80,0x09,0x11,0x58,0x80,0x15,	// 000020A0
	0x04,0x59,0x80,0x06,0x04,0x65,0x80,0x09,0x11,0x8e,0x80,0x09,0x04,0x62,0x80,0x0c,	// 000020B0
	0x01,0x1a,0x80,0x09,0x01,0x59,0x82,0xe2,0x0e,0x73,0x80,0x0c,0x14,0x94,0x80,0x15,	// 000020C0
	0x14,0x8b,0x80,0x24,0x11,0x76,0x80,0x0c,0x14,0xd9,0x80,0x15,0x14,0xd0,0x86,0x36,	// 000020D0
	0x11,0xbb,0x80,0x06,0x11,0x6d,0x80,0x06,0x11,0x67,0x80,0x39,0x14,0xb5,0x80,0x06,	// 000020E0
	0x01,0x59,0x80,0x06,0x01,0x20,0x82,0xe2,0x14,0xfa,0x80,0x06,0x11,0x6d,0x80,0x0f,	// 000020F0
	0x14,0x9a,0x80,0x0c,0x11,0x73,0x80,0x24,0x14,0xb5,0x80,0x06,0x01,0x59,0x80,0x0f,	// 00002100
	0x14,0xdf,0x80,0x0f,0x11,0xb8,0x82,0xdf,0x0e,0x6d,0x80,0x0c,0x11,0x70,0x80,0x39,	// 00002110
	0x1e,0x78,0x80,0x12,0x11,0x82,0x82,0xf1,0x1e,0xc3,0x80,0x15,0x11,0x4c,0x80,0x0c,	// 00002120
	0x11,0x6d,0x80,0x39,0x11,0x6d,0x80,0x0c,0x11,0xb2,0x82,0xdf,0x11,0xb2,0x86,0x90,	// 00002130
	0x0a,0xb9,0x89,0xd2,0x28,0x41,0x80,0x87,0x00,0x25,0x85,0x67,0x35,0xe2,0x80,0xa2,	// 00002140
	0x00,0xdb,0x80,0x96,0x0a,0xb3,0x80,0x96,0x00,0xdb,0x81,0x2c,0x3f,0xc9,0x80,0xf0,	// 00002150
	0x03,0xd5,0x80,0x96,0x0a,0xb3,0x80,0x96,0x04,0x23,0x81,0x2c,0x43,0x11,0x80,0xdb,	// 00002160
	0x03,0xd5,0x80,0x15,0x0b,0x3a,0x81,0x1d,0x42,0x7b,0x81,0x3b,0x46,0x4a,0x86,0xe4,	// 00002170
	0x44,0xd3,0x80,0x0f,0x1e,0x81,0x80,0x3c,0x25,0x08,0x80,0x12,0x21,0xf0,0x80,0x24,	// 00002180
	0x25,0x56,0x80,0x21,0x45,0xa8,0x80,0x81,0x4e,0xff,0x80,0x1b,0x43,0x02,0x80,0x0c,	// 00002190
	0x11,0x49,0x80,0x1e,0x25,0x11,0x80,0x1b,0x04,0x59,0x80,0x0c,0x11,0x8e,0x80,0x1e,	// 000021A0
	0x25,0x56,0x80,0x21,0x42,0xf6,0x80,0x1b,0x1b,0x39,0x80,0x0c,0x14,0x97,0x80,0x09,	// 000021B0
	0x11,0x64,0x80,0x15,0x04,0x59,0x80,0x1b,0x1b,0x7e,0x80,0x0f,0x21,0xed,0x80,0x0c,	// 000021C0
	0x01,0x20,0x80,0x21,0x50,0xb2,0x80,0x0c,0x25,0x0b,0x80,0x0c,0x1b,0x3f,0x80,0x12,	// 000021D0
	0x11,0x5b,0x80,0x1b,0x50,0xfd,0x80,0x0c,0x25,0x50,0x80,0x0c,0x1b,0x84,0x80,0x12,	// 000021E0
	0x11,0xa0,0x80,0x7b,0x4e,0x90,0x80,0x3c,0x1e,0x75,0x80,0x18,0x51,0x21,0x80,0x21,	// 000021F0
	0x1e,0xc9,0x80,0x2d,0x4f,0x80,0x80,0x75,0x52,0x53,0x80,0x27,0x50,0x22,0x80,0x1e,	// 00002200
	0x1e,0x81,0x80,0x27,0x50,0x67,0x80,0x1e,0x1e,0xc6,0x80,0x21,0x42,0xf6,0x80,0x18,	// 00002210
	0x53,0x85,0x80,0x1e,0x54,0x1e,0x80,0x1e,0x11,0x7f,0x80,0x15,0x51,0x21,0x80,0x18,	// 00002220
	0x4f,0x3e,0x80,0x1b,0x54,0x00,0x80,0x18,0x53,0x7f,0x80,0x18,0x53,0x85,0x80,0x1e,	// 00002230
	0x4f,0x35,0x80,0x21,0x54,0xf9,0x83,0xba,0x51,0xd8,0x80,0x15,0x1e,0x81,0x80,0x12,	// 00002240
	0x4e,0xff,0x80,0x21,0x21,0xdb,0x80,0x21,0x52,0x92,0x80,0x12,0x14,0xe5,0x80,0x27,	// 00002250
	0x4f,0x7d,0x80,0x84,0x58,0xda,0x80,0x15,0x04,0x1a,0x80,0x0f,0x11,0x55,0x80,0x39,	// 00002260
	0x53,0x94,0x80,0x0c,0x11,0x9d,0x80,0x4b,0x53,0xd9,0x80,0x0c,0x50,0xf4,0x80,0x15,	// 00002270
	0x1b,0x30,0x80,0x27,0x11,0x79,0x80,0x09,0x01,0x20,0x80,0x15,0x1b,0x75,0x80,0x3c,	// 00002280
	0x54,0x8a,0x80,0x0f,0x5a,0x18,0x80,0x36,0x54,0xd5,0x80,0x0f,0x5a,0x5d,0x81,0x98,	// 00002290
	0x55,0x1a,0x09,0x2a,0x27,0x20,0x2a,0x27,0x20,0x2a,0x27,0x20,0x80,0xb4,0x53,0x73,	// 000022A0
	0x80,0x1e,0x1e,0x6f,0x80,0x27,0x54,0x45,0x80,0x1e,0x1e,0xb4,0x82,0x28,0x54,0x8a,	// 000022B0
	0x82,0x25,0x5d,0x42,0x80,0x0c,0x11,0x6d,0x80,0x18,0x5a,0x15,0x80,0x21,0x11,0x6d,	// 000022C0
	0x80,0x0c,0x11,0xb2,0x80,0x18,0x5a,0x5a,0x80,0x39,0x4f,0x68,0x80,0x81,0x62,0xaf,	// 000022D0
	0x80,0x1b,0x5d,0x42,0x80,0x18,0x1b,0x39,0x80,0x2d,0x53,0x9d,0x80,0x18,0x1b,0x7e,	// 000022E0
	0x80,0x33,0x53,0xe2,0x80,0x0f,0x1b,0x39,0x80,0x0f,0x64,0x80,0x80,0x27,0x25,0x17,	// 000022F0
	0x80,0x0f,0x1b,0x7e,0x80,0x0f,0x64,0xc5,0x80,0x33,0x50,0x04,0x80,0x12,0x62,0xc7,	// 00002300
	0x80,0x0c,0x11,0x67,0x80,0x12,0x64,0x83,0x80,0x21,0x4f,0x2f,0x80,0x0c,0x1b,0x7e,	// 00002310
	0x80,0x18,0x64,0xc2,0x81,0x92,0x48,0x00,0x80,0x1b,0x5d,0x42,0x83,0x2d,0x46,0x65,	// 00002320
	0x8b,0xf7,0x67,0x1a,0x81,0x29,0x38,0x9d,0x80,0x0f,0x5d,0x42,0x81,0x1d,0x38,0xa3,	// 00002330
	0x81,0x2c,0x78,0x18,0x83,0x0f,0x76,0x92,0x90,0x68,0x65,0xf1,0x80,0x12,0x5a,0x09,	// 00002340
	0x80,0x12,0x64,0x8f,0x80,0x27,0x14,0xaf,0x80,0x12,0x51,0x30,0x80,0x1e,0x5b,0x98,	// 00002350
	0x80,0x3c,0x63,0x24,0x80,0x0f,0x50,0x40,0x80,0x27,0x1b,0x3f,0x80,0x0f,0x62,0xf4,	// 00002360
	0x80,0x0f,0x50,0x85,0x80,0x1e,0x1b,0x84,0x80,0x15,0x5d,0x42,0x80,0x1e,0x8e,0x05,	// 00002370
	0x80,0x33,0x25,0x17,0x80,0x18,0x51,0xb4,0x80,0x30,0x64,0xe6,0x80,0x15,0x5b,0x56,	// 00002380
	0x80,0x18,0x65,0x13,0x80,0x21,0x21,0xe1,0x80,0x18,0x53,0xca,0x80,0x30,0x5b,0x0e,	// 00002390
	0x80,0x15,0x51,0x72,0x80,0x12,0x1b,0x2d,0x80,0x1e,0x11,0x73,0x80,0x15,0x51,0xb7,	// 000023A0
	0x80,0x12,0x1b,0x72,0x80,0x75,0x55,0x1a,0x80,0x1e,0x14,0x8b,0x80,0x30,0x8d,0x75,	// 000023B0
	0x80,0x1b,0x5e,0x41,0x80,0x45,0x52,0xb0,0x80,0x24,0x54,0xbd,0x80,0x3f,0x54,0xdb,	// 000023C0
	0x80,0x33,0x8e,0x68,0x80,0x3f,0x91,0x4d,0x80,0x2a,0x54,0xfc,0x80,0x24,0x42,0xf6,	// 000023D0
	0x80,0x15,0x90,0xb4,0x80,0x18,0x54,0xab,0x80,0x18,0x04,0x59,0x80,0x21,0x54,0x51,	// 000023E0
	0x80,0x27,0x55,0x14,0x80,0x1e,0x53,0x79,0x80,0x2d,0x1b,0x39,0x80,0x18,0x53,0xc4,	// 000023F0
	0x80,0x81,0x1b,0x7e,0x80,0x8d,0x90,0x99,0x80,0x2a,0x4e,0xe4,0x81,0x08,0x91,0x50,	// 00002400
	0x80,0x18,0x04,0x14,0x80,0x7e,0x92,0x70,0x80,0x27,0x90,0x8a,0x80,0x09,0x11,0x49,	// 00002410
	0x80,0x09,0x1e,0x6c,0x80,0x39,0x93,0x27,0x80,0x0c,0x1e,0xae,0x80,0x33,0x94,0x50,	// 00002420
	0x80,0x69,0x90,0x57,0x80,0x0f,0x50,0xf4,0x80,0x36,0x90,0xcf,0x80,0x15,0x01,0x1d,	// 00002430
	0x80,0x21,0x77,0x76,0x80,0x18,0x4e,0xf9,0x80,0x33,0x51,0x75,0x80,0x12,0x11,0xb8,	// 00002440
	0x80,0x2a,0x51,0xba,0x80,0x3c,0x91,0xc2,0x80,0x21,0x58,0xfe,0x80,0x24,0x54,0xf9,	// 00002450
	0x80,0x15,0x59,0x43,0x80,0x18,0x5d,0x42,0x80,0x18,0x92,0x70,0x80,0x1b,0x90,0xb4,	// 00002460
	0x80,0x2a,0x92,0xa3,0x80,0x1b,0x90,0xf9,0x80,0x1b,0x5d,0x3c,0x80,0x12,0x64,0x7d,	// 00002470
	0x80,0x33,0x98,0x79,0x80,0x12,0x64,0xc2,0x80,0x39,0x98,0xbe,0x80,0xdb,0x90,0x4b,	// 00002480
	0x80,0x2a,0x97,0xb6,0x80,0x72,0x54,0xba,0x80,0x96,0x91,0xc2,0x80,0x30,0x98,0xe8,	// 00002490
	0x80,0x66,0x92,0x88,0x80,0x1b,0x8e,0x7a,0x80,0x8a,0x91,0x47,0x83,0xa5,0x9a,0x23,	// 000024A0
	0x80,0x18,0x8d,0x60,0x80,0x2d,0x97,0x50,0x80,0x18,0x8d,0xa5,0x80,0x3c,0x97,0x95,	// 000024B0
	0x80,0x12,0x62,0xaf,0x80,0x33,0x65,0x25,0x80,0x12,0x62,0xf4,0x80,0x2a,0x65,0x6a,	// 000024C0
	0x80,0x21,0x99,0x7e,0x80,0x1e,0xa2,0x3f,0x80,0x27,0x64,0xa7,0x80,0x1e,0xa2,0x84,	// 000024D0
	0x80,0x2a,0x9b,0x88,0x80,0x15,0x51,0x66,0x80,0x18,0x51,0x63,0x80,0x21,0x21,0xe1,	// 000024E0
	0x80,0x18,0xa2,0x9c,0x80,0x18,0x5b,0x0e,0x80,0x1b,0x99,0x7e,0x80,0x3f,0x8e,0x95,	// 000024F0
	0x80,0x24,0x51,0xa8,0x80,0x27,0x63,0xba,0x80,0xdb,0x03,0xd5,0x80,0x1b,0x97,0xb6,	// 00002500
	0x81,0x17,0x66,0x99,0x81,0x3b,0xa5,0x72,0x8d,0x6e,0xa3,0xfb,0x81,0x23,0x76,0xf5,	// 00002510
	0x80,0x9c,0x77,0x7c,0x81,0xc2,0xb5,0xda,0x83,0x0f,0xb4,0xea,0x90,0x68,0xa4,0x49,	// 00002520
	0x80,0x1e,0x63,0xe1,0x80,0x33,0x50,0x4f,0x80,0x2a,0x8e,0xe0,0x80,0x33,0xa4,0xc4,	// 00002530
	0x80,0x7b,0x50,0x3d,0x80,0x1e,0x5d,0x42,0x80,0x18,0x5b,0x56,0x80,0x15,0x53,0x9d,	// 00002540
	0x80,0x27,0x5a,0x45,0x80,0x1b,0x5e,0x4d,0x80,0x24,0xa2,0xb7,0x80,0x15,0x65,0x25,	// 00002550
	0x80,0x1b,0x14,0x94,0x80,0x1b,0x8f,0xf1,0x80,0x18,0x51,0xb4,0x80,0x15,0x14,0xe2,	// 00002560
	0x80,0x2a,0x5d,0x3f,0x80,0x18,0x8d,0xf9,0x80,0x39,0x50,0x61,0x80,0x93,0x9d,0x3e,	// 00002570
	0x80,0x1e,0x8d,0x6f,0x80,0x30,0x96,0x7b,0x80,0x21,0x53,0xdf,0x80,0x33,0xcc,0x30,	// 00002580
	0x80,0x6f,0x53,0x91,0x80,0x1e,0x67,0x1a,0x80,0x15,0x90,0xb4,0x80,0x12,0x5a,0xc9,	// 00002590
	0x80,0x1e,0x04,0x59,0x80,0x21,0x8e,0xcb,0x80,0x3f,0x5d,0x30,0x80,0x2d,0xcd,0x95,	// 000025A0
	0x80,0x27,0x91,0x8c,0x80,0x3c,0xcd,0xe9,0x80,0x18,0x4e,0xff,0x80,0x3c,0x53,0xa9,	// 000025B0
	0x80,0x2a,0xcc,0xb7,0x81,0xaa,0xce,0xa3,0x80,0x0f,0x1e,0x69,0x80,0x36,0xd0,0x5c,	// 000025C0
	0x80,0x0f,0x1e,0xae,0x80,0xdb,0xd0,0xa1,0x80,0x2a,0xd3,0x98,0x80,0x1b,0x53,0xca,	// 000025D0
	0x80,0x2a,0xd3,0xdd,0x80,0x69,0xce,0xa3,0x80,0x1b,0x1b,0x3c,0x80,0x2a,0x53,0xaf,	// 000025E0
	0x80,0x1b,0x1b,0x81,0x80,0x36,0xcc,0x24,0x80,0x78,0x5a,0x18,0x80,0x36,0xd3,0x62,	// 000025F0
	0x80,0x2a,0x8d,0x78,0x80,0x1e,0x92,0xb2,0x80,0x2d,0x5d,0x2a,0x80,0x27,0x51,0x6f,	// 00002600
	0x80,0x2d,0x99,0xba,0x80,0x21,0x5a,0xed,0x80,0x36,0x5d,0x36,0x80,0x42,0x90,0xb4,	// 00002610
	0x80,0x1e,0x99,0x5a,0x81,0xc8,0xd1,0xd0,0x80,0x75,0xd6,0xe0,0x80,0x24,0x54,0xab,	// 00002620
	0x80,0x24,0xcd,0xa1,0x80,0x21,0x54,0xf3,0x80,0x4e,0xd1,0x2e,0x80,0x3c,0x93,0x24,	// 00002630
	0x83,0xe4,0xd8,0x48,0x80,0x93,0xd5,0x9c,0x80,0x7b,0x63,0xed,0x80,0x27,0xcc,0xd2,	// 00002640
	0x80,0x1b,0xcd,0x89,0x80,0x2a,0x5a,0x3c,0x80,0x1b,0xcd,0xce,0x80,0x3f,0xa3,0x47,	// 00002650
	0x80,0x15,0x64,0x8c,0x80,0x30,0x51,0x93,0x80,0x15,0x64,0xd1,0x80,0x33,0x63,0xc6,	// 00002660
	0x80,0x39,0xce,0x25,0x80,0x18,0xa2,0x9c,0x80,0x87,0x9d,0x3e,0x8d,0x14,0xa4,0x55,	// 00002670
	0x80,0x8d,0x00,0xdb,0x80,0x15,0x77,0x82,0x80,0x87,0x00,0xdb,0x80,0x0f,0x5d,0x42,	// 00002680
	0x81,0xc2,0xf0,0x63,0x80,0x4b,0x00,0x25,0x05,0x1c,0x1a,0x14,0x00,0x00,0x80,0x40,	// 00002690
	0xf2,0xcc,0x80,0x45,0xf3,0x06,0x80,0x18,0x77,0x7c,0x80,0x8a,0xf3,0x06,0x80,0x0c,	// 000026A0
	0x5d,0x42,0x81,0xc2,0xf3,0xa8,0x86,0xe1,0xf5,0xfd,0x80,0x09,0x0b,0x3a,0x81,0x6b,	// 000026B0
	0xfc,0xe1,0x81,0x77,0xfc,0xde,0x80,0x4e,0xfe,0x0a,0x89,0xae,0x00,0xfc,0xd2,0x06,	// 000026C0
	0x40,0x3e,0x38,0x40,0x3e,0x38,0x80,0x18,0x01,0x09,0xc8,0x86,0x78,0x01,0x00,0x0e,	// 000026D0
	0x81,0xb9,0x01,0x09,0xce,0x06,0x40,0x3e,0x38,0x00,0x00,0x00,0x80,0x9f,0x00,0x00,	// 000026E0
	0x25,0x80,0x09,0x01,0x09,0xe3,0x80,0x66,0x01,0x12,0x17,0x80,0x0c,0x01,0x09,0xe3,	// 000026F0
	0x82,0x28,0x00,0xff,0x87,0x80,0x18,0x00,0x00,0xd8,0x80,0x1b,0x00,0x04,0x20,0x80,	// 00002700
	0x1e,0x00,0x04,0x20,0x80,0x36,0x01,0x15,0x92,0x80,0x1b,0x00,0x04,0x20,0x80,0x06,	// 00002710
	0x00,0x01,0x14,0x80,0x09,0x00,0x0b,0x3d,0x06,0x1c,0x1a,0x14,0x2a,0x27,0x20,0x80,	// 00002720
	0x5a,0x01,0x16,0x13,0x80,0x06,0x00,0xf3,0x06,0x80,0x90,0x01,0x09,0x4a,0x81,0xa4,	// 00002730
	0x01,0x13,0xbe,0x80,0x30,0x01,0x15,0x7d,0x80,0x6f,0x01,0x15,0x92,0x80,0x06,0x00,	// 00002740
	0x04,0x5c,0x80,0x09,0x00,0x0b,0x3d,0x80,0x5d,0x01,0x16,0x13,0x80,0x09,0x00,0x5d,	// 00002750
	0x45,0x82,0x34,0x01,0x13,0x2e,0x80,0x12,0x00,0x1b,0x2d,0x80,0x0c,0x01,0x15,0x74,	// 00002760
	0x09,0xea,0xe7,0xe0,0xd5,0xd2,0xcb,0xa9,0xa7,0xa4,0x80,0x12,0x01,0x15,0x6e,0x80,	// 00002770
	0x0f,0x00,0x11,0x58,0x80,0x0f,0x01,0x15,0x71,0x80,0x09,0x00,0x11,0x6d,0x80,0x0c,	// 00002780
	0x00,0x50,0xf4,0x80,0x09,0x01,0x1b,0xef,0x80,0x0f,0x00,0x5a,0xb7,0x80,0x12,0x00,	// 00002790
	0x21,0xa8,0x80,0x0f,0x01,0x1c,0x34,0x80,0x45,0x01,0x19,0x4f,0x06,0xea,0xe7,0xe0,	// 000027A0
	0x2a,0x27,0x20,0x80,0xa8,0x01,0x19,0x9a,0x80,0x4e,0x01,0x09,0xda,0x80,0x3f,0x01,	// 000027B0
	0x12,0x17,0x80,0x18,0x01,0x13,0x2b,0x80,0xf6,0x01,0x1d,0xd8,0x80,0x1e,0x01,0x1b,	// 000027C0
	0xdd,0x80,0x0c,0x00,0x11,0x6d,0x80,0x12,0x00,0x21,0xa8,0x06,0xd5,0xd2,0xcb,0x7a,	// 000027D0
	0x77,0x70,0x80,0x48,0x01,0x1c,0x1f,0x80,0x0f,0x00,0x1b,0x3c,0x80,0xa8,0x01,0x19,	// 000027E0
	0x2e,0x80,0x57,0x01,0x1d,0xd8,0x80,0x63,0x00,0xff,0xed,0x80,0x42,0x00,0x00,0xd8,	// 000027F0
	0x81,0x0b,0x01,0x21,0x0b,0x80,0xa2,0x01,0x1f,0x25,0x80,0x18,0x01,0x1c,0x49,0x80,	// 00002800
	0x87,0x01,0x1c,0x97,0x80,0x57,0x01,0x21,0x20,0x80,0x21,0x01,0x09,0xad,0x80,0x45,	// 00002810
	0x01,0x20,0xde,0x80,0x3f,0x00,0x04,0x23,0x81,0x0b,0x01,0x24,0x53,0x80,0xa2,0x01,	// 00002820
	0x1b,0xdd,0x80,0x18,0x00,0x5a,0xc6,0x80,0x87,0x01,0x19,0x4f,0x80,0x57,0x01,0x24,	// 00002830
	0x68,0x80,0x66,0x01,0x20,0xbd,0x81,0x62,0x01,0x24,0x6b,0x81,0x29,0x01,0x18,0xad,	// 00002840
	0x82,0x1c,0x01,0x26,0xf6,0x80,0xae,0x01,0x15,0x62,0x82,0x97,0x01,0x26,0x78,0x80,	// 00002850
	0xae,0x01,0x12,0x17,0x81,0x59,0x01,0x26,0x75,0x80,0x15,0x00,0x50,0x58,0x80,0x90,	// 00002860
	0x01,0x24,0x9b,0x80,0x12,0x01,0x1c,0x2b,0x80,0x18,0x01,0x31,0xa6,0x80,0x72,0x01,	// 00002870
	0x25,0x55,0x80,0xb1,0x00,0xfd,0xa7,0x80,0x8d,0x01,0x26,0x78,0x80,0x12,0x00,0x62,	// 00002880
	0xb2,0x80,0x12,0x01,0x34,0x2e,0x82,0x91,0x01,0x31,0x01,0x80,0x06,0x01,0x12,0x17,	// 00002890
	0x81,0xfb,0x01,0x33,0x98,0x80,0x5d,0x01,0x31,0xf4,0x80,0x1e,0x01,0x34,0x37,0x80,	// 000028A0
	0xc6,0x01,0x2f,0x7e,0x80,0x0c,0x00,0xf2,0xfd,0x81,0x4d,0x01,0x26,0x78,0x80,0x33,	// 000028B0
	0x01,0x39,0x32,0x80,0x81,0x01,0x3b,0x51,0x80,0x24,0x01,0x31,0x9a,0x80,0x2d,0x01,	// 000028C0
	0x24,0xa7,0x80,0x0c,0x01,0x1c,0x49,0x80,0x12,0x01,0x1c,0x4c,0x80,0x2a,0x01,0x25,	// 000028D0
	0xa0,0x80,0x66,0x01,0x3a,0x25,0x80,0xab,0x01,0x3c,0xc5,0x80,0xea,0x01,0x33,0xfb,	// 000028E0
	0x81,0x05,0x01,0x3b,0x75,0x80,0x12,0x01,0x3c,0x77,0x80,0x15,0x01,0x3c,0x8f,0x80,	// 000028F0
	0x21,0x01,0x25,0xa9,0x81,0x0e,0x01,0x3c,0xc5,0x81,0xf2,0x01,0x37,0x40,0x80,0x0f,	// 00002900
	0x00,0x51,0x5d,0x80,0x18,0x01,0x3f,0xd4,0x81,0x5c,0x01,0x3f,0xe9,0x81,0xce,0x01,	// 00002910
	0x30,0xdd,0x06,0xbd,0xba,0xb4,0xbd,0xba,0xb4,0x80,0x39,0x01,0x25,0x91,0x82,0xa9,	// 00002920
	0x01,0x40,0x0a,0x80,0x9c,0x01,0x32,0x4b,0x82,0x07,0x01,0x40,0x07,0x81,0x44,0x01,	// 00002930
	0x24,0x86,0x82,0x04,0x01,0x43,0x52,0x84,0x8c,0x01,0x4b,0xe6,0x81,0x0e,0x01,0x3c,	// 00002940
	0xc2,0x80,0x1e,0x01,0x16,0x70,0x80,0xbd,0x01,0x26,0xf6,0x81,0x5c,0x01,0x21,0x23,	// 00002950
	0x80,0xae,0x01,0x39,0x77,0x80,0x6f,0x01,0x12,0x56,0x80,0x84,0x01,0x23,0x9c,0x80,	// 00002960
	0x48,0x01,0x00,0x08,0x81,0x5f,0x01,0x1d,0xd8,0x81,0x32,0x01,0x08,0x99,0x80,0xb7,	// 00002970
	0x01,0x20,0x69,0x8c,0xc0,0x00,0xfd,0x08,0x86,0xe7,0x00,0xff,0xf0,0x81,0x14,0x01,	// 00002980
	0x56,0xff,0x81,0xce,0x00,0x01,0x5c,0x80,0x0f,0x01,0x13,0x2b,0x80,0x0f,0x01,0x12,	// 00002990
	0x17,0x80,0x18,0x01,0x13,0x2b,0x80,0x30,0x00,0xfc,0xcf,0x81,0x14,0x01,0x3c,0xbf,	// 000029A0
	0x80,0x45,0x01,0x19,0x79,0x81,0x50,0x01,0x73,0x25,0x80,0x48,0x01,0x16,0x3a,0x80,	// 000029B0
	0x0c,0x01,0x16,0x0d,0x80,0x1b,0x01,0x16,0x70,0x83,0x78,0x00,0xf9,0x87,0x80,0x4e,	// 000029C0
	0x00,0xfc,0x9f,0x80,0x0f,0x01,0x19,0x55,0x80,0x1e,0x01,0x76,0x1f,0x80,0x15,0x01,	// 000029D0
	0x12,0x17,0x80,0x06,0x01,0x12,0x17,0x80,0x1b,0x01,0x7a,0x2a,0x83,0x12,0x01,0x77,	// 000029E0
	0x18,0x80,0x12,0x00,0x00,0xd8,0x80,0x0c,0x00,0x01,0x14,0x06,0x7a,0x77,0x70,0x9a,	// 000029F0
	0x97,0x90,0x80,0x09,0x01,0x7d,0x93,0x80,0x0c,0x00,0x04,0x5c,0x80,0x4e,0x00,0xfc,	// 00002A00
	0xde,0x80,0x99,0x00,0xfc,0xdb,0x82,0x2b,0x01,0x7b,0x4a,0x80,0x1b,0x00,0x04,0x4d,	// 00002A10
	0x80,0x0c,0x01,0x7d,0x93,0x80,0x06,0x01,0x7d,0x93,0x80,0xa2,0x01,0x7d,0xa2,0x09,	// 00002A20
	0x43,0x41,0x3b,0x43,0x41,0x3b,0x43,0x41,0x3b,0x80,0x21,0x01,0x12,0x0e,0x80,0x06,	// 00002A30
	0x01,0x09,0xe3,0x80,0x1e,0x01,0x81,0x9e,0x82,0x64,0x01,0x7e,0x92,0x80,0xa5,0x01,	// 00002A40
	0x57,0x89,0x80,0x18,0x01,0x15,0x5c,0x80,0x09,0x01,0x16,0x01,0x80,0x21,0x01,0x84,	// 00002A50
	0xe6,0x82,0x61,0x01,0x7e,0x95,0x80,0x4e,0x01,0x19,0x70,0x80,0x39,0x01,0x19,0x55,	// 00002A60
	0x80,0x0f,0x01,0x16,0x70,0x80,0x15,0x01,0x09,0xdd,0x80,0x1b,0x01,0x19,0x37,0x80,	// 00002A70
	0x06,0x00,0x04,0x20,0x0f,0xb5,0xb3,0xac,0xa0,0x9d,0x97,0x7a,0x77,0x70,0xa0,0x9d,	// 00002A80
	0x97,0xb5,0xb3,0xac,0x80,0x0c,0x01,0x88,0x43,0x82,0xe8,0x01,0x85,0x25,0x80,0x21,	// 00002A90
	0x01,0x19,0xb8,0x80,0x06,0x00,0x04,0x20,0x80,0x12,0x01,0x1c,0x49,0x80,0x0c,0x01,	// 00002AA0
	0x88,0x46,0x0c,0xa0,0x9d,0x97,0xea,0xe7,0xe0,0xb5,0xb3,0xac,0xea,0xe7,0xe0,0x80,	// 00002AB0
	0x06,0x01,0x88,0x55,0x83,0x00,0x01,0x88,0x64,0x80,0x1b,0x01,0x88,0x1c,0x80,0x0f,	// 00002AC0
	0x00,0x5a,0xc9,0x80,0x0c,0x01,0x88,0x46,0x80,0x06,0x01,0x88,0x4f,0x80,0x06,0x01,	// 00002AD0
	0x8b,0x9d,0x80,0x0f,0x01,0x88,0x40,0x83,0x0f,0x01,0x88,0x6d,0x80,0x09,0x00,0x1b,	// 00002AE0
	0x33,0x80,0x15,0x01,0x88,0x3d,0x82,0x49,0x01,0x8b,0x9a,0x06,0x58,0x56,0x50,0x58,	// 00002AF0
	0x56,0x50,0x80,0x15,0x01,0x80,0xc9,0x80,0x06,0x00,0x0b,0x3a,0x80,0xc3,0x01,0x8e,	// 00002B00
	0x04,0x82,0x64,0x01,0x88,0x37,0x80,0xba,0x01,0x94,0x73,0x80,0x21,0x01,0x16,0x70,	// 00002B10
	0x82,0xa0,0x01,0x84,0xe6,0x80,0x96,0x01,0x57,0x89,0x82,0xb2,0x01,0x81,0x8c,0x83,	// 00002B20
	0xde,0x01,0x7d,0xae,0x82,0xb2,0x01,0x7e,0x44,0x83,0x0f,0x01,0x7a,0x66,0x86,0x90,	// 00002B30
	0x01,0xa4,0xd5,0x80,0x39,0x01,0x7d,0x75,0x80,0x4b,0x00,0xfc,0xde,0x82,0xc1,0x01,	// 00002B40
	0x7d,0xf9,0x80,0x3f,0x01,0x7a,0x2a,0x83,0x0c,0x01,0x80,0xf9,0x80,0x42,0x00,0x38,	// 00002B50
	0xee,0x80,0x81,0x01,0x12,0x17,0x82,0x85,0x01,0x84,0xc8,0x80,0x42,0x00,0x38,0xee,	// 00002B60
	0x80,0x42,0x01,0x16,0x0d,0x82,0xc1,0x01,0x87,0xd1,0x80,0x1b,0x01,0x81,0x9e,0x80,	// 00002B70
	0x21,0x01,0xbb,0xc7,0x80,0x4b,0x01,0x19,0x4c,0x80,0x9f,0x01,0x8b,0x19,0x80,0x21,	// 00002B80
	0x01,0xbb,0xe8,0x82,0x04,0x01,0x7b,0x71,0x80,0x12,0x00,0x01,0x20,0x80,0x0c,0x00,	// 00002B90
	0x01,0x59,0x80,0x1e,0x01,0xbf,0x15,0x80,0x93,0x01,0xbc,0x09,0x80,0x57,0x01,0x8e,	// 00002BA0
	0xac,0x80,0x1e,0x01,0xbf,0x15,0x82,0x04,0x01,0x7b,0x71,0x12,0x10,0x50,0xe0,0x03,	// 00002BB0
	0x22,0x6c,0x07,0x32,0x94,0x10,0x50,0xe0,0x07,0x32,0x94,0x03,0x22,0x6c,0x80,0x1b,	// 00002BC0
	0x00,0xd1,0xbb,0x80,0x0f,0x00,0x04,0x9e,0x80,0xab,0x01,0xbc,0x09,0x80,0x3f,0x01,	// 00002BD0
	0x92,0x0c,0x81,0x86,0x00,0x04,0x8f,0x80,0x9f,0x01,0xc1,0xc1,0x06,0x07,0x32,0x94,	// 00002BE0
	0x00,0x00,0x00,0x80,0x09,0x01,0xc5,0xa8,0x80,0x0f,0x00,0x11,0x97,0x06,0x03,0x22,	// 00002BF0
	0x6c,0x00,0x00,0x00,0x80,0x06,0x00,0x00,0x25,0x80,0x0f,0x01,0xc2,0x6c,0x80,0xae,	// 00002C00
	0x01,0xbf,0x51,0x80,0x3c,0x01,0x88,0x37,0x80,0x1e,0x01,0xc5,0xc3,0x82,0x07,0x01,	// 00002C10
	0xc0,0x59,0x80,0x0c,0x01,0xc5,0xa5,0x80,0x15,0x00,0x21,0xf0,0x80,0x06,0x01,0xc5,	// 00002C20
	0xc6,0x80,0x06,0x01,0xc2,0x6c,0x80,0x15,0x01,0xc2,0x8d,0x80,0x8a,0x01,0xb8,0xca,	// 00002C30
	0x80,0x57,0x01,0x84,0xd4,0x80,0x1e,0x01,0xc9,0x0b,0x82,0x25,0x01,0xc3,0xa1,0x80,	// 00002C40
	0x09,0x01,0xc9,0x0b,0x80,0x18,0x01,0xc2,0x87,0x80,0x8d,0x01,0xb5,0x7f,0x80,0x57,	// 00002C50
	0x01,0x81,0x8c,0x80,0x1e,0x01,0xcc,0x53,0x82,0x46,0x01,0xc0,0x59,0x80,0xe4,0x01,	// 00002C60
	0x7d,0xb7,0x82,0x22,0x01,0xc3,0x83,0x80,0x42,0x01,0xbf,0x15,0x80,0xe4,0x01,0x7d,	// 00002C70
	0xb7,0x82,0x1f,0x01,0xc0,0x3b,0x80,0x3f,0x01,0xbb,0xca,0x80,0xea,0x01,0x57,0x2c,	// 00002C80
	0x81,0x86,0x01,0xbc,0xf3,0x83,0x69,0x01,0x76,0x49,0x80,0x27,0x01,0x16,0x10,0x81,	// 00002C90
	0x2f,0x01,0x74,0x75,0x80,0x51,0x01,0x87,0x83,0x81,0x80,0x01,0x75,0xef,0x81,0xda,	// 00002CA0
	0x01,0x6f,0xb9,0x80,0x48,0x01,0x72,0xb9,0x81,0x6e,0x00,0xfb,0xbb,0x81,0x2f,0x00,	// 00002CB0
	0xfc,0xde,0x80,0x51,0x01,0x7d,0xab,0x81,0x80,0x01,0x7e,0x4a,0x85,0x5e,0x01,0xe2,	// 00002CC0
	0x91,0x81,0x2f,0x00,0xfe,0x0a,0x89,0xe4,0x01,0xe9,0x1e,0x80,0x1e,0x01,0x09,0xc8,	// 00002CD0
	0x80,0x21,0x01,0xf6,0x4a,0x80,0x06,0x01,0x12,0xb9,0x80,0x5d,0x01,0xf6,0x8c,0x80,	// 00002CE0
	0x8d,0x01,0x09,0x59,0x80,0x8d,0x01,0xf6,0x4a,0x80,0x0f,0x01,0x13,0x28,0x80,0x42,	// 00002CF0
	0x01,0x81,0x9e,0x81,0xe6,0x01,0xeb,0x37,0x06,0xea,0xe7,0xe0,0x5a,0x57,0x50,0x80,	// 00002D00
	0x06,0x00,0x0b,0x3a,0x06,0xb5,0xb2,0xac,0xea,0xe7,0xe0,0x80,0x06,0x01,0xfa,0x3d,	// 00002D10
	0x80,0x0f,0x01,0xfa,0x4f,0x06,0xea,0xe7,0xe0,0xb5,0xb2,0xac,0x80,0x12,0x01,0xfa,	// 00002D20
	0x46,0x80,0x0f,0x01,0xfa,0x70,0x80,0x06,0x01,0xfa,0x67,0x80,0x0f,0x01,0xfa,0x3a,	// 00002D30
	0x80,0xbd,0x01,0xe3,0xa8,0x80,0x42,0x01,0x84,0xe6,0x81,0xe6,0x01,0xf5,0x0f,0x80,	// 00002D40
	0x0c,0x01,0xfa,0x3d,0x80,0x12,0x01,0xfd,0x85,0x80,0x1e,0x01,0xfd,0x91,0x80,0x1b,	// 00002D50
	0x01,0xfd,0xb2,0x80,0x0f,0x01,0xfa,0x94,0x80,0xba,0x01,0xf7,0x5b,0x80,0x42,0x01,	// 00002D60
	0x88,0x2e,0x81,0xf2,0x01,0xf8,0x57,0x80,0x5a,0x01,0xfd,0x91,0x80,0xbd,0x01,0xfa,	// 00002D70
	0xa3,0x80,0x3f,0x01,0x8b,0x79,0x81,0xe9,0x01,0xfb,0x9f,0x80,0x09,0x01,0xfa,0x64,	// 00002D80
	0x80,0x0f,0x01,0xfd,0x85,0x80,0x09,0x01,0xfa,0x4c,0x80,0x12,0x01,0xfa,0x49,0x80,	// 00002D90
	0x12,0x01,0xfa,0x34,0x80,0x06,0x01,0xfa,0x49,0x80,0x18,0x01,0xfa,0x8b,0x80,0xc3,	// 00002DA0
	0x01,0xfd,0xeb,0x80,0x39,0x01,0x8e,0xc7,0x81,0xec,0x01,0xf8,0x57,0x80,0x1e,0x01,	// 00002DB0
	0xfd,0x9d,0x80,0x18,0x02,0x07,0x5d,0x80,0x1b,0x01,0xfd,0xd0,0x80,0xcf,0x02,0x01,	// 00002DC0
	0x24,0x80,0x3c,0x01,0x92,0x0c,0x81,0xec,0x01,0xfb,0x9f,0x80,0x60,0x02,0x07,0x63,	// 00002DD0
	0x82,0xe5,0x01,0xfd,0xeb,0x80,0x15,0x02,0x04,0x18,0x80,0x0c,0x02,0x04,0x5d,0x80,	// 00002DE0
	0x1b,0x02,0x07,0x5d,0x80,0x18,0x02,0x04,0x30,0x80,0x09,0x01,0xfa,0x4c,0x82,0xe8,	// 00002DF0
	0x01,0xfa,0x9d,0x83,0x48,0x01,0xf6,0xf5,0x85,0xdc,0x01,0xe9,0xd5,0x82,0x61,0x00,	// 00002E00
	0xfa,0xcb,0x84,0x2f,0x02,0x19,0x72,0x82,0x16,0x01,0xdc,0x01,0x81,0x50,0x01,0xeb,	// 00002E10
	0x37,0x81,0xf8,0x01,0xdf,0x67,0x8b,0x13,0x01,0xeb,0x37,0xac,0xb5,0x01,0xec,0x72,	// 00002E20
	0x83,0x48,0x00,0xf5,0xfd,0x81,0x2f,0x01,0x74,0x2a,0x5b,0x54,0x65,0x78,0x74,0x5d,	// 00002E30
	0x0d,0x0a,0x1f,0x4e,0x6f,0x72,0x6d,0x61,0x6c,0x3d,0x23,0x37,0x30,0x37,0x37,0x37,	// 00002E40
	0x61,0x0d,0x0a,0x43,0x75,0x72,0x72,0x65,0x6e,0x74,0x3d,0x23,0x65,0x30,0x65,0x37,	// 00002E50
	0x65,0x61,0x80,0x08,0x06,0x14,0x42,0x47,0x3d,0x23,0x32,0x30,0x32,0x37,0x32,0x61,	// 00002E60
	0x0d,0x0a,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x80,0x04,0x2f,0x14,0x35,0x30,	// 00002E70
	0x35,0x37,0x35,0x61,0x0d,0x0a,0x46,0x6f,0x6e,0x74,0x3d,0x41,0x72,0x69,0x61,0x6c,	// 00002E80
	0x0d,0x0a,0x42,0x4d,0x4e,0x24,0x00,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,	// 00002E90
	0x00,0x28,0x00,0x00,0x00,0x33,0x01,0x00,0x00,0x0a,0x00,0x00,0x00,0x01,0x00,0x18,	// 00002EA0
	0x80,0x05,0x04,0x04,0x18,0x24,0x00,0x00,0x80,0x10,0x24,0x04,0x5a,0x57,0x50,0x5a,	// 00002EB0
	0x82,0xe4,0x37,0x05,0x40,0x3e,0x38,0x00,0x00,0x80,0x4f,0x03,0x21,0x06,0x40,0x3e,	// 00002EC0
	0x38,0xff,0xff,0xff,0x80,0x57,0x03,0x1e,0x82,0xeb,0x00,0x33,0x09,0x00,0x00,0x00,	// 00002ED0
	0x58,0x56,0x50,0x7a,0x77,0x70,0x80,0x48,0x06,0xc0,0x12,0x58,0x56,0x50,0x00,0x00,	// 00002EE0
	0x00,0xff,0xff,0xff,0x00,0x00,0x00,0x7a,0x77,0x70,0x9a,0x97,0x90,0x80,0x48,0x07,	// 00002EF0
	0x1a,0x05,0x7a,0x77,0x70,0x00,0x00,0x80,0x0a,0x03,0xc8,0x82,0xdc,0x07,0x71,0x06,	// 00002F00
	0x40,0x3e,0x38,0x5a,0x57,0x50,0x80,0x06,0x07,0x14,0x80,0x15,0x06,0xc0,0x05,0x5a,	// 00002F10
	0x57,0x50,0x7a,0x77,0x80,0x1f,0x0a,0x70,0x80,0x15,0x06,0xc0,0x80,0x09,0x07,0x0e,	// 00002F20
	0x80,0x18,0x07,0x1a,0x05,0x5a,0x57,0x50,0x9a,0x97,0x80,0x1f,0x0a,0xca,0x80,0x15,	// 00002F30
	0x07,0x1a,0x80,0x09,0x00,0x24,0x06,0x1c,0x1a,0x14,0x2a,0x27,0x20,0x82,0xd6,0x0b,	// 00002F40
	0x10,0x06,0x1c,0x1a,0x14,0x00,0x00,0x00,0x80,0xba,0x0a,0x53,0x82,0xd9,0x0b,0x10,	// 00002F50
	0x80,0x06,0x0b,0x10,0x84,0x59,0x0d,0xec,0x83,0x99,0x0b,0x0d,0x83,0x9c,0x07,0x6e,	// 00002F60
	0x83,0x9c,0x03,0xd2,0x83,0x9c,0x00,0x36,0x42,0x4d,0xda,0x5b,0x00,0x00,0x00,0x00,	// 00002F70
	0x15,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x5c,0x00,0x00,0x00,0x55,	// 00002F80
	0x00,0x00,0x00,0x01,0x00,0x18,0x80,0x05,0x04,0x04,0xa4,0x5b,0x00,0x00,0x80,0x10,	// 00002F90
	0x24,0x06,0x09,0x38,0xa4,0x10,0x50,0xe0,0x80,0x3c,0x39,0x04,0x00,0x00,0x00,0x10,	// 00002FA0
	0x80,0x3e,0x3a,0x0c,0x09,0x38,0xa4,0x00,0x00,0x00,0x05,0x26,0x77,0x09,0x38,0xa4,	// 00002FB0
	0x80,0x3c,0xc3,0x80,0x06,0x00,0x33,0x80,0x3c,0x00,0xc3,0x05,0x05,0x26,0x77,0x00,	// 00002FC0
	0x00,0x80,0x40,0x00,0x7a,0x80,0x45,0x00,0x75,0x80,0x06,0x00,0x75,0x80,0x3f,0x00,	// 00002FD0
	0xc3,0x80,0x45,0x00,0xff,0x80,0x06,0x00,0xba,0x80,0x12,0x00,0x69,0x80,0x0c,0x00,	// 00002FE0
	0x78,0x80,0x1e,0x02,0x6d,0x80,0x18,0x00,0x72,0x80,0x09,0x02,0x6d,0x80,0x12,0x00,	// 00002FF0
	0x24,0x80,0x09,0x00,0x24,0x80,0x21,0x01,0xc2,0x80,0x09,0x00,0x30,0x80,0x24,0x02,	// 00003000
	0xf1,0x80,0x18,0x00,0xfc,0x80,0x09,0x00,0x30,0x80,0x1b,0x02,0xbb,0x81,0x32,0x02,	// 00003010
	0x4c,0x80,0x12,0x02,0xca,0x80,0x36,0x02,0x7c,0x80,0x42,0x01,0x9e,0x80,0x12,0x03,	// 00003020
	0x54,0x80,0x36,0x03,0x06,0x80,0x60,0x02,0x28,0x80,0x18,0x02,0xca,0x80,0x72,0x02,	// 00003030
	0xa0,0x80,0x18,0x03,0x54,0x81,0x68,0x03,0x2a,0x80,0x21,0x05,0xb5,0x80,0x69,0x04,	// 00003040
	0xb3,0x80,0x21,0x06,0x3f,0x80,0x87,0x05,0x3d,0x82,0x0a,0x02,0x88,0x81,0x08,0x01,	// 00003050
	0x56,0x81,0x14,0x00,0x36,0x06,0x58,0x56,0x50,0x7a,0x77,0x70,0x80,0x3c,0x0d,0x29,	// 00003060
	0x05,0x00,0x00,0x00,0x7a,0x77,0x80,0x3d,0x0d,0x2b,0x05,0x58,0x56,0x50,0x00,0x00,	// 00003070
	0x80,0x8b,0x00,0xbf,0x80,0x3f,0x0d,0x29,0x80,0x45,0x0d,0x65,0x80,0x06,0x0d,0x65,	// 00003080
	0x80,0x8a,0x01,0xd4,0x80,0x0f,0x0d,0x29,0x06,0xea,0xe7,0xe0,0xea,0xe7,0xe0,0x80,	// 00003090
	0x27,0x0f,0x54,0x80,0x18,0x0d,0x62,0x80,0x09,0x0f,0x5d,0x80,0x06,0x0f,0x5d,0x80,	// 000030A0
	0x15,0x0f,0xab,0x80,0x21,0x0e,0xb2,0x80,0x7b,0x02,0xf7,0x81,0x20,0x0f,0x4e,0x80,	// 000030B0
	0x12,0x0f,0xba,0x80,0x36,0x0f,0x6c,0x80,0x42,0x0e,0x8e,0x80,0x7e,0x05,0x1c,0x80,	// 000030C0
	0x2a,0x0f,0x4e,0x80,0x18,0x0f,0xba,0x80,0x72,0x0f,0x90,0x80,0x60,0x06,0x4e,0x81,	// 000030D0
	0x2f,0x0f,0x4e,0x80,0x21,0x11,0x82,0x80,0x5d,0x0e,0x76,0x80,0x7b,0x08,0x5b,0x82,	// 000030E0
	0x34,0x0f,0x4e,0x81,0x08,0x0e,0x46,0x81,0x14,0x0d,0x26,0x81,0x17,0x1a,0x13,0x80,	// 000030F0
	0x42,0x01,0xd4,0x80,0x0f,0x01,0x38,0x80,0x42,0x00,0xc0,0x80,0x4b,0x1b,0x2d,0x80,	// 00003100
	0x84,0x1a,0xf7,0x80,0x54,0x1b,0x81,0x80,0x3c,0x00,0xc0,0x80,0x57,0x1a,0xf7,0x0f,	// 00003110
	0x07,0x30,0x90,0x01,0x0f,0x3d,0x00,0x00,0x00,0x01,0x0f,0x3d,0x07,0x30,0x90,0x80,	// 00003120
	0x75,0x1b,0x99,0x80,0x39,0x00,0xc0,0x80,0x4e,0x1a,0xf7,0x80,0x06,0x00,0x33,0x80,	// 00003130
	0x06,0x01,0x44,0x06,0x01,0x0f,0x3d,0x02,0x1a,0x56,0x80,0x06,0x1d,0x79,0x80,0x5a,	// 00003140
	0x1b,0x7e,0x80,0x06,0x00,0x04,0x0c,0x01,0x0f,0x3d,0x05,0x26,0x77,0x09,0x38,0xa4,	// 00003150
	0x02,0x1a,0x56,0x80,0x0c,0x00,0x24,0x80,0x36,0x00,0xc0,0x80,0x51,0x1e,0x33,0x80,	// 00003160
	0x12,0x1f,0x0b,0x80,0x06,0x01,0x44,0x80,0x57,0x1b,0x7e,0x80,0x0c,0x00,0x24,0x05,	// 00003170
	0x02,0x1a,0x56,0x09,0x38,0x80,0x0d,0x1f,0x01,0x80,0x8d,0x1f,0x11,0x80,0x0f,0x00,	// 00003180
	0xc3,0x80,0x06,0x1f,0x02,0x80,0x5a,0x1c,0x8c,0x80,0x09,0x1f,0x02,0x80,0x09,0x00,	// 00003190
	0xc0,0x80,0x8d,0x1d,0xf7,0x80,0x78,0x1c,0x38,0x80,0x06,0x1f,0x02,0x05,0x01,0x0f,	// 000031A0
	0x3d,0x09,0x38,0x80,0x97,0x1c,0xdf,0x80,0x75,0x21,0xb4,0x80,0x06,0x1d,0x79,0x80,	// 000031B0
	0x06,0x20,0x13,0x80,0x8a,0x1c,0xe3,0x80,0x09,0x20,0x10,0x80,0x24,0x20,0x9d,0x80,	// 000031C0
	0x54,0x1c,0x92,0x80,0x09,0x1f,0x0b,0x80,0x8a,0x1d,0xf7,0x80,0x12,0x1f,0xaa,0x80,	// 000031D0
	0x0c,0x1a,0x10,0x80,0x5d,0x1b,0xb7,0x80,0x12,0x20,0x13,0x80,0x87,0x1f,0x0e,0x80,	// 000031E0
	0x1b,0x1e,0x84,0x80,0x60,0x25,0x14,0x80,0x0c,0x23,0x52,0x80,0x06,0x1d,0x79,0x80,	// 000031F0
	0x8a,0x25,0x86,0x80,0x84,0x1d,0x73,0x80,0x8d,0x1d,0xf4,0x81,0x1d,0x1c,0x59,0x80,	// 00003200
	0xf3,0x1b,0x4e,0x81,0x14,0x1a,0x13,0x80,0x42,0x01,0x4a,0x80,0x0f,0x00,0xae,0x80,	// 00003210
	0x42,0x00,0x36,0x80,0x4b,0x2b,0x59,0x80,0x84,0x2b,0x23,0x80,0x54,0x2b,0xad,0x80,	// 00003220
	0x3c,0x00,0x36,0x80,0x57,0x2b,0x23,0x0f,0x0d,0x45,0xc5,0x02,0x19,0x56,0x00,0x00,	// 00003230
	0x00,0x02,0x19,0x56,0x0d,0x45,0xc5,0x80,0x75,0x2b,0xc5,0x80,0x39,0x00,0x36,0x80,	// 00003240
	0x4e,0x2b,0x23,0x80,0x06,0x00,0x78,0x80,0x07,0x23,0xe2,0x05,0x19,0x56,0x04,0x27,	// 00003250
	0x78,0x80,0x06,0x2d,0xa5,0x80,0x5a,0x2b,0xaa,0x80,0x07,0x20,0x0d,0x0b,0x19,0x56,	// 00003260
	0x09,0x38,0xa4,0x10,0x50,0xe0,0x04,0x27,0x78,0x80,0x42,0x00,0x2a,0x80,0x51,0x2e,	// 00003270
	0x5f,0x80,0x12,0x00,0x30,0x80,0x48,0x0c,0x0c,0x80,0x21,0x2c,0x22,0x05,0x04,0x27,	// 00003280
	0x78,0x10,0x50,0x80,0x0d,0x2f,0x2d,0x80,0x8d,0x2f,0x3d,0x80,0x0f,0x00,0x39,0x80,	// 00003290
	0x06,0x2f,0x2e,0x80,0x5a,0x2c,0xb8,0x80,0x09,0x2f,0x2e,0x80,0x09,0x00,0x36,0x80,	// 000032A0
	0x8d,0x2e,0x23,0x80,0x78,0x2c,0x64,0x80,0x06,0x2f,0x2e,0x05,0x02,0x19,0x56,0x10,	// 000032B0
	0x50,0x80,0x97,0x2d,0x0b,0x80,0x75,0x31,0xe0,0x80,0x06,0x2d,0xa5,0x80,0x06,0x30,	// 000032C0
	0x3f,0x80,0x8a,0x2d,0x0f,0x80,0x09,0x30,0x3c,0x80,0x24,0x30,0xc9,0x80,0x54,0x2c,	// 000032D0
	0xbe,0x80,0x0c,0x03,0x3c,0x80,0x87,0x2e,0x26,0x80,0x12,0x0c,0x0c,0x80,0x0c,0x03,	// 000032E0
	0x42,0x80,0x5d,0x2b,0xe3,0x80,0x12,0x30,0x3f,0x80,0x87,0x2f,0x3a,0x80,0x1b,0x2e,	// 000032F0
	0xb0,0x80,0x60,0x35,0x40,0x80,0x0c,0x33,0x7e,0x80,0x06,0x2d,0xa5,0x80,0x8a,0x35,	// 00003300
	0xb2,0x80,0x84,0x2d,0x9f,0x80,0x8d,0x2e,0x20,0x81,0x1d,0x2c,0x85,0x80,0xf3,0x2b,	// 00003310
	0x7a,0x91,0x40,0x1a,0x19,0x80,0x42,0x0e,0x3a,0x80,0x0f,0x0d,0x9e,0x80,0x42,0x0d,	// 00003320
	0x26,0x80,0x4b,0x4b,0xb1,0x80,0x84,0x4b,0x7b,0x80,0x54,0x4c,0x05,0x05,0xa6,0xa3,	// 00003330
	0x9e,0x7a,0x77,0x80,0x8e,0x4c,0x58,0x0c,0xa6,0xa3,0x9e,0xbd,0xba,0xb4,0xea,0xe7,	// 00003340
	0xe0,0xbd,0xba,0xb4,0x80,0x3c,0x4d,0x67,0x80,0x39,0x0d,0x29,0x05,0xea,0xe7,0xe0,	// 00003350
	0xa6,0xa3,0x80,0x37,0x4d,0x69,0x80,0x4e,0x4b,0x7b,0x80,0x06,0x0f,0x60,0x80,0x06,	// 00003360
	0x4d,0xfd,0x06,0xea,0xe7,0xe0,0xdf,0xdc,0xd6,0x80,0x06,0x0f,0x5d,0x05,0xbd,0xba,	// 00003370
	0xb4,0x7a,0x77,0x80,0x58,0x4e,0x26,0x80,0x0c,0x4e,0x00,0x80,0x09,0x4f,0x0b,0x80,	// 00003380
	0x06,0x0f,0x5d,0x80,0x36,0x4d,0x67,0x80,0x51,0x4e,0xb7,0x80,0x12,0x4f,0x17,0x80,	// 00003390
	0x09,0x4d,0xfd,0x80,0x5a,0x4f,0x23,0x80,0x0c,0x4f,0x17,0x80,0x0c,0x4f,0x86,0x80,	// 000033A0
	0x8d,0x4f,0x95,0x80,0x0f,0x0d,0x29,0x80,0x06,0x4f,0x14,0x80,0x5a,0x4d,0x10,0x80,	// 000033B0
	0x09,0x4f,0x0b,0x80,0x09,0x4d,0x67,0x80,0x8d,0x4e,0x7b,0x80,0x18,0x0f,0xbd,0x80,	// 000033C0
	0x60,0x4c,0x05,0x80,0x06,0x4d,0xfd,0x05,0xdf,0xdc,0xd6,0x7a,0x77,0x80,0x97,0x4d,	// 000033D0
	0x63,0x80,0x75,0x52,0x38,0x80,0x06,0x4f,0x14,0x80,0x06,0x4f,0x1d,0x80,0x8a,0x4d,	// 000033E0
	0x67,0x80,0x0c,0x52,0xbf,0x80,0x21,0x51,0x24,0x80,0x54,0x4d,0x16,0x80,0x09,0x4f,	// 000033F0
	0x8f,0x80,0x8a,0x4e,0x7b,0x80,0x12,0x50,0x2e,0x80,0x0c,0x4f,0x86,0x80,0x5d,0x50,	// 00003400
	0x37,0x80,0x12,0x50,0x97,0x80,0x87,0x4f,0x92,0x80,0x1b,0x4f,0x08,0x80,0x60,0x55,	// 00003410
	0x98,0x80,0x0c,0x53,0xd6,0x80,0x12,0x51,0xa5,0x80,0x81,0x4c,0x62,0x80,0x81,0x4d,	// 00003420
	0xfa,0x80,0x8d,0x4e,0x78,0x81,0x1d,0x4c,0xdd,0x80,0xf3,0x4b,0xd2,0x81,0x4a,0x2a,	// 00003430
	0x0f,0x42,0x4d,0x7e,0x87,0x00,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,	// 00003440
	0x28,0x00,0x00,0x00,0x9b,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x01,0x00,0x18,0x80,	// 00003450
	0x05,0x04,0x04,0x48,0x87,0x00,0x00,0x80,0x10,0x24,0x04,0x2a,0x27,0x20,0x2a,0x81,	// 00003460
	0xcd,0x37,0xe4,0x92,0x00,0x33,0x05,0xea,0xe7,0xe0,0x2a,0x27,0x80,0x07,0x66,0x98,	// 00003470
	0x0c,0x2a,0x27,0x20,0x96,0x93,0x8e,0xea,0xe7,0xe0,0x96,0x93,0x8e,0x80,0x15,0x66,	// 00003480
	0xa2,0x80,0x0c,0x66,0x9c,0x81,0x9e,0x64,0xfe,0x80,0x06,0x68,0x6d,0x80,0x0c,0x66,	// 00003490
	0xc3,0x80,0x18,0x68,0x73,0x81,0xc5,0x64,0xf2,0x80,0x12,0x68,0x8b,0x80,0x0f,0x66,	// 000034A0
	0xba,0x81,0x95,0x00,0x78,0x80,0x12,0x66,0xb7,0x80,0x21,0x00,0x36,0x81,0x9b,0x66,	// 000034B0
	0xc9,0x80,0x15,0x66,0x93,0x80,0x21,0x6d,0xe9,0x81,0xa4,0x6a,0x71,0x81,0xd4,0x00,	// 000034C0
	0x39,0x80,0x12,0x6a,0x50,0x80,0x0f,0x68,0x70,0x80,0x12,0x71,0xa3,0x80,0x0f,0x6a,	// 000034D0
	0x74,0x80,0x18,0x6e,0x0d,0x80,0x15,0x6c,0x15,0x80,0x1b,0x6a,0x47,0x80,0x09,0x66,	// 000034E0
	0xab,0x80,0x0c,0x66,0x99,0x80,0x0f,0x68,0x6d,0x80,0x18,0x00,0x36,0x80,0x06,0x66,	// 000034F0
	0xa8,0x80,0x36,0x6a,0x6b,0x80,0x12,0x71,0xa6,0x80,0x1e,0x72,0x33,0x80,0x0f,0x68,	// 00003500
	0x73,0x80,0x0f,0x6c,0x3c,0x80,0x0f,0x6e,0x0d,0x80,0x1e,0x72,0x3f,0x80,0x1e,0x68,	// 00003510
	0x73,0x80,0x1b,0x6c,0x30,0x80,0x18,0x66,0xba,0x80,0x15,0x66,0x93,0x80,0x1b,0x73,	// 00003520
	0x68,0x80,0x18,0x66,0xc0,0x80,0x18,0x73,0x98,0x80,0x15,0x68,0x8b,0x80,0x27,0x73,	// 00003530
	0xb6,0x80,0x21,0x6c,0x2a,0x80,0x27,0x73,0x98,0x80,0x42,0x00,0x36,0x80,0x0f,0x66,	// 00003540
	0xc9,0x80,0x1e,0x72,0x57,0x80,0x2a,0x73,0xe3,0x80,0x06,0x66,0x99,0x80,0x0c,0x6a,	// 00003550
	0x56,0x80,0x1b,0x66,0xbd,0x80,0x12,0x72,0x30,0x80,0x18,0x71,0xa3,0x80,0x24,0x73,	// 00003560
	0x5f,0x80,0x15,0x66,0xb7,0x80,0x1e,0x71,0x97,0x80,0x15,0x72,0x0f,0x80,0x21,0x71,	// 00003570
	0xf7,0x80,0x0f,0x73,0x08,0x80,0x3f,0x74,0x55,0x80,0x12,0x75,0x0f,0x80,0x24,0x72,	// 00003580
	0xa8,0x80,0x18,0x73,0x32,0x80,0x1b,0x73,0x77,0x80,0x39,0x74,0x1c,0x80,0x12,0x75,	// 00003590
	0xc0,0x80,0x2a,0x66,0xc9,0x80,0x1b,0x66,0xb7,0x80,0x24,0x73,0x5f,0x80,0x2d,0x73,	// 000035A0
	0xa1,0x80,0x24,0x73,0xe3,0x80,0x45,0x68,0x73,0x80,0x3f,0x74,0x19,0x80,0x39,0x77,	// 000035B0
	0xd3,0x80,0x12,0x6a,0x71,0x80,0x0c,0x72,0x57,0x80,0x21,0x75,0xfc,0x80,0x1e,0x68,	// 000035C0
	0x7f,0x80,0x0f,0x78,0x4b,0x80,0x1b,0x74,0xfd,0x80,0x15,0x75,0x0c,0x80,0x0c,0x75,	// 000035D0
	0x2d,0x80,0x15,0x66,0xa8,0x80,0x18,0x73,0x3b,0x80,0x12,0x75,0x84,0x80,0x1b,0x74,	// 000035E0
	0xfd,0x80,0x12,0x73,0x08,0x80,0x12,0x79,0x2f,0x80,0x1e,0x71,0xe2,0x80,0x2a,0x00,	// 000035F0
	0x36,0x80,0x2d,0x72,0x57,0x80,0x39,0x74,0x2b,0x80,0x21,0x73,0x83,0x80,0x1e,0x72,	// 00003600
	0xde,0x80,0x1b,0x75,0x4b,0x80,0x2d,0x68,0x8b,0x80,0x1b,0x76,0xb0,0x81,0xe9,0x64,	// 00003610
	0xbf,0x80,0x15,0x71,0xdc,0x80,0x2a,0x7c,0x8f,0x80,0x2d,0x72,0xfc,0x80,0x1b,0x79,	// 00003620
	0x4d,0x80,0x15,0x66,0x99,0x80,0x27,0x68,0x73,0x80,0x15,0x6a,0x50,0x80,0x2d,0x7c,	// 00003630
	0xda,0x80,0x18,0x66,0xbd,0x80,0x12,0x66,0xb7,0x80,0x12,0x66,0xbd,0x80,0x27,0x6d,	// 00003640
	0xfe,0x80,0x1e,0x72,0x30,0x80,0x09,0x73,0x08,0x80,0x30,0x6a,0x71,0x80,0x2a,0x6d,	// 00003650
	0xe3,0x80,0x1e,0x78,0x6c,0x80,0x1e,0x73,0x8f,0x80,0x1b,0x68,0x82,0x80,0x2a,0x78,	// 00003660
	0x69,0x80,0x2d,0x7e,0xa8,0x80,0x3c,0x7e,0x8a,0x80,0x1e,0x73,0x71,0x80,0x21,0x6a,	// 00003670
	0x41,0x80,0x1b,0x68,0x70,0x80,0x21,0x72,0xbd,0x80,0x45,0x6c,0x3c,0x80,0x18,0x68,	// 00003680
	0x67,0x80,0x1e,0x79,0x11,0x80,0x12,0x6e,0x0a,0x80,0x18,0x74,0x10,0x80,0x1e,0x7c,	// 00003690
	0xf2,0x80,0x21,0x78,0x66,0x80,0x1e,0x79,0x11,0x80,0x0f,0x72,0x57,0x80,0x2d,0x7d,	// 000036A0
	0xd6,0x80,0x2d,0x71,0xd0,0x80,0x2d,0x7e,0xd8,0x80,0x0c,0x72,0x57,0x80,0x1e,0x75,	// 000036B0
	0xb1,0x80,0x1e,0x6c,0x15,0x80,0x0c,0x72,0x2a,0x80,0x93,0x7e,0x2a,0x80,0x1b,0x7f,	// 000036C0
	0x53,0x80,0x1b,0x77,0x1f,0x80,0x21,0x77,0x49,0x80,0x2a,0x68,0x70,0x80,0x3c,0x7f,	// 000036D0
	0x11,0x80,0x33,0x7e,0xd5,0x80,0x2d,0x68,0x73,0x80,0x24,0x73,0x0e,0x80,0x2d,0x66,	// 000036E0
	0xc9,0x80,0x1b,0x71,0x8b,0x80,0x36,0x7c,0x9e,0x80,0x1e,0x84,0x15,0x80,0x21,0x80,	// 000036F0
	0x8b,0x80,0x39,0x7e,0x60,0x80,0x1e,0x66,0xa8,0x80,0x1e,0x71,0xdc,0x80,0x24,0x7c,	// 00003700
	0x98,0x80,0x57,0x82,0xbf,0x80,0x1b,0x68,0x70,0x80,0x3f,0x7e,0x1e,0x81,0xd1,0x00,	// 00003710
	0x39,0x42,0x4d,0xee,0x5e,0x01,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,0x00,	// 00003720
	0x28,0x00,0x00,0x00,0x58,0x01,0x00,0x00,0x57,0x00,0x00,0x00,0x01,0x00,0x18,0x80,	// 00003730
	0x05,0x05,0x04,0xb8,0x5e,0x01,0x00,0x80,0x05,0x05,0x83,0x9b,0x25,0x05,0x2a,0x27,	// 00003740
	0x20,0x2a,0x27,0x80,0x73,0x03,0xc8,0x80,0x54,0x00,0x25,0x05,0x5a,0x57,0x50,0x5a,	// 00003750
	0x57,0x83,0x2e,0x04,0x94,0x84,0xec,0x03,0xbd,0x05,0x40,0x3e,0x38,0x00,0x00,0x80,	// 00003760
	0x13,0x00,0x25,0x05,0x40,0x3e,0x38,0x5a,0x57,0x80,0x0a,0x0c,0xaa,0x81,0x44,0x0c,	// 00003770
	0xd5,0x80,0x3f,0x04,0x92,0x81,0x20,0x0d,0x05,0x80,0x1e,0x0c,0xb1,0x80,0x3c,0x0f,	// 00003780
	0x7b,0x80,0x12,0x03,0xbd,0x05,0x47,0x44,0x3d,0x2a,0x27,0x80,0x13,0x03,0xc8,0x80,	// 00003790
	0x48,0x0f,0xe7,0x05,0xae,0xab,0xa6,0x2a,0x27,0x80,0x6d,0x04,0x34,0x09,0x00,0x00,	// 000037A0
	0x00,0x58,0x56,0x50,0x7a,0x77,0x70,0x80,0x0c,0x10,0xbf,0x05,0x58,0x56,0x50,0x00,	// 000037B0
	0x00,0x81,0x5a,0x04,0x91,0x05,0xea,0xe7,0xe0,0x5a,0x57,0x80,0x16,0x12,0x2c,0x80,	// 000037C0
	0x06,0x12,0x45,0x80,0x0f,0x12,0x2a,0x81,0x29,0x06,0x9f,0x80,0x1b,0x10,0xbc,0x80,	// 000037D0
	0x3f,0x13,0x83,0x80,0x0c,0x03,0xc0,0x06,0x47,0x44,0x3d,0x5a,0x57,0x50,0x80,0x12,	// 000037E0
	0x0f,0xe7,0x80,0x48,0x13,0xec,0x06,0xae,0xab,0xa6,0xea,0xe7,0xe0,0x80,0x0c,0x10,	// 000037F0
	0x47,0x80,0x66,0x10,0x56,0x06,0x7a,0x77,0x70,0xea,0xe7,0xe0,0x80,0x0f,0x10,0xbf,	// 00003800
	0x80,0x0c,0x04,0x8f,0x81,0x50,0x0c,0xd5,0x80,0x18,0x12,0x2d,0x80,0x12,0x16,0x44,	// 00003810
	0x80,0x0c,0x12,0x57,0x81,0x20,0x0d,0x05,0x80,0x06,0x14,0xc1,0x80,0x12,0x17,0x8e,	// 00003820
	0x80,0x09,0x13,0x9b,0x80,0x21,0x17,0x8e,0x0f,0xb5,0xb3,0xac,0xa0,0x9d,0x97,0x7a,	// 00003830
	0x77,0x70,0xa0,0x9d,0x97,0xb5,0xb3,0xac,0x80,0x0c,0x17,0xa0,0x80,0x0c,0x03,0xc0,	// 00003840
	0x05,0x5a,0x57,0x50,0x2a,0x27,0x80,0x07,0x17,0xf3,0x80,0x0c,0x03,0xc6,0x80,0x48,	// 00003850
	0x17,0xf4,0x05,0xea,0xe7,0xe0,0x2a,0x27,0x80,0x07,0x18,0x53,0x80,0x6f,0x14,0x58,	// 00003860
	0x0c,0x7a,0x77,0x70,0xbd,0xba,0xb4,0xea,0xe7,0xe0,0xbd,0xba,0xb4,0x80,0x12,0x14,	// 00003870
	0xd3,0x81,0x68,0x10,0xdd,0x80,0x1e,0x16,0x4d,0x81,0x23,0x06,0xa5,0x80,0x09,0x10,	// 00003880
	0xbf,0x80,0x09,0x18,0xd8,0x80,0x0f,0x17,0xa0,0x80,0x06,0x18,0xd2,0x80,0x06,0x12,	// 00003890
	0x45,0x80,0x06,0x18,0xd8,0x80,0x0c,0x17,0xa3,0x0c,0xa0,0x9d,0x97,0xea,0xe7,0xe0,	// 000038A0
	0xb5,0xb3,0xac,0xea,0xe7,0xe0,0x80,0x06,0x17,0xd0,0x80,0xf3,0x17,0xdf,0x80,0x06,	// 000038B0
	0x14,0xc7,0x80,0x09,0x14,0xc7,0x81,0x6b,0x14,0xd9,0x80,0x09,0x12,0x48,0x81,0x47,	// 000038C0
	0x16,0x4d,0x80,0x15,0x18,0xd2,0x80,0x27,0x1f,0x9b,0x80,0x06,0x1b,0xdb,0x80,0x06,	// 000038D0
	0x17,0xd9,0x82,0x64,0x17,0xdc,0x05,0xb5,0xb2,0xac,0xea,0xe7,0x81,0x54,0x1a,0x45,	// 000038E0
	0x80,0x1e,0x1b,0xb7,0x80,0x1e,0x1b,0x99,0x80,0x27,0x1b,0xd5,0x80,0xd5,0x03,0xcc,	// 000038F0
	0x80,0x12,0x17,0x8b,0x80,0x06,0x14,0xc7,0x81,0x5f,0x14,0xd9,0x80,0x18,0x12,0x48,	// 00003900
	0x81,0xa4,0x16,0x50,0x80,0xd8,0x24,0x0c,0x81,0x7d,0x10,0xbc,0x80,0x06,0x22,0x50,	// 00003910
	0x05,0xb5,0xb2,0xac,0x5a,0x57,0x80,0x0d,0x12,0x44,0x80,0x0c,0x2a,0x69,0x81,0x8f,	// 00003920
	0x12,0x5d,0x84,0x08,0x0b,0xdc,0x80,0x06,0x04,0x92,0x80,0x12,0x0f,0xe7,0x80,0x30,	// 00003930
	0x30,0x24,0x80,0x06,0x12,0x45,0x80,0x0f,0x10,0x47,0x80,0x15,0x30,0x21,0x83,0x96,	// 00003940
	0x04,0x3e,0x80,0x5a,0x18,0x0c,0x80,0x18,0x17,0xee,0x84,0x5c,0x30,0x96,0x83,0x42,	// 00003950
	0x00,0x8a,0x84,0x0b,0x34,0x2c,0x84,0x05,0x30,0x27,0x88,0x13,0x07,0xd4,0x82,0x52,	// 00003960
	0x28,0x17,0x81,0xb3,0x12,0x39,0x80,0x09,0x04,0x92,0x80,0x15,0x30,0x2d,0x80,0x15,	// 00003970
	0x18,0x42,0x80,0x06,0x12,0x45,0x80,0x27,0x50,0x6d,0x80,0x12,0x50,0x64,0x83,0x96,	// 00003980
	0x14,0x5e,0x80,0x15,0x17,0xf7,0x80,0x1e,0x54,0x69,0x80,0x12,0x34,0x7a,0x80,0x2d,	// 00003990
	0x54,0x69,0x83,0x96,0x18,0x66,0x80,0xde,0x54,0x6c,0x83,0x2a,0x1c,0xda,0x82,0x4c,	// 000039A0
	0x54,0x6c,0x81,0xbc,0x22,0x50,0x80,0xdb,0x50,0x64,0x8b,0x3d,0x24,0xe7,0x84,0x08,	// 000039B0
	0x03,0xcc,0x80,0x42,0x34,0x5c,0x80,0x30,0x17,0xee,0x84,0x5c,0x6d,0x0e,0x83,0x45,	// 000039C0
	0x38,0xfa,0x80,0x57,0x50,0x7f,0x80,0x6c,0x50,0xbe,0x83,0x5a,0x38,0xfa,0x83,0xf0,	// 000039D0
	0x74,0xc4,0x80,0x2a,0x14,0x34,0x80,0x48,0x13,0xe6,0x84,0xa1,0x08,0x46,0x80,0x96,	// 000039E0
	0x0e,0x1f,0x80,0x21,0x0c,0xa8,0x80,0x63,0x00,0x25,0x80,0x15,0x0c,0xc9,0x80,0x63,	// 000039F0
	0x86,0x6d,0x80,0x78,0x86,0xf1,0x80,0x54,0x86,0xa6,0x80,0x30,0x86,0x76,0x80,0x42,	// 00003A00
	0x0f,0x93,0x81,0x3e,0x4c,0x2f,0x80,0x99,0x12,0x2d,0x06,0x00,0x00,0x00,0x1c,0x1a,	// 00003A10
	0x14,0x80,0x72,0x03,0xc6,0x05,0x1c,0x1a,0x14,0x00,0x00,0x80,0x1c,0x04,0x91,0x80,	// 00003A20
	0x57,0x8a,0x7e,0x80,0x24,0x8a,0xf6,0x80,0x12,0x10,0xbc,0x80,0x06,0x14,0xd6,0x80,	// 00003A30
	0x15,0x17,0x8e,0x80,0x1e,0x8b,0xa4,0x80,0x39,0x8b,0xbf,0x80,0x1b,0x8b,0xa7,0x80,	// 00003A40
	0x0c,0x10,0xce,0x80,0x2d,0x8a,0x7e,0x80,0x09,0x8a,0xf6,0x81,0x3e,0x2b,0xb3,0x80,	// 00003A50
	0x36,0x14,0xc1,0x80,0x96,0x16,0x2f,0x80,0x0c,0x07,0xbc,0x80,0x7b,0x03,0xc6,0x80,	// 00003A60
	0x1b,0x86,0xf4,0x80,0x5a,0x03,0xc3,0x80,0x21,0x8f,0x01,0x80,0x0f,0x1b,0x9c,0x80,	// 00003A70
	0x09,0x1b,0xc3,0x80,0x09,0x1c,0xd4,0x06,0xd5,0xd2,0xcb,0xa9,0xa7,0xa4,0x80,0x12,	// 00003A80
	0x8b,0x9e,0x05,0xa9,0xa7,0xa4,0xea,0xe7,0x80,0x07,0x1c,0xdc,0x80,0x09,0x8f,0xbe,	// 00003A90
	0x80,0x0c,0x8f,0xca,0x80,0x0c,0x8f,0xf1,0x80,0x0c,0x8b,0xa1,0x80,0x1b,0x8f,0x9d,	// 00003AA0
	0x80,0x12,0x1b,0xb7,0x80,0x0c,0x14,0xd6,0x80,0x30,0x03,0xc3,0x80,0x2a,0x17,0xa3,	// 00003AB0
	0x80,0x45,0x17,0xaf,0x80,0x5a,0x80,0xdc,0x80,0x7b,0x81,0x1e,0x80,0x3c,0x18,0xc9,	// 00003AC0
	0x80,0x99,0x1a,0x3d,0x80,0x87,0x8e,0x86,0x80,0x48,0x92,0x7c,0x80,0x18,0x54,0x9f,	// 00003AD0
	0x80,0x2d,0x92,0xfd,0x80,0x0c,0x14,0xc4,0x80,0x06,0x18,0xd2,0x80,0x0f,0x8f,0xac,	// 00003AE0
	0x80,0x06,0x12,0x45,0x05,0xd5,0xd2,0xcb,0x7a,0x77,0x80,0x2e,0x8f,0xc6,0x80,0x09,	// 00003AF0
	0x12,0x45,0x80,0x0f,0x8f,0xdf,0x80,0x0c,0x18,0xd5,0x80,0x0f,0x93,0xb1,0x80,0x1b,	// 00003B00
	0x17,0x8e,0x80,0x45,0x90,0x42,0x80,0x5d,0x1b,0x9f,0x80,0x5a,0x70,0xbc,0x80,0x7b,	// 00003B10
	0x34,0x86,0x80,0x36,0x1c,0xd1,0x80,0x96,0x1e,0x3f,0x81,0x20,0x8e,0x7d,0x80,0x06,	// 00003B20
	0x14,0xc7,0x80,0x09,0x1b,0xb7,0x80,0x15,0x93,0xb4,0x80,0x0c,0x1b,0xc0,0x80,0x42,	// 00003B30
	0x93,0xd5,0x80,0x09,0x18,0xd5,0x80,0x0f,0x93,0xb1,0x80,0x24,0x90,0x27,0x80,0x0c,	// 00003B40
	0x17,0xf4,0x80,0x1e,0x98,0x5b,0x80,0x2d,0x1f,0xb3,0x80,0x42,0x1f,0xc2,0x80,0xde,	// 00003B50
	0x94,0xec,0x80,0x36,0x91,0xc2,0x80,0x96,0x22,0x50,0x81,0xa4,0x92,0x8e,0x80,0x0f,	// 00003B60
	0x18,0xd2,0x80,0x48,0x90,0x39,0x80,0x63,0x23,0xa9,0x80,0xde,0x94,0xec,0x80,0x2d,	// 00003B70
	0x24,0xea,0x80,0x96,0x26,0x4f,0x81,0xaa,0x8e,0x7d,0x80,0x12,0x1b,0x99,0x81,0x83,	// 00003B80
	0x90,0x39,0x80,0x45,0x89,0xac,0x80,0x8d,0x2a,0x69,0x83,0x33,0x8a,0x7e,0x84,0x08,	// 00003B90
	0x85,0xa1,0x87,0x35,0x04,0xa1,0x80,0x7b,0x00,0x25,0x80,0x30,0x8c,0x40,0x80,0x06,	// 00003BA0
	0x10,0xbc,0x05,0x58,0x56,0x50,0x58,0x56,0x80,0x10,0xb1,0xcb,0x83,0x8a,0x00,0x84,	// 00003BB0
	0x80,0x60,0x03,0x93,0x80,0x21,0x8b,0xc2,0x83,0x87,0x04,0x8f,0x80,0x93,0xb5,0x6e,	// 00003BC0
	0x83,0x75,0x85,0xa1,0x80,0x36,0x03,0x93,0x80,0x2d,0x98,0x5b,0x05,0x7a,0x77,0x70,	// 00003BD0
	0x5a,0x57,0x80,0x07,0x10,0xbe,0x80,0x0f,0xbd,0xe4,0x83,0x4b,0x89,0x94,0x80,0x72,	// 00003BE0
	0x10,0x17,0x80,0x60,0xb5,0xa1,0x83,0x33,0x8d,0xb1,0x80,0x75,0x14,0x1c,0x80,0x66,	// 00003BF0
	0xc1,0xb9,0x83,0x2d,0x91,0xbf,0x80,0x75,0x18,0x24,0x80,0x51,0xb1,0x99,0x83,0x42,	// 00003C00
	0x95,0xb2,0x80,0x72,0x18,0x24,0x80,0x1b,0x0c,0xb1,0x80,0x1b,0x0c,0xb1,0x83,0x60,	// 00003C10
	0x99,0x9c,0x80,0x75,0x18,0x24,0x80,0x18,0x10,0xbc,0x09,0x00,0x00,0x00,0x09,0x38,	// 00003C20
	0xa4,0x10,0x50,0xe0,0x80,0x0c,0xd1,0xf7,0x05,0x09,0x38,0xa4,0x00,0x00,0x83,0x61,	// 00003C30
	0x9d,0xa3,0x80,0x75,0x03,0xfc,0x80,0x1b,0xb5,0xd7,0x80,0x0f,0xd1,0xf7,0x80,0x06,	// 00003C40
	0xd1,0xf7,0x83,0xa5,0xa1,0xa9,0x80,0x36,0xd5,0xae,0x80,0x15,0x1b,0xb7,0x80,0x06,	// 00003C50
	0xd5,0xf9,0x05,0x03,0x22,0x6c,0x00,0x00,0x80,0x07,0x00,0x25,0x05,0x03,0x22,0x6c,	// 00003C60
	0x10,0x50,0x80,0x31,0xd6,0x10,0x83,0xa8,0xba,0x09,0x80,0x18,0x18,0xcc,0x80,0x09,	// 00003C70
	0xd5,0xf9,0x80,0x06,0xda,0x07,0x80,0x06,0xda,0x13,0x80,0x33,0xd6,0x0e,0x83,0x63,	// 00003C80
	0x3d,0x11,0x80,0x12,0x30,0x6c,0x80,0x3c,0xd5,0xae,0x80,0x0f,0x1b,0x9f,0x80,0x0c,	// 00003C90
	0xd5,0xf9,0x80,0x09,0xde,0x18,0x83,0x69,0xde,0x1e,0x80,0x72,0x18,0x27,0x80,0x51,	// 00003CA0
	0xd5,0xe1,0x83,0x72,0x38,0xfa,0x80,0xa5,0xd1,0x94,0x83,0xa5,0xe2,0x59,0x80,0x63,	// 00003CB0
	0xcd,0xce,0x83,0xa5,0xde,0x51,0x80,0x63,0xcd,0xce,0x83,0x75,0x49,0x29,0x80,0x96,	// 00003CC0
	0xd1,0xa6,0x83,0x30,0x10,0xbc,0x80,0xd8,0xd5,0x6c,0x83,0x33,0x51,0x3c,0x80,0xd2,	// 00003CD0
	0xd9,0x77,0x83,0x36,0x18,0xc9,0x80,0x3f,0x00,0x50,0x67,0x80,0x93,0x00,0xdd,0xbe,	// 00003CE0
	0x83,0x75,0x00,0x59,0x49,0x80,0x93,0x00,0xe1,0xc6,0x83,0x36,0x00,0x20,0xd9,0x80,	// 00003CF0
	0x7b,0x01,0x05,0xcf,0x80,0x5d,0x00,0xfa,0x32,0x83,0x30,0x00,0x24,0xe7,0x80,0x72,	// 00003D00
	0x01,0x05,0xcf,0x81,0xe0,0x00,0xf6,0x21,0x81,0xb3,0x00,0x2a,0x69,0x80,0x72,0x01,	// 00003D10
	0x01,0xc4,0x84,0x08,0x00,0xf2,0x16,0x80,0x36,0x00,0xcd,0xce,0x80,0x1e,0x00,0xcd,	// 00003D20
	0xe9,0x83,0xb7,0x00,0xb5,0xf2,0x80,0x1b,0x00,0xd1,0xf4,0x80,0x36,0x01,0x1a,0x69,	// 00003D30
	0x83,0xb7,0x00,0xb5,0xf2,0x80,0x06,0x00,0xd6,0x0e,0x80,0x15,0x00,0xd6,0x02,0x80,	// 00003D40
	0x1b,0x00,0xd5,0xfc,0x80,0x06,0x00,0xda,0x04,0x09,0x07,0x32,0x94,0x10,0x50,0xe0,	// 00003D50
	0x07,0x32,0x94,0x80,0x27,0x00,0xda,0x13,0x83,0x9c,0x00,0xe6,0x6d,0x80,0x1b,0x00,	// 00003D60
	0xde,0x0c,0x80,0x1b,0x00,0xe2,0x14,0x80,0x06,0x01,0x1e,0xb0,0x06,0x00,0x00,0x00,	// 00003D70
	0x07,0x32,0x94,0x80,0x06,0x01,0x22,0xb5,0x83,0xc6,0x01,0x1e,0xb9,0x80,0x0f,0x01,	// 00003D80
	0x1e,0x6e,0x80,0x27,0x01,0x22,0x73,0x80,0x0c,0x01,0x22,0xb8,0x80,0x09,0x00,0xd6,	// 00003D90
	0x0e,0x83,0x48,0x00,0x3d,0x02,0x80,0x6f,0x01,0x01,0xca,0x80,0x1e,0x01,0x22,0x79,	// 00003DA0
	0x80,0x18,0x00,0xda,0x07,0x80,0x1b,0x01,0x22,0xaf,0x83,0xb7,0x00,0xe2,0x4a,0x80,	// 00003DB0
	0x12,0x00,0xd6,0x02,0x80,0x3f,0x01,0x1e,0x83,0x83,0x42,0x00,0x0c,0xa2,0x80,0x75,	// 00003DC0
	0x00,0x14,0x1c,0x80,0x60,0x01,0x1a,0x69,0x83,0xa5,0x00,0xf6,0x81,0x80,0x63,0x01,	// 00003DD0
	0x16,0x5e,0x83,0xa5,0x00,0xfa,0x89,0x80,0x69,0x01,0x36,0x9e,0x83,0x30,0x00,0x55,	// 00003DE0
	0x47,0x80,0x8d,0x00,0xf5,0xaf,0x80,0x36,0x01,0x3e,0xb1,0x83,0x42,0x00,0x1c,0xc2,	// 00003DF0
	0x80,0x75,0x00,0x14,0x1c,0x80,0x18,0x00,0x14,0xc4,0x80,0x1e,0x00,0xd5,0xde,0x80,	// 00003E00
	0x18,0x00,0x17,0xca,0x83,0x48,0x00,0x5d,0x3f,0x80,0x78,0x00,0xe5,0x8f,0x80,0x15,	// 00003E10
	0x00,0xdd,0xf7,0x80,0x1b,0x00,0xe1,0xf9,0x80,0x18,0x00,0x1b,0xd2,0x83,0x45,0x00,	// 00003E20
	0x24,0xcf,0x80,0x7b,0x00,0xe5,0x8c,0x80,0x12,0x00,0x1c,0xda,0x80,0x24,0x01,0x46,	// 00003E30
	0xbe,0x80,0x12,0x00,0x1f,0xe0,0x83,0x48,0x01,0x0e,0x9f,0x80,0x90,0x01,0x46,0x4f,	// 00003E40
	0x80,0x18,0x00,0xd9,0xec,0x80,0x2a,0x01,0x46,0xf7,0x83,0xa8,0x01,0x2e,0xf1,0x80,	// 00003E50
	0x18,0x00,0x24,0xe4,0x80,0x48,0x01,0x42,0xd1,0x83,0xa8,0x00,0xb6,0x01,0x80,0x60,	// 00003E60
	0x01,0x3e,0xb1,0x83,0xa5,0x00,0xb6,0x01,0x80,0x54,0x01,0x16,0x5e,0x83,0xb4,0x00,	// 00003E70
	0xb1,0xea,0x33,0x32,0x2c,0x33,0x39,0x2c,0x34,0x32,0x1e,0x2c,0x09,0x2f,0x2f,0x20,	// 00003E80
	0x63,0x6f,0x6c,0x6f,0x72,0x20,0x30,0x20,0x3d,0x20,0x62,0x6c,0x61,0x63,0x6b,0x0d,	// 00003E90
	0x0a,0x38,0x30,0x2c,0x38,0x37,0x2c,0x39,0x30,0x80,0x0b,0x08,0x14,0x31,0x20,0x3d,	// 00003EA0
	0x20,0x67,0x72,0x65,0x79,0x0d,0x0a,0x31,0x31,0x32,0x2c,0x31,0x31,0x39,0x2c,0x31,	// 00003EB0
	0x32,0x80,0x0c,0x07,0x0f,0x32,0x20,0x3d,0x20,0x74,0x6f,0x70,0x20,0x6f,0x66,0x20,	// 00003EC0
	0x73,0x70,0x65,0x63,0x80,0x04,0x39,0x08,0x30,0x2c,0x31,0x31,0x37,0x2c,0x31,0x32,	// 00003ED0
	0x80,0x0c,0x25,0x11,0x33,0x20,0x3d,0x20,0x0d,0x0a,0x31,0x30,0x38,0x2c,0x31,0x31,	// 00003EE0
	0x35,0x2c,0x31,0x31,0x38,0x80,0x0b,0x08,0x04,0x34,0x20,0x3d,0x20,0x80,0x04,0x7c,	// 00003EF0
	0x09,0x36,0x2c,0x31,0x31,0x33,0x2c,0x31,0x31,0x36,0x80,0x0b,0x08,0x04,0x35,0x20,	// 00003F00
	0x3d,0x20,0x80,0x04,0x7c,0x09,0x34,0x2c,0x31,0x31,0x31,0x2c,0x31,0x31,0x34,0x80,	// 00003F10
	0x0b,0x08,0x04,0x36,0x20,0x3d,0x20,0x80,0x04,0x7c,0x06,0x32,0x2c,0x31,0x30,0x39,	// 00003F20
	0x2c,0x80,0x04,0x3b,0x80,0x0a,0x09,0x04,0x37,0x20,0x3d,0x20,0x80,0x04,0x7c,0x06,	// 00003F30
	0x30,0x2c,0x31,0x30,0x37,0x2c,0x80,0x04,0x62,0x80,0x0a,0x09,0x0f,0x38,0x20,0x3d,	// 00003F40
	0x20,0x0d,0x0a,0x39,0x38,0x2c,0x31,0x30,0x35,0x2c,0x31,0x30,0x80,0x0c,0x00,0x88,	// 00003F50
	0x0f,0x39,0x20,0x3d,0x20,0x0d,0x0a,0x39,0x36,0x2c,0x31,0x30,0x33,0x2c,0x31,0x30,	// 00003F60
	0x80,0x0c,0x00,0xa4,0x10,0x31,0x30,0x20,0x3d,0x20,0x0d,0x0a,0x39,0x34,0x2c,0x31,	// 00003F70
	0x30,0x31,0x2c,0x31,0x30,0x80,0x0c,0x00,0xc0,0x0f,0x31,0x31,0x20,0x3d,0x20,0x0d,	// 00003F80
	0x0a,0x39,0x32,0x2c,0x39,0x39,0x2c,0x31,0x30,0x80,0x0c,0x00,0x07,0x0f,0x31,0x32,	// 00003F90
	0x20,0x3d,0x20,0x0d,0x0a,0x39,0x30,0x2c,0x39,0x37,0x2c,0x31,0x30,0x80,0x0d,0x00,	// 00003FA0
	0x25,0x80,0x06,0x00,0x78,0x07,0x38,0x38,0x2c,0x39,0x35,0x2c,0x39,0x80,0x0c,0x00,	// 00003FB0
	0x88,0x0e,0x31,0x34,0x20,0x3d,0x20,0x0d,0x0a,0x38,0x36,0x2c,0x39,0x33,0x2c,0x39,	// 00003FC0
	0x80,0x0d,0x01,0x2e,0x80,0x06,0x00,0xb0,0x80,0x13,0x00,0x00,0x05,0x31,0x36,0x20,	// 00003FD0
	0x3d,0x20,0x80,0x16,0x00,0x1c,0x0a,0x37,0x20,0x3d,0x20,0x62,0x6f,0x74,0x74,0x6f,	// 00003FE0
	0x6d,0x80,0x0a,0x00,0x58,0x0b,0x32,0x32,0x34,0x2c,0x32,0x33,0x31,0x2c,0x32,0x33,	// 00003FF0
	0x34,0x80,0x0b,0x00,0x27,0x09,0x38,0x20,0x3d,0x20,0x6f,0x73,0x63,0x20,0x31,0x80,	// 00004000
	0x18,0x00,0x39,0x1c,0x31,0x39,0x20,0x3d,0x20,0x6f,0x73,0x63,0x20,0x32,0x20,0x28,	// 00004010
	0x73,0x6c,0x69,0x67,0x68,0x74,0x6c,0x79,0x20,0x64,0x69,0x6d,0x6d,0x65,0x72,0x29,	// 00004020
	0x80,0x0d,0x02,0x07,0x80,0x0c,0x00,0x46,0x09,0x30,0x20,0x3d,0x20,0x6f,0x73,0x63,	// 00004030
	0x20,0x33,0x80,0x19,0x02,0x5c,0x09,0x31,0x20,0x3d,0x20,0x6f,0x73,0x63,0x20,0x34,	// 00004040
	0x80,0x19,0x02,0x5c,0x09,0x32,0x20,0x3d,0x20,0x6f,0x73,0x63,0x20,0x35,0x80,0x19,	// 00004050
	0x02,0x5c,0x0f,0x33,0x20,0x3d,0x20,0x70,0x65,0x61,0x6b,0x20,0x64,0x6f,0x74,0x73,	// 00004060
	0x0d,0x0a,0x42,0x4d,0x42,0x59,0x01,0x00,0x00,0x00,0x15,0x00,0x00,0x36,0x00,0x00,	// 00004070
	0x00,0x28,0x00,0x00,0x00,0x44,0x00,0x00,0x00,0xb1,0x01,0x00,0x00,0x01,0x00,0x18,	// 00004080
	0x80,0x05,0x05,0x04,0x0c,0x59,0x01,0x00,0x80,0x05,0x05,0x80,0x0b,0x25,0x06,0x5a,	// 00004090
	0x57,0x50,0x56,0x53,0x4c,0x80,0x21,0x39,0x0c,0x58,0x55,0x4e,0x00,0x00,0x00,0x56,	// 000040A0
	0x53,0x4c,0x52,0x4f,0x48,0x80,0x21,0x66,0x04,0x54,0x51,0x4a,0x00,0x80,0x11,0x25,	// 000040B0
	0x80,0x63,0x8d,0x05,0x40,0x3e,0x38,0x00,0x00,0x80,0x28,0x00,0xe0,0x80,0x2d,0x01,	// 000040C0
	0x02,0x80,0x75,0x00,0x8d,0x06,0x7a,0x77,0x70,0x9a,0x97,0x90,0x80,0x1b,0x01,0xd4,	// 000040D0
	0x05,0x7a,0x77,0x70,0x00,0x00,0x80,0x07,0x00,0x25,0x06,0x58,0x56,0x50,0x7a,0x77,	// 000040E0
	0x70,0x80,0x1b,0x02,0x01,0x05,0x58,0x56,0x50,0x00,0x00,0x80,0x79,0x02,0x22,0x80,	// 000040F0
	0x1e,0x01,0xd4,0x80,0x06,0x01,0xd4,0x80,0x0c,0x01,0xc8,0x80,0x21,0x02,0xca,0x81,	// 00004100
	0x56,0x02,0x22,0x06,0x5a,0x57,0x50,0x5a,0x57,0x50,0x80,0x27,0x02,0xb2,0x80,0x06,	// 00004110
	0x04,0x44,0x81,0x65,0x03,0xab,0x81,0x89,0x02,0xac,0x80,0xc9,0x01,0xd1,0x80,0xcf,	// 00004120
	0x01,0x02,0x83,0x2d,0x08,0x85,0x80,0x06,0x04,0x44,0x83,0x2a,0x0c,0x2a,0x80,0xc0,	// 00004130
	0x08,0x82,0x05,0x40,0x3e,0x38,0x5a,0x57,0x80,0x07,0x0c,0x2c,0x09,0x00,0x00,0x00,	// 00004140
	0x40,0x6c,0x14,0x4f,0x90,0x00,0x80,0xb4,0x10,0x2c,0x05,0x40,0x6c,0x14,0x00,0x00,	// 00004150
	0x80,0x0a,0x0c,0x29,0x05,0x00,0x00,0x00,0x4f,0x90,0x80,0xbb,0x10,0xf4,0x80,0xdb,	// 00004160
	0x10,0xe6,0x80,0xc9,0x10,0x29,0x80,0xcc,0x0f,0x5a,0x82,0x64,0x0c,0x2a,0x85,0x97,	// 00004170
	0x0a,0x92,0x06,0x3f,0x6a,0x14,0x4e,0x8d,0x02,0x80,0xab,0x1c,0x20,0x0b,0x2a,0x27,	// 00004180
	0x20,0x2a,0x27,0x20,0x2a,0x27,0x20,0x1c,0x1a,0x80,0x10,0x10,0xe5,0x80,0xae,0x1c,	// 00004190
	0x20,0x80,0x0c,0x1c,0xcb,0x05,0x2a,0x27,0x20,0x00,0x00,0x80,0xd9,0x1c,0xdc,0x80,	// 000041A0
	0xc9,0x1c,0x1d,0x88,0xc7,0x13,0x56,0x06,0x3d,0x67,0x14,0x4c,0x8a,0x05,0x80,0xa5,	// 000041B0
	0x28,0x14,0x80,0x0c,0x1d,0x9a,0x80,0x15,0x1c,0xd4,0x80,0xa8,0x28,0x14,0x80,0x12,	// 000041C0
	0x28,0xb9,0x80,0x12,0x1d,0xa3,0x80,0xcc,0x28,0xdd,0x80,0xc9,0x28,0x11,0x88,0xc7,	// 000041D0
	0x13,0x56,0x06,0x3c,0x65,0x14,0x4b,0x86,0x07,0x80,0x9f,0x34,0x08,0x80,0x12,0x29,	// 000041E0
	0x88,0x80,0x15,0x1c,0xd4,0x80,0xa2,0x34,0x08,0x80,0x18,0x34,0xa7,0x80,0x12,0x1d,	// 000041F0
	0xa3,0x80,0xcc,0x34,0xd1,0x80,0xc9,0x34,0x05,0x88,0xc7,0x13,0x56,0x06,0x3b,0x62,	// 00004200
	0x14,0x49,0x83,0x0a,0x80,0x99,0x3f,0xfc,0x80,0x18,0x35,0x76,0x80,0x15,0x1c,0xd4,	// 00004210
	0x80,0x9c,0x3f,0xfc,0x80,0x1e,0x40,0x95,0x80,0x12,0x1d,0xa3,0x80,0xcc,0x40,0xc5,	// 00004220
	0x80,0xc9,0x3f,0xf9,0x88,0xc7,0x13,0x56,0x06,0x39,0x5f,0x14,0x48,0x80,0x0c,0x80,	// 00004230
	0x93,0x4b,0xf0,0x80,0x1e,0x41,0x64,0x80,0x15,0x1c,0xd4,0x80,0x96,0x4b,0xf0,0x80,	// 00004240
	0x24,0x4c,0x83,0x80,0x12,0x1d,0xa3,0x80,0xcc,0x4c,0xb9,0x80,0xc9,0x4b,0xed,0x88,	// 00004250
	0xc7,0x13,0x56,0x06,0x38,0x5c,0x14,0x46,0x7c,0x0e,0x80,0x8d,0x57,0xe4,0x80,0x24,	// 00004260
	0x4d,0x52,0x80,0x15,0x1c,0xd4,0x80,0x90,0x57,0xe4,0x80,0x2a,0x58,0x71,0x80,0x12,	// 00004270
	0x1d,0xa3,0x80,0xcc,0x58,0xad,0x80,0xc9,0x57,0xe1,0x83,0xf3,0x13,0x56,0x80,0xd5,	// 00004280
	0x5e,0x35,0x83,0xff,0x0c,0x2a,0x06,0x36,0x5a,0x14,0x45,0x78,0x10,0x80,0x87,0x63,	// 00004290
	0xd8,0x80,0x2a,0x59,0x40,0x80,0x15,0x1c,0xd4,0x80,0x8a,0x63,0xd8,0x80,0x30,0x64,	// 000042A0
	0x5f,0x80,0x12,0x1d,0xa3,0x80,0xcc,0x64,0xa1,0x80,0xc9,0x63,0xd5,0x88,0xc7,0x5b,	// 000042B0
	0x0e,0x06,0x35,0x56,0x14,0x43,0x74,0x11,0x80,0x81,0x6f,0xcc,0x80,0x30,0x65,0x2e,	// 000042C0
	0x80,0x15,0x1c,0xd4,0x80,0x84,0x6f,0xcc,0x80,0x36,0x70,0x4d,0x80,0x12,0x1d,0xa3,	// 000042D0
	0x80,0xcc,0x70,0x95,0x80,0xc9,0x6f,0xc9,0x88,0xc7,0x5b,0x0e,0x06,0x33,0x53,0x14,	// 000042E0
	0x41,0x70,0x13,0x80,0x7b,0x7b,0xc0,0x80,0x36,0x71,0x1c,0x80,0x15,0x1c,0xd4,0x80,	// 000042F0
	0x7e,0x7b,0xc0,0x80,0x3c,0x7c,0x3b,0x80,0x12,0x1d,0xa3,0x80,0xcc,0x7c,0x89,0x80,	// 00004300
	0xc9,0x7b,0xbd,0x88,0xc7,0x13,0x56,0x05,0x32,0x50,0x14,0x40,0x6c,0x80,0x76,0x87,	// 00004310
	0xb3,0x80,0x3c,0x7d,0x0a,0x80,0x15,0x1c,0xd4,0x80,0x78,0x87,0xb4,0x80,0x42,0x88,	// 00004320
	0x29,0x80,0x12,0x1d,0xa3,0x80,0xcc,0x88,0x7d,0x80,0xc9,0x87,0xb1,0x88,0xc7,0x13,	// 00004330
	0x56,0x06,0x30,0x4c,0x14,0x3e,0x67,0x16,0x80,0x6f,0x93,0xa8,0x80,0x42,0x88,0xf8,	// 00004340
	0x80,0x15,0x1c,0xd4,0x80,0x72,0x93,0xa8,0x80,0x48,0x94,0x17,0x80,0x12,0x1d,0xa3,	// 00004350
	0x80,0xcc,0x94,0x71,0x80,0xc9,0x93,0xa5,0x88,0xc7,0x13,0x56,0x06,0x2e,0x49,0x14,	// 00004360
	0x3c,0x63,0x17,0x80,0x69,0x9f,0x9c,0x80,0x48,0x94,0xe6,0x80,0x15,0x1c,0xd4,0x80,	// 00004370
	0x6c,0x9f,0x9c,0x80,0x4e,0xa0,0x05,0x80,0x13,0x36,0x57,0x80,0xcb,0xa0,0x66,0x80,	// 00004380
	0xc9,0x9f,0x99,0x88,0xc7,0x13,0x56,0x06,0x2c,0x45,0x14,0x3a,0x5e,0x18,0x80,0x63,	// 00004390
	0xab,0x90,0x80,0x4e,0xa0,0xd4,0x80,0x15,0x1c,0xd4,0x80,0x66,0xab,0x90,0x80,0x54,	// 000043A0
	0xab,0xf3,0x80,0x12,0x1d,0xa3,0x80,0xcc,0xac,0x59,0x80,0xc9,0xab,0x8d,0x88,0xc7,	// 000043B0
	0x13,0x56,0x06,0x2a,0x41,0x14,0x38,0x58,0x1a,0x80,0x5d,0xb7,0x84,0x80,0x54,0xac,	// 000043C0
	0xc2,0x80,0x15,0x1c,0xd4,0x80,0x60,0xb7,0x84,0x80,0x5a,0xb7,0xe1,0x80,0x13,0x5a,	// 000043D0
	0x33,0x80,0xcb,0xb8,0x4e,0x80,0xc9,0xb7,0x81,0x88,0xc7,0x5b,0x0e,0x06,0x29,0x3d,	// 000043E0
	0x14,0x36,0x53,0x1b,0x80,0x57,0xc3,0x78,0x80,0x5a,0xb8,0xb0,0x80,0x15,0x1c,0xd4,	// 000043F0
	0x80,0x5a,0xc3,0x78,0x80,0x60,0xc3,0xcf,0x80,0x13,0x66,0x27,0x80,0xcb,0xc4,0x42,	// 00004400
	0x80,0xc9,0xc3,0x75,0x88,0xc7,0x5b,0x0e,0x06,0x27,0x3a,0x14,0x35,0x50,0x1b,0x80,	// 00004410
	0x51,0xcf,0x6c,0x80,0x60,0xc4,0x9e,0x80,0x15,0x1c,0xd4,0x80,0x54,0xcf,0x6c,0x80,	// 00004420
	0x66,0xcf,0xbd,0x80,0x13,0x72,0x1b,0x80,0xcb,0xd0,0x36,0x80,0xc9,0xcf,0x69,0x88,	// 00004430
	0xc7,0x13,0x56,0x06,0x26,0x37,0x14,0x34,0x4c,0x1c,0x80,0x4b,0xdb,0x60,0x80,0x66,	// 00004440
	0xd0,0x8c,0x80,0x15,0x1c,0xd4,0x80,0x4e,0xdb,0x60,0x80,0x6c,0xdb,0xab,0x80,0x12,	// 00004450
	0x1d,0xa3,0x80,0xcc,0xdc,0x29,0x80,0xc9,0xdb,0x5d,0x88,0xc7,0x13,0x56,0x06,0x25,	// 00004460
	0x35,0x14,0x33,0x49,0x1c,0x80,0x45,0xe7,0x54,0x80,0x6c,0xdc,0x7a,0x80,0x15,0x1c,	// 00004470
	0xd4,0x80,0x48,0xe7,0x54,0x80,0x72,0xe7,0x99,0x80,0x13,0x7e,0x0f,0x80,0xcb,0xe8,	// 00004480
	0x1e,0x80,0xc9,0xe7,0x51,0x88,0xc7,0x5b,0x0e,0x06,0x24,0x33,0x14,0x32,0x46,0x1d,	// 00004490
	0x80,0x3f,0xf3,0x48,0x80,0x72,0xe8,0x68,0x80,0x15,0x1c,0xd4,0x80,0x42,0xf3,0x48,	// 000044A0
	0x80,0x78,0xf3,0x87,0x80,0x13,0x8a,0x03,0x80,0xcb,0xf4,0x12,0x80,0xc9,0xf3,0x45,	// 000044B0
	0x88,0xc7,0x5b,0x0e,0x06,0x23,0x30,0x14,0x31,0x43,0x1d,0x80,0x39,0xff,0x3c,0x80,	// 000044C0
	0x78,0xf4,0x56,0x80,0x15,0x1c,0xd4,0x80,0x3c,0x00,0xff,0x3c,0x80,0x7e,0x00,0xff,	// 000044D0
	0x75,0x80,0x12,0x00,0x1d,0xa3,0x80,0xcc,0x01,0x00,0x05,0x80,0xc9,0x00,0xff,0x39,	// 000044E0
	0x88,0xc7,0x00,0x5b,0x0e,0x06,0x22,0x2e,0x14,0x30,0x40,0x1e,0x80,0x33,0x01,0x0b,	// 000044F0
	0x30,0x80,0x7e,0x01,0x00,0x44,0x80,0x15,0x00,0x1c,0xd4,0x80,0x36,0x01,0x0b,0x30,	// 00004500
	0x80,0x84,0x01,0x0b,0x63,0x80,0x13,0x00,0x95,0xf7,0x80,0xcb,0x01,0x0b,0xfa,0x80,	// 00004510
	0xc9,0x01,0x0b,0x2d,0x88,0xc7,0x00,0x13,0x56,0x06,0x21,0x2b,0x14,0x2f,0x3d,0x1e,	// 00004520
	0x80,0x2d,0x01,0x17,0x24,0x80,0x84,0x01,0x0c,0x32,0x80,0x15,0x00,0x1c,0xd4,0x80,	// 00004530
	0x30,0x01,0x17,0x24,0x80,0x8a,0x01,0x17,0x51,0x80,0x12,0x00,0x1d,0xa3,0x80,0xcc,	// 00004540
	0x01,0x17,0xed,0x80,0xc9,0x01,0x17,0x21,0x88,0xc7,0x00,0x13,0x56,0x06,0x20,0x28,	// 00004550
	0x14,0x2e,0x39,0x1e,0x80,0x27,0x01,0x23,0x18,0x80,0x8a,0x01,0x18,0x20,0x80,0x15,	// 00004560
	0x00,0x1c,0xd4,0x80,0x2a,0x01,0x23,0x18,0x80,0x90,0x01,0x23,0x3f,0x80,0x13,0x00,	// 00004570
	0xa1,0xeb,0x80,0xcb,0x01,0x23,0xe2,0x80,0xc9,0x01,0x23,0x15,0x88,0xc7,0x00,0x13,	// 00004580
	0x56,0x06,0x1f,0x25,0x14,0x2d,0x35,0x1f,0x80,0x21,0x01,0x2f,0x0c,0x80,0x90,0x01,	// 00004590
	0x24,0x0e,0x80,0x15,0x00,0x1c,0xd4,0x80,0x24,0x01,0x2f,0x0c,0x80,0x96,0x01,0x2f,	// 000045A0
	0x2d,0x80,0x12,0x00,0x1d,0xa3,0x80,0xcc,0x01,0x2f,0xd5,0x80,0xc9,0x01,0x2f,0x09,	// 000045B0
	0x88,0xc7,0x00,0x13,0x56,0x06,0x1e,0x22,0x14,0x2c,0x31,0x1f,0x80,0x1b,0x01,0x3b,	// 000045C0
	0x00,0x80,0x96,0x01,0x2f,0xfc,0x80,0x15,0x00,0x1c,0xd4,0x80,0x1e,0x01,0x3b,0x00,	// 000045D0
	0x80,0x9c,0x01,0x3b,0x1b,0x80,0x13,0x00,0xad,0xdf,0x80,0xcb,0x01,0x3b,0xca,0x80,	// 000045E0
	0xc9,0x01,0x3a,0xfd,0x88,0xc7,0x00,0x13,0x56,0x06,0x1d,0x1e,0x14,0x2b,0x2c,0x20,	// 000045F0
	0x80,0x15,0x01,0x46,0xf4,0x80,0x9c,0x01,0x3b,0xea,0x80,0x15,0x00,0x1c,0xd4,0x80,	// 00004600
	0x18,0x01,0x46,0xf4,0x80,0xa2,0x01,0x47,0x09,0x80,0x12,0x00,0x1d,0xa3,0x80,0xcc,	// 00004610
	0x01,0x47,0xbd,0x80,0xc9,0x01,0x46,0xf1,0x88,0xc7,0x00,0x13,0x56,0x06,0x1c,0x1a,	// 00004620
	0x14,0x2a,0x27,0x20,0x80,0xb4,0x01,0x52,0xe8,0x80,0x12,0x00,0x1c,0xd7,0x80,0xb7,	// 00004630
	0x01,0x52,0xe8,0x80,0x16,0x00,0xb9,0xd0,0x80,0xcb,0x01,0x53,0xb2,0x80,0xc9,0x01,	// 00004640
	0x52,0xe5,0x83,0x30,0x00,0x13,0x56,0x64,0x31,0x31,0x61,0x6d,0x70,0x20,0x74,0x32,	// 00004650
	0x68,0x65,0x6d,0x65,0x20,0x43,0x43,0x2d,0x30,0x2d,0x31,0x2e,0x30,0x20,0x62,0x79,	// 00004660
	0x20,0x43,0x68,0x72,0x69,0x73,0x74,0x69,0x61,0x6e,0x20,0x52,0x75,0x65,0x73,0x63,	// 00004670
	0x68,0x20,0x3c,0x63,0x72,0x40,0x72,0x74,0x2e,0x66,0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,	// 00004680
	0x2d,0x2d,0x80,0x04,0x34,0x1d,0x0d,0x0a,0x43,0x72,0x65,0x61,0x74,0x69,0x76,0x65,	// 00004690
	0x20,0x43,0x6f,0x6d,0x6d,0x6f,0x6e,0x73,0x20,0x4c,0x65,0x67,0x61,0x6c,0x20,0x43,	// 000046A0
	0x6f,0x64,0x65,0x80,0x05,0x3c,0x10,0x43,0x30,0x20,0x31,0x2e,0x30,0x20,0x55,0x6e,	// 000046B0
	0x69,0x76,0x65,0x72,0x73,0x61,0x6c,0x80,0x04,0x34,0x3a,0x20,0x20,0x20,0x20,0x43,	// 000046C0
	0x52,0x45,0x41,0x54,0x49,0x56,0x45,0x20,0x43,0x4f,0x4d,0x4d,0x4f,0x4e,0x53,0x20,	// 000046D0
	0x43,0x4f,0x52,0x50,0x4f,0x52,0x41,0x54,0x49,0x4f,0x4e,0x20,0x49,0x53,0x20,0x4e,	// 000046E0
	0x4f,0x54,0x20,0x41,0x20,0x4c,0x41,0x57,0x20,0x46,0x49,0x52,0x4d,0x20,0x41,0x4e,	// 000046F0
	0x44,0x20,0x44,0x4f,0x45,0x80,0x06,0x96,0x07,0x50,0x52,0x4f,0x56,0x49,0x44,0x45,	// 00004700
	0x80,0x06,0x72,0x18,0x4c,0x45,0x47,0x41,0x4c,0x20,0x53,0x45,0x52,0x56,0x49,0x43,	// 00004710
	0x45,0x53,0x2e,0x20,0x44,0x49,0x53,0x54,0x52,0x49,0x42,0x55,0x80,0x05,0x90,0x10,	// 00004720
	0x4f,0x46,0x20,0x54,0x48,0x49,0x53,0x20,0x44,0x4f,0x43,0x55,0x4d,0x45,0x4e,0x54,	// 00004730
	0x80,0x0a,0xaa,0x80,0x05,0x78,0x04,0x45,0x20,0x41,0x4e,0x80,0x06,0x00,0x72,0x13,	// 00004740
	0x41,0x54,0x54,0x4f,0x52,0x4e,0x45,0x59,0x2d,0x43,0x4c,0x49,0x45,0x4e,0x54,0x20,	// 00004750
	0x52,0x45,0x4c,0x80,0x05,0x00,0x8f,0x05,0x53,0x48,0x49,0x50,0x2e,0x80,0x12,0x00,	// 00004760
	0x77,0x80,0x07,0x00,0xb4,0x06,0x53,0x20,0x54,0x48,0x49,0x53,0x80,0x06,0x00,0x72,	// 00004770
	0x06,0x49,0x4e,0x46,0x4f,0x52,0x4d,0x80,0x06,0x00,0x8f,0x13,0x4f,0x4e,0x20,0x41,	// 00004780
	0x4e,0x20,0x22,0x41,0x53,0x2d,0x49,0x53,0x22,0x20,0x42,0x41,0x53,0x49,0x53,0x80,	// 00004790
	0x13,0x01,0x23,0x12,0x4d,0x41,0x4b,0x45,0x53,0x20,0x4e,0x4f,0x20,0x57,0x41,0x52,	// 000047A0
	0x52,0x41,0x4e,0x54,0x49,0x45,0x80,0x07,0x01,0x42,0x11,0x52,0x45,0x47,0x41,0x52,	// 000047B0
	0x44,0x49,0x4e,0x47,0x20,0x54,0x48,0x45,0x20,0x55,0x53,0x45,0x80,0x12,0x00,0xdd,	// 000047C0
	0x06,0x4f,0x52,0x20,0x54,0x48,0x45,0x80,0x0e,0x01,0x48,0x06,0x52,0x20,0x57,0x4f,	// 000047D0
	0x52,0x4b,0x80,0x07,0x01,0x42,0x80,0x07,0x00,0xb4,0x0c,0x44,0x20,0x48,0x45,0x52,	// 000047E0
	0x45,0x55,0x4e,0x44,0x45,0x52,0x2c,0x80,0x06,0x00,0xa6,0x2d,0x49,0x53,0x43,0x4c,	// 000047F0
	0x41,0x49,0x4d,0x53,0x20,0x4c,0x49,0x41,0x42,0x49,0x4c,0x49,0x54,0x59,0x20,0x46,	// 00004800
	0x4f,0x52,0x20,0x44,0x41,0x4d,0x41,0x47,0x45,0x53,0x20,0x52,0x45,0x53,0x55,0x4c,	// 00004810
	0x54,0x49,0x4e,0x47,0x20,0x46,0x52,0x4f,0x4d,0x80,0x06,0x00,0x72,0x80,0x34,0x01,	// 00004820
	0x9e,0x80,0x09,0x01,0xd7,0x80,0x06,0x00,0x72,0x80,0x09,0x01,0xe1,0x18,0x2e,0x0d,	// 00004830
	0x0a,0x0d,0x0a,0x53,0x74,0x61,0x74,0x65,0x6d,0x65,0x6e,0x74,0x20,0x6f,0x66,0x20,	// 00004840
	0x50,0x75,0x72,0x70,0x6f,0x73,0x80,0x05,0x00,0x5a,0x50,0x54,0x68,0x65,0x20,0x6c,	// 00004850
	0x61,0x77,0x73,0x20,0x6f,0x66,0x20,0x6d,0x6f,0x73,0x74,0x20,0x6a,0x75,0x72,0x69,	// 00004860
	0x73,0x64,0x69,0x63,0x74,0x69,0x6f,0x6e,0x73,0x20,0x74,0x68,0x72,0x6f,0x75,0x67,	// 00004870
	0x68,0x6f,0x75,0x74,0x20,0x74,0x68,0x65,0x20,0x77,0x6f,0x72,0x6c,0x64,0x20,0x61,	// 00004880
	0x75,0x74,0x6f,0x6d,0x61,0x74,0x69,0x63,0x61,0x6c,0x6c,0x79,0x20,0x63,0x6f,0x6e,	// 00004890
	0x66,0x65,0x72,0x0d,0x0a,0x65,0x78,0x63,0x6c,0x75,0x73,0x80,0x06,0x00,0x45,0x2f,	// 000048A0
	0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x61,0x6e,0x64,0x20,0x52,0x65,0x6c,0x61,	// 000048B0
	0x74,0x65,0x64,0x20,0x52,0x69,0x67,0x68,0x74,0x73,0x20,0x28,0x64,0x65,0x66,0x69,	// 000048C0
	0x6e,0x65,0x64,0x20,0x62,0x65,0x6c,0x6f,0x77,0x29,0x20,0x75,0x70,0x6f,0x6e,0x80,	// 000048D0
	0x05,0x02,0xb6,0x14,0x63,0x72,0x65,0x61,0x74,0x6f,0x72,0x0d,0x0a,0x61,0x6e,0x64,	// 000048E0
	0x20,0x73,0x75,0x62,0x73,0x65,0x71,0x75,0x80,0x05,0x02,0x7b,0x0d,0x77,0x6e,0x65,	// 000048F0
	0x72,0x28,0x73,0x29,0x20,0x28,0x65,0x61,0x63,0x68,0x80,0x05,0x02,0xea,0x09,0x61,	// 00004900
	0x6c,0x6c,0x2c,0x20,0x61,0x6e,0x20,0x22,0x80,0x05,0x03,0x2f,0x37,0x22,0x29,0x20,	// 00004910
	0x6f,0x66,0x20,0x61,0x6e,0x20,0x6f,0x72,0x69,0x67,0x69,0x6e,0x61,0x6c,0x20,0x77,	// 00004920
	0x6f,0x72,0x6b,0x20,0x6f,0x66,0x0d,0x0a,0x61,0x75,0x74,0x68,0x6f,0x72,0x73,0x68,	// 00004930
	0x69,0x70,0x20,0x61,0x6e,0x64,0x2f,0x6f,0x72,0x20,0x61,0x20,0x64,0x61,0x74,0x61,	// 00004940
	0x62,0x61,0x73,0x65,0x80,0x06,0x03,0x37,0x0b,0x2c,0x20,0x61,0x20,0x22,0x57,0x6f,	// 00004950
	0x72,0x6b,0x22,0x29,0x80,0x05,0x02,0x70,0x07,0x43,0x65,0x72,0x74,0x61,0x69,0x6e,	// 00004960
	0x80,0x06,0x03,0x2e,0x1d,0x73,0x20,0x77,0x69,0x73,0x68,0x20,0x74,0x6f,0x20,0x70,	// 00004970
	0x65,0x72,0x6d,0x61,0x6e,0x65,0x6e,0x74,0x6c,0x79,0x20,0x72,0x65,0x6c,0x69,0x6e,	// 00004980
	0x71,0x75,0x80,0x05,0x03,0xad,0x05,0x68,0x6f,0x73,0x65,0x20,0x80,0x05,0x02,0xe5,	// 00004990
	0x16,0x73,0x20,0x74,0x6f,0x20,0x61,0x20,0x57,0x6f,0x72,0x6b,0x20,0x66,0x6f,0x72,	// 000049A0
	0x0d,0x0a,0x74,0x68,0x65,0x20,0x70,0x80,0x06,0x02,0x83,0x10,0x20,0x6f,0x66,0x20,	// 000049B0
	0x63,0x6f,0x6e,0x74,0x72,0x69,0x62,0x75,0x74,0x69,0x6e,0x67,0x80,0x06,0x03,0xd7,	// 000049C0
	0x06,0x63,0x6f,0x6d,0x6d,0x6f,0x6e,0x80,0x05,0x02,0x94,0x80,0x05,0x03,0x17,0x1d,	// 000049D0
	0x69,0x76,0x65,0x2c,0x20,0x63,0x75,0x6c,0x74,0x75,0x72,0x61,0x6c,0x20,0x61,0x6e,	// 000049E0
	0x64,0x0d,0x0a,0x73,0x63,0x69,0x65,0x6e,0x74,0x69,0x66,0x69,0x63,0x80,0x05,0x03,	// 000049F0
	0x61,0x05,0x73,0x20,0x28,0x22,0x43,0x80,0x06,0x00,0x4a,0x06,0x22,0x29,0x20,0x74,	// 00004A00
	0x68,0x61,0x80,0x06,0x02,0xb5,0x0a,0x70,0x75,0x62,0x6c,0x69,0x63,0x20,0x63,0x61,	// 00004A10
	0x6e,0x80,0x05,0x03,0xbf,0x0c,0x61,0x62,0x6c,0x79,0x20,0x61,0x6e,0x64,0x20,0x77,	// 00004A20
	0x69,0x74,0x80,0x05,0x02,0xb2,0x14,0x66,0x65,0x61,0x72,0x0d,0x0a,0x6f,0x66,0x20,	// 00004A30
	0x6c,0x61,0x74,0x65,0x72,0x20,0x63,0x6c,0x61,0x69,0x6d,0x80,0x05,0x02,0x94,0x07,	// 00004A40
	0x69,0x6e,0x66,0x72,0x69,0x6e,0x67,0x80,0x06,0x02,0x79,0x05,0x62,0x75,0x69,0x6c,	// 00004A50
	0x64,0x80,0x05,0x03,0x0d,0x20,0x2c,0x20,0x6d,0x6f,0x64,0x69,0x66,0x79,0x2c,0x20,	// 00004A60
	0x69,0x6e,0x63,0x6f,0x72,0x70,0x6f,0x72,0x61,0x74,0x65,0x20,0x69,0x6e,0x20,0x6f,	// 00004A70
	0x74,0x68,0x65,0x72,0x0d,0x0a,0x80,0x05,0x04,0x36,0x07,0x2c,0x20,0x72,0x65,0x75,	// 00004A80
	0x73,0x65,0x80,0x05,0x02,0xea,0x05,0x72,0x65,0x64,0x69,0x73,0x80,0x06,0x03,0xf9,	// 00004A90
	0x16,0x65,0x20,0x61,0x73,0x20,0x66,0x72,0x65,0x65,0x6c,0x79,0x20,0x61,0x73,0x20,	// 00004AA0
	0x70,0x6f,0x73,0x73,0x69,0x62,0x6c,0x80,0x05,0x04,0xb5,0x12,0x61,0x6e,0x79,0x20,	// 00004AB0
	0x66,0x6f,0x72,0x6d,0x20,0x77,0x68,0x61,0x74,0x73,0x6f,0x65,0x76,0x65,0x80,0x07,	// 00004AC0
	0x03,0x1d,0x07,0x66,0x6f,0x72,0x20,0x61,0x6e,0x79,0x80,0x08,0x03,0xea,0x0c,0x73,	// 00004AD0
	0x2c,0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x69,0x6e,0x67,0x80,0x09,0x04,0x68,0x0a,	// 00004AE0
	0x6c,0x69,0x6d,0x69,0x74,0x61,0x74,0x69,0x6f,0x6e,0x80,0x05,0x04,0x07,0x06,0x65,	// 00004AF0
	0x72,0x63,0x69,0x61,0x6c,0x80,0x09,0x05,0x18,0x08,0x2e,0x0d,0x0a,0x54,0x68,0x65,	// 00004B00
	0x73,0x65,0x80,0x08,0x03,0xa4,0x05,0x6d,0x61,0x79,0x20,0x63,0x80,0x08,0x03,0xf7,	// 00004B10
	0x07,0x65,0x20,0x74,0x6f,0x20,0x74,0x68,0x80,0x0a,0x00,0x47,0x0a,0x74,0x6f,0x20,	// 00004B20
	0x70,0x72,0x6f,0x6d,0x6f,0x74,0x65,0x80,0x05,0x02,0xb6,0x05,0x69,0x64,0x65,0x61,	// 00004B30
	0x6c,0x80,0x05,0x03,0x52,0x80,0x05,0x04,0xe1,0x08,0x0d,0x0a,0x63,0x75,0x6c,0x74,	// 00004B40
	0x75,0x72,0x80,0x06,0x04,0xcc,0x11,0x74,0x68,0x65,0x20,0x66,0x75,0x72,0x74,0x68,	// 00004B50
	0x65,0x72,0x20,0x70,0x72,0x6f,0x64,0x75,0x80,0x05,0x02,0xa5,0x80,0x1a,0x04,0x0f,	// 00004B60
	0x05,0x20,0x73,0x63,0x69,0x65,0x80,0x06,0x04,0x2f,0x80,0x09,0x04,0xbf,0x0f,0x6f,	// 00004B70
	0x72,0x20,0x74,0x6f,0x20,0x67,0x61,0x69,0x6e,0x20,0x72,0x65,0x70,0x75,0x80,0x07,	// 00004B80
	0x05,0x39,0x06,0x6f,0x72,0x20,0x67,0x72,0x65,0x80,0x05,0x04,0x7b,0x80,0x09,0x04,	// 00004B90
	0xd4,0x0d,0x69,0x6f,0x6e,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x69,0x72,0x80,	// 00004BA0
	0x06,0x03,0xdc,0x08,0x69,0x6e,0x0d,0x0a,0x70,0x61,0x72,0x74,0x80,0x08,0x02,0xab,	// 00004BB0
	0x80,0x05,0x02,0xb6,0x80,0x08,0x04,0xca,0x06,0x65,0x66,0x66,0x6f,0x72,0x74,0x80,	// 00004BC0
	0x05,0x02,0x94,0x80,0x05,0x04,0xba,0x07,0x73,0x2e,0x0d,0x0a,0x0d,0x0a,0x46,0x80,	// 00004BD0
	0x06,0x06,0x20,0x80,0x06,0x04,0xcb,0x05,0x2f,0x6f,0x72,0x20,0x6f,0x80,0x06,0x05,	// 00004BE0
	0xb4,0x80,0x07,0x05,0x1a,0x80,0x05,0x02,0xea,0x05,0x6d,0x6f,0x74,0x69,0x76,0x80,	// 00004BF0
	0x05,0x05,0x3a,0x05,0x73,0x2c,0x20,0x61,0x6e,0x80,0x0a,0x04,0x67,0x0a,0x61,0x6e,	// 00004C00
	0x79,0x0d,0x0a,0x65,0x78,0x70,0x65,0x63,0x80,0x08,0x06,0x00,0x15,0x66,0x20,0x61,	// 00004C10
	0x64,0x64,0x69,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x20,0x63,0x6f,0x6e,0x73,0x69,0x64,	// 00004C20
	0x65,0x72,0x80,0x09,0x06,0x01,0x07,0x63,0x6f,0x6d,0x70,0x65,0x6e,0x73,0x80,0x05,	// 00004C30
	0x05,0x3a,0x15,0x2c,0x20,0x74,0x68,0x65,0x20,0x70,0x65,0x72,0x73,0x6f,0x6e,0x0d,	// 00004C40
	0x0a,0x61,0x73,0x73,0x6f,0x63,0x69,0x61,0x80,0x05,0x03,0xfe,0x08,0x43,0x43,0x30,	// 00004C50
	0x20,0x77,0x69,0x74,0x68,0x80,0x08,0x03,0xda,0x11,0x28,0x74,0x68,0x65,0x20,0x22,	// 00004C60
	0x41,0x66,0x66,0x69,0x72,0x6d,0x65,0x72,0x22,0x29,0x2c,0x80,0x08,0x05,0x71,0x06,	// 00004C70
	0x65,0x78,0x74,0x65,0x6e,0x74,0x80,0x06,0x04,0x47,0x0d,0x68,0x65,0x20,0x6f,0x72,	// 00004C80
	0x20,0x73,0x68,0x65,0x0d,0x0a,0x69,0x73,0x80,0x05,0x03,0x55,0x07,0x77,0x6e,0x65,	// 00004C90
	0x72,0x20,0x6f,0x66,0x80,0x1e,0x02,0xe0,0x06,0x69,0x6e,0x20,0x74,0x68,0x65,0x80,	// 00004CA0
	0x05,0x03,0xdc,0x13,0x2c,0x20,0x76,0x6f,0x6c,0x75,0x6e,0x74,0x61,0x72,0x69,0x6c,	// 00004CB0
	0x79,0x0d,0x0a,0x65,0x6c,0x65,0x63,0x80,0x07,0x03,0xd5,0x08,0x70,0x70,0x6c,0x79,	// 00004CC0
	0x20,0x43,0x43,0x30,0x80,0x08,0x05,0x71,0x80,0x05,0x03,0xdd,0x05,0x61,0x6e,0x64,	// 00004CD0
	0x20,0x70,0x80,0x05,0x04,0x52,0x05,0x6c,0x79,0x20,0x64,0x69,0x80,0x09,0x04,0xd6,	// 00004CE0
	0x80,0x09,0x07,0x91,0x11,0x75,0x6e,0x64,0x65,0x72,0x20,0x69,0x74,0x73,0x0d,0x0a,	// 00004CF0
	0x74,0x65,0x72,0x6d,0x73,0x2c,0x80,0x06,0x06,0xf7,0x08,0x6b,0x6e,0x6f,0x77,0x6c,	// 00004D00
	0x65,0x64,0x67,0x80,0x05,0x03,0xf1,0x0a,0x68,0x69,0x73,0x20,0x6f,0x72,0x20,0x68,	// 00004D10
	0x65,0x72,0x80,0x24,0x07,0x42,0x05,0x0d,0x0a,0x57,0x6f,0x72,0x80,0x06,0x07,0x98,	// 00004D20
	0x0b,0x74,0x68,0x65,0x20,0x6d,0x65,0x61,0x6e,0x69,0x6e,0x67,0x80,0x05,0x02,0xea,	// 00004D30
	0x0a,0x69,0x6e,0x74,0x65,0x6e,0x64,0x65,0x64,0x20,0x6c,0x80,0x05,0x00,0x52,0x05,	// 00004D40
	0x65,0x66,0x66,0x65,0x63,0x80,0x05,0x02,0x7d,0x06,0x43,0x43,0x30,0x20,0x6f,0x6e,	// 00004D50
	0x80,0x0d,0x03,0xca,0x80,0x05,0x02,0x70,0x05,0x31,0x2e,0x20,0x43,0x6f,0x80,0x1a,	// 00004D60
	0x02,0xe3,0x17,0x2e,0x20,0x41,0x20,0x57,0x6f,0x72,0x6b,0x20,0x6d,0x61,0x64,0x65,	// 00004D70
	0x20,0x61,0x76,0x61,0x69,0x6c,0x61,0x62,0x6c,0x65,0x80,0x07,0x07,0xba,0x1a,0x43,	// 00004D80
	0x43,0x30,0x20,0x6d,0x61,0x79,0x20,0x62,0x65,0x0d,0x0a,0x70,0x72,0x6f,0x74,0x65,	// 00004D90
	0x63,0x74,0x65,0x64,0x20,0x62,0x79,0x20,0x63,0x80,0x0d,0x02,0xe2,0x16,0x72,0x65,	// 00004DA0
	0x6c,0x61,0x74,0x65,0x64,0x20,0x6f,0x72,0x20,0x6e,0x65,0x69,0x67,0x68,0x62,0x6f,	// 00004DB0
	0x72,0x69,0x6e,0x67,0x80,0x08,0x03,0xd0,0x05,0x28,0x22,0x43,0x6f,0x70,0x80,0x0a,	// 00004DC0
	0x02,0xe4,0x05,0x0d,0x0a,0x52,0x65,0x6c,0x80,0x0b,0x02,0xf2,0x05,0x22,0x29,0x2e,	// 00004DD0
	0x20,0x43,0x80,0x1e,0x07,0x44,0x14,0x63,0x6c,0x75,0x64,0x65,0x2c,0x20,0x62,0x75,	// 00004DE0
	0x74,0x20,0x61,0x72,0x65,0x20,0x6e,0x6f,0x74,0x0d,0x0a,0x80,0x05,0x05,0x35,0x05,	// 00004DF0
	0x65,0x64,0x20,0x74,0x6f,0x80,0x06,0x06,0xda,0x0a,0x66,0x6f,0x6c,0x6c,0x6f,0x77,	// 00004E00
	0x69,0x6e,0x67,0x3a,0x80,0x06,0x00,0x70,0x05,0x69,0x2e,0x20,0x74,0x68,0x80,0x07,	// 00004E10
	0x03,0xcf,0x06,0x20,0x74,0x6f,0x20,0x72,0x65,0x80,0x06,0x05,0xb9,0x09,0x65,0x2c,	// 00004E20
	0x20,0x61,0x64,0x61,0x70,0x74,0x2c,0x80,0x0b,0x07,0xa6,0x09,0x2c,0x20,0x70,0x65,	// 00004E30
	0x72,0x66,0x6f,0x72,0x6d,0x80,0x05,0x09,0x71,0x05,0x70,0x6c,0x61,0x79,0x2c,0x80,	// 00004E40
	0x06,0x00,0x72,0x80,0x05,0x04,0x07,0x07,0x75,0x6e,0x69,0x63,0x61,0x74,0x65,0x80,	// 00004E50
	0x06,0x06,0x90,0x09,0x74,0x72,0x61,0x6e,0x73,0x6c,0x61,0x74,0x65,0x80,0x07,0x03,	// 00004E60
	0xda,0x0d,0x3b,0x0d,0x0a,0x20,0x69,0x69,0x2e,0x20,0x6d,0x6f,0x72,0x61,0x6c,0x80,	// 00004E70
	0x08,0x03,0xd0,0x05,0x72,0x65,0x74,0x61,0x69,0x80,0x05,0x03,0x03,0x05,0x79,0x20,	// 00004E80
	0x74,0x68,0x65,0x80,0x0a,0x03,0x58,0x80,0x06,0x03,0x6b,0x05,0x28,0x73,0x29,0x20,	// 00004E90
	0x61,0x80,0x06,0x03,0x77,0x80,0x07,0x09,0x7f,0x80,0x05,0x03,0x32,0x07,0x3b,0x0d,	// 00004EA0
	0x0a,0x69,0x69,0x69,0x2e,0x80,0x07,0x04,0x50,0x0f,0x69,0x74,0x79,0x20,0x61,0x6e,	// 00004EB0
	0x64,0x20,0x70,0x72,0x69,0x76,0x61,0x63,0x79,0x80,0x08,0x03,0xd0,0x06,0x70,0x65,	// 00004EC0
	0x72,0x74,0x61,0x69,0x80,0x05,0x08,0x1f,0x80,0x05,0x03,0xd8,0x80,0x06,0x06,0xe0,	// 00004ED0
	0x0b,0x27,0x73,0x20,0x69,0x6d,0x61,0x67,0x65,0x20,0x6f,0x72,0x80,0x07,0x09,0x90,	// 00004EE0
	0x0d,0x6c,0x69,0x6b,0x65,0x6e,0x65,0x73,0x73,0x20,0x64,0x65,0x70,0x69,0x80,0x05,	// 00004EF0
	0x08,0xa7,0x05,0x69,0x6e,0x20,0x61,0x20,0x80,0x09,0x09,0xb4,0x05,0x76,0x2e,0x20,	// 00004F00
	0x72,0x69,0x80,0x06,0x0a,0x23,0x80,0x06,0x08,0xa3,0x80,0x05,0x08,0x20,0x0c,0x67,	// 00004F10
	0x61,0x69,0x6e,0x73,0x74,0x20,0x75,0x6e,0x66,0x61,0x69,0x80,0x07,0x06,0xcc,0x07,	// 00004F20
	0x74,0x69,0x74,0x69,0x6f,0x6e,0x20,0x80,0x05,0x05,0xf9,0x05,0x67,0x61,0x72,0x64,	// 00004F30
	0x73,0x80,0x0a,0x03,0xd7,0x80,0x08,0x09,0x8f,0x06,0x73,0x75,0x62,0x6a,0x65,0x63,	// 00004F40
	0x80,0x05,0x09,0x5c,0x05,0x74,0x68,0x65,0x20,0x6c,0x80,0x09,0x05,0x36,0x80,0x05,	// 00004F50
	0x07,0x5e,0x0f,0x70,0x61,0x72,0x61,0x67,0x72,0x61,0x70,0x68,0x20,0x34,0x28,0x61,	// 00004F60
	0x29,0x2c,0x80,0x06,0x03,0x06,0x05,0x3b,0x0d,0x0a,0x20,0x20,0x80,0x15,0x0a,0x70,	// 00004F70
	0x80,0x07,0x07,0x19,0x07,0x72,0x61,0x63,0x74,0x69,0x6f,0x6e,0x80,0x05,0x09,0x71,	// 00004F80
	0x05,0x73,0x65,0x6d,0x69,0x6e,0x80,0x07,0x06,0xd5,0x80,0x0a,0x04,0xca,0x06,0x75,	// 00004F90
	0x73,0x65,0x20,0x6f,0x66,0x80,0x05,0x03,0x7e,0x80,0x07,0x09,0x90,0x80,0x0d,0x0a,	// 00004FA0
	0x62,0x05,0x76,0x69,0x2e,0x20,0x64,0x80,0x08,0x03,0x80,0x80,0x08,0x08,0xd4,0x07,	// 00004FB0
	0x73,0x75,0x63,0x68,0x20,0x61,0x73,0x80,0x07,0x03,0xca,0x07,0x61,0x72,0x69,0x73,	// 00004FC0
	0x69,0x6e,0x67,0x80,0x07,0x07,0xba,0x05,0x44,0x69,0x72,0x65,0x63,0x80,0x05,0x00,	// 00004FD0
	0x44,0x0a,0x39,0x36,0x2f,0x39,0x2f,0x45,0x43,0x20,0x6f,0x66,0x80,0x06,0x08,0x09,	// 00004FE0
	0x80,0x05,0x09,0x92,0x0f,0x45,0x75,0x72,0x6f,0x70,0x65,0x61,0x6e,0x20,0x50,0x61,	// 00004FF0
	0x72,0x6c,0x69,0x61,0x80,0x05,0x02,0x7a,0x05,0x61,0x6e,0x64,0x20,0x6f,0x80,0x05,	// 00005000
	0x0b,0x95,0x07,0x20,0x43,0x6f,0x75,0x6e,0x63,0x69,0x80,0x05,0x05,0x94,0x0d,0x31,	// 00005010
	0x31,0x20,0x4d,0x61,0x72,0x63,0x68,0x20,0x31,0x39,0x39,0x36,0x80,0x06,0x08,0x44,	// 00005020
	0x07,0x65,0x20,0x6c,0x65,0x67,0x61,0x6c,0x80,0x07,0x09,0x90,0x80,0x08,0x0a,0x7a,	// 00005030
	0x80,0x06,0x05,0xc1,0x80,0x08,0x03,0x7f,0x80,0x07,0x06,0x8f,0x80,0x06,0x07,0xbb,	// 00005040
	0x05,0x61,0x6e,0x79,0x20,0x6e,0x80,0x05,0x05,0x3a,0x07,0x61,0x6c,0x20,0x69,0x6d,	// 00005050
	0x70,0x6c,0x80,0x05,0x02,0x79,0x80,0x05,0x05,0x3a,0x80,0x07,0x09,0x90,0x07,0x74,	// 00005060
	0x68,0x65,0x72,0x65,0x6f,0x66,0x80,0x0c,0x05,0x21,0x06,0x61,0x6e,0x79,0x20,0x61,	// 00005070
	0x6d,0x80,0x06,0x08,0x2b,0x11,0x6f,0x72,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,	// 00005080
	0x6f,0x72,0x20,0x76,0x65,0x72,0x73,0x80,0x07,0x05,0xc0,0x05,0x73,0x75,0x63,0x68,	// 00005090
	0x0d,0x80,0x06,0x09,0x91,0x0b,0x64,0x69,0x72,0x65,0x63,0x74,0x69,0x76,0x65,0x29,	// 000050A0
	0x3b,0x80,0x06,0x04,0x25,0x05,0x76,0x69,0x69,0x2e,0x20,0x80,0x06,0x06,0x72,0x10,	// 000050B0
	0x73,0x69,0x6d,0x69,0x6c,0x61,0x72,0x2c,0x20,0x65,0x71,0x75,0x69,0x76,0x61,0x6c,	// 000050C0
	0x80,0x05,0x02,0x7b,0x0b,0x72,0x20,0x63,0x6f,0x72,0x72,0x65,0x73,0x70,0x6f,0x6e,	// 000050D0
	0x80,0x05,0x05,0x28,0x80,0x08,0x03,0xd1,0x80,0x0d,0x02,0xad,0x80,0x07,0x09,0x90,	// 000050E0
	0x80,0x06,0x02,0xbb,0x08,0x62,0x61,0x73,0x65,0x64,0x20,0x6f,0x6e,0x80,0x05,0x07,	// 000050F0
	0x83,0x05,0x69,0x63,0x61,0x62,0x6c,0x80,0x05,0x02,0x8f,0x80,0x05,0x05,0xf0,0x05,	// 00005100
	0x72,0x65,0x61,0x74,0x79,0x80,0x06,0x06,0x90,0x80,0x0c,0x0c,0x0f,0x80,0x08,0x0b,	// 00005110
	0x3d,0x80,0x0d,0x0c,0x1d,0x09,0x73,0x20,0x74,0x68,0x65,0x72,0x65,0x6f,0x66,0x80,	// 00005120
	0x05,0x02,0x70,0x0c,0x32,0x2e,0x20,0x57,0x61,0x69,0x76,0x65,0x72,0x2e,0x20,0x54,	// 00005130
	0x80,0x06,0x05,0x73,0x80,0x06,0x06,0x0a,0x05,0x73,0x74,0x20,0x65,0x78,0x80,0x05,	// 00005140
	0x07,0x1f,0x06,0x70,0x65,0x72,0x6d,0x69,0x74,0x80,0x06,0x08,0xa8,0x80,0x06,0x09,	// 00005150
	0x22,0x06,0x6e,0x6f,0x74,0x20,0x69,0x6e,0x80,0x06,0x03,0xf5,0x05,0x61,0x76,0x65,	// 00005160
	0x6e,0x74,0x80,0x05,0x0c,0x27,0x05,0x6f,0x66,0x2c,0x20,0x61,0x80,0x0d,0x0c,0xe0,	// 00005170
	0x05,0x2c,0x20,0x41,0x66,0x66,0x80,0x05,0x07,0x0d,0x16,0x20,0x68,0x65,0x72,0x65,	// 00005180
	0x62,0x79,0x20,0x6f,0x76,0x65,0x72,0x74,0x6c,0x79,0x2c,0x20,0x66,0x75,0x6c,0x6c,	// 00005190
	0x79,0x80,0x05,0x09,0x7d,0x80,0x08,0x03,0xb7,0x0a,0x2c,0x0d,0x0a,0x69,0x72,0x72,	// 000051A0
	0x65,0x76,0x6f,0x63,0x80,0x09,0x04,0x60,0x05,0x75,0x6e,0x63,0x6f,0x6e,0x80,0x08,	// 000051B0
	0x06,0xb4,0x07,0x6c,0x79,0x20,0x77,0x61,0x69,0x76,0x80,0x05,0x0c,0x01,0x05,0x62,	// 000051C0
	0x61,0x6e,0x64,0x6f,0x80,0x08,0x06,0x8e,0x0e,0x73,0x75,0x72,0x72,0x65,0x6e,0x64,	// 000051D0
	0x65,0x72,0x73,0x20,0x61,0x6c,0x6c,0x80,0x05,0x03,0x66,0x80,0x08,0x07,0x0a,0x05,	// 000051E0
	0x27,0x73,0x20,0x43,0x6f,0x80,0x1b,0x02,0xe3,0x80,0x05,0x03,0x3e,0x80,0x07,0x06,	// 000051F0
	0xe9,0x05,0x65,0x64,0x20,0x63,0x6c,0x80,0x05,0x04,0x82,0x0a,0x61,0x6e,0x64,0x20,	// 00005200
	0x63,0x61,0x75,0x73,0x65,0x73,0x80,0x05,0x04,0x75,0x80,0x08,0x0b,0x11,0x0b,0x77,	// 00005210
	0x68,0x65,0x74,0x68,0x65,0x72,0x20,0x6e,0x6f,0x77,0x80,0x05,0x07,0xd1,0x80,0x05,	// 00005220
	0x06,0x05,0x09,0x75,0x6e,0x6b,0x6e,0x6f,0x77,0x6e,0x20,0x28,0x80,0x0a,0x05,0x23,	// 00005230
	0x05,0x65,0x78,0x69,0x73,0x74,0x80,0x05,0x08,0x20,0x0d,0x73,0x20,0x77,0x65,0x6c,	// 00005240
	0x6c,0x20,0x61,0x73,0x0d,0x0a,0x66,0x75,0x80,0x05,0x05,0xa4,0x80,0x11,0x0e,0x38,	// 00005250
	0x80,0x05,0x03,0x52,0x80,0x05,0x02,0xa5,0x05,0x29,0x2c,0x20,0x69,0x6e,0x80,0x0a,	// 00005260
	0x07,0x90,0x06,0x28,0x69,0x29,0x20,0x69,0x6e,0x80,0x05,0x0d,0xf8,0x0b,0x74,0x65,	// 00005270
	0x72,0x72,0x69,0x74,0x6f,0x72,0x69,0x65,0x73,0x80,0x05,0x04,0xbf,0x0c,0x6c,0x64,	// 00005280
	0x77,0x69,0x64,0x65,0x2c,0x20,0x28,0x69,0x69,0x29,0x80,0x08,0x06,0x1e,0x0b,0x20,	// 00005290
	0x6d,0x61,0x78,0x69,0x6d,0x75,0x6d,0x20,0x64,0x75,0x80,0x07,0x06,0xc4,0x06,0x70,	// 000052A0
	0x72,0x6f,0x76,0x69,0x64,0x80,0x06,0x08,0xa9,0x80,0x11,0x0c,0xdf,0x08,0x0d,0x0a,	// 000052B0
	0x74,0x72,0x65,0x61,0x74,0x79,0x80,0x0c,0x0e,0x72,0x80,0x07,0x0e,0x93,0x05,0x74,	// 000052C0
	0x69,0x6d,0x65,0x20,0x80,0x05,0x07,0x1d,0x06,0x73,0x69,0x6f,0x6e,0x73,0x29,0x80,	// 000052D0
	0x05,0x0e,0xe5,0x80,0x07,0x0e,0xc5,0x07,0x6e,0x79,0x20,0x63,0x75,0x72,0x72,0x80,	// 000052E0
	0x07,0x0c,0x9f,0x80,0x06,0x0e,0x93,0x08,0x0d,0x0a,0x6d,0x65,0x64,0x69,0x75,0x6d,	// 000052F0
	0x80,0x05,0x02,0xea,0x80,0x08,0x05,0x11,0x05,0x6e,0x75,0x6d,0x62,0x65,0x80,0x05,	// 00005300
	0x07,0x3e,0x05,0x63,0x6f,0x70,0x69,0x65,0x80,0x07,0x06,0x8f,0x05,0x28,0x69,0x76,	// 00005310
	0x29,0x20,0x80,0x0f,0x05,0x11,0x80,0x0b,0x05,0x00,0x05,0x2c,0x0d,0x0a,0x69,0x6e,	// 00005320
	0x80,0x25,0x05,0x25,0x08,0x2c,0x20,0x61,0x64,0x76,0x65,0x72,0x74,0x80,0x06,0x0b,	// 00005330
	0x76,0x08,0x6f,0x72,0x20,0x70,0x72,0x6f,0x6d,0x6f,0x80,0x08,0x0d,0x03,0x80,0x09,	// 00005340
	0x06,0x78,0x80,0x06,0x07,0x04,0x80,0x06,0x0d,0x2f,0x05,0x22,0x29,0x2e,0x20,0x41,	// 00005350
	0x80,0x08,0x0d,0x8b,0x05,0x6d,0x61,0x6b,0x65,0x73,0x80,0x06,0x07,0x62,0x80,0x05,	// 00005360
	0x0d,0x30,0x80,0x09,0x0e,0xeb,0x06,0x62,0x65,0x6e,0x65,0x66,0x69,0x80,0x05,0x02,	// 00005370
	0x7d,0x08,0x65,0x61,0x63,0x68,0x0d,0x0a,0x6d,0x65,0x80,0x08,0x0f,0x84,0x80,0x0b,	// 00005380
	0x04,0x4d,0x07,0x61,0x74,0x20,0x6c,0x61,0x72,0x67,0x80,0x07,0x05,0xa7,0x80,0x06,	// 00005390
	0x05,0x73,0x05,0x64,0x65,0x74,0x72,0x69,0x80,0x08,0x02,0x7a,0x80,0x0b,0x0e,0x01,	// 000053A0
	0x05,0x68,0x65,0x69,0x72,0x73,0x80,0x07,0x04,0x25,0x80,0x08,0x0c,0x54,0x08,0x73,	// 000053B0
	0x2c,0x20,0x66,0x75,0x6c,0x6c,0x79,0x80,0x07,0x08,0x27,0x80,0x06,0x0b,0x05,0x07,	// 000053C0
	0x61,0x74,0x20,0x73,0x75,0x63,0x68,0x80,0x08,0x10,0x2a,0x05,0x73,0x68,0x61,0x6c,	// 000053D0
	0x6c,0x80,0x05,0x0d,0x5f,0x05,0x62,0x65,0x20,0x73,0x75,0x80,0x08,0x0a,0xbe,0x07,	// 000053E0
	0x0d,0x0a,0x72,0x65,0x76,0x6f,0x63,0x80,0x07,0x06,0xd5,0x07,0x72,0x65,0x73,0x63,	// 000053F0
	0x69,0x73,0x73,0x80,0x05,0x06,0xd7,0x07,0x63,0x61,0x6e,0x63,0x65,0x6c,0x6c,0x80,	// 00005400
	0x08,0x06,0xd5,0x05,0x65,0x72,0x6d,0x69,0x6e,0x80,0x07,0x06,0xd5,0x80,0x07,0x05,	// 00005410
	0x12,0x80,0x06,0x06,0x72,0x80,0x06,0x08,0x31,0x09,0x6f,0x72,0x0d,0x0a,0x65,0x71,	// 00005420
	0x75,0x69,0x74,0x80,0x05,0x08,0x8b,0x80,0x06,0x0b,0x11,0x0a,0x20,0x74,0x6f,0x20,	// 00005430
	0x64,0x69,0x73,0x72,0x75,0x70,0x80,0x06,0x02,0xb5,0x0b,0x71,0x75,0x69,0x65,0x74,	// 00005440
	0x20,0x65,0x6e,0x6a,0x6f,0x79,0x80,0x08,0x02,0x7a,0x80,0x09,0x07,0x91,0x80,0x07,	// 00005450
	0x09,0xd6,0x80,0x06,0x04,0x51,0x0c,0x0d,0x0a,0x61,0x73,0x20,0x63,0x6f,0x6e,0x74,	// 00005460
	0x65,0x6d,0x70,0x80,0x06,0x02,0xf1,0x05,0x62,0x79,0x20,0x41,0x66,0x80,0x09,0x0e,	// 00005470
	0x03,0x08,0x65,0x78,0x70,0x72,0x65,0x73,0x73,0x20,0x80,0x14,0x02,0x75,0x80,0x05,	// 00005480
	0x02,0x70,0x05,0x33,0x2e,0x20,0x50,0x75,0x80,0x05,0x04,0x53,0x17,0x4c,0x69,0x63,	// 00005490
	0x65,0x6e,0x73,0x65,0x20,0x46,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2e,0x20,0x53,	// 000054A0
	0x68,0x6f,0x75,0x6c,0x80,0x06,0x0c,0xfb,0x80,0x05,0x06,0x32,0x80,0x08,0x11,0x57,	// 000054B0
	0x80,0x0a,0x10,0x2c,0x07,0x61,0x6e,0x79,0x20,0x72,0x65,0x61,0x80,0x05,0x06,0xe3,	// 000054C0
	0x07,0x62,0x65,0x20,0x6a,0x75,0x64,0x67,0x80,0x08,0x08,0x2e,0x80,0x05,0x10,0xa6,	// 000054D0
	0x0b,0x76,0x61,0x6c,0x69,0x64,0x20,0x6f,0x72,0x20,0x69,0x6e,0x80,0x06,0x08,0x37,	// 000054E0
	0x05,0x69,0x76,0x65,0x20,0x75,0x80,0x06,0x0c,0x0a,0x80,0x0f,0x0d,0x7b,0x05,0x74,	// 000054F0
	0x68,0x65,0x6e,0x20,0x80,0x06,0x08,0x0a,0x80,0x0c,0x10,0xbe,0x0a,0x62,0x65,0x20,	// 00005500
	0x70,0x72,0x65,0x73,0x65,0x72,0x76,0x80,0x05,0x09,0x36,0x80,0x0d,0x0e,0xef,0x80,	// 00005510
	0x11,0x0d,0x47,0x14,0x74,0x61,0x6b,0x69,0x6e,0x67,0x20,0x69,0x6e,0x74,0x6f,0x0d,	// 00005520
	0x0a,0x61,0x63,0x63,0x6f,0x75,0x6e,0x74,0x80,0x29,0x11,0x84,0x05,0x20,0x49,0x6e,	// 00005530
	0x20,0x61,0x80,0x07,0x06,0xb3,0x80,0x08,0x07,0x14,0x05,0x0d,0x0a,0x65,0x78,0x74,	// 00005540
	0x80,0x06,0x07,0x20,0x80,0x09,0x10,0x29,0x05,0x69,0x73,0x20,0x73,0x6f,0x80,0x08,	// 00005550
	0x11,0xfd,0x80,0x10,0x0d,0x8a,0x05,0x67,0x72,0x61,0x6e,0x74,0x80,0x05,0x03,0xd6,	// 00005560
	0x80,0x06,0x03,0x39,0x80,0x05,0x08,0x38,0x05,0x65,0x64,0x0d,0x0a,0x70,0x80,0x05,	// 00005570
	0x06,0xe1,0x14,0x20,0x61,0x20,0x72,0x6f,0x79,0x61,0x6c,0x74,0x79,0x2d,0x66,0x72,	// 00005580
	0x65,0x65,0x2c,0x20,0x6e,0x6f,0x6e,0x80,0x06,0x09,0xa7,0x06,0x66,0x65,0x72,0x61,	// 00005590
	0x62,0x6c,0x80,0x07,0x13,0x2d,0x09,0x73,0x75,0x62,0x6c,0x69,0x63,0x65,0x6e,0x73,	// 000055A0
	0x80,0x0a,0x13,0x3c,0x80,0x09,0x02,0xd7,0x80,0x0d,0x0d,0xb5,0x80,0x06,0x04,0xcc,	// 000055B0
	0x80,0x0d,0x0d,0xc8,0x07,0x20,0x6c,0x69,0x63,0x65,0x6e,0x73,0x80,0x05,0x05,0x70,	// 000055C0
	0x08,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x80,0x0c,0x10,0x80,0x80,0x1d,0x08,	// 000055D0
	0xdd,0x80,0x23,0x0e,0xb7,0x80,0x06,0x02,0xba,0x80,0x12,0x0e,0xe1,0x05,0x0d,0x0a,	// 000055E0
	0x6d,0x61,0x78,0x80,0x2b,0x0e,0xf7,0x80,0x07,0x0c,0xf0,0x80,0x12,0x0f,0x2a,0x05,	// 000055F0
	0x0d,0x0a,0x74,0x69,0x6d,0x80,0x2d,0x0f,0x40,0x05,0x20,0x6d,0x65,0x64,0x69,0x80,	// 00005600
	0x15,0x0f,0x73,0x80,0x05,0x04,0x75,0x80,0x2c,0x0f,0x8c,0x80,0x12,0x05,0x22,0x80,	// 00005610
	0x07,0x09,0x2f,0x80,0x2c,0x0f,0xd1,0x80,0x0a,0x06,0x77,0x07,0x28,0x74,0x68,0x65,	// 00005620
	0x0d,0x0a,0x22,0x80,0x07,0x11,0xbb,0x07,0x22,0x29,0x2e,0x20,0x54,0x68,0x65,0x80,	// 00005630
	0x09,0x11,0xba,0x80,0x09,0x12,0x4b,0x05,0x64,0x65,0x65,0x6d,0x65,0x80,0x05,0x06,	// 00005640
	0x49,0x80,0x07,0x0b,0x85,0x05,0x61,0x73,0x20,0x6f,0x66,0x80,0x06,0x10,0x6f,0x0d,	// 00005650
	0x61,0x74,0x65,0x20,0x43,0x43,0x30,0x20,0x77,0x61,0x73,0x0d,0x0a,0x80,0x05,0x0c,	// 00005660
	0xdf,0x80,0x0e,0x11,0x7f,0x80,0x0c,0x07,0x8d,0x80,0x19,0x11,0xcb,0x80,0x08,0x11,	// 00005670
	0xbb,0x80,0x07,0x05,0x11,0x09,0x0d,0x0a,0x72,0x65,0x61,0x73,0x6f,0x6e,0x20,0x80,	// 00005680
	0x3f,0x11,0xfb,0x80,0x06,0x0c,0x68,0x07,0x70,0x61,0x72,0x74,0x69,0x61,0x6c,0x80,	// 00005690
	0x08,0x12,0x0c,0x05,0x69,0x74,0x79,0x20,0x6f,0x80,0x0d,0x12,0x16,0x80,0x05,0x0a,	// 000056A0
	0x54,0x80,0x0a,0x10,0xc4,0x80,0x07,0x12,0x0d,0x0f,0x61,0x74,0x65,0x20,0x74,0x68,	// 000056B0
	0x65,0x20,0x72,0x65,0x6d,0x61,0x69,0x6e,0x64,0x80,0x07,0x14,0x8d,0x80,0x0b,0x15,	// 000056C0
	0x93,0x80,0x06,0x06,0x90,0x0a,0x69,0x6e,0x20,0x73,0x75,0x63,0x68,0x20,0x63,0x61,	// 000056D0
	0x80,0x0b,0x13,0x94,0x80,0x08,0x0d,0x92,0x07,0x61,0x66,0x66,0x69,0x72,0x6d,0x73,	// 000056E0
	0x80,0x11,0x07,0x23,0x08,0x77,0x69,0x6c,0x6c,0x20,0x6e,0x6f,0x74,0x80,0x05,0x0e,	// 000056F0
	0xc3,0x80,0x09,0x13,0x8e,0x80,0x05,0x11,0x13,0x80,0x0d,0x07,0xdd,0x80,0x06,0x16,	// 00005700
	0x33,0x80,0x05,0x06,0xf0,0x80,0x14,0x02,0xe2,0x05,0x0d,0x0a,0x52,0x69,0x67,0x80,	// 00005710
	0x10,0x13,0xbc,0x0d,0x6f,0x72,0x20,0x28,0x69,0x69,0x29,0x20,0x61,0x73,0x73,0x65,	// 00005720
	0x72,0x80,0x05,0x06,0x9c,0x80,0x1d,0x0e,0x2c,0x80,0x06,0x03,0x66,0x80,0x06,0x05,	// 00005730
	0xbe,0x80,0x05,0x06,0xf8,0x05,0x72,0x65,0x73,0x70,0x65,0x80,0x0a,0x0a,0xc1,0x80,	// 00005740
	0x06,0x07,0x67,0x05,0x69,0x6e,0x20,0x65,0x69,0x80,0x05,0x05,0xb4,0x80,0x05,0x16,	// 00005750
	0x5a,0x80,0x06,0x0d,0x67,0x05,0x72,0x79,0x20,0x74,0x6f,0x80,0x0b,0x10,0x80,0x80,	// 00005760
	0x05,0x06,0xa1,0x80,0x1e,0x11,0x93,0x05,0x34,0x2e,0x20,0x4c,0x69,0x80,0x0a,0x0a,	// 00005770
	0xcd,0x07,0x61,0x6e,0x64,0x20,0x44,0x69,0x73,0x80,0x05,0x04,0x80,0x80,0x08,0x06,	// 00005780
	0x59,0x0e,0x20,0x61,0x2e,0x20,0x4e,0x6f,0x20,0x74,0x72,0x61,0x64,0x65,0x6d,0x61,	// 00005790
	0x80,0x06,0x16,0xe0,0x06,0x70,0x61,0x74,0x65,0x6e,0x74,0x80,0x08,0x03,0xd0,0x05,	// 000057A0
	0x68,0x65,0x6c,0x64,0x20,0x80,0x0c,0x15,0x67,0x0a,0x61,0x72,0x65,0x20,0x77,0x61,	// 000057B0
	0x69,0x76,0x65,0x64,0x80,0x09,0x0d,0xde,0x05,0x65,0x64,0x2c,0x0d,0x0a,0x80,0x06,	// 000057C0
	0x0a,0xb8,0x80,0x07,0x0d,0xf0,0x05,0x65,0x64,0x2c,0x20,0x6c,0x80,0x06,0x11,0xbc,	// 000057D0
	0x80,0x05,0x08,0xc3,0x80,0x05,0x04,0xba,0x05,0x77,0x69,0x73,0x65,0x20,0x80,0x08,	// 000057E0
	0x13,0x0f,0x80,0x06,0x09,0xd5,0x10,0x69,0x73,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,	// 000057F0
	0x6e,0x74,0x2e,0x0d,0x0a,0x20,0x62,0x80,0x0b,0x10,0x16,0x05,0x6f,0x66,0x66,0x65,	// 00005800
	0x72,0x80,0x07,0x10,0x25,0x80,0x05,0x07,0x96,0x05,0x73,0x2d,0x69,0x73,0x20,0x80,	// 00005810
	0x05,0x06,0x81,0x80,0x05,0x10,0x22,0x05,0x6e,0x6f,0x20,0x72,0x65,0x80,0x05,0x12,	// 00005820
	0x54,0x80,0x09,0x0d,0x17,0x80,0x08,0x0a,0x47,0x08,0x77,0x61,0x72,0x72,0x61,0x6e,	// 00005830
	0x74,0x69,0x80,0x07,0x0e,0xa9,0x0e,0x6e,0x79,0x20,0x6b,0x69,0x6e,0x64,0x20,0x63,	// 00005840
	0x6f,0x6e,0x63,0x65,0x72,0x80,0x06,0x0a,0x2e,0x80,0x09,0x07,0x64,0x80,0x07,0x11,	// 00005850
	0x90,0x07,0x2c,0x20,0x69,0x6d,0x70,0x6c,0x69,0x80,0x0a,0x17,0xe9,0x07,0x74,0x61,	// 00005860
	0x74,0x75,0x74,0x6f,0x72,0x80,0x05,0x16,0x05,0x80,0x09,0x18,0x0b,0x80,0x1f,0x05,	// 00005870
	0x21,0x80,0x0d,0x18,0x79,0x80,0x06,0x00,0x72,0x1b,0x74,0x69,0x74,0x6c,0x65,0x2c,	// 00005880
	0x20,0x6d,0x65,0x72,0x63,0x68,0x61,0x6e,0x74,0x61,0x62,0x69,0x6c,0x69,0x74,0x79,	// 00005890
	0x2c,0x20,0x66,0x69,0x74,0x80,0x05,0x0a,0x54,0x80,0x05,0x05,0x11,0x80,0x05,0x11,	// 000058A0
	0xd7,0x05,0x69,0x63,0x75,0x6c,0x61,0x80,0x09,0x06,0x76,0x80,0x05,0x13,0x2e,0x80,	// 000058B0
	0x06,0x00,0x72,0x80,0x0c,0x04,0x8a,0x80,0x06,0x05,0xef,0x09,0x68,0x65,0x20,0x61,	// 000058C0
	0x62,0x73,0x65,0x6e,0x63,0x80,0x05,0x03,0xf1,0x05,0x6c,0x61,0x74,0x65,0x6e,0x80,	// 000058D0
	0x05,0x0c,0xa1,0x80,0x06,0x06,0x72,0x12,0x64,0x65,0x66,0x65,0x63,0x74,0x73,0x2c,	// 000058E0
	0x20,0x61,0x63,0x63,0x75,0x72,0x61,0x63,0x79,0x2c,0x80,0x09,0x0a,0x46,0x80,0x05,	// 000058F0
	0x03,0xe7,0x80,0x06,0x18,0x64,0x80,0x05,0x11,0x0f,0x80,0x0a,0x19,0x5d,0x06,0x65,	// 00005900
	0x72,0x72,0x6f,0x72,0x73,0x80,0x0a,0x0e,0x54,0x0d,0x6f,0x72,0x20,0x6e,0x6f,0x74,	// 00005910
	0x20,0x64,0x69,0x73,0x63,0x6f,0x76,0x80,0x08,0x13,0x3a,0x80,0x05,0x0e,0xcb,0x05,	// 00005920
	0x6f,0x0d,0x0a,0x20,0x20,0x80,0x06,0x19,0x90,0x80,0x15,0x0d,0x3e,0x80,0x07,0x04,	// 00005930
	0xee,0x80,0x14,0x12,0x24,0x05,0x2e,0x0d,0x0a,0x20,0x63,0x80,0x0b,0x10,0x16,0x05,	// 00005940
	0x64,0x69,0x73,0x63,0x6c,0x80,0x05,0x04,0x82,0x80,0x06,0x0c,0xa9,0x07,0x73,0x69,	// 00005950
	0x62,0x69,0x6c,0x69,0x74,0x80,0x05,0x04,0xfa,0x05,0x20,0x63,0x6c,0x65,0x61,0x80,	// 00005960
	0x0c,0x08,0xcf,0x80,0x08,0x06,0x53,0x80,0x07,0x06,0xdf,0x06,0x73,0x0d,0x0a,0x20,	// 00005970
	0x20,0x20,0x80,0x06,0x04,0x47,0x05,0x6d,0x61,0x79,0x20,0x61,0x80,0x05,0x07,0x85,	// 00005980
	0x80,0x0c,0x07,0x8e,0x80,0x07,0x05,0x12,0x05,0x75,0x73,0x65,0x20,0x74,0x80,0x12,	// 00005990
	0x0c,0x32,0x80,0x09,0x14,0xcb,0x80,0x06,0x0a,0x4c,0x80,0x09,0x05,0x37,0x80,0x05,	// 000059A0
	0x05,0x15,0x80,0x08,0x0a,0x39,0x80,0x28,0x07,0x43,0x08,0x2e,0x0d,0x0a,0x20,0x20,	// 000059B0
	0x20,0x20,0x46,0x80,0x06,0x05,0xb2,0x80,0x0b,0x0d,0x88,0x80,0x1d,0x1a,0x21,0x05,	// 000059C0
	0x6f,0x62,0x74,0x61,0x69,0x80,0x07,0x08,0x1f,0x0b,0x79,0x20,0x6e,0x65,0x63,0x65,	// 000059D0
	0x73,0x73,0x61,0x72,0x79,0x80,0x06,0x00,0x72,0x08,0x63,0x6f,0x6e,0x73,0x65,0x6e,	// 000059E0
	0x74,0x73,0x80,0x06,0x0d,0xa8,0x80,0x06,0x10,0xed,0x80,0x05,0x07,0xe1,0x80,0x06,	// 000059F0
	0x06,0x72,0x80,0x09,0x09,0xc6,0x05,0x71,0x75,0x69,0x72,0x65,0x80,0x0a,0x05,0x0f,	// 00005A00
	0x80,0x07,0x0b,0x32,0x80,0x09,0x0b,0x97,0x80,0x08,0x1a,0xe6,0x05,0x64,0x2e,0x20,	// 00005A10
	0x41,0x66,0x80,0x07,0x0d,0x8c,0x80,0x05,0x07,0xbb,0x05,0x73,0x74,0x61,0x6e,0x64,	// 00005A20
	0x80,0x07,0x0e,0x27,0x05,0x63,0x6b,0x6e,0x6f,0x77,0x80,0x05,0x07,0xd6,0x80,0x07,	// 00005A30
	0x16,0x75,0x80,0x11,0x00,0x40,0x07,0x69,0x73,0x20,0x6e,0x6f,0x74,0x20,0x80,0x07,	// 00005A40
	0x0b,0x3c,0x05,0x70,0x61,0x72,0x74,0x79,0x80,0x06,0x05,0x71,0x80,0x0b,0x18,0x23,	// 00005A50
	0x80,0x05,0x02,0xea,0x09,0x68,0x61,0x73,0x20,0x6e,0x6f,0x20,0x64,0x75,0x80,0x06,	// 00005A60
	0x16,0x04,0x05,0x6f,0x62,0x6c,0x69,0x67,0x80,0x07,0x18,0xeb,0x80,0x0e,0x17,0x1f,	// 00005A70
	0x80,0x08,0x19,0x8c,0x06,0x69,0x73,0x20,0x43,0x43,0x30,0x80,0x05,0x0e,0x67,0x80,	// 00005A80
	0x09,0x1b,0x75,0x80,0x08,0x1a,0xe5
};
