/* $Id: gbk.c,v 1.1 2008/01/22 10:55:48 onoe Exp $ */

/*-
 * Copyright (c) 2008 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "gbk.h"

static const unsigned short gbk_euc[] = {
	/* 0x8140 */
0x30a1, 0x30a2, 0x30a3, 0x0000, 0x0000, 0x30a5, 0xd2c2, 0x30a6,
0x0000, 0xcebe, 0x30a7, 0xcac2, 0x0000, 0x30ab, 0x30ac, 0xd0a5,
0x0000, 0x30ae, 0x0000, 0xd0a7, 0x30af, 0x30b0, 0xd0a9, 0x30b1,
0x0000, 0x0000, 0x30b3, 0xe9c9, 0xbee8, 0x30b4, 0x0000, 0xd6a6,
0x30b6, 0x0000, 0x0000, 0x0000, 0x30b7, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x30b9, 0x30ba, 0x0000, 0x0000,
0x0000, 0x30bb, 0x0000, 0x0000, 0x0000, 0x0000, 0x30bc, 0xb5b5,
0x0000, 0xd0ac, 0x0000, 0x0000, 0xd0ad, 0x0000, 0xd0af, 0x0000,
0x0000, 0x30be, 0x30bf, 0xcfca, 0xb0a1, 0x30c0, 0xd0b3, 0x0000,
0x0000, 0x30c1, 0xd0b7, 0x0000, 0x0000, 0xd0b9, 0x0000, 0x0000,
0x30c2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xcaa9, 0x30c4,
0x0000, 0x30c5, 0x30c6, 0x0000, 0x30c7, 0x30c9, 0x0000, 0x0000,
0x0000, 0xd0c1, 0xb2be, 0x30cb, 0x30cc, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x30d0, 0x30d2, 0x30d3, 0x30d4, 0x0000, 0x0000,
0x0000, 0x0000, 0x30d5, 0x30d6, 0x30d7, 0x30d8, 0x0000, 0x0000,
0x30d9, 0x30da, 0xd0e7, 0xc5c1, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x30dd, 0x30de, 0x30e0, 0x30e1, 0x30e2, 0x30e3,
0x30e4, 0x30e5, 0x0000, 0x30e6, 0x0000, 0x30e7, 0x0000, 0x0000,
0xd0ca, 0x30e8, 0x30e9, 0x0000, 0x30ea, 0x30eb, 0x30ec, 0x30ed,
0x30ee, 0x0000, 0x0000, 0x0000, 0x0000, 0x30f2, 0x0000, 0x0000,
0x30f4, 0x30f5, 0x0000, 0xcabb, 0x30f6, 0x30f7, 0x30f8, 0x30f9,
0x30fa, 0x0000, 0x30fc, 0x30fd, 0x31a1, 0xd0d4, 0x0000, 0x31a3,
0x31a4, 0x31a5, 0x31a6, 0x31a7, 0x31a8, 0x0000, 0xd0d5, 0xd0ce,
0x31ab, 0x31ac, 0x0000, 0x31ad, 0x31ae, 0xb2c1, 0x0000,
	/* 0x8240 */
0x0000, 0xd5a5, 0xcbf9, 0x0000, 0x0000, 0x31af, 0x0000, 0x0000,
0xceb7, 0x31b0, 0x0000, 0x31b1, 0x0000, 0x31b2, 0x31b3, 0x31b4,
0x31b5, 0x31b6, 0x31b7, 0xb7b8, 0x31b9, 0x0000, 0x31ba, 0x31bb,
0x31bc, 0x31bd, 0x31be, 0x31c0, 0x0000, 0xd0d7, 0x0000, 0x0000,
0x0000, 0xd0db, 0x31c2, 0x31c3, 0xd0df, 0xd0e0, 0x0000, 0x0000,
0x0000, 0x31c4, 0x31c5, 0x0000, 0xc9b6, 0xd0e8, 0x0000, 0x0000,
0x0000, 0x31c6, 0x31c7, 0x31c8, 0x31c9, 0x31ca, 0x0000, 0x0000,
0x31cb, 0xd0e6, 0xd0ef, 0x31cc, 0x0000, 0xc1d2, 0x31cd, 0x0000,
0xb8c4, 0x31cf, 0x31d0, 0xd0ee, 0x31d1, 0x0000, 0xb8f6, 0x31d2,
0x31d4, 0x31d6, 0x31d7, 0x0000, 0x31d8, 0xcaef, 0xc3cd, 0x31d9,
0xced1, 0x0000, 0x31db, 0x0000, 0x31dc, 0x31dd, 0x0000, 0x31de,
0xb6e6, 0x0000, 0x0000, 0xb7f0, 0x31f6, 0x0000, 0x0000, 0x31df,
0x31e0, 0x31e1, 0x0000, 0x31e2, 0x31e3, 0xb0ce, 0x31e4, 0x0000,
0x0000, 0xd0f4, 0x31e7, 0x31e8, 0x31e9, 0x0000, 0xd0f7, 0x31ea,
0x0000, 0x31eb, 0x0000, 0x0000, 0x0000, 0x31ec, 0x31ed, 0x0000,
0x31ee, 0x31ef, 0x0000, 0x31f0, 0x31f1, 0x0000, 0x0000, 0x31f2,
0x0000, 0x31f3, 0x0000, 0x0000, 0x31f4, 0x31f5, 0xbcc5, 0x0000,
0xc2a6, 0xc4e5, 0xd0f9, 0x0000, 0x0000, 0x0000, 0xb5b6, 0x31f7,
0x0000, 0x31f8, 0x31f9, 0x31fa, 0x0000, 0x0000, 0x31fb, 0x0000,
0x0000, 0x31fc, 0x31fd, 0x31fe, 0xb7e6, 0x32a1, 0x32a2, 0x32a3,
0x0000, 0x32a4, 0x0000, 0xbbb1, 0xc8f7, 0xd0fb, 0x32a5, 0x32a6,
0x0000, 0x32a7, 0x32a8, 0x32a9, 0x32aa, 0x32ab, 0x0000, 0x0000,
0x32ac, 0x0000, 0xcdc3, 0x0000, 0x32ad, 0x32ae, 0x0000, 0xd1a3,
0xd0fd, 0xbac4, 0x0000, 0xbdfd, 0x0000, 0x32af, 0x0000,
	/* 0x8340 */
0x32b1, 0xb7b9, 0x0000, 0x32b2, 0x0000, 0xd1a4, 0x32b3, 0x32b4,
0xb6cf, 0x0000, 0x32b5, 0x0000, 0xd1a1, 0xd1a2, 0x0000, 0x32b6,
0xc6af, 0x32b7, 0x32b8, 0xb6a3, 0x0000, 0x32b9, 0x32ba, 0xcbcd,
0x0000, 0x32bb, 0x0000, 0x0000, 0x32bc, 0x32bd, 0xd1a6, 0x32be,
0x0000, 0x0000, 0x32bf, 0xd1a9, 0x32c0, 0xd1a7, 0x32c2, 0x32c3,
0x0000, 0x0000, 0x32c4, 0x0000, 0x32c5, 0x32d1, 0x0000, 0x32c6,
0x0000, 0x0000, 0xd1ab, 0x32c7, 0x0000, 0x0000, 0x32c8, 0x0000,
0xb5b7, 0xd1ae, 0xd1af, 0x32c9, 0xb2af, 0x0000, 0x32cc, 0x0000,
0xd1ad, 0x0000, 0x32ce, 0x32cf, 0x32d0, 0x0000, 0x32d2, 0x0000,
0x0000, 0xd1b2, 0xd1b1, 0xd1b0, 0x32d3, 0xd0d6, 0x32d4, 0xd1b3,
0x32d5, 0x32d6, 0x32d7, 0x32d8, 0xbdfe, 0x0000, 0x0000, 0x32d9,
0x0000, 0x0000, 0x0000, 0x32da, 0x32db, 0x0000, 0xcda5, 0x0000,
0x32dc, 0x32dd, 0x0000, 0x32de, 0x0000, 0x32df, 0xccd9, 0x32e0,
0x32e1, 0x32e2, 0x0000, 0xd1b6, 0x32e3, 0x32e4, 0xd1b5, 0xd1b8,
0xd1b7, 0x0000, 0x0000, 0x32e5, 0xb6a4, 0x32e6, 0xd1bc, 0xc5c6,
0x32e7, 0xbbf9, 0xd1bb, 0x32e8, 0x32ea, 0x32eb, 0x0000, 0x0000,
0x0000, 0x0000, 0x32ec, 0x0000, 0x0000, 0x0000, 0x32ed, 0x32ee,
0x0000, 0xd1c0, 0xd1c1, 0x0000, 0x0000, 0x0000, 0x32ef, 0x0000,
0x32f0, 0x32f1, 0xb1df, 0x0000, 0xbafd, 0x32f2, 0x32f3, 0xd1c8,
0xe6ee, 0xd1c9, 0xd1ca, 0x0000, 0x32f4, 0x0000, 0x32f5, 0x0000,
0x0000, 0x32f6, 0x32f7, 0xd1ce, 0x0000, 0xc9da, 0xd1d0, 0xd1d1,
0x32f8, 0x0000, 0xbae3, 0x32f9, 0x0000, 0x32fa, 0x32fc, 0x32fd,
0x0000, 0x32fe, 0x0000, 0xd1d9, 0x33a1, 0x0000, 0xc5e0, 0x0000,
0x0000, 0x33a4, 0x33a5, 0x0000, 0x33a6, 0xd2c5, 0x0000,
	/* 0x8440 */
0x33a7, 0x0000, 0x0000, 0xf4a5, 0x33a8, 0x0000, 0x33a9, 0x0000,
0x33aa, 0xbde8, 0xc2fc, 0x0000, 0xd1de, 0xc6e4, 0x0000, 0x33ab,
0xb3ae, 0x33ac, 0x33ae, 0x33af, 0xd1e2, 0xd1e3, 0x33b2, 0x0000,
0xd1e4, 0x0000, 0x0000, 0x0000, 0x33b4, 0xd1e5, 0x33b5, 0x0000,
0x0000, 0x0000, 0x0000, 0x33b8, 0x0000, 0xcacc, 0x0000, 0xd1e7,
0xd1e8, 0x0000, 0x0000, 0x33ba, 0x33bb, 0x0000, 0x33bc, 0x33bd,
0x0000, 0xd1ed, 0x33be, 0x0000, 0xc2a7, 0x0000, 0x33bf, 0xd1ee,
0x0000, 0xd1ec, 0x0000, 0x0000, 0x33c0, 0x33c1, 0x33c2, 0x0000,
0x0000, 0x33c3, 0xb9e4, 0x0000, 0x33c5, 0x33c6, 0x0000, 0xb7f5,
0xbade, 0x33c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x33c9, 0xbeea,
0xd1fb, 0xd1f5, 0xd1f3, 0xc1cf, 0x0000, 0x33ca, 0x33cb, 0x33cc,
0x0000, 0x0000, 0x0000, 0x0000, 0x33cd, 0xb3c4, 0x0000, 0x33cf,
0x0000, 0xb7e0, 0xcead, 0x33d0, 0x0000, 0x33d1, 0xd1f8, 0x0000,
0x0000, 0xd1fd, 0xd1fa, 0xd1f9, 0x33d3, 0x33d4, 0x33d5, 0x33d6,
0x0000, 0x33d7, 0x33d8, 0x33d9, 0x33da, 0x33db, 0x33dc, 0x0000,
0x33dd, 0x33de, 0xcfab, 0xd2a5, 0x33df, 0x33e0, 0x33e1, 0xb8fa,
0x33e2, 0x33e3, 0xd2a4, 0x33e4, 0x33e5, 0xd2a6, 0x0000, 0x33e6,
0xc4bc, 0x33e7, 0x33e8, 0x0000, 0x33e9, 0xd2a7, 0x0000, 0x33ea,
0x33eb, 0x0000, 0x33ec, 0xc6b0, 0xd2a8, 0xccb3, 0x0000, 0x33ee,
0x33ef, 0xbea1, 0xd2a9, 0xd2ad, 0x33f0, 0xc0aa, 0xd2aa, 0x33f1,
0xd2ab, 0xb4ab, 0x33f2, 0x33f3, 0x33f4, 0x0000, 0x33f5, 0x0000,
0x0000, 0x0000, 0x33f7, 0xb7ae, 0xd2ae, 0x33f8, 0xd2af, 0x33f9,
0x33fa, 0xd2b0, 0x0000, 0x0000, 0x0000, 0xcce8, 0xc6f7, 0x33fc,
0x0000, 0x0000, 0x0000, 0x33fd, 0x33fe, 0x34a1, 0x0000,
	/* 0x8540 */
0x34a2, 0x0000, 0x34a3, 0x0000, 0x34a4, 0x34a5, 0x34a6, 0x34a7,
0x34a8, 0x0000, 0x0000, 0x34a9, 0x34aa, 0x34ab, 0x34ac, 0x34ad,
0x34ae, 0x34af, 0xd2bb, 0x34b0, 0xd2bc, 0x34b1, 0xd2bd, 0x0000,
0x34b2, 0x0000, 0x0000, 0xd2be, 0x34b3, 0x34b4, 0xd2bf, 0x34b6,
0x0000, 0xd2c0, 0x34b8, 0x34b7, 0xd2c4, 0x0000, 0xb6a8, 0xc3b1,
0x34b9, 0x34ba, 0x0000, 0x34bd, 0x0000, 0x0000, 0x34be, 0x34bf,
0x34c0, 0x0000, 0x34c1, 0xd2ca, 0x0000, 0x0000, 0x34c2, 0x0000,
0x0000, 0x34c3, 0x34c4, 0x34c5, 0x0000, 0x34c6, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x34c7, 0x34c8, 0xd2cd, 0x0000, 0x34c9,
0x0000, 0x0000, 0x0000, 0xd2ce, 0x34cb, 0x34cc, 0x0000, 0x34cd,
0x34ce, 0x0000, 0xb1de, 0x34cf, 0xd2d2, 0x0000, 0x34d0, 0xb8b7,
0x34d1, 0x34d2, 0x34d3, 0x34d4, 0x0000, 0x34d5, 0x0000, 0x34d6,
0x0000, 0x34d7, 0xd2d4, 0x0000, 0x34d8, 0x0000, 0x0000, 0xbcfd,
0x34d9, 0x0000, 0x34da, 0x34db, 0x34dc, 0x34dd, 0x0000, 0x34de,
0x34df, 0xb1c3, 0xc1d1, 0x34e2, 0x0000, 0xd2dd, 0x0000, 0x0000,
0x0000, 0x34e4, 0x0000, 0x0000, 0xb1a5, 0x0000, 0x0000, 0x0000,
0x34e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x34ea, 0x0000, 0x0000,
0xd2e5, 0x0000, 0x0000, 0xd2df, 0x0000, 0x0000, 0xcfa4, 0x34f0,
0x0000, 0x34f1, 0xb8e2, 0x0000, 0x34f2, 0xd2e8, 0x34f3, 0xc6dd,
0x0000, 0x0000, 0x34f4, 0xd2ec, 0x0000, 0x0000, 0x0000, 0x0000,
0x34f8, 0x34f9, 0xbcf6, 0x34fa, 0x0000, 0x34fb, 0x34fc, 0x0000,
0xd2ef, 0x34fd, 0x0000, 0x0000, 0x0000, 0x34fe, 0x35a1, 0x35a2,
0x35a3, 0x0000, 0x35a4, 0x35a5, 0x0000, 0x35a6, 0x35a7, 0x0000,
0x0000, 0x0000, 0x35aa, 0x0000, 0x35ab, 0x0000, 0x35ac,
	/* 0x8640 */
0xd2f8, 0xd2fa, 0x35b2, 0x0000, 0xbae9, 0x0000, 0x0000, 0x35b4,
0x35b5, 0x35b6, 0xd3a5, 0xd3a4, 0x0000, 0x0000, 0x35ba, 0x0000,
0x0000, 0xd3a6, 0x0000, 0x35bd, 0xb0f7, 0xd3af, 0x0000, 0x0000,
0x0000, 0x35bf, 0x35c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x35c1,
0x0000, 0x0000, 0x0000, 0x0000, 0x35c3, 0x35c5, 0x0000, 0x0000,
0xb1b4, 0x35c7, 0x35c8, 0x0000, 0x0000, 0x35ca, 0x35cb, 0x35cc,
0x0000, 0x0000, 0x35cd, 0xb0a2, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x35cf, 0x0000, 0x35d0, 0x0000, 0x35d1, 0x35d2,
0xd3b9, 0xd3b0, 0x0000, 0x35d3, 0x35d5, 0xd3b1, 0x0000, 0xd3b6,
0x35d7, 0x0000, 0x0000, 0xd3b3, 0x35da, 0x0000, 0xcce4, 0x35dc,
0x0000, 0xb7bc, 0x0000, 0xd3b8, 0x35dd, 0x0000, 0x35de, 0x35df,
0xd3bb, 0x35e0, 0x0000, 0x35e1, 0x0000, 0xd3b2, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x35e5, 0x0000, 0x35e8, 0x0000, 0x0000, 0x35ea,
0x0000, 0x35ed, 0x35ee, 0x0000, 0x0000, 0x35f0, 0xb4ad, 0x0000,
0xd3c4, 0x0000, 0x0000, 0x0000, 0x35f1, 0x35f2, 0x0000, 0x0000,
0xd3ca, 0xd3c8, 0xc1d3, 0xb5ca, 0xb6ac, 0x35f3, 0xd3c5, 0x0000,
0xb6f4, 0x35f4, 0x0000, 0xb1c4, 0x0000, 0x0000, 0x0000, 0x35f5,
0x0000, 0x35f6, 0x0000, 0x35f7, 0x35f8, 0xd4a7, 0x0000, 0x0000,
0x35fa, 0x35fc, 0x0000, 0x0000, 0x0000, 0x36a2, 0x36a3, 0x0000,
0xd3cb, 0x36a4, 0x36a5, 0x0000, 0x36a6, 0x0000, 0x36a7, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x36a8, 0x0000, 0xd3d8, 0x0000,
0x0000, 0x0000, 0x36a9, 0x0000, 0x0000, 0x0000, 0x36aa,
	/* 0x8740 */
0xc3b2, 0x0000, 0x36ac, 0x0000, 0x36ad, 0x36b0, 0x36b1, 0x36b2,
0x0000, 0xd3d2, 0x0000, 0xd3d4, 0xbea8, 0x36b3, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb2de,
0x0000, 0x0000, 0x0000, 0xd3e2, 0x36b5, 0x36b6, 0x36b7, 0x36b8,
0xd3df, 0x0000, 0x36bb, 0x36bc, 0x0000, 0x36be, 0x36bf, 0xb1bd,
0x36c0, 0x36c1, 0x0000, 0x36c2, 0x0000, 0x0000, 0x36c3, 0x0000,
0x36c4, 0x36c6, 0xd3da, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xb3fa, 0x0000, 0x36c8, 0x0000, 0x36c9, 0x36ca, 0x0000,
0x36cc, 0x0000, 0x36cd, 0x0000, 0x36cf, 0x0000, 0x36d0, 0x0000,
0x36d2, 0x0000, 0xcaae, 0x36d3, 0x0000, 0xc6d5, 0x0000, 0xc8b8,
0x0000, 0x0000, 0x0000, 0xd3e6, 0x0000, 0x0000, 0x0000, 0x36d4,
0xb3c5, 0x36d6, 0x0000, 0xd3e7, 0x36d7, 0x36d8, 0x0000, 0x0000,
0x0000, 0x0000, 0xd3e9, 0x36d9, 0x0000, 0x0000, 0x0000, 0x36da,
0x36db, 0x0000, 0x0000, 0x36dc, 0x36dd, 0x36de, 0xd3e8, 0x0000,
0xc7b9, 0x0000, 0xd3eb, 0x36df, 0x36e0, 0x36e1, 0x36e2, 0x0000,
0x36e3, 0x36e4, 0x36e5, 0xd3ec, 0x0000, 0x36e6, 0x0000, 0x36e7,
0xd3ee, 0x0000, 0xd3ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x36e9, 0x0000, 0xd3f3, 0xd3f1, 0xd3ef, 0xd3f2, 0x0000, 0x36ea,
0x0000, 0x0000, 0xd3f4, 0x36eb, 0x36ed, 0x36f0, 0x36f1, 0xd3f5,
0x36ee, 0x36ef, 0xd3f6, 0x0000, 0xd3f7, 0x0000, 0x0000, 0xd1c5,
0x36f2, 0x36f3, 0xc3c4, 0x36f8, 0x36f9, 0x36fa, 0x36fb, 0x0000,
0x0000, 0x0000, 0xd3f9, 0x0000, 0xb0cf, 0xbfde, 0x37a1, 0x37a2,
0x0000, 0x0000, 0x0000, 0xd3fb, 0x37a3, 0x37a4, 0x0000, 0x37a5,
0xd4a2, 0x37a7, 0xd4a3, 0x0000, 0xb7f7, 0x0000, 0x37a8,
	/* 0x8840 */
0xb1e0, 0xd4a4, 0x0000, 0x37a9, 0xd4a6, 0x0000, 0xd4a5, 0x0000,
0x37aa, 0x37ab, 0x37ac, 0x0000, 0x37ad, 0x0000, 0x37ae, 0x37b0,
0x37b1, 0xd4a9, 0xb0b5, 0x0000, 0x0000, 0x0000, 0x37b8, 0x0000,
0x0000, 0xd4aa, 0xd4ab, 0x0000, 0x37b9, 0x37bb, 0x0000, 0x0000,
0x0000, 0x37bc, 0x37bd, 0x0000, 0x0000, 0x0000, 0x37c0, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x37c1, 0x0000, 0x37c2,
0x37c3, 0x0000, 0x37c7, 0x37c9, 0x37ca, 0x0000, 0x37cc, 0x37cd,
0x0000, 0x37cf, 0x37d0, 0x0000, 0x37d3, 0xd4b4, 0x0000, 0x0000,
0x37d4, 0x0000, 0xd4b2, 0xd4b5, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x37d7, 0x37e0, 0x0000, 0x37d8, 0x0000, 0x37d9,
0x37da, 0x37db, 0x37dc, 0x37dd, 0x37de, 0x0000, 0x37e2, 0xd4ba,
0x37e4, 0x0000, 0xd4bb, 0x0000, 0xd4b8, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x37e6, 0x0000, 0x0000, 0xd4b1,
0x0000, 0x0000, 0x0000, 0xd4bd, 0x37e7, 0x37e8, 0x0000, 0x0000,
0x37e9, 0x0000, 0x0000, 0x0000, 0xd4c0, 0xd4c2, 0x0000, 0x0000,
0xc7b8, 0x37ed, 0x37fe, 0x0000, 0xd4c3, 0x0000, 0x37ef, 0x37f0,
0x0000, 0x37f1, 0x0000, 0x0000, 0x0000, 0x0000, 0x37f3, 0x0000,
0x0000, 0x0000, 0x37f4, 0x37f5, 0xbcb9, 0x0000, 0xbaeb, 0x37f8,
0x37f9, 0x0000, 0x37fa, 0x37fb, 0xb7f8, 0x37fc, 0x37fd, 0xd4c1,
0x38a1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x38a3, 0x0000, 0xd4c6, 0x38a5, 0x0000,
0x0000, 0x0000, 0x38a7, 0x38a8, 0x0000, 0x0000, 0x0000, 0x0000,
0x38a9, 0x0000, 0xf4a1, 0xcaf3, 0x38aa, 0x0000, 0xbeec, 0x0000,
0x0000, 0x0000, 0x38ab, 0xbae6, 0x0000, 0x0000, 0xd4ce,
	/* 0x8940 */
0x0000, 0x38ac, 0xcabd, 0xcedd, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x38ad, 0xb2f4, 0xd4ca, 0x0000, 0x38b0, 0x38b1,
0xd4cd, 0x0000, 0x38b2, 0x0000, 0xc5c9, 0xc8b9, 0xc4cd, 0x0000,
0x0000, 0x0000, 0x38b3, 0x0000, 0x38b4, 0xd4c9, 0x0000, 0x38b5,
0x0000, 0x38b6, 0x38b7, 0xb1f6, 0x0000, 0x0000, 0x0000, 0x0000,
0xd4cb, 0x0000, 0xd4c7, 0x0000, 0x0000, 0xbfd0, 0x0000, 0x0000,
0x38b8, 0xd4cf, 0x0000, 0x0000, 0x38b9, 0x0000, 0x38ba, 0x0000,
0x0000, 0x0000, 0x38bd, 0x38be, 0x38c0, 0x0000, 0x38c1, 0x0000,
0x38c2, 0x0000, 0x38c3, 0x38c4, 0x0000, 0x38c5, 0x0000, 0x38c6,
0xc1fd, 0x0000, 0x0000, 0xc4c6, 0x38c7, 0x38c8, 0x38c9, 0x38ca,
0x0000, 0x0000, 0x0000, 0x38cb, 0x0000, 0x0000, 0xd4d3, 0x0000,
0x0000, 0xd4d8, 0x0000, 0x0000, 0x38cd, 0x38ce, 0xcaaf, 0x0000,
0x0000, 0x0000, 0x0000, 0xd4d7, 0xd4d1, 0xd4d4, 0xd4d6, 0x0000,
0xbaa6, 0x0000, 0x0000, 0x38d1, 0x0000, 0x38cf, 0x0000, 0xc3c5,
0x38d2, 0x0000, 0xb2f5, 0x0000, 0xbeed, 0x38d3, 0x38d4, 0x0000,
0x38d5, 0x38d6, 0xd4da, 0x38d7, 0x38d8, 0xd4dc, 0xd4de, 0xd4dd,
0x38d9, 0x0000, 0xd4e0, 0x38da, 0xd4d5, 0xd4e2, 0x0000, 0x38db,
0x38dc, 0x0000, 0xd4df, 0x0000, 0x0000, 0x0000, 0x38dd, 0x0000,
0x0000, 0xd4e3, 0xb0ed, 0xc7e4, 0x0000, 0x0000, 0xc4db, 0x0000,
0xd4e4, 0xd4e6, 0xd4e7, 0xd4e8, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x38df, 0x38e0, 0x0000, 0xcad1, 0xd4ea, 0x38e1, 0x38e2,
0x0000, 0xd4eb, 0x0000, 0x38e3, 0x38e4, 0x0000, 0xd2c9, 0xd4ec,
0x38e7, 0x0000, 0x0000, 0x38e8, 0xccb4, 0x38e9, 0x0000, 0x38eb,
0xd4ef, 0x38ed, 0xd4f1, 0x38ee, 0x38ef, 0x38f0, 0x0000,
	/* 0x8a40 */
0x0000, 0xd4f3, 0x38f1, 0x0000, 0x38f2, 0x0000, 0x38f3, 0x0000,
0x0000, 0x0000, 0xd4f6, 0x38f4, 0x38f5, 0x38f6, 0x38f7, 0x0000,
0x38f8, 0x38f9, 0x38fa, 0x38fb, 0x38fc, 0x0000, 0x0000, 0xd4fc,
0xbea9, 0xd4fe, 0xc3a5, 0x38fd, 0xd4fd, 0x38fe, 0xcab3, 0x39a1,
0x0000, 0x0000, 0x39a2, 0x39a3, 0x0000, 0x0000, 0x39a6, 0x39a7,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x39a8, 0x39a9, 0x39aa,
0x0000, 0x0000, 0x0000, 0x0000, 0x39ac, 0x0000, 0x0000, 0xd6ac,
0x0000, 0xd5a3, 0x39ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x39b0, 0xc5ca, 0x39b1, 0x39b4, 0x0000, 0x39b5, 0x0000, 0x0000,
0x0000, 0x39b6, 0x0000, 0x39b7, 0x39b8, 0x0000, 0x0000, 0x0000,
0x39b9, 0x0000, 0x39ba, 0x39bb, 0x0000, 0x0000, 0x39bc, 0xbbd0,
0x0000, 0x39be, 0x0000, 0x0000, 0x0000, 0x0000, 0xd5ac, 0x0000,
0x39c1, 0x39c2, 0x0000, 0x0000, 0x0000, 0x39c4, 0xb4af, 0x39c5,
0x0000, 0xccc5, 0xc9b1, 0x0000, 0x39c6, 0x39c7, 0x0000, 0x39c8,
0x39c9, 0x0000, 0x39ca, 0x0000, 0xb0a8, 0x39cb, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x39cc, 0x0000, 0x0000, 0x0000, 0x39cf,
0x39d0, 0x0000, 0x0000, 0x39d1, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xd5b3, 0x0000, 0x0000, 0x39d3, 0x0000, 0x0000, 0x39d5,
0x0000, 0x39d6, 0x39d7, 0x39d8, 0x0000, 0x0000, 0x39d9, 0x0000,
0xb8e4, 0x39da, 0x0000, 0xd5b7, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xcfac, 0x0000, 0x0000, 0x39db,
0x39dc, 0x39dd, 0x39de, 0x0000, 0x39df, 0x0000, 0x0000, 0x0000,
0x39e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x39e2, 0x0000, 0x0000,
	/* 0x8b40 */
0x0000, 0x39e3, 0x0000, 0x39e4, 0xc9d8, 0x0000, 0x0000, 0x0000,
0xd5b5, 0x39e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x39e9, 0x0000, 0x0000, 0x39ea, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x39eb, 0x0000, 0x0000, 0x0000, 0x0000, 0x39ec, 0x0000,
0x39ed, 0x0000, 0x0000, 0x39ee, 0x0000, 0x0000, 0x39ef, 0x39f0,
0x0000, 0x39f1, 0x39f2, 0x39f3, 0x0000, 0x39f4, 0x0000, 0x0000,
0x0000, 0x0000, 0x39f5, 0x0000, 0x0000, 0x0000, 0x39f6, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x39f7, 0x0000, 0x0000, 0x0000,
0x0000, 0x39fc, 0x39fd, 0xd5bc, 0xd5c0, 0x39fe, 0x0000, 0x0000,
0x3aa1, 0x0000, 0x3aa2, 0x0000, 0x3aa3, 0x0000, 0xd5be, 0x0000,
0x0000, 0x3aa4, 0xd5cc, 0x0000, 0x0000, 0x0000, 0xd5c2, 0x0000,
0x3aa5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3aa8,
0x0000, 0x0000, 0x3aa9, 0x0000, 0x0000, 0x3aaa, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x3aab, 0x3aac, 0x0000, 0x0000, 0x0000,
0xd5c6, 0xd5c7, 0x0000, 0x3aad, 0x0000, 0x0000, 0x3aae, 0x3aaf,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ab0, 0x0000,
0xd5c9, 0xd5c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x3ab3, 0x0000, 0x3ab4, 0x0000,
0x3ab5, 0x0000, 0x0000, 0x0000, 0x3ab6, 0xbeee, 0x0000, 0x0000,
0x3ab7, 0x0000, 0x0000, 0x0000, 0x0000, 0xd5cd, 0x0000, 0xc4dc,
0x3ab8, 0x0000, 0x0000, 0xb1c5, 0x0000, 0x0000, 0x0000, 0xd5ce,
0x3ab9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd5cf, 0x0000,
0x3aba, 0x0000, 0xd5d0, 0x0000, 0xd5d1, 0x0000, 0x0000,
	/* 0x8c40 */
0x0000, 0x0000, 0x0000, 0x3abb, 0x3abc, 0x0000, 0x0000, 0x0000,
0x3abd, 0x3abe, 0x3abf, 0x0000, 0x0000, 0x0000, 0x3ac0, 0xc2b9,
0x0000, 0x3ac1, 0x3ac2, 0x0000, 0x0000, 0x0000, 0x0000, 0xd5dc,
0x0000, 0x0000, 0x3ac3, 0x3ac5, 0x3ac6, 0x0000, 0x3ac9, 0x3aca,
0xbcb5, 0x3acb, 0x3acc, 0x3acd, 0x0000, 0x3acf, 0x3ad0, 0xbcc2,
0x0000, 0x3ad1, 0x3ad2, 0x3ad3, 0x3ad4, 0xb5dc, 0x3ad5, 0x3ad6,
0x3ad7, 0x3ad8, 0x3ad9, 0x0000, 0x3ada, 0x3adb, 0x3adc, 0xd5e3,
0x0000, 0xd5e5, 0x0000, 0x0000, 0x3add, 0x0000, 0x3ade, 0x0000,
0x0000, 0xd5e6, 0x0000, 0x3adf, 0x3ae0, 0x3ae1, 0x3ae2, 0x3ae3,
0xb4b2, 0x0000, 0x3ae4, 0xd5ea, 0x0000, 0xd5e9, 0xc7ab, 0xbfb3,
0x0000, 0xd5ed, 0x0000, 0x0000, 0x3ae5, 0x3ae6, 0x0000, 0xd5f0,
0x3ae7, 0xc3fe, 0xd5ef, 0x0000, 0x3ae8, 0xc2d0, 0x0000, 0xc0ec,
0x0000, 0xd5f1, 0xd5f2, 0xd5f3, 0xbfd2, 0x3ae9, 0xd5f4, 0xc6b3,
0x0000, 0x0000, 0xd5f5, 0x3aea, 0x0000, 0x0000, 0x3aeb, 0x3aec,
0xd5f6, 0x0000, 0x3aed, 0x3aee, 0xd5f8, 0x3aef, 0x0000, 0x3af0,
0xb6c6, 0x3af2, 0x0000, 0x3af3, 0x3af4, 0x0000, 0x3af5, 0x3af6,
0x0000, 0x0000, 0x0000, 0xd5fc, 0x0000, 0x0000, 0xbbd3, 0x0000,
0xd5fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x3af8, 0x0000, 0x3af9,
0x0000, 0x0000, 0x3afa, 0xc1d8, 0x3afc, 0x3afd, 0x3afe, 0x0000,
0x0000, 0xd6a4, 0x3ba1, 0x3ba2, 0x0000, 0x0000, 0x3ba3, 0x3ba4,
0xd6a7, 0x0000, 0x0000, 0x3ba6, 0x3ba7, 0x3ba8, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x3ba9, 0x0000, 0x3bab, 0x0000,
0x0000, 0x3bac, 0x3bad, 0x0000, 0x0000, 0x3bae, 0x0000, 0x3baf,
0x3bb0, 0xb2ac, 0x0000, 0x0000, 0x3bb3, 0x0000, 0xc1bb,
	/* 0x8d40 */
0x3bb4, 0x0000, 0x0000, 0x0000, 0x3bb5, 0x3bb6, 0xd6af, 0x0000,
0x3bb8, 0xd6ae, 0xd6b0, 0xd6b3, 0x0000, 0x0000, 0x0000, 0xd6b2,
0x0000, 0xd6b4, 0x0000, 0x3bb9, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bbd,
0x0000, 0x0000, 0x0000, 0x0000, 0x3bbc, 0x0000, 0x0000, 0xc6bd,
0x0000, 0x0000, 0x0000, 0xd6b6, 0x0000, 0x0000, 0x3bbe, 0xcaf7,
0x3bbf, 0x3bc0, 0x0000, 0x3bc1, 0x0000, 0xc5e7, 0x0000, 0x0000,
0x0000, 0xd6b8, 0x0000, 0xd6b7, 0x0000, 0x0000, 0x0000, 0x0000,
0x3bc2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd6bc, 0x0000,
0x3bc4, 0x0000, 0x0000, 0xd6c2, 0x3bc5, 0x0000, 0xd6bd, 0xd6be,
0xd6c7, 0xd6c6, 0xd6c5, 0x0000, 0x0000, 0xd6c0, 0x0000, 0x0000,
0xd6c4, 0x3bc7, 0x0000, 0x0000, 0x0000, 0x3bc6, 0x0000, 0x0000,
0x0000, 0x3bcb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x3bcd, 0x0000, 0x0000, 0x0000, 0x3bcf, 0x0000, 0x0000, 0x3bd0,
0x3bd1, 0x0000, 0x0000, 0x3bd2, 0x3bd3, 0x0000, 0x0000, 0xd6ca,
0x0000, 0xcdf2, 0x3bd5, 0xd6c9, 0x0000, 0x0000, 0x3bd4, 0x0000,
0x0000, 0x3bd6, 0x0000, 0xd6bf, 0x0000, 0x3bd8, 0x3bd9, 0x3bda,
0x3bdb, 0x0000, 0x3bdc, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bdd,
0x3bde, 0x0000, 0x3bdf, 0x0000, 0x0000, 0xd6cd, 0x0000, 0xd6ce,
0x0000, 0x0000, 0x3be0, 0x3be1, 0x0000, 0x0000, 0x0000, 0x3be2,
0x3be3, 0x0000, 0x3be4, 0x3be5, 0xd6d0, 0x0000, 0x0000, 0xd6cf,
0x3be6, 0x0000, 0x3be7, 0xc5e8, 0xd6ba, 0x0000, 0x0000, 0x0000,
0xd6d7, 0x0000, 0x3be8, 0x3be9, 0x3bea, 0x3beb, 0x0000, 0x0000,
0x0000, 0x0000, 0x3bed, 0x0000, 0x0000, 0x3bee, 0x3bef,
	/* 0x8e40 */
0x0000, 0xd6d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bf0, 0x0000,
0x0000, 0x0000, 0x3bf1, 0xd6d4, 0x0000, 0xd6d5, 0x0000, 0x3bf2,
0x0000, 0x66f4, 0x0000, 0x3bf3, 0x0000, 0x0000, 0x3bf4, 0x3bf5,
0xcee6, 0x0000, 0xd6d9, 0xd6d6, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x3bf6, 0x0000, 0x0000, 0x3bf7, 0x0000, 0xd6da, 0x0000,
0x3bf8, 0xb4e0, 0x3bfa, 0x0000, 0x3bf9, 0x0000, 0xd6dd, 0xd6dc,
0x0000, 0x0000, 0xd6de, 0x0000, 0x3bfb, 0x3bfc, 0x0000, 0x0000,
0x0000, 0x3bfd, 0xc1e3, 0x3bfe, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xd6e2, 0x0000, 0x3ca2, 0x3ca3, 0x0000, 0xb4ac, 0x0000,
0x0000, 0x3ca4, 0x0000, 0x3ca5, 0x0000, 0x0000, 0xd6e3, 0x3ca6,
0x0000, 0x3ca7, 0x0000, 0x0000, 0x0000, 0x3cab, 0x3cac, 0x0000,
0x0000, 0x0000, 0x0000, 0xbfe3, 0x3cae, 0x0000, 0x0000, 0xbbd5,
0x0000, 0xc2d3, 0xb5a2, 0x3caf, 0xc4a2, 0x0000, 0x3cb0, 0xd6e8,
0x0000, 0x0000, 0x3cb1, 0x0000, 0xd6ec, 0x0000, 0xd6eb, 0x0000,
0xd6f3, 0x0000, 0x3cb4, 0x0000, 0x3cb2, 0x0000, 0xd6ed, 0x0000,
0x3cb3, 0x3cb5, 0x0000, 0x0000, 0x3cb6, 0xd6ee, 0x3cb7, 0x0000,
0x0000, 0x3cb9, 0x0000, 0xd6f0, 0x0000, 0xcabe, 0xd6f2, 0x0000,
0x0000, 0x0000, 0x3cbb, 0x0000, 0x3cbc, 0x3cbd, 0x3cbe, 0x3cbf,
0x3cc0, 0x0000, 0x3cc1, 0x0000, 0xd6f4, 0x0000, 0xb4b4, 0xb4f6,
0xc4a3, 0x0000, 0xb9ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x3cc4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3cc5, 0x0000,
0x3cc6, 0x3cc8, 0x0000, 0x3cc9, 0xb8cb, 0x3cca, 0x0000, 0x0000,
0x0000, 0x3ccb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ccd,
0x3ccf, 0x0000, 0xd6fa, 0xd6fb, 0xc7d1, 0x0000, 0x0000,
	/* 0x8f40 */
0x3cd0, 0x0000, 0xd6fc, 0x3cd2, 0x3cd1, 0x0000, 0x3cd3, 0xd6fe,
0xd6fd, 0x3cd6, 0x3cd7, 0x0000, 0x0000, 0x0000, 0xd7a4, 0x3cd8,
0xd7a3, 0x3cd9, 0xc9c0, 0xbeb3, 0xd7a7, 0xd7a6, 0xd7a2, 0x0000,
0x3cda, 0x0000, 0x0000, 0xd7a9, 0x3cdb, 0xd7aa, 0x0000, 0x0000,
0x0000, 0xd7ad, 0xd7ab, 0x0000, 0xd7ac, 0x0000, 0xd7af, 0x0000,
0xb2f6, 0xc7b6, 0x0000, 0x0000, 0x3cdd, 0x3cde, 0xd7b2, 0xd0a1,
0xd0b1, 0x3ce0, 0xc6f5, 0x0000, 0xc4a4, 0xd7b7, 0x3ce1, 0x0000,
0x3ce2, 0x3ce3, 0x0000, 0x3ce4, 0x3ce5, 0x3ce6, 0x3ce7, 0x0000,
0x3ce8, 0x3ce9, 0x3cea, 0x3ceb, 0x3cec, 0x0000, 0x0000, 0x3ced,
0xc4a5, 0x3cee, 0xb6af, 0xd7ba, 0x3cef, 0x3cf0, 0xc3c6, 0x3cf1,
0xd7bb, 0x0000, 0x0000, 0x3cf3, 0x3cf4, 0x0000, 0x3cf5, 0xd7bc,
0x0000, 0xb6b0, 0x0000, 0xd7bd, 0x3cf6, 0xd7be, 0x0000, 0xd7c0,
0x3cf8, 0xd7c3, 0x0000, 0x3cfa, 0xd7b4, 0x0000, 0x0000, 0x3cfb,
0x3cfc, 0x0000, 0x3cfe, 0x0000, 0xc4a6, 0x0000, 0x3da1, 0x3da2,
0x3da3, 0x3da4, 0x0000, 0x3da5, 0x3da6, 0x3da7, 0x3da8, 0xd7ca,
0xd7c8, 0x0000, 0x3daa, 0x0000, 0x3dab, 0xd7cd, 0xbdbe, 0x0000,
0x3dac, 0x0000, 0x0000, 0x3dae, 0xd7cf, 0x0000, 0xd7d2, 0x3daf,
0x0000, 0x3db2, 0x0000, 0x0000, 0x3db0, 0xc9fc, 0x3db1, 0x3db3,
0x3db4, 0x3db5, 0x3db6, 0x0000, 0xc6c1, 0xc4a7, 0x0000, 0x3db7,
0xc5b0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x3db9, 0x3dba, 0x0000, 0x3dbc, 0x0000, 0x3dc0, 0x3dc1, 0x0000,
0x0000, 0x0000, 0xb1fe, 0x3dc2, 0x0000, 0x3dc4, 0x0000, 0x0000,
0x0000, 0x3dc5, 0x3dc6, 0x3dc8, 0x3dcb, 0xd8ad, 0x3dcc, 0x3dcd,
0x0000, 0x3dce, 0x0000, 0x0000, 0x3dcf, 0x3dd0, 0x3dd1,
	/* 0x9040 */
0x0000, 0x0000, 0x0000, 0x0000, 0xd7e1, 0x0000, 0x3dd4, 0x3dd6,
0x3dd7, 0x3dd8, 0x0000, 0x3dd9, 0x0000, 0x0000, 0x3dda, 0x0000,
0x3ddb, 0x0000, 0x0000, 0xd7e4, 0x0000, 0x3ddc, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xd7ea, 0x0000, 0x0000, 0x3dde, 0x0000,
0x0000, 0xd7f1, 0x3ddf, 0x3de0, 0x3de1, 0xd7f0, 0x3de2, 0x0000,
0x0000, 0x3de3, 0x0000, 0x3de4, 0x3de5, 0x3de6, 0x0000, 0x0000,
0x0000, 0x0000, 0xd7ef, 0xd7df, 0x3de8, 0xc3d1, 0x0000, 0x0000,
0x3dea, 0x0000, 0x0000, 0xb7c3, 0xd7ee, 0x3deb, 0x0000, 0x0000,
0xd7fa, 0x3ded, 0x0000, 0x3dee, 0x0000, 0x3def, 0x3df0, 0xd8a7,
0x3df1, 0x0000, 0x0000, 0x3df2, 0x3df3, 0x3df4, 0xd8a4, 0x3df5,
0x0000, 0x0000, 0x3df7, 0x0000, 0x3df8, 0x3df9, 0x3dfa, 0xd8a6,
0xc7ba, 0xb0ad, 0x0000, 0x3dfc, 0xd7dc, 0xd8b0, 0xcce5, 0x3dfe,
0x0000, 0x0000, 0xd8ae, 0x3ea2, 0x0000, 0x0000, 0x0000, 0x3ea3,
0x0000, 0x3ea4, 0xc6d7, 0x3ea5, 0x3ea6, 0x0000, 0x0000, 0x3ea9,
0x3eaa, 0x0000, 0x0000, 0xd8ab, 0x3eab, 0x0000, 0x0000, 0x3ead,
0x3eae, 0x3eb0, 0xd8a8, 0x3eb1, 0xc1da, 0x0000, 0x3eb2, 0x0000,
0xd8bd, 0x3eb3, 0x3eb4, 0xd8b6, 0x3eb5, 0xd8bc, 0x3eb6, 0x3eb7,
0x0000, 0x0000, 0x3eb8, 0xd8ba, 0x0000, 0x0000, 0x3eb9, 0x3eba,
0x0000, 0x3ebb, 0x3ebc, 0x3ebd, 0x3ebe, 0x3ebf, 0x3ec0, 0x3ec1,
0x3ec2, 0x0000, 0x3ec3, 0xb0a6, 0x3ec4, 0x0000, 0x3ec5, 0xd8bb,
0x3ec6, 0x0000, 0xd8c2, 0x0000, 0x3ec7, 0xd8c7, 0x0000, 0x0000,
0x0000, 0x3ec9, 0x3eca, 0x0000, 0x0000, 0xd8c8, 0x3ecb, 0x3ecc,
0x3ecd, 0x0000, 0x3ece, 0x0000, 0x0000, 0xd8c6, 0xd8c9, 0xd8c1,
0x0000, 0x3ecf, 0xd8ca, 0x0000, 0xd8cb, 0x3ed0, 0x3ed1,
	/* 0x9140 */
0xd8c0, 0x3ed2, 0xc2d6, 0xd8b2, 0x0000, 0x0000, 0x0000, 0xd8d8,
0x0000, 0x0000, 0x0000, 0xd8ce, 0xd8cf, 0xd8d0, 0x0000, 0x0000,
0x3ed3, 0xd8d6, 0x3ed4, 0x0000, 0xb4b7, 0x0000, 0xd8d4, 0x0000,
0x0000, 0x0000, 0xd8d1, 0x3ed5, 0x0000, 0xceb8, 0xd8d3, 0xd8d5,
0x3ed6, 0xd8cc, 0xd8d2, 0xb7c4, 0x3ed7, 0x0000, 0x0000, 0x3ed8,
0x3ed9, 0x0000, 0xcddd, 0x3eda, 0x3edb, 0x3edc, 0xcdab, 0x3edd,
0x3ede, 0x0000, 0x0000, 0xd8dc, 0x0000, 0x0000, 0xd8e0, 0x0000,
0x3ee0, 0x0000, 0xcef9, 0xd8e1, 0x3ee1, 0x3ee2, 0x0000, 0x0000,
0xd8db, 0x3ee3, 0x3ee4, 0xd8da, 0xd8df, 0x0000, 0x3ee5, 0x0000,
0x3ee7, 0x3ee8, 0x0000, 0x0000, 0x0000, 0xcab0, 0x3ee9, 0x0000,
0x3eeb, 0xd8e2, 0x3eec, 0xd8e3, 0x0000, 0x0000, 0x0000, 0xb7fb,
0x0000, 0x0000, 0x0000, 0xb2b1, 0x3eed, 0x3eee, 0xd8eb, 0x0000,
0x3eef, 0x0000, 0x0000, 0x3ef0, 0x3ef1, 0xd8e9, 0x0000, 0x0000,
0xd8ea, 0xbaa9, 0xd8e6, 0xd8e4, 0xd8ee, 0x3ef3, 0x3ef4, 0xb2fb,
0x0000, 0x3ef5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x3ef6, 0x3ef7, 0x3ef8, 0x3ef9, 0x0000, 0x3efa, 0x3efb, 0xd8f0,
0x0000, 0x3efe, 0x3efc, 0x0000, 0x3efd, 0x0000, 0x0000, 0x3fa1,
0x3fa2, 0x0000, 0x3fa3, 0x0000, 0x0000, 0xc4a8, 0x0000, 0xd8f3,
0xd8f1, 0xd8e7, 0xb7fc, 0x0000, 0xd8f2, 0x0000, 0xd8f6, 0xd8f5,
0xd8f7, 0xd8f8, 0x3fa4, 0x0000, 0x3fa5, 0x3fa6, 0x0000, 0x3fa7,
0xd8fa, 0x3fa8, 0xd8fd, 0x0000, 0x3faa, 0xecc3, 0xd9a1, 0x3fab,
0x3fad, 0xc0ef, 0x3fae, 0x0000, 0x3faf, 0x3fb0, 0x0000, 0xb5ba,
0xd9a5, 0x0000, 0xd9a6, 0x0000, 0x0000, 0xb8cd, 0x3fb1, 0x0000,
0xcce1, 0x0000, 0x3fb3, 0x3fb5, 0x0000, 0x3fb6, 0x0000,
	/* 0x9240 */
0x0000, 0x3fb8, 0xcaa7, 0x3fbc, 0x0000, 0x0000, 0x3fbd, 0x3fbe,
0x0000, 0xd9aa, 0x0000, 0xd9ad, 0x0000, 0x0000, 0x3fbf, 0x0000,
0xd9ae, 0xb0b7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fc3,
0x0000, 0x3fc4, 0x0000, 0xd9b0, 0xd9b7, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x3fc5, 0x3fc6, 0x3fc7, 0x3fc8, 0xd9b8,
0x0000, 0xc8b4, 0x0000, 0xc2f2, 0x0000, 0x3fc9, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fcb, 0x0000,
0x3fcc, 0x3fcd, 0x0000, 0x3fce, 0x3fcf, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xd9bc, 0xd9ba, 0x3fd3, 0xc7d2, 0x0000, 0xb5f2,
0xb3c8, 0x0000, 0x3fd6, 0x0000, 0x0000, 0x3fd7, 0xd9cf, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x3fdb, 0x3fdc, 0x0000, 0x0000,
0x3fdd, 0x3fde, 0xd9c8, 0x3fdf, 0x0000, 0x3fe0, 0x0000, 0x3fe1,
0x0000, 0x0000, 0x0000, 0x3fe3, 0xb5f3, 0x0000, 0x0000, 0xd9cb,
0x3fe4, 0x0000, 0x3fe6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x3fe7, 0x3fe8, 0x0000, 0x0000, 0x0000, 0x3fea, 0xd9d1, 0xc1de,
0x0000, 0x3feb, 0x3fee, 0x0000, 0x0000, 0x3ff0, 0x0000, 0x3ff3,
0x3ff4, 0x3ff5, 0x0000, 0xc4bd, 0x3ff6, 0x0000, 0x0000, 0x3ff7,
0xc1dc, 0x0000, 0x0000, 0x0000, 0x3ff8, 0x3ff9, 0xbcce, 0x0000,
0xd9df, 0x3ffa, 0x0000, 0x0000, 0xb7fe, 0x0000, 0x3ffd, 0x3ffe,
0x40a1, 0x0000, 0x40a2, 0x40a3, 0x0000, 0x40a4, 0x0000, 0xc1dd,
0x40a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x40aa,
0x40ab, 0x0000, 0x40ac, 0x40ad, 0xb3dd, 0x0000, 0x0000, 0x40ae,
0xd9dd, 0xbace, 0x40af, 0x40b0, 0xd9d8, 0x40b3, 0x0000, 0xb7c7,
0xd9de, 0x0000, 0x0000, 0xc1df, 0x40b4, 0x0000, 0xd9e3,
	/* 0x9340 */
0x40b5, 0x0000, 0xc2b7, 0x40b6, 0x0000, 0x40b7, 0x0000, 0x0000,
0x0000, 0x40b9, 0x40ba, 0x40bb, 0x40bc, 0x0000, 0x0000, 0x0000,
0xcdc8, 0xb4b9, 0x40bd, 0x0000, 0x0000, 0x0000, 0x0000, 0x40bf,
0x0000, 0x0000, 0x0000, 0x0000, 0x40c1, 0xb4f8, 0x0000, 0x0000,
0x0000, 0x40c3, 0x40c4, 0x0000, 0x40c6, 0xcdc9, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xd9ec, 0x0000, 0x0000, 0x40c7, 0x40c8,
0xc2bb, 0x0000, 0x0000, 0x40ca, 0x0000, 0xd9ea, 0xd9f1, 0x40cc,
0x0000, 0x0000, 0x0000, 0x0000, 0x40cf, 0x0000, 0x40d0, 0x0000,
0x40d1, 0x0000, 0xd9f2, 0x40d2, 0x0000, 0x0000, 0x40d4, 0x40d5,
0x0000, 0x0000, 0x0000, 0x40d6, 0xd9ef, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xbaf1, 0x0000, 0xc0dd, 0x0000, 0x0000, 0x40d9,
0x0000, 0x0000, 0xd9f7, 0x40da, 0x0000, 0x40db, 0x40dd, 0x0000,
0x0000, 0x0000, 0x0000, 0x40df, 0x40e0, 0x40e1, 0x40e2, 0x40e3,
0x40e4, 0x40e5, 0x0000, 0x40e6, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xd9f5, 0x0000, 0x0000, 0x0000,
0x40e8, 0x40e9, 0x0000, 0xd9f6, 0x0000, 0x40ea, 0x0000, 0x40eb,
0x0000, 0x0000, 0x0000, 0x0000, 0xb7e2, 0x0000, 0xd9fd, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x40ee, 0x40ef, 0xd9fa,
0x0000, 0x0000, 0x40f1, 0xc7b2, 0x40f3, 0x0000, 0x40f4, 0x40f5,
0x0000, 0x40f6, 0x0000, 0x40f7, 0xd9fb, 0x40f8, 0x0000, 0x40f9,
0x0000, 0xc9ef, 0x0000, 0x0000, 0xcbd0, 0x40fb, 0x0000, 0x0000,
0xb3c9, 0xdaa5, 0x40fc, 0x40fd, 0x40fe, 0xcdca, 0x0000, 0x41a1,
0x0000, 0xdaa4, 0x0000, 0x41a2, 0x41a3, 0x41a4, 0x41a5, 0x0000,
0x41a8, 0x0000, 0xd9bf, 0x41a9, 0x0000, 0x0000, 0xdaa1,
	/* 0x9440 */
0x0000, 0x0000, 0x0000, 0x0000, 0xdaab, 0xdaac, 0xdaae, 0x41ac,
0xdaa9, 0x0000, 0x41ad, 0x41ae, 0x0000, 0xb5bc, 0x41af, 0x0000,
0xdaaf, 0x41b0, 0xdaa8, 0xdab3, 0x0000, 0xdab2, 0x41b1, 0xdab1,
0x41b2, 0x0000, 0x0000, 0xdab4, 0x41b3, 0x0000, 0xdab6, 0xbef1,
0x41b4, 0x41b5, 0x0000, 0x0000, 0x41b6, 0xdab9, 0x0000, 0x0000,
0x41b7, 0x41b9, 0x0000, 0x0000, 0x0000, 0x0000, 0x41ba, 0x0000,
0x0000, 0x41bb, 0x41bc, 0x0000, 0x41bd, 0x0000, 0x41be, 0x0000,
0x41bf, 0xdab8, 0xd9f0, 0x41c0, 0x41c1, 0x0000, 0x0000, 0x0000,
0x41c2, 0xdabb, 0xdaba, 0x41c3, 0x0000, 0x0000, 0x41c4, 0xd9f8,
0xdab0, 0x0000, 0x0000, 0x41c6, 0x0000, 0x0000, 0xdabf, 0x41c7,
0x41c8, 0x41c9, 0x0000, 0x0000, 0x0000, 0x41ca, 0x0000, 0x0000,
0x41cb, 0x0000, 0x0000, 0xdac6, 0x0000, 0x41cd, 0x41ce, 0x0000,
0x41cf, 0xc7d4, 0xdac7, 0x0000, 0x0000, 0x41d0, 0x41d1, 0x0000,
0x0000, 0x0000, 0x41d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xc5a8, 0x0000, 0xdacb, 0x0000, 0x41d4,
0x0000, 0x0000, 0x41d5, 0x0000, 0x0000, 0x0000, 0x41d6, 0xdacc,
0xdacd, 0x0000, 0x41d7, 0x0000, 0xd5dd, 0xc0c6, 0x41d8, 0x0000,
0xbad8, 0x0000, 0x41d9, 0x0000, 0x41da, 0x0000, 0x41db, 0x0000,
0x41dc, 0x0000, 0x41dd, 0x0000, 0x41de, 0x41df, 0x0000, 0x0000,
0xbbc2, 0x41e0, 0x0000, 0x41e1, 0x41e2, 0x41e3, 0x0000, 0x0000,
0xdad2, 0x0000, 0x0000, 0x0000, 0x0000, 0x41e4, 0x0000, 0x41e5,
0x0000, 0x41e6, 0x41e7, 0x0000, 0x0000, 0x41e9, 0x0000, 0x0000,
0x41ea, 0x0000, 0x41ec, 0xdada, 0x0000, 0xdad9, 0x0000, 0x0000,
0x0000, 0x41ed, 0xdadc, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0x9540 */
0x41ef, 0x0000, 0x41f0, 0x41f1, 0x0000, 0x41f2, 0xdae1, 0x0000,
0x0000, 0x41f3, 0x41f4, 0x0000, 0x41f6, 0x0000, 0xbeba, 0x41f7,
0x41f8, 0x0000, 0x41f9, 0x0000, 0x41fa, 0x41fb, 0x41fd, 0x0000,
0x0000, 0x0000, 0x0000, 0xdae6, 0x42a1, 0x42a2, 0x42a3, 0x42a4,
0x42a5, 0x42a6, 0x42a7, 0x42a8, 0x42a9, 0x42aa, 0x42ab, 0x42ac,
0x0000, 0x42ae, 0x42b0, 0x0000, 0x42af, 0x0000, 0x0000, 0x0000,
0xdba6, 0x42b1, 0xbbfe, 0xdae8, 0x42b2, 0x42b3, 0x0000, 0x0000,
0xdae9, 0x42b4, 0x0000, 0x42b7, 0x0000, 0x42b6, 0x42b9, 0x0000,
0x42ba, 0x42bb, 0x42bc, 0xdaec, 0xdaeb, 0x42bd, 0xdaf1, 0x0000,
0x0000, 0xdaee, 0xc8d5, 0x42c0, 0x42c1, 0x42c2, 0x0000, 0x0000,
0x0000, 0x42c4, 0x42c5, 0x42c8, 0x42c9, 0x42ca, 0x42cc, 0x0000,
0x42c6, 0x42cb, 0xb6c7, 0xdaf3, 0x0000, 0x0000, 0xdaf4, 0xdaf6,
0x0000, 0x42cd, 0x42cf, 0xdaf5, 0x0000, 0x42d0, 0x42d1, 0x0000,
0x0000, 0x0000, 0xdaf8, 0x42d2, 0x42d3, 0x42d4, 0x42d5, 0x0000,
0x42d6, 0x42d7, 0x0000, 0xc4aa, 0x0000, 0x42d8, 0x0000, 0xcef1,
0x0000, 0x0000, 0xbbc3, 0x0000, 0x42d9, 0x0000, 0x0000, 0x42da,
0x42db, 0x0000, 0x42dc, 0x0000, 0x0000, 0xdba2, 0x0000, 0x42dd,
0xdafe, 0x0000, 0x42de, 0x42df, 0xdafa, 0x42e0, 0x42e1, 0xdba1,
0x0000, 0x0000, 0xc6de, 0x42e2, 0xdafc, 0x0000, 0x0000, 0x42e3,
0x0000, 0x42e4, 0x42e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x42e6,
0x0000, 0xdba3, 0x0000, 0x0000, 0xdba4, 0x0000, 0x42e8, 0xdba5,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42e9, 0x0000,
0x42ea, 0x42eb, 0x0000, 0x42ec, 0x0000, 0x0000, 0xdbaa, 0x0000,
0xbdf1, 0x42ed, 0x42bf, 0xc1be, 0x0000, 0x0000, 0xd0f2,
	/* 0x9640 */
0x0000, 0x42ee, 0x0000, 0x42ef, 0x0000, 0x42f0, 0xdbac, 0x0000,
0x0000, 0x42f1, 0xdbad, 0x0000, 0x42f2, 0x0000, 0x42f3, 0xdbae,
0x42f4, 0x0000, 0x42f5, 0x0000, 0x0000, 0x0000, 0xdbb0, 0x0000,
0xdbb2, 0x0000, 0x0000, 0x42f6, 0xdbb4, 0xdbb7, 0xdbb6, 0x0000,
0x0000, 0x0000, 0x42f7, 0xdbb3, 0xdbb5, 0x0000, 0x42f8, 0x42f9,
0x0000, 0x0000, 0x0000, 0x0000, 0x42fc, 0x42fd, 0x0000, 0x0000,
0xdbbb, 0x0000, 0x0000, 0x42fe, 0xccdd, 0xdbbc, 0xdbbd, 0x43a1,
0x0000, 0x0000, 0x43a2, 0x43a3, 0xc5ec, 0x43a4, 0x43a5, 0x0000,
0x0000, 0x0000, 0x0000, 0x43a6, 0x0000, 0x0000, 0x0000, 0x0000,
0xdbc7, 0x0000, 0x0000, 0x0000, 0xdbc3, 0x0000, 0x43a9, 0x43aa,
0x43ab, 0x0000, 0x43ac, 0x0000, 0x43ad, 0x43af, 0x43b0, 0x0000,
0xcfc8, 0xdbc6, 0x0000, 0xdbc5, 0xdbc0, 0x0000, 0x0000, 0x43b2,
0x43b3, 0xdbca, 0xdbd4, 0x0000, 0x43b5, 0x43b6, 0x43b7, 0x0000,
0x0000, 0x43b9, 0x43ba, 0x43bc, 0xdbd6, 0x0000, 0x43bd, 0x43be,
0xc9a2, 0x0000, 0x0000, 0x0000, 0xdbd5, 0x0000, 0x0000, 0x43c0,
0x0000, 0x0000, 0x43c3, 0x0000, 0xdbcf, 0x43c4, 0xdbd7, 0x0000,
0x0000, 0x0000, 0x0000, 0xdbd3, 0x43c6, 0xbaf4, 0x43c7, 0x43c8,
0x0000, 0x43b8, 0x0000, 0xbaba, 0x0000, 0xcbef, 0x0000, 0xc4ce,
0xc6ca, 0xb1c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x43ca, 0x0000,
0x0000, 0x43cb, 0x0000, 0x0000, 0x0000, 0xdbd9, 0x43cd, 0x0000,
0xb3fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x43cf, 0x43ce, 0xdbe1,
0x43d0, 0x43d1, 0x0000, 0x43d2, 0x43d3, 0x43d4, 0xc0f3, 0x0000,
0x0000, 0x0000, 0x43d6, 0x43d7, 0x0000, 0x0000, 0xdbdd, 0x0000,
0x43c9, 0x0000, 0x43dd, 0x43de, 0xdbe2, 0x0000, 0x43df,
	/* 0x9740 */
0xbaf9, 0xcbf1, 0x0000, 0xbbb7, 0x0000, 0x0000, 0x0000, 0x43e1,
0x43e2, 0x43e3, 0x43e4, 0x43e5, 0x0000, 0x43e6, 0x0000, 0x43e7,
0x43e8, 0x43e9, 0x43ea, 0x0000, 0xdbf5, 0xdbe5, 0x0000, 0x43eb,
0x43ec, 0x0000, 0x43ee, 0x0000, 0x0000, 0x0000, 0x0000, 0xdbf4,
0x0000, 0x0000, 0x0000, 0x0000, 0xdbe9, 0x0000, 0x43ef, 0x43f0,
0x0000, 0x43f1, 0xdbeb, 0x43f2, 0xdbea, 0x0000, 0xdbe6, 0xdbf1,
0x43f3, 0x43f4, 0x0000, 0x43f5, 0x43f6, 0x43f7, 0x0000, 0x0000,
0x43f8, 0xbaad, 0x43f9, 0x0000, 0xb3e1, 0x0000, 0x0000, 0x0000,
0xdbee, 0xdbf2, 0x43fa, 0xc5ee, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xb4fe, 0x43fb, 0xdcb2, 0x0000, 0x43fc, 0xdbf7, 0x43fd,
0x0000, 0x43fe, 0x44a1, 0x44a2, 0x44a3, 0xdca1, 0x44a4, 0xdca7,
0x44a5, 0x0000, 0x44a6, 0x44a7, 0x0000, 0xc5ef, 0xdbfc, 0x0000,
0x0000, 0x44a8, 0x0000, 0xdca2, 0x44a9, 0x0000, 0x44aa, 0x44ab,
0x44ac, 0x44ad, 0xdcac, 0xc0b3, 0x0000, 0x0000, 0x44b1, 0x0000,
0x0000, 0x44b2, 0x44b4, 0x0000, 0x0000, 0xcfd0, 0x0000, 0x0000,
0xdca6, 0x44b5, 0x0000, 0xdbf8, 0x44b6, 0x44b7, 0xdbfd, 0xdbf3,
0x44b9, 0x44ba, 0x0000, 0x0000, 0x44bb, 0x44bc, 0x0000, 0xbffa,
0xdcaf, 0xb3f1, 0xb8a1, 0x0000, 0x0000, 0xdcb1, 0xdbfa, 0xdcb0,
0xdca9, 0xdbfb, 0x0000, 0xdcad, 0x0000, 0xdcae, 0x0000, 0x0000,
0x0000, 0x0000, 0x44bd, 0x0000, 0x44be, 0x44bf, 0xdca4, 0x0000,
0x44c0, 0x0000, 0x44c1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x44c3, 0x0000, 0x0000, 0x0000, 0x44c4, 0xcdcc, 0x0000,
0x0000, 0x0000, 0x44c5, 0x0000, 0x0000, 0x0000, 0x0000, 0xc9f6,
0xc2ca, 0x0000, 0x0000, 0xdcbe, 0x44c7, 0xdcb5, 0x0000,
	/* 0x9840 */
0xdcc0, 0xc6ea, 0x44c9, 0x44ca, 0x0000, 0x44cc, 0x44cd, 0xdcc4,
0x44ce, 0xb6c8, 0xbddd, 0x44cf, 0x44d1, 0xc7e0, 0xdcbc, 0xb6cb,
0x0000, 0x44d2, 0x44d3, 0xb3da, 0xdcb9, 0x44d4, 0xdcc3, 0x0000,
0x0000, 0xbae7, 0x0000, 0x0000, 0xb1dd, 0x0000, 0x0000, 0xdcd4,
0x44d7, 0x0000, 0x44d8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xdcd5, 0x44da, 0x0000, 0x0000, 0x0000, 0x44db, 0x44dc,
0x0000, 0x0000, 0x0000, 0xdcc6, 0x44e0, 0x0000, 0xdcc5, 0x0000,
0x0000, 0x0000, 0x44e2, 0x0000, 0x44e3, 0x44e4, 0x0000, 0x0000,
0xdccb, 0xdcc8, 0x0000, 0x0000, 0xdcd1, 0x0000, 0x44e5, 0x0000,
0xf4a2, 0x44e6, 0x0000, 0xb9bd, 0xc1e4, 0x0000, 0x44e7, 0x0000,
0xdcca, 0x0000, 0x44e8, 0x44e9, 0xcdcd, 0xcbea, 0x0000, 0x0000,
0xdccf, 0xdcd9, 0x0000, 0x44ea, 0x0000, 0x0000, 0x44eb, 0x0000,
0xdce1, 0xdcda, 0x0000, 0x0000, 0xdce7, 0x0000, 0x44ec, 0x44ed,
0x0000, 0x44ee, 0x44ef, 0x0000, 0x44f0, 0x0000, 0x0000, 0x0000,
0xdcdf, 0x0000, 0xc4d0, 0x0000, 0x44f1, 0x44f2, 0x44f3, 0xdcdb,
0x44f4, 0x0000, 0xdce2, 0x0000, 0x0000, 0x0000, 0x0000, 0xc8f5,
0xdcee, 0x0000, 0x0000, 0x44f5, 0x0000, 0x44f6, 0xdce9, 0xdcec,
0xdce6, 0x44f7, 0x0000, 0xc9b8, 0x44f8, 0xdcdc, 0x0000, 0x44f9,
0xdce4, 0x44fa, 0xdcf8, 0xdceb, 0x44fb, 0x0000, 0x0000, 0x0000,
0xb8a2, 0xb3df, 0x0000, 0x0000, 0xdcd3, 0x44fd, 0x44fe, 0x0000,
0x45a1, 0xdcf0, 0x45a2, 0xdcf7, 0xbcf9, 0xb3f2, 0x45a3, 0x0000,
0x45a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x45a6, 0x45a7, 0xdcf6,
0x45a8, 0x45a9, 0xb6b6, 0x0000, 0x0000, 0x45aa, 0x0000, 0x45ac,
0x45ad, 0x0000, 0x0000, 0x45ae, 0x45af, 0x0000, 0x0000,
	/* 0x9940 */
0x0000, 0x0000, 0x0000, 0xb5a1, 0x0000, 0xdcf3, 0x0000, 0x45b1,
0xdcf5, 0x45b2, 0x0000, 0x0000, 0x45b3, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xdcef, 0x45b5, 0x0000, 0x0000, 0x0000,
0x0000, 0xdcf1, 0x0000, 0x0000, 0x0000, 0x45b6, 0xb3e0, 0x45b7,
0x0000, 0x45b8, 0x0000, 0x45b9, 0x45ba, 0x0000, 0x45bb, 0x0000,
0x45bc, 0x0000, 0xdcfa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x45be, 0xdbd8, 0x45bf, 0x45c0,
0x45c1, 0x0000, 0xdcfd, 0xdcfe, 0x0000, 0x45c2, 0x0000, 0x0000,
0x0000, 0x0000, 0xddac, 0x0000, 0xdbed, 0x45c4, 0x45c5, 0x45c6,
0x0000, 0xdda7, 0x45c7, 0x0000, 0x0000, 0x0000, 0xdda6, 0x0000,
0x0000, 0xdda3, 0x0000, 0x45c8, 0x45c9, 0x45ca, 0x0000, 0xdcea,
0xdda5, 0xdda4, 0x0000, 0x0000, 0x45cb, 0x0000, 0x45cd, 0x45cc,
0x0000, 0x0000, 0x45ce, 0x0000, 0x0000, 0x0000, 0x45cf, 0xddaa,
0x0000, 0xcfa6, 0x45d0, 0x45d1, 0x45d2, 0x0000, 0x0000, 0x0000,
0xddad, 0xb6fb, 0x45d3, 0x45d4, 0xdda9, 0xddab, 0x0000, 0x0000,
0x0000, 0x0000, 0x45d5, 0x0000, 0x0000, 0x45d6, 0xc8a7, 0x0000,
0xddae, 0x0000, 0x45d7, 0x0000, 0x0000, 0x0000, 0x45d8, 0x45d9,
0x45da, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xddb2, 0xddaf, 0x45db, 0x45dc, 0x0000, 0x0000, 0x0000, 0x0000,
0x45dd, 0x45de, 0xcdf3, 0xddb0, 0x45df, 0x45e0, 0x0000, 0x45e1,
0xdcde, 0x0000, 0x0000, 0x0000, 0x0000, 0x45e2, 0x45e3, 0x45e4,
0xddb3, 0x0000, 0x0000, 0x0000, 0xddb4, 0x45e5, 0x0000, 0x0000,
0x0000, 0x45e6, 0x0000, 0xb1b5, 0x45e7, 0xddb6, 0x0000, 0x0000,
0x45e9, 0x0000, 0x0000, 0x45ea, 0x45eb, 0x0000, 0x0000,
	/* 0x9a40 */
0x45ec, 0x0000, 0x0000, 0x0000, 0x0000, 0x45ed, 0x45ee, 0xddb7,
0x45ef, 0x0000, 0xb6d6, 0x45f0, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x45f2, 0x0000, 0x45f3, 0xc3b7, 0x0000, 0xddbf,
0x0000, 0x45f4, 0xb4bf, 0xddc1, 0x0000, 0x45f5, 0x0000, 0x45f6,
0x0000, 0xddc2, 0x0000, 0x45f7, 0x0000, 0xddc3, 0x45f8, 0xddc4,
0x0000, 0xcae2, 0x45fa, 0x0000, 0x0000, 0x45fb, 0xbbf5, 0x45fc,
0x0000, 0x0000, 0xbad0, 0xcef2, 0x45fd, 0x0000, 0x0000, 0xddc5,
0x0000, 0x45fe, 0x46a1, 0xddc7, 0xddc8, 0x46a3, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xddcd, 0x46a4,
0xddcc, 0x0000, 0x0000, 0x0000, 0xddce, 0x46a6, 0x46a7, 0x46a8,
0x46a9, 0xddcf, 0x0000, 0x0000, 0x0000, 0x46aa, 0x46ab, 0xddd1,
0x46ac, 0x46ad, 0x46ae, 0xddd2, 0x46af, 0xddd4, 0xddd3, 0x0000,
0x46b0, 0x46b1, 0xbba6, 0xb3cc, 0xddd7, 0x46b2, 0x46b3, 0xd4cc,
0x46b4, 0x46b5, 0xddd8, 0x0000, 0x0000, 0x46b6, 0x0000, 0x46b7,
0xcbe8, 0x0000, 0x0000, 0xc8fb, 0x46b9, 0x0000, 0x0000, 0x0000,
0xdddb, 0x0000, 0x0000, 0x46bb, 0x0000, 0x0000, 0x46bc, 0x46bd,
0x0000, 0x0000, 0xdddc, 0x0000, 0x46be, 0x0000, 0x46bf, 0x0000,
0x0000, 0x0000, 0x46c0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x46c2, 0x0000, 0x0000, 0x46c3, 0x0000, 0x46c4, 0xdde1, 0x46c6,
0x0000, 0x0000, 0x0000, 0x46c8, 0x46ca, 0xb5a4, 0x0000, 0x0000,
0x0000, 0x0000, 0xdde6, 0x0000, 0x0000, 0x46d0, 0x0000, 0x0000,
0x46d2, 0x46d4, 0xc9b9, 0x0000, 0x46d5, 0x46d6, 0x0000, 0xc8c5,
0x46d7, 0x0000, 0x0000, 0x0000, 0x0000, 0x46d9, 0x0000, 0x46da,
0xc8c6, 0x46db, 0x0000, 0x46dc, 0x0000, 0x0000, 0x0000,
	/* 0x9b40 */
0x46de, 0xb1f8, 0xdde9, 0x0000, 0x0000, 0x0000, 0x47b6, 0x46e1,
0x0000, 0x46e2, 0x0000, 0x46e3, 0x0000, 0xddf2, 0x0000, 0x0000,
0x46e6, 0xb7e8, 0x46e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x46eb,
0x0000, 0x0000, 0xddec, 0x0000, 0x0000, 0xddf3, 0x46ee, 0xb2ad,
0x46ef, 0x46f0, 0xdded, 0x46f1, 0x0000, 0x0000, 0x0000, 0xc2f4,
0x0000, 0x0000, 0x0000, 0x46f3, 0x46f5, 0x0000, 0x0000, 0x0000,
0xdea1, 0x0000, 0xb6b7, 0x46f6, 0x0000, 0x46f7, 0x0000, 0x0000,
0x0000, 0x46f8, 0x0000, 0x46f9, 0x46fb, 0x46fc, 0x0000, 0x0000,
0xdea4, 0x47a1, 0x47a2, 0xddfb, 0x0000, 0x0000, 0x0000, 0x47a4,
0x47a5, 0x47a7, 0x0000, 0x47a9, 0x47aa, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x47ad, 0x0000,
0x47af, 0x0000, 0x47b0, 0x47b1, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xdea6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x47b3, 0x47b5, 0xb1cc, 0x0000, 0x0000, 0x47b8, 0x0000, 0x0000,
0xdea8, 0x0000, 0xdeab, 0x0000, 0x47bc, 0x0000, 0x0000, 0xbef4,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x47bd, 0x0000, 0x0000,
0x0000, 0x47bf, 0x47c0, 0x0000, 0xdeb3, 0x47c1, 0x47c2, 0x0000,
0x0000, 0xb3bd, 0x0000, 0x47c4, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xdeb5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x47c7, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x47c9, 0x47cb, 0x47cc, 0x47cd, 0xcede, 0x0000,
0xc6c2, 0x0000, 0x0000, 0x47cf, 0x0000, 0x0000, 0x0000, 0x0000,
0x47d0, 0x0000, 0x47d1, 0x47d2, 0x0000, 0x0000, 0xcec3, 0x47d3,
0x0000, 0x0000, 0x0000, 0x0000, 0x47d6, 0x0000, 0x47d7,
	/* 0x9c40 */
0x0000, 0x47d8, 0x47d9, 0x0000, 0xdec7, 0x0000, 0x0000, 0xdecc,
0x0000, 0x0000, 0x47db, 0x0000, 0x47dd, 0x47df, 0x0000, 0x47e0,
0x0000, 0xdec6, 0x47e1, 0xdecd, 0x0000, 0x47e2, 0x47e3, 0x0000,
0x47e4, 0xcaa5, 0x47e5, 0x0000, 0xdec9, 0x0000, 0x0000, 0x0000,
0x47e7, 0x0000, 0x0000, 0x0000, 0x47e8, 0x0000, 0xb3e9, 0xbad1,
0xbec4, 0xbdc2, 0x0000, 0x0000, 0xb7cc, 0xdebc, 0x0000, 0xded2,
0xb8ba, 0x0000, 0x47e9, 0xdedb, 0x47ea, 0xb1b2, 0x47eb, 0x0000,
0x0000, 0xc2ac, 0xded1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x47ed, 0x0000, 0x47ee, 0x47ef, 0x47f0, 0x0000, 0xded5, 0x0000,
0x0000, 0x0000, 0x0000, 0x47f2, 0x0000, 0x0000, 0x47f3, 0x47f4,
0xccab, 0x47f5, 0x0000, 0x47f6, 0x0000, 0x47f7, 0x47f8, 0x0000,
0x47fb, 0x0000, 0x0000, 0x47fc, 0x47fd, 0x47fe, 0x0000, 0x0000,
0x48a1, 0x48a2, 0x0000, 0x0000, 0x0000, 0xcdaf, 0x48a3, 0x0000,
0x0000, 0x0000, 0x0000, 0xc5f2, 0x0000, 0x0000, 0xded3, 0x48a4,
0x0000, 0x0000, 0xded9, 0x0000, 0x0000, 0x0000, 0x0000, 0x48a5,
0x0000, 0x48a6, 0xcbfe, 0x0000, 0xdee3, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xc8ae, 0x48a7, 0x0000, 0x0000, 0x0000, 0x48a8,
0x0000, 0x0000, 0xbde0, 0x0000, 0x48a9, 0x0000, 0x0000, 0xb9c2,
0x0000, 0x48aa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x48ac, 0x48ad, 0x0000, 0x48af, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x48b1, 0x48b2, 0x48b4, 0xdeeb, 0xccc7,
0x0000, 0x48b6, 0xdee6, 0x48b7, 0xdefe, 0x48b8, 0x48b9, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc2ec, 0x0000,
0x0000, 0x0000, 0x48bb, 0xdef6, 0x48bc, 0x48bd, 0xdefc,
	/* 0x9d40 */
0x0000, 0x0000, 0xdefa, 0x0000, 0x0000, 0x0000, 0xdfa3, 0xdef7,
0x0000, 0x48bf, 0x0000, 0x48c0, 0xdef8, 0xdee0, 0x0000, 0xb5f9,
0x0000, 0x48c1, 0x0000, 0x0000, 0x48c2, 0x48c3, 0x0000, 0x48c4,
0x48c5, 0x0000, 0x0000, 0xdef4, 0x0000, 0x48c6, 0x0000, 0x48c7,
0x0000, 0x48c8, 0x48c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xb4c1, 0xcefa, 0x0000, 0x48ca, 0x0000, 0x0000, 0xc4d2, 0x0000,
0x48ce, 0xdefd, 0x0000, 0x0000, 0x0000, 0xc1b2, 0x0000, 0x0000,
0x48d1, 0x48d2, 0x0000, 0xdef9, 0x0000, 0xdef3, 0x0000, 0x0000,
0x0000, 0x0000, 0xb4c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x48d4, 0x0000, 0x48d5, 0x48d6, 0x48d7, 0xb7e9, 0x0000, 0x0000,
0x48d8, 0x48d9, 0x48da, 0xdfaa, 0x48db, 0xb3e3, 0x0000, 0x48dd,
0x0000, 0xbde1, 0x0000, 0x0000, 0x48df, 0x0000, 0x0000, 0x0000,
0x48e0, 0xdfa9, 0xc4d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x48e1, 0x48e2, 0x0000, 0xdfa8, 0xdfa7, 0xdfad,
0x48e3, 0x0000, 0xdfa4, 0x48e4, 0x0000, 0x48e6, 0x0000, 0x48e9,
0xdfb1, 0x48ea, 0x48eb, 0x48ec, 0x0000, 0x48ed, 0xb4c2, 0x0000,
0x0000, 0x48ee, 0x0000, 0x0000, 0x0000, 0x48ef, 0x48f0, 0x0000,
0xdfb5, 0xdfb7, 0x48f1, 0x48f2, 0x48f4, 0x0000, 0xdfba, 0x0000,
0x0000, 0x0000, 0x48f5, 0x48f6, 0x48f7, 0xc5c3, 0x0000, 0x0000,
0x48f8, 0x0000, 0x0000, 0x0000, 0x0000, 0x48fa, 0x0000, 0x0000,
0x0000, 0xc2f9, 0xc7bb, 0x0000, 0x48fb, 0xdfb9, 0x48fc, 0x48fd,
0x48fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xdfbe, 0xdfbc, 0x0000, 0x0000, 0xdfbf, 0x0000, 0x49a1, 0xdfc2,
0x0000, 0x0000, 0xdfbb, 0x0000, 0x0000, 0xdeb9, 0x0000,
	/* 0x9e40 */
0x0000, 0x0000, 0x49a3, 0x49a4, 0x0000, 0xcdf4, 0xdfbd, 0x0000,
0x49a5, 0xdfc0, 0x0000, 0xdfab, 0x0000, 0x49a6, 0xefe9, 0x0000,
0x0000, 0x49a7, 0xdfc5, 0x0000, 0x49a8, 0x49a9, 0xdfc9, 0x0000,
0x49aa, 0xdfc7, 0x0000, 0x0000, 0x0000, 0x49ab, 0x49ac, 0x49ad,
0x0000, 0xdfc3, 0x0000, 0xdfc4, 0x0000, 0x49ae, 0x0000, 0xdfc8,
0x0000, 0x0000, 0x0000, 0x0000, 0xc9ce, 0x0000, 0x49af, 0xdfce,
0x0000, 0x0000, 0xdfcd, 0xc6d4, 0xdfcf, 0x49b0, 0x0000, 0x0000,
0x0000, 0x0000, 0xc3f5, 0xc2ed, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xc0a5, 0x0000, 0x0000, 0x49b2, 0xdfd0, 0x0000, 0xdfd2,
0x0000, 0x49b3, 0x0000, 0x49b4, 0x0000, 0x0000, 0x0000, 0x49b6,
0x0000, 0xdfd1, 0x0000, 0x0000, 0x0000, 0x0000, 0x49b7, 0x49b8,
0x0000, 0x0000, 0x0000, 0x49b9, 0x49ba, 0x49bb, 0x49bc, 0x0000,
0x49c1, 0x0000, 0xdfd3, 0x0000, 0x0000, 0x49bd, 0x49be, 0x0000,
0x0000, 0xc6e7, 0x0000, 0x0000, 0x0000, 0x0000, 0x49bf, 0x0000,
0x0000, 0x0000, 0x0000, 0xdfd4, 0x49c2, 0x49c3, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x49c5, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xbad2, 0x49c9, 0x0000, 0x0000,
0x0000, 0x49cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x49cf, 0x49d0, 0x0000, 0x49d1, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x49d2, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x49d4, 0x0000, 0x49d6, 0x0000,
0x0000, 0xb0d9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xdfde, 0x0000, 0x0000, 0x0000, 0xb1a8, 0x0000, 0x49d9,
0x0000, 0x49da, 0x49db, 0x49dc, 0x49dd, 0x0000, 0x0000,
	/* 0x9f40 */
0x49df, 0xdfdf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xdfd8, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x49e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x49e2, 0x49e3, 0x49e4, 0x49e5, 0x49e6, 0x0000,
0x49e7, 0x49e8, 0x0000, 0x0000, 0x49e9, 0x0000, 0x0000, 0xb1eb,
0x0000, 0x0000, 0xdfe3, 0x0000, 0x49ea, 0x0000, 0x49eb, 0xccb5,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x49ec, 0x0000, 0x49ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x49f1, 0x0000, 0x0000, 0x0000, 0xbec6, 0x0000,
0x0000, 0x0000, 0x0000, 0x49f2, 0x0000, 0x0000, 0x0000, 0x49f4,
0x49f5, 0x0000, 0xcefb, 0x49f7, 0x0000, 0x0000, 0x49f8, 0x0000,
0x49f9, 0x0000, 0x0000, 0xdfe6, 0xdfeb, 0x49fa, 0x0000, 0xb1ec,
0x49fb, 0x0000, 0x0000, 0x0000, 0x49fe, 0x0000, 0xdfe9, 0x0000,
0xdfe5, 0xc8d1, 0x0000, 0x0000, 0xdfec, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4aa2, 0x0000, 0x0000,
0x0000, 0x0000, 0x4aa3, 0x0000, 0x0000, 0x0000, 0x4aa4, 0x0000,
0x4aa5, 0xdfe7, 0x0000, 0x0000, 0x4aa6, 0x0000, 0x0000, 0x0000,
0x0000, 0x4aa7, 0x0000, 0xdff0, 0x0000, 0x0000, 0x4aa8, 0x4aa9,
0x0000, 0x0000, 0x0000, 0x0000, 0x4aab, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4aac,
0x4aad, 0xc7ae, 0x4aae, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ab0,
0x0000, 0x0000, 0x0000, 0xdff5, 0x4ab1, 0x4ab2, 0x4ab3, 0x0000,
0x4ab4, 0x0000, 0x0000, 0x0000, 0xc5f5, 0xdff7, 0x0000, 0x4ab5,
0x4ab6, 0x0000, 0x0000, 0xced5, 0x0000, 0xdff6, 0x4ab7,
	/* 0xa040 */
0x4ab8, 0xdff3, 0x0000, 0x4ab9, 0x4aba, 0x0000, 0x4abb, 0x0000,
0x0000, 0xd3db, 0x0000, 0x0000, 0x0000, 0x0000, 0xbbb8, 0x0000,
0x0000, 0x0000, 0x0000, 0xdffb, 0xbfa4, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xdffd, 0x0000, 0x0000, 0x4abc, 0x0000,
0xdfee, 0xdffe, 0x0000, 0x4abd, 0xe0a2, 0x4abe, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x4abf, 0x4ac0, 0x4ac1, 0x0000, 0x0000,
0x0000, 0xe0a3, 0x0000, 0x0000, 0xe0a4, 0x0000, 0x0000, 0x4ac2,
0x0000, 0x0000, 0x0000, 0x4ac3, 0x0000, 0x0000, 0x4ac4, 0x0000,
0xe0a5, 0x0000, 0x0000, 0x4ac6, 0x0000, 0x0000, 0x0000, 0x0000,
0x4ac7, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ac8, 0xe0a7, 0x0000,
0x4ac9, 0xe0aa, 0x0000, 0x4aca, 0xccec, 0xe0ac, 0xbca4, 0xe0ae,
0x4acd, 0x4ace, 0x4acf, 0x0000, 0x4ad0, 0xe0af, 0x0000, 0x0000,
0xe0b0, 0x4ad1, 0x4ad2, 0x4ad3, 0x0000, 0x4ad4, 0x0000, 0x4ad5,
0x0000, 0xe0b1, 0x4ad7, 0x4ad8, 0x4ad9, 0x4ada, 0x4adb, 0x0000,
0x0000, 0x4adc, 0x0000, 0x4add, 0x0000, 0x0000, 0x0000, 0x4ae0,
0x0000, 0xe0b2, 0x0000, 0x4ae1, 0x4ae2, 0x4ae3, 0x4ae4, 0xb8a3,
0xe0b4, 0x0000, 0x0000, 0x0000, 0xe0b6, 0x0000, 0x4ae7, 0x0000,
0x4ae9, 0x0000, 0x0000, 0x4aea, 0x0000, 0x0000, 0xe0b8, 0x0000,
0x0000, 0x0000, 0x0000, 0x4aeb, 0x0000, 0x0000, 0x0000, 0xb5be,
0x0000, 0xe0b9, 0x0000, 0x0000, 0x0000, 0x0000, 0xe0ba, 0x4aec,
0x0000, 0x0000, 0x0000, 0x4aee, 0x4aef, 0xe0bc, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x4af1, 0x0000, 0x0000, 0x0000,
0xe0be, 0x4af3, 0x4af4, 0x0000, 0x0000, 0x4af5, 0x0000, 0x0000,
0x0000, 0x0000, 0x4af6, 0x4af7, 0x4af8, 0x0000, 0xb9fd,
	/* 0xa140 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xa1a1, 0xa1a2, 0xa1a3, 0x0000, 0x0000, 0x22b0, 0xa1af,
0xa1b7, 0xa1b9, 0xa1bd, 0x22b7, 0xa1c2, 0xa1c4, 0xa1c6, 0xa1c7,
0xa1c8, 0xa1c9, 0xa1cc, 0xa1cd, 0xa1d2, 0xa1d3, 0xa1d4, 0xa1d5,
0xa1d6, 0xa1d7, 0xa1d8, 0xa1d9, 0x0000, 0x0000, 0xa1da, 0xa1db,
0xa1de, 0xa1df, 0xa1e0, 0x0000, 0xa2ca, 0xa2cb, 0x0000, 0x0000,
0xa2c0, 0xa2c1, 0xa2ba, 0x0000, 0xa2e5, 0xa2dd, 0x0000, 0xa2dc,
0xa2de, 0x0000, 0xa2e9, 0x0000, 0xa2e1, 0x0000, 0x0000, 0xa2e6,
0xa2e7, 0xa1e2, 0x0000, 0x0000, 0x0000, 0x0000, 0xa1e7, 0xa2e8,
0xa1e8, 0xa1e9, 0xa1ea, 0xa1eb, 0xa1ec, 0xa1ed, 0xa1ee, 0xa1f0,
0x22f0, 0x0000, 0x0000, 0xa2f3, 0xa1f8, 0x22f1, 0xa1f9, 0xa1fa,
0xa1fb, 0xa1fc, 0xa1fd, 0xa1fe, 0xa2a1, 0xa2a2, 0xa2a3, 0xa2a4,
0xa2a5, 0xa2a8, 0xa2aa, 0xa2ab, 0xa2ac, 0xa2ad, 0xa2ae,
	/* 0xa240 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xa340 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xa1aa, 0x0000, 0xa1f4, 0xa1ef, 0xa1f3, 0xa1f5, 0x0000,
0xa1ca, 0xa1cb, 0xa1f6, 0xa1dc, 0xa1a4, 0x0000, 0xa1a5, 0xa1bf,
0xa3b0, 0xa3b1, 0xa3b2, 0xa3b3, 0xa3b4, 0xa3b5, 0xa3b6, 0xa3b7,
0xa3b8, 0xa3b9, 0xa1a7, 0xa1a8, 0xa1e3, 0xa1e1, 0xa1e4, 0xa1a9,
0xa1f7, 0xa3c1, 0xa3c2, 0xa3c3, 0xa3c4, 0xa3c5, 0xa3c6, 0xa3c7,
0xa3c8, 0xa3c9, 0xa3ca, 0xa3cb, 0xa3cc, 0xa3cd, 0xa3ce, 0xa3cf,
0xa3d0, 0xa3d1, 0xa3d2, 0xa3d3, 0xa3d4, 0xa3d5, 0xa3d6, 0xa3d7,
0xa3d8, 0xa3d9, 0xa3da, 0xa1ce, 0xa1c0, 0xa1cf, 0xa1b0, 0xa1b2,
0xa1ae, 0xa3e1, 0xa3e2, 0xa3e3, 0xa3e4, 0xa3e5, 0xa3e6, 0xa3e7,
0xa3e8, 0xa3e9, 0xa3ea, 0xa3eb, 0xa3ec, 0xa3ed, 0xa3ee, 0xa3ef,
0xa3f0, 0xa3f1, 0xa3f2, 0xa3f3, 0xa3f4, 0xa3f5, 0xa3f6, 0xa3f7,
0xa3f8, 0xa3f9, 0xa3fa, 0xa1d0, 0xa1c3, 0xa1d1, 0xa1b1,
	/* 0xa440 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xa4a1, 0xa4a2, 0xa4a3, 0xa4a4, 0xa4a5, 0xa4a6, 0xa4a7,
0xa4a8, 0xa4a9, 0xa4aa, 0xa4ab, 0xa4ac, 0xa4ad, 0xa4ae, 0xa4af,
0xa4b0, 0xa4b1, 0xa4b2, 0xa4b3, 0xa4b4, 0xa4b5, 0xa4b6, 0xa4b7,
0xa4b8, 0xa4b9, 0xa4ba, 0xa4bb, 0xa4bc, 0xa4bd, 0xa4be, 0xa4bf,
0xa4c0, 0xa4c1, 0xa4c2, 0xa4c3, 0xa4c4, 0xa4c5, 0xa4c6, 0xa4c7,
0xa4c8, 0xa4c9, 0xa4ca, 0xa4cb, 0xa4cc, 0xa4cd, 0xa4ce, 0xa4cf,
0xa4d0, 0xa4d1, 0xa4d2, 0xa4d3, 0xa4d4, 0xa4d5, 0xa4d6, 0xa4d7,
0xa4d8, 0xa4d9, 0xa4da, 0xa4db, 0xa4dc, 0xa4dd, 0xa4de, 0xa4df,
0xa4e0, 0xa4e1, 0xa4e2, 0xa4e3, 0xa4e4, 0xa4e5, 0xa4e6, 0xa4e7,
0xa4e8, 0xa4e9, 0xa4ea, 0xa4eb, 0xa4ec, 0xa4ed, 0xa4ee, 0xa4ef,
0xa4f0, 0xa4f1, 0xa4f2, 0xa4f3, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xa540 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xa5a1, 0xa5a2, 0xa5a3, 0xa5a4, 0xa5a5, 0xa5a6, 0xa5a7,
0xa5a8, 0xa5a9, 0xa5aa, 0xa5ab, 0xa5ac, 0xa5ad, 0xa5ae, 0xa5af,
0xa5b0, 0xa5b1, 0xa5b2, 0xa5b3, 0xa5b4, 0xa5b5, 0xa5b6, 0xa5b7,
0xa5b8, 0xa5b9, 0xa5ba, 0xa5bb, 0xa5bc, 0xa5bd, 0xa5be, 0xa5bf,
0xa5c0, 0xa5c1, 0xa5c2, 0xa5c3, 0xa5c4, 0xa5c5, 0xa5c6, 0xa5c7,
0xa5c8, 0xa5c9, 0xa5ca, 0xa5cb, 0xa5cc, 0xa5cd, 0xa5ce, 0xa5cf,
0xa5d0, 0xa5d1, 0xa5d2, 0xa5d3, 0xa5d4, 0xa5d5, 0xa5d6, 0xa5d7,
0xa5d8, 0xa5d9, 0xa5da, 0xa5db, 0xa5dc, 0xa5dd, 0xa5de, 0xa5df,
0xa5e0, 0xa5e1, 0xa5e2, 0xa5e3, 0xa5e4, 0xa5e5, 0xa5e6, 0xa5e7,
0xa5e8, 0xa5e9, 0xa5ea, 0xa5eb, 0xa5ec, 0xa5ed, 0xa5ee, 0xa5ef,
0xa5f0, 0xa5f1, 0xa5f2, 0xa5f3, 0xa5f4, 0xa5f5, 0xa5f6, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xa640 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xa6a1, 0xa6a2, 0xa6a3, 0xa6a4, 0xa6a5, 0xa6a6, 0xa6a7,
0xa6a8, 0xa6a9, 0xa6aa, 0xa6ab, 0xa6ac, 0xa6ad, 0xa6ae, 0xa6af,
0xa6b0, 0xa6b1, 0xa6b2, 0xa6b3, 0xa6b4, 0xa6b5, 0xa6b6, 0xa6b7,
0xa6b8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xa6c1, 0xa6c2, 0xa6c3, 0xa6c4, 0xa6c5, 0xa6c6, 0xa6c7,
0xa6c8, 0xa6c9, 0xa6ca, 0xa6cb, 0xa6cc, 0xa6cd, 0xa6ce, 0xa6cf,
0xa6d0, 0xa6d1, 0xa6d2, 0xa6d3, 0xa6d4, 0xa6d5, 0xa6d6, 0xa6d7,
0xa6d8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xa740 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xa7a1, 0xa7a2, 0xa7a3, 0xa7a4, 0xa7a5, 0xa7a6, 0xa7a7,
0xa7a8, 0xa7a9, 0xa7aa, 0xa7ab, 0xa7ac, 0xa7ad, 0xa7ae, 0xa7af,
0xa7b0, 0xa7b1, 0xa7b2, 0xa7b3, 0xa7b4, 0xa7b5, 0xa7b6, 0xa7b7,
0xa7b8, 0xa7b9, 0xa7ba, 0xa7bb, 0xa7bc, 0xa7bd, 0xa7be, 0xa7bf,
0xa7c0, 0xa7c1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xa7d1, 0xa7d2, 0xa7d3, 0xa7d4, 0xa7d5, 0xa7d6, 0xa7d7,
0xa7d8, 0xa7d9, 0xa7da, 0xa7db, 0xa7dc, 0xa7dd, 0xa7de, 0xa7df,
0xa7e0, 0xa7e1, 0xa7e2, 0xa7e3, 0xa7e4, 0xa7e5, 0xa7e6, 0xa7e7,
0xa7e8, 0xa7e9, 0xa7ea, 0xa7eb, 0xa7ec, 0xa7ed, 0xa7ee, 0xa7ef,
0xa7f0, 0xa7f1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xa840 */
0x0000, 0x0000, 0x22b2, 0x0000, 0x0000, 0xa1c5, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xa2e2, 0xa1e5, 0xa1e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xa2a7, 0xa2a6, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xa2a9, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x2ba7, 0x2ba1, 0x2ba6, 0x2ba2, 0x2bb7, 0x2bb1, 0x2bb5,
0x2bb2, 0x2bc5, 0x2bbf, 0x2bc3, 0x2bc0, 0x2bd7, 0x2bd1, 0x2bd5,
0x2bd2, 0x2be9, 0x2be2, 0x2be7, 0x2be3, 0x2bf0, 0x2bed, 0x2bef,
0x2bee, 0x2be4, 0x2bb4, 0x0000, 0x0000, 0x2bcd, 0x2bce, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xa940 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xa1be, 0x0000, 0x0000, 0x0000,
0xa1bc, 0xa1ab, 0xa1ac, 0xa1b3, 0xa1b4, 0xa1ba, 0xa1b5, 0xa1b6,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa1bb, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xa8a1, 0xa8ac, 0xa8a2, 0xa8ad,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xa8a3, 0x0000, 0x0000, 0xa8ae, 0xa8a4, 0x0000, 0x0000, 0xa8af,
0xa8a6, 0x0000, 0x0000, 0xa8b1, 0xa8a5, 0x0000, 0x0000, 0xa8b0,
0xa8a7, 0xa8bc, 0x0000, 0x0000, 0xa8b7, 0x0000, 0x0000, 0xa8b2,
0xa8a9, 0xa8be, 0x0000, 0x0000, 0xa8b9, 0x0000, 0x0000, 0xa8b4,
0xa8a8, 0x0000, 0x0000, 0xa8b8, 0xa8bd, 0x0000, 0x0000, 0xa8b3,
0xa8aa, 0x0000, 0x0000, 0xa8ba, 0xa8bf, 0x0000, 0x0000, 0xa8b5,
0xa8ab, 0x0000, 0x0000, 0xa8bb, 0x0000, 0x0000, 0xa8c0, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa8b6,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xaa40 */
0x0000, 0x0000, 0x4af9, 0xe0c2, 0x0000, 0x0000, 0x4afa, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe0c5, 0xc7e2, 0x4ba1,
0x0000, 0x0000, 0x4ba2, 0x4ba3, 0x4ba4, 0x0000, 0x4ba5, 0x0000,
0x0000, 0x4ba6, 0x0000, 0x4ba7, 0x0000, 0x0000, 0x0000, 0x4ba8,
0x0000, 0x4baa, 0x4bab, 0x0000, 0xcec4, 0x0000, 0x0000, 0x4bae,
0x0000, 0x4baf, 0x4bb0, 0x0000, 0xe0ce, 0x0000, 0x4bb3, 0x0000,
0x4bb4, 0xcdb1, 0x4bb5, 0x4bb6, 0x0000, 0x4bb7, 0x0000, 0x0000,
0x0000, 0x4bb8, 0xb9f6, 0xbbe2, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xe0d2, 0xe0d3, 0x0000, 0x0000,
0x0000, 0x0000, 0x4bbc, 0x4bbd, 0x0000, 0x0000, 0x0000, 0x0000,
0x4bbe, 0x4bbf, 0x4bc0, 0x0000, 0x0000, 0xbdc3, 0x0000, 0x0000,
0x4bc2, 0x4bc3, 0xe0d7, 0x4bc4, 0xe0d6, 0x4bc5, 0x4bc7, 0xe0d8,
0x4bc9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xab40 */
0xb3cd, 0x0000, 0x0000, 0xe0da, 0x0000, 0x4bca, 0xe0d9, 0x4bcb,
0xe0dc, 0xe0db, 0x4bcc, 0x0000, 0x0000, 0x4bcd, 0x4bce, 0x0000,
0x4bcf, 0x4bd0, 0x4bd1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x4bd3, 0x0000, 0x4bd4, 0x0000, 0x4bd5, 0x4bd6, 0x4bd7, 0x0000,
0x0000, 0x4bd8, 0x0000, 0x4bd9, 0x4bdb, 0x0000, 0x0000, 0x0000,
0x4bdd, 0x4bde, 0x0000, 0x0000, 0x4bdf, 0x0000, 0x4be1, 0x0000,
0x0000, 0x4be2, 0x0000, 0x0000, 0x4be4, 0x4be5, 0x4be6, 0x0000,
0x4be7, 0x0000, 0x0000, 0x0000, 0x4be8, 0x4be9, 0x0000, 0x0000,
0x4beb, 0x4bec, 0xe0df, 0x4bee, 0x4bef, 0x0000, 0x0000, 0x4bf0,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4bf2, 0x0000, 0x4bf3,
0x0000, 0x4bf4, 0x0000, 0x4bf5, 0x0000, 0xb7be, 0x0000, 0x0000,
0xe0e3, 0x0000, 0x0000, 0xe0fe, 0x0000, 0x4bf8, 0x4bf9, 0x0000,
0x4bfa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xac40 */
0xe0e9, 0x4bfb, 0x4bfc, 0x4bfd, 0x0000, 0x4bfe, 0xb8bd, 0x4ca1,
0x4ca2, 0x4ca3, 0x0000, 0x4ca4, 0x4ca5, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x4ca7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x4caa, 0x0000, 0x4cad, 0x4caf, 0x4cb1, 0x4cb3,
0x4cb5, 0xe0ea, 0x0000, 0x0000, 0x4cb6, 0xe0eb, 0x0000, 0x0000,
0x0000, 0xe0ed, 0x4cb7, 0x0000, 0x4cb8, 0x4cb9, 0x0000, 0x4cba,
0x4cbb, 0x0000, 0x0000, 0x0000, 0x4cbc, 0x0000, 0x4cbd, 0x0000,
0x0000, 0x0000, 0x0000, 0x4cbe, 0x4cbf, 0x0000, 0x0000, 0x0000,
0x0000, 0x4cc1, 0xcedc, 0x0000, 0x4cc2, 0xe0f4, 0xf4a4, 0x0000,
0x4cc3, 0x4cc4, 0x4cc5, 0xe0f2, 0xe0f5, 0x4cc6, 0x0000, 0x4cc8,
0xe0e7, 0x4cc9, 0x4cca, 0xbabc, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xad40 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ccd, 0x4cce,
0x0000, 0x4cd0, 0x0000, 0x0000, 0x0000, 0x4cd1, 0x4cd3, 0x4cd4,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4cd5, 0x4cd6, 0x4cd7,
0x0000, 0x0000, 0x4cd9, 0x4cda, 0x4cdb, 0xe0e5, 0x4cdc, 0x0000,
0x0000, 0x4cdd, 0x4ce0, 0x4ce1, 0x0000, 0x0000, 0x4ce2, 0x4ce3,
0xb4c4, 0x4ce4, 0x4ce5, 0x0000, 0x0000, 0x4ce6, 0x0000, 0x0000,
0x0000, 0x4ce7, 0x4ce8, 0x0000, 0xbca5, 0x0000, 0x4ce9, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x4cea, 0x4ceb, 0xe0fb, 0x0000, 0x4cec, 0x0000, 0x0000, 0xe0fc,
0x4ced, 0x0000, 0x4cee, 0xe0fd, 0x0000, 0x0000, 0x0000, 0x4cef,
0x0000, 0x4cf0, 0x4cf1, 0x0000, 0x4cf3, 0x0000, 0x0000, 0xe1a3,
0x4cf5, 0xe1a4, 0x4cf6, 0x4cf7, 0x0000, 0x0000, 0xe1a7, 0xe1a8,
0xe1a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xae40 */
0x0000, 0x0000, 0xe1a9, 0x0000, 0x4cfa, 0x4cfb, 0x4cfc, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xe1ac, 0xe1ad, 0x4cfe, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xe1ae, 0xe1af, 0x0000, 0x4da1,
0x0000, 0xe1b1, 0x4da2, 0x4da3, 0x0000, 0x0000, 0xe1b3, 0x4da4,
0x4da5, 0x0000, 0xbbba, 0x4da6, 0xe1b4, 0x4da7, 0x4da9, 0x0000,
0x0000, 0x4dab, 0x4dac, 0xe1b6, 0x4dad, 0x4daf, 0x0000, 0x0000,
0x4db1, 0xe1b7, 0xe1bc, 0x4db2, 0xe1ba, 0xe1b9, 0xe1b8, 0x4db5,
0xc8aa, 0x4db6, 0x0000, 0x0000, 0x0000, 0x4db7, 0x0000, 0x0000,
0xc0a6, 0x4db8, 0x4db9, 0xc8ab, 0x4dba, 0xc9ad, 0x0000, 0xe1bf,
0xe1c0, 0x0000, 0xe1be, 0xe1c1, 0x0000, 0xe1c2, 0x0000, 0x4dbb,
0xb0db, 0x4dbc, 0xbef6, 0x0000, 0xe1c4, 0xc6ed, 0x4dbe, 0x4dbf,
0x4dc0, 0x4dc1, 0x4dc2, 0x0000, 0x4dc3, 0xe1ca, 0x0000, 0x4dc4,
0xe1c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xaf40 */
0x0000, 0xe1c9, 0xe1c8, 0x0000, 0x0000, 0xc1c2, 0x4dc5, 0x4dc7,
0x4dc8, 0x0000, 0x0000, 0x4dca, 0x0000, 0x4dcb, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4dce, 0x0000,
0x4dcf, 0x4dd0, 0x4dd1, 0x4dd3, 0x0000, 0x4dd4, 0x4dd5, 0x4dd6,
0x0000, 0x0000, 0x0000, 0x4dd7, 0xe1db, 0x0000, 0x4dd8, 0x0000,
0x4dd9, 0x4dda, 0x4ddb, 0x0000, 0xc1e9, 0x4dde, 0x0000, 0x4ddf,
0x4de0, 0xe1e4, 0xe1e5, 0x0000, 0x0000, 0x0000, 0x0000, 0xe1e3,
0x0000, 0x0000, 0xe1de, 0x4de4, 0x4de6, 0x0000, 0x4de7, 0x0000,
0x4de8, 0xe1e8, 0xe1e6, 0xe1e7, 0x0000, 0x4deb, 0x0000, 0x4dec,
0x4ded, 0x0000, 0x4def, 0x0000, 0x4df2, 0x4df3, 0x4df4, 0xe1ec,
0x4df5, 0xe1ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4dfa,
0x0000, 0x0000, 0x4dfe, 0x4ea1, 0xe1f1, 0x0000, 0x4ea5, 0xcec5,
0x4ea7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xb040 */
0x4ea8, 0xe1f4, 0xe1f2, 0xe1f3, 0x4ea9, 0x4ea3, 0x4eaa, 0x0000,
0x0000, 0x0000, 0x0000, 0xccfe, 0x0000, 0x4eab, 0x0000, 0xe1f6,
0x4eac, 0x0000, 0x0000, 0x0000, 0x4ead, 0x0000, 0xe1f7, 0xe1f8,
0x4eae, 0x4eaf, 0x0000, 0xe1fc, 0xe1f9, 0xe1fa, 0xe1fb, 0xe1fd,
0x4eb0, 0x4eb1, 0xe1fe, 0x4eb3, 0xe2a1, 0x0000, 0x4eb4, 0x0000,
0xe2a2, 0x0000, 0x0000, 0xc8af, 0xe2a4, 0x0000, 0xe2a5, 0x4eb5,
0xe2a6, 0x4eb6, 0x0000, 0x0000, 0x4eb7, 0x4eb8, 0x0000, 0xbba9,
0x0000, 0x0000, 0x4eb9, 0x0000, 0x0000, 0xe2ad, 0x4eba, 0x0000,
0x4ebb, 0x4ebc, 0x0000, 0x4ebd, 0x4ebe, 0x0000, 0x4ebf, 0x4ec0,
0x4ec2, 0x4ec3, 0x4ec4, 0x4ec5, 0x0000, 0x4ec6, 0x0000, 0x0000,
0x4ec7, 0x0000, 0xe2ae, 0x0000, 0x0000, 0x0000, 0xf3e9, 0xe2b0,
0xe2b1, 0xe2b2, 0x0000, 0x0000, 0x4ec8, 0x0000, 0x0000, 0x4ec9,
0xc7d6, 0x35d9, 0xb0a4, 0xd4bc, 0xb0a7, 0x35bc, 0x35c9, 0xb0a5,
0x0000, 0xb4e2, 0x0000, 0xe2e4, 0xe7e8, 0xb3b7, 0x0000, 0xf0a7,
0xb0c8, 0x46cf, 0xb0c2, 0xb2b6, 0xb0c4, 0xb0c5, 0xb4df, 0x56a6,
0xb0c6, 0x0000, 0xb9b7, 0x4ece, 0xb1fa, 0xdac4, 0xdff2, 0x0000,
0x0000, 0xd0fe, 0xb1fc, 0xd8e5, 0xdfb4, 0xc7ce, 0xbbab, 0x3fba,
0xd2dc, 0x34e8, 0xe3f6, 0xc8ac, 0x4dcc, 0xc7c3, 0xd9b6, 0xeced,
0x67bc, 0xc7c4, 0xe6d2, 0x0000, 0xdbb1, 0x0000, 0x4acb, 0xc7f2,
0xc7f0, 0xc9b4, 0x0000, 0xd0d1, 0x0000, 0xd9c1, 0xc9a3, 0xc8c3,
0xc8c9, 0xc8c2, 0x3fc2, 0xc8cc, 0x0000, 0xc8c4, 0xc8c7, 0xcab1,
0xd9c2, 0xc8bc, 0xe1a2, 0xc8be, 0x0000, 0x0000, 0xcbae, 0x3cad,
0x43ed, 0xdcd6, 0xe7af, 0x0000, 0xcbc0, 0xe2fc, 0xe9d3, 0x0000,
0xcbb5, 0x0000, 0xe7fa, 0xcba6, 0xcaf1, 0xcbab, 0xc7ed,
	/* 0xb140 */
0x0000, 0x0000, 0x4ecb, 0x4ecc, 0x4ecd, 0x0000, 0x0000, 0x4ed0,
0x0000, 0xddb9, 0x0000, 0xe2b7, 0x4ed1, 0xe2b8, 0x0000, 0xb4c6,
0xc8d7, 0x4ed2, 0xe2ba, 0x4ed3, 0x0000, 0xe2bb, 0x0000, 0x4ed4,
0x0000, 0x4ed5, 0x0000, 0x0000, 0x4ed7, 0x0000, 0x0000, 0xe2bd,
0x0000, 0x0000, 0x4eda, 0x0000, 0x0000, 0x0000, 0x4edb, 0x4edc,
0xb8a9, 0x4edd, 0x0000, 0x0000, 0x0000, 0x4ede, 0x0000, 0x4edf,
0x4ee0, 0x0000, 0x4ee1, 0x0000, 0xe2c6, 0x4ee4, 0x0000, 0xe2c3,
0x0000, 0x0000, 0xe2c2, 0xe2c4, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x4ee8, 0x0000, 0x0000, 0x0000, 0x0000, 0x4eea, 0x4eed,
0x0000, 0x4eee, 0x4eef, 0x0000, 0x4ef0, 0x0000, 0x4ef1, 0x4ef2,
0x0000, 0x0000, 0x4ef3, 0x0000, 0x0000, 0x4ef4, 0x4ef5, 0x4ef6,
0x4ef7, 0x0000, 0x0000, 0x0000, 0x4ef8, 0x4ef9, 0x0000, 0x0000,
0x4efa, 0xc7f6, 0xf0bb, 0xcadd, 0xd4c8, 0x0000, 0xcaf5, 0xcafa,
0x0000, 0xcbbd, 0xc9bf, 0x0000, 0xc7fa, 0xc7d5, 0xc8ea, 0xc8e1,
0xc8dc, 0xcbcc, 0x0000, 0xc7d8, 0x0000, 0x0000, 0xc7dc, 0x0000,
0x0000, 0x0000, 0xdfe4, 0xc8ef, 0xcbdb, 0x57d8, 0xcbdc, 0xe3fc,
0xcaf8, 0x0000, 0x0000, 0x0000, 0x0000, 0xedfe, 0xc9af, 0xc9a1,
0xc8e6, 0xeec1, 0x51f4, 0xc8e0, 0xcacb, 0xe8ef, 0xcac3, 0x0000,
0x0000, 0x46b8, 0x0000, 0xc8df, 0x4de2, 0x0000, 0xdac9, 0xcac0,
0xc9ac, 0xede4, 0xcac9, 0xe7be, 0xc8f2, 0xcac5, 0xcadc, 0x0000,
0x0000, 0x0000, 0xd9a8, 0xcad8, 0x0000, 0xd2c6, 0xd1fe, 0x0000,
0x0000, 0xcad7, 0x0000, 0xc9b7, 0x56cd, 0xc9bd, 0x0000, 0x3edf,
0x0000, 0x0000, 0xc9cb, 0xc9cc, 0x0000, 0x0000, 0x0000, 0x0000,
0xcabc, 0xd1d6, 0xcac1, 0xcaba, 0xe3bd, 0x0000, 0xdfdb,
	/* 0xb240 */
0x0000, 0x4efb, 0x4efc, 0x4efd, 0x4fa1, 0x4fa2, 0x0000, 0x4fa3,
0x0000, 0x0000, 0x0000, 0x4fa5, 0x0000, 0x4fa6, 0x4fa7, 0x4fa8,
0x0000, 0x0000, 0x0000, 0x0000, 0x4fa9, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe2d3,
0x0000, 0x0000, 0x0000, 0x4faf, 0x4fb0, 0x4fb1, 0x0000, 0x0000,
0x0000, 0x4fb2, 0x0000, 0x0000, 0x0000, 0xe2d6, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xcec6, 0x4fb7, 0x4fb8, 0x4fb9,
0x0000, 0x0000, 0xe2d8, 0x0000, 0x0000, 0xe2d9, 0x0000, 0x0000,
0xe2db, 0x4fbb, 0x0000, 0x0000, 0x0000, 0x4fbc, 0x0000, 0x0000,
0x0000, 0xe2de, 0x0000, 0x4fbd, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x4fbe, 0x4fbf, 0x0000, 0x0000, 0x4fc0, 0x0000,
0x0000, 0x4fc1, 0xe2e1, 0x0000, 0x4fc2, 0x4fc3, 0x4fc4, 0x0000,
0x4fc5, 0xc9c2, 0xd6f5, 0xe0e0, 0xe8ca, 0xc7c5, 0x0000, 0x0000,
0xc7c8, 0xc7ee, 0xcbd6, 0xd9f3, 0x0000, 0xc7f3, 0xc7ec, 0xd6e7,
0xc7f5, 0x56aa, 0xe7ae, 0xdedf, 0xc7f1, 0x0000, 0xcae1, 0xcbce,
0xd3ae, 0x0000, 0xc9d6, 0xc9d4, 0xc9db, 0x0000, 0xcaed, 0xc9f4,
0xc9dd, 0xbba4, 0xe0ca, 0xbadb, 0xbae0, 0xbacd, 0x0000, 0x4fa4,
0x0000, 0xbad3, 0xbacc, 0xbada, 0xe8f1, 0xbbc1, 0xbbb2, 0xbbbd,
0xbbc4, 0x0000, 0xbbb4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xe9b6, 0xc1e0, 0x53c4, 0xc1e5, 0xc1e2, 0xc1f0, 0x0000, 0xbaf6,
0x0000, 0xd1c6, 0x0000, 0x0000, 0x60ba, 0xd9e7, 0xbab5, 0x57ea,
0xc3e3, 0x0000, 0x0000, 0x40d7, 0xbba1, 0xd6ab, 0xbab9, 0x0000,
0xd9be, 0xbcc6, 0xecb9, 0x0000, 0x0000, 0xc0e6, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbebb, 0xe0cb,
	/* 0xb340 */
0x4fc6, 0x0000, 0x4fc7, 0xb6ba, 0x4fc9, 0x4fca, 0x0000, 0x4fcb,
0x0000, 0x0000, 0x0000, 0x0000, 0x4fcd, 0xe2e5, 0x0000, 0x0000,
0x4fce, 0x4fcf, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fd2, 0x0000,
0x0000, 0x0000, 0xbad5, 0x0000, 0x0000, 0x0000, 0xe2e9, 0x4fd5,
0x4fd6, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fd9, 0x0000, 0x0000,
0xcba4, 0x0000, 0x4fdb, 0x0000, 0x0000, 0xb9dc, 0x0000, 0x0000,
0x4fdd, 0x4fde, 0x0000, 0x4fe0, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x4fe4, 0x4fe5, 0x0000, 0x4fe6, 0x4fe7, 0x0000, 0x4fe8,
0x4fe9, 0x0000, 0x0000, 0x0000, 0x4fea, 0x0000, 0xb8a7, 0x0000,
0x0000, 0xc8a3, 0x0000, 0xe2ed, 0x0000, 0x0000, 0x0000, 0x0000,
0x4fed, 0x0000, 0x0000, 0x4fee, 0x0000, 0x0000, 0xb8eb, 0x0000,
0x0000, 0x0000, 0x0000, 0xbeef, 0x0000, 0x0000, 0x0000, 0xd2cc,
0xdac8, 0x0000, 0xbea7, 0xd0e9, 0xc4b6, 0xbeb6, 0x0000, 0xc4ab,
0xd3de, 0xc4ac, 0x0000, 0x34ee, 0xdfd6, 0x0000, 0x3fc1, 0xc5b1,
0xd9da, 0x0000, 0x48e5, 0x62b2, 0xbfc3, 0xc3a4, 0x0000, 0xdaef,
0xd7da, 0x46ec, 0x0000, 0xece3, 0x0000, 0x40f0, 0xbece, 0xbeeb,
0xdcf4, 0xc0ae, 0xc4e8, 0xd0ab, 0xc4f8, 0x0000, 0xc0a1, 0x0000,
0xbeb5, 0xedf7, 0x0000, 0xc7e9, 0xb5c9, 0xc3d4, 0xbbfd, 0xbafc,
0xc3d3, 0x0000, 0xc3d0, 0x0000, 0xe6d7, 0x0000, 0xd0cc, 0xbcdc,
0xc0d6, 0xe6c2, 0xc0cd, 0x0000, 0xbdbc, 0xd1d5, 0xc3ee, 0xbff2,
0x0000, 0xc3ea, 0xbdb7, 0xe1c7, 0x0000, 0xe3c7, 0xbda5, 0x0000,
0xb5d8, 0x0000, 0x0000, 0xb1af, 0xbdad, 0xbde9, 0xbdd0, 0x45b4,
0xbfdf, 0xedb0, 0x0000, 0x0000, 0x48b3, 0xbdfc, 0xc1bf,
	/* 0xb440 */
0x0000, 0x0000, 0xe2ee, 0x0000, 0x4fef, 0x0000, 0x4ff0, 0x0000,
0x0000, 0x4ff1, 0xbaec, 0x0000, 0x0000, 0x4ff4, 0x4ff5, 0x0000,
0x0000, 0x4ff7, 0x0000, 0x4ff8, 0xc0d9, 0xe2f4, 0x0000, 0x4ff9,
0x4ffa, 0x0000, 0xe2f5, 0xe2f3, 0x0000, 0x0000, 0x0000, 0xb3ce,
0x50a1, 0xe2fb, 0x50a2, 0x50a3, 0x0000, 0x0000, 0x0000, 0x0000,
0xe2f7, 0x50a4, 0x50a5, 0x50a7, 0x0000, 0x50a8, 0x0000, 0xe2f6,
0x50a9, 0x50aa, 0x50ac, 0x0000, 0x0000, 0xe3a2, 0x50ae, 0x0000,
0x0000, 0x0000, 0x50af, 0x50b0, 0x50b1, 0x0000, 0x0000, 0x0000,
0x50ad, 0x0000, 0x50b2, 0xe3a1, 0x0000, 0x50b3, 0x0000, 0x0000,
0x0000, 0xb0eb, 0x0000, 0x0000, 0x50b5, 0x0000, 0x50b7, 0x0000,
0x0000, 0x50ba, 0x0000, 0xe3a3, 0x0000, 0x50bb, 0x50b6, 0x0000,
0x0000, 0x0000, 0x50bc, 0xe3a5, 0x0000, 0x0000, 0x0000, 0x0000,
0x50bd, 0x0000, 0x0000, 0xe2e0, 0x40c9, 0xbfa8, 0x0000, 0xd9e5,
0xc0ee, 0xc0fc, 0xdcbd, 0x0000, 0xc1a5, 0xd3c3, 0xb6fa, 0x0000,
0xe3d9, 0xd6f1, 0xbeb2, 0x0000, 0x0000, 0xbfe1, 0xbfe6, 0xd9d9,
0x0000, 0xbfe2, 0xbdd5, 0xc4d8, 0xbde6, 0xbfb0, 0xbddf, 0x0000,
0xeac1, 0xd9a7, 0x0000, 0xe1d3, 0xb0f1, 0xbca7, 0xbbf3, 0xbcad,
0xbbfc, 0xe1aa, 0x0000, 0xbaa1, 0xbbc9, 0x0000, 0xbca1, 0x0000,
0xc7ac, 0x36fc, 0xd2b2, 0xd0ba, 0x0000, 0x33a3, 0xc1c6, 0xeecc,
0xe4c8, 0xc2a5, 0x0000, 0x0000, 0x0000, 0xd9f4, 0xd6c3, 0xbac5,
0xc0c8, 0xe1e1, 0xe4ef, 0xdec3, 0xbfe9, 0xc2bc, 0xc2b8, 0xc0a3,
0xe2f8, 0xbba3, 0xd9ed, 0xc1bc, 0xbac3, 0x0000, 0xc5eb, 0x61b6,
0xc5fa, 0x4df8, 0xc2c7, 0xc2e7, 0xcaf2, 0xddc6, 0x0000, 0xc2d7,
0x0000, 0xcbd8, 0xc2e5, 0x0000, 0xc2de, 0xc2d4, 0xc2e1,
	/* 0xb540 */
0x0000, 0xc1c3, 0x0000, 0x50be, 0xe3a7, 0xe3a6, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xe3a8, 0x50bf, 0x0000, 0x50c0, 0x0000,
0x50c2, 0x50c3, 0x0000, 0x0000, 0x0000, 0x50c4, 0xe2e8, 0x50c5,
0x0000, 0x50c6, 0xe2ea, 0xe3aa, 0xe3a9, 0x50c7, 0x0000, 0x0000,
0x0000, 0x50c8, 0x0000, 0x0000, 0x50ca, 0x0000, 0x0000, 0x0000,
0x0000, 0x50cc, 0x50cd, 0x0000, 0x0000, 0x50ce, 0x50cf, 0xb5c0,
0x50d1, 0x50d2, 0x0000, 0x0000, 0x0000, 0x50d3, 0xcdb4, 0x50d4,
0x0000, 0x50d5, 0xe3b0, 0x50d6, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x50da, 0x0000, 0x50db, 0x0000, 0x0000, 0x0000,
0x0000, 0x50dc, 0x0000, 0x0000, 0x0000, 0x0000, 0x50dd, 0x50de,
0x50df, 0x0000, 0x50e0, 0xe3b3, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x50e1, 0x50e2, 0xb2d2, 0xc4f7, 0x0000, 0x50e3,
0x0000, 0xc2d5, 0xc3bf, 0xc3b4, 0xc3b0, 0x0000, 0x0000, 0x0000,
0xc3c0, 0xc3b6, 0x46d1, 0xc3a2, 0x0000, 0xc3b8, 0x0000, 0x0000,
0xc3c1, 0xc5f6, 0x0000, 0xc5de, 0x0000, 0xdbe3, 0xc5e1, 0x0000,
0xeda5, 0xc5dd, 0x0000, 0xc5f8, 0x0000, 0xc5fe, 0xe3cb, 0xc5e9,
0xc6bb, 0xc5f0, 0x0000, 0xc6c0, 0xc5aa, 0x60b9, 0xc5f4, 0xc5d0,
0xc5f9, 0x4fb6, 0x33ad, 0x0000, 0xc4e9, 0xc4e3, 0xc5a9, 0xedec,
0x0000, 0xc5ab, 0xe0bf, 0x0000, 0x55bc, 0xc3e4, 0xc4f1, 0xc4ec,
0xc3cf, 0xe8dc, 0xc2e8, 0xc4eb, 0xc4ef, 0x0000, 0x0000, 0x0000,
0x40a5, 0x48b5, 0x4ff2, 0xc5c0, 0xc5b5, 0x67b6, 0x0000, 0x0000,
0xc4d1, 0xd2b4, 0xc5b9, 0x0000, 0xd4fb, 0xcde4, 0xc5c2, 0x0000,
0x0000, 0xf0ba, 0xc3fc, 0x33b0, 0xd9dc, 0xc4df, 0x0000, 0x0000,
0xeceb, 0x4acc, 0x4ff6, 0xc4b3, 0xc5b3, 0x0000, 0x34e0,
	/* 0xb640 */
0x50e4, 0x50e5, 0x50e6, 0x50e7, 0x0000, 0x50e8, 0x0000, 0x50e9,
0x50ea, 0xe3b5, 0x0000, 0x0000, 0x0000, 0x50eb, 0x0000, 0x0000,
0x0000, 0x0000, 0xb5fa, 0x50ec, 0x50ed, 0xe3b8, 0x50ee, 0x0000,
0x0000, 0xe3b9, 0x50ef, 0xc7a9, 0x50f0, 0x0000, 0x50f1, 0x0000,
0x0000, 0x0000, 0x50f2, 0x0000, 0xc6c5, 0x50f4, 0x50f5, 0x0000,
0x50f6, 0x50f7, 0x50f8, 0x0000, 0x0000, 0x50f9, 0x0000, 0x0000,
0x50fa, 0x50fb, 0x0000, 0x0000, 0x50fc, 0x0000, 0x0000, 0x50fd,
0x50fe, 0x51a1, 0xe3c1, 0x51a2, 0x51a3, 0x0000, 0x51a4, 0x0000,
0xe3c0, 0x0000, 0x51a7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x51a9, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x51ac, 0xe3c3, 0x51ad, 0x51ae, 0x51af, 0x0000, 0x0000,
0x51b0, 0x0000, 0x0000, 0x51b1, 0x0000, 0xe3c5, 0xe3c6, 0x51b2,
0xcec7, 0xc3fa, 0x0000, 0xd2da, 0x0000, 0x0000, 0xc5a4, 0x0000,
0xc4ea, 0x0000, 0x0000, 0x0000, 0xc5df, 0xc6a1, 0x3ef2, 0x0000,
0x0000, 0x31aa, 0xd7f8, 0x0000, 0xc6b6, 0xb3f5, 0xd9b5, 0xc5cd,
0x66d9, 0xc6a6, 0xbfe0, 0xc5f7, 0xc5d4, 0xc6c4, 0xc6c7, 0x0000,
0xc6c8, 0x0000, 0xc5c8, 0xe2d1, 0x0000, 0xc5ce, 0x0000, 0xe6ec,
0xc5d9, 0xc5cf, 0x39ab, 0xc3bc, 0xc3bb, 0x0000, 0xc3ca, 0xc3c7,
0x0000, 0xc2cf, 0x0000, 0x0000, 0x0000, 0x38cc, 0x34e9, 0xedad,
0xc6d8, 0x0000, 0x36f7, 0x0000, 0xbde2, 0xc6db, 0x40a7, 0x35b9,
0xc2bf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc2c9, 0x0000,
0xc2c6, 0xc2c4, 0xb2eb, 0xb2e5, 0x0000, 0xb2e4, 0x0000, 0x0000,
0xd5ae, 0x0000, 0xccf1, 0xd9af, 0xeea1, 0xeebf, 0x0000, 0xb2b8,
0xbca9, 0xd1b9, 0xbcaa, 0x0000, 0x0000, 0x47b9, 0xc6f3,
	/* 0xb740 */
0x0000, 0xe3c8, 0x51b4, 0x0000, 0x0000, 0x0000, 0x0000, 0x51b5,
0x0000, 0x0000, 0x0000, 0x51b6, 0x0000, 0x51b7, 0xbcef, 0x51b8,
0x51b9, 0xe3ca, 0xb0f0, 0x51ba, 0x51bb, 0x0000, 0x51bc, 0x51be,
0xe3cc, 0xb9f2, 0x0000, 0xcae6, 0xe3ce, 0x51bf, 0x51c0, 0x51c1,
0x51c2, 0xe3d0, 0x0000, 0x0000, 0x51c3, 0xc0d1, 0xb1cf, 0xb2ba,
0xb0ac, 0x0000, 0x0000, 0x0000, 0x51c4, 0x51c5, 0x0000, 0x51c6,
0x0000, 0x0000, 0x51c7, 0x51c8, 0x0000, 0x51c9, 0x51ca, 0xe3d1,
0xe3d2, 0xbef7, 0x0000, 0x51cb, 0x0000, 0x51cc, 0x0000, 0x0000,
0xe3d3, 0x51cd, 0xb3cf, 0x0000, 0x51ce, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x51cf, 0x0000, 0x0000, 0xe3d7, 0x51d1, 0x51d3,
0x51d4, 0x0000, 0x0000, 0x51d6, 0x51d7, 0x0000, 0x0000, 0x0000,
0x51d8, 0xc1eb, 0x51da, 0x0000, 0x0000, 0x0000, 0x51db, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xc8b5, 0xc8b2, 0xcbb3, 0x0000,
0xcba1, 0x0000, 0xc8cd, 0xc8c1, 0xc8d6, 0xcbdd, 0xdce8, 0x0000,
0x0000, 0xc8cb, 0xcbde, 0x0000, 0xc8bf, 0xcad6, 0xe7f7, 0x0000,
0xc8c8, 0x0000, 0xdea2, 0xcbb7, 0xcba7, 0xcafd, 0xcbc3, 0xcbbc,
0xcbc9, 0xcbb8, 0x30d1, 0x0000, 0x0000, 0xcafc, 0xe8cb, 0xc8f3,
0x35e2, 0x0000, 0xc8ee, 0xc8db, 0x0000, 0xcbca, 0xc7d9, 0x0000,
0xcaa8, 0x0000, 0xe7ee, 0x62da, 0xd2e6, 0xdde4, 0xcaac, 0x0000,
0x0000, 0xcab2, 0xddf0, 0xcab4, 0x0000, 0x30cf, 0xd7dd, 0x0000,
0x0000, 0x30ad, 0xc9f5, 0x0000, 0xcbaa, 0xcaf6, 0x0000, 0x0000,
0x0000, 0xdfe2, 0xb0a9, 0x0000, 0x0000, 0x0000, 0xcaf4, 0x0000,
0xd0c7, 0xc8dd, 0xc9d7, 0xc9df, 0x0000, 0xd5db, 0xc9de, 0xd9c4,
0x0000, 0xc9fd, 0x46cc, 0xc9e4, 0xc9fa, 0xd0da, 0xc9fe,
	/* 0xb840 */
0x51dd, 0x0000, 0x0000, 0xe3dd, 0xb7a6, 0x0000, 0xb5e7, 0xcdd2,
0xe3df, 0x0000, 0x0000, 0x0000, 0x51e0, 0xe3e0, 0x0000, 0x0000,
0x51e1, 0xb1ae, 0x51e2, 0x51e3, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xb3f6, 0xe3e2, 0xe3e1, 0x51e4, 0xe3e5, 0xe3de, 0x51e5,
0xe3e6, 0x51e6, 0xe3e7, 0x51e7, 0xe3e8, 0x0000, 0x51e8, 0xd4f4,
0xe3ea, 0x0000, 0xe3e9, 0x0000, 0x0000, 0xe3ec, 0x51e9, 0xceb5,
0xe3ed, 0xe3ee, 0xe3ef, 0x0000, 0x0000, 0x51ea, 0x51eb, 0xc3a8,
0x51ec, 0x51ed, 0x0000, 0xe3f2, 0x51ee, 0x0000, 0x0000, 0x0000,
0x51ef, 0x0000, 0xb6a5, 0x0000, 0xd1bf, 0x51f0, 0x0000, 0x51f2,
0x0000, 0x0000, 0xe3f3, 0x0000, 0x51f3, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe3f8, 0x0000,
0x0000, 0x0000, 0x51f5, 0x0000, 0x0000, 0x51f6, 0x51f7, 0x51f8,
0x51fb, 0xc9e2, 0x47ce, 0xcaa1, 0xeae0, 0xcaa6, 0xcae3, 0x0000,
0x0000, 0xd0ed, 0xb3f8, 0xc9e0, 0xe6fd, 0xe7a5, 0xc9dc, 0xc9e5,
0xc9eb, 0xc9fb, 0xcaa4, 0x0000, 0x0000, 0xd0fc, 0xc9d5, 0xc9ec,
0xc9e3, 0xcaa2, 0x0000, 0xc9d9, 0x0000, 0xc9ed, 0x0000, 0x0000,
0xd2f5, 0x0000, 0x36ae, 0x0000, 0xb2fe, 0xb3b5, 0x0000, 0xe2b5,
0x0000, 0xb4b3, 0xb4c5, 0xdbb8, 0xb4bb, 0xb4c8, 0xb4ce, 0x0000,
0xb4b6, 0x0000, 0xb4ba, 0x0000, 0x0000, 0x0000, 0x0000, 0xe5fd,
0xe6ea, 0x0000, 0x0000, 0xb9c1, 0xdbba, 0x52cf, 0xe2a8, 0xb9e2,
0xb9d1, 0xe6b6, 0x53c2, 0x40cd, 0x0000, 0xb9c6, 0xb9f0, 0xd3a7,
0xb2ce, 0x0000, 0xd8f9, 0x0000, 0x56a3, 0x4dc9, 0xb3e4, 0xb3d7,
0xb3eb, 0xb3ca, 0xc8ba, 0x0000, 0xb3d6, 0x0000, 0xd0a4, 0xb3c6,
0x0000, 0xbaac, 0xecf0, 0xb9cc, 0xb9b9, 0xb9ae, 0xe6bd,
	/* 0xb940 */
0x51fd, 0x51fe, 0x0000, 0x52a2, 0xe3fb, 0xe3fd, 0x0000, 0xbafb,
0x0000, 0x52a3, 0x52a4, 0x52a5, 0x52a6, 0x0000, 0x0000, 0x0000,
0xc9ae, 0xc8a6, 0x0000, 0xe4a3, 0x52a8, 0x0000, 0x52a9, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x52ab, 0xe4a8,
0x52ac, 0xe4aa, 0x0000, 0x52ad, 0x52ae, 0x0000, 0xe4ad, 0x52af,
0x52b0, 0xe4ab, 0x52b2, 0xe4a9, 0x0000, 0x0000, 0xe4a1, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x52b4, 0xcacf, 0xb2d5,
0x0000, 0x52b5, 0x0000, 0xe4b5, 0x0000, 0x52b6, 0xe4b7, 0x0000,
0x52b8, 0xe4b6, 0x0000, 0x52b9, 0xe4b0, 0xe4b9, 0xe4b4, 0x52ba,
0x52bb, 0xe4b1, 0x52bc, 0x0000, 0x0000, 0x52bd, 0x0000, 0x52bf,
0x52c0, 0x52c1, 0x0000, 0x52c2, 0x52c3, 0x0000, 0x0000, 0x52c4,
0x52c5, 0x52c6, 0x52c7, 0x0000, 0x0000, 0xc0e1, 0x52c8, 0x0000,
0xc8cf, 0x0000, 0xe6d6, 0xb9bc, 0xb9a9, 0xb9b6, 0xb8f9, 0xb6b3,
0x0000, 0xb6a1, 0xedbb, 0xb8f8, 0x0000, 0xb5dd, 0x3ca1, 0xdde7,
0xd9ca, 0x0000, 0xb6a6, 0x0000, 0xb8fb, 0x46f2, 0xe7f1, 0xb6e9,
0xb9a4, 0x43a8, 0x0000, 0x0000, 0xede3, 0x58b7, 0x35a8, 0xe4b2,
0xd0c6, 0xddf8, 0xb8c9, 0xb8c8, 0xb8dd, 0xb8c5, 0x0000, 0xb9fc,
0xc3ab, 0xb8d4, 0xb8ce, 0x0000, 0xb8c7, 0xb8db, 0xd1e9, 0xb1bb,
0x0000, 0xb2c9, 0xd9cc, 0xeae8, 0xd0aa, 0xb2fd, 0xb2f8, 0xb4bd,
0x0000, 0xb4b1, 0xb4a7, 0x0000, 0xb4c9, 0x0000, 0xe6a5, 0x0000,
0xdef5, 0x0000, 0xb8f7, 0xd6f8, 0x61d0, 0xe0f3, 0x0000, 0xb7bd,
0xe2eb, 0x0000, 0x0000, 0x0000, 0x0000, 0xb5b4, 0x0000, 0xe2a3,
0xb7cb, 0x43c2, 0xecee, 0x0000, 0x0000, 0x0000, 0x0000, 0xdbfe,
0x0000, 0xb3d4, 0xb9f1, 0xb2cc, 0xeae7, 0x0000, 0xd2fd,
	/* 0xba40 */
0x52c9, 0x52ca, 0xc3db, 0x52cb, 0xe4ba, 0x0000, 0x0000, 0xe4bd,
0x0000, 0x0000, 0x52cc, 0x0000, 0x52cd, 0x52ce, 0x0000, 0x52d1,
0x0000, 0x0000, 0x0000, 0xbcc4, 0x0000, 0x0000, 0xc6c6, 0x0000,
0x52d2, 0xe4c1, 0x0000, 0x0000, 0xcfb6, 0x0000, 0x0000, 0x52d4,
0xe4ca, 0x52d5, 0x52d6, 0xe4ce, 0x52d7, 0x52d8, 0x52d9, 0x0000,
0x0000, 0x0000, 0xe4c7, 0x52dc, 0x52dd, 0x52de, 0x52df, 0x0000,
0x52e0, 0x0000, 0x52e1, 0x0000, 0xe4cd, 0x52e4, 0x0000, 0xe4c2,
0xd2d5, 0xe4c9, 0xe4c3, 0x0000, 0xe4cc, 0x0000, 0x52e6, 0x0000,
0x0000, 0x52e7, 0x0000, 0x0000, 0x0000, 0x52e8, 0xb4ca, 0x0000,
0xe4cf, 0x0000, 0x52e9, 0x52eb, 0x0000, 0xe4d4, 0x52ec, 0x0000,
0x0000, 0x0000, 0x0000, 0x52ed, 0x0000, 0x52ee, 0x52ef, 0x0000,
0x52f0, 0xe4d3, 0x52f1, 0x52f2, 0x0000, 0x0000, 0xe4d5, 0xcefc,
0x0000, 0xb3bc, 0xd5d8, 0xb3a4, 0x46cd, 0xb0e7, 0xb3b2, 0x0000,
0xeec7, 0x3eea, 0xeeb8, 0x0000, 0xb4de, 0xdebe, 0xb4a8, 0xc8a1,
0xd3bf, 0xe6a7, 0xb4cd, 0xd9fe, 0xd9d2, 0xdadd, 0xb4b8, 0xd7fb,
0x0000, 0xb4c0, 0x0000, 0x38ec, 0xb9ba, 0xb9d2, 0xb9e8, 0x0000,
0xb9eb, 0xdddd, 0x62aa, 0xb9a5, 0xccd7, 0xb9e6, 0xb9c0, 0xd2ea,
0xb3e5, 0xb2d9, 0x58b9, 0xb3cb, 0xb2d3, 0xcfc2, 0xb2bf, 0xb9e7,
0xe2b6, 0xecbb, 0x0000, 0xb2cf, 0xdec1, 0xb3d2, 0xb3ec, 0x0000,
0x0000, 0x36bd, 0x0000, 0xbaaf, 0xd7cc, 0xe0c3, 0xbaa8, 0x35c2,
0xb5fc, 0xb2a3, 0xb9d5, 0xb9b1, 0x0000, 0xd2fc, 0x49de, 0xc6fa,
0x0000, 0xb9bf, 0xb9a8, 0xb9b0, 0x0000, 0xb9a2, 0xb8f4, 0xe0cd,
0xd2e3, 0xb8fc, 0xb8f5, 0xb9a1, 0xb8c6, 0xb8c3, 0xb9fa, 0xb8ea,
0x0000, 0xe8d9, 0xb8d5, 0xe9fa, 0xb8d1, 0xb8d2, 0xb8d0,
	/* 0xbb40 */
0xe4d7, 0x0000, 0x0000, 0x52f3, 0x0000, 0x0000, 0x0000, 0x52f4,
0x0000, 0xe4d6, 0x0000, 0xe4d9, 0xe4db, 0x52f6, 0x52f7, 0x52f8,
0xe4d8, 0x52f5, 0xe4df, 0x0000, 0xe4dc, 0x52f9, 0x52fa, 0x52fb,
0x52fc, 0x52fd, 0x52fe, 0xe4dd, 0xe4c6, 0x53a1, 0x0000, 0x53a2,
0xe4de, 0xe4e0, 0x0000, 0x53a3, 0x0000, 0x53a4, 0x0000, 0x0000,
0xe4e1, 0x53a5, 0x53a6, 0x0000, 0x53a7, 0x0000, 0x53a8, 0xe4e2,
0x0000, 0x0000, 0x0000, 0x53a9, 0x0000, 0xcce2, 0x0000, 0x0000,
0xb6ce, 0xb7a9, 0xe4e3, 0x0000, 0x0000, 0x53ac, 0x53ad, 0x0000,
0x0000, 0x0000, 0xbfe8, 0x0000, 0xccb0, 0x0000, 0x53ae, 0xe4e4,
0x0000, 0x53af, 0x0000, 0x0000, 0x0000, 0xbdcd, 0x53b1, 0xe4e9,
0x0000, 0x53b2, 0xbed1, 0xe4ea, 0x0000, 0xe4e8, 0x0000, 0xe4e6,
0x0000, 0x53b3, 0x0000, 0x0000, 0x53b4, 0x53b5, 0x0000, 0x53b6,
0x53b7, 0xb8cc, 0xb8d7, 0x0000, 0x0000, 0xb8df, 0x0000, 0x0000,
0xb2d6, 0x0000, 0x0000, 0xe0d1, 0xb3ea, 0xb2e8, 0x33b3, 0xb2bd,
0x0000, 0xdcc7, 0xd7cb, 0x0000, 0xdece, 0xd4af, 0x0000, 0x0000,
0xb4bc, 0x0000, 0x0000, 0x0000, 0xb4b5, 0x0000, 0x0000, 0xecb6,
0x0000, 0x0000, 0xd5e1, 0xb8b8, 0xb9d3, 0xb9b2, 0xb2ab, 0x50b9,
0xe9fb, 0xe4d0, 0xb9c4, 0xd1e0, 0xd8b5, 0xdfea, 0xb9b8, 0xcbda,
0xd7f2, 0x0000, 0xb3a5, 0x0000, 0x0000, 0xb5ab, 0xb2fa, 0xe9dc,
0xb2f3, 0x0000, 0xb2f9, 0xb7c5, 0xd2c3, 0xd8aa, 0xb3a2, 0x0000,
0x0000, 0xb2f1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xbaaa, 0xbaa7, 0xbab2, 0x0000, 0xbaae, 0xecaf, 0xb3e8, 0x30dc,
0xb2d0, 0x0000, 0xb0bf, 0xcfc7, 0xf0b9, 0x0000, 0x0000, 0x0000,
0x37ba, 0xb4f0, 0xb4f9, 0xe1c3, 0xb7ce, 0x0000, 0xcca7,
	/* 0xbc40 */
0x53b9, 0xe4f1, 0xe4f3, 0x0000, 0x53ba, 0x0000, 0x53bd, 0x0000,
0xc1b8, 0x53bf, 0x0000, 0x0000, 0xe4f5, 0x53c0, 0x53c1, 0xe4f4,
0x53c5, 0x0000, 0x53c6, 0xcab5, 0x0000, 0xe4f7, 0x0000, 0x0000,
0x0000, 0x53c7, 0xcec8, 0x53c8, 0x0000, 0x53c9, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xe4fa, 0x0000, 0xe4fb, 0x53ca, 0xe4fc,
0x0000, 0x0000, 0xe4fd, 0x0000, 0x0000, 0xb5ea, 0x0000, 0xb5aa,
0x0000, 0xe5a1, 0x53cb, 0xccf3, 0xb9c8, 0xe4fe, 0x53cc, 0x53cd,
0x53ce, 0xcce6, 0x0000, 0xc7bc, 0x0000, 0x53cf, 0xc9b3, 0x0000,
0x53d0, 0x53d1, 0x53d2, 0xbde3, 0xe5a3, 0x53d3, 0xbcd3, 0xb9c9,
0xbbe6, 0xb5e9, 0xcab6, 0xe5a2, 0x53d4, 0x53d5, 0x0000, 0xcbc2,
0x53d6, 0x0000, 0x0000, 0x53d7, 0x0000, 0x0000, 0x53d8, 0xc4dd,
0x53d9, 0xe5a7, 0xbad9, 0x53da, 0xe5a8, 0xbfc2, 0x0000, 0xe5aa,
0x0000, 0xc8a9, 0x0000, 0xedf1, 0xb7e3, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xb5c8, 0x43a7, 0xdbf9, 0x0000, 0xc0d2, 0xbdb8,
0xb5da, 0xb5de, 0xbcc0, 0xb5e2, 0xc2a8, 0xbcbb, 0x0000, 0x0000,
0xd1dc, 0xc0d4, 0xb8ca, 0x0000, 0xb5bb, 0xd1c3, 0xb5a8, 0xb4ec,
0xbad7, 0x0000, 0xd8a9, 0x0000, 0xb4f3, 0xbce4, 0x0000, 0x0000,
0xb4fb, 0xb4f7, 0x0000, 0xb5b8, 0x0000, 0x0000, 0xb2c5, 0xdbc8,
0x0000, 0xb2c2, 0xb2c8, 0xb2c3, 0x0000, 0x0000, 0x0000, 0xb9c3,
0x0000, 0xd0f1, 0xb2d4, 0xd0c3, 0xb2cd, 0x0000, 0xb2c7, 0x0000,
0x0000, 0x0000, 0xc0ed, 0x0000, 0x0000, 0xc0f9, 0xb7f3, 0xb8aa,
0x0000, 0xd5a1, 0x0000, 0x0000, 0x0000, 0xdbcb, 0x4ffc, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xd1f2, 0x33a2, 0xe8a8, 0x0000,
0x0000, 0xc1a9, 0x0000, 0x0000, 0x0000, 0xc0fd, 0xb7ef,
	/* 0xbd40 */
0x0000, 0x0000, 0xbed2, 0xbab0, 0x0000, 0x53db, 0x53dc, 0x53dd,
0xe5a9, 0x53de, 0x53df, 0xbdaa, 0xb8be, 0xc1c8, 0xe5a5, 0xe5ab,
0x53e0, 0x53e1, 0x0000, 0x0000, 0xe5a6, 0xb7d0, 0x53e2, 0xe5ae,
0xe5b2, 0xb7eb, 0x53e3, 0x0000, 0x53e4, 0x0000, 0x0000, 0xe5ad,
0x53e5, 0x0000, 0x53e6, 0x53e7, 0xe5b6, 0x53e8, 0x53e9, 0xb9ca,
0x0000, 0x0000, 0xcded, 0xb0bc, 0xe5b3, 0x0000, 0x53ea, 0xb5eb,
0x53eb, 0xe5b0, 0x0000, 0x53ec, 0x0000, 0x0000, 0x0000, 0x0000,
0x53ed, 0xc5fd, 0xe5af, 0xe5ac, 0x0000, 0xb3a8, 0xc0e4, 0x0000,
0x53ee, 0xb8a8, 0x53ef, 0x53f0, 0x0000, 0xe5b8, 0x0000, 0x53f1,
0x0000, 0x53f2, 0x53f3, 0x53f4, 0x0000, 0x53f5, 0x53f6, 0x0000,
0x53f7, 0xe5b5, 0x0000, 0x53f8, 0x53f9, 0x53fa, 0x0000, 0xe5b7,
0x0000, 0x53fb, 0x0000, 0xe5b4, 0x0000, 0x0000, 0x53fc, 0x53fd,
0x0000, 0xb7f2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xb7fa, 0xd1ac, 0xd5aa, 0xbead, 0x0000, 0xb9be, 0xe1c5, 0xbed5,
0x0000, 0x0000, 0x0000, 0xbea2, 0x0000, 0xb9df, 0xbed6, 0xdca5,
0xbecc, 0xbec7, 0x56a4, 0xb8f2, 0xb9d9, 0x0000, 0x0000, 0x0000,
0xd3f0, 0x0000, 0x0000, 0x0000, 0x0000, 0xb5d3, 0xe0c4, 0xb3d1,
0x0000, 0x0000, 0x0000, 0xd1f6, 0xb6b5, 0xb9da, 0x0000, 0x0000,
0xb6ab, 0xe3dc, 0x0000, 0xc0dc, 0xb3a7, 0x51a8, 0xb3b9, 0x0000,
0xd9a3, 0xb9e5, 0x0000, 0xb5cb, 0xdbbf, 0xbeb9, 0xe2cc, 0xe3f1,
0x0000, 0x0000, 0xb2f2, 0xb0b9, 0xb2fc, 0xe9b4, 0xb3a9, 0xb3a6,
0xbcda, 0xb2f0, 0xe1ce, 0x0000, 0xc6cf, 0xb6d2, 0xb6da, 0xb6d4,
0xb6e2, 0xbaa3, 0xc4c5, 0xb6df, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x67bb, 0xbfb8, 0xb6d8, 0xb6e1, 0x0000, 0xbfbb,
	/* 0xbe40 */
0xb7d1, 0xc2b3, 0xe5b9, 0xc1ee, 0x53fe, 0x54a1, 0xe5c6, 0x0000,
0x0000, 0xe5c2, 0xe5bc, 0x0000, 0x0000, 0x54a3, 0x0000, 0x0000,
0x54a4, 0xe5c0, 0xbcfa, 0xb0dd, 0xe5c3, 0xe5c7, 0xb9cb, 0xccd6,
0x54a5, 0xc4d6, 0xe5bd, 0x54a6, 0x54a7, 0xe5c5, 0x54a8, 0xe5ba,
0xc3be, 0x0000, 0xe5bf, 0xb0bd, 0xccca, 0x0000, 0x0000, 0x54a9,
0x54aa, 0x54ab, 0x54ac, 0x54ad, 0xe5be, 0x0000, 0x0000, 0xb6db,
0xc8ec, 0x54ae, 0x54af, 0x54b0, 0xc1ed, 0x0000, 0xced0, 0xbdef,
0x0000, 0x0000, 0xe5ee, 0x0000, 0x54b1, 0xe5c8, 0x54b2, 0x0000,
0xc0fe, 0x0000, 0xe5c4, 0xe5c9, 0xe5cb, 0x0000, 0xc4f9, 0xe5ce,
0x54b4, 0x0000, 0xe5ca, 0x54b5, 0x54b6, 0x0000, 0xcad4, 0xb4cb,
0x54b7, 0x54b8, 0xcccb, 0x54b9, 0x0000, 0xb0de, 0x0000, 0x54ba,
0xe5cd, 0x0000, 0xcefd, 0x54bb, 0x54bc, 0x0000, 0x0000, 0x54bd,
0x54be, 0xbfd4, 0x0000, 0x0000, 0xd1be, 0xb7d4, 0xe2cd, 0xbebd,
0x0000, 0xb5fe, 0x3ea7, 0xc0ba, 0xe4eb, 0x0000, 0xb0e6, 0xb7d9,
0xb7ca, 0x0000, 0xc0c5, 0xb6ad, 0xb7c9, 0x0000, 0xb7c2, 0x0000,
0xccf7, 0xf0ef, 0x0000, 0x0000, 0xdfd7, 0xe3db, 0x40c0, 0xb5e6,
0x0000, 0xb6ea, 0xf0ec, 0xb5d7, 0xb5e4, 0xb6e5, 0xbcf2, 0xb1b9,
0xb5df, 0xb5ec, 0xb1b1, 0xe7cf, 0xd2eb, 0xbda2, 0xe1cc, 0xb5c7,
0xb9b4, 0xc1c0, 0xe1d4, 0xb5ef, 0x0000, 0xb5c6, 0xb6c9, 0xd2f2,
0xb6eb, 0x0000, 0xddfc, 0xe6dc, 0xb5f1, 0xbff8, 0xb5f0, 0xb6f1,
0xb5f7, 0xecf7, 0x0000, 0x0000, 0xb6e7, 0xd7fc, 0xdfd9, 0x0000,
0xd9d0, 0x0000, 0xd5af, 0xb7f1, 0xe2c7, 0xd2cb, 0x0000, 0x40ec,
0xdabc, 0xd9b1, 0xb7a1, 0xd0e3, 0xbcdf, 0x0000, 0xd1d3, 0x0000,
0x0000, 0xb6d1, 0xb6dd, 0x0000, 0x0000, 0xb7af, 0xbdd4,
	/* 0xbf40 */
0xe5cc, 0x0000, 0x0000, 0x0000, 0x0000, 0x54b3, 0xb1ef, 0x0000,
0x0000, 0xc6ec, 0xe5cf, 0x0000, 0x0000, 0x54bf, 0xe5d6, 0xe5d0,
0xe5d7, 0x0000, 0x0000, 0x0000, 0x0000, 0x54c0, 0x54c1, 0xe5d3,
0x0000, 0x0000, 0x54c2, 0x0000, 0x54c3, 0x0000, 0x0000, 0x0000,
0xc7fb, 0x54c4, 0x54c5, 0xbcca, 0xe5d5, 0x54c6, 0xe5d2, 0xe5d8,
0xe5d1, 0x0000, 0x0000, 0xbdc4, 0x54c7, 0x54c8, 0x0000, 0x0000,
0xcba5, 0x54c9, 0x54ca, 0xbdcc, 0x54cb, 0x0000, 0xe5d4, 0xe5e0,
0x54cc, 0x0000, 0xe5dc, 0x54cd, 0xe5df, 0x0000, 0xe5dd, 0x0000,
0xe5e1, 0x0000, 0xe5c1, 0xc0d3, 0x54ce, 0x0000, 0x0000, 0xe5de,
0x54cf, 0x54d0, 0xe5d9, 0x0000, 0x0000, 0xc1a1, 0xb7d2, 0x0000,
0xbdab, 0x54d2, 0x0000, 0x54d3, 0x0000, 0x54d4, 0x0000, 0xbfa5,
0xc1b6, 0xe5e4, 0x0000, 0x54d5, 0xe5e6, 0xe5e7, 0x0000, 0x0000,
0xe5e3, 0xbdd3, 0xbdd7, 0xdeb4, 0xb7b4, 0x0000, 0xd3bd, 0x35a9,
0x34bb, 0xd3be, 0x0000, 0xd9e2, 0xdcb4, 0x0000, 0xb3b4, 0xb4a9,
0xb4ae, 0xb4aa, 0xd4ac, 0x4fd1, 0xb4c7, 0xb9af, 0xd8cd, 0xb9c7,
0xd9ac, 0xb9b3, 0xd0b6, 0x49cd, 0xb9cd, 0xb9e9, 0x49e0, 0xf0d1,
0x37ce, 0xb2d7, 0xdbc9, 0x44b0, 0x50ab, 0x0000, 0xb2ca, 0x38de,
0xb3b1, 0xb2c4, 0x0000, 0xb9ee, 0xb9ef, 0xb5d2, 0x0000, 0xb9ce,
0x0000, 0x0000, 0x0000, 0xb9a3, 0xd2e2, 0xb6f5, 0xb6b2, 0xb9a6,
0xb9b5, 0x0000, 0xb8fd, 0xd9ab, 0xd5e4, 0xb8cf, 0xd3ad, 0xb7a2,
0xb6ec, 0xb9f3, 0x0000, 0x0000, 0xd4f2, 0x0000, 0x0000, 0xb8d9,
0xe6f8, 0x0000, 0x52b3, 0x0000, 0xb2f7, 0x0000, 0xb4be, 0xb6a9,
0xe3fe, 0xb6b8, 0xdbda, 0x0000, 0x4eec, 0x0000, 0xd1d7, 0x0000,
0x4ecf, 0x0000, 0x0000, 0xb0aa, 0xd4f7, 0xb3a1, 0xd0fa,
	/* 0xc040 */
0xe5e5, 0x54d6, 0x0000, 0x54d7, 0x54d8, 0x0000, 0x0000, 0x54d9,
0xe5da, 0xe5e2, 0x0000, 0xe5ea, 0xe5e9, 0x54da, 0x0000, 0xcbfa,
0x54db, 0x54dc, 0xb7ab, 0x0000, 0x0000, 0x54dd, 0x0000, 0x0000,
0x0000, 0x0000, 0x54de, 0xe5e8, 0x0000, 0xe5ec, 0xe5eb, 0xe5ef,
0x54df, 0xe5f1, 0x0000, 0x54e0, 0xe5ed, 0x0000, 0x0000, 0x54e1,
0x54e2, 0xe5f2, 0xe5f3, 0x54e3, 0x0000, 0xe5f4, 0x54e4, 0xe5fa,
0xc5bb, 0xe5f6, 0x54e5, 0xe5f5, 0xe5f7, 0xe5f8, 0x54e6, 0xe5f9,
0x0000, 0x54e7, 0x0000, 0x54e8, 0xe5fc, 0x54e9, 0x54ea, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x54ec, 0x54eb, 0x54ed,
0x54ee, 0x54ef, 0x0000, 0x0000, 0x54f0, 0x0000, 0x54f2, 0x0000,
0x0000, 0x0000, 0x0000, 0xe6a2, 0xe6a3, 0xe6a4, 0x54f3, 0x54f4,
0x54f5, 0x0000, 0xd8c3, 0x0000, 0xbaa5, 0xbaab, 0x3fef, 0xbaa4,
0xb3e7, 0x0000, 0xb3c7, 0x0000, 0x37d5, 0xd9c7, 0xd3c9, 0x5afd,
0x56b9, 0xede5, 0x35e4, 0xcde9, 0xcde8, 0x0000, 0x0000, 0xd5ba,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe0e6, 0xcfb1, 0xcfb5,
0xcfad, 0xcfba, 0xcfaf, 0xcfb2, 0x0000, 0x0000, 0xcfb4, 0xcfb7,
0x30f3, 0xb1b8, 0xcdef, 0xdfe0, 0x0000, 0xf0d5, 0x0000, 0xcdeb,
0x0000, 0xe9b2, 0xe2fd, 0xcedf, 0xd1b4, 0x0000, 0xdaa7, 0xcfbe,
0x0000, 0xdea5, 0x44af, 0xdcc1, 0xcee4, 0xced2, 0xcdfc, 0xe0b5,
0xf3d5, 0x0000, 0xc3ac, 0x50f3, 0xdfa2, 0xcdfd, 0xcdfb, 0xcea4,
0x0000, 0xcee9, 0xe8bd, 0x57e3, 0xcdf9, 0xb7aa, 0x0000, 0x0000,
0xcee5, 0x0000, 0x0000, 0xcdf8, 0x0000, 0xcee3, 0xd0de,
	/* 0xc140 */
0x0000, 0x0000, 0x54f6, 0x54f7, 0x54f8, 0x0000, 0xe6ab, 0x54fa,
0x54fb, 0x54fc, 0x54fd, 0xe6ae, 0xb7d3, 0x0000, 0x54fe, 0x0000,
0xc8b3, 0x0000, 0xc7cd, 0x0000, 0xc8ed, 0xe6af, 0x0000, 0x0000,
0x0000, 0x55a2, 0x55a4, 0x55a5, 0xe6b0, 0xe6b2, 0x0000, 0xcde5,
0xe6b1, 0xe6b4, 0xe6b3, 0x0000, 0x55a6, 0x55a7, 0x55a8, 0x55a9,
0x55aa, 0x0000, 0x0000, 0x0000, 0x55ab, 0x55ac, 0x0000, 0x0000,
0x0000, 0x55ad, 0x0000, 0x55af, 0xe6ba, 0x0000, 0x55b0, 0xc1a2,
0xb5c1, 0x55b1, 0x0000, 0x0000, 0x55b2, 0xe6be, 0x0000, 0x0000,
0x0000, 0x55b3, 0x0000, 0xe6bf, 0x0000, 0x0000, 0x0000, 0x0000,
0x55b6, 0x0000, 0x55b7, 0x0000, 0xe6c3, 0x0000, 0x55b8, 0x0000,
0x0000, 0x0000, 0x55ba, 0x0000, 0x0000, 0xbdac, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x55bb, 0x0000, 0x0000, 0x0000, 0x0000,
0x55bd, 0xcea1, 0xcea9, 0xceb3, 0x0000, 0xf0b0, 0xcecf, 0xcdfe,
0xcbe9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xcef7, 0xcee7,
0x0000, 0x3caa, 0x0000, 0x0000, 0x0000, 0xcef8, 0x0000, 0x0000,
0xe4ee, 0xd1da, 0xcec2, 0xe4ed, 0xcec9, 0x30a8, 0x0000, 0xcecc,
0x42c3, 0xcebc, 0x0000, 0xd9fc, 0xe6d8, 0xcebd, 0x0000, 0xdff9,
0xd5ec, 0x0000, 0xdfb3, 0xcebb, 0x0000, 0x0000, 0xd7a1, 0xcec1,
0xcef3, 0xcef6, 0xcef5, 0xcef4, 0x0000, 0xced6, 0xced3, 0x50b8,
0xf0c3, 0x0000, 0x0000, 0x0000, 0xced4, 0xd1db, 0x0000, 0xd2e7,
0x3fd2, 0xcee8, 0xc9a9, 0xceed, 0x0000, 0x0000, 0xcee2, 0xe6b9,
0xcebf, 0x49c6, 0xcecd, 0x0000, 0x0000, 0x34e1, 0xcee1, 0xceaf,
0xceb0, 0xdcd8, 0xceb2, 0x0000, 0xceb1, 0x33b7, 0xe1ee, 0xceae,
0xccf8, 0xcfbb, 0x0000, 0x0000, 0x0000, 0x0000, 0xe3e3,
	/* 0xc240 */
0x0000, 0x0000, 0x55bf, 0x0000, 0xb4e5, 0x55c0, 0x0000, 0x55c2,
0x55c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe6cb, 0x55c4,
0x55c5, 0x55c6, 0x55c7, 0x0000, 0x55c8, 0x55c9, 0x0000, 0x55ca,
0x55cc, 0x55cd, 0x55ce, 0x55cf, 0x0000, 0x0000, 0x55d2, 0x55d3,
0x55d4, 0xe6d4, 0x0000, 0x55d6, 0x0000, 0x55d8, 0x0000, 0x55d9,
0x0000, 0x55da, 0x0000, 0x55db, 0x55de, 0x55df, 0x55e0, 0x55e1,
0x55e2, 0x0000, 0x55e3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc0bb, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xcab9, 0xe6dd, 0x55e4, 0xc1ef,
0xe6de, 0x0000, 0x55e5, 0x0000, 0x55e6, 0x0000, 0xe6df, 0x0000,
0x0000, 0x55e7, 0x0000, 0xcefe, 0xe6e2, 0xe6e1, 0xe6e0, 0xc4b0,
0x55e9, 0xe6e3, 0xbfa6, 0x0000, 0xe6e4, 0x0000, 0x0000, 0x0000,
0xe6e5, 0xceb4, 0x0000, 0x0000, 0x0000, 0xcfb0, 0x39cd, 0x0000,
0x0000, 0xcfb3, 0xeffb, 0xb0b2, 0x0000, 0x0000, 0x0000, 0xcfa7,
0x0000, 0x0000, 0x0000, 0x0000, 0xcfbc, 0xe2f1, 0xcfaa, 0xcfa9,
0x0000, 0xbcaf, 0x48dc, 0xcfbd, 0x0000, 0x0000, 0xd9a4, 0x0000,
0x0000, 0x0000, 0x0000, 0xceb9, 0xcdfa, 0xbcc8, 0x0000, 0x0000,
0x0000, 0xcea7, 0xcea8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xcdf1, 0xcdf0, 0xceab, 0xceac, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xcde6, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xcde7, 0xcdee, 0xcdec, 0x0000, 0x0000,
0x0000, 0xcbe3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd3d7,
0x0000, 0xcbe4, 0x0000, 0xc7fe, 0x0000, 0x0000, 0xe6f7, 0x0000,
0x0000, 0xc8da, 0x0000, 0xcca2, 0xd2d8, 0xcbfd, 0xcca1,
	/* 0xc340 */
0xcfb8, 0x55ea, 0x0000, 0xe6e9, 0x55eb, 0x0000, 0x0000, 0x55ec,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x55ee, 0x0000, 0x55ef, 0x55f0, 0x0000, 0xe6ef, 0x0000, 0x0000,
0x0000, 0x0000, 0x55f2, 0x55f3, 0x0000, 0x0000, 0x0000, 0x55f4,
0x0000, 0x0000, 0x0000, 0x55f6, 0x0000, 0x0000, 0x55f7, 0x0000,
0x55f8, 0x55f9, 0x55fb, 0x0000, 0x55fc, 0x0000, 0x0000, 0x0000,
0x55fe, 0x0000, 0x0000, 0x56a5, 0x0000, 0x56a7, 0x0000, 0x0000,
0x0000, 0x56a8, 0x0000, 0xb6bc, 0xcfc6, 0xccae, 0x56a9, 0x0000,
0x0000, 0x0000, 0x56ab, 0x0000, 0xe6fa, 0x56ad, 0x0000, 0x0000,
0x56af, 0x0000, 0x0000, 0xe6fc, 0x56b0, 0x0000, 0x0000, 0x56b1,
0x0000, 0xe6fb, 0x0000, 0x0000, 0x0000, 0x0000, 0x56b3, 0xc7be,
0x0000, 0x56b4, 0x0000, 0xc4b1, 0x56b5, 0x0000, 0x56b6, 0x0000,
0x0000, 0x0000, 0xe7ea, 0xe8ab, 0xccd5, 0xdde2, 0xcbbb, 0xe8cf,
0xc7ad, 0xb3fd, 0x0000, 0xccd3, 0xccb7, 0x0000, 0xb1ac, 0xccd0,
0xcbc1, 0xcbb9, 0xcbc6, 0x0000, 0x0000, 0x4be0, 0xcbe7, 0xc7df,
0x0000, 0x67a3, 0xc7e1, 0xcbd7, 0xc8fd, 0xc7de, 0x0000, 0x0000,
0xc8fe, 0xcbe6, 0xd5e7, 0xcbe5, 0xd5bb, 0x0000, 0x0000, 0x0000,
0xcba8, 0xccd8, 0xdda8, 0xccc1, 0x0000, 0xccd4, 0xd4ed, 0xccd2,
0x4ee9, 0x0000, 0xf3d3, 0xe4f6, 0xccc2, 0x0000, 0xccef, 0xcac6,
0xc8eb, 0x0000, 0xc8e7, 0xccaa, 0xcca9, 0x0000, 0xccc9, 0xccb2,
0x0000, 0xd1cb, 0xccc8, 0xcad9, 0xcada, 0x0000, 0xcccc, 0xc9c4,
0xc9c1, 0x4fac, 0xe9b8, 0xc9c3, 0xdedd, 0x0000, 0xccaf, 0xcace,
0x0000, 0xccb1, 0x3fd0, 0xbbae, 0xc9d2, 0x0000, 0x0000, 0xccc0,
0xeaa6, 0x0000, 0x0000, 0xccbe, 0xccbf, 0x0000, 0xccce,
	/* 0xc440 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x56b7, 0x56b8, 0x0000,
0x0000, 0xbfd5, 0x0000, 0x56bb, 0x0000, 0x56bc, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xe7b5, 0x56be, 0x0000, 0x0000, 0x0000,
0xe7aa, 0x56c0, 0x0000, 0xbcf0, 0x0000, 0x56c3, 0x0000, 0x0000,
0x0000, 0x0000, 0x56c4, 0xc4b2, 0x56c5, 0xe7ac, 0x56c7, 0x56c8,
0x56c9, 0x0000, 0x0000, 0x56ca, 0x0000, 0x0000, 0x56cb, 0x56c6,
0x0000, 0xe7b6, 0x0000, 0xe7b2, 0x56cc, 0x0000, 0x0000, 0xc9e6,
0x56cf, 0x0000, 0xe7b1, 0x0000, 0x56d0, 0xe7b3, 0x0000, 0x0000,
0x0000, 0xe7b7, 0x0000, 0x0000, 0x0000, 0x56d1, 0x0000, 0xe7b8,
0x0000, 0x56d2, 0x56d3, 0xe7b9, 0x0000, 0x0000, 0xe7bb, 0x0000,
0x0000, 0xe7bc, 0xe7ba, 0xc7bf, 0x0000, 0x56d7, 0x0000, 0xe7c5,
0xe7c0, 0x56d5, 0xe7c1, 0x56d9, 0x56da, 0x0000, 0xe7c2, 0x0000,
0xc2a1, 0x0000, 0x5aa8, 0xcccf, 0xcbec, 0xcbe1, 0xcbe0, 0xcbe2,
0xcbf5, 0xcbf6, 0xc7fc, 0xcbcf, 0xe0d4, 0xcbf7, 0xc7f9, 0xd5eb,
0xeff9, 0x0000, 0xccb6, 0xcbbf, 0xd9c5, 0xb2b4, 0x0000, 0xd5a8,
0xcaec, 0xcae8, 0xcaeb, 0xcbeb, 0xcae7, 0xcae9, 0xccda, 0xccdc,
0xcbd3, 0xcbd2, 0xcbd4, 0xd9bd, 0x35be, 0x0000, 0x0000, 0xc6e1,
0xd5b1, 0x0000, 0x0000, 0xc7b5, 0x39a4, 0xc2d1, 0xc6e0, 0xc6ee,
0xc3cb, 0x0000, 0x36ec, 0x0000, 0x0000, 0x0000, 0x0000, 0x47da,
0x34f5, 0x0000, 0xc6e2, 0xd5c4, 0xc7bd, 0x39b2, 0xf0bf, 0xd0e4,
0xc5a5, 0xc6f4, 0x0000, 0x30df, 0xc6bf, 0x0000, 0xb5d5, 0xc5ae,
0x59bb, 0xd9c0, 0xc7af, 0xe2fa, 0x0000, 0xc7b1, 0xc7b0, 0xccbc,
0x0000, 0x0000, 0xc7a2, 0xd9d4, 0x0000, 0x3ac4, 0x0000, 0x0000,
0x0000, 0xdeba, 0x3dfb, 0x0000, 0x0000, 0xb6c5, 0x3ac7,
	/* 0xc540 */
0x0000, 0x56db, 0x0000, 0x56dc, 0xe7c4, 0xe7c3, 0xe7c6, 0x56dd,
0x0000, 0x56de, 0x56df, 0xe7c7, 0xe7c8, 0x56e0, 0x0000, 0x56e1,
0xb2e9, 0x0000, 0xced7, 0x0000, 0x56e2, 0x0000, 0x0000, 0x56e4,
0x56e5, 0x56e6, 0x56e7, 0x56e8, 0x0000, 0x56e9, 0x56ea, 0xe7ca,
0x56eb, 0x56ec, 0x56ee, 0xe7d0, 0xb6bd, 0xdaaa, 0xe7d1, 0x0000,
0xbccb, 0x56ef, 0x0000, 0x56f0, 0x0000, 0xe7d4, 0xcade, 0xb4dc,
0x56f2, 0x56f3, 0x56f4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xe7d5, 0xe7e4, 0x56f8, 0x56fa, 0x0000, 0x0000, 0x0000, 0x0000,
0xe7d9, 0x0000, 0x0000, 0x56fb, 0x56fd, 0x56fe, 0x0000, 0x0000,
0x0000, 0x0000, 0x57a2, 0x0000, 0x57a4, 0x0000, 0x0000, 0x0000,
0x0000, 0x57a5, 0x0000, 0xe7da, 0x0000, 0x57a6, 0xe7dc, 0x0000,
0x57a7, 0x0000, 0xe7e0, 0x57a8, 0xe7df, 0x0000, 0xb4cf, 0x57a9,
0x0000, 0x0000, 0x0000, 0xb5ed, 0x3fc0, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xcfae, 0xc5db, 0xc5d8, 0xc5dc, 0xbdf7, 0xc3c8,
0xb5d4, 0x0000, 0x3fe5, 0xd8ef, 0xe4f9, 0x0000, 0xd3a8, 0xb2a4,
0x0000, 0xb2a5, 0xe9b9, 0x0000, 0xb6f6, 0x0000, 0x0000, 0x0000,
0xe0a8, 0x3ca9, 0xd7e6, 0xc7ca, 0xc7ef, 0xc7d3, 0xc7d7, 0xd7d1,
0xdedc, 0xc7c9, 0xdab5, 0xdfaf, 0x0000, 0xc8d8, 0x4ed9, 0xc8ca,
0xc8bd, 0xc8c0, 0x0000, 0x0000, 0xdad5, 0x0000, 0xe6f6, 0xd9c6,
0xd2f6, 0x33b9, 0xdfdc, 0xeadc, 0x5fe5, 0xcba2, 0x0000, 0xe6f5,
0xc7dd, 0xeaea, 0x0000, 0xc7e6, 0xc7db, 0xd0d0, 0xddef, 0x0000,
0xcbdf, 0x4fda, 0x3fca, 0xcba3, 0xdfb0, 0xd7c5, 0xcba9, 0xc3aa,
0xe2ef, 0xe4cb, 0xcbc4, 0xcafe, 0x0000, 0xcafb, 0x4ffb, 0x37c8,
0xe2e7, 0xf0c8, 0xc8e3, 0xc8e4, 0xd1fc, 0xc8fc, 0x0000,
	/* 0xc640 */
0xe7e2, 0xe7e3, 0x0000, 0x57aa, 0xe7e5, 0x0000, 0xb1f0, 0xe7e6,
0xe7e7, 0x57ac, 0x0000, 0x57af, 0x57b0, 0x57b1, 0x0000, 0x0000,
0x57b3, 0x57b4, 0x0000, 0x0000, 0x0000, 0x57b8, 0x0000, 0x57b9,
0x57bb, 0x57bc, 0x0000, 0x57bd, 0x0000, 0x57bf, 0x57c1, 0x57c7,
0x0000, 0x0000, 0x57ca, 0xe7ed, 0x57cb, 0x57cd, 0x0000, 0x0000,
0x0000, 0xb4a3, 0x57ce, 0x0000, 0x57cf, 0x0000, 0xe7fe, 0x57d1,
0x0000, 0x57d3, 0xc3f7, 0x57d5, 0x0000, 0x57d6, 0x0000, 0x57d7,
0x0000, 0x0000, 0x0000, 0xe7f4, 0x0000, 0x57d9, 0x0000, 0x0000,
0xe7f5, 0x0000, 0x57db, 0x57dc, 0x0000, 0x57dd, 0x57e1, 0x57e2,
0x0000, 0x0000, 0x0000, 0x0000, 0xe8a3, 0xe8ad, 0x0000, 0x57e5,
0x57e6, 0x57e7, 0x0000, 0x57e8, 0x57e9, 0xe8b4, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x57ec, 0x57ed, 0xe8a4, 0x57ef, 0x0000,
0x57f2, 0x35e3, 0xe7a3, 0xc8e8, 0xc8e9, 0xc9a4, 0xe1dd, 0xcac8,
0xd5fb, 0xeca2, 0xcad3, 0xcad0, 0xcad2, 0x0000, 0x0000, 0xc9ba,
0xc9bb, 0xc9bc, 0x40ed, 0xcacd, 0x3fd9, 0x0000, 0x0000, 0xc9ca,
0xe6db, 0x0000, 0xc4da, 0xe7f9, 0xe8cc, 0xcabf, 0xd1df, 0xc9d3,
0x0000, 0xd6a2, 0xd4b3, 0x0000, 0x0000, 0xc7cc, 0xc7cb, 0xf2b0,
0xc7f7, 0xc7f4, 0xcbb6, 0x3fb9, 0x0000, 0xd0bd, 0x58a6, 0xc9f2,
0xcaee, 0xb3f7, 0xd4be, 0xcbd1, 0xcae0, 0xc9e1, 0xb1ba, 0x0000,
0xc7f8, 0xdfc6, 0xb4fc, 0xb5bd, 0xc0b4, 0xc0cc, 0xbaca, 0xbcb7,
0xc0a8, 0xbcbf, 0x43bf, 0x0000, 0xc2b6, 0xb4fd, 0xb4f1, 0x45f9,
0xb7cd, 0xbaea, 0x0000, 0x0000, 0xb4fa, 0xb5a7, 0xb7b7, 0x0000,
0xb5af, 0x0000, 0xb8f0, 0xb4eb, 0x34eb, 0xb7c0, 0xe2e6, 0xb4ef,
0xdde3, 0xcbf8, 0xd7b1, 0xb5a5, 0xb5e3, 0x0000, 0x40a9,
	/* 0xc740 */
0x0000, 0x0000, 0x0000, 0x57f3, 0x57f5, 0xe8a9, 0x0000, 0xb7d5,
0x0000, 0x0000, 0x57f7, 0x57f8, 0x58be, 0x57fa, 0x57fb, 0x57fc,
0xc1f1, 0x0000, 0x0000, 0x0000, 0x57fd, 0x0000, 0x0000, 0xe8ba,
0x0000, 0xe8bb, 0x0000, 0x0000, 0x0000, 0x0000, 0x58a2, 0x58a3,
0x0000, 0x58a4, 0x0000, 0x58a5, 0xe8b6, 0x0000, 0xe8b7, 0x0000,
0x0000, 0x58a7, 0x0000, 0x0000, 0x0000, 0x58a9, 0x58aa, 0xe8b3,
0x0000, 0x58ac, 0xe8af, 0x58af, 0xe8b1, 0x0000, 0xe8b2, 0x0000,
0x0000, 0x0000, 0x58b0, 0x58b1, 0x58b3, 0x58cc, 0x0000, 0x0000,
0x0000, 0xe8b9, 0x0000, 0x58b4, 0x58b5, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x58b8, 0x0000, 0x0000, 0xe8c2, 0x58ba, 0x58bb,
0x0000, 0xb2db, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58bf, 0xe8c1, 0x0000,
0x0000, 0xb3e6, 0xdeaa, 0x0000, 0x0000, 0x0000, 0x0000, 0xc0e9,
0x61b8, 0x0000, 0xd0c2, 0x0000, 0xb4a5, 0xf3d8, 0x0000, 0x0000,
0xc1b0, 0xc0f8, 0xb8af, 0xc0f5, 0x0000, 0x0000, 0xd6c8, 0xb7e7,
0xddbe, 0x0000, 0x0000, 0xb9d0, 0xe6b5, 0x0000, 0x0000, 0x0000,
0x0000, 0xdcf2, 0x0000, 0xdaca, 0xd8a1, 0x0000, 0x4fb5, 0x0000,
0x0000, 0xb9aa, 0xbee4, 0x40fa, 0x0000, 0xd6b9, 0x31bf, 0x0000,
0xc0da, 0xb2d8, 0xb3ee, 0xb6b1, 0xc0e0, 0x0000, 0xbfaf, 0x0000,
0xbfc1, 0xb6d7, 0xb6d0, 0xb6dc, 0xdaa2, 0xb6d9, 0xbfb2, 0xddee,
0xc0c4, 0x0000, 0x0000, 0x0000, 0xb6aa, 0xc0b6, 0x41a6, 0xc0b2,
0x0000, 0xbef0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbda9,
0xb5d6, 0xeeb9, 0xb5e5, 0xb5e1, 0xbcfc, 0xbdb6, 0xddfa, 0x0000,
0xb6e8, 0xe9d7, 0xb6ca, 0xb6ed, 0xb6fe, 0x0000, 0xb5f4,
	/* 0xc840 */
0x0000, 0xb2da, 0x0000, 0xe8bf, 0x0000, 0x58c1, 0xe8c8, 0x0000,
0xe8d2, 0x58c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe8c9,
0x0000, 0x0000, 0x58c7, 0x0000, 0x0000, 0xe8c0, 0x0000, 0x58ca,
0x0000, 0x0000, 0x58cb, 0x0000, 0x0000, 0x0000, 0x0000, 0xe8ce,
0x0000, 0xe8cd, 0x0000, 0xc7eb, 0xe8d4, 0x0000, 0xe8df, 0x0000,
0x0000, 0x58cd, 0x0000, 0x0000, 0x0000, 0x0000, 0xe8e2, 0x0000,
0x0000, 0x58ce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x58cf, 0x58d0, 0x58d1, 0xcdd5, 0x0000,
0x58d2, 0x0000, 0x0000, 0x58d3, 0xceaa, 0x58d4, 0x0000, 0x58d6,
0x0000, 0x0000, 0x0000, 0x58d7, 0x58d8, 0x0000, 0x0000, 0x0000,
0x58dc, 0xe8e4, 0x58dd, 0x58de, 0xb0b1, 0x58df, 0x0000, 0x58e0,
0xe8db, 0xe8e0, 0x58e1, 0x0000, 0x58e3, 0xe8d8, 0xe8e1, 0x0000,
0x58e6, 0xbce8, 0xd5b8, 0x0000, 0xbcf1, 0xb5ee, 0xd4a1, 0x0000,
0x0000, 0x0000, 0xc0f4, 0xc1b4, 0xe1d9, 0xb7fd, 0xb8a4, 0xb7f4,
0x0000, 0xe5fe, 0x49cc, 0x4dfd, 0xb5d1, 0x0000, 0x44e1, 0x4fec,
0xbffd, 0xeae5, 0xb7b2, 0xc1b3, 0xc7b3, 0xd1c7, 0xc0f7, 0x4cf4,
0xd4e1, 0xdab7, 0x36e8, 0x0000, 0x0000, 0x0000, 0x0000, 0xbce6,
0x0000, 0xbfd1, 0xbfce, 0xbfcd, 0xc7a6, 0x0000, 0xc7a4, 0x0000,
0xbfcf, 0xc7a5, 0x0000, 0x3fbb, 0xd0bb, 0xc6fc, 0xbdbf, 0xc2fb,
0xcdd6, 0x0000, 0xcdbb, 0xcdd0, 0xcdcf, 0xcdc6, 0x0000, 0xbee9,
0xd9e6, 0xbdc0, 0xc6f9, 0xe8a7, 0xeac0, 0xbcf4, 0xd5de, 0xc7a1,
0xbfab, 0xc6fd, 0xc6f2, 0xc6fe, 0xeaf3, 0x0000, 0xeff6, 0xbcc9,
0xbff0, 0x0000, 0x0000, 0x0000, 0xbce3, 0xbce5, 0xbbb5, 0xdeaf,
0x0000, 0xe7a8, 0x0000, 0xbac9, 0x0000, 0xbbb0, 0x0000,
	/* 0xc940 */
0x58e7, 0x0000, 0x0000, 0x0000, 0x58e8, 0x0000, 0xe8d7, 0x58e9,
0x0000, 0x0000, 0x0000, 0x0000, 0xbdaf, 0x0000, 0x58ea, 0x58eb,
0xbcac, 0x58ec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58ed,
0xe8e7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58ee, 0x0000,
0x58ef, 0x58f0, 0x58f1, 0x0000, 0x0000, 0xe8da, 0x0000, 0x0000,
0x58f3, 0x0000, 0x0000, 0x0000, 0x0000, 0xe8ea, 0xc1f3, 0x58f7,
0x58f8, 0x58f9, 0x0000, 0x0000, 0xe8ee, 0x58fa, 0x58fb, 0xb3b8,
0x58fc, 0x0000, 0x58fd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xe8e8, 0xe8eb, 0x0000, 0x59a1, 0x0000, 0x0000, 0x0000,
0x0000, 0x59a2, 0x0000, 0x0000, 0x59a3, 0x0000, 0x0000, 0xcfa1,
0x59a4, 0x59a6, 0x59a7, 0x0000, 0xe8f3, 0x0000, 0x0000, 0x59a8,
0x0000, 0x0000, 0x59aa, 0x59ab, 0x59ac, 0x0000, 0xbcc3, 0x0000,
0x59ad, 0x0000, 0xbbb6, 0xb7ac, 0x36a1, 0x0000, 0x40cb, 0x0000,
0x0000, 0xd5bf, 0xe0ee, 0xbfa7, 0x0000, 0xbfb9, 0xc1ce, 0xe8b5,
0xbabd, 0x0000, 0xd1eb, 0xbabb, 0x0000, 0x0000, 0x0000, 0x49fd,
0x0000, 0xbbaf, 0xbbb9, 0xc6d1, 0xbff9, 0xbbb3, 0x0000, 0xc0fa,
0xeace, 0x0000, 0x0000, 0xdaa3, 0x0000, 0xc1b7, 0xc1b1, 0xdde8,
0xc0f0, 0x0000, 0x0000, 0x0000, 0xbea6, 0x0000, 0x42b5, 0xbee5,
0xbeb0, 0xbed8, 0xbebf, 0x3ff2, 0xe3c4, 0x0000, 0xe7e9, 0xbcdb,
0xf0f0, 0xbeaf, 0xbea5, 0xeeba, 0x0000, 0xd4fa, 0x0000, 0xbcd8,
0xc0e5, 0xe7d2, 0xbccf, 0x0000, 0xbccd, 0x0000, 0x0000, 0xbcd2,
0x0000, 0x4fdc, 0xbfbd, 0xd2f1, 0xbfad, 0xbfc8, 0xbfbc, 0xbfb1,
0x0000, 0xbfc0, 0xc4c0, 0x0000, 0x0000, 0xbfd3, 0x0000, 0xbfb5,
0x0000, 0xc0bc, 0xc0b8, 0xb1f9, 0xc0b7, 0xbea3, 0x0000,
	/* 0xca40 */
0x59ae, 0x0000, 0x0000, 0xe8d1, 0x59af, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x59b1, 0x0000, 0x59b2, 0x0000, 0xe8f9, 0xe8f8,
0x0000, 0xe8f5, 0x0000, 0x0000, 0x59b3, 0x0000, 0x59b4, 0x0000,
0x59b5, 0x59b6, 0x59b7, 0x59b8, 0xc4d5, 0x59b9, 0x0000, 0x0000,
0x59ba, 0xb0fe, 0x0000, 0x59bc, 0x0000, 0x0000, 0x59a9, 0x59bd,
0x59be, 0xc2a2, 0x59bf, 0x0000, 0x59c0, 0xe8fb, 0xe9a1, 0x0000,
0x0000, 0x0000, 0x59c1, 0x0000, 0xe9a3, 0x0000, 0x0000, 0xb6be,
0x59c2, 0x59c3, 0x59c4, 0x59c5, 0x59c6, 0x0000, 0xe9a4, 0x0000,
0xc9f9, 0xe8fd, 0xe8d6, 0x0000, 0x59c9, 0x59ca, 0x59cc, 0x59cd,
0x59ce, 0x59cf, 0xe8fc, 0x0000, 0x0000, 0x0000, 0xc6a2, 0xc9f3,
0x59d1, 0x0000, 0xe9ab, 0x0000, 0x59d2, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xe9b1, 0x0000, 0x0000, 0x59d6, 0x59d7, 0xe9a5,
0x59d8, 0xbeca, 0xc0b9, 0xd1f4, 0x0000, 0x37af, 0x0000, 0xbcba,
0x0000, 0xbbdc, 0xbcbe, 0x0000, 0xd5f9, 0xe9cd, 0xbdbd, 0xc0d0,
0xbda6, 0x0000, 0xbdba, 0xbfa9, 0x0000, 0x0000, 0x0000, 0xbbcb,
0xccf0, 0xbbc8, 0xd5fd, 0x0000, 0xbbcf, 0xbcb0, 0xbca8, 0xbbce,
0xc0a4, 0xb3c1, 0xbbf6, 0xbfa1, 0xc0c0, 0xc0c2, 0x0000, 0xc0a7,
0xd3cf, 0xd3e3, 0x61cb, 0xbbc5, 0xbbf8, 0x0000, 0x0000, 0xbbe1,
0xbbd4, 0xd7f4, 0xbcbc, 0x0000, 0x0000, 0xdac0, 0xbcea, 0xbcf3,
0xbce9, 0xbcf7, 0xbcf8, 0xd3b4, 0xbcf5, 0x4df7, 0x0000, 0xe8f6,
0xbff5, 0xdbe0, 0xbcec, 0xd9b3, 0x0000, 0xbdc7, 0xd0b0, 0xbdca,
0xc1c1, 0x0000, 0x0000, 0xd5d9, 0xbdcf, 0xbdf2, 0xbdeb, 0xbdec,
0xbdf0, 0xe9e6, 0xb5d0, 0xc1cd, 0xc2b0, 0x0000, 0xbdd2, 0x0000,
0xc2ab, 0xd8fb, 0x0000, 0xd4d0, 0xbdee, 0xbff4, 0xdefb,
	/* 0xcb40 */
0x0000, 0x0000, 0x59da, 0xe9a7, 0x59db, 0xe9a9, 0x59dc, 0x59dd,
0x0000, 0x0000, 0xe9b3, 0xe9a8, 0x0000, 0x59df, 0xe9ac, 0x0000,
0x0000, 0xb1f2, 0x59e0, 0xc6e5, 0x0000, 0x59e1, 0x0000, 0x59e2,
0x59e3, 0x0000, 0x59e4, 0x0000, 0x59e5, 0xc1a6, 0x59e6, 0xbba7,
0xb7b0, 0xccf4, 0x59f4, 0x0000, 0x0000, 0x0000, 0x59e7, 0x0000,
0x59e8, 0x59ea, 0xe9b5, 0x0000, 0x59eb, 0x59ec, 0x59ed, 0x59ee,
0x0000, 0x59ef, 0x0000, 0x0000, 0x0000, 0x0000, 0x59f0, 0x0000,
0x59f1, 0x59f2, 0x0000, 0xcdf5, 0x59f3, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x59f5, 0x0000, 0x59f6, 0x0000, 0xe9ba,
0x0000, 0x59f7, 0x59f8, 0x0000, 0x0000, 0x0000, 0xe9bb, 0x59f9,
0x0000, 0x59fa, 0xe9ae, 0x0000, 0x0000, 0x59fb, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x59fc, 0x0000, 0x0000, 0x59fd, 0xbdf3,
0x0000, 0xbdfa, 0xbafe, 0x55cb, 0x40de, 0xbfea, 0x4da8, 0x0000,
0xc0f2, 0x3fd8, 0xc1fa, 0xc1d0, 0xc1d6, 0x0000, 0xbfe5, 0xbfe7,
0xc0c7, 0xd2e4, 0xbdd6, 0x0000, 0xbdd8, 0x0000, 0x0000, 0xbaf3,
0x0000, 0xbbdb, 0xd9f9, 0xd3dd, 0xbbd7, 0xbbe4, 0xbbca, 0x0000,
0xbbe0, 0xe6e8, 0xbbfb, 0xbbcc, 0xbbcd, 0xbbc7, 0xbbf7, 0x0000,
0xcca6, 0xbebe, 0x0000, 0x0000, 0x0000, 0xc1f7, 0xc1d7, 0x0000,
0x0000, 0xd9d3, 0xe7db, 0x0000, 0xd3d6, 0x0000, 0xeec8, 0xc2af,
0xc1c7, 0xc2ae, 0xb0c0, 0x0000, 0xc1ba, 0xdeea, 0xbdc9, 0x0000,
0x0000, 0xbbc0, 0xc9c7, 0xbbbb, 0x0000, 0xe7a1, 0xbfef, 0x0000,
0xf1f2, 0xe2ec, 0x0000, 0xe3cf, 0xbfeb, 0xf0ab, 0xe3ae, 0x0000,
0x0000, 0xe4a4, 0xccac, 0xdbe8, 0xbab6, 0x0000, 0x0000, 0xbaf7,
0x0000, 0xbdea, 0x38ae, 0xc2be, 0xd5e0, 0x39a5, 0xc5e3,
	/* 0xcc40 */
0xe9bd, 0xe9c2, 0x59fe, 0x0000, 0xe9c1, 0x5aa2, 0x0000, 0xe9a2,
0x0000, 0x5aa3, 0xe9c3, 0xc1c9, 0x0000, 0x0000, 0xe9be, 0xe9c0,
0x0000, 0x5aa5, 0x5aa6, 0x0000, 0x5aa7, 0x5aa9, 0xe9bf, 0x0000,
0x0000, 0xdda2, 0x5aaa, 0x5aab, 0xe9c5, 0x5aac, 0x0000, 0x0000,
0x5aad, 0x0000, 0x0000, 0x5aae, 0xe9c4, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xcdf6, 0x0000, 0xe2bc,
0xe9c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ab1, 0x0000,
0x0000, 0x5ab3, 0x0000, 0x5ab5, 0x0000, 0xe9c7, 0x5ab6, 0x0000,
0x38e6, 0x5ab7, 0x0000, 0x0000, 0x0000, 0x5ab8, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x5ab9, 0x5aba, 0xd1dd, 0x5abb,
0x5abc, 0x5abd, 0x5abe, 0x0000, 0xceba, 0x5abf, 0xe9cb, 0x5ac0,
0x5ac1, 0x5ac3, 0x5ac4, 0x0000, 0x0000, 0xe9cc, 0x0000, 0x5ac5,
0x0000, 0x0000, 0x0000, 0x60ad, 0xc6a7, 0xc2db, 0xc2dd, 0xdaad,
0xc2e6, 0xc2d9, 0x0000, 0xc2c0, 0x0000, 0xc2c1, 0x37bf, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xc3c9, 0xe1e2, 0xdfac, 0x0000,
0x0000, 0xc3b3, 0xdddf, 0xead8, 0x4ffe, 0xc3b5, 0x0000, 0xc3ba,
0x0000, 0xc5e4, 0x40d3, 0xc6b2, 0xdcab, 0x56ce, 0xc5e2, 0xc5fc,
0x31d3, 0x60d2, 0xdec5, 0x5fd3, 0x0000, 0xd9db, 0xc5f3, 0xdeed,
0x0000, 0xc6ba, 0xc5ed, 0xc6a8, 0xc5f1, 0xc6ab, 0x0000, 0xc5e5,
0xc6c3, 0xc6a3, 0x0000, 0xe1d6, 0x0000, 0xc4f4, 0xd1f1, 0x5ffe,
0x0000, 0xc4f3, 0x0000, 0xc4fd, 0xd3c6, 0xc2ce, 0xc2d8, 0xd3ea,
0x3eac, 0xdeb8, 0xc4e6, 0x0000, 0xc5b7, 0xc5ba, 0xc5b6, 0xc5c4,
0xc5bc, 0xd7f7, 0x56f1, 0xe7a2, 0xc4a9, 0xbef2, 0xedeb, 0xc4af,
0xc4b7, 0x0000, 0x0000, 0xc4a1, 0x0000, 0xd2e1, 0x0000,
	/* 0xcd40 */
0x0000, 0x5ac7, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ac8, 0x5ac9,
0x5aca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5aed,
0x0000, 0x0000, 0x0000, 0x0000, 0x5acd, 0x0000, 0x0000, 0x5ace,
0x0000, 0x5acf, 0x0000, 0x5ad0, 0x0000, 0x0000, 0x0000, 0x0000,
0x5ad2, 0x0000, 0x0000, 0x5ad3, 0xe9db, 0x5ad6, 0x0000, 0x0000,
0x5ad8, 0x5adb, 0x5adc, 0x5add, 0x0000, 0x0000, 0x0000, 0x0000,
0x5ade, 0x5ae0, 0x0000, 0x5ae1, 0x5ae2, 0x0000, 0x0000, 0xb7d6,
0x5ae4, 0x0000, 0x5ae5, 0x0000, 0x5ae6, 0x5ae7, 0x5ae8, 0x0000,
0x0000, 0x5ae9, 0x0000, 0x0000, 0x5aea, 0x5aeb, 0x0000, 0x5aec,
0x0000, 0x0000, 0x0000, 0xe9df, 0xe9e2, 0x0000, 0x0000, 0x0000,
0x5aee, 0xe9e8, 0x5aef, 0x5af0, 0x0000, 0x0000, 0x5af1, 0x5af2,
0xe9e4, 0x5af4, 0x0000, 0x5af5, 0x5af6, 0x5af7, 0xe9e9, 0x5af9,
0x0000, 0xc4f5, 0xc4ee, 0xc4e4, 0xc4e2, 0xc4ed, 0xc4f2, 0xc4fa,
0xc4cc, 0xb6cd, 0x0000, 0xc6b7, 0xc6b1, 0x0000, 0x3cfd, 0xc6b8,
0xb2b3, 0x0000, 0xc5fb, 0x0000, 0xc4cb, 0x0000, 0xc5ea, 0x0000,
0xc6a9, 0xc6cc, 0x0000, 0xc6cd, 0x0000, 0xc5cc, 0xc5d3, 0x47c6,
0xc5cb, 0xc5da, 0xc5c7, 0xd1bd, 0xdeda, 0x0000, 0xbfe4, 0x0000,
0xc2dc, 0x0000, 0xeaf4, 0xc2e0, 0x0000, 0xc6d6, 0xe7bd, 0x3fd4,
0xc2f1, 0xc3a6, 0x0000, 0xc2cb, 0x0000, 0x0000, 0x0000, 0xc2c5,
0xc2f3, 0xc2c3, 0x3fe2, 0xd2f7, 0xb3bf, 0x47bb, 0xb0a3, 0xb4a4,
0x5cbc, 0xcfc4, 0xb3b0, 0xecb2, 0xd7bf, 0xcfd1, 0xb4e1, 0x0000,
0xb4dd, 0x0000, 0xb4b0, 0xcfd2, 0xc8d4, 0x0000, 0xe2aa, 0x3ea8,
0xb0b8, 0xd5b6, 0xcbfc, 0xcfd3, 0xddea, 0xb2a6, 0xcbb4, 0xdbbe,
0xe6a6, 0xb1fd, 0xb2a2, 0xcbbe, 0xcbba, 0xccd1, 0xb0d2,
	/* 0xce40 */
0x5afa, 0x0000, 0x0000, 0x5afc, 0x0000, 0x0000, 0x0000, 0x0000,
0x5ba1, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ba3, 0x0000, 0x5ba5,
0x0000, 0x0000, 0x0000, 0x0000, 0x5ba6, 0x5ba7, 0x5ba8, 0x5ba9,
0x5bab, 0x0000, 0x0000, 0x5bac, 0x0000, 0x5bad, 0x0000, 0x0000,
0xcfb9, 0x5bae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbfaa,
0x0000, 0x5baf, 0x0000, 0x0000, 0x0000, 0x5bb0, 0x0000, 0xe9f6,
0x5bb1, 0x0000, 0xb2dc, 0x0000, 0xe9fc, 0x0000, 0xeaa3, 0x0000,
0x0000, 0x0000, 0x5bb4, 0x5bb5, 0x5bb6, 0x0000, 0x0000, 0x0000,
0x0000, 0xe9f7, 0x0000, 0x0000, 0xc7e8, 0x0000, 0x0000, 0x5bb9,
0x5bbb, 0x5bbc, 0x5bbe, 0x0000, 0x5bc0, 0x0000, 0x0000, 0x5bc1,
0x0000, 0x0000, 0x0000, 0x5bc3, 0x0000, 0x5bc5, 0x5bc6, 0x0000,
0x0000, 0x0000, 0x0000, 0x5bc7, 0x5bc8, 0x0000, 0xeaa5, 0x5bc9,
0x0000, 0xd6db, 0xc8f9, 0xb4ed, 0x0000, 0x0000, 0x43d9, 0x0000,
0xcda3, 0xb0d4, 0x0000, 0x0000, 0x0000, 0x0000, 0xb0e0, 0xb0d1,
0x0000, 0x0000, 0xc8f8, 0x0000, 0xcca4, 0xb1b6, 0xcca3, 0xb0da,
0xb0df, 0x35e7, 0xf2b2, 0xb0cc, 0xdecf, 0x0000, 0xb0d3, 0xb0d6,
0x0000, 0xe1e9, 0xb2b9, 0xb2e3, 0xcab8, 0x0000, 0x0000, 0xcaad,
0x0000, 0xe5a4, 0x0000, 0x0000, 0xb2a7, 0xe1a5, 0x0000, 0x0000,
0x0000, 0x0000, 0xb2e6, 0xb0b6, 0x0000, 0xb0ae, 0xcde0, 0xd6e0,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb2b0, 0xdadb, 0x0000,
0xb8e8, 0xb8e3, 0x34ed, 0xddd9, 0xc9f0, 0xb8de, 0x3fec, 0xb8e1,
0xc9f1, 0xb8e0, 0xc9ee, 0x0000, 0xcaea, 0x0000, 0xdaed, 0xcaaa,
0xccde, 0x0000, 0xb8e7, 0x0000, 0xc0ce, 0xf4a6, 0xc0cf, 0xc0be,
0x4fe3, 0x0000, 0xdaf2, 0x36ba, 0xb5db, 0x0000, 0x0000,
	/* 0xcf40 */
0x0000, 0x0000, 0x5bca, 0x0000, 0x0000, 0x5bcd, 0x0000, 0x5bce,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xeab3, 0x0000,
0x5bd0, 0x5bd1, 0x5bd2, 0x0000, 0x0000, 0xeaaf, 0x0000, 0xeab1,
0x5bd3, 0x5bd4, 0x0000, 0x0000, 0x5bd6, 0x0000, 0xeaac, 0x0000,
0x5bd7, 0x5bd8, 0x0000, 0x0000, 0x5bd9, 0x5bda, 0x5bdb, 0x0000,
0x0000, 0x5bdc, 0x0000, 0x5bdd, 0x5bde, 0x5bdf, 0x0000, 0x0000,
0x0000, 0x0000, 0x5be1, 0x0000, 0x5be2, 0xeab4, 0x0000, 0x5be3,
0xeab5, 0x5be4, 0x0000, 0x0000, 0xeaba, 0xeabb, 0x5be5, 0x0000,
0x5be6, 0xb5c2, 0x0000, 0x0000, 0x5be7, 0x0000, 0x5be8, 0x0000,
0x0000, 0xeaa4, 0x5bea, 0x0000, 0x0000, 0x5beb, 0x5bed, 0x0000,
0xeab8, 0xeabc, 0xeab7, 0x5bee, 0xeabe, 0x5bf0, 0x5bf2, 0x0000,
0x5bf3, 0x5bef, 0x5bf4, 0x5bf6, 0x0000, 0x5bf7, 0x5bf8, 0x0000,
0xe9da, 0xb5a9, 0xc2a9, 0xb4f5, 0xbcbd, 0xc9a8, 0xcdbc, 0xc0cb,
0xdfef, 0x0000, 0xdee4, 0xbcae, 0xbad4, 0xdcfc, 0x0000, 0xc0ca,
0x0000, 0x39f9, 0xb4ee, 0x0000, 0xc0f6, 0xb7cf, 0xb7e4, 0x0000,
0x0000, 0xe2d2, 0x0000, 0xd2ba, 0xb2e2, 0x0000, 0xb2cb, 0xb6ae,
0xb6a2, 0xb6b9, 0xb2bc, 0xd2cf, 0xb2c6, 0x34e5, 0xd9d7, 0x0000,
0xc0e8, 0xc0e7, 0x0000, 0x0000, 0xd2f9, 0x0000, 0x0000, 0xb8bf,
0x0000, 0xdeb7, 0xb8b9, 0xb7f9, 0x0000, 0x0000, 0x0000, 0xb8a5,
0x0000, 0xc1a3, 0x0000, 0x55ae, 0x0000, 0xeffc, 0xb8c2, 0x0000,
0xc1ea, 0x0000, 0x0000, 0xb9e1, 0xc8a2, 0xeaf7, 0xbec5, 0x0000,
0xe6c6, 0xbecd, 0x0000, 0xc1db, 0x35bb, 0xb5fd, 0x0000, 0xb9ab,
0xc6cb, 0xc1fc, 0xb8fe, 0xbedd, 0x0000, 0xbecb, 0xf0bc, 0xbaef,
0xd3ac, 0x0000, 0x0000, 0xbec3, 0xbeac, 0xdec2, 0x0000,
	/* 0xd040 */
0x0000, 0x0000, 0x0000, 0xeac6, 0x5bf9, 0x0000, 0x0000, 0x0000,
0x0000, 0x5bfa, 0x5bfb, 0x0000, 0x5bfc, 0xeac3, 0x0000, 0x0000,
0x5bfe, 0xeac4, 0x0000, 0x0000, 0x5ca1, 0xeac7, 0x0000, 0x0000,
0x0000, 0x5ca3, 0xeac9, 0x5ca4, 0xbdb0, 0x0000, 0x5ca6, 0x5ca7,
0x5ca8, 0x5ca9, 0x5caa, 0x0000, 0x0000, 0x5cab, 0xeaca, 0xbdd1,
0x5cac, 0x5cad, 0x5cae, 0x5caf, 0xb1d2, 0x5cb0, 0xbed7, 0xeacc,
0x5cb1, 0x5cb2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cb5,
0x0000, 0x0000, 0xead2, 0x0000, 0x0000, 0x5cb6, 0x0000, 0x0000,
0x5cb7, 0x0000, 0x5cb8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xead7, 0x5cb9, 0xeada, 0x5cba, 0x5cbb, 0x0000, 0xead1, 0x5cbd,
0x5cbe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cbf, 0x0000,
0x5cc0, 0xbeae, 0xb9a7, 0xb9bb, 0xbed3, 0x0000, 0xbed0, 0xdac3,
0xdcb8, 0xbab3, 0xddbc, 0xe9f9, 0xf0de, 0x0000, 0xb6b4, 0xb7c8,
0xbcd9, 0xbcd0, 0x0000, 0x0000, 0xbccc, 0xb3a3, 0xb2b7, 0xb3aa,
0xd8e8, 0xddf5, 0x0000, 0x0000, 0xb6fd, 0xbfc5, 0xbfc4, 0x0000,
0xb6d5, 0xbfc9, 0xbfb7, 0xd7d7, 0xbfb4, 0xbfae, 0x5ca5, 0xc0b1,
0xe7a9, 0xe0cf, 0xd8b9, 0x0000, 0xb7ba, 0xb7bf, 0xb7c1, 0x61f4,
0xb9d4, 0xc0c3, 0xb9ac, 0xb0c9, 0xc0ad, 0xc0ab, 0xb7bb, 0xb6a7,
0xb6bb, 0xd2b3, 0x46e7, 0xcdba, 0xb7a7, 0xb5d9, 0xbda4, 0xe6b7,
0xb5e0, 0xd3cc, 0x0000, 0xbda8, 0xc2b5, 0x0000, 0xd4d2, 0xd8fc,
0xbcfb, 0xb5f5, 0xb1b3, 0x0000, 0xbdf9, 0x0000, 0xc3df, 0x62d8,
0xbdf6, 0xb0b0, 0xbdf8, 0xc3dc, 0xd7f5, 0xe5b1, 0xccbb, 0x0000,
0x0000, 0x0000, 0xb7f6, 0xc0eb, 0x0000, 0xc0fb, 0xb8bc,
	/* 0xd140 */
0x0000, 0xead9, 0x0000, 0xeade, 0x0000, 0x0000, 0xb8d3, 0xead4,
0x0000, 0x0000, 0x0000, 0x5cc1, 0x0000, 0x5cc2, 0x5cc3, 0xeadf,
0x5cc4, 0xeae1, 0xeae2, 0x0000, 0x0000, 0x5cc5, 0x5cc6, 0x5cc7,
0x5cc8, 0xcea2, 0x0000, 0x5cca, 0x5ccc, 0x0000, 0x0000, 0x0000,
0x5ccd, 0xcae4, 0xeae6, 0x5cce, 0x0000, 0xcea3, 0x0000, 0x5ccf,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cd0, 0xeaec,
0x5cd3, 0x0000, 0x5cd4, 0x0000, 0x0000, 0xc0bd, 0x0000, 0x0000,
0x5cd5, 0x0000, 0xeaed, 0x0000, 0x5cd6, 0xcaa3, 0x0000, 0x0000,
0x0000, 0x0000, 0xeaee, 0x5cd7, 0x5cd8, 0x5cd9, 0x0000, 0x0000,
0x5cda, 0x5cdb, 0x0000, 0x5cdc, 0x5cdf, 0xeafc, 0xeaf2, 0x0000,
0x5ce0, 0x0000, 0x0000, 0x0000, 0x5ce1, 0x5ce2, 0x5ce3, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x5ce5, 0x5ce6, 0x0000, 0x5ce7,
0x0000, 0x0000, 0x0000, 0xe2c1, 0x0000, 0xb7a4, 0xe9ad, 0xb3d8,
0xb7ea, 0xc0e3, 0xb7ec, 0x0000, 0xdfed, 0xbddb, 0xbddc, 0x0000,
0x0000, 0x0000, 0xbde4, 0xbdde, 0x46df, 0x0000, 0x0000, 0x0000,
0xbfd7, 0x0000, 0xb2a1, 0x0000, 0x0000, 0xd2e0, 0x30aa, 0xb2ea,
0xb2e7, 0x5ad1, 0xb3b3, 0xeacb, 0xb3b6, 0xb2ed, 0x0000, 0x0000,
0x0000, 0xdfe1, 0xb0f6, 0x0000, 0xdfdd, 0xdebb, 0x0000, 0x0000,
0xb8a6, 0xe9e3, 0xb4e4, 0xb1e4, 0xb8c0, 0x0000, 0x0000, 0xb1ea,
0xb1e8, 0xb1e2, 0xb1e6, 0xb4e3, 0xdea7, 0xb1e9, 0x0000, 0xb1e1,
0xb1ed, 0x0000, 0x0000, 0xb4e7, 0x35c6, 0xc9a7, 0x49ef, 0xb1e3,
0x0000, 0x0000, 0xddca, 0xb1fb, 0x0000, 0xe3bf, 0x0000, 0x0000,
0xd0d3, 0x0000, 0xcdd3, 0xcdce, 0x66cc, 0x46ce, 0xb6c4, 0xe1da,
0x0000, 0x0000, 0xdfa1, 0xeeb3, 0xb9f8, 0xcdc5, 0xe0f6,
	/* 0xd240 */
0xeafa, 0x5ce8, 0x5ce9, 0xeaf8, 0x0000, 0x0000, 0x5cea, 0x0000,
0x5ceb, 0x5cec, 0xeaf1, 0x5ced, 0x5cee, 0x0000, 0x0000, 0x5cef,
0x0000, 0x0000, 0xeafb, 0xf0b7, 0x0000, 0x5cf0, 0x0000, 0x0000,
0x5cf1, 0x0000, 0x0000, 0x0000, 0xb2a8, 0x5cf2, 0x0000, 0x0000,
0x5cf3, 0x5cf4, 0x5cf5, 0x0000, 0xeafd, 0x5cf6, 0x5cf7, 0x5cf8,
0xeba2, 0x0000, 0x0000, 0x0000, 0x0000, 0xeba4, 0x5cf9, 0x0000,
0xeba3, 0x5cfa, 0xeba5, 0x5cfb, 0x0000, 0xbdb1, 0x5cfc, 0xeba6,
0x5cfd, 0x0000, 0xeba7, 0x0000, 0x0000, 0x5cfe, 0x5da2, 0x0000,
0x5da3, 0xeba8, 0x0000, 0x0000, 0x0000, 0x0000, 0xc7c6, 0xebaa,
0x5da4, 0xebab, 0xb8ab, 0x0000, 0x5da5, 0x0000, 0xb5ac, 0x5da6,
0x0000, 0x0000, 0xebac, 0x5da7, 0x5da8, 0xbbeb, 0xc7c1, 0xebad,
0x0000, 0xb3d0, 0x5da9, 0x5daa, 0x0000, 0x0000, 0x5dab, 0x5dac,
0xebae, 0x0000, 0x0000, 0xcdda, 0x51d9, 0x0000, 0xd5ad, 0xd2fb,
0x56ed, 0x0000, 0xcdd7, 0xcdd4, 0xdcbf, 0xd3d9, 0xcced, 0x0000,
0xccee, 0xccea, 0xcce9, 0x0000, 0xd9d5, 0x0000, 0xb3f0, 0xb1c8,
0xe6fe, 0xcceb, 0xb1d5, 0xb0ec, 0xd4e5, 0xb0e5, 0xcdac, 0x0000,
0xb0cd, 0xb0cb, 0xb0e1, 0x0000, 0xb0d0, 0x0000, 0xb0dc, 0x0000,
0x56a1, 0xb5bf, 0xddeb, 0xb5b9, 0xd5a9, 0xd7b3, 0xb0d8, 0x0000,
0xd0e1, 0xd6e1, 0xb2b5, 0xe2e3, 0xb0ca, 0x0000, 0xcdde, 0xb0d7,
0xcdb8, 0xd6a8, 0x0000, 0xccf2, 0xb2b2, 0xb0ef, 0xe6e7, 0xb1d6,
0xcbf2, 0xeae3, 0xb0d5, 0xb5a3, 0x0000, 0x0000, 0xb1d7, 0xb0ee,
0x0000, 0x0000, 0x0000, 0x0000, 0x3cdc, 0xcde3, 0xcde2, 0x0000,
0xe8a1, 0x0000, 0xb0f8, 0xddd6, 0xb2bb, 0x0000, 0xb0f9, 0xb6e3,
0x0000, 0xb0fc, 0xc6d2, 0x0000, 0xd5fa, 0xb0fa, 0x0000,
	/* 0xd340 */
0x0000, 0x0000, 0x0000, 0x5dad, 0xebb0, 0xcdf7, 0x0000, 0xebaf,
0xbfc6, 0x0000, 0xebb1, 0x0000, 0x0000, 0xebb2, 0x5dae, 0x0000,
0xebb3, 0xb4d1, 0x5daf, 0x5db0, 0x5db1, 0x5db2, 0x0000, 0x0000,
0xebb4, 0x0000, 0x5db3, 0xebb5, 0x0000, 0xebb6, 0xebb7, 0x0000,
0x0000, 0x0000, 0x5db4, 0x5db5, 0x5db7, 0x5db8, 0x0000, 0x0000,
0xebba, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xebbb, 0x0000,
0x5dba, 0x0000, 0x0000, 0x5dbc, 0x0000, 0x0000, 0x5dbd, 0x0000,
0xebbc, 0x0000, 0x5dbf, 0x0000, 0xebbd, 0x5dc0, 0x0000, 0x0000,
0x0000, 0x0000, 0x5dc1, 0x0000, 0x5dc2, 0x0000, 0xc4fb, 0xebbe,
0x5dc3, 0x5dc4, 0x0000, 0xb7d7, 0x0000, 0xbfd6, 0x0000, 0xebc1,
0x0000, 0xc6a4, 0x5dc6, 0xebc0, 0x5dc7, 0x5dc8, 0xb7b1, 0x5dc9,
0x5dca, 0xebbf, 0xc2f7, 0xb5ad, 0x0000, 0x0000, 0xebc2, 0x0000,
0xebc3, 0xb0f5, 0xb1d1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb7de, 0x0000, 0xb1ce,
0xb1c6, 0x0000, 0xb9c5, 0xb1c7, 0x0000, 0x0000, 0x30f1, 0x56d6,
0x0000, 0xcdc7, 0xf0b6, 0xcdd9, 0xe9ec, 0xd2e9, 0xb1cb, 0xcdb0,
0xb1ca, 0x3dec, 0xcda6, 0xcdd1, 0xcda9, 0x0000, 0xcdaa, 0x0000,
0xcce0, 0xcdb3, 0x0000, 0x0000, 0xe0bb, 0xccfd, 0xdee2, 0xc6d3,
0xcdad, 0xcda7, 0xb1a6, 0xcda4, 0xeed8, 0x0000, 0xcbf4, 0xcdc4,
0xb1aa, 0xdecb, 0xd0b2, 0xe2b3, 0x0000, 0xb6f3, 0xb6f2, 0x0000,
0xcdbe, 0x0000, 0xeea7, 0x0000, 0xccfb, 0xdee1, 0x0000, 0xb6f9,
0xcdbd, 0x0000, 0xb1ab, 0xcdbf, 0x0000, 0xe3bb, 0xb1a7, 0x0000,
0xb1a9, 0xb6cc, 0xb0e8, 0xb0f2, 0xb0ea, 0xd2de, 0xb6f8, 0x0000,
0xd6bb, 0xb8e6, 0xccfc, 0xcddf, 0x0000, 0xb0e9, 0xcdc0,
	/* 0xd440 */
0x5dcb, 0xbed9, 0x5dcc, 0x0000, 0x5dcd, 0xb7ed, 0x5dce, 0xebc4,
0x5dcf, 0x0000, 0x0000, 0x0000, 0xcbac, 0x5dd0, 0x5dd1, 0xc0df,
0x0000, 0x5dd2, 0x0000, 0xb5f6, 0x0000, 0xccf5, 0xc1ca, 0x5dd3,
0xebc5, 0x5dd4, 0x0000, 0x0000, 0xbfc7, 0xc3f0, 0xbeda, 0x5dd5,
0x0000, 0x5dd7, 0xebc6, 0x0000, 0x5dd8, 0x0000, 0x5dd9, 0xebc9,
0x5dda, 0x5ddb, 0x0000, 0x0000, 0x0000, 0x5ddc, 0x5ddd, 0x0000,
0xbabe, 0xc2c2, 0xebc8, 0x5dde, 0xbedb, 0xc9be, 0x5ddf, 0x5de0,
0x5de1, 0x0000, 0x0000, 0xebc7, 0x5de2, 0x5de3, 0xbbec, 0x0000,
0x0000, 0xb1d3, 0x5de4, 0xebce, 0xb7d8, 0x0000, 0x5de5, 0xbbee,
0x5de6, 0x0000, 0xbbed, 0x0000, 0xcfcd, 0xebcd, 0xebcc, 0xc1a7,
0x0000, 0xb5cd, 0xcfc3, 0xb3ba, 0xbedc, 0x0000, 0x5de7, 0x5de8,
0x5de9, 0x0000, 0x5deb, 0x5dec, 0xebcb, 0x0000, 0x5ded, 0x5dee,
0x5def, 0xcde1, 0xb6f7, 0xcdb5, 0x0000, 0xd0ae, 0x0000, 0x0000,
0xdebd, 0xd1cd, 0xb8b5, 0xb3c0, 0xeacf, 0xb8b6, 0xb1e7, 0x0000,
0x36fe, 0x0000, 0x0000, 0xb1ee, 0xb8bb, 0x0000, 0x0000, 0xb1f1,
0xd8c5, 0xb1e5, 0xb1a1, 0xdba9, 0x0000, 0xb1db, 0x0000, 0x0000,
0xb3d9, 0xe4e5, 0xb7ee, 0xb1d9, 0x0000, 0xe6d1, 0xb1be, 0x0000,
0x33fb, 0x0000, 0xb0f4, 0x61bd, 0x0000, 0x0000, 0x0000, 0xf0f1,
0xd5d4, 0xc1d9, 0x0000, 0x0000, 0xbacf, 0xbac8, 0x49c8, 0xbacb,
0x0000, 0xbac6, 0xbadf, 0x35b3, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xc1f2, 0xc1f8, 0xc1ec, 0x0000, 0xc1f4, 0x0000, 0xc1e1,
0xdfb6, 0xc7c2, 0xedaf, 0xd3e4, 0xc2a4, 0x0000, 0x49c7, 0xc1e7,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd7e3, 0x0000, 0xc1fe,
0xc1bd, 0x0000, 0xd9a9, 0x0000, 0xded6, 0xbba5, 0x0000,
	/* 0xd540 */
0x0000, 0xebd0, 0x5df0, 0xebd1, 0xebcf, 0x5df1, 0xb8d8, 0x0000,
0x5df2, 0xbbef, 0xc7a7, 0x0000, 0x5df3, 0x5df4, 0xebd4, 0x5df5,
0x0000, 0xc3c2, 0x5df6, 0x5df7, 0xcdb6, 0x5df8, 0xebd7, 0x0000,
0x0000, 0x0000, 0xb8ec, 0x5df9, 0xc0bf, 0xebd3, 0x0000, 0xebd8,
0xb8ed, 0xebd5, 0xebd6, 0x5dfa, 0xebd2, 0x5dfb, 0x0000, 0x0000,
0xc0e2, 0xc6c9, 0x5dfc, 0x5dfd, 0xc3af, 0x0000, 0xb2dd, 0x5dfe,
0x0000, 0x0000, 0x5ea1, 0x5ea2, 0x0000, 0xc8f0, 0x0000, 0x5ea3,
0xb5c3, 0x0000, 0x5ea4, 0xc4b4, 0x0000, 0x0000, 0xebdb, 0x0000,
0x5ea5, 0xebd9, 0x0000, 0x5ea6, 0xc3cc, 0x5ea7, 0x5ea8, 0x5ea9,
0xc0c1, 0xb4d2, 0xebda, 0x0000, 0xbfdb, 0x0000, 0x5eaa, 0xceca,
0x5eab, 0x5eac, 0x5ead, 0xcfc0, 0x5eae, 0x0000, 0x0000, 0xebdc,
0xebe7, 0xc4b5, 0x5eaf, 0xebe6, 0x5eb0, 0xebe3, 0xebeb, 0xebe4,
0x0000, 0x0000, 0x0000, 0x4ee6, 0x0000, 0x44dd, 0xbaf0, 0xc6e3,
0xdfda, 0x0000, 0xc5a6, 0x0000, 0xc2f0, 0xbaf5, 0x0000, 0xdccd,
0xe2dd, 0x46ba, 0x5dea, 0xc7b4, 0xddfe, 0x0000, 0x0000, 0x0000,
0x0000, 0xc5b8, 0x5ab2, 0x0000, 0xc0ea, 0x0000, 0xe3eb, 0xc3b9,
0x0000, 0xbec0, 0xbecf, 0xbeb4, 0x48cf, 0x0000, 0xbeb8, 0x0000,
0xbef3, 0xbee6, 0x0000, 0x0000, 0xd0bf, 0x0000, 0xe1ef, 0xbee3,
0xbeb7, 0xbebc, 0xd9b2, 0xbec2, 0x0000, 0xbec8, 0xe6ad, 0xc3fb,
0xc8a5, 0xbea4, 0xbcd7, 0xc0de, 0xc5af, 0x0000, 0x0000, 0xbcd4,
0x0000, 0xe8f4, 0x0000, 0xdeb6, 0xc4c1, 0xdad0, 0xbfbf, 0xe1ab,
0xb5ce, 0xe7cb, 0x0000, 0x0000, 0x0000, 0xcbed, 0xbfbe, 0x0000,
0xbfcc, 0xbfb6, 0x0000, 0x0000, 0xbef8, 0x0000, 0x0000, 0xc0ac,
0x0000, 0xc1e8, 0x3dd5, 0xc0b0, 0xd9ce, 0xc0b5, 0xc0af,
	/* 0xd640 */
0xebe0, 0x0000, 0xc4fc, 0xebdf, 0x0000, 0x0000, 0x0000, 0xebdd,
0x5eb1, 0xcda1, 0xbbf0, 0x0000, 0x5eb2, 0xebe1, 0x0000, 0xebde,
0x5eb3, 0x5eb4, 0x5eb5, 0xebe5, 0xbdf4, 0x0000, 0xb8c1, 0x0000,
0x5eb6, 0x0000, 0xc2fa, 0x5eb7, 0xcbc5, 0xb1da, 0xb0e2, 0x0000,
0xc6a5, 0x5eb8, 0x5eb9, 0x0000, 0x0000, 0x5ebf, 0x5eba, 0xebe8,
0x0000, 0xc6e6, 0x0000, 0xebed, 0x5ebb, 0x0000, 0x0000, 0xebe2,
0x0000, 0xebec, 0xebee, 0x0000, 0xb8ac, 0xebea, 0xb9d6, 0x5ebc,
0xbcd5, 0x5ebd, 0x5ebe, 0xebef, 0xcdd8, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xebf5, 0x0000, 0x0000, 0xebf3, 0xc9b5,
0x5ec0, 0x0000, 0x0000, 0x5ec1, 0x0000, 0x0000, 0xebf0, 0x0000,
0x0000, 0x0000, 0x5ec2, 0x0000, 0xb6e0, 0x0000, 0x0000, 0x5ec3,
0x0000, 0xebf4, 0x0000, 0x0000, 0xebf6, 0x5ec4, 0x5ec5, 0x5ec6,
0x5ec7, 0x0000, 0xbec9, 0x0000, 0x0000, 0xbcc7, 0xbbde, 0xbbd9,
0x34ec, 0xc3d8, 0xc3ce, 0xbbe8, 0xbbe9, 0xbdc1, 0xc7b7, 0x0000,
0x0000, 0xc4be, 0xbfa2, 0xbfa3, 0x0000, 0x0000, 0x30fe, 0xd4ae,
0xbbd8, 0xbbdf, 0xece6, 0xc2fe, 0xbbdd, 0x0000, 0xbbd6, 0x0000,
0x0000, 0xbbea, 0xc3d7, 0xc3d6, 0x0000, 0xd6b5, 0xc0a9, 0xc3d2,
0xc3e1, 0xc3d5, 0x0000, 0xdfd5, 0xbca6, 0xc2da, 0xbca3, 0xc3e2,
0xc3e6, 0x4eca, 0xc3e9, 0x0000, 0xc3ef, 0x0000, 0x0000, 0x0000,
0xbdc5, 0xc3e7, 0x30db, 0xbdae, 0xbcfe, 0xbda3, 0xbda7, 0x0000,
0xb4a1, 0x0000, 0xc9aa, 0xd6e4, 0xd2f0, 0x0000, 0xc3e8, 0xc3eb,
0x0000, 0xbcee, 0xb3f4, 0xe9e1, 0xbceb, 0xc3f6, 0x0000, 0x0000,
0xc3e0, 0xc3dd, 0x0000, 0xbcd1, 0x3fd1, 0x0000, 0xbefc, 0xbce7,
0xc3f8, 0xc3ec, 0xbdf5, 0x5adf, 0x0000, 0x0000, 0xc3de,
	/* 0xd740 */
0x5ec8, 0x0000, 0x5ec9, 0xebfa, 0x0000, 0x0000, 0xebf7, 0x5ece,
0xebf9, 0xebf8, 0x0000, 0x0000, 0x5eca, 0x5ecb, 0x5ecc, 0x0000,
0xebfb, 0x0000, 0xbcb1, 0x5ecd, 0xebfd, 0xebfc, 0xc9e8, 0x0000,
0x5ecf, 0xeca1, 0x0000, 0x0000, 0x0000, 0x5ed0, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xebfe, 0x5ed1, 0x0000, 0xeca3,
0xb5c4, 0xe6c1, 0xbef9, 0x0000, 0xeca4, 0x0000, 0x5ed2, 0xb8ee,
0x5ed3, 0x5ed4, 0x0000, 0x0000, 0x5ed5, 0xeca5, 0x5ed6, 0x0000,
0xeca6, 0x5ed7, 0x0000, 0xbbbe, 0x5ed8, 0x5ed9, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xdace, 0x5eda, 0xeca7, 0x5edb, 0xeca8,
0x5edc, 0xbdb2, 0x0000, 0xeca9, 0xecaa, 0x5edd, 0x5ede, 0xecab,
0x0000, 0x0000, 0xecac, 0xecad, 0x0000, 0x5edf, 0x0000, 0x5ee0,
0x5ee1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xbdbb, 0xc3ed, 0xbdcb, 0x0000, 0xd9b4, 0xc4de, 0x3fda,
0x0000, 0x0000, 0x0000, 0xc0f1, 0x0000, 0xe4bf, 0x0000, 0xbeb1,
0xc1f5, 0x0000, 0xc6b5, 0xc1d4, 0xbef5, 0xc4c7, 0x0000, 0xc4c9,
0x0000, 0x0000, 0x0000, 0x0000, 0xbdda, 0xc2aa, 0xc0db, 0xc2ee,
0x43db, 0xc2f6, 0x57de, 0xbce0, 0xc2ef, 0xc3e5, 0xbcde, 0x0000,
0x0000, 0xd2fe, 0x0000, 0xbbd1, 0xbca2, 0x47d5, 0xbbda, 0xbbe7,
0xbbc6, 0x53ab, 0xdee8, 0xbbd2, 0xbcab, 0x0000, 0xbbfa, 0x69fe,
0xdca3, 0xeda9, 0xbda1, 0x0000, 0x0000, 0x0000, 0x0000, 0xc1f6,
0xc1d5, 0x0000, 0xc1c5, 0xc2ad, 0xc2b4, 0xc2b2, 0xc1c4, 0x0000,
0xc1cb, 0x0000, 0x0000, 0xbbbc, 0xd3dc, 0xeecd, 0xbac7, 0xbae1,
0xc2ba, 0xbde5, 0xbaf2, 0xbab8, 0xbab4, 0xdbd0, 0xd0f6, 0xbaee,
0xbac1, 0xbac2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xd840 */
0x5ee2, 0x5ee3, 0xecae, 0x0000, 0x0000, 0x5ee4, 0x5ee5, 0xecb0,
0x0000, 0x0000, 0x0000, 0x0000, 0x5ee6, 0xecb1, 0xcbad, 0x5ee9,
0x0000, 0xecb3, 0x5eea, 0xecb4, 0x5eeb, 0x0000, 0x5eec, 0x5eed,
0x0000, 0x5eee, 0x5eef, 0x5ef2, 0x5ef0, 0x0000, 0x5ef1, 0x0000,
0x0000, 0x0000, 0x5ef3, 0x5ef4, 0x0000, 0x5ef5, 0x0000, 0x5ef6,
0x5ef7, 0xecb7, 0x5ef8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x5efa, 0x5efb, 0x0000, 0x5efc, 0xecc1, 0x0000, 0x5efd,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5efe, 0x5fa1, 0x0000,
0x0000, 0x5fa2, 0xecbe, 0xecbf, 0x0000, 0x5fa3, 0x0000, 0x5fa4,
0x5fa5, 0x0000, 0x0000, 0x0000, 0x5fa6, 0x0000, 0x5fa7, 0x5fa8,
0xb3ad, 0xc4e7, 0x0000, 0xc9e9, 0xbae2, 0xb9d7, 0x0000, 0x5fa9,
0x0000, 0x0000, 0xc9cf, 0xb2df, 0xc8ce, 0xecc5, 0xb4d3, 0xc0d5,
0xecc4, 0x30bd, 0x30a4, 0xd1ba, 0xd0a2, 0xc6fb, 0xd2c1, 0xd0a3,
0xcfcb, 0xbee7, 0xf2af, 0x0000, 0x36ce, 0x30a9, 0xe3bc, 0xd0a8,
0xd2b8, 0x30b2, 0xd4f0, 0xe0ab, 0xd2c8, 0x46c9, 0x36f5, 0xb0fd,
0xf1c4, 0xddda, 0xe2d0, 0x6dac, 0xd0a6, 0xd0b4, 0x6da7, 0x30b5,
0x30b8, 0x0000, 0x0000, 0xd5d6, 0x0000, 0x36af, 0xd0bc, 0x0000,
0x34ca, 0x0000, 0xd2d0, 0xd2d1, 0x0000, 0x0000, 0xd2b9, 0x34e3,
0x0000, 0x0000, 0x34b5, 0x0000, 0xb7b5, 0x34bc, 0x33b1, 0xb4a2,
0xd1e6, 0x0000, 0xd1ea, 0x0000, 0x0000, 0xd1ef, 0xd1f0, 0x33c7,
0x33c4, 0x58f2, 0xd1f7, 0x33ce, 0x0000, 0x0000, 0x33d2, 0xd1c4,
0xe6a8, 0x0000, 0x30c3, 0x0000, 0xd0be, 0x30ca, 0x30c8, 0x0000,
0xd0c0, 0x0000, 0x30cd, 0x0000, 0x0000, 0x30ce, 0x0000, 0x0000,
0xd0c4, 0x0000, 0xd5a4, 0x0000, 0xdac1, 0xd0c5, 0xd0c8,
	/* 0xd940 */
0xecc9, 0xc3f9, 0xcce3, 0x0000, 0xecc7, 0xecc8, 0xb5ae, 0x0000,
0xecca, 0xc7e3, 0xc2df, 0x5faa, 0x5fab, 0xc8f1, 0xc5bd, 0xecc6,
0x0000, 0xcbc7, 0xb2ec, 0xeccc, 0xcfa8, 0xc4c2, 0xcfc5, 0x5fac,
0x5fad, 0xbbf1, 0xeccb, 0x5fae, 0xc2b1, 0x5faf, 0x0000, 0xecdc,
0xc1a8, 0x5fb0, 0x0000, 0xc6f8, 0x0000, 0xc9d0, 0x0000, 0x5fb2,
0x5fb1, 0x0000, 0x0000, 0x5fb3, 0xeccf, 0xbbbf, 0xbbf2, 0x5fb4,
0xbede, 0x0000, 0xc7e5, 0x5fb5, 0xb8ad, 0xecce, 0xeccd, 0x0000,
0xc9ea, 0x0000, 0x5fb6, 0x0000, 0xbcc1, 0x0000, 0x5fb7, 0x0000,
0xc5d2, 0x0000, 0x5fb8, 0x5fb9, 0x0000, 0x5fba, 0x0000, 0x0000,
0x5fbb, 0x0000, 0x5fbc, 0x5fbd, 0x0000, 0xecd1, 0xecd2, 0xb9d8,
0xecd0, 0x5fbe, 0x5fbf, 0x0000, 0x5fc0, 0x0000, 0x5fc1, 0xecd3,
0xecd4, 0x0000, 0xecd6, 0xc2a3, 0x5fc2, 0xecd5, 0xb4e6, 0x0000,
0xecd8, 0x30f0, 0xd0c9, 0x0000, 0xb2c0, 0xd0cb, 0x0000, 0xd0d2,
0x31a2, 0xb4a6, 0xd0cd, 0x30fb, 0xd0cf, 0x0000, 0xb8f3, 0x0000,
0x31a9, 0x0000, 0x0000, 0x0000, 0x31b8, 0xd0dd, 0xcbf3, 0x31c1,
0xd0dc, 0xd0d8, 0xcaf0, 0xd0ea, 0x31e5, 0xc7d0, 0xd0eb, 0xe0c7,
0x31da, 0xcfc1, 0xd0ec, 0x31d5, 0x31ce, 0xd0e5, 0xd0e2, 0x0000,
0xd0f0, 0xd0f3, 0xd0f5, 0x31e6, 0xd0f8, 0x0000, 0x0000, 0x0000,
0x0000, 0x32b0, 0xd1a5, 0x32ca, 0xd1a8, 0x0000, 0x32c1, 0xd1aa,
0x32cb, 0x32cd, 0xa1b8, 0x0000, 0x30ef, 0x0000, 0xd0d9, 0xf3fe,
0x0000, 0x0000, 0xd1c2, 0xc3a7, 0x0000, 0xf1c5, 0x0000, 0x38e5,
0xd2b1, 0xd2b5, 0x5dc5, 0xd2b6, 0x0000, 0xbdc8, 0x32e9, 0xd0b5,
0x0000, 0xd0b8, 0x0000, 0xeadd, 0x0000, 0x0000, 0x5ccb, 0xe3c9,
0x3ab2, 0x5be9, 0xe6c0, 0xd1d2, 0xd1d4, 0xd1d8, 0x32fb,
	/* 0xda40 */
0x0000, 0xecd7, 0xecd9, 0x0000, 0x5fc3, 0xecdb, 0xecdd, 0x0000,
0xecde, 0x5fc4, 0x0000, 0x0000, 0x0000, 0x5fc5, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x5fc6, 0x0000, 0x5fc7, 0x0000,
0x5fc8, 0x5fc9, 0x0000, 0xece1, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x5fca, 0x0000, 0x5fcb, 0x0000,
0x0000, 0x0000, 0x5fcd, 0x0000, 0x0000, 0x5fce, 0x0000, 0x0000,
0x5fcf, 0x0000, 0x0000, 0x5fd1, 0x0000, 0x0000, 0x0000, 0xece4,
0x0000, 0x0000, 0x0000, 0x0000, 0x5fd2, 0x5fd4, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x5fd5, 0x0000, 0xbff6, 0x0000, 0x0000,
0x5fd6, 0x5fd7, 0x0000, 0x0000, 0x5fd8, 0x0000, 0x5fd9, 0x0000,
0x5fdb, 0x5fdc, 0x5fdd, 0x0000, 0x5fde, 0x0000, 0xece5, 0x5fdf,
0x5fe1, 0x5fe2, 0x0000, 0x5fe3, 0x0000, 0x0000, 0x0000, 0x0000,
0x5fe6, 0x0000, 0xd1cc, 0xd1cf, 0xccbd, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xd2c7, 0x0000, 0x66c4, 0x66c6, 0xeff4, 0x66cb, 0xbae5, 0x66d2,
0x66d1, 0xeff8, 0x0000, 0x66d5, 0xf0a2, 0x0000, 0xf0a5, 0xf0a4,
0x66db, 0xb7a8, 0xf0a6, 0xf0a9, 0xf0ae, 0x61ee, 0x61f1, 0x0000,
0x61f0, 0x0000, 0x61f3, 0x61f9, 0x61f8, 0x61fa, 0x0000,
	/* 0xdb40 */
0x5fe7, 0x0000, 0x5fe9, 0x0000, 0x0000, 0xc0d7, 0x0000, 0x5feb,
0x0000, 0x5fec, 0x0000, 0x0000, 0x0000, 0x5fee, 0x5ff0, 0x5ff1,
0x5ff2, 0x0000, 0xecf2, 0x0000, 0xecf5, 0x0000, 0x5ff4, 0x0000,
0x0000, 0x5ff5, 0x5ff7, 0x0000, 0xecf3, 0x5ff8, 0x0000, 0x0000,
0xecf8, 0x5ff9, 0x0000, 0x0000, 0x0000, 0x5ffb, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x5ffc, 0x5ffd, 0x0000, 0x0000,
0x60a2, 0x60a3, 0x0000, 0x0000, 0x0000, 0xecfc, 0x0000, 0x60a5,
0xecfd, 0x60a6, 0x60a7, 0x60a8, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xeda3, 0x60ae, 0x60af, 0x60b0,
0xeda4, 0x0000, 0x60b1, 0xedab, 0x0000, 0x0000, 0x0000, 0x0000,
0x60b2, 0x60b3, 0x60b4, 0x60b5, 0xc0d8, 0xeda8, 0x60b6, 0x60b7,
0xedaa, 0xeda7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x60bd, 0xc5a1, 0x61f6, 0x0000, 0x62a2, 0x61fd, 0x0000, 0x62a1,
0x62a3, 0x0000, 0x0000, 0xeebb, 0x62a9, 0x62a6, 0xeebe, 0x62af,
0x62b0, 0x62b3, 0x62b6, 0x62c5, 0x62c2, 0x62c6, 0x62cb, 0x62ca,
0x62cf, 0x62d3, 0x0000, 0x0000, 0x0000, 0x0000, 0xd2a2, 0xd2a3,
0xb3af, 0x35c4, 0x0000, 0x33ed, 0x33f6, 0xd2d7, 0xd2d9, 0xe2df,
0xd7ae, 0xd1e1, 0x0000, 0xf2ae, 0xd2d3, 0xcadb, 0xe1bd, 0x0000,
0x37be, 0x37e3, 0x37df, 0xbdce, 0x38d0, 0xd4d9, 0xd4db, 0x37b2,
0x37b4, 0x37b3, 0x37b7, 0x0000, 0x37b5, 0x37b6, 0x0000, 0xd4ad,
0xbae4, 0xd4b0, 0x0000, 0x37c5, 0x0000, 0x37d2, 0x37d1, 0x37c4,
0x37c6, 0x0000, 0x37cb, 0x0000, 0xd4b9, 0x37d6, 0x0000, 0x37ea,
0x37e1, 0x0000, 0xd4b6, 0xd4b7, 0x37eb, 0x0000, 0x0000, 0x0000,
0xd4bf, 0x37e5, 0xbefd, 0x0000, 0x37f6, 0x37ee, 0x37ec,
	/* 0xdc40 */
0x0000, 0x0000, 0x0000, 0x0000, 0x60be, 0x60bf, 0x60c0, 0x0000,
0x0000, 0x0000, 0x60c1, 0x60c2, 0xedb2, 0x0000, 0x0000, 0x60c3,
0xedb4, 0xedb3, 0x0000, 0xccf6, 0x0000, 0xedb6, 0x60c5, 0xedb5,
0x60c6, 0x0000, 0x0000, 0x0000, 0xedb8, 0x60c7, 0x60c8, 0x60c9,
0x0000, 0x0000, 0xedba, 0x60cb, 0x0000, 0x0000, 0x0000, 0x0000,
0x60cc, 0x0000, 0x60cd, 0xedb9, 0x60ce, 0x60cf, 0xedbc, 0xedbe,
0x60d0, 0x0000, 0x60d1, 0x0000, 0x0000, 0x0000, 0x0000, 0x60d3,
0x0000, 0x0000, 0xedbf, 0x0000, 0x60d4, 0x60d5, 0x0000, 0x0000,
0x60d6, 0x60d7, 0xedc0, 0xedbd, 0x60d8, 0xedc1, 0x0000, 0xbcd6,
0xedc2, 0xb5b0, 0xb7b3, 0x60d9, 0x0000, 0x60da, 0xb8ae, 0x0000,
0x60db, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xedc3,
0x60dc, 0x0000, 0x0000, 0xc6f0, 0x0000, 0x0000, 0xc5be, 0xedc4,
0x0000, 0xd4c4, 0x38a2, 0x37f7, 0x37f2, 0xcbd9, 0x38a4, 0xd4c5,
0x0000, 0x38a6, 0x0000, 0x0000, 0x38bc, 0x38bf, 0x0000, 0x38bb,
0xb3be, 0x6dad, 0xd8f4, 0x0000, 0x57ad, 0x57ae, 0x0000, 0x57b5,
0x57c2, 0x57b2, 0x57b6, 0x57b7, 0x0000, 0xc9e7, 0xe7eb, 0xb7dd,
0x57cc, 0x57c6, 0x0000, 0x0000, 0xe7f0, 0x57ba, 0x57c9, 0x57c5,
0x0000, 0x0000, 0x0000, 0x57c3, 0x57c8, 0x57be, 0x57c4, 0xe7ec,
0x0000, 0x0000, 0x57c0, 0xe7ef, 0xe7fd, 0x57da, 0x57d4, 0x0000,
0x57df, 0xe7fc, 0xe7f3, 0xe7f2, 0x0000, 0x0000, 0xe7f8, 0xceea,
0x0000, 0x0000, 0xe7fb, 0x0000, 0x0000, 0x57d2, 0x57d0, 0xb0ab,
0x57f9, 0x0000, 0x0000, 0x57e0, 0x58a8, 0x57f1, 0xe8a2, 0xe8a5,
0x58ad, 0x0000, 0xe8aa, 0xb1c1, 0x57f6, 0x57f4, 0x0000, 0xe8a6,
0xe8ac, 0x0000, 0x57eb, 0x57f0, 0x57ee, 0x0000, 0x0000,
	/* 0xdd40 */
0x0000, 0x0000, 0x0000, 0x60dd, 0x0000, 0x0000, 0xedc7, 0x0000,
0x60e4, 0x60de, 0x0000, 0x60df, 0x60e0, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x60e1, 0xbcb4, 0x60e2, 0x60e3, 0xedc6, 0xedc5,
0xb7da, 0xedc8, 0x0000, 0x60e5, 0x0000, 0x60e6, 0xb3d3, 0x0000,
0xedca, 0x0000, 0x60e7, 0x60e8, 0xbadc, 0xedc9, 0x0000, 0xedd2,
0x0000, 0x0000, 0x60e9, 0x60ea, 0x0000, 0xedcc, 0xedce, 0xcae5,
0xedcb, 0x60eb, 0x60ec, 0x60ed, 0xedcd, 0x0000, 0xedd1, 0xedcf,
0xb5b1, 0x60ee, 0xedd0, 0x60ef, 0x60f0, 0x0000, 0x60f1, 0x0000,
0x0000, 0x60f2, 0xedd3, 0x60f3, 0x60f4, 0xc7da, 0xced8, 0x0000,
0x60f5, 0x60f6, 0x60f7, 0xbdb4, 0x0000, 0x0000, 0x0000, 0xedd4,
0x60f8, 0x60f9, 0x60fa, 0x60fb, 0xcda2, 0xedd6, 0x60fc, 0xedd5,
0x0000, 0x0000, 0xedd9, 0xcdc1, 0x60fd, 0x60fe, 0xedd8, 0x61a1,
0xb3ed, 0x0000, 0x57e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x57fe, 0x0000, 0x0000, 0xe8bc, 0xe8b0, 0xe7f6, 0x58ae,
0xe8ae, 0xe8b8, 0x0000, 0x58b2, 0x58a1, 0x0000, 0xb2ae, 0x58ab,
0xb4d0, 0xe8be, 0x0000, 0x0000, 0xe8c7, 0x58c5, 0x0000, 0xe8c5,
0x0000, 0x0000, 0xe8c6, 0x58bd, 0xe8c3, 0xbed4, 0x0000, 0xe8d0,
0x58c9, 0x58c6, 0x58bc, 0xc5d1, 0x58c8, 0xe8c4, 0x58c2, 0x58c3,
0x58c0, 0xbffb, 0x58b6, 0x0000, 0xb8d6, 0x0000, 0x58db, 0x58d5,
0x58da, 0x58d9, 0x58e2, 0x0000, 0x0000, 0xc9f8, 0x0000, 0x58e5,
0xe8d5, 0xe8de, 0xe8dd, 0x58e4, 0x0000, 0x0000, 0xb3fe, 0xe8d3,
0xe8ed, 0xe8e9, 0xe8ec, 0x0000, 0x58f6, 0x58fe, 0xe8e3, 0xe8e6,
0x58f5, 0x0000, 0xe8f0, 0xe8e5, 0x58f4, 0x0000, 0x0000, 0x0000,
0x59b0, 0xe1b0, 0x0000, 0x59a5, 0x0000, 0xe8f7, 0x0000,
	/* 0xde40 */
0xedd7, 0xeddc, 0x61a2, 0x0000, 0xeddb, 0x0000, 0x0000, 0xedda,
0xc5b2, 0xeddd, 0x61a3, 0x0000, 0x61a4, 0x61a5, 0x61a6, 0x61a7,
0x61a8, 0x0000, 0xedde, 0x61a9, 0x0000, 0x0000, 0x0000, 0xeddf,
0x61aa, 0x61ab, 0xb9ec, 0x0000, 0xb7a5, 0xede0, 0xede1, 0xede2,
0x61ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x61ad, 0x61ae, 0x61af,
0x0000, 0x61b0, 0x61b1, 0x61b2, 0xd2a1, 0x0000, 0x0000, 0xede6,
0xe5f0, 0xede7, 0xc7c0, 0x0000, 0x0000, 0x61b3, 0xede8, 0x61b5,
0xcad5, 0xc4d4, 0xb9fe, 0xc3a9, 0x61b7, 0x0000, 0x61b9, 0x0000,
0x0000, 0x61ba, 0x61bb, 0x0000, 0x61bc, 0x0000, 0x61be, 0x0000,
0x0000, 0xede9, 0x61c1, 0x0000, 0x61c2, 0x0000, 0x0000, 0xeded,
0x61c6, 0x0000, 0xedef, 0x61c7, 0x61c8, 0xedf2, 0x61c9, 0x0000,
0x61ca, 0x0000, 0x0000, 0x61cd, 0x61ce, 0xeea5, 0xc4fe, 0xedf4,
0x61cf, 0x59c7, 0x0000, 0xe8f2, 0xe8fa, 0x59c8, 0xe8fe, 0xcfcf,
0x59d0, 0x59cb, 0x59d4, 0x4fb4, 0xc8d9, 0x0000, 0x59d5, 0xe9a6,
0xe9aa, 0xe9af, 0x59de, 0x59d3, 0xccf9, 0xe9b0, 0x59d9, 0xe9b7,
0x59e9, 0x0000, 0x0000, 0xcfce, 0xe9bc, 0x5aa1, 0x5aaf, 0x5aa4,
0x5ab0, 0xddb1, 0x5ab4, 0xd7b0, 0x3cdf, 0x0000, 0x0000, 0x55dd,
0xd4f5, 0xd4f8, 0xd4f9, 0xd2b7, 0xd5f7, 0x0000, 0x3af1, 0x0000,
0x3fb7, 0x0000, 0x0000, 0xd9bb, 0xd9c3, 0x3fd5, 0xd9b9, 0xd9c9,
0x0000, 0xbba2, 0x3fe9, 0x3ff1, 0x3fed, 0x40b1, 0xd9e8, 0x3ffc,
0xc6e8, 0xd9d6, 0xc4cf, 0x3ffb, 0xb5c5, 0x40a8, 0xd9e0, 0x40b2,
0x0000, 0x40c2, 0x40c5, 0x40be, 0x0000, 0xd9e9, 0x0000, 0x40b8,
0x40dc, 0xd9e4, 0xd9e1, 0x0000, 0x0000, 0x0000, 0x0000, 0x40ce,
0x0000, 0xd9ee, 0x0000, 0x0000, 0x0000, 0x40e7, 0x0000,
	/* 0xdf40 */
0xc7e7, 0x0000, 0xcfa2, 0x0000, 0x0000, 0xedfa, 0x61d1, 0x61d2,
0x61d4, 0x0000, 0x61d5, 0x0000, 0xbdb5, 0xbfca, 0x61d7, 0x61d8,
0x61d9, 0xedfd, 0x0000, 0x0000, 0x61da, 0x0000, 0x61db, 0xc3d9,
0x0000, 0x0000, 0xeea6, 0xcdb7, 0xb1bf, 0x61dd, 0xb2e1, 0xc3a3,
0xb0e3, 0xeea8, 0xf4a3, 0x0000, 0xc2bd, 0x61df, 0xeeaa, 0x0000,
0xb1f3, 0xc1cc, 0x0000, 0x61e1, 0x61e2, 0xc5ac, 0x0000, 0x0000,
0x61e3, 0xeeac, 0x61e4, 0x0000, 0xeeaf, 0x0000, 0xeead, 0xc1ab,
0xc1aa, 0x61e6, 0xb0e4, 0x0000, 0xcecb, 0x0000, 0xeeb2, 0x0000,
0xb4d4, 0x61e7, 0x0000, 0xedee, 0xeeb5, 0xeeb4, 0x61ea, 0x0000,
0x61eb, 0xeeb6, 0x61ec, 0x0000, 0x0000, 0x0000, 0x61ef, 0x0000,
0x0000, 0x0000, 0x0000, 0x61f2, 0x0000, 0x61f5, 0x0000, 0xeeb7,
0x0000, 0x0000, 0x0000, 0x61f7, 0x0000, 0x0000, 0x61fb, 0x0000,
0x0000, 0xc0a2, 0x0000, 0x0000, 0x40f2, 0x0000, 0x0000, 0x41a7,
0x41aa, 0x41ab, 0xc5a7, 0x41b8, 0x0000, 0x41c5, 0xd7b5, 0x3dbf,
0x0000, 0xd7b6, 0x0000, 0xbcb8, 0x0000, 0xc3a1, 0xd2db, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x34ef, 0x34e7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xd2ee, 0xd2ed, 0x34f6, 0x0000, 0x0000, 0xd2f4, 0xd2f3, 0x34f7,
0x0000, 0x0000, 0x35b1, 0xd3a2, 0x0000, 0x0000, 0x35ae, 0x35ad,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x35b7, 0x35b8, 0x0000,
0x0000, 0x0000, 0x0000, 0x35af, 0x35b0, 0xd3a3, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xd3ab, 0xd3aa, 0x0000, 0x0000,
0x0000, 0xd3a9, 0x0000, 0x0000, 0x35ce, 0x0000, 0x35eb, 0x0000,
0x35d8, 0x0000, 0x35d6, 0x0000, 0x0000, 0x35db, 0x35d4,
	/* 0xe040 */
0x0000, 0x61fe, 0x0000, 0x62a4, 0x0000, 0x0000, 0x61fc, 0x0000,
0x62ad, 0x0000, 0x62a5, 0x0000, 0x62a7, 0x62a8, 0x0000, 0x0000,
0x62ab, 0x0000, 0x0000, 0xeebc, 0x62ac, 0x0000, 0x0000, 0x0000,
0x0000, 0x62b1, 0x0000, 0x0000, 0x0000, 0xcdb9, 0x62ae, 0xb6bf,
0x0000, 0x0000, 0x0000, 0x0000, 0x62b4, 0x62b5, 0x0000, 0x0000,
0x62b7, 0x62b8, 0x0000, 0x62b9, 0x0000, 0x0000, 0x0000, 0x0000,
0x62ba, 0x0000, 0x0000, 0x62bb, 0x0000, 0xeec0, 0x0000, 0x62bc,
0x0000, 0x62bd, 0x62be, 0x62bf, 0x62c0, 0x0000, 0x62c1, 0x0000,
0x0000, 0x0000, 0x62c3, 0x0000, 0x0000, 0x62c4, 0x0000, 0x62c7,
0x0000, 0x62c8, 0x0000, 0x0000, 0x0000, 0xc5a2, 0x62c9, 0xeec3,
0xeec2, 0x0000, 0x62cc, 0x0000, 0x62cd, 0x62ce, 0x0000, 0x62d0,
0x0000, 0x62d1, 0x62d2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xd3b7, 0x0000, 0x0000, 0x0000, 0xd3ba, 0x0000,
0xd3b5, 0xc3fd, 0x35fe, 0xd3c7, 0x0000, 0x0000, 0x35e9, 0x35e6,
0xd3c0, 0xd3c2, 0x0000, 0x35ec, 0xd3c1, 0xd3cd, 0x0000, 0x0000,
0x35ef, 0xd3bc, 0x0000, 0xd3d3, 0x35f9, 0x0000, 0x35fd, 0x0000,
0x0000, 0xd3d1, 0x0000, 0x0000, 0xd3ce, 0x0000, 0x0000, 0x0000,
0x0000, 0x35fb, 0x0000, 0x0000, 0x0000, 0xd3d0, 0x0000, 0x0000,
0x36ab, 0x0000, 0x0000, 0x0000, 0x0000, 0xd3d5, 0x0000, 0x0000,
0x0000, 0x0000, 0x36b9, 0x0000, 0x36b4, 0x36c5, 0x36cb, 0x0000,
0x0000, 0xc1b9, 0x36c7, 0xd3e5, 0xd3e1, 0x36d1, 0xd3e0, 0x0000,
0x0000, 0x36d5, 0x0000, 0x0000, 0x0000, 0xd3f8, 0x36f4, 0x36f6,
0x0000, 0x36fd, 0xd3fa, 0xd3fc, 0xd3fd, 0x37a6, 0xd3fe, 0xd4a8,
0x0000, 0xd6e5, 0x3ca8, 0xd6e6, 0x0000, 0x0000, 0x0000,
	/* 0xe140 */
0x0000, 0x62d4, 0x62d5, 0x0000, 0x62d7, 0xbfec, 0x0000, 0xeec5,
0xeec6, 0x62d9, 0x62db, 0x0000, 0x0000, 0x0000, 0x0000, 0x62de,
0x0000, 0x0000, 0x62df, 0xeeca, 0x62e2, 0x62e3, 0x0000, 0x0000,
0x62e4, 0xeece, 0x62e5, 0x0000, 0x62e7, 0x0000, 0x62e8, 0x62e9,
0x0000, 0x62eb, 0x62ec, 0x62ed, 0x0000, 0xc8b0, 0x62ee, 0x0000,
0xbdb9, 0x0000, 0x62ef, 0x0000, 0x0000, 0x62f0, 0xbedf, 0x0000,
0x62f1, 0x0000, 0x62f2, 0x0000, 0xeed0, 0x62f3, 0x62f6, 0x62f7,
0x62f8, 0x62f9, 0x62fa, 0x0000, 0xbefa, 0x0000, 0x62fb, 0x0000,
0x62fc, 0x62fd, 0x0000, 0x62fe, 0xeed6, 0xeed7, 0x63a1, 0x63a2,
0x0000, 0x63a3, 0xc8d0, 0xbce1, 0xeed9, 0xeeda, 0x0000, 0x63a4,
0x63a5, 0x0000, 0xeedb, 0x63a6, 0xc5a3, 0x63a7, 0x63a8, 0xeede,
0xbfcb, 0x63a9, 0xeedc, 0x0000, 0xeedd, 0x0000, 0xc4e0, 0x63aa,
0x63ab, 0xd6e9, 0xd6ea, 0xd6ef, 0x3cb8, 0x3cba, 0xc8a8, 0xd6a9,
0x3ba5, 0x0000, 0xb4f4, 0x0000, 0x3baa, 0x0000, 0x0000, 0xd6aa,
0x0000, 0x0000, 0x3bb7, 0x3bb1, 0x0000, 0xcca8, 0xd6ad, 0xc2d2,
0x3bb2, 0x0000, 0xd6b1, 0x0000, 0x3bbb, 0x0000, 0x3bba, 0x0000,
0x0000, 0x0000, 0x3bca, 0x3bc9, 0x0000, 0x3bc8, 0x0000, 0x3bc3,
0xd6c1, 0x0000, 0x0000, 0x3bcc, 0x3bce, 0xd6cc, 0x0000, 0xbab7,
0x0000, 0x0000, 0xd6cb, 0x3bd7, 0xbff3, 0x0000, 0xd6d1, 0x3bec,
0xd6d3, 0x5ef9, 0xd6d8, 0x0000, 0xd7c6, 0xd7c7, 0xd7c9, 0xd7ce,
0x3da9, 0xb8e5, 0x0000, 0xd7d0, 0x3dad, 0xd7d3, 0xd7d4, 0x0000,
0xd7d5, 0xeacd, 0xd7c4, 0x4aed, 0x0000, 0x4af0, 0x0000, 0x0000,
0xe0bd, 0x4af2, 0xe0c0, 0x0000, 0xe0c1, 0x0000, 0x0000, 0xbced,
0x0000, 0x4afc, 0xe0c6, 0x0000, 0x4afb, 0x0000, 0x4afd,
	/* 0xe240 */
0xcbd5, 0xb6fc, 0x0000, 0x63ac, 0x63ad, 0x0000, 0x63ae, 0x63af,
0x63b0, 0x63b1, 0x63b2, 0x63b3, 0x0000, 0x0000, 0x0000, 0xeee0,
0xeee1, 0x63b4, 0x0000, 0x63b5, 0x0000, 0x63b6, 0xeedf, 0x63b7,
0x0000, 0xeee3, 0x63b8, 0x63b9, 0x0000, 0x0000, 0x63ba, 0x63bb,
0x63bc, 0x63bd, 0x0000, 0x63be, 0x63bf, 0x0000, 0x63c0, 0xc6df,
0xb3c3, 0x0000, 0x63c1, 0xeee7, 0x63c2, 0x63c3, 0xeee4, 0xeee6,
0x63c4, 0x0000, 0x63c5, 0x0000, 0x0000, 0x0000, 0x63c6, 0x63c7,
0xeee2, 0x0000, 0x0000, 0x0000, 0x0000, 0x63c8, 0x63c9, 0x0000,
0x63ca, 0x63cb, 0x0000, 0x63cc, 0xefcf, 0x0000, 0x0000, 0xeee5,
0x0000, 0x63cd, 0x63ce, 0x63cf, 0x0000, 0x0000, 0x63d0, 0xceeb,
0x63d1, 0x63d2, 0xb8da, 0x63d3, 0x63d4, 0x63d5, 0x0000, 0x63d6,
0x0000, 0x63d7, 0xeeef, 0x63d8, 0x0000, 0x63d9, 0x63da, 0xc5b4,
0xeeea, 0x4afe, 0xe0c8, 0x4ba9, 0x0000, 0xe0c9, 0x4bac, 0xe0cc,
0x0000, 0x4bad, 0x0000, 0xe0d0, 0x4bb1, 0x0000, 0x4bb2, 0x4bba,
0x4bb9, 0xe0d5, 0x4bc1, 0x4bc6, 0x4bc8, 0x0000, 0xc1a4, 0xd4ee,
0x68cc, 0x38ea, 0xd4e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3cc2,
0x0000, 0x3cc3, 0xcaf9, 0x3cc7, 0xd6f9, 0x0000, 0xb0c3, 0x3cce,
0x3ccc, 0x0000, 0x3cd5, 0x3cd4, 0xd7a5, 0xd7a8, 0x0000, 0xe7bf,
0x3db8, 0x3dbb, 0xd7d6, 0x0000, 0x0000, 0x3dca, 0x0000, 0x3dc3,
0xd7d8, 0x0000, 0x0000, 0x0000, 0x3dc7, 0x3dc9, 0xd7d9, 0xd7e0,
0x3ddd, 0xd7e8, 0xd7e5, 0xd7e9, 0x3dd3, 0xd7e2, 0xd7e7, 0x3dd2,
0x0000, 0xd7de, 0x0000, 0x0000, 0x0000, 0x0000, 0xd7f6,
	/* 0xe340 */
0x63db, 0x63dc, 0xeeed, 0xeeeb, 0x63dd, 0xeef0, 0x0000, 0x63de,
0x63df, 0x63e0, 0xeef1, 0x63e1, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xeee9, 0x63e2, 0x63e3, 0xeef6, 0xb1f4, 0x63e4, 0x63e5,
0xeee8, 0x0000, 0x63e6, 0x63e7, 0xc8ad, 0x0000, 0xeeec, 0x63e8,
0xbee0, 0x63e9, 0x63ea, 0x63eb, 0x0000, 0x0000, 0x0000, 0x0000,
0x63ec, 0x63ed, 0x63ee, 0xb9db, 0x0000, 0x0000, 0x63ef, 0x63f0,
0x63f1, 0x63f2, 0x63f3, 0x0000, 0x63f4, 0x63f5, 0x63f6, 0xcbc8,
0x63f7, 0xb6e4, 0x0000, 0x0000, 0xbdc6, 0x0000, 0xc6bc, 0x0000,
0x0000, 0x0000, 0x63f8, 0x63f9, 0x63fa, 0x0000, 0x0000, 0x63fb,
0x0000, 0x0000, 0xc1ad, 0x63fd, 0xeef4, 0x0000, 0xeeee, 0xeef3,
0x63fe, 0xccc3, 0x64a1, 0xc4b8, 0xeef5, 0xeef2, 0x0000, 0x0000,
0x64a2, 0x64a3, 0x0000, 0x0000, 0x0000, 0x64a4, 0x64a5, 0x0000,
0x64a6, 0xd7ed, 0x0000, 0xd8a3, 0xd7fe, 0x0000, 0x3df6, 0xd7fd,
0xd8a5, 0xc4f0, 0xd8a2, 0x0000, 0x3ea1, 0x3dfd, 0x3eaf, 0xd8b1,
0xd8af, 0xb9fb, 0xd8ac, 0x0000, 0x0000, 0xd8b3, 0x0000, 0xd8b8,
0xd8b7, 0xd8bf, 0x3ec8, 0xd8c4, 0xd8d9, 0xd8dd, 0xd8de, 0xc6b4,
0x0000, 0x0000, 0x0000, 0xd7db, 0x66f0, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe0ad, 0x3fa9, 0x46d3,
0x46dd, 0x46e0, 0x46d8, 0x0000, 0x46e9, 0xddf4, 0x46ed, 0xc6d9,
0xddf1, 0x0000, 0x46e4, 0x46e5, 0x46ea, 0x0000, 0x46fa, 0x46fd,
0x0000, 0x0000, 0x0000, 0xddf6, 0xddf9, 0x46f4, 0x47a3, 0x46fe,
0x0000, 0x47a6, 0x47a8, 0xddfd, 0xddf7, 0xdea3, 0x0000,
	/* 0xe440 */
0x64a7, 0x0000, 0x0000, 0x64a8, 0x0000, 0xc1ac, 0x64a9, 0x0000,
0x0000, 0x64aa, 0x0000, 0x0000, 0x0000, 0x64ab, 0xeef9, 0x64ac,
0xeef8, 0x64ad, 0x64ae, 0x64af, 0x64b0, 0x0000, 0x64b1, 0x64b2,
0x64b3, 0x64b4, 0x64b5, 0x0000, 0x64b6, 0x64b7, 0x64b8, 0x0000,
0x0000, 0x64ba, 0x64bb, 0x64bc, 0x64bd, 0xeef7, 0x64be, 0x0000,
0xcbaf, 0x64bf, 0x0000, 0x64c0, 0x0000, 0x64c1, 0x64c2, 0x64c3,
0x0000, 0x0000, 0x64c4, 0x64c5, 0x0000, 0x64c6, 0x64c7, 0x64c8,
0x0000, 0x64c9, 0xbdfb, 0x64ca, 0x0000, 0x64cb, 0x64cc, 0x0000,
0xeefa, 0xcadf, 0x0000, 0x64cd, 0xb1d4, 0x64ce, 0x0000, 0x64cf,
0x0000, 0xc9c6, 0xc3f2, 0x0000, 0x0000, 0x0000, 0x0000, 0xb5f8,
0x64d0, 0xeefc, 0x64d1, 0xb9dd, 0x0000, 0x0000, 0x64d2, 0x64d3,
0x0000, 0x64d4, 0x0000, 0x0000, 0x0000, 0xbbac, 0x0000, 0x64d5,
0x0000, 0x47ba, 0x47b4, 0xdeb0, 0x0000, 0x0000, 0x47ac, 0x47ab,
0xdeac, 0x47ae, 0xdea9, 0x0000, 0x47b7, 0xdead, 0x47b2, 0x0000,
0x0000, 0x0000, 0xdeae, 0x47c8, 0x47c3, 0x0000, 0x0000, 0x47be,
0xdeb2, 0x47ca, 0xc9cd, 0x0000, 0x47c5, 0xdeb1, 0xbded, 0xdebf,
0xdec8, 0xdec4, 0x0000, 0x47d4, 0x47de, 0x0000, 0xdec0, 0x47dc,
0xdeca, 0x0000, 0x0000, 0x0000, 0x0000, 0xded8, 0xded0, 0xdede,
0xded7, 0xdeec, 0xded4, 0x0000, 0x47f9, 0x47fa, 0x47ec, 0xb0af,
0x47f1, 0x0000, 0x48ae, 0xdee5, 0x0000, 0x48d3, 0x0000, 0xdef0,
0x48ab, 0xdee9, 0x48b0, 0xdee7, 0x0000, 0x0000, 0x48ba, 0xdeef,
0xdef1, 0xdef2, 0x48de, 0x0000, 0x0000, 0x0000, 0xc1e6, 0x48be,
0x48cd, 0x48d0, 0x0000, 0xdfcc, 0x48cc, 0xb9f7, 0x48cb, 0x0000,
0x48e8, 0x48e7, 0xdfa6, 0x0000, 0xdfae, 0xdfa5, 0x0000,
	/* 0xe540 */
0x0000, 0x0000, 0x0000, 0x64d6, 0x0000, 0xeefb, 0xbfed, 0x64d7,
0x0000, 0x0000, 0x64d8, 0x64d9, 0x0000, 0x0000, 0xbfee, 0xefa1,
0xefa3, 0x0000, 0x64da, 0x64db, 0x64dc, 0x64dd, 0xbefb, 0x64de,
0xefa2, 0xefa4, 0x64df, 0x64e0, 0xb6d3, 0x64e1, 0xc9c5, 0x64e2,
0x64e3, 0xbce2, 0xcfa3, 0x0000, 0xeefe, 0xbaf8, 0x0000, 0x0000,
0xcfbf, 0x64e4, 0x64e5, 0xefa6, 0x64e6, 0x64e7, 0x0000, 0x0000,
0xefa5, 0xefa7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xeefd, 0x0000, 0x0000, 0x64e8, 0x64e9, 0x64ea, 0x0000,
0x0000, 0xc6e9, 0x0000, 0xc5d5, 0x0000, 0x0000, 0x64eb, 0x64ec,
0x64ed, 0x0000, 0xc4d7, 0x64ee, 0xefac, 0x64ef, 0x64f0, 0x0000,
0x64f1, 0xc3c3, 0xefa8, 0x0000, 0x64f2, 0x0000, 0xefa9, 0x0000,
0x0000, 0x0000, 0x64f3, 0x64f4, 0x0000, 0x64f5, 0x0000, 0x64f6,
0x0000, 0x0000, 0x48f3, 0xdfb8, 0x48f9, 0xdfb2, 0xc7a8, 0xdfc1,
0x49a2, 0xb9ea, 0xc2f5, 0xdfcb, 0x49b1, 0xdfca, 0x49b5, 0x0000,
0x0000, 0x49c0, 0xd5df, 0x3ac8, 0xc5e6, 0x3ace, 0xcda8, 0xd5e2,
0x4daa, 0x0000, 0xd9eb, 0xd5e8, 0xcec0, 0x5ce4, 0xd5ee, 0xeda1,
0xebe9, 0x61b4, 0x61bf, 0x61c0, 0xedea, 0x61c5, 0x61c3, 0xc6f6,
0xb2e0, 0x0000, 0x61c4, 0xedf0, 0x61cc, 0xedf9, 0x0000, 0xedf3,
0xedf6, 0xedf8, 0xedf5, 0xedfc, 0xedfb, 0x61d6, 0x61d3, 0x61dc,
0xeea3, 0xeea4, 0xeea2, 0xeeab, 0xeea9, 0x61e0, 0x61de, 0xdafb,
0x61e5, 0xeeb1, 0xeeb0, 0x61e8, 0xe3e4, 0x61e9, 0x3cf7, 0xd7c2,
0xd7c1, 0x3cf9, 0xbfac, 0xd3a1, 0xd6a1, 0x3af7, 0xd6a3, 0x3afb,
0x0000, 0x55b4, 0x0000, 0xd7b8, 0xd7b9, 0x57ab, 0xc9ab, 0xe4f8,
0xd6a5, 0xd5a2, 0xc8de, 0xd5ab, 0x0000, 0x0000, 0xd5a6,
	/* 0xe640 */
0xb7ad, 0x64f8, 0xefab, 0x64f9, 0x64fa, 0x64fb, 0x0000, 0x64fc,
0x64fd, 0xb8b0, 0x64fe, 0x0000, 0x0000, 0x0000, 0x65a1, 0x0000,
0xefaa, 0x65a2, 0xbee1, 0x65a3, 0x65a4, 0x65a5, 0x65a6, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x65a7, 0x0000, 0x65a8, 0x65a9,
0xb3f9, 0x65aa, 0x0000, 0x0000, 0x0000, 0x65ac, 0x0000, 0xefb0,
0x65ad, 0xbabf, 0xc1f9, 0x65ae, 0x0000, 0xc4ca, 0x65af, 0x0000,
0x0000, 0x65b0, 0x0000, 0x0000, 0x65b1, 0x0000, 0x65b2, 0x65b3,
0x0000, 0x65b4, 0xb3bb, 0x65b5, 0x65bb, 0x0000, 0x65b6, 0x0000,
0xefae, 0xefaf, 0xc4c3, 0x0000, 0xefad, 0x0000, 0x0000, 0x0000,
0x65b7, 0x65b8, 0x65b9, 0x0000, 0x0000, 0xefb1, 0x65ba, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x65bc, 0x0000, 0xefb7,
0x65bd, 0x65be, 0x65bf, 0x65c0, 0xefba, 0x65c1, 0x65c3, 0x65c4,
0x65c5, 0x39ad, 0x39bd, 0x0000, 0x0000, 0x39af, 0x39bf, 0xd5a7,
0x39b3, 0x0000, 0xbeaa, 0x0000, 0x0000, 0x39c0, 0x0000, 0x39c3,
0x0000, 0x0000, 0x39ce, 0xd5b2, 0x0000, 0x0000, 0xd5b0, 0x39d4,
0x39d2, 0xd5b4, 0x39e5, 0x0000, 0x39e1, 0xbeab, 0xd5b9, 0x0000,
0x0000, 0x0000, 0xc9b2, 0x39e7, 0x39e8, 0xd5bd, 0x0000, 0x39f8,
0x0000, 0x0000, 0x39fb, 0x3aa7, 0xd5c1, 0x0000, 0xd5c5, 0xd5c3,
0x0000, 0x3aa6, 0xb4f2, 0x3ab1, 0xd5ca, 0xd5cb, 0x0000, 0xd5d2,
0x0000, 0x0000, 0xd5d5, 0xd5d7, 0xd5da, 0xd5d3, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xe740 */
0x0000, 0x0000, 0xefb9, 0xc5ad, 0x0000, 0x65c6, 0x0000, 0x0000,
0xefb3, 0xefb6, 0x65c7, 0x0000, 0x0000, 0x65c8, 0xefb8, 0x65c9,
0x65ca, 0x0000, 0xb6c0, 0x65cb, 0x0000, 0xefbb, 0xefb5, 0x65cc,
0x65cd, 0xefb4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x65cf, 0x65d0, 0x65ce, 0x65d1, 0x65d2, 0x0000, 0x65d3, 0x0000,
0x0000, 0x0000, 0x65d4, 0x65d5, 0xefbf, 0x65d6, 0x0000, 0x0000,
0xefc0, 0x65d7, 0x65d8, 0x0000, 0x0000, 0x0000, 0x65d9, 0x0000,
0x65da, 0x65db, 0xefc1, 0x0000, 0x0000, 0xefbe, 0xefbd, 0x65dc,
0x65dd, 0x65de, 0xbee2, 0xc6aa, 0xefbc, 0x0000, 0x0000, 0x0000,
0x0000, 0x65df, 0x0000, 0xefc5, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xefc3, 0x0000, 0x0000,
0x65e0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xd6f6, 0xb5a6, 0xd6df, 0x4dae, 0x61ed,
0x4bd2, 0x0000, 0x0000, 0x4bdc, 0x4bda, 0x4bed, 0xb2d1, 0x0000,
0x4be3, 0xe0de, 0xe0e1, 0x4bea, 0xe0dd, 0xe0e2, 0x4bf1, 0x0000,
0x4ca6, 0x4bf7, 0x4bf6, 0xe0e4, 0x0000, 0x0000, 0x0000, 0x4cae,
0xb1cd, 0x4cab, 0xe0e8, 0x4cac, 0x4cb4, 0x4cb2, 0x4cb0,
	/* 0xe840 */
0x65e1, 0x0000, 0x65e2, 0x65e3, 0x65e4, 0x65e5, 0xefc4, 0xefc2,
0x0000, 0xc2f8, 0x0000, 0xefc6, 0x65e6, 0x0000, 0x65e8, 0x65e7,
0x0000, 0xefc7, 0x0000, 0x65e9, 0xefc9, 0x65ea, 0x0000, 0x0000,
0x65eb, 0x0000, 0x65ec, 0x0000, 0x65ed, 0x0000, 0x0000, 0x0000,
0x0000, 0xb4d5, 0xefc8, 0xccfa, 0x0000, 0x65ee, 0x0000, 0x0000,
0x0000, 0x65ef, 0xefd4, 0xefca, 0x65f0, 0x0000, 0xefcd, 0x65f1,
0xefcb, 0x65f2, 0xefcc, 0x65f3, 0x0000, 0x0000, 0x0000, 0x0000,
0x65f4, 0x0000, 0xefce, 0x0000, 0x65f6, 0x65f7, 0x65f8, 0x0000,
0xefd0, 0x65f9, 0x65fa, 0x0000, 0x0000, 0xefd1, 0x0000, 0xefd2,
0x0000, 0x0000, 0x0000, 0x0000, 0xefd5, 0xefd3, 0xefd6, 0xefd8,
0x0000, 0xefd7, 0x0000, 0x65fc, 0x65fb, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x4ca9, 0x4ca8, 0xe0f0, 0xe0f1, 0x4cc0, 0xe0ec, 0xe0ef,
0x0000, 0x4cc7, 0xe0f7, 0x4cd8, 0x0000, 0x4ccb, 0x4ccc, 0x4ccf,
0xe0f8, 0xe0f9, 0x4cde, 0x4cdf, 0x4cd2, 0xe0fa, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x42fb, 0xbcdd, 0xdbb9, 0x42fa, 0x0000,
0x0000, 0xc8fa, 0xdbc2, 0xdae2, 0x43ae, 0x0000, 0xb5cf, 0x0000,
0x0000, 0x0000, 0xdbc4, 0xc7c7, 0xdbc1, 0x43c5, 0x0000, 0xc4d3,
0x0000, 0xdbcd, 0x43b1, 0x0000, 0x43c1, 0x43b4, 0xcdae, 0xdbcc,
0xdbd1, 0x0000, 0x43bb, 0xdbce, 0xdbd2, 0x0000, 0xc2c8, 0x0000,
0xdbde, 0x43d5, 0x0000, 0x0000, 0xdbdf, 0x0000, 0x43d8, 0x0000,
0xdbec, 0x43cc, 0x43dc, 0x0000, 0xb7e5, 0xc9b0, 0xdbdc, 0x0000,
0x43da, 0x0000, 0xdbdb, 0xdbf0, 0xdbe7, 0xdbef, 0xdbe4, 0xb0b4,
0x43e0, 0x0000, 0xdcba, 0x44b3, 0x0000, 0x0000, 0xdcaa,
	/* 0xe940 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xc4b9, 0x65fd, 0x65fe, 0x0000,
0x0000, 0x0000, 0x0000, 0x66a1, 0xcce7, 0x0000, 0xefd9, 0xc1ae,
0x66a2, 0x0000, 0x0000, 0xefda, 0x66a3, 0xcac4, 0xefdb, 0xb3ab,
0x66a4, 0x66a5, 0x66a6, 0xb1bc, 0x0000, 0xb4d7, 0x0000, 0xb4d6,
0xefdc, 0x0000, 0xefdd, 0x0000, 0xefde, 0xefdf, 0x0000, 0x0000,
0x0000, 0x66a7, 0x66a8, 0x66a9, 0xefe0, 0x66aa, 0xb4d8, 0xb3d5,
0xb9de, 0xc8b6, 0x66ab, 0xefe2, 0xefe1, 0x66ac, 0x0000, 0x0000,
0x66ad, 0x66ae, 0xefe3, 0x0000, 0x0000, 0x0000, 0x0000, 0xb1dc,
0x0000, 0x66af, 0x0000, 0x66b0, 0x0000, 0x0000, 0xefe6, 0x66b1,
0xefe5, 0xefe4, 0x66b2, 0xefe7, 0x66b3, 0x0000, 0x0000, 0x0000,
0xefea, 0x0000, 0x0000, 0x66b4, 0xb0c7, 0x66b5, 0x66b6, 0xefe8,
0x66b7, 0x0000, 0x44ae, 0xccba, 0xdbf6, 0x44c6, 0xdca8, 0x44b8,
0x44d0, 0xdcbb, 0xc6ef, 0x44c2, 0xdcc2, 0x0000, 0xdcb7, 0x44d5,
0x44d9, 0xdcb6, 0xc6ce, 0xc4c8, 0x0000, 0x0000, 0xdccc, 0x0000,
0x44cb, 0x44c8, 0xdcb3, 0xbfba, 0xdcd2, 0xdcd0, 0x44de, 0x44df,
0x0000, 0xdce3, 0xdcc9, 0xdcce, 0x0000, 0xdcd7, 0x0000, 0x44d6,
0xdcdd, 0x0000, 0xdce5, 0xc3f4, 0x0000, 0x0000, 0xdce0, 0xdced,
0x45a4, 0xdcfb, 0x45ab, 0x45b0, 0xbec1, 0xb8e9, 0x0000, 0xc3ae,
0x44fc, 0xb5cc, 0x0000, 0x45bd, 0xdcf9, 0x0000, 0xdda1, 0x45c3,
0xcdb2, 0x4bbb, 0x0000, 0x46a2, 0x0000, 0xddc9, 0x0000, 0x0000,
0xddcb, 0x0000, 0x46a5, 0x0000, 0xddd0, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xea40 */
0xefec, 0xefeb, 0x0000, 0x0000, 0x66b8, 0x66b9, 0x66ba, 0x66bb,
0xefee, 0xefed, 0xefef, 0x0000, 0xc6ae, 0x66bc, 0x66bd, 0x0000,
0xeff0, 0x66be, 0x66bf, 0x66c0, 0x66c1, 0xeff1, 0xeff3, 0x0000,
0x66c2, 0xeff2, 0x66c3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x66c5, 0x0000, 0x0000, 0x66c7, 0x66c8, 0x66c9,
0x0000, 0xeff5, 0x0000, 0x0000, 0x66ca, 0x0000, 0xeff7, 0x0000,
0x66cd, 0x66ce, 0x66cf, 0x66d0, 0x0000, 0x66d3, 0x0000, 0x0000,
0x0000, 0xeffa, 0x0000, 0x66d4, 0x0000, 0x66d6, 0x66d7, 0x0000,
0x66d8, 0x0000, 0x0000, 0xeffd, 0xf0a1, 0xeffe, 0x0000, 0xbfd8,
0xb4d9, 0xf0a3, 0x0000, 0x0000, 0x66da, 0x0000, 0xb1a2, 0x0000,
0xc4c4, 0xcea6, 0x0000, 0xb8b1, 0x66dc, 0x66dd, 0xcddb, 0x66de,
0x66df, 0x0000, 0x66e0, 0x66e1, 0x66e2, 0x66e3, 0x0000, 0x66e4,
0xc2e2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0xd8fe, 0xb7e1, 0x3fac, 0xd9a2, 0x0000, 0x0000, 0x0000,
0xe7c9, 0x4cf8, 0x4cf9, 0x4cfd, 0x0000, 0xb9f9, 0xe1b2, 0xdabd,
0x0000, 0x0000, 0x41ee, 0xdadf, 0x0000, 0xdade, 0xdae0, 0x41fc,
0x41f5, 0x49ca, 0xdbab, 0x41fe, 0xdae5, 0x42ad, 0xdae4, 0xdae3,
0xe6cd, 0xdaf0, 0x0000, 0xdaea, 0xdae7, 0x0000, 0x42be, 0x42b8,
0x42c7, 0xdaf7, 0x42ce, 0x0000, 0xdaf9, 0xdafd, 0x42e7, 0xcdcb,
0xdba7, 0xdba8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x4ade, 0x0000, 0xccc6, 0x0000, 0x4adf, 0xe0b3, 0x4ae5, 0x4ae6,
0x0000, 0x4ae8, 0x0000, 0xe0b7, 0xd9cd, 0x0000, 0x0000,
	/* 0xeb40 */
0x0000, 0xb3ac, 0x66e5, 0x0000, 0x0000, 0xf0a8, 0x66e6, 0x66e7,
0xbadd, 0x66e8, 0x0000, 0x66e9, 0xb1a3, 0x0000, 0x0000, 0xced9,
0x66ea, 0x66eb, 0x66ec, 0xeeae, 0x66ed, 0xf0aa, 0x0000, 0x0000,
0x0000, 0x66ee, 0x66ef, 0xf0ac, 0xf0ad, 0xf0af, 0x0000, 0xceec,
0xf0b1, 0x66f1, 0xc0c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x66f2,
0xf0b4, 0x0000, 0xbba8, 0x0000, 0x0000, 0xeaad, 0x0000, 0x66f5,
0xd2d6, 0x66f6, 0xbff7, 0xf0b8, 0x66f7, 0x66f8, 0x66f9, 0x0000,
0xcea5, 0xc6f1, 0x0000, 0x0000, 0x0000, 0x0000, 0xbcb6, 0x0000,
0x0000, 0x0000, 0x0000, 0xcab7, 0x66fc, 0xb1c0, 0x0000, 0x0000,
0x0000, 0x66fd, 0xc5c5, 0x0000, 0x0000, 0x0000, 0x66fe, 0x67a1,
0x67a2, 0xceee, 0x0000, 0x0000, 0x0000, 0xf0c1, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0xf0c4, 0x67a4, 0x67a5, 0x67a6, 0x0000,
0x0000, 0x40d8, 0xdaa6, 0xe6ce, 0x0000, 0xddde, 0x0000, 0x0000,
0x46c1, 0x46c5, 0x0000, 0x0000, 0x46c7, 0x0000, 0x0000, 0x46cb,
0x0000, 0x0000, 0x0000, 0xdde5, 0x0000, 0x0000, 0xdabe, 0xdac5,
0x41d3, 0x0000, 0xc4ad, 0x4ad6, 0xe0a9, 0x5ac2, 0x33b6, 0x0000,
0x55ed, 0xe6eb, 0x0000, 0x0000, 0x0000, 0xb9cf, 0x55f1, 0xe6ed,
0xbae8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe6f0, 0x0000,
0xe6f4, 0xe6f2, 0x55f5, 0x55fa, 0x0000, 0xe6f3, 0x0000, 0xe6f9,
0xc6b9, 0x55fd, 0x0000, 0x0000, 0x56a2, 0xe7a6, 0xc4bf, 0x0000,
0xc6da, 0x0000, 0x56ae, 0x56b2, 0x56ac, 0x0000, 0x0000, 0x56ba,
0xe7a4, 0xe7ab, 0x0000, 0x0000, 0xe7a7, 0x56bd, 0x56c1, 0x0000,
0x0000, 0x56c2, 0x56bf, 0x38af, 0x39fa, 0xe7ad, 0xe7b0, 0x0000,
0xdeee, 0xe7b4, 0x0000, 0x0000, 0xdbaf, 0x56d8, 0x56d4,
	/* 0xec40 */
0x67a7, 0x67a8, 0x67a9, 0xf0c5, 0x0000, 0x0000, 0xccb8, 0x67aa,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x67ab, 0x67ac, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf0c9, 0x0000,
0x0000, 0x67ad, 0xf0ce, 0x67ae, 0xf0cb, 0x0000, 0xf0cc, 0x0000,
0xf0cd, 0xf0cf, 0x67af, 0x0000, 0x0000, 0x0000, 0x67b0, 0x67b1,
0x0000, 0x0000, 0x0000, 0x67b2, 0x67b3, 0x67b4, 0x67b5, 0xf0d0,
0x0000, 0x0000, 0x67b7, 0xf0d2, 0xf0d3, 0x67b8, 0xf0d4, 0x67b9,
0xf0d6, 0x0000, 0xbfd9, 0x67ba, 0x0000, 0x0000, 0xf0d7, 0x0000,
0x0000, 0x0000, 0x67bd, 0x67be, 0xf0d8, 0xf0dc, 0x67bf, 0x67c0,
0x0000, 0x67c1, 0x67c2, 0xf0db, 0x0000, 0x0000, 0xb3f3, 0xf0dd,
0x0000, 0x0000, 0x67c3, 0x0000, 0x0000, 0x0000, 0xf0df, 0xf0e0,
0x0000, 0x67c4, 0x67c5, 0x67c6, 0x67c7, 0x67c8, 0x0000, 0xf0e1,
0x0000, 0x0000, 0x0000, 0x45e8, 0xddb8, 0xddba, 0xddbd, 0x45f1,
0xddc0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xddd5,
0x3cf2, 0x0000, 0x5dbe, 0xc8e5, 0x0000, 0x0000, 0xb1f7, 0xdad4,
0xdad6, 0xdad3, 0xdad7, 0x41e8, 0xdad8, 0x41eb, 0x0000, 0x0000,
0x49ce, 0x0000, 0x0000, 0x0000, 0x49d7, 0x49d3, 0x49d5, 0x0000,
0x49d8, 0x0000, 0x0000, 0x0000, 0x49ee, 0x49f0, 0x0000, 0x49fc,
0x4aa1, 0x49f3, 0x0000, 0x49f6, 0x0000, 0x0000, 0x0000, 0x4aaf,
0x0000, 0xdff1, 0x4aaa, 0xdffa, 0xdff8, 0xdffc, 0xe0a1, 0x4ac5,
0xe0a6, 0x49c4, 0x0000, 0xdfe8, 0xdff4, 0x0000, 0x3fb2, 0x3fb4,
0xeebd, 0xc8e2, 0x50cb, 0xe3ab, 0x50d0, 0xbbe3, 0x50d7, 0x50d8,
0xe3b1, 0xe3af, 0xc7aa, 0xe3ad, 0xe3ac, 0x0000, 0x50d9, 0xe3b2,
0xc1b5, 0xe3b4, 0x0000, 0xe3b6, 0xe3ba, 0x3dbe, 0x3dbd,
	/* 0xed40 */
0x67c9, 0x67ca, 0x0000, 0x67cb, 0x0000, 0x0000, 0xf0e3, 0x0000,
0xf0e2, 0x0000, 0x0000, 0x67cc, 0x67cd, 0x0000, 0x67ce, 0xf0e5,
0x67d0, 0x67d1, 0x0000, 0x67d2, 0x67d3, 0x67d4, 0x0000, 0x67d5,
0x0000, 0x67d6, 0x67d7, 0x0000, 0x67d8, 0x0000, 0xf0e7, 0x67d9,
0x67da, 0xf0e8, 0x67db, 0xf0e9, 0x67dc, 0x67dd, 0xf0ea, 0x67de,
0x67df, 0x67e0, 0x0000, 0x67e1, 0x67e2, 0x0000, 0xb4da, 0x67e3,
0x0000, 0x0000, 0x67e4, 0x67e5, 0x67e6, 0x0000, 0x67ea, 0xf0eb,
0x67e7, 0x67e8, 0x0000, 0x67e9, 0x67eb, 0x0000, 0x0000, 0x0000,
0x67ec, 0x0000, 0x0000, 0xc7a3, 0x67ed, 0x0000, 0x67ee, 0xf0ee,
0x67ef, 0x67f0, 0x67f1, 0x0000, 0x67f2, 0xb1a4, 0x0000, 0x0000,
0x0000, 0xb6c1, 0x0000, 0xcac7, 0xc4ba, 0xbaa2, 0x0000, 0xb9e0,
0xbde7, 0x67f3, 0xbfdc, 0x0000, 0x67f4, 0x0000, 0xf0f3, 0x67f6,
0x67f7, 0x0000, 0x3de7, 0xd7eb, 0x3de9, 0xd7ec, 0xd7f9, 0xd7f3,
0x0000, 0xd8b4, 0xd8be, 0xd8d7, 0xb7c6, 0x3ee6, 0xd8ec, 0x0000,
0x0000, 0x0000, 0xe6e6, 0xb7a3, 0x0000, 0x47e6, 0x0000, 0x4fcc,
0x0000, 0x4fd0, 0x0000, 0x0000, 0x4fd3, 0xdad1, 0x4fd8, 0x0000,
0x4fd4, 0x0000, 0xc5d7, 0x0000, 0x0000, 0x0000, 0xc5d6, 0x0000,
0x4fd7, 0x0000, 0x4fe2, 0x0000, 0x0000, 0x0000, 0xbad6, 0x0000,
0x4fdf, 0x4fe1, 0x4feb, 0x0000, 0xb1b0, 0xe2f0, 0xc4f6, 0x0000,
0x4ff3, 0xe2f2, 0x4ffd, 0x0000, 0x0000, 0xe2f9, 0x0000, 0x50a6,
0xe2fe, 0x50b4, 0x0000, 0xe3a4, 0x0000, 0x0000, 0x50c1, 0x50c9,
0x0000, 0xf3e3, 0xf3e4, 0xf3e5, 0x4ed6, 0xe2c0, 0x0000, 0x4ed8,
0xe2bf, 0xe2be, 0x4ee3, 0x4ee5, 0x4ee2, 0x4ee7, 0xe2c5, 0x4eeb,
0xe2c8, 0x0000, 0x0000, 0xe2c9, 0x0000, 0xe2ca, 0xe2cb,
	/* 0xee40 */
0xf0f2, 0xcdc2, 0xb4e8, 0xc8d2, 0xc6dc, 0x67f8, 0x0000, 0x67f9,
0xbffc, 0xcece, 0x67f5, 0xb7db, 0x0000, 0x67fa, 0x0000, 0x67fb,
0x0000, 0x67fc, 0xf0f6, 0x0000, 0x67fd, 0xf0f5, 0x68a8, 0x67fe,
0x0000, 0x0000, 0x0000, 0x0000, 0x68a1, 0xcbcb, 0xc6ac, 0x68a2,
0x68a3, 0x68a4, 0x0000, 0x68a5, 0x68a6, 0xb1d0, 0x68a7, 0x0000,
0xf0f7, 0xf0f4, 0x0000, 0x0000, 0xc9d1, 0xcdea, 0xf0f8, 0x68a9,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x68aa, 0x0000, 0xf0f9,
0x68ab, 0x0000, 0x0000, 0x68ac, 0xf0fb, 0xc2ea, 0xb3db, 0x0000,
0xb3dc, 0xf0fa, 0x0000, 0x68ad, 0x68ae, 0x68af, 0xb4e9, 0xb8b2,
0x68b0, 0x68b1, 0xb4ea, 0x68b2, 0x68b3, 0xc5bf, 0x0000, 0x0000,
0xcee0, 0x0000, 0x0000, 0x0000, 0x68b4, 0x68b5, 0x0000, 0x68b6,
0x68b7, 0xb8dc, 0x0000, 0x0000, 0x68b8, 0xf0fc, 0x68b9, 0x0000,
0x0000, 0x4efe, 0xe2ce, 0xe2cf, 0x4fae, 0x4faa, 0x4fab, 0x4fad,
0xe2d4, 0x4fb3, 0xe2d5, 0xe2d7, 0x4fba, 0xe2dc, 0xc4ae, 0x4db0,
0x4db4, 0xdac2, 0x4db3, 0xe1bb, 0x0000, 0x4dbd, 0x0000, 0xe6a9,
0x54f9, 0xe6aa, 0xebca, 0xe6ac, 0x0000, 0x55a1, 0xd8ed, 0x0000,
0x55a3, 0xe2b4, 0xe2b9, 0x5bfd, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xef40 */
0xf0fd, 0xf0fe, 0xf1a1, 0x0000, 0xf1a3, 0xf1a2, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0xc9f7, 0x0000, 0xf1a4, 0x68ba,
0x0000, 0x68bb, 0x68bc, 0xf1a5, 0x68bd, 0xf1a6, 0x0000, 0x0000,
0x68be, 0x0000, 0xf1a7, 0x68bf, 0x68c0, 0x0000, 0x68c1, 0x68c2,
0x0000, 0x0000, 0x0000, 0x68c3, 0x0000, 0x0000, 0x68c4, 0xf1a9,
0xf1a8, 0x68c5, 0xf1aa, 0x0000, 0x68c6, 0x0000, 0x0000, 0x0000,
0x68c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc8f4,
0xe6cc, 0x0000, 0x0000, 0x68c8, 0xb5b2, 0x68c9, 0x0000, 0x0000,
0x68ca, 0x68cb, 0xf1ab, 0x68cd, 0xf1ac, 0x0000, 0xd2ac, 0xddbb,
0xc8d3, 0x0000, 0x0000, 0xb0fb, 0x68ce, 0xb0bb, 0x0000, 0x68cf,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbbf4, 0xcbb0, 0xbefe,
0x0000, 0x0000, 0x0000, 0x68d0, 0xf1ad, 0x0000, 0xccdf, 0x0000,
0x68d1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0xc7ea, 0x4fc8, 0xf0b5, 0xe3be, 0x51a6, 0xe3c2,
0x51a5, 0x0000, 0x0000, 0x51ab, 0x51aa, 0x51b3, 0xccad,
	/* 0xf040 */
0x68d2, 0xf1ae, 0xcddc, 0x0000, 0xb1c2, 0x0000, 0x0000, 0x68d3,
0xf1af, 0xb2ee, 0xf1b0, 0x68d4, 0x68d5, 0x68d6, 0xf1b1, 0x0000,
0x68d7, 0x68d8, 0x68d9, 0xf1b3, 0xf1b4, 0x68da, 0xf1b6, 0xf1b2,
0x68db, 0x0000, 0xf1b5, 0x0000, 0x68dc, 0x68dd, 0xb4db, 0x0000,
0x0000, 0x68de, 0xf1b7, 0x0000, 0x0000, 0x0000, 0x68df, 0x68e0,
0x68e1, 0x68e2, 0x68e3, 0x0000, 0x0000, 0x0000, 0x68e4, 0x68e5,
0x68e6, 0x68e7, 0xf1b9, 0xf1ba, 0x0000, 0x68e8, 0x68e9, 0xf1bb,
0x0000, 0x0000, 0xf1bd, 0x68ea, 0x68eb, 0x68ec, 0xf1bc, 0x0000,
0x0000, 0xf1bf, 0xf1c2, 0x68ed, 0x68ee, 0x0000, 0xf1be, 0xf1c0,
0xf1c1, 0x0000, 0x0000, 0xb6c2, 0x68f0, 0x68f1, 0x0000, 0x68f2,
0x68f3, 0x0000, 0x68f4, 0x68f5, 0x68f6, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x51bd, 0xe3cd, 0x0000, 0xf3d6, 0xf1c6, 0xe3d5, 0xe2a7,
0xe2a9, 0xe2ab, 0xe2ac, 0x4ec1, 0x4cf2, 0xe1a1, 0xe1b5, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x4dc6, 0xe1cb, 0x0000, 0x0000, 0xe1cd, 0x0000,
0xe1cf, 0xe1d1, 0x4dcd, 0xe1d5, 0x4dd2, 0xe1d7, 0x0000, 0xe1d2,
0xe1d0, 0x0000, 0xe1d8, 0xe1dc, 0x0000, 0x0000, 0x4ddc, 0x0000,
0x4ddd, 0x4de5, 0x4de1, 0xe1e0, 0xe1df, 0x0000, 0x4de3, 0x0000,
0x4dea, 0x0000, 0x4de9, 0x4df6, 0x0000, 0x4dee, 0x4df0,
	/* 0xf140 */
0x0000, 0x0000, 0x0000, 0x68f7, 0x0000, 0x68f8, 0x0000, 0x68f9,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x68fa, 0x0000, 0x0000,
0x0000, 0x0000, 0xc7cf, 0xf1c7, 0xf1c8, 0x0000, 0x68fb, 0x68fc,
0x68fd, 0xc3da, 0xc6eb, 0x68fe, 0x0000, 0x0000, 0x0000, 0x69a1,
0x69a2, 0x0000, 0xf1c9, 0x69a3, 0x0000, 0x69a4, 0x0000, 0xc7fd,
0x0000, 0x69a5, 0xc2cc, 0xb1d8, 0xb6ee, 0x0000, 0xb6ef, 0x69a6,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc3f3, 0xf1ce,
0xb6f0, 0x69a7, 0x69a8, 0xb2ef, 0x0000, 0x0000, 0xf1cd, 0x0000,
0x69a9, 0x69aa, 0xf1cb, 0x69ab, 0xf1cc, 0x69ac, 0xf1ca, 0x0000,
0x0000, 0xf1d8, 0x0000, 0x0000, 0x0000, 0x0000, 0x69ad, 0x0000,
0x0000, 0x69ae, 0x69af, 0x69b0, 0xf1cf, 0xf1d0, 0x0000, 0x69b1,
0xf1d1, 0xf1d2, 0x0000, 0x69b2, 0x69b3, 0x0000, 0x0000, 0xf1d4,
0x69b4, 0x4df1, 0x4ea2, 0xe1ed, 0xe1eb, 0x4ea4, 0x4df9, 0xe1f0,
0x0000, 0x4dfc, 0x4ea6, 0x0000, 0x4dfb, 0x0000, 0x0000, 0x0000,
0xe1f5, 0xcaca, 0x0000, 0x4eb2, 0xe6c4, 0xe3f0, 0x51d0, 0xe3d6,
0x51d2, 0x51d5, 0xe3d8, 0xe3da, 0x0000, 0x51dc, 0x51de, 0x0000,
0x0000, 0x51df, 0x5cb3, 0x5cb4, 0xead5, 0xead3, 0xb6de, 0xead6,
0xeadb, 0x0000, 0xb0c1, 0x0000, 0x0000, 0x0000, 0x5cc9, 0x0000,
0x0000, 0x5cd2, 0x5cde, 0xeae9, 0xeaeb, 0xbffe, 0x5cd1, 0x0000,
0x5cdd, 0xeaf0, 0x0000, 0xeaef, 0x0000, 0xeaf5, 0xeaf9, 0xeaf6,
0xeba1, 0x5da1, 0xc9a5, 0xe6f1, 0x0000, 0xe2af, 0xe2e2, 0xe6d0,
0x55d0, 0x55d1, 0xe6d3, 0x55d5, 0x0000, 0x0000, 0x55d7, 0x0000,
0x0000, 0xe6d5, 0x0000, 0xe6cf, 0x55dc, 0x0000, 0xe6d9, 0x0000,
0xe6da, 0x0000, 0x55e8, 0xeba9, 0x0000, 0x0000, 0x0000,
	/* 0xf240 */
0x0000, 0xf1d3, 0x0000, 0x69b5, 0x69b6, 0xbdd9, 0x0000, 0xf1d5,
0x69b7, 0x69b8, 0x69b9, 0xf1d7, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x69ba, 0x69bb, 0x0000, 0xb5b3, 0xf1d6, 0x69bc, 0x69bd,
0xc1fb, 0xb8b3, 0x0000, 0x0000, 0x69be, 0x0000, 0x0000, 0xf1d9,
0x0000, 0x0000, 0x0000, 0x0000, 0x69bf, 0x0000, 0x69c0, 0x0000,
0x69c1, 0x69c2, 0x69c3, 0x0000, 0x0000, 0x69c4, 0xc2cd, 0x0000,
0x0000, 0xf1da, 0x0000, 0x69c5, 0x69c6, 0x0000, 0xc6ad, 0x0000,
0x0000, 0x69c7, 0x0000, 0x69c8, 0x69c9, 0xf1db, 0x69ca, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf1e0, 0x0000, 0xf1de,
0x69cc, 0xf1dd, 0xf1df, 0x69cd, 0xf1dc, 0x0000, 0x69cb, 0x0000,
0x0000, 0x69ce, 0x69cf, 0x69d0, 0xf1e2, 0x69d1, 0x0000, 0x0000,
0x69d2, 0x0000, 0x0000, 0x69d3, 0xf1e1, 0x69d4, 0xf1e4, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe9c8, 0xe9ca,
0x5ac6, 0x0000, 0x0000, 0x5acb, 0x0000, 0xb0ba, 0x5ad5, 0x5acc,
0xe9d2, 0x0000, 0x0000, 0x5ad4, 0xe9cf, 0xe9d1, 0xe9ce, 0xe9d0,
0xe9d4, 0xe9d6, 0x5ada, 0xb3c2, 0xe9d8, 0x0000, 0x5ad7, 0xe9d5,
0xe9d9, 0x0000, 0x5ad9, 0xe9de, 0x0000, 0x0000, 0xc9c8, 0x0000,
0x0000, 0x5af8, 0xe9dd, 0x0000, 0xe9e0, 0x0000, 0x5ae3, 0xe9e7,
0x5af3, 0xc2fd, 0xe9e5, 0xe9ed, 0xe9eb, 0xe9ea, 0x5afe, 0xe9f1,
0x5afb, 0xe9f2, 0x5ba2, 0xe9f4, 0x5baa, 0x0000, 0xe9ee, 0x5ba4,
0xe9f3, 0xe9f0, 0xe9ef, 0xeaa7, 0x0000, 0x0000, 0x0000, 0x5bb7,
0xe9f5, 0x0000, 0xe9f8, 0xe9fd, 0x5bbf, 0xeaa1, 0xeaa2, 0x0000,
0x5bb2, 0xe9fe, 0x5bb3, 0x5bc2, 0xeaa8, 0x0000, 0xeabd,
	/* 0xf340 */
0xb6c3, 0xf1e3, 0x0000, 0x69d5, 0x0000, 0xf1e5, 0x0000, 0x0000,
0xf1e6, 0x0000, 0xf1e8, 0xf1e7, 0x0000, 0x0000, 0x0000, 0xf1e9,
0xf1eb, 0xf1ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x69d6, 0x0000, 0x69d7, 0xf1ec,
0x69d8, 0x69d9, 0x69da, 0x0000, 0x69db, 0x69dc, 0x69de, 0x69df,
0x0000, 0x69e0, 0x69e1, 0x69e3, 0xbff1, 0x69e4, 0x0000, 0x69e5,
0x0000, 0x0000, 0x0000, 0x69e6, 0xf1f0, 0x69e7, 0x69e8, 0xf1f3,
0x69e9, 0x69ea, 0x69eb, 0x0000, 0x0000, 0x69ec, 0x69ed, 0x0000,
0x0000, 0xf1f4, 0x69ee, 0xf1f6, 0xf1f7, 0x69ef, 0x69f0, 0x69f1,
0x0000, 0x69f2, 0xc8b1, 0x69f3, 0xf1fb, 0x0000, 0xf1fd, 0x69f4,
0x69f5, 0xf1fc, 0x69f6, 0x0000, 0xf1fe, 0x0000, 0x69f8, 0x0000,
0x69f9, 0x0000, 0x69fa, 0x69fb, 0x69fc, 0x69fd, 0x6aa1, 0x6aa2,
0xf2a2, 0xeab2, 0x5bbd, 0x5bba, 0x5bcc, 0x5bc4, 0x5bb8, 0xeaae,
0x0000, 0x5bcb, 0x5bcf, 0xeab0, 0xeaa9, 0x0000, 0xeaaa, 0x0000,
0xeaab, 0x5bd5, 0x0000, 0x5be0, 0xeab6, 0x0000, 0xeabf, 0x5bf1,
0xeab9, 0x5bec, 0x5bf5, 0xeac2, 0xeac5, 0x5ca2, 0xb4cc, 0x0000,
0x54f1, 0xe6a1, 0xe7d3, 0xbcb3, 0x51f1, 0xb5e8, 0x0000, 0xe4a2,
0x0000, 0xe3f5, 0x51fa, 0xe3f4, 0x52a7, 0x0000, 0x51f9, 0xe3f9,
0x51fc, 0x52a1, 0xb3de, 0xbfda, 0x0000, 0xe3f7, 0x0000, 0xe3fa,
0x0000, 0x0000, 0xe4a6, 0xe4a7, 0xe4a5, 0xe4b8, 0x52aa, 0xe4ae,
0x0000, 0x0000, 0x52b1, 0xe4ac, 0x52b7, 0x0000, 0x0000, 0xc8a4,
0x52be, 0xe4af, 0x0000, 0x0000, 0xc3bd, 0xe4b3, 0x0000, 0x0000,
0xe4be, 0x0000, 0xe4bb, 0xe4bc, 0xe4c0, 0x52d0, 0xe4c5, 0xe4c4,
0x52d3, 0x52e3, 0x52db, 0x52da, 0x52e5, 0x0000, 0x52e2,
	/* 0xf440 */
0x0000, 0x6aa4, 0x0000, 0x6aa5, 0x6aa6, 0x6aa7, 0x6aa8, 0x6aa9,
0x0000, 0x6aaa, 0x0000, 0x0000, 0x6aab, 0x0000, 0xf2a3, 0x6aac,
0xf2a4, 0x6aad, 0x6aae, 0x0000, 0x0000, 0x6aaf, 0x0000, 0xf2a6,
0x0000, 0xf2a8, 0x6ab0, 0xf2a9, 0xf2aa, 0xf2ab, 0xf2ac, 0x6ab1,
0x0000, 0x6ab2, 0xf2ad, 0x0000, 0xddb5, 0x6ab3, 0x6ab4, 0x6ab5,
0x0000, 0x6ab6, 0x0000, 0x6ab7, 0x6ab8, 0x6ab9, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x6abb, 0x6abc, 0xf2b4, 0x0000, 0x0000,
0x0000, 0x6abd, 0x6abe, 0x6abf, 0xf2b6, 0x0000, 0xb5fb, 0x0000,
0x6ac0, 0x0000, 0x0000, 0x6ac1, 0x0000, 0x0000, 0x6ac2, 0x0000,
0x6ac3, 0x0000, 0x6ac4, 0x6ac5, 0x0000, 0x6ac6, 0x0000, 0x6ac7,
0x6ac8, 0x6ac9, 0x6aca, 0x6acb, 0xcfa5, 0x0000, 0x0000, 0x0000,
0x6acc, 0xf2b7, 0x6acd, 0x0000, 0x6ace, 0x6acf, 0x6ad0, 0x0000,
0x0000, 0xe4d2, 0xe4d1, 0x52ea, 0xc8f6, 0x0000, 0xe4da, 0xe7cc,
0xe7cd, 0xe7ce, 0x0000, 0x56e3, 0xeac8, 0x56f5, 0x56f6, 0x0000,
0x0000, 0x0000, 0x56f7, 0xe7d6, 0xe7d7, 0x0000, 0xe7d8, 0x56f9,
0x0000, 0x56fc, 0x0000, 0x57a1, 0x57a3, 0xe7dd, 0xe7de, 0xe7e1,
0xead0, 0x0000, 0xb7b6, 0xeae4, 0xbac0, 0xeafe, 0xe6b8, 0x0000,
0x0000, 0xe6bb, 0x0000, 0xe6bc, 0x53aa, 0x41cc, 0x0000, 0x0000,
0x0000, 0x53b0, 0xe4e7, 0xe4ec, 0x53b8, 0xe4f0, 0x0000, 0x53bb,
0x0000, 0x53be, 0x53bc, 0xe4f2, 0x53c3, 0x0000, 0xbab1, 0x0000,
0x55b5, 0x55b9, 0xe6c5, 0x55be, 0xe6c7, 0xe6c8, 0xe6c9, 0x55c1,
0xe6ca, 0xbbe5, 0x0000, 0x54a2, 0xe5bb, 0x54d1, 0xe5fb, 0xf3d0,
0x6cef, 0xece2, 0x5fcc, 0x0000, 0x5fd0, 0x0000, 0xecdf, 0xece0,
0x5ee7, 0x5ee8, 0xeec4, 0x0000, 0xc3f1, 0x62d6, 0x62dd,
	/* 0xf540 */
0x0000, 0x0000, 0x0000, 0x6ad1, 0x6ad2, 0x0000, 0x0000, 0xf2b9,
0x6ad3, 0x6ad4, 0x6ad5, 0x6ad6, 0x0000, 0x6ad7, 0x6ad8, 0x6ad9,
0x0000, 0x6ada, 0xb0be, 0x6adb, 0x6adc, 0xf2ba, 0xcaab, 0xf2b8,
0x6add, 0x0000, 0xf2bb, 0xf2bc, 0x0000, 0x0000, 0x6ade, 0x0000,
0x0000, 0x6adf, 0x6ae0, 0xf2bd, 0xf2be, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x6ae1, 0x6ae2, 0xf2bf, 0x6ae3, 0xcbee, 0xbbad,
0x6ae4, 0xbafa, 0xc1af, 0x0000, 0x6ae5, 0x6ae6, 0x6ae7, 0x0000,
0xf2c0, 0x0000, 0x0000, 0x6ae8, 0x6ae9, 0xf2c3, 0x0000, 0x0000,
0x6aea, 0x6aeb, 0x0000, 0x6aec, 0x6aed, 0xf2c1, 0x6aee, 0x0000,
0x0000, 0x0000, 0x0000, 0xf2c4, 0x6aef, 0x6af0, 0xb8f1, 0xf2c2,
0x0000, 0x0000, 0x0000, 0x6af1, 0xf2c5, 0x6af2, 0xf2c6, 0xf2c7,
0x0000, 0xf2cb, 0x0000, 0xbbaa, 0x6af3, 0x6af4, 0x0000, 0x0000,
0xc2e4, 0xbfdd, 0x62dc, 0x0000, 0xeec9, 0x0000, 0x0000, 0x0000,
0xeecb, 0x62e0, 0x62e1, 0x0000, 0x62e6, 0xb8ef, 0xc2e9, 0x62ea,
0xeecf, 0x0000, 0xeed2, 0x62f4, 0x62f5, 0xeed1, 0xeed3, 0xeed4,
0xeed5, 0xecb5, 0x0000, 0x0000, 0xecef, 0x5ff6, 0xeda6, 0x60b8,
0x5fda, 0x0000, 0x5fef, 0xece7, 0x0000, 0xecea, 0x5fe8, 0xece9,
0x0000, 0x5fe4, 0xece8, 0xecec, 0x5fe0, 0x5fed, 0x0000, 0x0000,
0xecf1, 0x0000, 0x0000, 0x5fea, 0xecf4, 0x5ff3, 0x5ffa, 0xecf6,
0xecf9, 0x0000, 0x0000, 0x60a1, 0x0000, 0x0000, 0x60ab, 0x60a9,
0xecfb, 0x60aa, 0x60a4, 0xeda2, 0x60ac, 0xecfa, 0x0000, 0x0000,
0xecfe, 0x60bc, 0xedac, 0xedae, 0x60bb, 0xbdb3, 0xedb1, 0x0000,
0xedb7, 0x60c4, 0x0000, 0x60ca, 0xecb8, 0xecba, 0xecbd, 0xecbc,
0xecc2, 0xecc0, 0xdacf, 0x5db6, 0x0000, 0xebb8, 0xebb9,
	/* 0xf640 */
0x0000, 0x6af5, 0x0000, 0x6af6, 0x0000, 0xf2cc, 0xf2c9, 0xf2c8,
0xf2ca, 0x6af7, 0x0000, 0x6af8, 0xb7df, 0x0000, 0x6af9, 0x6afa,
0x0000, 0x0000, 0x0000, 0x6afb, 0xf2d0, 0xf2cf, 0xf2ce, 0x6afc,
0x0000, 0xb0b3, 0x0000, 0x6afd, 0x6afe, 0x6ba1, 0x6ba2, 0x0000,
0x0000, 0x6ba3, 0x0000, 0x6ba4, 0x6ba5, 0x0000, 0x6ba6, 0x0000,
0xf2da, 0x0000, 0xf2d6, 0x0000, 0xf2d7, 0xf2d3, 0xf2d9, 0x6ba7,
0xf2d5, 0xb3e2, 0x0000, 0x6ba8, 0xcfcc, 0x6ba9, 0xf2d8, 0xf2d4,
0xf2d2, 0xf2d1, 0x6baa, 0x0000, 0x6bab, 0x6bac, 0x6bad, 0x0000,
0xf2dc, 0x6bae, 0x0000, 0x6baf, 0x0000, 0x0000, 0xf2df, 0x6bb0,
0x6bb1, 0xf2de, 0xf2dd, 0x6bb2, 0x6bb3, 0x6bb4, 0x6bb5, 0x6bb6,
0x0000, 0x0000, 0xc9c9, 0xf2db, 0xb0f3, 0xf2e0, 0x6bb7, 0xf2e2,
0x0000, 0x0000, 0x6bb8, 0x6bb9, 0x6bba, 0x0000, 0xb3ef, 0xf2cd,
0xb1b7, 0x5db9, 0x5dbb, 0x0000, 0x5dd6, 0xebf2, 0x0000, 0x66fa,
0x0000, 0x66fb, 0xf0bd, 0x0000, 0xf0be, 0xf0c2, 0xf0c0, 0xf0c6,
0x0000, 0xf0c7, 0xf0ca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf0b2,
0xc8bb, 0x0000, 0xf0b3, 0x66f3, 0xe2da, 0x0000, 0x63fc, 0x0000,
0x64b9, 0x0000, 0x64f7, 0x65c2, 0x65ab, 0x0000, 0x65f5, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xf740 */
0x0000, 0x6bbb, 0xf2e4, 0x0000, 0x0000, 0x6bbc, 0x0000, 0x6bbd,
0x6bbe, 0x6bbf, 0xf2e3, 0xf2e1, 0xc3ad, 0x6bc0, 0x6bc1, 0x0000,
0x0000, 0x0000, 0x6bc2, 0x6bc3, 0x6bc4, 0x0000, 0xcbf0, 0x6bc5,
0x6bc6, 0x0000, 0x6bc7, 0xceda, 0x6bc8, 0x0000, 0xf2e5, 0x6bc9,
0x6bd0, 0x6bca, 0x6bcb, 0x6bcc, 0xf2e6, 0x0000, 0x0000, 0x6bcd,
0x0000, 0x0000, 0x0000, 0xf2e7, 0x6bd2, 0x6bce, 0x6bcf, 0x6bd1,
0x0000, 0x0000, 0x6bd3, 0x0000, 0x6bd4, 0x0000, 0x6bd5, 0x0000,
0x0000, 0x6bd6, 0xf2e8, 0x6bd7, 0xf2e9, 0x0000, 0x0000, 0x0000,
0x6bd8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0xf0da, 0xf0d9, 0x0000, 0x0000, 0x0000, 0x0000, 0xebf1, 0xf0e4,
0x67cf, 0xf0e6, 0x0000, 0xf1ed, 0x0000, 0x0000, 0x69dd, 0x0000,
0xf1ee, 0x69e2, 0xf1ef, 0x0000, 0x0000, 0x0000, 0x0000, 0xf1f1,
0xcca5, 0xf2b1, 0x0000, 0x0000, 0x6aba, 0xf2b3, 0xf2b5, 0x0000,
0x0000, 0xf1b8, 0xf1c3, 0x68ef, 0xf1f5, 0x0000, 0xf1f8, 0xf1f9,
0xf1fa, 0xf2a1, 0xc9a6, 0x69f7, 0x6aa3, 0x0000, 0x0000, 0xf2a5,
0xf2a7, 0x0000, 0xdde0, 0xe5db, 0x6cdd, 0x6ce1, 0xf3c7, 0xf3c8,
0xf3ca, 0xefb2, 0xf3cd, 0xcedb, 0xc2e3, 0xf3d9, 0xf3db, 0xf3dc,
0x6cf5, 0x0000, 0x0000, 0x6cf7, 0xf3dd, 0x0000, 0xf3df, 0x6db1,
0xf3ec, 0x6db5, 0x6dba, 0x6db9, 0x6dbd, 0xf3ed, 0x6dc1,
	/* 0xf840 */
0x0000, 0x0000, 0xc4bb, 0x6bd9, 0xf2ea, 0x0000, 0xc8b7, 0x0000,
0xf2ef, 0xf2eb, 0x0000, 0x0000, 0x0000, 0xf2ec, 0x0000, 0x6bda,
0xcbb1, 0xccc4, 0x0000, 0xc6d0, 0x6bdb, 0x0000, 0x6bdc, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6bde,
0xf2f0, 0x0000, 0x0000, 0xf2f1, 0xc6be, 0xf2ee, 0xf2ed, 0x0000,
0x6bdd, 0x0000, 0x0000, 0xb2aa, 0x0000, 0x0000, 0x6bdf, 0xf2f9,
0x0000, 0x0000, 0xf2f8, 0x0000, 0x6be0, 0x6be1, 0x0000, 0x0000,
0xb1f5, 0x6be2, 0x6be3, 0x6be4, 0xf2f6, 0x0000, 0x0000, 0x0000,
0x0000, 0xf2f5, 0x0000, 0x0000, 0xf2f3, 0x0000, 0xb3fb, 0x0000,
0xf2f2, 0xbcb2, 0xb2a9, 0x0000, 0x0000, 0x6be5, 0x6be6, 0x0000,
0x6be7, 0x6be8, 0x6be9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x6bea, 0xb9e3, 0x6beb, 0x6bed, 0xf2fc, 0xf2fb, 0x0000, 0xf2fa,
0x6bee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xf940 */
0x6bef, 0xf2f7, 0x6bec, 0xf2fd, 0x6bf0, 0xf2fe, 0x0000, 0x6bf1,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf3a5, 0xf3a4, 0x0000,
0x6bf2, 0x6bf3, 0x0000, 0x0000, 0x0000, 0x0000, 0xf3a6, 0x0000,
0x0000, 0xb1ad, 0xf3a1, 0xf3a2, 0x6bf4, 0xb9f4, 0xccb9, 0x6bf6,
0x6bf5, 0xf3a3, 0x6bf7, 0x0000, 0x0000, 0x0000, 0x6bf8, 0x6bf9,
0x6bfa, 0xcbb2, 0x0000, 0x0000, 0xf3ab, 0x6bfb, 0x0000, 0xf3a7,
0x0000, 0x0000, 0x0000, 0x6bfc, 0x6bfd, 0x0000, 0x0000, 0xf3ac,
0x6bfe, 0x6ca1, 0x0000, 0x6ca2, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x6ca3, 0x6ca4, 0x0000, 0x6ca5, 0xf3a9, 0x0000, 0xf3a8,
0x6ca6, 0x0000, 0x0000, 0x6ca7, 0x6ca8, 0xb7dc, 0x0000, 0x0000,
0x6ca9, 0x6caa, 0x0000, 0x6cab, 0x6cac, 0x6cad, 0x6cae, 0x0000,
0xf3ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6caf,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xfa40 */
0x0000, 0xf3ae, 0x0000, 0x0000, 0x0000, 0x0000, 0xf3af, 0x6cb0,
0xf3aa, 0x6cb1, 0x0000, 0x6cb2, 0xf2f4, 0x0000, 0x6cb3, 0xf3b0,
0x0000, 0xc4e1, 0x6cb4, 0x0000, 0x0000, 0xf3b4, 0x6cb5, 0xf3b5,
0xf3b3, 0x6cb6, 0x0000, 0x0000, 0x6cb7, 0x0000, 0xf3b2, 0xf3b8,
0x6cb8, 0xf3b1, 0x0000, 0xf3b6, 0x6cb9, 0x0000, 0x6cba, 0x6cbb,
0x0000, 0x0000, 0x0000, 0x0000, 0xf3b7, 0x0000, 0x0000, 0x0000,
0xf3ba, 0x6cbc, 0x6cbd, 0x6cbe, 0x6cbf, 0x0000, 0xf3b9, 0x6cc0,
0x0000, 0x0000, 0x0000, 0x6cc1, 0x6cc2, 0x6cc3, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x6cc4, 0xf3bc, 0x6cc5, 0x0000, 0x6cc6,
0x0000, 0x6cc7, 0x0000, 0xf3bd, 0x6cc8, 0xf3be, 0x6cc9, 0x0000,
0xcfc9, 0x6cca, 0x6ccb, 0x0000, 0x0000, 0x0000, 0xf3bb, 0xc2eb,
0xbaed, 0x0000, 0x0000, 0xf3bf, 0x6ccc, 0x0000, 0x0000, 0x0000,
0x6cce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xfb40 */
0x0000, 0x0000, 0x0000, 0x0000, 0x6ccf, 0x0000, 0x0000, 0x6ccd,
0x0000, 0x0000, 0x0000, 0x6cd0, 0x0000, 0x6cd1, 0x6cd2, 0x6cd3,
0x0000, 0x0000, 0x6cd4, 0x6cd5, 0x0000, 0x0000, 0x6cd6, 0xf3c0,
0xf3c1, 0x6cd7, 0x6cd8, 0xf3c2, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf3c3, 0x0000, 0x0000,
0xb8b4, 0xf3c4, 0x6cd9, 0x6cda, 0x6cdb, 0xf3c5, 0x6cdc, 0x0000,
0xf3c6, 0x6cde, 0x6cdf, 0x6ce0, 0x0000, 0x0000, 0x0000, 0xf3c9,
0x0000, 0x6ce2, 0x6ce3, 0x0000, 0xf3cc, 0x0000, 0xf3cb, 0x6ce4,
0xceef, 0x6ce5, 0x0000, 0x0000, 0x6ce6, 0x0000, 0x6ce7, 0x0000,
0x0000, 0x0000, 0x0000, 0x6ce8, 0xf3ce, 0x0000, 0x6ce9, 0xf3cf,
0xf3d1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xfc40 */
0x0000, 0x6cea, 0xf3d2, 0x6ceb, 0x6cec, 0x6ced, 0x0000, 0x0000,
0x6cee, 0x6cf0, 0x0000, 0x0000, 0xb9ed, 0xcccd, 0xd6f7, 0xcbfb,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6cf1, 0x0000, 0x6cf2,
0x0000, 0x6cf3, 0xf3d4, 0xf3d7, 0xb9f5, 0x0000, 0x6cf4, 0x0000,
0x0000, 0xccdb, 0x0000, 0xf3da, 0x0000, 0x0000, 0x6cf6, 0x0000,
0xf3de, 0x0000, 0x6cf8, 0x6cf9, 0x6cfa, 0x6cfb, 0x6cfc, 0x6cfd,
0x0000, 0xf3e0, 0x6cfe, 0xf3e1, 0xf3e2, 0x6da1, 0x0000, 0xf3e6,
0x6da2, 0x0000, 0x0000, 0x6da3, 0x6da4, 0x0000, 0x0000, 0x0000,
0x0000, 0xf3e7, 0xf3e8, 0x6da5, 0x0000, 0x0000, 0x6da6, 0x6da8,
0x6da9, 0x6daa, 0xf3ea, 0x6dab, 0x0000, 0x6dae, 0x6daf, 0x0000,
0x0000, 0x0000, 0x6db0, 0xf3eb, 0x0000, 0x0000, 0x0000, 0x6db2,
0x0000, 0x0000, 0x0000, 0x6db3, 0x6db4, 0x0000, 0x0000, 0x0000,
0x6db6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	/* 0xfd40 */
0x6db7, 0x0000, 0x6db8, 0x0000, 0x0000, 0x0000, 0x6dbb, 0x6dbc,
0x6dbe, 0x0000, 0x6dbf, 0x0000, 0x6dc0, 0x6dc2, 0x6dc3, 0x6dc4,
0x0000, 0x0000, 0xf3ee, 0xe3b7, 0x0000, 0x0000, 0xecda, 0xf0ed,
0xf3ef, 0x6dc5, 0xf3f0, 0x6dc6, 0x6dc7, 0x6dc8, 0x6dc9, 0x0000,
0x6dca, 0x0000, 0x0000, 0x6dcb, 0x6dcc, 0xf3f2, 0xf3f3, 0xf3f4,
0xcef0, 0xf3f1, 0x0000, 0x0000, 0xf3f5, 0xf3f6, 0x6dcd, 0x6dce,
0xf3f8, 0x0000, 0xf3f7, 0x6dcf, 0x6dd0, 0x6dd1, 0x6dd2, 0x6dd3,
0xf3fa, 0x6dd4, 0x0000, 0x6dd5, 0xf3fb, 0xf3f9, 0x0000, 0x0000,
0x0000, 0x6dd6, 0x0000, 0x0000, 0x6dd7, 0x0000, 0x0000, 0x0000,
0xceb6, 0x0000, 0x6dd8, 0x6dd9, 0x6dda, 0x6ddb, 0x0000, 0x6ddc,
0xf3fc, 0x6ddd, 0x6dde, 0x0000, 0xf3fd, 0xe3d4, 0x6ddf, 0x6de0,
0x6de1, 0x6de2, 0x0000, 0x6de3, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};

unsigned long
gbk_decode(unsigned long code)
{
	int b1, b2;
	unsigned long v;

	if (code > 0xffff)
		return 0;
	b1 = (code >> 8) & 0xff;
	if (b1 < 0x81 || b1 > 0xfe)
		return 0;
	v = (b1 - 0x81) * 191;

	b2 = code & 0xff;
	if (b2 < 0x40 || b2 > 0xfe)
		return 0;
	v += b2 - 0x40;

	if (v < sizeof(gbk_euc) / sizeof(gbk_euc[0])) {
		v = gbk_euc[v];
		if (!(v & 0x8000))
			v |= 0x8f8000;
		return v;
	}
	return 0;
}
