/* $Id: banner.c,v 1.4 2015/09/29 13:17:42 onoe Exp $ */

/*-
 * Copyright (c) 1999 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>

#include "cue.h"

#define	BFONT_HEIGHT	5
#define	BFONT_WIDTH	5
#ifndef LINE_WIDTH
#define	LINE_WIDTH	80
#endif

static const char font[][BFONT_HEIGHT][BFONT_WIDTH] = {
    {
	"     ",
	"     ",
	"     ",
	"     ",
	"     ",
    },
    {
	"  #  ",
	"  #  ",
	"  #  ",
	"     ",
	"  #  ",
    },
    {
	" # # ",
	" # # ",
	"     ",
	"     ",
	"     ",
    },
    {
	" # # ",
	"#####",
	" # # ",
	"#####",
	" # # ",
    },
    {
	" ### ",
	"# #  ",
	" ### ",
	"  # #",
	" ### ",
    },
    {
	" #  #",
	"   # ",
	"  #  ",
	" #   ",
	"#  # ",
    },
    {
	" ##  ",
	"#  # ",
	" ##  ",
	"#  ##",
	" ####",
    },
    {
	"   # ",
	"  #  ",
	"     ",
	"     ",
	"     ",
    },
    {
	"  #  ",
	" #   ",
	" #   ",
	" #   ",
	"  #  ",
    },
    {
	"  #  ",
	"   # ",
	"   # ",
	"   # ",
	"  #  ",
    },
    {
	"#   #",
	" ### ",
	"#####",
	" ### ",
	"#   #",
    },
    {
	"  #  ",
	"  #  ",
	"#####",
	"  #  ",
	"  #  ",
    },
    {
	"     ",
	"     ",
	"     ",
	" ##  ",
	"  #  ",
    },
    {
	"     ",
	"     ",
	"#####",
	"     ",
	"     ",
    },
    {
	"     ",
	"     ",
	"     ",
	" ##  ",
	" ##  ",
    },
    {
	"    #",
	"   # ",
	"  #  ",
	" #   ",
	"#    ",
    },
    {
	" ### ",
	"#  ##",
	"# # #",
	"##  #",
	" ### ",
    },
    {
	"  #  ",
	" ##  ",
	"  #  ",
	"  #  ",
	" ### ",
    },
    {
	" ### ",
	"#   #",
	"  ## ",
	" #   ",
	"#####",
    },
    {
	"#### ",
	"    #",
	" ### ",
	"    #",
	"#### ",
    },
    {
	"   # ",
	"  ## ",
	" # # ",
	"#####",
	"   # ",
    },
    {
	"#####",
	"#    ",
	"#### ",
	"    #",
	"#### ",
    },
    {
	" ### ",
	"#    ",
	"#### ",
	"#   #",
	" ### ",
    },
    {
	"#####",
	"#   #",
	"   # ",
	"   # ",
	"  #  ",
    },
    {
	" ### ",
	"#   #",
	" ### ",
	"#   #",
	" ### ",
    },
    {
	" ### ",
	"#   #",
	" ####",
	"   # ",
	"  #  ",
    },
    {
	"     ",
	"  #  ",
	"     ",
	"  #  ",
	"     ",
    },
    {
	"     ",
	"  #  ",
	"     ",
	"  #  ",
	" #   ",
    },
    {
	"   # ",
	"  #  ",
	" #   ",
	"  #  ",
	"   # ",
    },
    {
	"     ",
	"#####",
	"     ",
	"#####",
	"     ",
    },
    {
	" #   ",
	"  #  ",
	"   # ",
	"  #  ",
	" #   ",
    },
    {
	" ### ",
	"#   #",
	"  ## ",
	"  #  ",
	"  #  ",
    },
    {
	" ### ",
	"# ###",
	"# ###",
	"#    ",
	" ### ",
    },
    {
	" ### ",
	"#   #",
	"#####",
	"#   #",
	"#   #",
    },
    {
	"#### ",
	"#   #",
	"#### ",
	"#   #",
	"#### ",
    },
    {
	" ### ",
	"#   #",
	"#    ",
	"#   #",
	" ### ",
    },
    {
	"#### ",
	"#   #",
	"#   #",
	"#   #",
	"#### ",
    },
    {
	"#####",
	"#    ",
	"#### ",
	"#    ",
	"#####",
    },
    {
	"#####",
	"#    ",
	"#### ",
	"#    ",
	"#    ",
    },
    {
	" ### ",
	"#    ",
	"#  ##",
	"#   #",
	" ### ",
    },
    {
	"#   #",
	"#   #",
	"#####",
	"#   #",
	"#   #",
    },
    {
	" ### ",
	"  #  ",
	"  #  ",
	"  #  ",
	" ### ",
    },
    {
	"   ##",
	"    #",
	"    #",
	"#   #",
	" ### ",
    },
    {
	"#   #",
	"#  # ",
	"###  ",
	"#  # ",
	"#   #",
    },
    {
	"#    ",
	"#    ",
	"#    ",
	"#    ",
	"#####",
    },
    {
	"#   #",
	"## ##",
	"# # #",
	"#   #",
	"#   #",
    },
    {
	"#   #",
	"##  #",
	"# # #",
	"#  ##",
	"#   #",
    },
    {
	" ### ",
	"#   #",
	"#   #",
	"#   #",
	" ### ",
    },
    {
	"#### ",
	"#   #",
	"#### ",
	"#    ",
	"#    ",
    },
    {
	" ### ",
	"#   #",
	"# # #",
	"#  ##",
	" ## #",
    },
    {
	"#### ",
	"#   #",
	"#### ",
	"#  # ",
	"#   #",
    },
    {
	" ####",
	"#    ",
	" ### ",
	"    #",
	"#### ",
    },
    {
	"#####",
	"  #  ",
	"  #  ",
	"  #  ",
	"  #  ",
    },
    {
	"#   #",
	"#   #",
	"#   #",
	"#   #",
	" ### ",
    },
    {
	"#   #",
	"#   #",
	" # # ",
	" # # ",
	"  #  ",
    },
    {
	"#   #",
	"#   #",
	"# # #",
	"# # #",
	" # # ",
    },
    {
	"#   #",
	" # # ",
	"  #  ",
	" # # ",
	"#   #",
    },
    {
	"#   #",
	" # # ",
	"  #  ",
	"  #  ",
	"  #  ",
    },
    {
	"#####",
	"   # ",
	"  #  ",
	" #   ",
	"#####",
    },
    {
	" ### ",
	" #   ",
	" #   ",
	" #   ",
	" ### ",
    },
    {
	"#    ",
	" #   ",
	"  #  ",
	"   # ",
	"    #",
    },
    {
	" ### ",
	"   # ",
	"   # ",
	"   # ",
	" ### ",
    },
    {
	"  #  ",
	" # # ",
	"     ",
	"     ",
	"     ",
    },
    {
	"     ",
	"     ",
	"     ",
	"     ",
	"#####",
    },
    {
	"  #  ",
	"   # ",
	"     ",
	"     ",
	"     ",
    },
    {
	"     ",
	" ### ",
	"#  # ",
	"#  # ",
	" ####",
    },
    {
	"#    ",
	"#### ",
	"#   #",
	"#   #",
	"#### ",
    },
    {
	"     ",
	" ####",
	"#    ",
	"#    ",
	" ####",
    },
    {
	"    #",
	" ####",
	"#   #",
	"#   #",
	" ####",
    },
    {
	"     ",
	" ### ",
	"#####",
	"#    ",
	" ####",
    },
    {
	"   ##",
	" ####",
	"  #  ",
	"  #  ",
	"  #  ",
    },
    {
	"     ",
	" ### ",
	"#   #",
	" ####",
	"  ###",
    },
    {
	"#    ",
	"#### ",
	"#   #",
	"#   #",
	"#   #",
    },
    {
	"  #  ",
	"     ",
	" ##  ",
	"  #  ",
	" ### ",
    },
    {
	"   # ",
	"     ",
	" ### ",
	"   # ",
	" ##  ",
    },
    {
	"#    ",
	"#  # ",
	"# #  ",
	"## # ",
	"#   #",
    },
    {
	" ##  ",
	"  #  ",
	"  #  ",
	"  #  ",
	"  #  ",
    },
    {
	"     ",
	"## # ",
	"# # #",
	"# # #",
	"# # #",
    },
    {
	"     ",
	"#### ",
	"#   #",
	"#   #",
	"#   #",
    },
    {
	"     ",
	" ### ",
	"#   #",
	"#   #",
	" ### ",
    },
    {
	"     ",
	"#### ",
	"#   #",
	"#### ",
	"#    ",
    },
    {
	"     ",
	" ####",
	"#   #",
	" ####",
	"    #",
    },
    {
	"     ",
	"# ###",
	"##   ",
	"#    ",
	"#    ",
    },
    {
	"     ",
	" ### ",
	"#### ",
	"    #",
	" ### ",
    },
    {
	"  #  ",
	" ### ",
	"  #  ",
	"  #  ",
	"   # ",
    },
    {
	"     ",
	"#  # ",
	"#  # ",
	"#  # ",
	" ## #",
    },
    {
	"     ",
	"#   #",
	"#   #",
	" # # ",
	"  #  ",
    },
    {
	"     ",
	"#   #",
	"#   #",
	"# # #",
	" # # ",
    },
    {
	"     ",
	"#   #",
	" ### ",
	" ### ",
	"#   #",
    },
    {
	"     ",
	"#   #",
	" ####",
	"    #",
	" ### ",
    },
    {
	"     ",
	"#####",
	"  ## ",
	" ##  ",
	"#####",
    },
    {
	"  ## ",
	"  #  ",
	" #   ",
	"  #  ",
	"  ## ",
    },
    {
	"  #  ",
	"  #  ",
	"  #  ",
	"  #  ",
	"  #  ",
    },
    {
	" ##  ",
	"  #  ",
	"   # ",
	"  #  ",
	" ##  ",
    },
    {
	"     ",
	" #   ",
	"# # #",
	"   # ",
	"     ",
    }
};

char *
banner(const char *str)
{
	static char buf[LINE_WIDTH * BFONT_HEIGHT];
	const char *p;
	char *q;
	const char *d;
	int i, j;

	q = buf;
	for (i = 0; i < BFONT_HEIGHT; i++) {
		for (p = str; *p && p < str + (LINE_WIDTH / (BFONT_WIDTH + 1)); p++) {
			d = font[*p - ' '][i];
			for (j = 0; j < BFONT_WIDTH; j++)
				*q++ = *d++;
			*q++ = ' ';
		}
		*q++ = '\n';
	}
	*q = '\0';
	return buf;
}
