/* $Id: b64.h,v 1.3 2015/09/29 13:17:42 onoe Exp $ */

/*-
 * Copyright (c) 2005 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _B64_H
#define	_B64_H

struct b64_state {
	const char *bs_ptr;
	const char *bs_eptr;
	int	bs_hold;
	u_long	bs_code;
};

extern const char b64[64];
extern char rb64[256];

void b64_set(struct b64_state *bs, const char *p, const char *ep);
const char *b64_getptr(struct b64_state *bs);
int b64_filbuf(struct b64_state *bs);
int b64_ngetc(struct b64_state *bs, char *p, int n);

#define	b64_getc(bs)	(((bs)->bs_hold == 0 && b64_filbuf(bs)) ? -1 : \
	((bs)->bs_hold--, ((bs)->bs_code <<= 8) >> 24))
#define	b64_hold(bs)	((bs)->bs_hold)

#endif /* !_B64_H */
