#! /usr/bin/env python
from distutils.core import setup,Extension
from distutils.sysconfig import get_python_inc

ECCSOURCES = ["ecc/src/bigint.c",
			"ecc/src/ecc_wrap.c",
			"ecc/src/eliptic.c",
			"ecc/src/int_functions.c",
			"ecc/src/onb_integer.c",
			"ecc/src/onb.c",
			"ecc/src/protocols1.c",
			"ecc/src/sha.c"]

AESSOURCES = ["aes/src/rijndael-alg-fst.c",
			"aes/src/rijndael-api-fst.c",
			"aes/src/rijndael_wrap.c"]


SHASOURCES = ["sha256/src/sha256_wrap.c",
			"sha256/src/sha2.c"]

setup(name="cryptkit",
		version="0.9",
		description="Python Cryptographic toolkit.",
		author="Bryan Mongeau",
		author_email="bryan@eevolved.com",
		url="http://cryptkit.sourceforge.net",

		packages = ["ecc","aes","sha256","entropy","cryptsock"],
		package_dir = { "ecc":"ecc/src",
						"aes":"aes/src",
						"sha256":"sha256/src",
						"entropy":"entropy/src",
						"cryptsock":"cryptsock/src" },

		ext_modules = [Extension("ellipticc",
						sources=ECCSOURCES,
						include_dirs=[get_python_inc(plat_specific=1)]),

						Extension("rijndaelc",
						sources=AESSOURCES,
						include_dirs=[get_python_inc(plat_specific=1)]),

						Extension("sha256c",
						sources=SHASOURCES,
						include_dirs=[get_python_inc(plat_specific=1)]),

						]

)
