/* This file is part of cqual.
   Copyright (C) 2000-2003 The Regents of the University of California.

cqual is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

cqual is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cqual; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef LOCATION_H
#define LOCATION_H

#include "config.h"
#include "bool.h"
#include "typed_set.h"

typedef struct Location
{ 
  char *filename;
  unsigned long lineno;
  unsigned long filepos; /* Offset in file */
  bool in_system_header;
  int location_index; /* A unique identifier for each program location */
} *location;

unsigned long location_hash(location loc);
bool location_eq(location loc1, location loc2);
int location_cmp(location loc1, location loc2);
int location_index(location loc);

/* Set the original .c file that a preprocessed output
   file was derived from. */
void file_set_orig_name(const char *name, const char *orig_name);
const char *file_get_orig_name(const char *name);

/* Mark a file as a prelude file */
void file_set_isprelude(const char *name, bool isprelude);
bool file_get_isprelude(const char *name);

DEFINE_SET(loc_set, location, location_cmp);
#define scan_loc_set(var, scanner, set) \
for (loc_set_scan(set, &scanner), var = loc_set_next(&scanner); \
     var; \
     var = loc_set_next(&scanner))

#endif
