/* This file is part of cqual.
   Copyright (C) 2002-2003 The Regents of the University of California.

cqual is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

cqual is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cqual; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef COMMON_ANALYZE_H
#define COMMON_ANALYZE_H

#include "analyze.h"
#include "cqual.h"
#include "hash.h"
#include "qerror.h"
#include "qtype.h"
#include "utils.h"
#include "pam.h"
#include "effect.h"
#include "dd_list.h"
#include "error-messages.h"

EXTERN_C_BEGIN

/*************************************************************************
 *
 * This header contains stuff that 
 *  -is shared between cil-analyze.c and analyze.c
 *  -but shouldn't be exported to anyone else
 *
 *************************************************************************/


typedef enum { lpos, rpos, apos } context;
/* What kind of position we're in. apos = & context */

typedef struct einfo {
  qtype qt;    /* Standard qtype */
  effect eff;     /* Locations read, written, or restricted */
  bool ismalloc;
} einfo;

typedef struct sinfo {
  effect eff;     /* Locations read, written, or restricted */
} sinfo;

typedef struct dinfo {
  effect eff;    /* Locations read, written, or restricted */
  effect alocs;  /* Locations bound in environment by this decl */
  dd_list drinfolist;
} dinfo;


/* Operator signatures */
typedef struct operator
{
  const char *name;
  enum sig_kind { sig_deref, sig_addr, sig_unop, sig_binop, sig_assign } sig;
  qtype qt;
} *operator;

extern struct operator operators[];

#define exists_op_kind(k) (find_op_kind(k) != NULL)

inline operator find_op_name(const char *name);
void reset_operators(void);
bool match_signature(enum sig_kind k, qtype qt, location loc);
bool add_op_signature(operator op, qtype qt, location loc);
bool add_op_constraints(operator op, qtype ret_qt, qtype arg1_qt, qtype arg2_qt,
                        location loc, const char *error_message);
operator find_op_kind(ast_kind k);

/* function prototypes */
einfo do_assign(einfo arg1, einfo arg2, location loc, effect eff);
einfo do_cast(einfo arg1, bool is_lexical_cst, type cast_t, location loc, context context);
einfo do_sizealign_of(const char *tag, location loc, context context);
einfo do_boolop(location, bool is_eq_or_neq, bool dna1, bool dna2,
		einfo arg1, einfo arg2, effect, operator);
sinfo do_change_type(einfo exp, type t, qtype *qt, location loc);
sinfo do_assert_type(einfo exp, type t, qtype *qt, location loc, location tloc);

qtype do_dereference(location loc, qtype p);

einfo put_id_in_context(location, einfo, context);
void init_string(location, qtype lhs_qtype, qtype rhs_qtype, const char *error_message);

inline void mk_effect_leq_global_env(effect e);
inline void mk_effect_leq_global_effect(effect e);

extern void qtype_mklhs_nonconst(location, qtype);
extern void mkNonConst_qual(location, qual, const char *error_message);
extern void mkNonConst_pointer(location, qtype, const char *error_message);
extern void mkNonConst_aggregate(location, qtype, const char *error_message);
extern void mkConst_pointer(location, qtype, const char *error_message);

inline einfo mkeinfo(qtype qt, effect eff, bool ismalloc);
inline sinfo mksinfo(effect eff);
inline dinfo mkdinfo(effect eff, effect alocs);

bool file_pointer_qtype(qtype qt);


EXTERN_C_END

#endif
