/*  $Id: c-api.h,v 1.1 2012/07/08 00:46:01 sarrazip Exp $

    flatzebra - SDL-based sound renderer
    Copyright (C) 2011 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA  02110-1301, USA.
*/

#pragma once

#include <stddef.h>


#ifdef __cplusplus
extern "C" {
#endif

/* TODO: doc these functions */

int flatzebra_sound_create(int rendererFreq);

void flatzebra_sound_destroy();

void flatzebra_sound_setMasterVolume(float linVol);

int flatzebra_sound_requestSquareWave(float startFreq,
                                  float endFreq,
                                  float attackLevel,
                                  float sustainLevel,
                                  float attackTime,
                                  float decayTime,
                                  float sustainTime,
                                  float releaseTime,
                                  size_t loopCount);

//int flatzebra_sound_setSquareWaveFreq(int sqWaveHandle, float newWaveFreq);

int flatzebra_sound_requestWhiteNoise(float attackLevel,
                                  float sustainLevel,
                                  float attackTime,
                                  float decayTime,
                                  float sustainTime,
                                  float releaseTime,
                                  size_t loopCount);

int flatzebra_sound_isRequestAlive(int reqHandle);

int flatzebra_sound_pauseMainBus();

int flatzebra_sound_resumeMainBus();

#ifdef __cplusplus
}  /* extern "C" */
#endif
