/*  $Id: WaveFileSource.h,v 1.1 2012/07/08 00:46:01 sarrazip Exp $

    flatzebra - SDL-based sound renderer
    Copyright (C) 2011 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA  02110-1301, USA.
*/

#pragma once

#include <roundbeetle/SampleSource.h>
#include <roundbeetle/WaveFileBuffer.h>


namespace roundbeetle {


class WaveFileSource : public SampleSource
{
public:

    WaveFileSource(const WaveFileBuffer &_waveFileBuffer);

    virtual ~WaveFileSource();

    // Returns mono PCM-16 signal.
    //
    virtual size_t getSamples(Sint16 *dest, size_t numRequested);

    virtual bool isFinished() const;

    virtual bool rewind();

private:

    WaveFileSource(const WaveFileSource &);
    WaveFileSource & operator = (const WaveFileSource &);

private:

    const WaveFileBuffer &waveFileBuffer;
    size_t sampleCounter;  // reading index

};


}  // namespace roundbeetle
