/*  $Id: SampleSource.h,v 1.1 2012/07/08 00:45:58 sarrazip Exp $

    flatzebra - SDL-based sound renderer
    Copyright (C) 2011 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA  02110-1301, USA.
*/

#pragma once

#include <roundbeetle/SoundRenderer.h>

#include <SDL.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <algorithm>
#include <iostream>


namespace roundbeetle {


class SampleSource
{
public:

    virtual ~SampleSource() {}

    // Returns a mono signal and the number of samples generated.
    //
    virtual size_t getSamples(Sint16 *dest, size_t numRequested) = 0;

    virtual bool isFinished() const = 0;

    virtual bool rewind() = 0;

};


}  // namespace roundbeetle
