/* aafont.c - generic library for drawing anti-aliased fonts
   Copyright (C) 1996-2000 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

void XAaFree (Font fid);

void XAaInit (Display * display, Visual * visual, int depth, Window root);

int XAaTextWidth (XFontStruct * font_struct, char *s, int length);

int XAaTextWidth16 (XFontStruct * font_struct, XChar2b * s, int length);

int XAaDrawImageString (Display * display, Drawable d, GC gc, int x, int y, char *s, int length);

int XAaDrawImageString16 (Display * display, Drawable d, GC gc, int x, int y, XChar2b * wc, int length);

#define RedFirst 0
#define BlueFirst 1

extern int option_interchar_spacing;
extern int option_rgb_order;


#define X_ENLARGEMENT	3
#define Y_ENLARGEMENT	5

#define SHRINK_WIDTH(x) (((x) + X_ENLARGEMENT) / 3 + option_interchar_spacing)
#define SHRINK_HEIGHT(x) (((x) + Y_ENLARGEMENT) / 3)
