# TO MAKE CHANGES USE "meta" DIRECTORY (see packgram docs).

import os
from setuptools import setup, find_packages

data_files = []
if data_files:
    try:
        if os.geteuid() != 0:
            data_files.clear()
    except Exception:
        pass

packages = find_packages(os.path.dirname(__file__) or '.', exclude=['tests*'])

setup(
    author='roll',
    author_email='roll@respect31.com',
    classifiers=[],       
    description='Color is a terminal color/style formatter.',
    data_files=data_files,
    download_url='https://github.com/respect31/color/tarball/0.3.0',
    entry_points={},
    license='MIT License',
    maintainer='roll',
    maintainer_email='roll@respect31.com',
    name='color',
    include_package_data=True,
    install_requires=[], 
    packages=packages,
    platforms=['Unix'],
    url='https://github.com/respect31/color',
    long_description='''.. TO MAKE CHANGES USE "meta" DIRECTORY (see packgram docs).

Color
=====================
Color is a terminal color/style formatter.

.. image:: http://img.shields.io/badge/code-GitHub-brightgreen.svg
     :target: https://github.com/respect31/color
     :alt: code
.. image:: http://img.shields.io/travis/respect31/color/master.svg
     :target: https://travis-ci.org/respect31/color 
     :alt: build
.. image:: http://img.shields.io/coveralls/respect31/color/master.svg 
     :target: https://coveralls.io/r/respect31/color  
     :alt: coverage
.. image:: http://img.shields.io/badge/docs-latest-brightgreen.svg
     :target: http://color.readthedocs.org
     :alt: docs     
.. image:: http://img.shields.io/pypi/v/color.svg
     :target: https://pypi.python.org/pypi?:action=display&name=color
     :alt: pypi


Example
-------

.. code-block:: python

  from color import Formatter, cformat, cprint
  
  # Format and print the string with full featured Formatter
  
  formatter = Formatter()
  with formatter.style(background='green'):
      with formatter.style(foreground='bright_red'):
          print(formatter.format('Red on green'))
      print(formatter.format('Bold on green', bold=True))
  
  # Do the same with cformat shortcut
  
  print(cformat('Red on green', background='green', foreground='bright_red'))
  print(cformat('Bold on green', background='green', bold=True))
  
  # Do the same with cprint shortcut using style dicts
  
  style1 = {'background':'green', 'foreground': 'bright_red'}
  style2 = {'background':'green', 'bold': True}
  
  cprint('Bright red on green', **style1)
  cprint('Bold on green', **style2)
  
  # Extend formatter styles using cprint shortcut
  
  cprint('Now it\'s crossed', crossed=True, styles={'crossed': 9})

Application
-----------
Package is under active development and is not ready for production use.
Backward-compatibility between minor releases (0.x.0), documentation and 
changelog are not guaranteed to be present before stable versions (>=1.0.0).

Requirements
------------
- Platforms

  - Unix
- Interpreters

  - Python 3.3
  - Python 3.4

Installation
------------
- pip install color

Contribution
------------
- Authors

  - roll <roll@respect31.com>
- Maintainers

  - roll <roll@respect31.com>

Changelog
---------
- no entries yet

License
-------
**MIT License**

Copyright (c) 2014 Respect31 <post@respect31.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
''',     
    tests_require=['nose', 'coverage'],
    test_suite='nose.collector',
    version='0.3.0')
