#ifndef MISC_H
#define MISC_H
#include <time.h>
void savegame(int [8][8],struct gamedat *,int [4]);
struct gamedat *loadgame(void);
void export_game(int,int);
void make_hash(hash *,board *,int [4],int);
void add_hash(hash_elt *,move *,long int,int,int,int,long int,int,int);
hash *find_hash(hash_elt *,long int,int,int);
void alter_hash(hash *,long int,int,move *,int,int);
void progress(int,int,int);
void get_pieces(board *);
void print_time(double);
double get_time(clock_t);
int get_num_from_string(char *,int);
void print_board(const board *);
void help(void);
void help_comp(void);
void help_analy(void);
void about(void);
void credits(void);
long int getparam(char *,int);
int get_time_limit(int,int,int,int,int);
void perform_epd_test(int,int,int,int,int);
board *get_board_fen(char *);
int same_move(move *,char *,board *);
void format_move(FILE *,move *,int);
int is_drawn_game(const board *,int);
void free_poslist(poslist *);
void get_poslist(compdat *,int,board *);
poslist *copy_poslist(poslist *);
int isinposlist(poslist *,long int,int);
void update_poslist(compdat *,int,long int,int);
int test_for_draw(int,int,board *,int);
char *board_to_fen(board *,int,int [4],move *);
move *check_opening(board *,int,int [4],move *,openpos *);
void learn_opening(int,int,openpos *,int);
openpos *load_openings(void);
void save_openings(openpos *);
void free_opening(openpos *);
int parseepd(char *,char *,char *,char *, char *, char [20][20],int);
int is_won_game(const board *,int,int,int);
int file_free(const board *,int,int,int);
void scan_book(openpos *);
void load_game_string(FILE *);
void perform_self_test(openpos *);
struct gamedat *import_pgn(void);
move *load_pgn_game(FILE *,int *);
void annotate_game(openpos *,int,int);
int check_opening_exists(board *,int,int [4],move *,move *,openpos *);
void free_mvlst(movelst *);
#endif /*  MISC_H */

