#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <assert.h>

#include "chess.h"
#include "eval.h"
#include "moves.h"
#include "checks.h"
#include "tactics.h"
#include "mprocs.h"
#include "misc.h"

extern int centre_board[8][8],squared[20];
int first_pawn[8][2]; /*  Stores pawn nearest to beginning on each file for white and black (i.e. nearest to  */
extern board defsq,defsqop;
int nrf[8][2],nrr[8][2];

int pts(int side,board *sq) { /*  Returns sum of all piece values on board. */
  int a,b,npts=0,p;

  for (a=0;a<8;a++) {
    for (b=0;b<8;b++) {
      p=sq->sq[a][b];
      if ((side==WHITE && p<1) || (side==BLACK && p>-1)) continue;
      p=abs(p);
      if (p==1) npts++;
      if (p==2) npts+=5;
      if (p==3) npts+=3;
      if (p==4) npts+=3;
      if (p==5) npts+=9;
    }
  }
  return npts;
}

 /*  Not used in computer player - used only for 'danger' command */
 /*  Does the same as sdef_nchk but includes checks, */
 /*  and only considers one side's pieces */
board *def(int side,board *sq) {
  int a,b,c,d;
  board *temp,*tot,*bd;
  move *mv;

  temp=malloc(sizeof(board));
  tot=malloc(sizeof(board));
  mv=malloc(sizeof(move));
  assert(temp!=NULL);assert(tot!=NULL);assert(mv!=NULL);
  mv->castle=mv->ep=0;
  memset(temp->sq, 0, sizeof(temp->sq));
  memset(tot->sq, 0, sizeof(tot->sq));

  for (a=0;a<8;a++) {
    for (b=0;b<8;b++) {
      if (sq->sq[a][b]!=0) {
    	if (side==WHITE && sq->sq[a][b]>0) {
	  if (sq->sq[a][b]==1 && a>0) {
	    if (b>0) (temp->sq[a-1][b-1])=1;
	    if (b<7) (temp->sq[a-1][b+1])=1;
	  }
	  if (sq->sq[a][b]==2) mprw(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==3) mpnw(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==4) mpbw(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==5) mpqw(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==6) mpkw(b,a,sq->sq,temp);
	}
	if (side==BLACK && sq->sq[a][b]<0) {
	  if (sq->sq[a][b]==-1 && a<7) {
	    if (b>0) (temp->sq[a+1][b-1])=1;
	    if (b<7) (temp->sq[a+1][b+1])=1;
	  }
	  if (sq->sq[a][b]==-2) mprb(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==-3) mpnb(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==-4) mpbb(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==-5) mpqb(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==-6) mpkb(b,a,sq->sq,temp);
	}
	for (c=0;c<8;c++) {
	  for (d=0;d<8;d++) {
	    if ((temp->sq[c][d])>0) {
	      temp->sq[c][d]=0;
	      mv->fx=b;mv->fy=a;
	      mv->tx=d;mv->ty=c;
	      bd=do_move(sq,mv,side);
	      if (abs(sq->sq[c][d])==6 || chck(bd,side)==0) (tot->sq[c][d])++;
	      free(bd);
	    }
          }
	}
      }
    }
  }
  free(mv);
  free(temp);
  return tot;
}

 /*  Returns boards containing defence scores for both players */
 /*  Currently used in human game not computer.  Too slow :(( */
board *sdef(int side,board *sq) {
  int a,b,c,d,s=0;
  board *temp,*tot,*bd;
  move *mv;

  temp=malloc(sizeof(board));
  tot=malloc(sizeof(board));
  mv=malloc(sizeof(move));
  assert(temp!=NULL);assert(tot!=NULL);assert(mv!=NULL);
  mv->castle=mv->ep=0;
  memset(temp->sq, 0, sizeof(temp->sq));
  memset(tot->sq, 0, sizeof(tot->sq));

  for (a=0;a<8;a++) {
    for (b=0;b<8;b++) {
      if (sq->sq[a][b]!=0) {
    	if (sq->sq[a][b]>0) {
          s=1;
	  if (sq->sq[a][b]==1 && a>0) {
	    if (b>0) (temp->sq[a-1][b-1])=1;
	    if (b<7) (temp->sq[a-1][b+1])=1;
	  }
	  if (sq->sq[a][b]==2) mprw(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==3) mpnw(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==4) mpbw(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==5) mpqw(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==6) mpkw(b,a,sq->sq,temp);
	}
	if (sq->sq[a][b]<0) {
          s=2;
	  if (sq->sq[a][b]==-1 && a<7) {
	    if (b>0) (temp->sq[a+1][b-1])=1;
	    if (b<7) (temp->sq[a+1][b+1])=1;
	  }
	  if (sq->sq[a][b]==-2) mprb(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==-3) mpnb(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==-4) mpbb(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==-5) mpqb(b,a,sq->sq,temp);
	  if (sq->sq[a][b]==-6) mpkb(b,a,sq->sq,temp);
	}
	for (c=0;c<8;c++) {
	  for (d=0;d<8;d++) {
	    if ((temp->sq[c][d])>0) {
	      temp->sq[c][d]=0;
              mv->fx=b;mv->fy=a;
              mv->tx=d;mv->ty=c;
              bd=do_move(sq,mv,s);
              if (abs(sq->sq[c][d])==6 || chck(bd,s)==0) {
  	        if (s==side) (tot->sq[c][d])++;
                else (tot->sq[c][d])--;
              }
              free(bd);
	    }
          }
	}
      }
    }
  }
  free(mv);
  free(temp);
  return tot;
}

 /*  Currently not used in computer player.  Returns a value based on sdef. */
int vdef(int side,board *sq) {
  int sc=0,a,b,p,d;
  board *bd;

  bd=sdef(side,sq);
  for (a=0;a<8;a++) {
    for (b=0;b<8;b++) {
      p=sq->sq[a][b];
      d=bd->sq[a][b];
      if (p==0) sc+=d;
      else if (d!=0) {
 	if (side==BLACK) p=0-p;
        if (d>0 && p==1) sc+=(d*3);
	if (d>0 && (p==3 || p==4)) sc+=(d*2);
        if (d>0 && p==2) sc+=d;
	if (d<0 && p>0) {
          if (p==1) sc+=(d*2);
	  if (p==2) sc-=6;
	  if (p==3 || p==4) sc+=(d*3);
	  if (p==5) sc-=10;
	}
      }
    }
  }
  free(bd);
  return sc;
}

 /*  Calculates total defence values for b&w, ignoring pinned pieces */
 /*  This is realistic as pins are only temporary, but a positional */
 /*  (dis)advantage can last.  This method is also much faster :) */
void sdef_nchk(const board *sq) {
  int a,b,p;

  memset(nrf, 0, sizeof(nrf));
  memset(nrr, 0, sizeof(nrr));
   for (a=0;a<8;a++) {
    for (b=0;b<8;b++) {
      p=sq->sq[a][b];
      switch(p) {
        case 0: break;
        case 1: if (a>0) {
	          if (b>0) (defsq.sq[a-1][b-1])++;
	          if (b<7) (defsq.sq[a-1][b+1])++;
	          if (a>first_pawn[b][0]) first_pawn[b][0]=a;
                }break;
        case 2: mpr(b,a,sq,&defsq);nrf[b][0]++;nrr[a][0]++;break;
        case 3: mpn(b,a,&defsq);break;
        case 4: mpb(b,a,sq,&defsq);break;
	case 5: mpq(b,a,sq,&defsq);nrf[b][0]++;nrr[a][0]++;break;
        case 6: mpk(b,a,&defsq);break;
        case -1: if (a<7) {
                   if (b>0) (defsqop.sq[a+1][b-1])++;
                   if (b<7) (defsqop.sq[a+1][b+1])++;
  	           if (a<first_pawn[b][1]) first_pawn[b][1]=a;
                 }break;
        case -2: mpr(b,a,sq,&defsqop);nrf[b][1]++;nrr[a][1]++;break;
        case -3: mpn(b,a,&defsqop);break;
        case -4: mpb(b,a,sq,&defsqop);break;
        case -5: mpq(b,a,sq,&defsqop);nrf[b][1]++;nrr[a][1]++;break;
        case -6: mpk(b,a,&defsqop);break;
        default: break;
      }
    }
  }
}


 /*  Score the given board for the specified player.
  *  Actually scores it for white, then if black it returns
  *  the negated score */
int defsc(const int side,const board *sq,const compdat *cd) {
  int sc=0,a,b,p,np=0,npo=0,bb[2],d,ypts=0,opts=0,sdiff=0,pieces_left=0;
  int rank7=0,orank7=0,thwin=0,att,def,enprise=0,kx=0,okx=0,wp=0,bp=0;

   /* If only kings and pawns ( & rooks )left then do special KP(R) endgame evals */
  if (cd->gamestage<31) {
    if (cd->gamestage==0) return 0;
    pieces_left=no_pieces(sq);
     /* No pieces left at all - just kings and pawns */
    if (pieces_left==0) return defsc_kp(side,sq,cd);
     /* Only kings and at least one rook plus 0 or more pawns */
    else if (pieces_left==2) return defsc_kpr(side,sq,cd);
    else if (pieces_left==3) return defsc_kpn(side,sq,cd);
    else if (pieces_left==4) return defsc_kpb(side,sq,cd);
  }

   /*  Score is 0 in a drawn game */
  if (cd->gamestage<=6 && is_drawn_game(sq,cd->gamestage)) return 0;

  for (a=0;a<8;a++) {first_pawn[a][0]=-1;first_pawn[a][1]=8;}
   
  /*  Get board of all squares attacked/defended */
  sdef_nchk(sq);

  bb[0]=bb[1]=0; /*  Set all necessary vars initially to zero */
  for (b=0;b<8;b++) {
    for (a=0;a<8;a++) {
      p=sq->sq[b][a]; /*  Get identifier of piece at current co-ordinates */
      def=defsq.sq[b][a];att=defsqop.sq[b][a];
      d=def-att; /* Overall defence value of current square */
      defsq.sq[b][a]=0; /*  Reset defsq ready for next use */
      defsqop.sq[b][a]=0; /*  Reset defsqop ready for next use */
       /* Check to see if current piece is attacked and not defended */
      if (p>0 && def==0 && att>0) enprise=1;
      else if (p<0 && def>0 && att==0) enprise=1;
      else enprise=0;
       /* Analyse the piece */
      switch(p) {
        case  0: if (d) sc+=d*centre_board[a][b]; break;
        case -1: if (((a+b)&1)==0) npo++; else npo--; sc+=d+d; bp++;
                   sc-=tact_pawn(sq,BLACK,a,b,cd,att,def);
	           if (d>0) sc+=ATTACKED_PAWN; break;
        case -2: sc-=tact_rook(sq,BLACK,a,b); if (b==6) orank7++;
	           if (enprise==1) sc+=ROOK_ENPR; break;
        case -3: sc-=tact_knight(sq,BLACK,a,b,cd);
                   sc+=d; if (d>0) sc+=ATTACKED_PIECE;
	           if (enprise==1) sc+=KNIGHT_ENPR; break;
        case -4: if (((a+b)&1)==1) bb[1]=1;
                   sc-=tact_bishop(sq,BLACK,a,b,cd); sc+=d;
	           if (d>0) sc+=ATTACKED_PIECE;
	           if (enprise==1) sc+=BISHOP_ENPR; break;
        case -5: sc-=tact_queen(sq,BLACK,a,b,cd); if (b==6) orank7++;
	           if (enprise==1) sc+=QUEEN_ENPR; break;
        case -6: sc-=tact_king(sq,BLACK,a,b,cd); okx=a; break;
        case  1: if (((a+b)&1)==0) np++; else np--; sc+=d+d; wp++;
	           if (d<0) sc-=ATTACKED_PAWN;
	           sc+=tact_pawn(sq,WHITE,a,b,cd,def,att); break;
        case  2: sc+=tact_rook(sq,WHITE,a,b); if (b==1) rank7++;
	           if (enprise==1) sc-=ROOK_ENPR; break;
        case  3: sc+=tact_knight(sq,WHITE,a,b,cd);
                   sc+=d; if (d<0) sc-=ATTACKED_PIECE;
	           if (enprise==1) sc-=KNIGHT_ENPR; break;
        case  4: if (((a+b)&1)==1) bb[0]=1; if (d<0) sc-=ATTACKED_PIECE;
                   sc+=tact_bishop(sq,WHITE,a,b,cd); sc+=d;
	           if (enprise==1) sc-=BISHOP_ENPR; break;
        case  5: sc+=tact_queen(sq,WHITE,a,b,cd); if (b==1) rank7++;
	           if (enprise==1) sc-=QUEEN_ENPR; break;
        case  6: sc+=tact_king(sq,WHITE,a,b,cd);kx=a; break;
        default: break;
      }
    }
  }

  for (a=0;a<8;a++) {
    if (nrf[a][0]>1) sc+=CONNECTED_ROOKS; /*  Bonus for having more than one rook on a file */
    if (nrf[a][1]>1) sc-=CONNECTED_ROOKS; /*  Penalty for opp. having more than one rook on a file */
  }
  if (wp==0) sc-=NO_PAWNS;     /*  White has no pawns so penalise */
  if (bp==0) sc+=NO_PAWNS;     /*  Black has no pawns so penalise */
   /* Penalise king safety if there is an unblocked rook attack on the same file */
  if (nrf[kx][1]==1) sc-=ROOK_THREAT;
  if (nrf[kx][1]>1) sc-=ROOK_THREAT*3;
  if (nrf[okx][0]==1) sc+=ROOK_THREAT;
  if (nrf[okx][0]>1) sc+=ROOK_THREAT*3;
   
   /*  Modifiers for pawns blocking bishops */
  if (sq->npieces[0][2]==1) { /*  White has only one bishop */
    if (bb[0]==1) sc+=np*2; /*  Bishop on black squares -> penalise for having lots of pawns on black squares */
    else sc-=np*2; /*  Ditto for white squares */
  }
  else if (bb[0]==1) sc+=TWO_BISHOPS; /*  Bonus for having both bishops */
  if (sq->npieces[1][2]==1) { /*  Opp. has only one bishop */
    if (bb[1]==1) sc-=npo*2; /*  Only black square bishop */
    else sc+=npo*2; /*  Only white square bishop */
  }
  else if (bb[1]==1) sc-=TWO_BISHOPS; /*  Penalty for opp. having two bishops */

   /*  Number of points each side has on the {1,5,3,3,9,0} scale */
  ypts=cd->pts[0];
  opts=cd->pts[1];
   /*  Error check :) */
  if (ypts+opts!=cd->gamestage) {fprintf(stderr,"PTS DON'T ADD UP IN DEFSC! (%d vs %d)\n",ypts+opts,cd->gamestage);print_board(sq);exit(0);}
   /*  Encourage to trade off if ahead. (Gives bonus if ahead of 2 for each point under 60 of total points in play.) */
  if (ypts!=opts) {
    sdiff=(78-cd->gamestage);
    if (ypts>opts) sc+=sdiff;
    else sc-=sdiff;
  }

   /*  RR, RQ, QQ pair (or more) on 7th rank.  Increased if king is on 8th rank. */
  if (rank7>1) {sc+=ATTACK_7TH_RANK;if (sq->kpos[3]==0) sc+=KING_TRAPPED;}
  if (orank7>1) {sc-=ATTACK_7TH_RANK;if (sq->kpos[1]==7) sc-=KING_TRAPPED;}

   /*  Score bonus for overall positional quality */
  sc+=tact_overall(sq,WHITE,cd);
   
   /*  If no mating material for one side then score cannot favour that side */
  if (ypts==0 || (ypts==3 && (sq->npieces[0][1]==1 || sq->npieces[0][2]==1))) sc=min(sc,0);
  if (opts==0 || (opts==3 && (sq->npieces[1][1]==1 || sq->npieces[1][2]==1))) sc=max(sc,0);

   /* Check if theoretically won */
  thwin=is_won_game(sq,WHITE,ypts,opts);
  if (thwin==1) sc+=THEORETICAL_WIN;
  else if (thwin==-1) sc-=THEORETICAL_WIN;

   /*  .. and finally return the total score. */
  if (side==WHITE) return sc;
  return -sc;
}

 /*  Score the given board for the specified player. */
 /*  Optimised for king and pawn endgames */
int defsc_kp(const int side,const board *sq,const compdat *cd) {
  int sc=0,a,b,p,ypts=0,opts=0,fp=8,fpo=8,lp=-1,lpo=-1,pdiff;
  int fpy=0,fpoy=0,lpy=0,lpoy=0;
  int att=0,np=0;

  for (a=0;a<8;a++) {
    for (b=0;b<8;b++) {
       /*  Get identifier of piece at current co-ordinates */
      p=sq->sq[b][a];
       /* Test to see if current square is a pawn, and if so then is it attacked? */
      if (abs(p)==1) {
	 /* Keep a count of the total number of pawns analysed so far */
	np++;
         /* 'att' holds if this pawn is being attacked */
      	att=0;
 	 /* Analyse a White pawn */
        if (p==1) {
 	  if (abs(sq->kpos[2]-a)<2 && abs(sq->kpos[3]-b)<2) att=1;
	  if (b>1 && a>0 && sq->sq[b-1][a-1]==-1) att=1;
	  if (b>1 && a<7 && sq->sq[b-1][a+1]==-1) att=1;
          sc+=tact_pawn_kp(sq,WHITE,a,b,att);
          if (file_free(sq,a,b,-1)) {
	    if (a<fp) {fp=a;fpy=b;}
	    if (a>lp) {lp=a;lpy=b;}
	  }
	}
	 /* Analyse a Black Pawn */
	else {
	  if (abs(sq->kpos[0]-a)<2 && abs(sq->kpos[1]-b)<2) att=1;
	  if (b<6 && a>0 && sq->sq[b+1][a-1]==1) att=1;
	  if (b<6 && a<7 && sq->sq[b+1][a+1]==1) att=1;
          sc-=tact_pawn_kp(sq,BLACK,a,b,att);
	  if (file_free(sq,a,b,1)) {
	    if (a<fpo) {fpo=a;fpoy=b;}
	    if (a>lpo) {lpo=a;lpoy=b;}
	  }
	}
	 /* End of pawn analysis */
      }
       /* We've analysed all of the pawns so stop */
      if (np==cd->gamestage) break;
    }
    if (np==cd->gamestage) break;
  }

  sc+=tact_king_kp(sq,WHITE,sq->kpos[0],sq->kpos[1]);
  sc-=tact_king_kp(sq,BLACK,sq->kpos[2],sq->kpos[3]);

   /* Bonus for well separated passed pawns */
  if (lp>-1 && lp>fp) {
    pdiff=(lp-fp);
    if (fp==0 || sq->pawnfile[fp-1][1]==0 || file_free(sq,fp-1,fpy-1,-1)) pdiff++;
    if (sq->pawnfile[fp+1][1]==0 || file_free(sq,fp+1,fpy-1,-1)) pdiff++;
    if (sq->pawnfile[lp-1][1]==0 || file_free(sq,lp-1,lpy-1,-1)) pdiff++;
    if (lp==7 || sq->pawnfile[lp+1][1]==0 || file_free(sq,lp+1,lpy-1,-1)) pdiff++;
    sc+=squared[pdiff];
  }
  if (lpo>-1 && lpo>fpo) {
    pdiff=(lpo-fpo);
    if (fpo==0 || sq->pawnfile[fpo-1][0]==0 || file_free(sq,fpo-1,fpoy+1,1)) pdiff++;
    if (sq->pawnfile[fpo+1][0]==0 || file_free(sq,fpo+1,fpoy+1,1)) pdiff++;
    if (sq->pawnfile[lpo-1][0]==0 || file_free(sq,lpo-1,lpoy+1,1)) pdiff++;
    if (lpo==7 || sq->pawnfile[lpo+1][0]==0 || file_free(sq,lpo+1,lpoy+1,1)) pdiff++;
    sc-=squared[pdiff];
  }
   /*  Number of points each side has on the {1,5,3,3,9,0} scale */
  ypts=cd->pts[0];
  opts=cd->pts[1];
   /*  Error check :) */
  if (ypts+opts!=cd->gamestage) {fprintf(stderr,"PTS DON'T ADD UP IN DEFSC! (%d vs %d)\n",ypts+opts,cd->gamestage);print_board(sq);exit(0);}
   /*  If no pawns for one side then score cannot favour that side */
  if (ypts==0) sc=min(sc,0);     
  if (opts==0) sc=max(sc,0);
   /*  Finally return the total score. */
  if (side==WHITE) return sc;
  return -sc;
}


 /* Score the given board for the specified player. */
 /* Optimised for king, (pawn) and rook endgames */
int defsc_kpr(const int side,const board *sq,const compdat *cd) {
  int sc=0,a,b,p,ypts=0,opts=0,nrry=0,nrro=0;
  int att=0,nrfy[8],nrfo[8],wp=0,bp=0;

  memset(nrfy, 0, sizeof(nrfy));
  memset(nrfo, 0, sizeof(nrfo));
   
  for (b=0;b<8;b++) {
    nrry=nrro=0;
    for (a=0;a<8;a++) {
      p=sq->sq[b][a]; /*  Get identifier of piece at current co-ordinates */
       /* Test to see if current square is a pawn, and if so then is it attacked? */
      if (abs(p)==1) {
        att=0;
 	 /* White pawn */
	if (abs(sq->kpos[2]-a)<2 && abs(sq->kpos[3]-b)<2) att++;
	if (b>1 && a>0 && sq->sq[b-1][a-1]==-1) att++;
	if (b>1 && a<7 && sq->sq[b-1][a+1]==-1) att++;
	if (abs(sq->kpos[0]-a)<2 && abs(sq->kpos[1]-b)<2) att--;
	if (b<6 && a>0 && sq->sq[b+1][a-1]==1) att--;
	if (b<6 && a<7 && sq->sq[b+1][a+1]==1) att--;
	 /* Black Pawn */
        if (p==-1) att=-att;
      }
      switch(p) {
        case -1: sc-=tact_pawn_kpr(sq,BLACK,a,b,cd,att);bp++;break;
        case -2: sc-=tact_rook_kpr(sq,BLACK,a,b);nrfo[a]++;nrro++;break;
        case -6: sc-=tact_king(sq,BLACK,a,b,cd);break;
        case  1: sc+=tact_pawn_kpr(sq,WHITE,a,b,cd,att);wp++;break;
        case  2: sc+=tact_rook_kpr(sq,WHITE,a,b);nrfy[a]++;nrry++;break;
        case  6: sc+=tact_king(sq,WHITE,a,b,cd);break;
        default: break;
      }
    }
    if (nrry>1) sc+=CONNECTED_ROOKS;
    if (nrro>1) sc-=CONNECTED_ROOKS;
  }
  for (a=0;a<8;a++) {
    if (nrfy[a]>1) sc+=CONNECTED_ROOKS; /*  Bonus for having more than one rook on a file */
    if (nrfo[a]>1) sc-=CONNECTED_ROOKS; /*  Penalty for opp. having more than one rook on a file */
  }
  if (wp==0) sc-=NO_PAWNS_KPR;     /*  White has no pawns so penalise */
  if (bp==0) sc+=NO_PAWNS_KPR;     /*  Black has no pawns so penalise */
   /* Bonus if no opp rooks */
  if (sq->npieces[1][0]==0) sc+=LONE_ROOK_BONUS;
   /* Penalty if you have no rooks */
  if (sq->npieces[0][0]==0) sc-=LONE_ROOK_BONUS;
   /* Number of points each side has on the {1,5,3,3,9,0} scale */
  ypts=cd->pts[0];
  opts=cd->pts[1];
   /*  Error check :) */
  if (ypts+opts!=cd->gamestage) {fprintf(stderr,"PTS DON'T ADD UP IN DEFSC! (%d vs %d)\n",ypts+opts,cd->gamestage);print_board(sq);exit(0);}
   /* Check if position is theoretically won */
  if (ypts==0) sc-=THEORETICAL_WIN; 
  if (opts==0) sc+=THEORETICAL_WIN; 
   /*  .. and finally return the total score. */
  if (side==WHITE) return sc;
  return -sc;
}

 /* Score the given board for the specified player. */
 /* Optimised for King, (pawn) and bishop endgames. */
int defsc_kpb(const int side,const board *sq,const compdat *cd) {
  int sc=0,a,b,p,np=0,npo=0,bb[2],ypts=0,opts=0,att=0,wp=0,bp=0;

   /*  Score is 0 in a drawn game */
  if (cd->gamestage==3 && (sq->npieces[0][2]==1 || sq->npieces[1][2]==1)) return 0;

  bb[0]=bb[1]=0; /*  Set all necessary vars initially to zero */
  for (b=0;b<8;b++) {
    for (a=0;a<8;a++) {
      p=sq->sq[b][a]; /*  Get identifier of piece at current co-ordinates */
       /* Test to see if current square is a pawn, and if so then is it attacked? */
      if (abs(p)==1) {
        att=0;
 	 /* White pawn */
	if (abs(sq->kpos[2]-a)<2 && abs(sq->kpos[3]-b)<2) att++;
	if (b>1 && a>0 && sq->sq[b-1][a-1]==-1) att++;
	if (b>1 && a<7 && sq->sq[b-1][a+1]==-1) att++;
	if (abs(sq->kpos[0]-a)<2 && abs(sq->kpos[1]-b)<2) att--;
	if (b<6 && a>0 && sq->sq[b+1][a-1]==1) att--;
	if (b<6 && a<7 && sq->sq[b+1][a+1]==1) att--;
	 /* Black Pawn */
        if (p==-1) att=-att;
      }
      switch(p) {
        case -1: if (((a+b)&1)==0) npo++;else npo--;bp++;
                   sc-=tact_pawn_kpb(sq,BLACK,a,b,cd,att);break;
        case -4: if (((a+b)&1)==1) bb[1]=1;
                   sc-=tact_bishop_kpb(a,b,cd);break;
        case -6: sc-=tact_king(sq,BLACK,a,b,cd);break;
        case  1: if (((a+b)&1)==0) np++;else np--;wp++;
	            sc+=tact_pawn_kpb(sq,WHITE,a,b,cd,att);break;
        case  4: if (((a+b)&1)==1) bb[0]=1;
                   sc+=tact_bishop_kpb(a,b,cd);break;
        case  6: sc+=tact_king(sq,WHITE,a,b,cd);break;
        default: break;
      }
    }
  }
  if (wp==0) sc-=NO_PAWNS_KPB;     /*  White has no pawns so penalise */
  if (bp==0) sc+=NO_PAWNS_KPB;     /*  Black has no pawns so penalise */
   /*  Modifiers for pawns blocking bishops */
  if (sq->npieces[0][2]==1) { /*  You have only one bishop */
    if (bb[0]==1) sc+=np*4; /*  Bishop on black squares -> penalise for having lots of pawns on black squares */
    else sc-=(np*4); /*  Ditto for white squares */
  }
   /*  Bonus for having both bishops */
  else if (bb[0]==1) sc+=TWO_BISHOPS_KPB;
  if (sq->npieces[1][2]==1) { /*  Opp. has only one bishop */
    if (bb[1]==1) sc-=(npo*4); /*  Only black square bishop */
    else sc+=(npo*4); /*  Only white square bishop */
  }
   /*  Penalty for opp. having two bishops */
  else if (bb[1]==1) sc-=TWO_BISHOPS_KPB;
   
   /*  Number of points each side has on the {1,5,3,3,9,0} scale */
  ypts=cd->pts[0];
  opts=cd->pts[1];
   /*  Error check :) */
  if (ypts+opts!=cd->gamestage) {fprintf(stderr,"PTS DON'T ADD UP IN DEFSC! (%d vs %d)\n",ypts+opts,cd->gamestage);print_board(sq);exit(0);}
   /*  If no mating material for one side then score cannot favour that side */
  if (ypts==0 || (ypts==3 && sq->npieces[0][2]==1)) sc=min(sc,0);     
  if (opts==0 || (opts==3 && sq->npieces[1][2]==1)) sc=max(sc,0);
   /* Check if theoretically won */
  if (ypts==0 && ((opts&1)==0 || sq->npieces[1][2]>1)) sc-=THEORETICAL_WIN;
  if (opts==0 && ((ypts&1)==0 || sq->npieces[0][2]>1)) sc+=THEORETICAL_WIN;
   /*  .. and finally return the total score. */
  if (side==WHITE) return sc;
  return -sc;
}

 /* Score the given board for the specified player.
  * Optimised for King, (pawn) and Knight endgames */
int defsc_kpn(const int side,const board *sq,const compdat *cd) {
  int sc=0,a,b,p,ypts=0,opts=0,att=0,wp=0,bp=0;

   /*  Score is 0 in a drawn game */
  if (cd->gamestage==3 || cd->gamestage==0 || (cd->gamestage==6 && sq->npieces[0][1]==1 && sq->npieces[1][1]==1)) return 0;

  for (b=0;b<8;b++) {
    for (a=0;a<8;a++) {
      p=sq->sq[b][a]; /*  Get identifier of piece at current co-ordinates */
       /* Test to see if current square is a pawn, and if so then is it attacked? */
      if (abs(p)==1) {
        att=0;
 	 /* White pawn */
	if (abs(sq->kpos[2]-a)<2 && abs(sq->kpos[3]-b)<2) att++;
	if (b>1 && a>0 && sq->sq[b-1][a-1]==-1) att++;
	if (b>1 && a<7 && sq->sq[b-1][a+1]==-1) att++;
	if (abs(sq->kpos[0]-a)<2 && abs(sq->kpos[1]-b)<2) att--;
	if (b<6 && a>0 && sq->sq[b+1][a-1]==1) att--;
	if (b<6 && a<7 && sq->sq[b+1][a+1]==1) att--;
	 /* Black Pawn */
        if (p==-1) att=-att;
      }
      switch(p) {
        case -1: sc-=tact_pawn_kpn(sq,BLACK,a,b,cd,att);bp++;break;
        case -3: sc-=tact_knight_kpn(sq,BLACK,a,b,cd);break;
        case -6: sc-=tact_king(sq,BLACK,a,b,cd);break;
        case  1: sc+=tact_pawn_kpn(sq,WHITE,a,b,cd,att);wp++;break;
        case  3: sc+=tact_knight_kpn(sq,WHITE,a,b,cd);break;
        case  6: sc+=tact_king(sq,WHITE,a,b,cd);break;
        default: break;
      }
    }
  }
  if (wp==0) sc-=NO_PAWNS_KPN;     /*  White has no pawns so penalise */
  if (bp==0) sc+=NO_PAWNS_KPN;     /*  Black has no pawns so penalise */
   /*  Number of points each side has on the {1,5,3,3,9,0} scale */
  ypts=cd->pts[0];
  opts=cd->pts[1];
   /*  Error check :) */
  if (ypts+opts!=cd->gamestage) {fprintf(stderr,"PTS DON'T ADD UP IN DEFSC! (%d vs %d)\n",ypts+opts,cd->gamestage);print_board(sq);exit(0);}
   /*  If no mating material for one side then score cannot favour that side */
  if (ypts==0 || (ypts==3 && sq->npieces[0][1]==1)) sc=min(sc,0);
  if (opts==0 || (opts==3 && sq->npieces[1][1]==1)) sc=max(sc,0);
   /* Check if theoretically won */
  if (opts==0 && (ypts-sq->npieces[0][1])>0) sc+=THEORETICAL_WIN;
  else if (ypts==0 && (opts-sq->npieces[1][1])>0) sc-=THEORETICAL_WIN;
   /*  .. and finally return the total score. */
  if (side==WHITE) return sc;
  return -sc;
}

 /* Test to see if there are no pieces left, or just pieces of one type,
  * currently rooks or bishops only  ->  specialist endgame functions */
int no_pieces(const board *sq) {
  int flg=0;

  if (sq->npieces[0][3]>0) return 1;
  if (sq->npieces[1][3]>0) return 1;
  if (sq->npieces[0][1]>0) flg=1;
  if (sq->npieces[1][1]>0) flg=1;
  if (sq->npieces[0][2]>0) {if (flg==1) return 1; else flg=2;}
  if (sq->npieces[1][2]>0) {if (flg==1) return 1; else flg=2;}
  if (sq->npieces[0][0]>0) {if (flg>0) return 1; else return 2;}
  if (sq->npieces[1][0]>0) {if (flg>0) return 1; else return 2;}
  if (flg==1) return 3;
  if (flg==2) return 4;
  return 0;
}
