#ifndef CHESS_H
#define CHESS_H

#define MAX_PV (50)
#define MAX_INPUT_LENGTH (100)
#define random2(a) (rand() % (a))

 /* A few compatability things */
#include <time.h>
#ifndef CLOCKS_PER_SEC
# ifdef CLK_TCK
#  define CLOCKS_PER_SEC CLK_TCK
# else
#  define CLOCKS_PER_SEC 1000000
# endif
#endif

#ifndef NULL
#define NULL ((void *)0)
#endif

 /* OK so I know that my code is unreadable without these... */

#define WHITE (1)
#define BLACK (2)

/*  Running Windows? You have my sympathy :) */

#ifndef _WIN32
/* Uncomment this following line for Windows version */
/*#define _WIN32*/
#endif

 /* Just incase they're not already defined */

#ifndef max /*  Returns the maximum of two numbers */
# define max(a,b)   (((a) > (b)) ? (a) : (b))
#endif
#ifndef min /*  Returns the minimum of two numbers */
# define min(a,b)   (((a) < (b)) ? (a) : (b))
#endif

#define VER "7.0"

#define THEORETICAL_WIN   (10000)

#define learn_max_ply     (40)

typedef struct {
  int fx,fy,tx,ty;
  long int score;
  int castle,gchk,ep,promote;  /*  gchk is if move gives check, promote is for pawn promotions (piece it turns into) */
  int type; /*  Not really used except occasionally as a flag - often to do with moves scored from the hash table */
  int capt,cm; /*  Identifier of piece that this move captures, and if this move gives cm */
}move;
typedef struct {
  int ty,tx;
}tosquare;
typedef struct {
  int sq[8][8];
  int kpos[4];  /*  King position.  0&1 are white king x,y.  2,3 are black king x,y */
  int pawnfile[8][2]; /*  Count of pawns for white (0) and black(1) on specified file */
  int npieces[2][4]; /*  List no. of each type of piece for each side.  First field is side-1, second is piece number-2 (2-5) */
  /*  Note - bottom right hand corner= 7,7 */
}board;
struct gamedat {  /*  Holds essential gamedata for save/load routines */
  int mvno,skillw,skillb;
  int side,cdm,death,quiesce,depth; /*  cdm is computer automove on/off */
  int sq[8][8];
  int cp[4]; /*  Castling allowed WKS,WQS,BKS,BQS */
  int proper; /*  (1/0) Is game a proper game, i.e. did it start from move 1 at the initial position, or is it a special position? */
};
typedef struct poslist { /*  Holds position list for draw by repetition */
 long int check,check2;
 struct poslist *next;
}poslist;
typedef struct { /*  Holds data for computer player */
  int side,inchk; /*  inchk is if in check from previous move */
  int skill,quiesce;
  int cp[4];
  move *last; /*  Previous move played */
  int tflg,capt; /*  tflg = ? capt is string of captures (+ = you're doing better, - = you're doing worse) */
  long int alpha,beta;
  int gamestage;
  int smove,svars; /*  suggested move for this iteration hashed into two ints. */
  int tlimit; /*  Time limit for computer moves */
  poslist *once[2],*twice[2]; /*  Used for draw by repetition */
  int followpv; /*  Follow the PV */
  int extend; /*  Number of quiescence width extensions */
  int pts[2]; /*  Points for each side */
}compdat;
typedef struct hash { /*  Entry in hash table */
  long int check; /* Checksum */
  int check2; /*  Secondary Checksum */
  short vars;    /* -- INCLUDES ALL CPs AS BINARY CP[0-3] & side(0/1)*16 -- */
  enum {exact,lower_bound,upper_bound} type;
  short depth,cm;
  long int score; /* Score for this position */
  int move; /*  Suggested move hashed into an int. */
  short mvars; /* Rest of the move data */
  struct hash *next;
}hash;
typedef struct { /*  Element of hash table. */
  hash *h; /*  List of hash entries */
  int num; /*  Number of hash entries */
}hash_elt;
typedef struct movelst{
  move mv;
  struct movelst *next;
}movelst;
typedef struct openpos{
  char *fen,*comments;
  movelst *moves;
  struct openpos *next;
}openpos;
typedef struct miscdata{
  int hash,ok;
  int learn,book;
}miscdata;
int main(int,char **);
int quap(int);
void error(int);
int test_check(int,board *,int,int);
void bye(void);
board *reset_board(void);
void load_pos_data(void);
void setup_precalculated_data(void);
#  ifdef _WIN32
miscdata load_ini_file(char *);
#  endif

# endif /*  CHESS_H */
