#!/bin/sh

# Setup env
set -xe
. /environ

# Clone git repository at branch / tag.
REPO='https://bitbucket.org/multicoreware/x265_git'; TAG='3.6'
git clone "$REPO" --depth=1 --branch="$TAG" /x265
cd /x265/source

# Make modifications to flags.
export CFLAGS=$(trim_spaces ${CFLAGS} \
                            -D_WASI_EMULATED_SIGNAL)
export LDFLAGS=$(trim_spaces ${LDFLAGS} \
                             -lwasi-emulated-signal)

(
    # Make 10bit lib
    mkdir 10bit
    cd 10bit
    cmake ../ -D CMAKE_CXX_FLAGS="$CXXFLAGS" \
              -D ENABLE_LIBNUMA=OFF \
              -D ENABLE_SHARED=OFF \
              -D ENABLE_CLI=OFF \
              -D HIGH_BIT_DEPTH=ON \
              -D EXPORT_C_API=OFF
    make -j $(nproc)
)

(
    # Make 10bit lib
    mkdir 12bit
    cd 12bit
    cmake ../ -D CMAKE_CXX_FLAGS="$CXXFLAGS" \
              -D ENABLE_LIBNUMA=OFF \
              -D ENABLE_SHARED=OFF \
              -D ENABLE_CLI=OFF \
              -D HIGH_BIT_DEPTH=ON \
              -D EXPORT_C_API=OFF \
              -D MAIN12=ON
    make -j $(nproc)
)

(
    # Make main lib
    mkdir main
    cd main
    cp ../10bit/libx265.a libx265_main10.a
    cp ../12bit/libx265.a libx265_main12.a
    cmake ../ -D CMAKE_CXX_FLAGS="$CXXFLAGS" \
              -D ENABLE_LIBNUMA=OFF \
              -D ENABLE_SHARED=OFF \
              -D ENABLE_CLI=OFF \
              -D EXTRA_LIB='x265_main10.a;x265_main12.a' \
              -D EXTRA_LINK_FLAGS=-L. \
              -D LINKED_10BIT=ON \
              -D LINKED_12BIT=ON
    make -j $(nproc)
	mv libx265.a libx265_main.a
)

cd main
merge_archives libx265.a \
               libx265_main.a \
               libx265_main10.a \
               libx265_main12.a
make install -j $(nproc)
