use crate::{
    actions::{repo::parse_owner_and_repo, GeneralArgs},
    types::context::BergContext,
};

use clap::Parser;

/// Delete a repository
#[derive(Parser, Debug)]
pub struct RepoDeleteArgs {
    /// Repository to be deleted
    #[arg(value_name = "OWNER/REPO")]
    pub owner_and_repo: String,
}

impl RepoDeleteArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        let _ = general_args;
        let ctx = BergContext::new(self, general_args).await?;

        let (owner, repo) = parse_owner_and_repo(ctx.args.owner_and_repo.as_str())?;
        ctx.client
            .repo_delete(owner.as_str(), repo.as_str())
            .await?;
        Ok(())
    }
}
