use inquire::{validator::Validation, Text};

pub fn mk_color_validator(prompt: Text) -> Text {
    prompt
        .with_help_message("(format: #xxxxxx)")
        .with_validator(|color: &str| {
            Ok((color.len() == 7
                && color.starts_with('#')
                && color
                    .chars()
                    .skip(1)
                    .take(6)
                    .filter(|digit| digit.is_ascii_hexdigit())
                    .count()
                    == 6)
                .then_some(Validation::Valid)
                .unwrap_or_else(|| Validation::Invalid("Not a color: format <#XXXXXX>".into())))
        })
}
