[![License: AGPL v3](https://img.shields.io/badge/License-AGPL_v3-blue.svg)](https://www.gnu.org/licenses/agpl-3.0)
[<img alt="crates.io" src="https://img.shields.io/crates/v/codeberg-cli.svg?style=for-the-badge&color=fc8d62&logo=rust" height="20">](https://crates.io/crates/codeberg-cli)

<details>
    <summary> `fjo` Updates </summary>

```
### 2024-04-20

`codeberg-cli` is un-deprecated since `fjo` development came to a halt before reaching feature pairity and I think we're better off including the findings here.

### End of 2023

We are thrilled to share a pivotal update on our software project. Thanks to recent developments, our project is now compatible with all Forgejo instances, not limited to Codeberg. As part of this expansion, the primary development focus will shift to our forked repository, [fjo](https://codeberg.org/VoiDD/fjo) in the future.

Rest assured, `codeberg-cli` will remain active. Our plan is to seamlessly incorporate new changes from the forked project here. We'll continue to make small adjustments to ensure smooth use, particularly for Codeberg, such as optimizing default values and Codeberg-specific features.

We appreciate your ongoing support and anticipate delivering even more enhancements soon.
```

</details>

______________________________________________________________________

<p align="center">
  <img alt="codeberg-cli logo" src="https://codeberg.org/Aviac/codeberg-cli/raw/branch/main/assets/logo.png" width="500">
</p>

# codeberg-cli (berg)

CLI Tool for [Codeberg](https://codeberg.org/) similar to `gh` and `glab`.

<p align="center">
  <img alt="Shell running the issue view command" width="600" src="https://codeberg.org/Aviac/codeberg-cli/raw/branch/main/assets/userinfo.gif">
  <img alt="Shell running the issue view command" width="600" src="https://codeberg.org/Aviac/codeberg-cli/raw/branch/main/assets/issueview.gif">
</p>

## Installation

### Prerequisites

For API communication reasons, the package depends on `openssl` package. Please make sure to install this with your systems respective package manager before continuing.

### Cargo

The easiest way to install the `berg` command is using cargo. (If you haven't installed rust/cargo yet, take a look [here](https://doc.rust-lang.org/cargo/getting-started/installation.html))

#### Build from source

Clone the repo and install `berg` with

```sh
cargo install --path .
```

#### Via crates.io

Anywhere, just run

```sh
cargo install codeberg-cli
```

### Void Linux

Run the following:

```sh
sudo xbps-install codeberg-cli
```

### Nix/NixOS

Run the following:

```sh
nix-shell -p codeberg-cli
```

or

```sh
nix develop nixpkgs#codeberg-cli
```

### Checking the installation

After that, the `berg` command should be available for you. Check it with `berg -V`

```sh
berg 0.4.0
```

## Usage

Run `berg -h` for the help menu. Each subcommand also has it's own help menu

```sh
Codeberg CLI app

Usage: berg [OPTIONS] <COMMAND>

Commands:
  api           API subcommands
  auth          Authentication subcommands
  config        Config subcommands
  user          User subcommands
  issue         Issue subcommands
  pull          Pull request subcommands
  label         Label subcommands
  repo          Repository subcommands
  milestone     Milestone subcommands
  notification  Notification subcommands
  completion    Print completion script
  help          Print this message or the help of the given subcommand(s)

Options:
      --non-interactive  Whether or not to disable all interactive features.
                         In this case arguments have to be provided in the console!
                         
  -h, --help             Print help
  -V, --version          Print version
```

### Non-Codeberg Forgejo

If you want to use this tool with instances of forgejo other than `codeberg.org` this is possible through extra configuration either through files or through environment variables:

- file approach: You can generate the default configuration via `berg config generate`. Please take a look at the command line options via the `--help` flag. Please also note that you can check the current configuration values and where they are sourced from via `berg config info`.
- environment variable approach: All of the options from the file approach are also available via environment variables. For now the best way to get the available options is to take a look at the output from `berg config info`. The environment variable names are the option names prefixed by `BERG_`. Example: `base_url` in config files is equivalent to `BERG_BASE_URL` in environment variables

Please note that the environment variables take precedence over the config file options. Also: There exist several visibility ranges for config files (local vs. global) and `berg` tries to resolve this recursively starting from the most local path walking upwards. Local configurations take precedence over global ones.

#### Example log into locally hosted instance of forgejo

```sh
BERG_BASE_URL=localhost:8000 berg auth login
```

## Development

Please take a look at [CONTRIBUTING.md](https://codeberg.org/Aviac/codeberg-cli/raw/branch/main/CONTRIBUTING.md) before opening PRs. We can't accept PRs which don't stick to the guidelines.

## Similar Projects

The development of `codeberg-cli` has gone to sleep several times due to me being busy. I just want to encourage you checking out similar other projects which are trying to achieve some similar goals:

- [`fjo`](https://codeberg.org/VoiDD/fjo) - A collective approach of re-writing `codeberg-cli`
- [`forgejo-cli`](https://codeberg.org/Cyborus/forgejo-cli) - A CLI application for interacting with forgejo in general
