%define opt_with() %{expand:%%global with_%{1} %%{?_with_%{1}:1}%%{?!_with_%{1}:0}}
%define initdir %(if test -d /etc/rc.d/init.d ; then echo /etc/rc.d/init.d ; else echo /etc/init.d ; fi)

%opt_with vcodacon

Summary: Coda distributed file system
Name: coda
Version: 6.9.5
Release: 1
Source: ftp://ftp.coda.cs.cmu.edu/pub/coda/src/%{name}-%{version}.tar.gz
License: GPL
BuildRoot: %{_builddir}/%{name}-%{version}/Root
BuildRequires: lwp-devel >= 2.3, rpc2-devel, rvm-devel
BuildRequires: ncurses-devel, libtermcap-devel
%if %{with_vcodacon}
BuildRequires: fltk-fluid, fltk-devel
%endif
Group: Networking/Daemons
%description
Source package for the Coda file system.  Three packages are provided by
this rpm: the client and server and the backup components. Separately
you must install a kernel module, or have a Coda enabled kernel, and
you should get the Coda documentation package.

%package client
Summary: Coda client
Group: Networking/Daemons
%description client
This package contains the main client program, the cachemanager Venus.
Also included are the binaries for the cfs, utilities for logging, ACL
manipulation etc, the hoarding tools for use with laptops and repair
tools for fixing conflicts. Finally there is the cmon and codacon
console utilities to monitor Coda's activities. You need a Coda
kernel-module for your kernel version, or Coda in your kernel, to have
a complete coda client.

%package server
Summary: Coda server
Group: Networking/Daemons
Requires: rvm-tools
%description server
This package contains the fileserver for the Coda file system, as well
as the volume utilities.

%package backup
Summary: Coda backup coordinator
Group: Networking/Daemons
%description backup
This package contains the backup software for the Coda file system, as
well as the volume utilities.

%if %{with_vcodacon}
%package vcodacon
Summary: Coda graphical console
Group: Networking/Daemons
Requires: coda-client
%description vcodacon
This package contains vcodacon, a graphical console for the Coda file
system client.
%endif

%changelog
* Sun Jan 19 2003 Rafael Jesus Alcantara Perez <rafa@dedalo.ws>
- Initial attempt for making the RPM packages from CVS with KERBEROS support.
* Sun Jun 21 1998 Peter Braam <braam@cs.cmu.edu>
- get rid of the kernel package. This needs interaction during the build.
- no more separate libc, glibc packages
* Tue Dec 30 1997 Peter Braam <braam@cs.cmu.edu>
- several changes: documentation separate
- use variables: (at)KVER(at)=`uname -r`, (at)CVER(at)=coda version
* Mon Jun 02 1997 Peter Braam <braam@cs.cmu.edu>
- small changes to Elliots improvements.
- some of his ideas are now in the scripts
* Wed May 28 1997 Elliot Lee <sopwith@redhat.com>
- Based upon 4.0.3-1 spec file.
- Changed to BuildRoot
- Do as much as possible at build time instead of in %post
- Added initscript for venus

%prep
%setup -n %{name}-%{version}

%build
options=""
%if %{with_vcodacon}
options="$options --with-vcodacon"
%endif

./configure --prefix=/usr '--mandir=${prefix}/share/man' $options
#  --with-krb4 \
#  --with-krb4-includes=/usr/kerberos/include/kerberosIV \
#  --with-krb4-libraries=/usr/kerberos/lib \
#  --with-krb5 \
#  --with-krb5-includes=/usr/kerberos/include \
#  --with-krb5-libraries=/usr/kerberos/lib
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT/usr install

mkdir -p $RPM_BUILD_ROOT/coda
mkdir -p $RPM_BUILD_ROOT/usr/coda/etc
mkdir -p $RPM_BUILD_ROOT/usr/coda/venus.cache
touch $RPM_BUILD_ROOT/coda/NOT_REALLY_CODA

%clean
rm -rf $RPM_BUILD_ROOT

%pre client
grep "^coda" /proc/mounts > /dev/null 2>&1
if [ $? = 0 ]; then
	echo "*** Coda is mounted: cannot install ***"
	exit 1
else
	exit 0
fi

%post client
if [ -e /usr/coda/venus.cache/pid ]; then
    rm -f /usr/coda/venus.cache/pid
fi
if [ ! -e /etc/coda/venus.conf ]; then
	/usr/sbin/venus-setup "" 100000
fi
#if [ ! -e /dev/cfs0 ]; then
#	/bin/mknod /dev/cfs0 c 67 0
#fi
/sbin/chkconfig --add venus.init

%preun client
grep "^coda" /proc/mounts > /dev/null 2>&1
if [ $? = 0 ]; then
	echo "*** Coda is mounted: cannot uninstall ***"
	exit 1
fi
/sbin/chkconfig --del venus.init
exit 0

%post server
/sbin/chkconfig --add update.init
/sbin/chkconfig --add auth2.init
/sbin/chkconfig --add codasrv.init

%preun server
/sbin/chkconfig --del update.init
/sbin/chkconfig --del auth2.init
/sbin/chkconfig --del codasrv.init

%files client
%defattr(-,root,root)
%dir /usr/coda
%dir /usr/coda/etc
%dir /usr/coda/venus.cache
%dir /coda
%verify() /coda/NOT_REALLY_CODA
/etc/coda/realms
/etc/coda/venus.conf.ex
%{initdir}/venus.init
/usr/sbin/asrlauncher
/usr/sbin/codaconfedit
/usr/sbin/venus
/usr/sbin/venus-setup
/usr/sbin/volmunge
/usr/sbin/vutil
/usr/bin/au
/usr/bin/cfs
/usr/bin/clog
/usr/bin/cmon
/usr/bin/codacon
/usr/bin/cpasswd
/usr/bin/ctokens
/usr/bin/cunlog
/usr/bin/filerepair
/usr/bin/gcodacon
/usr/bin/hoard
/usr/bin/mkcodabf
/usr/bin/mklka
/usr/bin/parser
/usr/bin/removeinc
/usr/bin/repair
/usr/bin/coda_replay
/usr/bin/spy
/usr/bin/xaskuser
/usr/bin/xfrepair
/usr/share/man/man1/au.1.gz
/usr/share/man/man1/cfs.1.gz
/usr/share/man/man1/clog.1.gz
/usr/share/man/man1/cmon.1.gz
/usr/share/man/man1/coda_replay.1.gz
/usr/share/man/man1/cpasswd.1.gz
/usr/share/man/man1/ctokens.1.gz
/usr/share/man/man1/cunlog.1.gz
/usr/share/man/man1/hoard.1.gz
/usr/share/man/man1/mkcodabf.1.gz
/usr/share/man/man1/repair.1.gz
/usr/share/man/man1/spy.1.gz
/usr/share/man/man8/venus.8.gz
/usr/share/man/man8/venus-setup.8.gz
/usr/share/man/man8/volmunge.8.gz
/usr/share/man/man8/vutil.8.gz

%files server
%defattr(-,root,root)
/etc/coda/server.conf.ex
/usr/sbin/auth2
/usr/sbin/bldvldb.sh
/usr/sbin/coda-server-logrotate
/usr/sbin/codaconfedit
/usr/sbin/codadump2tar
/usr/sbin/codasrv
/usr/sbin/codastart
/usr/sbin/createvol_rep
/usr/sbin/initpw
/usr/sbin/inoder
/usr/sbin/norton
/usr/sbin/norton-reinit
/usr/sbin/parserecdump
/usr/sbin/partial-reinit.sh
/usr/sbin/pdbtool
/usr/sbin/printvrdb
/usr/sbin/purgevol_rep
/usr/sbin/startserver
/usr/sbin/tokentool
/usr/sbin/updatesrv
/usr/sbin/updateclnt
/usr/sbin/updatefetch
/usr/sbin/vice-killvolumes
/usr/sbin/vice-setup
/usr/sbin/vice-setup-rvm
/usr/sbin/vice-setup-srvdir
/usr/sbin/vice-setup-user
/usr/sbin/vice-setup-scm
/usr/sbin/volutil
/usr/bin/getvolinfo
/usr/bin/reinit
/usr/bin/rpc2ping
/usr/bin/rvmsizer
/usr/bin/smon2
/usr/share/man/man5/maxgroupid.5.gz
/usr/share/man/man5/passwd.coda.5.gz
/usr/share/man/man5/servers.5.gz
/usr/share/man/man5/vicetab.5.gz
/usr/share/man/man5/volumelist.5.gz
/usr/share/man/man5/vrdb.5.gz
/usr/share/man/man8/auth2.8.gz
/usr/share/man/man8/bldvldb.sh.8.gz
/usr/share/man/man8/codasrv.8.gz
/usr/share/man/man8/createvol_rep.8.gz
/usr/share/man/man8/initpw.8.gz
/usr/share/man/man8/norton.8.gz
/usr/share/man/man8/pdbtool.8.gz
/usr/share/man/man8/purgevol_rep.8.gz
/usr/share/man/man8/startserver.8.gz
/usr/share/man/man8/updateclnt.8.gz
/usr/share/man/man8/updatesrv.8.gz
/usr/share/man/man8/vice-setup.8.gz
/usr/share/man/man8/volutil.8.gz
%{initdir}/codasrv.init
%{initdir}/auth2.init
%{initdir}/update.init

%files backup
%defattr(-,root,root)
/usr/sbin/auth2
/usr/sbin/backup
/usr/sbin/backup.sh
/usr/sbin/merge
/usr/sbin/readdump
/usr/sbin/tape.pl
/usr/sbin/updateclnt
/usr/sbin/updatefetch
/usr/sbin/volutil
/usr/share/man/man5/backuplogs.5.gz
/usr/share/man/man5/dumpfile.5.gz
/usr/share/man/man5/dumplist.5.gz
/usr/share/man/man8/backup.8.gz
/usr/share/man/man8/merge.8.gz
/usr/share/man/man8/readdump.8.gz

%if %{with_vcodacon}
%files vcodacon
%defattr(-,root,root)
/usr/bin/vcodacon
%endif
