/* These constants can be changed if necessary */

#define nmlngth    10        /* required # of characters in sequence name */
#define iters      50        /* how hard to try to estimate theta */
#define menu       true      /* are we using the menu? */
#define epsilon    0.0000001 /* a small number */
#define thetaout   false     /* create "thetafile" with running tally
                                  of theta estimates? */
#define onebestree true      /* "true" = only single bestree in file "bestree"
                                "false" = running tally of bestrees in file
                                "bestree" */
#define MINTHETA   0.001     /* low end of table */
#define MAXTHETA   10.0      /* high end of table */
#define EXPMIN    -40.0      /* minimum value of "x" in "exp(x)" */

/* The following program constants should not be changed */
#define point        "."
#define rootlength   10000       /* length of root branch must be much
                                    larger than the total height of the
                                    tree */
#define LINESIZE     128         /* this is actually (maximum linesize)+1
                                    because of trailing '\0' */
#define NUMBOOL        9         /* number of boolean tokens in parameter
                                    file */
#define NUMNUMBER      7         /* number of numeric (double) tokens in
                                    parameter file */
#define POSMAX       DBL_MAX     /* largest positive number */
#define NEGMAX  -(DBL_MAX - 1.0) /* smallest negative number */

