import math

# This may be generated by a program.
weights = {}

class classifier:
    """ linear classifier (binary) """

    def __init__(self, model=None):
        if model is not None:
            self.weights = model.weights
        else:
            self.weights = weights
        self.clear()

    def clear(self):
        self.score = self.weights.get('__BIAS__', 0.)

    def add(self, attr, value):
        self.score += self.weights.get(attr, 0.) * value

    def set(self, iterable):
        self.clear()
        for a, v in iterable:
            self.add(a, v)

    def label(self):
        return (0. < self.score)

    def score(self):
        return self.score

    def prob(self):
        if -100. < self.score:
            return (1. / (1. + math.exp(-self.score)))
        else:
            return 0.

