.TH CAMLLEX 1

.SH NAME
camllex \- a lexical analyzer generator for Caml Light

.SH SYNOPSIS
.B camllex
.IR lexer \&.mll

.SH DESCRIPTION

.B camllex
produces a lexical analyzer from a set of regular expressions with
attached semantic actions, in the style of
.BR lex (1).
Assuming the input file is
.IR lexer \&.mll,
camllex produces the file
.IR lexer \&.ml.
The output file must be compiled by Caml Light, and linked with the
rest of the program.

The generated module defines one lexing function per entry points in
the lexer definition. These functions have the same names as the entry
points. Lexing functions take as argument a lexer buffer, and return
the semantic attribute of the corresponding entry point. Lexer buffers
are an abstract data type implemented in the standard library
"lexing".

When used in conjunction with a parser generated by
.BR camlyacc (1),
the semantic actions compute a value belonging to the
type "token" defined by the generated parsing module.

.SH SEE ALSO
.BR camlyacc (1).
.br
.I
The Caml Light user's manual,
.P
chapter "Lexer and parser generators".
.br
.I
LEX - Lexical Analyzer Generator,
.P
by M. E. Lesk and E. Schmidt.
.br
.I
Compilers - Principles, Techniques, and Tools
.P
(chapter 3), by A. V. Aho, R. Sethi, and J. D. Ullman.

.SH BUGS

Type checking is performed when compiling the .ml output file, not
when compiling the lexer definition. This does not break type safety,
since the .ml output file is well-typed iff the lexer definition is
well-typed.  However, this results in type error messages that are
somehow hard to relate to the lexer definition.
