/*
   NAME rmove.c CREATED 13:15 4 Jan, 1995
   Created 04/01/95 by R.E.W.

   Will move a vector from a file into the move test board.....
 */


#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "chipmunk.h"
#include "move-syscall.h"
#include <unistd.h>
#include <errno.h>

/* Needed for the "times" <system> call. */
#include <sys/times.h>


#ifdef INCLUDE_MOVE_TEST

#define WSHIFTREG(v) (*((volatile int *)(BASE + 0xff20)) = v << 8)
#define LOAD_DATA()  (*((volatile int *)(BASE + 0xff30)) = 0)
#define SHIFT_REG()  (*((volatile int *)(BASE + 0x0030)) = 0)
#define STATREG      (*((volatile int *)(BASE + 0x10)))
#define RDATA        ((STATREG >>  24) & 0xff)
#define CLK_UP()     (*((volatile int *)(BASE + 0x10)) |=  0x00800000)
#define CLK_DWN()    (*((volatile int *)(BASE + 0x10)) &= ~0x00800000)
#define CTRLREG      (*((volatile int *)(BASE + 0x10))) 

#define WDBUS(v)     (*((volatile int *)(BASE + 0xff30)) = v)
#define DBUSIN()     (*((volatile int *)(BASE + 0x10)) |=  0x00030000)
#define DBUSOUT()    (*((volatile int *)(BASE + 0x10)) &= ~0x00030000)

int handle_syscall (int callno,int arg0, int arg1, int arg2,int arg3,
                               int arg4, int arg5, int arg6);


int getvect (int rvect[])
{
    int i;

    LOAD_DATA ();
    for (i=0;i<8;i++)
        {
            rvect[7-i] = RDATA ^ 0xff;
            SHIFT_REG ();
        }
    return ((STATREG & 0x80000000) != 0);
}


int setvect (int wvect[])
{
    int i;
    
    for (i=0;i<8;i++)
        WSHIFTREG (wvect[i]);
    return 0;
}

int rvector[32];

int rvect (int argc,char **argv)
{
   int i,t;

   t = getvect (rvector);
   for (i=0;i<8;i++)
       printf ("%02x",rvector[i] & 0x7f);
   printf ("     %d\n",t);
   
   return 0;
}


int mgetvect (int argc,char **argv)
{
   getvect (rvector);
   return 0;
}

#define BIT(v,n)      ((v[(n)>>3] & (1 << ((n)&7))) != 0)
#define SETBIT(v,n,b) (v[(n)>>3] = ((v[(n)>>3] & ~(1  << ((n)&7))) \
                                              |  ((b) << ((n)&7))))

#define IAS_BIT 54
#define DL0_BIT 30
#define WRN0_BIT 46

int D0_BIT[16]  = {56,57,48,49,40,41,32,33,24,25,16,17, 8, 9, 0, 1};
int IA_BIT[16]  = {58,59,50,51,42,43,34,35,26,27,18,19,10,11, 2, 3};
int DA0_BIT[16] = {60,61,52,53,44,45,36,37,28,29,20,21,12,13, 4, 5};

int I_BIT[48]   = { 
                   56,57,58,59,60,61,
                   48,49,50,51,52,53,
                   40,41,42,43,44,45,
                   32,33,34,35,36,37,
                   24,25,26,27,28,29,
                   16,17,18,19,20,21,
                    8, 9,10,11,12,13,
                    0, 1, 2, 3, 4, 5,
};


int bit (int argc,char **argv)
{
return ! (BIT (rvector, myatoi (argv[1])));
}



void printvect (int vect[])
{
   int i;

   for (i=0;i<8;i++)
       printf ("%02x",vect[i] & 0xff);
}


int testvect ( int argc,char **argv)
{
int *a;
int i;
int v;

a = (int *) (BASE + myatoi (argv[1]));
if (strlen (argv[2]) != 32) 
  {
  printf ("Illegal testvector length! is now %d\n",(int)strlen (argv[2]));
  return 1;
  }

for (i=0;i<8;i++)
  {
  sscanf (argv[2]+i*4,"%4x",&v);
  *a = v;
  }
return 0;
}


int setone (int argc,char **argv)
{
int *a,b;
int tot;

a = (int *)(BASE + myatoi (argv[1]));
b = myatoi (argv[2]);

for (tot=128,b=128-b;b > 16;b -= 16,tot -= 16)
   *a = 0;
*a = 0x10000 >> b;
tot -= 16;
for (;tot > 0;tot -= 16)
   *a = 0;
return 0;
}

int testmove (int argc,char **argv)
{
FILE *fp;
int vn,i,j,errs;
char buf[1024], wvects[256],rvects[256];
int wvect[32],rvect[32],mask[32],actvect[32];

fp = fopen (argv[1],"r");
if (!fp)
   {
   printf ("Couldnt' open file %s\n",argv[1]);
   return 1;
   }

vn = 0;
while (fgets (buf,1024,fp))
   {
   if (buf[0] == '#') continue;
   if (sscanf (buf,"%s %s\n",wvects,rvects) != 2) break;
   for (i=0;i<8;i++)
       {
       wvect[i] = 0;
       for (j=0;j<8;j++)
           wvect[i] = (wvect[i] << 1) + (wvects[i*8+j] & 1);
       }
   for (i=0;i<8;i++)
       {
       rvect[i] = mask [i] = 0;
       for (j=0;j<8;j++)
           {
           rvect[i] = (rvect[i] << 1) + (rvects[i*8+j] & 1);
           mask[i]  = (mask[i]  << 1) + (rvects[i*8+j] != 'x');
           }
       }
   printf ("sending vect ");
   printvect (wvect);
   setvect (wvect);
   LOAD_DATA ();
   for (i=0;i<8;i++)
       {
       actvect[7-i] = RDATA;
       SHIFT_REG ();
       }    
   errs = 0;
   for (i=0;i<8;i++)
       {
       if ((actvect[i] & mask[i]) != (rvect[i] & mask[i]))
           errs++;
       }
   if (errs)
       {

       printf ("Vector %4d   mask:  ",vn);
       for (i=0;i<8;i++)
           printf ("%02x",mask[i]);
       printf ("\n          expected:  ");
       for (i=0;i<8;i++)
           printf ("%02x",rvect[i]);
       printf ("\n               got:  ");
       for (i=0;i<8;i++)
           printf ("%02x",actvect[i] & mask[i]);
       printf ("\n              diff:  ");
       for (i=0;i<8;i++)
           printf ("%02x",( actvect[i] ^ rvect[i]) & mask[i]);
       printf ("     %d\n\n",(STATREG & 0x80000000) != 0);
       }
   CLK_DWN ();
   CLK_UP ();
   vn++;
   }
fclose (fp);
return 0;
}




#define HALT_INST (((long long) 1) << 48)

long long instr_mem[65536];
short data_mem[65536];

int runprog (int argc,char **argv)
{ 
    int rvect[32]; 
    int wvect[32]; 
    int clock = 0;
    int max,nwords,temp;
    int ia,i,da0,d0;
    int read_delay;
    int fastclk,nosyscalls,noheaders;
    FILE *fp;
    char fnam[100];

    fastclk = getintvar ("FASTCLK");
    nosyscalls = getintvar ("NOSYSCALLS");
    noheaders = getintvar ("NOHEADERS");
    sprintf (fnam,"%s.bin",argv[1]);
    fp = fopen (fnam,"r");
    if (!fp) fp = fopen (argv[1],"r");

    if (!fp) {perror ("Can't open binary file");return 1;}
    nwords = fread (instr_mem,sizeof (long long), 65536,fp);
    fclose (fp);
    if (!noheaders) printf ("Got %d words from the bin file....\n",nwords);

    sprintf (fnam,"%s.dat",argv[1]);
    fp = fopen (fnam,"r");
    if (!fp) {
        if (!noheaders) printf ("Warning: Can't open data mem file.\n");
    } else
        {
        nwords = fread (data_mem,sizeof (short), 65536,fp);
        fclose (fp);
        if (!noheaders) printf ("Got %d words from the dat file....\n",nwords);
        }

    if (argc > 2)
        max = myatoi (argv[2]);
    else 
        max = 1000000000;

    if (argc > 3)
        temp = myatoi (argv[3]);
    else
        temp = 0;

    read_delay = 0;
    while (clock < max) {
        if (fastclk)
          while (STATREG & 0x80000000);
        i= getvect (rvect);
        if (VERBOSE > 3) {
            printf ("%5d: IAS= %d, p=%d %d got vect ",
                    clock,BIT (rvect,IAS_BIT),i, BIT (rvect,temp)); 
            printvect (rvect); 
            for (i=0;i<64;i++)
                printf ("%d",BIT (rvect,i)); 
            printf ("\n"); 
        }
        if (BIT (rvect,IAS_BIT)) {
            ia = 0;
            for (i=0;i<16;i++)
                ia |= BIT(rvect,IA_BIT[i]) << i;
            if (VERBOSE > 2)
                printf ("%8d IA = %04x ",clock,ia);
            if (instr_mem[ia] == HALT_INST) {
                if (VERBOSE > 2)
                    printf (" - halt.\n");
                if (VERBOSE > 0) 
                  printf ("Halt at %04x after %d clocks.\n",
                          ia,clock);
                break;
            }
            for (i=0;i<8;i++) wvect[i] = 0;
            for (i=0;i<48;i++)
                SETBIT (wvect,I_BIT[i],
                         (instr_mem[ia] & ((long long) 1 << i)) != 0);
            if (VERBOSE > 3)
                printvect (wvect); 
            setvect (wvect); 
        }
        if (BIT (rvect,DL0_BIT)) {
            da0 = 0;
            for (i=0;i<16;i++)
                da0 |= BIT(rvect,DA0_BIT[i]) << i;
            if (VERBOSE > 2) {
                if (BIT (rvect,IAS_BIT)) 
                    printf (" DA = %04x.",da0);
                else
                    printf ("%8d            DA = %04x.",clock,da0);   
                printf (" %d ",BIT(rvect,WRN0_BIT));
            }
            if (BIT(rvect,WRN0_BIT)) {
                d0 = data_mem[da0];  
                for (i=0;i<8;i++) wvect[i] = 0;
                for (i=0;i<16;i++)
                    SETBIT (wvect,D0_BIT[i], ((d0 & (1 << i)) != 0));
                if (VERBOSE > 2)
                    printf ("=> %04x.\n",d0);
                DBUSOUT ();
                for (i=0;i<8;i++)
                    WDBUS ((wvect[i] ^ 3));
                read_delay = getintvar ("READ_DELAY");
                if (read_delay <= 0)
                    DBUSIN ();
            } else {
                d0 = 0;
                for (i=0;i<16;i++)
                    d0  |= BIT(rvect,D0_BIT[i]) << i;
                if (VERBOSE > 2)
                    printf ("<= %04x.\n",d0);            
                data_mem[da0] = d0;
                if (!nosyscalls) {
                  switch (da0) {
                  case 0:
                    handle_syscall (d0,
                                    data_mem[1],data_mem[2],
                                    data_mem[3],data_mem[4],
                                    data_mem[5],data_mem[6],
                                    data_mem[7]);
                    break;
                  case 0x8:
                    if (VERBOSE > 0) {
                      printf ("%d",d0);
                      fflush (stdout);
                    }
                    break;
                  default: break;
                  }  
                }
            }
        }
        else if (BIT (rvect,IAS_BIT) && (VERBOSE > 2)) printf ("\n");
        if (fastclk) {
#if 0
          CTRLREG |= 0; /* B'vo GCC */
#endif
        CTRLREG |=   0x100000;
        CLK_DWN ();
        CLK_UP ();
        CTRLREG &= ~ 0x100000;
        } else {
          CLK_DWN ();
          CLK_UP ();    
        }
        if (read_delay > 0)
            {
            read_delay--;
            if (read_delay <= 0)
                DBUSIN ();
            }
        clock++;
    }
    return 0;
}
    
    
#if 0
int toggleclock (int argc,char **argv)
{
int n;

n = myatoi (argv[1]);
for (;n>0;n--)
    {
    CLK_DWN ();
    CLK_UP ();    
    }
return 0;
}

#else


#if 0

int toggleclock (int argc,char **argv)
{
register int n,cu,cd;
volatile int *cr;

n = myatoi (argv[1]);
cu = CTRLREG |  0x00800000;
cd = CTRLREG & ~0x00800000;
cr = & CTRLREG;
/* This seems to generate a six clock loop. It can easily be 
   hand optimized to only five clocks. */
for (;n>0;n--)
    {
    *cr = cd;
    *cr = cu;
    }
return 0;
}

#else

/* This version has been timed to be at least twice as fast as the
   first version. It should still be tested on the move test board
   (which is faster than the video board it was now tested on....)  */

int toggleclock (int argc,char **argv)
{
register int n,cu,cd;
volatile int *cr;

n = myatoi (argv[1]);
cu = CTRLREG |  0x00800000;
cd = CTRLREG & ~0x00800000;
cr = & CTRLREG;
n -= 32;

for (;n>0;n-=32)
    {
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    *cr = cd;
    *cr = cu;
    }
for (n+=32;n>0;n--)
    {
    *cr = cd;
    *cr = cu;
    }
return 0;
}


#endif

#endif




int codeword (int argc,char **argv)
{
int cw,i;

cw = myatoi (argv[1]);

usleep (1000);
for (i=0;i<22;i++)
    {
/* Data sheet says that I don't need to wait, as there are at least two
   clocks between two successive writes..... */
    usleep (1000);

    if (cw & 1) CTRLREG |=  (1 << 22);
          else  CTRLREG &= ~(1 << 22);
    cw >>= 1;
    CTRLREG &= ~0x00200000;
    usleep (1000);  
    CTRLREG |=  0x00200000;
    }
/* Data sheet says 10 ms delay to valid freq. (page 3-7) */
usleep (10000);
return 0;
}



int handle_syscall (int callno,int arg0, int arg1, int arg2,int arg3,
                               int arg4, int arg5, int arg6)
{
  int rc;

  switch (callno) {
  case SYS_WRITE:
    rc = write (arg0,&data_mem[arg1>>2],arg2);
    break;
  case SYS_PRINTF:
    {
    char *fmt;
    int args[8];
    int t;

    fmt = (char *) &data_mem[arg0>>2];
    args[0] = arg1;
    args[1] = arg2;
    args[2] = arg3;
    args[3] = arg4;
    args[4] = arg5;
    args[5] = arg6;

    for (t=0;*fmt;fmt++)
      if (*fmt == '%') {
        if (*++fmt == 's')
          args[t] = (int)(&data_mem[args[t]>>2]);
        t++;
        if (t > 6) {
          fprintf (stderr,"Warning: Too many args.\n");
          break;
          }
        }
    fmt = (char *) &data_mem[arg0>>2];
    rc = printf (fmt, args[0], args[1], args[2], args[3], args[4], args[5]);
    }
    break;
  case SYS_TIMES:
    {
    struct tms buf;
    
    rc = times (&buf);
    data_mem[arg0+0] = buf.tms_utime;
    data_mem[arg0+1] = buf.tms_stime;
    data_mem[arg0+2] = buf.tms_cutime;
    data_mem[arg0+3] = buf.tms_cstime;
    }
    break;
  default:{
    int rvect[32]; 
    int i,ia;

    i= getvect (rvect);
    ia = 0;
    for (i=0;i<16;i++)
      ia |= BIT(rvect,IA_BIT[i]) << i; 
    printf ("Unimplemented syscall number %d at address %d.\n",callno,ia);
    rc = -ENOSYS;
    break;
    }
  }
  data_mem[0] = rc;
  return rc;
}


#endif

