/*
   NAME io_ops.c CREATED 12:46 26 May, 1994
*/

#include <stdio.h>
#include <stdlib.h>

#include "config.h"

#include "commands.h"

#ifdef USE_UNISTD
#include <unistd.h>
#endif

#include "chipmunk.h"


#ifdef IN_OUT_INSTRUCTIONS
                                                               /* outb */
int outb (int argc,char **argv){
  unsigned short port;
  unsigned char value;

  port = IOBASE + myatoi (argv[1]);
  value = myatoi (argv[2]);
  __asm__ __volatile__ ("outb %b0,%w1"
                        :       /* no outputs */
                        :"a" (value),"d" (port));
  return 0;
}

                                                               /* outw */
int outw (int argc,char **argv) {
  unsigned short port;
  unsigned short value;

  port = IOBASE + myatoi (argv[1]);
  value = myatoi (argv[2]);
  __asm__ __volatile__ ("outw %w0,%w1"
                        :       /* no outputs */
                        :"a" (value),"d" (port));
  return 0;
}

                                                                /* inb */
int inb (int argc,char **argv) {
  unsigned short port;
  unsigned char value;

  port = IOBASE + myatoi (argv[1]);
  __asm__ __volatile__ ("inb %w1,%b0"
                        :"=a" (value):"d" (port),"0" (0));
  return value;
}


                                                                /* inw */
int inw (int argc,char **argv) {
  unsigned short port;
  unsigned short value;

  port = IOBASE + myatoi (argv[1]);
  __asm__ __volatile__ ("inw %w1,%w0"
                        :"=a" (value):"d" (port),"0" (0));
  return value;
}

                                                          /* do_ioperm */
int do_ioperm (int argc,char **argv){
  unsigned short startport;
  unsigned short numports;

  startport = IOBASE + myatoi (argv[1]);
  numports  =          myatoi (argv[2]);
  return my_ioperm (startport,numports,1);
}

#endif

