#if 0

This file contains prototypes and help text for commands in WORST.

Files implementing some of these commands should use:
   #include "commands.h"

One file, implementing the main loop should include this file as
follows:
   #include "commands.h"  /* Declare prototypes */
   #define NEED_TABLE
   #include "commands.h"  /* Build the table */

#endif

#ifndef NEED_TABLE
# define D(a,b,c,d) int b (int argc,char **argv);
#else
# define D(a,b,c,d) {a,b,c,d},
#endif


#ifndef NEED_TABLE
typedef (*builtinfn) ();
struct builtin {
  char *name;
  builtinfn func;
  char *help;
  char *usage;
};

extern struct builtin builtins[];

#else

struct builtin builtins [] = {

#endif
  
D("?",      help,   "synonym for help","[cmd ...]")
D("copyenv",copyenv,"set a variable from the programs environment","name")
D("echo",   echo,   "echo the arguments","[str] [...]")
D("endmac", do_endmac,"end of macro definition within macro","")
D("vars",    env,    "print all the variables","[name ...]")
D("exit",   quit,   "quit the program",NULL) 
D("help",   help,   "print help about the commands","[cmd ...]")
D("defmac", macdef, "define a macro on the command line","macname")
D("delmac", macdel, "delete a macro","macname [macname ...]")
D("macro",  macro,  "define a macro within a macro","macname")
D("putc",   do_putc,"echo the args (numbers) as chars","[ch1] [...]")
D("quit",   quit,   "synonym for exit",NULL)
D("savemac",savmac, "save macro to file","macname")
D("set",    set,    "set a variable","name value")
D("shift",  shift,  "shift macro args","")
D("showmac",shomac, "show the defined macros","[macname ...]")
D("timer",  timer,  "allows operation with the timers.","[reset]")
D("testvar",tstenv, "returns true if args exist in env","varname [...]")
D("unset",  unset,  "remove a variable from environment","[name ...]")
D("ver",    ver,    "print version info about the program",NULL)

/* Memory operations */
D("and",    and,    "clear some bits in a 32 bit memory location","loc mask")
D("ands",   ands,   "clear some bits in a 16 bit memory location","loc mask")
D("andb",   andb,   "clear some bits in a 8 bit memory location","loc mask")
D("dump",   dump,   "dump a memory area","loc [len]")
D("fill",   fill,   "Fill memory with a constant.","loc len value [...]")
D("free",   dofree ,"perform a free on specified pointer","ptr")
D("load",   load,   "load a file into memory","fn loc")
D("malloc",domalloc,"perform a malloc to allow dry-running/memtesting","len")
D("memcpy",do_memcpy,"copy a memory area to another place.","src len dest")
D("or",     or,     "set some bits in a 32 bit memory location","loc mask")
D("ors",    ors,    "set some bits in a 16 bit memory location","loc mask")
D("orb",    orb,    "set some bits in a 8 bit memory location","loc mask")
#if OBSOLETED
D("peek",   peek,   "peek into a memory location","loc")
D("peekb",  peekb,  "peek into a 8 bit memory location","loc")
D("peekbst",peekbst,"peek into a 8 bit memory location, return result in STATUS","loc")
D("peeks",  peeks,  "peek into a 16 bit memory location","loc")
D("peekst", peekst, "peek memory, return value in status","loc")
#endif
D("pmt",    pmt,    "pseudo memory test: generates regular pattern","")
D("poke",   poke,   "poke a value into a memory location","loc value")
D("pokes",  pokes,  "poke a value into a 16 bit memory location","loc value")
D("pokeb",  pokeb,  "poke a value into a 8 bit memory location","loc value")
D("save",   save,   "save from memory into a file","fn loc len")
D("xor",    xor,    "toggle some bits in a 32 bit memory location","loc mask")
D("xors",   xors,   "toggle some bits in a 16 bit memory location","loc mask")
D("xorb",   xorb,   "toggle some bits in a 8 bit memory location","loc mask")
D("open",   do_open,"Open a file","filename")
D("close",  do_close,"close a filedescriptor","fd")


#ifdef USE_SHM_COMM
/* 960-comunications terminal emulation */
D("send",   send,   "send a string to the board",NULL)
D("term",   term,   "go into terminal emulation mode",NULL)
D("log",    log,    "log session to a file","fn")
#endif

/* misc commands */
D("system", syst,   "perform a system command","[...]")
D("usleep", uslp,   "sleep for a few microseconds","value")

/* Macro control */
D("ask",    ask,    "echo args and return keycode","[str] [...]")
D("else",   do_else,"use with if",NULL)
D("endif", do_endif,"use with if",NULL)
D("endwhile",do_endwhile,"loop control",NULL)
D("if",     do_if,  "evaluates expression and executes conditionaly","exp")
D("mabort", mabort, "abort all (nested) macros","[val]")
D("return",doreturn,"return macro with status value","[val]")
D("while",  do_while,"loop control","exp")


/* Section of "optional" commands */

#ifdef IN_OUT_INSTRUCTIONS
D("outb",   outb,   "Output a byte in IO addressing space","loc value")
D("outw",   outw,   "Output a word in IO addressing space","loc value")
D("inb",    inb,    "Input a byte from IO addressing space","loc")
D("inw",    inw,    "Input a word from IO addressing space","loc")
D("ioperm", do_ioperm,"Acquire permission to address IO space","loc len")
#endif

#ifdef USE_MMAP
D("memmap",domemmap,"perform the memmap to get access to pysicalmem","? len")
#endif

#ifdef USE_MEMTEST
D("memtest",memtest,"perform specified memory test.","loc len opt")
#endif

#ifdef USE_TESTS
D("addrtest",addrtest,"addressline test","ref amask [opt]")
D("calcrc16",cal_crc,"Compute CRC16 of specified location(s)","ref [opt]")
D("cntones",do_count_ones,"returns ones count","val")
D("crashtest",crashtest,"performs vital mccd-access","loc msg")
D("datatest",datatest,"detect dataline SAF & BF","ref [opt]")
D("dlbftest",dlbftest,"dataline bf test","ref [opt]")
D("dlsatest",dlsatest,"dataline stuck at test","ref [opt]")
D("ghosttest",ghost_test,"checks or if ghost exists","ref xmask [opt]")
D("read",   read_test,"Read average of specified location(s)","ref [opt]")
D("setfaults",setfaults,"set faults, -v (or -V very) verbose","[-v | -V]")
D("tver",   tver,   "print version info about testparts","")
D("visit",  visit,  "performs a read access on several localtions","opts")
D("write",  write_test,"Write specified location(s).","ref [opt]")
#endif

#ifdef INCLUDE_2051
D("calc_clock",calc_clock,"Calculate the ICD2051 codeword given a freq",
                                                                      "clock")
#endif

#ifdef INCLUDE_MOVE
D("ctrlreg_set",ctrlreg_set,"set the MOVE ctrlreg","value")
D("ctrlreg_get",ctrlreg_set,"return the MOVE ctrlreg","")
#endif

#ifdef INCLUDE_SBUS
D("loadcfg",loadcfg,"load the Xilinx config","file")
D("readcfg",readcfg,"readback the config with state info.","file")
#endif

#ifdef INCLUDE_RMOVE
D("testvect",testvect,"load a testvector into the move test board",
                                                         "addres  testvect")
D("setone",setone,"set one bit of the move test board to one",
                                                         "addres  bitno")
D("testmove",testmove,"Test a move processor with testvectors from a file",
                                                         "file")
D("rvect",rvect,"read a vector from the move testboard","")
D("getvect",mgetvect,"read a vector from the move testboard", "")
D("bit",bit,"read a specified bit from the testboard",  "bit number")
D("runprog",runprog,"run a program from binary file","file maxclocks")
D("toggleclock",toggleclock,"toggle the clock as fast as possible","howmany")
D("codeword",codeword,"put a codeword into the ICD2051","Codeword")
#endif

#ifdef INCLUDE_P555
D("load_p555",load_p555,"load a file into the P555 ucode memory",
						"base startaddr file")
D("save_p555",save_p555,"load a file into the P555 ucode memory",
						"base startaddr length file")
#endif

#ifdef USE_MCCD_INTERFACE
D("mccd_init",do_mccd_init,"Call mccd_init in interface","")
D("mccd_mem_init",do_mccd_mem_init,"call mccd_mem_init in interface","")
D("start_grabber",do_start_grabber,"start_grabbing....","")
D("stop_grabber",do_stop_grabber,"stop_grabbing....","")
D("start_960",do_start_960,"start the 960 doing a contour","")
D("get_contour",do_get_contour,"get a contour, and print it.","")
D("reset_g335",do_reset_G335,"reset the G335.","")
D("send",   do_send,   "send a string to the board",NULL)
D("stop_grabber", do_stop_grabber,"stop_grabber",NULL)
D("showcost", do_showcost,"showcost",NULL)
D("showscanm", do_showscanm,"showscanm",NULL)
D("showpath", do_showpath,"showpath",NULL)
D("copyframe", do_copyframe,"copyframe",NULL)
D("showmodelc", do_showmodelc,"showmodelc",NULL)
D("showcontour", do_showcontour,"showcontour",NULL)
D("showcontouri", do_showcontouri,"showcontouri",NULL)
D("showcontours", do_showcontours,"showcontours",NULL)
D("showrespc", do_showrespc,"showrespc",NULL)
D("st",     do_st,"st",NULL)
D("gvi1",   do_gvi1,"gvi1",NULL)
D("gvi3",   do_gvi3,"gvi3",NULL)
D("gvi5",   do_gvi5,"gvi5",NULL)
D("gvi7",   do_gvi7,"gvi7",NULL)
D("gvi9",   do_gvi9,"gvi9",NULL)
D("calcost",do_calcost,"calcost",NULL)
D("findpath",do_findpath,"findpath",NULL)
D("tracon", do_tracon,"tracon",NULL)
D("area_nc",do_area_nc,"area_nc",NULL)
D("interp", do_interp,"interp",NULL)
D("smocon", do_smocon,"smocon",NULL)
D("genmod", do_genmod,"genmod",NULL)
#endif

#ifdef NEED_TABLE
D(NULL,NULL,NULL,NULL)
};

#define NBUILTINS ((sizeof (builtins) / sizeof (struct builtin)) -1)
#endif

#undef D
