/*
   NAME comm960.c CREATED 12:56 26 Jan, 1994
   

   performs shared memory communication commands.
 */


#include <stdio.h>
#include <stdlib.h>

#include "config.h"

#include "commands.h"


#ifdef USE_UNISTD
#include <unistd.h>
#endif

#ifdef USE_SIGNAL_H
#include <signal.h>
#endif

#ifdef USE_WAIT
#include <sys/wait.h>
#endif


#include "chipmunk.h"


#ifdef USE_SHM_COMM
/* Non standard includes: */

FILE *logfile;


#ifdef USE_PC_H
#include <pc.h>
#include <keys.h>
#endif

#ifndef ESC
#define ESC 27
#endif



struct combuf {
char buf[16];
volatile short ibuf;
volatile short istat;
volatile short o_head;
volatile short o_tail;
};

   

static struct combuf *cb = NULL;


static void out_ch (int ch)
{
int i=500000;

while (cb->istat && --i)
       ;
if (!i)
   {
   printf ("Timed out trying to send char.\n");
   return;
   }
cb->ibuf = (short) ch;
cb->istat = 1;
}


static int char_avail ()
{
return cb->o_head != cb->o_tail;
}


static int in_ch ()
{
int t,r,h,i=100;


t = cb->o_tail;
do {
   h = cb->o_head;
   } while ((h == t) && --i);

if (!i) 
    {
    printf ("Mhhhh... Timed out on waiting for character... h=%d,t=%d.\n",h,t);
    return 0;
    }
if (t & ~15) 
   {
   printf ("Hmm... Weird t value:%08x.\n",t);
   return (0);
   }
t &= 15;
if (h & ~15) 
   {
   printf ("Hmm... Weird h value:%08x.\n",h);
   return (0);
   }
h &= 15;

r = cb->buf[t];
cb->o_tail = (t+1) & 15;
return r;
}


static void init_cb (void)

{
int off;

off = getintvar ("COMBASE");
if (off == 0)
    cb = (void *) (BASE + 0x9ffe0);
else
    cb = (void *) (BASE + off);
}

int term (int argc,char **argv)
{
int ch,pid;
char chr;
#ifndef UNIX
int t;
#endif

if (cb == NULL) init_cb ();
if (VERBOSE > 0)
   {
   printf ("ATERM: program doing shared memory communication with the\n");   
   printf ("I960 MCCD board.... The combuf is at %08x.\n",(int) cb);
   }
#ifdef UNIX

   fflush (stdout); /* Do this, otherwise you get double output */
   if ((cb->o_tail & ~0xf) || (cb->o_head & ~0xf))
	{
	printf ("Hmmmm. There are weird values in the buffer space\n");
	return 0;
	}
   if ( (pid = fork ()))
	{
	/* Parent does USER -> MCCD communication */
	system ("stty -echo cbreak");
	read (0,&chr,1);
	while (chr != ESC)
	    {
	    out_ch (chr);
	    read (0,&chr,1);
	    }
	system ("stty -cbreak echo" );
	kill (pid,SIGQUIT);
	waitpid (pid,NULL,0);
	}
   else
	{
	/* Child does MCCD -> terminal communication */
	while (1)
	    {
	    while (char_avail ())
		{
		putchar (ch = in_ch ());
	        if (!ch) exit (-1);
		}
	    fflush (stdout);
	    usleep (30000); /* 30 ms -> check 30 times a second. */
	    }
	}
    printf ("\n");
#else

setbuf (stdin,NULL);

do {
    if (kbhit ())
	{
	ch = getxkey ();
	switch (ch)
	    {
	    case ESC:
		return (0);
	    default:	
		out_ch (ch);
	    }
	}
    t= 1000;
    while (char_avail () && t--)
    	{
	putchar (ch = in_ch ());
	if (logfile)
	    putc (ch,logfile);
	}
    fflush (stdout);
    } while (1);
#endif
return (0);
}


static void timeout_echo (int to)
{
int t;

for (t=to;t != 0;t--)
    if (char_avail ())
	{
	putchar (in_ch ());
	t = to;
	}
}



int send (int argc,char **argv)
{
int i;
char *p;

if (cb == NULL) init_cb ();
timeout_echo (10);
for (i=1;i<argc;i++)
    {
    for (p=argv[i];*p != '\0';p++)
	out_ch (*p);
    out_ch (' ');
    timeout_echo (10);
    }
out_ch ('\r');
timeout_echo (10000);
return 0;
}



int log (int argc,char **argv)
{
MINARGC(2);
if (logfile)
    fclose (logfile);
logfile = NULL;
if (strcmp (argv[1],"off") == 0) return 0;
logfile = fopen (argv[1],"w");
if (!logfile)
    perror ("Error opening logfile");
return 0;
}



#endif

