/*
 * This file is part of ce.
 *
 * Copyright (c) 1990 by Chester Ramey.
 *
 * Permission is hereby granted to copy, reproduce, redistribute or
 * otherwise use this software subject to the following: 
 * 	1) That there be no monetary profit gained specifically from 
 *	   the use or reproduction of this software.
 * 	2) This software may not be sold, rented, traded or otherwise 
 *	   marketed.
 * 	3) This copyright notice must be included prominently in any copy
 * 	   made of this software.
 *
 * The author makes no claims as to the fitness or correctness of
 * this software for any use whatsoever, and it is provided as is. 
 * Any use of this software is at the user's own risk.
 */
/*
 * key.c  -- Initial default key to function bindings for ce
 *
 */

#include "ce.h"

#ifndef NULL
#define NULL 0
#endif

#include "externs.h"

/*
 * Command table.
 * This table  is *roughly* in ASCII order, left to right across the
 * characters of the command. This expains the funny location of the
 * control-X commands.
 */
KEYTAB  keytab[NBINDS] = {
        {CTRL|'@',              setmark},
	{CTRL|'A',		gotobol},
	{CTRL|'B',		backchar},
	{CTRL|'C',		showversion},
	{CTRL|'D',		forwdel},
	{CTRL|'E',		gotoeol},
	{CTRL|'F',		forwchar},
	{CTRL|'G',		ctrlg},
	{CTRL|'H',		backdel},
	{CTRL|'I',		tab},
	{CTRL|'J',		indent},
	{CTRL|'K',		killtext},
	{CTRL|'L',		refresh},
	{CTRL|'M',		newline},
	{CTRL|'N',		forwline},
	{CTRL|'O',		openline},
	{CTRL|'P',		backline},
	{CTRL|'Q',		quote},
	{CTRL|'R',		backisearch},
	{CTRL|'S',		forwisearch},
	{CTRL|'T',		twiddle},
	{CTRL|'U',              getarg},
	{CTRL|'V',		forwpage},
	{CTRL|'W',		killregion},
	{CTRL|'Y',		yank},
	{CTRL|'Z',		spawncli},
	{CTLX|CTRL|'B',		listbuffers},
	{CTLX|CTRL|'C',		saveandexit},    /* Hard quit.           */
	{CTLX|CTRL|'F',		filefind},
	{CTLX|CTRL|'G',		ctrlg},
	{CTLX|CTRL|'I',		insbuffer},
	{CTLX|CTRL|'L',		lowerregion},
	{CTLX|CTRL|'M',		delemode},
	{CTLX|CTRL|'N',		mvdnwind},
	{CTLX|CTRL|'O',		deblank},
	{CTLX|CTRL|'P',		mvupwind},
	{CTLX|CTRL|'Q',		readonly},
	{CTLX|CTRL|'R',		fileview},
	{CTLX|CTRL|'S',		filesave},
	{CTLX|CTRL|'T',         twiddlelines},  
	{CTLX|CTRL|'U',		upperregion},
	{CTLX|CTRL|'V',		fileread},
	{CTLX|CTRL|'W',		filewrite},
	{CTLX|CTRL|'X',		swapmark},
	{CTLX|CTRL|'Z',		shrinkwind},    /* non-GNU */
	{CTLX|'!',		spawn},         /* Run 1 command.       */
	{CTLX|'%',		searchrepl},    /* non-GNU */
	{CTLX|'(',		ctlxlp},
	{CTLX|')',		ctlxrp},
	{CTLX|'.',		setprefix},
	{CTLX|'=',		showcpos},
	{CTLX|'?',		deskey},
	{CTLX|'^',		enlargewind},
	{CTLX|'1',		onlywind},
	{CTLX|'2',		splitwind},
/*      {CTLX|'A',              appendtobuffer},  */
	{CTLX|'B',		usebuffer},
	{CTLX|'C',		spawncli},      /* non-GNU */
	{CTLX|'E',		ctlxe},
	{CTLX|'F',		setfillcol},
	{CTLX|'H',		markbuffer},
	{CTLX|'I',              fileinsert},
	{CTLX|'K',		killbuffer},
	{CTLX|'M',		setemode},
	{CTLX|'N',		filename},
	{CTLX|'O',		nextwind},
	{CTLX|'P',		prevwind},
	{CTLX|'S',		savechanged},
	{CTLX|'X',		nextbuffer},
	{CTLX|'Z',		enlargewind},
	{CTLX|0x7F,		delbsentence},
	{META|CTRL|'G',		ctrlg},
	{META|CTRL|'H',		delbword},
	{META|CTRL|'K',		unbindkey},
	{META|CTRL|'L',		reposition},
	{META|CTRL|'M',		delgmode},
	{META|CTRL|'N',		namebuffer},
	{META|CTRL|'O',		openvert},
	{META|CTRL|'R',		queryrepl},
	{META|CTRL|'S',		regexfsearch},
	{META|CTRL|'V',		scrnextdw},
	{META|CTRL|'W',		killpara},
	{META|CTRL|'Z',		scrnextup},
	{META|'@',		markword},
	{META|' ',		setmark},
	{META|'%',              queryrepl},
	{META|'?',		help},
	{META|'!',		spawn},      /* GNU has it this way */
	{META|'.',		setmark},
	{META|'>',		gotoeob},
	{META|'=',              countregion},
	{META|'<',		gotobob},
	{META|'|',              regionshellcmd},
	{META|'[',		xtermarrowkeys},
	{META|')',		charmatch},
	{META|'A',              backsentence},
	{META|'B',		backword},
	{META|'C',		capword},
	{META|'D',		delfword},
	{META|'E',              forwsentence},
	{META|'F',		forwword},
	{META|'G',		fillregion},   
	{META|'H',		markpara},
	{META|'I',              tab},            /* GNU seems to do this */
	{META|'K',		killsentence},
	{META|'L',		lowerword},
	{META|'M',		setgmode},
	{META|'N',		gotoeop},
	{META|'O',		xtermarrowkeys}, /* this is a hack [CR] */
	{META|'P',		gotobop},
	{META|'Q',		fillpara},
	{META|'R',		reposition},     /* GNU has it this way */
	{META|'S',		centerline},     /* like Twenex EMACS */
	{META|'U',		upperword},
	{META|'V',		backpage},
	{META|'W',		copyregion},
	{META|'X',		namedcmd},
	{META|'Z',		quickexit},
	{META|'\\',		delspace},
	{META|'~',              notmodified},
	{META|0x7F,             delbword},
	{0x7F,			backdel},
	{0,			(Function *) 0}
};
