#include <errno.h>
#include <string.h>
#include "strerr.h"

struct strerr strerr_sys;

void strerr_sysinit(void)
{
  const char *e;
  if (errno == ENOMEM)
    e = "Cannot allocate memory";
  else if (errno == ELOOP)
    e = "Too many levels of symbolic links";
  else
    e = strerror(errno);
  strerr_sys.who = 0;
  strerr_sys.x = e;
  strerr_sys.y = "";
  strerr_sys.z = "";
}
