Automatic tests:

    make rts
    ./rts > rts.out
    diff rts.exp rts.out

Normally this prints nothing.
The `./rts` script takes 12 seconds to run
on a 2.245GHz Zen 2 CPU core.
Most of the time is building five 4GB databases.
(Those databases are written to `/dev/null`;
a few megabytes of disk space suffice for the tests.)

If cdb is compiled with `filcc` as of mid-October 2025,
the script takes 50 seconds to run
and produces a change from `rts.exp`, namely changing

    cdbmake: fatal: unable to create test.tmp: Cannot allocate memory
    111

to the following:

    [...] filc panic: src/libpas/pas_compact_heap_reservation.c:65: pas_aligned_allocation_result pas_compact_heap_reservation_try_allocate(size_t, size_t): assertion page_result.result failed.
    Trace/breakpoint trap
    133

There is also a similar change for `cdb64make`.
These differences do not reflect a problem with the compiled code.

## Manual tests

Create a database from `/etc/services`:

    ./cdbmake-sv test.cdb test.tmp < /etc/services

Use `cdbtest` to test the database:

    ./cdbtest < test.cdb

The `bad length` and `not found` tallies should be 0.
The `different record` tally should be 0
_unless_ you have the same service listed on multiple lines in /etc/services.

Try retrieving particular records from the database:

    ./cdbget smtp/tcp < test.cdb && echo ''
    ./cdbget @25/tcp < test.cdb && echo ''

Try printing some database statistics:

    ./cdbstats < test.cdb

The numbers should decrease rapidly past `d0`.
