/*   -*- c -*-
 * 
 *  ----------------------------------------------------------------------
 *  Misc includes.
 *  ----------------------------------------------------------------------
 *
 *  Copyright (c) 2002-2003 by PuhPuh
 *  
 *  This code is copyrighted property of the author.  It can still
 *  be used for any non-commercial purpose following conditions:
 *  
 *      1) This copyright notice is not removed.
 *      2) Source code follows any distribution of the software
 *         if possible.
 *      3) Copyright notice above is found in the documentation
 *         of the distributed software.
 *  
 *  Any express or implied warranties are disclaimed.  Author is
 *  not liable for any direct or indirect damages caused by the use
 *  of this software.
 *
 *  ----------------------------------------------------------------------
 *
 */


#ifndef CCINCLUDES_H_INCLUDED
#define CCINCLUDES_H_INCLUDED 1

#ifndef __CYGWIN__ /* All bigfile stuff is disabled in Cygwin since it
		      breaks up even the "small file support". */

/* Following should make most modern systems define off_t to be 
   64 bits and to make file calls to use 64 bit interfaces. */
#define _FILE_OFFSET_BITS 64
#define _LARGEFILE_SOURCE
#ifdef __CYGWIN__
#define __CYGWIN_USE_BIG_TYPES__
#endif /* __CYGWIN__ */

#endif /* ! __CYGWIN__ */

/* Following includes are often needed. */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/select.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <dirent.h>   
#include <fcntl.h>
#include <stdlib.h>
#include <pwd.h>
#include <errno.h>
#include <netdb.h>

extern int errno;

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif /* ! PATH_MAX */

#if defined (WIN32) || defined (_XBOX)
#define ftello ftell
#define fseeko fseek
#endif /* __CYGWIN__ || WIN32 || _XBOX */

#if defined (__linux__) || defined (__NetBSD__) || defined (__FreeBSD__) || defined (__CYGWIN__) || defined (sun) 
#define CC_UINT_64_TYPE_NAME      unsigned long long int
#define CC_UINT_64_PRINTF_FORMAT  "%llu"
#elif defined (__alpha) 
#define CC_UINT_64_TYPE_NAME      unsigned long int
#define CC_UINT_64_PRINTF_FORMAT  "%lu"
#else
#define CC_UINT_64_TYPE_NAME      unsigned long int
#define CC_UINT_64_PRINTF_FORMAT  "%lu"
#endif

#include "ccutil.h"
#include "ccdebug.h"

#endif /* CCINCLUDES_H_INCLUDED */
/* eof (ccincludes.h) */
