/*   -*- c -*-
 * 
 *  ----------------------------------------------------------------------
 *  Debugging stuff.
 *  ----------------------------------------------------------------------
 *
 *  Copyright (c) 2002-2003 by PuhPuh
 *  
 *  This code is copyrighted property of the author.  It can still
 *  be used for any non-commercial purpose following conditions:
 *  
 *      1) This copyright notice is not removed.
 *      2) Source code follows any distribution of the software
 *         if possible.
 *      3) Copyright notice above is found in the documentation
 *         of the distributed software.
 *  
 *  Any express or implied warranties are disclaimed.  Author is
 *  not liable for any direct or indirect damages caused by the use
 *  of this software.
 *
 *  ----------------------------------------------------------------------
 *
 */


#ifndef CCDEBUG_H_INCLUDED
#define CCDEBUG_H_INCLUDED 1

void cc_debug_set_level(int level);
int cc_debug_level(void);
void cc_debug_set_source_offset(const char *file, int line);
void cc_debug_printf(const char *format, ...);

#define CC_DEBUG(level, msg) ((cc_debug_level() >= level) ? (cc_debug_set_source_offset(__FILE__, __LINE__), cc_debug_printf msg, 1) : 0)

#endif /* CCDEBUG_H_INCLUDED */
/* eof (ccdebug.h) */
