
#ifndef _ov7620reg_h_
#define _ov7620reg_h_

#define OV7620_AGC			0x00	/* gain control */
#define OV7620_BLU			0x01	/* Blue gain control */
#define OV7620_RED			0x02	/* Red gain control */
#define OV7620_SAT			0x03	/* Saturation control */
#define OV7620_BRT			0x06	/* Brightness control */
#define OV7620_SHP			0x07	/* Analog Sharpness control */
#define OV7620_ABLU			0x0C	/* White Balance background control -- Blue channel */
#define OV7620_ARED			0x0D	/* White Balance background control -- Red channel */
#define OV7620_AEC			0x10	/* Auto-Exposure-Control Register */
#define OV7620_CLK			0x11	/* Clock rate control */
#define OV7620_COMA			0x12	/* Common control A */
	#define	COMA_RST		0x80	/* chip reset */
	#define	COMA_MIR		0x40	/* mirror image */
	#define	COMA_AGC		0x20	/* AGC */
	#define	COMA_8BIT		0x10	/* 8 bit digital output */
	#define	COMA_RAW		0x08	/* raw data signal (1), YUV (0) */
	#define	COMA_AWB		0x04	/* auto white balance */
	#define	COMA_TST		0x02	/* color bar test */
	#define	COMA_BLC		0x01	/* black level compensation */
#define OV7620_COMB			0x13	/* Common control B */
	#define COMB_AADJ		0x01	/* auto adjust mode */
#define OV7620_COMC			0x14	/* Common control C */
	#define COMC_AWB		0x80	/* AWB activation threshold selection: 1- high; 0-low. */
	#define COMC_SIZ		0x20	/* QVGA output format. 1 - 320x240; 0 - 640x480. */
	#define COMC_HREF		0x08	/* HREF effective, 0-pos., 1-neg. */
	#define COMC_GAM		0x04	/* gamma value (reg.62) used */
#define OV7620_COMD			0x15	/* Common control D */
#define OV7620_HS			0x17	/* horizontal window start */
#define OV7620_HE			0x18	/* horizontal window end */
#define OV7620_VS			0x19	/* vertical window start */
#define OV7620_VE			0x1A	/* vertical window end */
#define OV7620_MANH			0x1C	/* Manufacture ID high byte */
#define OV7620_MANL			0x1D	/* Manufacture ID low  byte */
#define OV7620_AEW			0x24	/* Auto Exposure White Pixel Ratio */
#define OV7620_AEB			0x25	/* Auto Exposure Black Pixel Ratio */
#define OV7620_COMH			0x28	/* Common control H */
	#define COMH_LRGB		0x80	/* One-Line RGB raw data output */
	#define COMH_BW			0x40	/* B/W */
	#define COMH_PSC		0x20	/* progressive scan/interlaced mode */
	#define COMH_AFZ		0x10	/* freeze AGC/AEC */
	#define COMH_AGC		0x08	/* AGC disable */
	#define COMH_RFMT		0x04	/* raw data output format */
	#define COMH_BST		0x02	/* 2x gain boost */
#define OV7620_COMI			0x29	/* Common control I */
#define OV7620_FRARH		0x2A	/* Frame Rate Adjust High */
#define OV7620_COMJ			0x2D	/* Common Control J */
	#define COMJ_FIX		0x81
	#define COMJ_QVGA		0x40	/* QVGA 60 frame/s selection. */
	#define COMJ_BRGHT		0x10	/* Auto brightness enabled */
	#define COMJ_WB			0x08	/* White balance depends on AGC/AEC */
	#define COMJ_BFIL		0x04	/* Banding filter enable */
#define OV6620_CPP			0x33	/* Color Processing Parameter Control */
#define OV6620_BIAS			0x34	/* Bias Adjustment */
#define OV6620_COMK			0x38	/* Common Control K */
#define OV6620_COML			0x39	/* Common Control L */
#define OV6620_COMM			0x3c	/* Common Control M */
#define OV6620_YMXA			0x4d	/* YUV Matrix Control (Main) */
#define OV6620_ARL			0x4e	/* AEC/AGC Reference Level */
#define OV6620_YMXB			0x4f	/* YUV Matrix Control (Secondary) */
#define OV7620_SPCB			0x61	/* Signal Process Control B */
	#define SPCB_MOD		0x80	/* 1-YUV mode; 0-raw data mode. */
	#define SPCB_BTL		0x04	/* brightness limit (reg.06) to half */
	#define SPCB_BL1		0x02	/* Brightness target reference level */
	#define SPCB_BL0		0x01	/* Brightness target reference level */
#define OV7620_YGAM			0x64	/* Y Gamma Control */
	#define YGAM_ENABLE		0x01	/* 1-enable; 0-disable (linear) */
#define OV7620_YUV			0x67	/* Color Space Selection */
	#define YUV_UV1			0x80	/* UV coefficient selection */
	#define YUV_UV0			0x40	/* [00] YUV [01] Analog YUV */
									/* [10] CCIR 601 YCrCb [11] PAL YUV */
	#define YUV_UVD			0x20	/* U/V signal delay 2 pixel selection */
	#define YUV_UVC			0x10	/* U/V signal with 3 point chroma average */
	#define YUV_YD1			0x08	/* Y signal delay selection */
	#define YUV_YD0			0x04	/* (00)-0; (01)-1; (10)-2; (11)-3 pixels */
	#define YUV_ASC			0x02	/* Auto saturation control */
	#define YUV_ASR			0x01	/* Auto saturation control range */
#define OV7620_COMK			0x70	/* Common control K */
	#define COMK_HEC		0x80	/* HREF edge timing */
	#define COMK_OPC		0x40	/* Output port drive current additional 2x */
	#define COMK_ZVT		0x10	/* ZV port timing */
	#define COMK_ASM		0x08	/* Accelerated saturation mode */
	#define COMK_AWB		0x02	/* AWB update rate selection, 1 for fast */
	#define COMK_SLM		0x01	/* single line mode */

enum { TYPE_OV7620 = 0, TYPE_OV6620, TYPE_UNKNOWN };
struct
{
	uint8_t read;
	uint8_t write;
	uint8_t type;
	uint16_t maxw;
	uint16_t maxh;
	uint16_t minw;
	uint16_t minh;
	uint16_t largew;
	uint16_t largeh;
	uint8_t hmin;
	uint8_t hmax;
	uint8_t vmin;
	uint8_t vmax;
	char    *txt;
} sccb_types[] = 
{
	{ 0x43, 0x42, TYPE_OV7620,  640, 480, 64, 48, 320, 240, 0x2C, 0xD2, 0x05, 0xF6, "ov7620"  },
	{ 0xC1, 0xC0, TYPE_OV6620,  356, 292, 64, 48, 176, 144, 0x38, 0xEC, 0x03, 0x94, "ov6620"  },
	{ 0x00, 0x00, TYPE_UNKNOWN,   0,   0,  0,  0,   0,   0, 0x00, 0x00, 0x00, 0x00, "unknown" }
};

#endif /* _ov7620reg_h_ */
