
#ifndef _main_h_
#define _main_h_

#include <stdio.h>
#include <jpeglib.h>

#define VERSION "2.2"
#define RFC1123DATE "%a, %d %b %Y %H:%M:%S GMT"
#define FMT_YUV 1
#define FMT_RGB 2

#define COLOR_FORE	"000000"
#define COLOR_BACK	"FFFFFF"
#define COLOR_LINK	"000000"
#define COLOR_HOVER	"0F0F0F"

#define MAKEIP(x)	\
		((unsigned char *)&x)[0], \
		((unsigned char *)&x)[1], \
		((unsigned char *)&x)[2], \
		((unsigned char *)&x)[3]


struct webcam;
struct prefs_t;

struct webcam_data
{
	char *name;
	int jpg_ncomp;
	int jpg_format;
	void (*setprefs)(struct webcam *cam);
	void (*addpref)(struct prefs_t *prefs, char *key, char *value);
	void (*init)(struct webcam *cam);
	void (*finish)(struct webcam *cam);
	void (*capture_pic)(struct webcam *cam);
	void (*capture_getline)(struct webcam *cam, int line);
};

struct prefs_t
{
	int width, height;
	int keepold;
	int sleep;
	int quality;
	int server_enabled;
	int server_port;
	int server_dostream;
	int server_maxconn;
	int daemon;
	int verbose;
	int log_enabled;
	int use_external;
	char *cam;
	char *logfile;
	char *filename;
	char *fontfile;
	char *msg;
	char *title;
	char *rootdir;
	char *col_fore;
	char *col_back;
	char *col_link;
	char *col_hover;
};

struct webcam
{
	char tfilename[FILENAME_MAX];
	struct jpeg_error_mgr jerr;
	struct jpeg_compress_struct cinfo;
	char *buf;
	char *copybuf;
	int cols, rows;
	unsigned char* font;
	int fontwidth;
	int fontheight;
	char *msg;
	int max_msg;
	int jpg_ncomp;
	int jpg_format;
	unsigned long int btrans;
	FILE *log_fp;
	unsigned int round;
	struct prefs_t *prefs;

	/* cam_bktr */
	int video;
	int tuner;

	/* cam_ov511 */
	int unit;
	int format;
	int ctrl;
	int isoc;
	int bufsize;
	int ubufsize;
	char *ubuf;
};


void error(char *prefix, char *what);
void camsleep(struct webcam *cam, long sleep);
void camreset(struct webcam *cam);
void dlog(const char *module, const char *format, ... );
char *trim(char *s);


#endif /* _main_h_ */
