//
// structs.h
//

#pragma once

#include "globals.h"
#include "ogl_support.h"
#include "metaobjects.h"

#define	MAX_ANIMS			40
#define	MAX_KEYFRAMES		60
#define	MAX_JOINTS			30
#define	MAX_CHILDREN		(MAX_JOINTS-1)
#define	MAX_LIMBS	MAX_JOINTS

#define MAX_FLAGS_IN_OBJNODE			5		// # flags in ObjNode


#define	MAX_DECOMPOSED_POINTS	1200
#define	MAX_DECOMPOSED_NORMALS	1100
#define	MAX_POINT_REFS			10		// max times a point can be re-used in multiple places
#define	MAX_DECOMPOSED_TRIMESHES 10

#define	MAX_MORPH_TRIMESHES		10
#define	MAX_MORPH_POINTS		1000

#define	MAX_NODE_SPARKLES		20

#define	MAX_COLLISION_BOXES		8




			/*********************/
			/* SPLINE STRUCTURES */
			/*********************/

typedef	struct
{
	float	x,z;
}SplinePointType;

typedef struct
{
	float			placement;			// where on spline to start item (0=front, 1.0 = end)
	uint16_t		type;
	Byte			parm[4];
	uint16_t		flags;
}SplineItemType;

typedef struct
{
	int16_t			numNubs;			// # nubs in spline
	int32_t			junk1;				// ptr to nub list
	int32_t			numPoints;			// # points in spline
	int32_t			junk2;				// ptr to calculated spline points
	int16_t			numItems;			// # items on the spline
	int32_t			junk3;				// ptr to spline items

	Rect			bBox;				// bounding box of spline area
}File_SplineDefType;

typedef struct
{
	int				numNubs;			// # nubs in spline
	int				numPoints;			// # points in spline
	int				numItems;			// # items on the spline

//	SplinePointType	*nubList;			// list of nubs
	SplinePointType	*pointList;			// list of calculated spline points
	SplineItemType	*itemList;			// list of spline items

	Rect			bBox;				// bounding box of spline area
}SplineDefType;




		/* COLLISION BOX */

typedef struct
{
	float	left,right,front,back,top,bottom;
	float	oldLeft,oldRight,oldFront,oldBack,oldTop,oldBottom;
}CollisionBoxType;



//*************************** SKELETON *****************************************/

		/* BONE SPECIFICATIONS */
		//
		//
		// NOTE: Similar to joint definition but lacks animation, rot/scale info.
		//

typedef struct
{
	int32_t				parentBone;			 			// index to previous bone
	// void				*ignored1;
	// OGLMatrix4x4		ignored2;
	// void				*ignored3;
	// unsigned char	ignored4[32];
	OGLPoint3D			coord;							// absolute coord (not relative to parent!)
	uint16_t			numPointsAttachedToBone;		// # vertices/points that this bone has
	uint16_t			*pointList;						// indecies into gDecomposedPointList
	uint16_t			numNormalsAttachedToBone;		// # vertex normals this bone has
	uint16_t			*normalList;					// indecies into gDecomposedNormalsList
}BoneDefinitionType;


			/* DECOMPOSED POINT INFO */

typedef struct
{
	OGLPoint3D	realPoint;							// point coords as imported in 3DMF model
	OGLPoint3D	boneRelPoint;						// point relative to bone coords (offset from bone)

	Byte		numRefs;							// # of places this point is used in the geometry data
	Byte		whichTriMesh[MAX_POINT_REFS];		// index to trimeshes
	int16_t		whichPoint[MAX_POINT_REFS];			// index into pointlist of triMesh above
	int16_t		whichNormal[MAX_POINT_REFS];		// index into gDecomposedNormalsList
}DecomposedPointType;



		/* CURRENT JOINT STATE */

typedef struct
{
	int32_t		tick;					// time at which this state exists
	int32_t		accelerationMode;		// mode of in/out acceleration
	OGLPoint3D	coord;					// current 3D coords of joint (relative to link)
	OGLVector3D	rotation;				// current rotation values of joint (relative to link)
	OGLVector3D	scale;					// current scale values of joint mesh
}JointKeyframeType;


		/* JOINT DEFINITIONS */

typedef struct
{
	int8_t				numKeyFrames[MAX_ANIMS];				// # keyframes
	JointKeyframeType 	**keyFrames;							// 2D array of keyframe data keyFrames[anim#][keyframe#]
}JointKeyFrameHeader;

			/* ANIM EVENT TYPE */

typedef struct
{
	int16_t	time;
	Byte	type;
	Byte	value;
}AnimEventType;


			/* SKELETON INFO */


typedef struct
{
	Byte				NumBones;						// # joints in this skeleton object
	JointKeyFrameHeader	JointKeyframes[MAX_JOINTS];		// array of joint definitions

	Byte				numChildren[MAX_JOINTS];		// # children each joint has
	Byte				childIndecies[MAX_JOINTS][MAX_CHILDREN];	// index to each child

	Byte				NumAnims;						// # animations in this skeleton object
	Byte				*NumAnimEvents;					// ptr to array containing the # of animevents for each anim
	AnimEventType		**AnimEventsList;				// 2 dimensional array which holds a anim event list for each anim AnimEventsList[anim#][event#]

	BoneDefinitionType	*Bones;							// data which describes bone heirarachy

	int					numDecomposedTriMeshes;			// # trimeshes in skeleton
	int					numDecomposedPoints;			// # shared points in skeleton
	int					numDecomposedNormals;			// # shared normal vectors

	MOVertexArrayData	decomposedTriMeshes[MAX_DECOMPOSED_TRIMESHES];	// array of triMeshData
	DecomposedPointType	*decomposedPointList;			// array of shared points
	OGLVector3D			*decomposedNormalsList;			// array of shared normals
}SkeletonDefType;


		/* THE STRUCTURE ATTACHED TO AN OBJNODE */
		//
		// This contains all of the local skeleton data for a particular ObjNode
		//

typedef struct
{
	Boolean			JointsAreGlobal;				// true when joints are already in world-space coords
	Byte			AnimNum;						// animation #

	Boolean			IsMorphing;						// flag set when morphing from an anim to another
	float			MorphSpeed;						// speed of morphing (1.0 = normal)
	float			MorphPercent;					// percentage of morph from kf1 to kf2 (0.0 - 1.0)

	JointKeyframeType	JointCurrentPosition[MAX_JOINTS];	// for each joint, holds current interpolated keyframe values
	JointKeyframeType	MorphStart[MAX_JOINTS];		// morph start & end keyframes for each joint
	JointKeyframeType	MorphEnd[MAX_JOINTS];

	float			CurrentAnimTime;				// current time index for animation
	float			LoopBackTime;					// time to loop or zigzag back to (default = 0 unless set by a setmarker)
	float			MaxAnimTime;					// duration of current anim
	float			AnimSpeed;						// time factor for speed of executing current anim (1.0 = normal time)
	float			PauseTimer;						// # seconds to pause animation
	Byte			AnimEventIndex;					// current index into anim event list
	Byte			AnimDirection;					// if going forward in timeline or backward
	Byte			EndMode;						// what to do when reach end of animation
	Boolean			AnimHasStopped;					// flag gets set when anim has reached end of sequence (looping anims don't set this!)

	OGLMatrix4x4	jointTransformMatrix[MAX_JOINTS];	// holds matrix xform for each joint

	SkeletonDefType	*skeletonDefinition;						// point to skeleton's common/shared data

	MOMaterialObject	*overrideTexture[MAX_DECOMPOSED_TRIMESHES];		// an illegal ref to a texture object for each trimesh in skeleton

}SkeletonObjDataType;


			/* TERRAIN ITEM ENTRY TYPE */

typedef struct
{
	uint32_t						x;
	uint32_t						y;
	uint16_t						type;
	Byte							parm[4];
	uint16_t						flags;
}TerrainItemEntryType;




			/****************************/
			/*  OBJECT RECORD STRUCTURE */
			/****************************/

struct ObjNode
{
	struct ObjNode	*PrevNode;			// address of previous node in linked list
	struct ObjNode	*NextNode;			// address of next node in linked list
	struct ObjNode	*ChainNode;
	struct ObjNode	*ChainHead;			// a chain's head (link back to 1st obj in chain)

	struct ObjNode	*ShadowNode;		// ptr to node's shadow (if any)
	struct ObjNode	*MPlatform;			// current moving platform

	uint16_t		Slot;				// sort value
	Byte			Genre;				// obj genre
	int				Type;				// obj type
	int				Group;				// obj group
	int				Kind;				// kind
	int				Mode;				// mode
	int				What;				// what
	uint32_t		StatusBits;			// various status bits

			/* MOVE/DRAW CALLBACKS */

	void			(*MoveCall)(struct ObjNode *);			// pointer to object's move routine
	void			(*SplineMoveCall)(struct ObjNode *);	// pointer to object's spline move routine
	void			(*CustomDrawFunction)(struct ObjNode *);// pointer to object's custom draw function


			/* PHYSICS */

	OGLPoint3D		Coord;				// coord of object
	OGLPoint3D		OldCoord;			// coord @ previous frame
	OGLPoint3D		InitCoord;			// coord where was created
	OGLVector3D		Delta;				// delta velocity of object
	OGLVector3D		DeltaRot;
	OGLVector3D		Rot;				// rotation of object
	OGLVector3D		Scale;				// scale of object
	OGLVector2D		AccelVector;		// current acceleration vector
	float			Friction;			// amount of friction to apply to player if player lands on top of this (for platforms and the like).  0 = normal, 1 = slick

	float			Speed3D;			// length of Delta vector x,y,z (not scaled to fps)
	float			Speed2D;			// length of Delta vector x,z (not scaled to fps)
	float			Speed;

	OGLVector3D		TargetOff;
	OGLPoint3D		WeaponAutoTargetOff;	// offset from coord where weapon should auto target


			/* COLLISION INFO */

	uint32_t				CType;													// collision type bits
	uint32_t				CBits;													// collision attribute bits
	Byte				NumCollisionBoxes;
	CollisionBoxType	CollisionBoxes[MAX_COLLISION_BOXES];					// Array of collision rectangles
	float				LeftOff,RightOff,FrontOff,BackOff,TopOff,BottomOff;		// box offsets (only used by simple objects with 1 collision box)

	float				BoundingSphereRadius;
	struct ObjNode 		*CurrentTriggerObj;										// set when trigger occurs

	Boolean				(*TriggerCallback)(struct ObjNode *, struct ObjNode *, Byte sides);			// callback when trigger occurs
	void				(*DropCallback)(struct ObjNode *player, struct ObjNode *heldObject);
	void				(*GotKickedCallback)(struct ObjNode *player, struct ObjNode *kickedObj);	// callback when player's foot hits kickable obj
	Boolean				(*HurtCallback)(struct ObjNode *, float damage);							// used for enemies to call their hurt function

	OGLVector3D			HoldOffset;			// for Pickup objects, this is the offset that Skip needs to hold the object from
	OGLVector3D			HoldRot;			// rotation offsets for held objects

	float				ForceLookAtDist;	// dist for camera to be for the auto-look at to kick in


			/* SPECS */

	signed char		Flag[6];
	int				Special[6];
	float			SpecialF[6];
	struct ObjNode*	SpecialObjPtr[2];
	float			Timer;				// misc use timer

	float			Health;				// health 0..1
	float			Damage;				// damage


			/* 3D CALCULATION STUFF */

	OGLMatrix4x4		AlignmentMatrix;		// when objects need to be aligned with a matrix rather than x,y,z rotations

	OGLMatrix4x4		BaseTransformMatrix;	// matrix which contains all of the transforms for the object as a whole
	MOMatrixObject		*BaseTransformObject;	// extra LEGAL object ref to BaseTransformMatrix (other legal ref is kept in BaseGroup)
	MOGroupObject		*BaseGroup;				// group containing all geometry,etc. for this object (for drawing)

	OGLBoundingBox		BBox;					// bbox for the model

	SkeletonObjDataType	*Skeleton;				// pointer to skeleton record data


			/* TERRAIN ITEM / SPLINE INFO */

	TerrainItemEntryType *TerrainItemPtr;		// if item was from terrain, then this pts to entry in array
	SplineItemType 		*SplineItemPtr;			// if item was from spline, then this pts to entry in array
	uint8_t				SplineNum;				// which spline this spline item is on
	float				SplinePlacement;		// 0.0->.9999 for placement on spline
	short				SplineObjectIndex;		// index into gSplineObjectList of this ObjNode


				/* COLOR & TEXTURE INFO */

	OGLColorRGBA		ColorFilter;
	float				TextureTransformU, TextureTransformV;


			/* PARTICLE EFFECTS */

	short				EffectChannel;					// effect sound channel index (-1 = none)
	int					ParticleGroup;
	int					ParticleMagicNum;
	float				ParticleTimer;

	short				Sparkles[MAX_NODE_SPARKLES];	// indecies into sparkles list


			/* SPRITE INFO */

	MOSpriteObject		*SpriteMO;				// ref to sprite meta object for sprite genre.


			/* POOL INDEX */

	int					pooledIndex;
};
typedef struct ObjNode ObjNode;


		/* NEW OBJECT DEFINITION TYPE */

typedef struct
{
	Byte			genre,group,type,animNum;
	OGLPoint3D		coord;
	uint32_t		flags;
	short			slot;
	void			(*moveCall)(ObjNode *);
	void			(*drawCall)(ObjNode *);
	float			rot,scale;
}NewObjectDefinitionType;
