// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/resolve.proto

package registryv1alpha1

import (
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/module/v1alpha1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ResolvedReferenceType int32

const (
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_UNSPECIFIED ResolvedReferenceType = 0
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_COMMIT      ResolvedReferenceType = 1
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_BRANCH      ResolvedReferenceType = 2
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_TAG         ResolvedReferenceType = 3
	ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_DRAFT       ResolvedReferenceType = 5
)

// Enum value maps for ResolvedReferenceType.
var (
	ResolvedReferenceType_name = map[int32]string{
		0: "RESOLVED_REFERENCE_TYPE_UNSPECIFIED",
		1: "RESOLVED_REFERENCE_TYPE_COMMIT",
		2: "RESOLVED_REFERENCE_TYPE_BRANCH",
		3: "RESOLVED_REFERENCE_TYPE_TAG",
		5: "RESOLVED_REFERENCE_TYPE_DRAFT",
	}
	ResolvedReferenceType_value = map[string]int32{
		"RESOLVED_REFERENCE_TYPE_UNSPECIFIED": 0,
		"RESOLVED_REFERENCE_TYPE_COMMIT":      1,
		"RESOLVED_REFERENCE_TYPE_BRANCH":      2,
		"RESOLVED_REFERENCE_TYPE_TAG":         3,
		"RESOLVED_REFERENCE_TYPE_DRAFT":       5,
	}
)

func (x ResolvedReferenceType) Enum() *ResolvedReferenceType {
	p := new(ResolvedReferenceType)
	*p = x
	return p
}

func (x ResolvedReferenceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResolvedReferenceType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes[0].Descriptor()
}

func (ResolvedReferenceType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes[0]
}

func (x ResolvedReferenceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResolvedReferenceType.Descriptor instead.
func (ResolvedReferenceType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{0}
}

type GetModulePinsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ModuleReferences []*v1alpha1.ModuleReference `protobuf:"bytes,1,rep,name=module_references,json=moduleReferences,proto3" json:"module_references,omitempty"`
	// current_module_pins allows for partial dependency updates by letting clients
	// send a request with the pins for their current module and only the
	// identities of the dependencies they want to update in module_references.
	//
	// When resolving, if a client supplied module pin is:
	//   - in the transitive closure of pins resolved from the module_references,
	//     the client supplied module pin will be an extra candidate for tie
	//     breaking.
	//   - NOT in the in the transitive closure of pins resolved from the
	//     module_references, it will be returned as is.
	CurrentModulePins []*v1alpha1.ModulePin `protobuf:"bytes,2,rep,name=current_module_pins,json=currentModulePins,proto3" json:"current_module_pins,omitempty"`
}

func (x *GetModulePinsRequest) Reset() {
	*x = GetModulePinsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePinsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePinsRequest) ProtoMessage() {}

func (x *GetModulePinsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModulePinsRequest.ProtoReflect.Descriptor instead.
func (*GetModulePinsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{0}
}

func (x *GetModulePinsRequest) GetModuleReferences() []*v1alpha1.ModuleReference {
	if x != nil {
		return x.ModuleReferences
	}
	return nil
}

func (x *GetModulePinsRequest) GetCurrentModulePins() []*v1alpha1.ModulePin {
	if x != nil {
		return x.CurrentModulePins
	}
	return nil
}

type GetModulePinsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ModulePins []*v1alpha1.ModulePin `protobuf:"bytes,1,rep,name=module_pins,json=modulePins,proto3" json:"module_pins,omitempty"`
}

func (x *GetModulePinsResponse) Reset() {
	*x = GetModulePinsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePinsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePinsResponse) ProtoMessage() {}

func (x *GetModulePinsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModulePinsResponse.ProtoReflect.Descriptor instead.
func (*GetModulePinsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{1}
}

func (x *GetModulePinsResponse) GetModulePins() []*v1alpha1.ModulePin {
	if x != nil {
		return x.ModulePins
	}
	return nil
}

type GetLocalModulePinsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LocalModuleReferences []*LocalModuleReference `protobuf:"bytes,1,rep,name=local_module_references,json=localModuleReferences,proto3" json:"local_module_references,omitempty"`
}

func (x *GetLocalModulePinsRequest) Reset() {
	*x = GetLocalModulePinsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLocalModulePinsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLocalModulePinsRequest) ProtoMessage() {}

func (x *GetLocalModulePinsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLocalModulePinsRequest.ProtoReflect.Descriptor instead.
func (*GetLocalModulePinsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{2}
}

func (x *GetLocalModulePinsRequest) GetLocalModuleReferences() []*LocalModuleReference {
	if x != nil {
		return x.LocalModuleReferences
	}
	return nil
}

type LocalModuleResolveResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A copy of the reference that was resolved.
	Reference *LocalModuleReference `protobuf:"bytes,1,opt,name=reference,proto3" json:"reference,omitempty"`
	// The pin the reference resolved to.
	Pin *LocalModulePin `protobuf:"bytes,2,opt,name=pin,proto3" json:"pin,omitempty"`
	// The type the reference resolved as.
	ResolvedReferenceType ResolvedReferenceType `protobuf:"varint,3,opt,name=resolved_reference_type,json=resolvedReferenceType,proto3,enum=buf.alpha.registry.v1alpha1.ResolvedReferenceType" json:"resolved_reference_type,omitempty"`
}

func (x *LocalModuleResolveResult) Reset() {
	*x = LocalModuleResolveResult{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalModuleResolveResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalModuleResolveResult) ProtoMessage() {}

func (x *LocalModuleResolveResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalModuleResolveResult.ProtoReflect.Descriptor instead.
func (*LocalModuleResolveResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{3}
}

func (x *LocalModuleResolveResult) GetReference() *LocalModuleReference {
	if x != nil {
		return x.Reference
	}
	return nil
}

func (x *LocalModuleResolveResult) GetPin() *LocalModulePin {
	if x != nil {
		return x.Pin
	}
	return nil
}

func (x *LocalModuleResolveResult) GetResolvedReferenceType() ResolvedReferenceType {
	if x != nil {
		return x.ResolvedReferenceType
	}
	return ResolvedReferenceType_RESOLVED_REFERENCE_TYPE_UNSPECIFIED
}

type GetLocalModulePinsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LocalModuleResolveResults []*LocalModuleResolveResult `protobuf:"bytes,1,rep,name=local_module_resolve_results,json=localModuleResolveResults,proto3" json:"local_module_resolve_results,omitempty"`
	// dependencies are the dependencies of the LocalModulePins.
	//
	// This includes the transitive deps.
	Dependencies []*v1alpha1.ModulePin `protobuf:"bytes,2,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
}

func (x *GetLocalModulePinsResponse) Reset() {
	*x = GetLocalModulePinsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLocalModulePinsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLocalModulePinsResponse) ProtoMessage() {}

func (x *GetLocalModulePinsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLocalModulePinsResponse.ProtoReflect.Descriptor instead.
func (*GetLocalModulePinsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{4}
}

func (x *GetLocalModulePinsResponse) GetLocalModuleResolveResults() []*LocalModuleResolveResult {
	if x != nil {
		return x.LocalModuleResolveResults
	}
	return nil
}

func (x *GetLocalModulePinsResponse) GetDependencies() []*v1alpha1.ModulePin {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

type GetGoVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The module reference to resolve.
	ModuleReference *LocalModuleReference `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3" json:"module_reference,omitempty"`
}

func (x *GetGoVersionRequest) Reset() {
	*x = GetGoVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGoVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoVersionRequest) ProtoMessage() {}

func (x *GetGoVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGoVersionRequest.ProtoReflect.Descriptor instead.
func (*GetGoVersionRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{5}
}

func (x *GetGoVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *GetGoVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.ModuleReference
	}
	return nil
}

type GetGoVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the resolved version to be used with the go module proxy.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetGoVersionResponse) Reset() {
	*x = GetGoVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGoVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoVersionResponse) ProtoMessage() {}

func (x *GetGoVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGoVersionResponse.ProtoReflect.Descriptor instead.
func (*GetGoVersionResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{6}
}

func (x *GetGoVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GetMavenVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The module reference to resolve.
	ModuleReference *LocalModuleReference `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3" json:"module_reference,omitempty"`
}

func (x *GetMavenVersionRequest) Reset() {
	*x = GetMavenVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMavenVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMavenVersionRequest) ProtoMessage() {}

func (x *GetMavenVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMavenVersionRequest.ProtoReflect.Descriptor instead.
func (*GetMavenVersionRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{7}
}

func (x *GetMavenVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *GetMavenVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.ModuleReference
	}
	return nil
}

type GetMavenVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the resolved version to be used with the maven repository.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetMavenVersionResponse) Reset() {
	*x = GetMavenVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMavenVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMavenVersionResponse) ProtoMessage() {}

func (x *GetMavenVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMavenVersionResponse.ProtoReflect.Descriptor instead.
func (*GetMavenVersionResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{8}
}

func (x *GetMavenVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GetNPMVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The module reference to resolve.
	ModuleReference *LocalModuleReference `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3" json:"module_reference,omitempty"`
}

func (x *GetNPMVersionRequest) Reset() {
	*x = GetNPMVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNPMVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNPMVersionRequest) ProtoMessage() {}

func (x *GetNPMVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNPMVersionRequest.ProtoReflect.Descriptor instead.
func (*GetNPMVersionRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{9}
}

func (x *GetNPMVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *GetNPMVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.ModuleReference
	}
	return nil
}

type GetNPMVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the resolved version to be used with the npm registry.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetNPMVersionResponse) Reset() {
	*x = GetNPMVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNPMVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNPMVersionResponse) ProtoMessage() {}

func (x *GetNPMVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNPMVersionResponse.ProtoReflect.Descriptor instead.
func (*GetNPMVersionResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{10}
}

func (x *GetNPMVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GetSwiftVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The module reference to resolve.
	ModuleReference *LocalModuleReference `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3" json:"module_reference,omitempty"`
}

func (x *GetSwiftVersionRequest) Reset() {
	*x = GetSwiftVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSwiftVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSwiftVersionRequest) ProtoMessage() {}

func (x *GetSwiftVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSwiftVersionRequest.ProtoReflect.Descriptor instead.
func (*GetSwiftVersionRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{11}
}

func (x *GetSwiftVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *GetSwiftVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.ModuleReference
	}
	return nil
}

type GetSwiftVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the resolved version to be used with the swift registry.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetSwiftVersionResponse) Reset() {
	*x = GetSwiftVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSwiftVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSwiftVersionResponse) ProtoMessage() {}

func (x *GetSwiftVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSwiftVersionResponse.ProtoReflect.Descriptor instead.
func (*GetSwiftVersionResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{12}
}

func (x *GetSwiftVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GetPythonVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The module reference to resolve.
	ModuleReference *LocalModuleReference `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3" json:"module_reference,omitempty"`
}

func (x *GetPythonVersionRequest) Reset() {
	*x = GetPythonVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPythonVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPythonVersionRequest) ProtoMessage() {}

func (x *GetPythonVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPythonVersionRequest.ProtoReflect.Descriptor instead.
func (*GetPythonVersionRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{13}
}

func (x *GetPythonVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *GetPythonVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.ModuleReference
	}
	return nil
}

type GetPythonVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the resolved version to be used with the python repository.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetPythonVersionResponse) Reset() {
	*x = GetPythonVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPythonVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPythonVersionResponse) ProtoMessage() {}

func (x *GetPythonVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPythonVersionResponse.ProtoReflect.Descriptor instead.
func (*GetPythonVersionResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{14}
}

func (x *GetPythonVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GetCargoVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The module reference to resolve.
	ModuleReference *LocalModuleReference `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3" json:"module_reference,omitempty"`
}

func (x *GetCargoVersionRequest) Reset() {
	*x = GetCargoVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCargoVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCargoVersionRequest) ProtoMessage() {}

func (x *GetCargoVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCargoVersionRequest.ProtoReflect.Descriptor instead.
func (*GetCargoVersionRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{15}
}

func (x *GetCargoVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *GetCargoVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.ModuleReference
	}
	return nil
}

type GetCargoVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the resolved version to be used with the cargo registry.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetCargoVersionResponse) Reset() {
	*x = GetCargoVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCargoVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCargoVersionResponse) ProtoMessage() {}

func (x *GetCargoVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCargoVersionResponse.ProtoReflect.Descriptor instead.
func (*GetCargoVersionResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{16}
}

func (x *GetCargoVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GetNugetVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The module reference to resolve.
	ModuleReference *LocalModuleReference `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3" json:"module_reference,omitempty"`
}

func (x *GetNugetVersionRequest) Reset() {
	*x = GetNugetVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNugetVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNugetVersionRequest) ProtoMessage() {}

func (x *GetNugetVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNugetVersionRequest.ProtoReflect.Descriptor instead.
func (*GetNugetVersionRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{17}
}

func (x *GetNugetVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *GetNugetVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.ModuleReference
	}
	return nil
}

type GetNugetVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the resolved version to be used with the nuget registry.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetNugetVersionResponse) Reset() {
	*x = GetNugetVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNugetVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNugetVersionResponse) ProtoMessage() {}

func (x *GetNugetVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNugetVersionResponse.ProtoReflect.Descriptor instead.
func (*GetNugetVersionResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{18}
}

func (x *GetNugetVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GetCmakeVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin reference to resolve.
	PluginReference *GetRemotePackageVersionPlugin `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The module reference to resolve.
	ModuleReference *LocalModuleReference `protobuf:"bytes,2,opt,name=module_reference,json=moduleReference,proto3" json:"module_reference,omitempty"`
}

func (x *GetCmakeVersionRequest) Reset() {
	*x = GetCmakeVersionRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCmakeVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCmakeVersionRequest) ProtoMessage() {}

func (x *GetCmakeVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCmakeVersionRequest.ProtoReflect.Descriptor instead.
func (*GetCmakeVersionRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{19}
}

func (x *GetCmakeVersionRequest) GetPluginReference() *GetRemotePackageVersionPlugin {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *GetCmakeVersionRequest) GetModuleReference() *LocalModuleReference {
	if x != nil {
		return x.ModuleReference
	}
	return nil
}

type GetCmakeVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the resolved version to be used with the cmake registry.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetCmakeVersionResponse) Reset() {
	*x = GetCmakeVersionResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCmakeVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCmakeVersionResponse) ProtoMessage() {}

func (x *GetCmakeVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCmakeVersionResponse.ProtoReflect.Descriptor instead.
func (*GetCmakeVersionResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{20}
}

func (x *GetCmakeVersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// GetRemotePackageVersionPlugin is a plugin reference.
// If the version is empty, this is a reference to the latest version.
type GetRemotePackageVersionPlugin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the plugin.
	// example: bufbuild
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin.
	// example: connect-go
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the plugin.
	// If empty, this is a reference to the latest version.
	// example: v1.0.0
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// The revision of the plugin version.
	// example: 1
	Revision uint32 `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *GetRemotePackageVersionPlugin) Reset() {
	*x = GetRemotePackageVersionPlugin{}
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRemotePackageVersionPlugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRemotePackageVersionPlugin) ProtoMessage() {}

func (x *GetRemotePackageVersionPlugin) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRemotePackageVersionPlugin.ProtoReflect.Descriptor instead.
func (*GetRemotePackageVersionPlugin) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP(), []int{21}
}

func (x *GetRemotePackageVersionPlugin) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GetRemotePackageVersionPlugin) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

var File_buf_alpha_registry_v1alpha1_resolve_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc = []byte{
	0x0a, 0x29, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x28, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc5, 0x01, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x13,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x70,
	0x69, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x52,
	0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69,
	0x6e, 0x73, 0x22, 0x5e, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50,
	0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0b, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69,
	0x6e, 0x73, 0x22, 0x86, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x69, 0x0a, 0x17, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x15, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0xa9, 0x02, 0x0a, 0x18,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4f, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3d, 0x0a, 0x03, 0x70, 0x69, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x50, 0x69, 0x6e, 0x52, 0x03, 0x70, 0x69, 0x6e, 0x12, 0x6a, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x6f,
	0x6c, 0x76, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x72,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x52, 0x0b, 0x69, 0x73, 0x5f, 0x62,
	0x73, 0x72, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x22, 0xde, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x1c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x19, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x48,
	0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x22, 0xda, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74,
	0x47, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x30, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4d,
	0x61, 0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x33, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4d, 0x61,
	0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdb, 0x01, 0x0a,
	0x14, 0x47, 0x65, 0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x31, 0x0a, 0x15, 0x47, 0x65,
	0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x33, 0x0a,
	0x17, 0x47, 0x65, 0x74, 0x53, 0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xde, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65,
	0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0x34, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x43, 0x61, 0x72, 0x67, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x33, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x43, 0x61, 0x72, 0x67, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xdd,
	0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4e, 0x75, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52,
	0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x33,
	0x0a, 0x17, 0x47, 0x65, 0x74, 0x4e, 0x75, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65,
	0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0x33, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0xf1, 0x01, 0x0a, 0x15, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f,
	0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e,
	0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x01,
	0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x46,
	0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x52, 0x41, 0x4e,
	0x43, 0x48, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44,
	0x5f, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x54, 0x41, 0x47, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45,
	0x44, 0x5f, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x05, 0x22, 0x04, 0x08, 0x04, 0x10, 0x04, 0x2a, 0x1d,
	0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x32, 0x9f, 0x09,
	0x0a, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x7b, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e,
	0x73, 0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x78, 0x0a,
	0x0c, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x47,
	0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x47, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53,
	0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x77, 0x69,
	0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12,
	0x7b, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x50, 0x4d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x84, 0x01, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03,
	0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x61, 0x72, 0x67, 0x6f,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x61, 0x72, 0x67, 0x6f, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x61,
	0x72, 0x67, 0x6f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4e,
	0x75, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x75, 0x67,
	0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4e, 0x75, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x81, 0x01, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x32,
	0xa2, 0x01, 0x0a, 0x13, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8a, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x12, 0x36,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x03, 0x90, 0x02, 0x01, 0x42, 0x99, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75,
	0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x2e,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c,
	0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68,
	0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea,
	0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescData = file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_resolve_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes = []any{
	(ResolvedReferenceType)(0),            // 0: buf.alpha.registry.v1alpha1.ResolvedReferenceType
	(*GetModulePinsRequest)(nil),          // 1: buf.alpha.registry.v1alpha1.GetModulePinsRequest
	(*GetModulePinsResponse)(nil),         // 2: buf.alpha.registry.v1alpha1.GetModulePinsResponse
	(*GetLocalModulePinsRequest)(nil),     // 3: buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest
	(*LocalModuleResolveResult)(nil),      // 4: buf.alpha.registry.v1alpha1.LocalModuleResolveResult
	(*GetLocalModulePinsResponse)(nil),    // 5: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse
	(*GetGoVersionRequest)(nil),           // 6: buf.alpha.registry.v1alpha1.GetGoVersionRequest
	(*GetGoVersionResponse)(nil),          // 7: buf.alpha.registry.v1alpha1.GetGoVersionResponse
	(*GetMavenVersionRequest)(nil),        // 8: buf.alpha.registry.v1alpha1.GetMavenVersionRequest
	(*GetMavenVersionResponse)(nil),       // 9: buf.alpha.registry.v1alpha1.GetMavenVersionResponse
	(*GetNPMVersionRequest)(nil),          // 10: buf.alpha.registry.v1alpha1.GetNPMVersionRequest
	(*GetNPMVersionResponse)(nil),         // 11: buf.alpha.registry.v1alpha1.GetNPMVersionResponse
	(*GetSwiftVersionRequest)(nil),        // 12: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest
	(*GetSwiftVersionResponse)(nil),       // 13: buf.alpha.registry.v1alpha1.GetSwiftVersionResponse
	(*GetPythonVersionRequest)(nil),       // 14: buf.alpha.registry.v1alpha1.GetPythonVersionRequest
	(*GetPythonVersionResponse)(nil),      // 15: buf.alpha.registry.v1alpha1.GetPythonVersionResponse
	(*GetCargoVersionRequest)(nil),        // 16: buf.alpha.registry.v1alpha1.GetCargoVersionRequest
	(*GetCargoVersionResponse)(nil),       // 17: buf.alpha.registry.v1alpha1.GetCargoVersionResponse
	(*GetNugetVersionRequest)(nil),        // 18: buf.alpha.registry.v1alpha1.GetNugetVersionRequest
	(*GetNugetVersionResponse)(nil),       // 19: buf.alpha.registry.v1alpha1.GetNugetVersionResponse
	(*GetCmakeVersionRequest)(nil),        // 20: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest
	(*GetCmakeVersionResponse)(nil),       // 21: buf.alpha.registry.v1alpha1.GetCmakeVersionResponse
	(*GetRemotePackageVersionPlugin)(nil), // 22: buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	(*v1alpha1.ModuleReference)(nil),      // 23: buf.alpha.module.v1alpha1.ModuleReference
	(*v1alpha1.ModulePin)(nil),            // 24: buf.alpha.module.v1alpha1.ModulePin
	(*LocalModuleReference)(nil),          // 25: buf.alpha.registry.v1alpha1.LocalModuleReference
	(*LocalModulePin)(nil),                // 26: buf.alpha.registry.v1alpha1.LocalModulePin
}
var file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs = []int32{
	23, // 0: buf.alpha.registry.v1alpha1.GetModulePinsRequest.module_references:type_name -> buf.alpha.module.v1alpha1.ModuleReference
	24, // 1: buf.alpha.registry.v1alpha1.GetModulePinsRequest.current_module_pins:type_name -> buf.alpha.module.v1alpha1.ModulePin
	24, // 2: buf.alpha.registry.v1alpha1.GetModulePinsResponse.module_pins:type_name -> buf.alpha.module.v1alpha1.ModulePin
	25, // 3: buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest.local_module_references:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	25, // 4: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	26, // 5: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.pin:type_name -> buf.alpha.registry.v1alpha1.LocalModulePin
	0,  // 6: buf.alpha.registry.v1alpha1.LocalModuleResolveResult.resolved_reference_type:type_name -> buf.alpha.registry.v1alpha1.ResolvedReferenceType
	4,  // 7: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse.local_module_resolve_results:type_name -> buf.alpha.registry.v1alpha1.LocalModuleResolveResult
	24, // 8: buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse.dependencies:type_name -> buf.alpha.module.v1alpha1.ModulePin
	22, // 9: buf.alpha.registry.v1alpha1.GetGoVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 10: buf.alpha.registry.v1alpha1.GetGoVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 11: buf.alpha.registry.v1alpha1.GetMavenVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 12: buf.alpha.registry.v1alpha1.GetMavenVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 13: buf.alpha.registry.v1alpha1.GetNPMVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 14: buf.alpha.registry.v1alpha1.GetNPMVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 15: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 16: buf.alpha.registry.v1alpha1.GetSwiftVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 17: buf.alpha.registry.v1alpha1.GetPythonVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 18: buf.alpha.registry.v1alpha1.GetPythonVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 19: buf.alpha.registry.v1alpha1.GetCargoVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 20: buf.alpha.registry.v1alpha1.GetCargoVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 21: buf.alpha.registry.v1alpha1.GetNugetVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 22: buf.alpha.registry.v1alpha1.GetNugetVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	22, // 23: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.GetRemotePackageVersionPlugin
	25, // 24: buf.alpha.registry.v1alpha1.GetCmakeVersionRequest.module_reference:type_name -> buf.alpha.registry.v1alpha1.LocalModuleReference
	1,  // 25: buf.alpha.registry.v1alpha1.ResolveService.GetModulePins:input_type -> buf.alpha.registry.v1alpha1.GetModulePinsRequest
	6,  // 26: buf.alpha.registry.v1alpha1.ResolveService.GetGoVersion:input_type -> buf.alpha.registry.v1alpha1.GetGoVersionRequest
	12, // 27: buf.alpha.registry.v1alpha1.ResolveService.GetSwiftVersion:input_type -> buf.alpha.registry.v1alpha1.GetSwiftVersionRequest
	8,  // 28: buf.alpha.registry.v1alpha1.ResolveService.GetMavenVersion:input_type -> buf.alpha.registry.v1alpha1.GetMavenVersionRequest
	10, // 29: buf.alpha.registry.v1alpha1.ResolveService.GetNPMVersion:input_type -> buf.alpha.registry.v1alpha1.GetNPMVersionRequest
	14, // 30: buf.alpha.registry.v1alpha1.ResolveService.GetPythonVersion:input_type -> buf.alpha.registry.v1alpha1.GetPythonVersionRequest
	16, // 31: buf.alpha.registry.v1alpha1.ResolveService.GetCargoVersion:input_type -> buf.alpha.registry.v1alpha1.GetCargoVersionRequest
	18, // 32: buf.alpha.registry.v1alpha1.ResolveService.GetNugetVersion:input_type -> buf.alpha.registry.v1alpha1.GetNugetVersionRequest
	20, // 33: buf.alpha.registry.v1alpha1.ResolveService.GetCmakeVersion:input_type -> buf.alpha.registry.v1alpha1.GetCmakeVersionRequest
	3,  // 34: buf.alpha.registry.v1alpha1.LocalResolveService.GetLocalModulePins:input_type -> buf.alpha.registry.v1alpha1.GetLocalModulePinsRequest
	2,  // 35: buf.alpha.registry.v1alpha1.ResolveService.GetModulePins:output_type -> buf.alpha.registry.v1alpha1.GetModulePinsResponse
	7,  // 36: buf.alpha.registry.v1alpha1.ResolveService.GetGoVersion:output_type -> buf.alpha.registry.v1alpha1.GetGoVersionResponse
	13, // 37: buf.alpha.registry.v1alpha1.ResolveService.GetSwiftVersion:output_type -> buf.alpha.registry.v1alpha1.GetSwiftVersionResponse
	9,  // 38: buf.alpha.registry.v1alpha1.ResolveService.GetMavenVersion:output_type -> buf.alpha.registry.v1alpha1.GetMavenVersionResponse
	11, // 39: buf.alpha.registry.v1alpha1.ResolveService.GetNPMVersion:output_type -> buf.alpha.registry.v1alpha1.GetNPMVersionResponse
	15, // 40: buf.alpha.registry.v1alpha1.ResolveService.GetPythonVersion:output_type -> buf.alpha.registry.v1alpha1.GetPythonVersionResponse
	17, // 41: buf.alpha.registry.v1alpha1.ResolveService.GetCargoVersion:output_type -> buf.alpha.registry.v1alpha1.GetCargoVersionResponse
	19, // 42: buf.alpha.registry.v1alpha1.ResolveService.GetNugetVersion:output_type -> buf.alpha.registry.v1alpha1.GetNugetVersionResponse
	21, // 43: buf.alpha.registry.v1alpha1.ResolveService.GetCmakeVersion:output_type -> buf.alpha.registry.v1alpha1.GetCmakeVersionResponse
	5,  // 44: buf.alpha.registry.v1alpha1.LocalResolveService.GetLocalModulePins:output_type -> buf.alpha.registry.v1alpha1.GetLocalModulePinsResponse
	35, // [35:45] is the sub-list for method output_type
	25, // [25:35] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_resolve_proto_init() }
func file_buf_alpha_registry_v1alpha1_resolve_proto_init() {
	if File_buf_alpha_registry_v1alpha1_resolve_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_module_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_resolve_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_resolve_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_resolve_proto = out.File
	file_buf_alpha_registry_v1alpha1_resolve_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_resolve_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_resolve_proto_depIdxs = nil
}
