// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/doc.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// FieldType indicates whether a field is a normal, an extension or an any.
type FieldType int32

const (
	FieldType_FIELD_TYPE_UNSPECIFIED FieldType = 0
	FieldType_FIELD_TYPE_NORMAL      FieldType = 1
	FieldType_FIELD_TYPE_EXTENSION   FieldType = 2
	FieldType_FIELD_TYPE_ANY         FieldType = 3
)

// Enum value maps for FieldType.
var (
	FieldType_name = map[int32]string{
		0: "FIELD_TYPE_UNSPECIFIED",
		1: "FIELD_TYPE_NORMAL",
		2: "FIELD_TYPE_EXTENSION",
		3: "FIELD_TYPE_ANY",
	}
	FieldType_value = map[string]int32{
		"FIELD_TYPE_UNSPECIFIED": 0,
		"FIELD_TYPE_NORMAL":      1,
		"FIELD_TYPE_EXTENSION":   2,
		"FIELD_TYPE_ANY":         3,
	}
)

func (x FieldType) Enum() *FieldType {
	p := new(FieldType)
	*p = x
	return p
}

func (x FieldType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_doc_proto_enumTypes[0].Descriptor()
}

func (FieldType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_doc_proto_enumTypes[0]
}

func (x FieldType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldType.Descriptor instead.
func (FieldType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{0}
}

// GetSourceDirectoryInfoRequest takes an owner, repository, and reference.
type GetSourceDirectoryInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Owner      string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	Repository string `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string `protobuf:"bytes,3,opt,name=reference,proto3" json:"reference,omitempty"`
}

func (x *GetSourceDirectoryInfoRequest) Reset() {
	*x = GetSourceDirectoryInfoRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceDirectoryInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceDirectoryInfoRequest) ProtoMessage() {}

func (x *GetSourceDirectoryInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceDirectoryInfoRequest.ProtoReflect.Descriptor instead.
func (*GetSourceDirectoryInfoRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{0}
}

func (x *GetSourceDirectoryInfoRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GetSourceDirectoryInfoRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *GetSourceDirectoryInfoRequest) GetReference() string {
	if x != nil {
		return x.Reference
	}
	return ""
}

// GetSourceDirectoryInfoResponse returns the root FileInfo for the requested module.
type GetSourceDirectoryInfoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Root *FileInfo `protobuf:"bytes,1,opt,name=root,proto3" json:"root,omitempty"`
}

func (x *GetSourceDirectoryInfoResponse) Reset() {
	*x = GetSourceDirectoryInfoResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceDirectoryInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceDirectoryInfoResponse) ProtoMessage() {}

func (x *GetSourceDirectoryInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceDirectoryInfoResponse.ProtoReflect.Descriptor instead.
func (*GetSourceDirectoryInfoResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{1}
}

func (x *GetSourceDirectoryInfoResponse) GetRoot() *FileInfo {
	if x != nil {
		return x.Root
	}
	return nil
}

// FileInfo is a nested structure that contains the file path, whether or not it's a directory,
// and if so, the FileInfo children of that directory.
type FileInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the normalized path of the directory, relative to the root of the module.
	Path     string      `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	IsDir    bool        `protobuf:"varint,2,opt,name=is_dir,json=isDir,proto3" json:"is_dir,omitempty"`
	Children []*FileInfo `protobuf:"bytes,3,rep,name=children,proto3" json:"children,omitempty"`
}

func (x *FileInfo) Reset() {
	*x = FileInfo{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileInfo) ProtoMessage() {}

func (x *FileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileInfo.ProtoReflect.Descriptor instead.
func (*FileInfo) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{2}
}

func (x *FileInfo) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *FileInfo) GetIsDir() bool {
	if x != nil {
		return x.IsDir
	}
	return false
}

func (x *FileInfo) GetChildren() []*FileInfo {
	if x != nil {
		return x.Children
	}
	return nil
}

// GetSourceFileRequest takes an owner, repository, reference, and normalized path.
type GetSourceFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Owner      string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	Repository string `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string `protobuf:"bytes,3,opt,name=reference,proto3" json:"reference,omitempty"`
	// the normalized path to the requested file, relative to the root of the module.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *GetSourceFileRequest) Reset() {
	*x = GetSourceFileRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceFileRequest) ProtoMessage() {}

func (x *GetSourceFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceFileRequest.ProtoReflect.Descriptor instead.
func (*GetSourceFileRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{3}
}

func (x *GetSourceFileRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GetSourceFileRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *GetSourceFileRequest) GetReference() string {
	if x != nil {
		return x.Reference
	}
	return ""
}

func (x *GetSourceFileRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// GetSourceFileResponse returns the source code contents of the requested file.
type GetSourceFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// content is the content of the file.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *GetSourceFileResponse) Reset() {
	*x = GetSourceFileResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceFileResponse) ProtoMessage() {}

func (x *GetSourceFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceFileResponse.ProtoReflect.Descriptor instead.
func (*GetSourceFileResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{4}
}

func (x *GetSourceFileResponse) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

// GetModulePackagesRequest takes an owner, repository, and reference.
type GetModulePackagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Owner      string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	Repository string `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string `protobuf:"bytes,3,opt,name=reference,proto3" json:"reference,omitempty"`
}

func (x *GetModulePackagesRequest) Reset() {
	*x = GetModulePackagesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePackagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePackagesRequest) ProtoMessage() {}

func (x *GetModulePackagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModulePackagesRequest.ProtoReflect.Descriptor instead.
func (*GetModulePackagesRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{5}
}

func (x *GetModulePackagesRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GetModulePackagesRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *GetModulePackagesRequest) GetReference() string {
	if x != nil {
		return x.Reference
	}
	return ""
}

// GetModulePackagesResponse returns the list of ModulePackages for the requested module.
type GetModulePackagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name           string           `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ModulePackages []*ModulePackage `protobuf:"bytes,2,rep,name=module_packages,json=modulePackages,proto3" json:"module_packages,omitempty"`
}

func (x *GetModulePackagesResponse) Reset() {
	*x = GetModulePackagesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePackagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePackagesResponse) ProtoMessage() {}

func (x *GetModulePackagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModulePackagesResponse.ProtoReflect.Descriptor instead.
func (*GetModulePackagesResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{6}
}

func (x *GetModulePackagesResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetModulePackagesResponse) GetModulePackages() []*ModulePackage {
	if x != nil {
		return x.ModulePackages
	}
	return nil
}

// ModulePackage provides the details about a module's associated package.
type ModulePackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *ModulePackage) Reset() {
	*x = ModulePackage{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModulePackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModulePackage) ProtoMessage() {}

func (x *ModulePackage) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModulePackage.ProtoReflect.Descriptor instead.
func (*ModulePackage) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{7}
}

func (x *ModulePackage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModulePackage) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// GetModuleDocumentationRequest takes an owner, repository, and reference.
type GetModuleDocumentationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Owner      string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	Repository string `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string `protobuf:"bytes,3,opt,name=reference,proto3" json:"reference,omitempty"`
}

func (x *GetModuleDocumentationRequest) Reset() {
	*x = GetModuleDocumentationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModuleDocumentationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModuleDocumentationRequest) ProtoMessage() {}

func (x *GetModuleDocumentationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModuleDocumentationRequest.ProtoReflect.Descriptor instead.
func (*GetModuleDocumentationRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{8}
}

func (x *GetModuleDocumentationRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GetModuleDocumentationRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *GetModuleDocumentationRequest) GetReference() string {
	if x != nil {
		return x.Reference
	}
	return ""
}

// GetModuleDocumentationResponse returns the ModuleDocumentation for the requested module.
type GetModuleDocumentationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ModuleDocumentation *ModuleDocumentation `protobuf:"bytes,1,opt,name=module_documentation,json=moduleDocumentation,proto3" json:"module_documentation,omitempty"`
}

func (x *GetModuleDocumentationResponse) Reset() {
	*x = GetModuleDocumentationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModuleDocumentationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModuleDocumentationResponse) ProtoMessage() {}

func (x *GetModuleDocumentationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModuleDocumentationResponse.ProtoReflect.Descriptor instead.
func (*GetModuleDocumentationResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{9}
}

func (x *GetModuleDocumentationResponse) GetModuleDocumentation() *ModuleDocumentation {
	if x != nil {
		return x.ModuleDocumentation
	}
	return nil
}

// ModuleDocumentation provides the name of the module and associated documentations.
type ModuleDocumentation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is the string representation of the contents of the buf.md file for module-level documentation.
	//
	// The buf.md file is a part of the module.
	// string is used to enforce UTF-8 encoding or 7-bit ASCII text.
	Documentation string `protobuf:"bytes,3,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// This is the string representation of the contents of the LICENSE file for module-level license.
	//
	// The LICENSE file is a part of the module.
	// string is used to enforce UTF-8 encoding or 7-bit ASCII text.
	License string `protobuf:"bytes,4,opt,name=license,proto3" json:"license,omitempty"`
	// documentation_path is the path of the file which contains the module documentation.
	//
	// either `buf.md`, `README.md` or `README.markdown`.
	// if empty, assumes buf.md.
	DocumentationPath string `protobuf:"bytes,5,opt,name=documentation_path,json=documentationPath,proto3" json:"documentation_path,omitempty"`
}

func (x *ModuleDocumentation) Reset() {
	*x = ModuleDocumentation{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModuleDocumentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleDocumentation) ProtoMessage() {}

func (x *ModuleDocumentation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModuleDocumentation.ProtoReflect.Descriptor instead.
func (*ModuleDocumentation) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{10}
}

func (x *ModuleDocumentation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModuleDocumentation) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

func (x *ModuleDocumentation) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

func (x *ModuleDocumentation) GetDocumentationPath() string {
	if x != nil {
		return x.DocumentationPath
	}
	return ""
}

// GetPackageDocumentationRequest takes an owner, repository, reference, and package name.
type GetPackageDocumentationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Owner      string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	Repository string `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string `protobuf:"bytes,3,opt,name=reference,proto3" json:"reference,omitempty"`
	// this is the fully qualified package name.
	PackageName string `protobuf:"bytes,4,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
}

func (x *GetPackageDocumentationRequest) Reset() {
	*x = GetPackageDocumentationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPackageDocumentationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPackageDocumentationRequest) ProtoMessage() {}

func (x *GetPackageDocumentationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPackageDocumentationRequest.ProtoReflect.Descriptor instead.
func (*GetPackageDocumentationRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{11}
}

func (x *GetPackageDocumentationRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GetPackageDocumentationRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *GetPackageDocumentationRequest) GetReference() string {
	if x != nil {
		return x.Reference
	}
	return ""
}

func (x *GetPackageDocumentationRequest) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

// GetPackageDocumentationReponse returns the documentation for the requested package.
type GetPackageDocumentationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PackageDocumentation *PackageDocumentation `protobuf:"bytes,1,opt,name=package_documentation,json=packageDocumentation,proto3" json:"package_documentation,omitempty"`
}

func (x *GetPackageDocumentationResponse) Reset() {
	*x = GetPackageDocumentationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPackageDocumentationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPackageDocumentationResponse) ProtoMessage() {}

func (x *GetPackageDocumentationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPackageDocumentationResponse.ProtoReflect.Descriptor instead.
func (*GetPackageDocumentationResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{12}
}

func (x *GetPackageDocumentationResponse) GetPackageDocumentation() *PackageDocumentation {
	if x != nil {
		return x.PackageDocumentation
	}
	return nil
}

// PackageDocumentation provides the name, description, and top level types defined in the package.
type PackageDocumentation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// comments contains the package-level comment documentation.
	// There is currently no convention for this.
	//
	// This is derived from the leading comments at the top level of the package.
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string `protobuf:"bytes,2,opt,name=comments,proto3" json:"comments,omitempty"`
	// services contains all the services defined in the package in alphabetical order.
	Services []*Service `protobuf:"bytes,3,rep,name=services,proto3" json:"services,omitempty"`
	// enums contains all the enums defined in the package in alphabetical order.
	Enums []*Enum `protobuf:"bytes,4,rep,name=enums,proto3" json:"enums,omitempty"`
	// messages contains all the messages defined in the package in alphabetical order.
	Messages []*Message `protobuf:"bytes,5,rep,name=messages,proto3" json:"messages,omitempty"`
	// extensions contains all the file level extensions in the package in alphabetical order.
	FileExtensions []*FileExtension `protobuf:"bytes,6,rep,name=file_extensions,json=fileExtensions,proto3" json:"file_extensions,omitempty"`
}

func (x *PackageDocumentation) Reset() {
	*x = PackageDocumentation{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PackageDocumentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageDocumentation) ProtoMessage() {}

func (x *PackageDocumentation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageDocumentation.ProtoReflect.Descriptor instead.
func (*PackageDocumentation) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{13}
}

func (x *PackageDocumentation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PackageDocumentation) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

func (x *PackageDocumentation) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *PackageDocumentation) GetEnums() []*Enum {
	if x != nil {
		return x.Enums
	}
	return nil
}

func (x *PackageDocumentation) GetMessages() []*Message {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *PackageDocumentation) GetFileExtensions() []*FileExtension {
	if x != nil {
		return x.FileExtensions
	}
	return nil
}

// Location provides the location information for the source code.
//
// This does not provide the leading or trailing comments as these will
// be parsed into descriptions or dropped respectively.
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartLine   int32 `protobuf:"varint,1,opt,name=start_line,json=startLine,proto3" json:"start_line,omitempty"`
	StartColumn int32 `protobuf:"varint,2,opt,name=start_column,json=startColumn,proto3" json:"start_column,omitempty"`
	EndLine     int32 `protobuf:"varint,3,opt,name=end_line,json=endLine,proto3" json:"end_line,omitempty"`
	EndColumn   int32 `protobuf:"varint,4,opt,name=end_column,json=endColumn,proto3" json:"end_column,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{14}
}

func (x *Location) GetStartLine() int32 {
	if x != nil {
		return x.StartLine
	}
	return 0
}

func (x *Location) GetStartColumn() int32 {
	if x != nil {
		return x.StartColumn
	}
	return 0
}

func (x *Location) GetEndLine() int32 {
	if x != nil {
		return x.EndLine
	}
	return 0
}

func (x *Location) GetEndColumn() int32 {
	if x != nil {
		return x.EndColumn
	}
	return 0
}

// Service provides information for the documentation for a given service type in a file.
type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// nested_name includes the nested types for a given type definition.
	NestedName string `protobuf:"bytes,2,opt,name=nested_name,json=nestedName,proto3" json:"nested_name,omitempty"`
	// full_name includes the package name and nested types for a given type definition.
	FullName string `protobuf:"bytes,3,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty"`
	// comments is derived from the leading comments of a given service.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string `protobuf:"bytes,4,opt,name=comments,proto3" json:"comments,omitempty"`
	// file_path is the normalized path of the file containing the service.
	// This is used for navigating to the source code for the service.
	FilePath string    `protobuf:"bytes,5,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	Location *Location `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	Methods  []*Method `protobuf:"bytes,7,rep,name=methods,proto3" json:"methods,omitempty"`
	// implicitly_deprecated is true if its enclosing file is deprecated.
	ImplicitlyDeprecated bool `protobuf:"varint,9,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3" json:"implicitly_deprecated,omitempty"`
	// All options that are present on the service. This is a super-set of
	// service_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// This supersedes service_options.
	Options []*FieldLiteral `protobuf:"bytes,10,rep,name=options,proto3" json:"options,omitempty"`
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	ServiceOptions *ServiceOptions `protobuf:"bytes,8,opt,name=service_options,json=serviceOptions,proto3" json:"service_options,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{15}
}

func (x *Service) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Service) GetNestedName() string {
	if x != nil {
		return x.NestedName
	}
	return ""
}

func (x *Service) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *Service) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

func (x *Service) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

func (x *Service) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Service) GetMethods() []*Method {
	if x != nil {
		return x.Methods
	}
	return nil
}

func (x *Service) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.ImplicitlyDeprecated
	}
	return false
}

func (x *Service) GetOptions() []*FieldLiteral {
	if x != nil {
		return x.Options
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Service) GetServiceOptions() *ServiceOptions {
	if x != nil {
		return x.ServiceOptions
	}
	return nil
}

// ServiceOptions provides information for the documentation of options for a given service.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type ServiceOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Deprecated bool `protobuf:"varint,1,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
}

func (x *ServiceOptions) Reset() {
	*x = ServiceOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceOptions) ProtoMessage() {}

func (x *ServiceOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceOptions.ProtoReflect.Descriptor instead.
func (*ServiceOptions) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{16}
}

func (x *ServiceOptions) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

// Method provides information for the documentation for a method of a given service.
type Method struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// comments is derived from the leading comments of a given method.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string                 `protobuf:"bytes,2,opt,name=comments,proto3" json:"comments,omitempty"`
	Request  *MethodRequestResponse `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	Response *MethodRequestResponse `protobuf:"bytes,4,opt,name=response,proto3" json:"response,omitempty"`
	// implicitly_deprecated is true if its enclosing file or parent element is deprecated.
	ImplicitlyDeprecated bool `protobuf:"varint,6,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3" json:"implicitly_deprecated,omitempty"`
	// All options that are present on the method. This is a super-set of
	// method_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// This supersedes method_options.
	Options []*FieldLiteral `protobuf:"bytes,7,rep,name=options,proto3" json:"options,omitempty"`
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	MethodOptions *MethodOptions `protobuf:"bytes,5,opt,name=method_options,json=methodOptions,proto3" json:"method_options,omitempty"`
}

func (x *Method) Reset() {
	*x = Method{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Method) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Method) ProtoMessage() {}

func (x *Method) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Method.ProtoReflect.Descriptor instead.
func (*Method) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{17}
}

func (x *Method) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Method) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

func (x *Method) GetRequest() *MethodRequestResponse {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *Method) GetResponse() *MethodRequestResponse {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *Method) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.ImplicitlyDeprecated
	}
	return false
}

func (x *Method) GetOptions() []*FieldLiteral {
	if x != nil {
		return x.Options
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Method) GetMethodOptions() *MethodOptions {
	if x != nil {
		return x.MethodOptions
	}
	return nil
}

// MethodOptions provides information for the documentation of options for a method.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type MethodOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Deprecated bool `protobuf:"varint,1,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// idempotency_level holds a value of the enumeration `google.protobuf.MethodOptions.IdempotencyLevel.
	IdempotencyLevel int32 `protobuf:"varint,2,opt,name=idempotency_level,json=idempotencyLevel,proto3" json:"idempotency_level,omitempty"`
}

func (x *MethodOptions) Reset() {
	*x = MethodOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MethodOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodOptions) ProtoMessage() {}

func (x *MethodOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MethodOptions.ProtoReflect.Descriptor instead.
func (*MethodOptions) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{18}
}

func (x *MethodOptions) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *MethodOptions) GetIdempotencyLevel() int32 {
	if x != nil {
		return x.IdempotencyLevel
	}
	return 0
}

// MethodRequestResponse provides information for the documentation of a Method request or response message.
type MethodRequestResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// nested_type is the nested name of the message of the request or response. This includes nested definitions.
	NestedType string `protobuf:"bytes,1,opt,name=nested_type,json=nestedType,proto3" json:"nested_type,omitempty"`
	// full_type is the fully qualified name of the message of the request or response. This includes package and nested definitions.
	FullType string `protobuf:"bytes,2,opt,name=full_type,json=fullType,proto3" json:"full_type,omitempty"`
	// boolean flag for whether the streaming label is set on an method request or response.
	Streaming bool     `protobuf:"varint,3,opt,name=streaming,proto3" json:"streaming,omitempty"`
	Message   *Message `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	// import_module_ref is included if the request or response is an imported type.
	// It contains all the metadata for the import.
	ImportModuleRef *ImportModuleRef `protobuf:"bytes,5,opt,name=import_module_ref,json=importModuleRef,proto3" json:"import_module_ref,omitempty"`
}

func (x *MethodRequestResponse) Reset() {
	*x = MethodRequestResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MethodRequestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodRequestResponse) ProtoMessage() {}

func (x *MethodRequestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MethodRequestResponse.ProtoReflect.Descriptor instead.
func (*MethodRequestResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{19}
}

func (x *MethodRequestResponse) GetNestedType() string {
	if x != nil {
		return x.NestedType
	}
	return ""
}

func (x *MethodRequestResponse) GetFullType() string {
	if x != nil {
		return x.FullType
	}
	return ""
}

func (x *MethodRequestResponse) GetStreaming() bool {
	if x != nil {
		return x.Streaming
	}
	return false
}

func (x *MethodRequestResponse) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *MethodRequestResponse) GetImportModuleRef() *ImportModuleRef {
	if x != nil {
		return x.ImportModuleRef
	}
	return nil
}

// Enum provides information for the documentation of an enum.
type Enum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// nested_name includes the nested types for a given type definition.
	NestedName string `protobuf:"bytes,2,opt,name=nested_name,json=nestedName,proto3" json:"nested_name,omitempty"`
	// full_name includes the package name and nested types for a given type definition.
	FullName string `protobuf:"bytes,3,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty"`
	// comments is derived from the leading comments of a given Enum.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string `protobuf:"bytes,4,opt,name=comments,proto3" json:"comments,omitempty"`
	// file_path is the normalized path of the file containing the enum.
	FilePath string       `protobuf:"bytes,5,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	Location *Location    `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	Values   []*EnumValue `protobuf:"bytes,7,rep,name=values,proto3" json:"values,omitempty"`
	// implicitly_deprecated is true if its enclosing file or parent element is deprecated.
	ImplicitlyDeprecated bool `protobuf:"varint,9,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3" json:"implicitly_deprecated,omitempty"`
	// All options that are present on the enum. This is a super-set of
	// enum_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// // This supersedes enum_options.
	Options []*FieldLiteral `protobuf:"bytes,10,rep,name=options,proto3" json:"options,omitempty"`
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	EnumOptions *EnumOptions `protobuf:"bytes,8,opt,name=enum_options,json=enumOptions,proto3" json:"enum_options,omitempty"`
}

func (x *Enum) Reset() {
	*x = Enum{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Enum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Enum) ProtoMessage() {}

func (x *Enum) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Enum.ProtoReflect.Descriptor instead.
func (*Enum) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{20}
}

func (x *Enum) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Enum) GetNestedName() string {
	if x != nil {
		return x.NestedName
	}
	return ""
}

func (x *Enum) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *Enum) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

func (x *Enum) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

func (x *Enum) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Enum) GetValues() []*EnumValue {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *Enum) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.ImplicitlyDeprecated
	}
	return false
}

func (x *Enum) GetOptions() []*FieldLiteral {
	if x != nil {
		return x.Options
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Enum) GetEnumOptions() *EnumOptions {
	if x != nil {
		return x.EnumOptions
	}
	return nil
}

// EnumOptions provides information for the documentation of options for an enum.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type EnumOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Deprecated bool `protobuf:"varint,1,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	AllowAlias bool `protobuf:"varint,2,opt,name=allow_alias,json=allowAlias,proto3" json:"allow_alias,omitempty"`
}

func (x *EnumOptions) Reset() {
	*x = EnumOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumOptions) ProtoMessage() {}

func (x *EnumOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumOptions.ProtoReflect.Descriptor instead.
func (*EnumOptions) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{21}
}

func (x *EnumOptions) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *EnumOptions) GetAllowAlias() bool {
	if x != nil {
		return x.AllowAlias
	}
	return false
}

// EnumValue provides information for the documentation of an enum value.
type EnumValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name   string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Number int32  `protobuf:"varint,2,opt,name=number,proto3" json:"number,omitempty"`
	// comments is derived from the leading comments of a given enum value.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string `protobuf:"bytes,3,opt,name=comments,proto3" json:"comments,omitempty"`
	// All options that are present on the enum. This is a super-set of
	// enum_value_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// // This supersedes enum_value_options.
	Options []*FieldLiteral `protobuf:"bytes,5,rep,name=options,proto3" json:"options,omitempty"`
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	EnumValueOptions *EnumValueOptions `protobuf:"bytes,4,opt,name=enum_value_options,json=enumValueOptions,proto3" json:"enum_value_options,omitempty"`
}

func (x *EnumValue) Reset() {
	*x = EnumValue{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumValue) ProtoMessage() {}

func (x *EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumValue.ProtoReflect.Descriptor instead.
func (*EnumValue) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{22}
}

func (x *EnumValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnumValue) GetNumber() int32 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *EnumValue) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

func (x *EnumValue) GetOptions() []*FieldLiteral {
	if x != nil {
		return x.Options
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *EnumValue) GetEnumValueOptions() *EnumValueOptions {
	if x != nil {
		return x.EnumValueOptions
	}
	return nil
}

// EnumValueOptions provides information for the documentation of options for an enum value.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type EnumValueOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Deprecated bool `protobuf:"varint,1,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
}

func (x *EnumValueOptions) Reset() {
	*x = EnumValueOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumValueOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumValueOptions) ProtoMessage() {}

func (x *EnumValueOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumValueOptions.ProtoReflect.Descriptor instead.
func (*EnumValueOptions) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{23}
}

func (x *EnumValueOptions) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

// ImportRef provides the import metadata if a type is imported.
type ImportModuleRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Remote     string `protobuf:"bytes,1,opt,name=remote,proto3" json:"remote,omitempty"`
	Owner      string `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	Repository string `protobuf:"bytes,3,opt,name=repository,proto3" json:"repository,omitempty"`
	// the commit is based on the module commit of the imported type provided
	// by the image.
	Commit      string `protobuf:"bytes,4,opt,name=commit,proto3" json:"commit,omitempty"`
	PackageName string `protobuf:"bytes,5,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
}

func (x *ImportModuleRef) Reset() {
	*x = ImportModuleRef{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportModuleRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportModuleRef) ProtoMessage() {}

func (x *ImportModuleRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportModuleRef.ProtoReflect.Descriptor instead.
func (*ImportModuleRef) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{24}
}

func (x *ImportModuleRef) GetRemote() string {
	if x != nil {
		return x.Remote
	}
	return ""
}

func (x *ImportModuleRef) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *ImportModuleRef) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *ImportModuleRef) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

func (x *ImportModuleRef) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

// Message provides information for the documentation of a protobuf message.
type Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// nested_name includes the nested types for a given type definition.
	NestedName string `protobuf:"bytes,2,opt,name=nested_name,json=nestedName,proto3" json:"nested_name,omitempty"`
	// full_name includes the package name and nested types for a given type definition.
	FullName string `protobuf:"bytes,3,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty"`
	// comments is derived from the leading comments of a given message.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string `protobuf:"bytes,4,opt,name=comments,proto3" json:"comments,omitempty"`
	// file_path is the normalized path of the file containing the message.
	FilePath          string          `protobuf:"bytes,5,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	IsMapEntry        bool            `protobuf:"varint,6,opt,name=is_map_entry,json=isMapEntry,proto3" json:"is_map_entry,omitempty"`
	Fields            []*MessageField `protobuf:"bytes,7,rep,name=fields,proto3" json:"fields,omitempty"`
	Location          *Location       `protobuf:"bytes,8,opt,name=location,proto3" json:"location,omitempty"`
	MessageExtensions []*Field        `protobuf:"bytes,9,rep,name=message_extensions,json=messageExtensions,proto3" json:"message_extensions,omitempty"`
	// implicitly_deprecated is true if its enclosing file or parent element is deprecated.
	ImplicitlyDeprecated bool `protobuf:"varint,11,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3" json:"implicitly_deprecated,omitempty"`
	// All options that are present on the message. This is a super-set of
	// message_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// // This supersedes message_options.
	Options []*FieldLiteral `protobuf:"bytes,12,rep,name=options,proto3" json:"options,omitempty"`
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	MessageOptions *MessageOptions `protobuf:"bytes,10,opt,name=message_options,json=messageOptions,proto3" json:"message_options,omitempty"`
}

func (x *Message) Reset() {
	*x = Message{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{25}
}

func (x *Message) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Message) GetNestedName() string {
	if x != nil {
		return x.NestedName
	}
	return ""
}

func (x *Message) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *Message) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

func (x *Message) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

func (x *Message) GetIsMapEntry() bool {
	if x != nil {
		return x.IsMapEntry
	}
	return false
}

func (x *Message) GetFields() []*MessageField {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Message) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Message) GetMessageExtensions() []*Field {
	if x != nil {
		return x.MessageExtensions
	}
	return nil
}

func (x *Message) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.ImplicitlyDeprecated
	}
	return false
}

func (x *Message) GetOptions() []*FieldLiteral {
	if x != nil {
		return x.Options
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Message) GetMessageOptions() *MessageOptions {
	if x != nil {
		return x.MessageOptions
	}
	return nil
}

// MessageField can be either a single field or a oneof set of fields.
type MessageField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to MessageField:
	//
	//	*MessageField_Field
	//	*MessageField_Oneof
	MessageField isMessageField_MessageField `protobuf_oneof:"message_field"`
}

func (x *MessageField) Reset() {
	*x = MessageField{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageField) ProtoMessage() {}

func (x *MessageField) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageField.ProtoReflect.Descriptor instead.
func (*MessageField) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{26}
}

func (m *MessageField) GetMessageField() isMessageField_MessageField {
	if m != nil {
		return m.MessageField
	}
	return nil
}

func (x *MessageField) GetField() *Field {
	if x, ok := x.GetMessageField().(*MessageField_Field); ok {
		return x.Field
	}
	return nil
}

func (x *MessageField) GetOneof() *Oneof {
	if x, ok := x.GetMessageField().(*MessageField_Oneof); ok {
		return x.Oneof
	}
	return nil
}

type isMessageField_MessageField interface {
	isMessageField_MessageField()
}

type MessageField_Field struct {
	Field *Field `protobuf:"bytes,1,opt,name=field,proto3,oneof"`
}

type MessageField_Oneof struct {
	Oneof *Oneof `protobuf:"bytes,2,opt,name=oneof,proto3,oneof"`
}

func (*MessageField_Field) isMessageField_MessageField() {}

func (*MessageField_Oneof) isMessageField_MessageField() {}

// MessageOptions provides information for the documentation of options for a message.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type MessageOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Deprecated bool `protobuf:"varint,1,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
}

func (x *MessageOptions) Reset() {
	*x = MessageOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageOptions) ProtoMessage() {}

func (x *MessageOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageOptions.ProtoReflect.Descriptor instead.
func (*MessageOptions) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{27}
}

func (x *MessageOptions) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

// Oneof represents a oneof set of fields.
type Oneof struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name   string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Fields []*Field `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
	// All options that are present on the OneOf.
	// This is a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	Options []*FieldLiteral `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *Oneof) Reset() {
	*x = Oneof{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Oneof) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Oneof) ProtoMessage() {}

func (x *Oneof) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Oneof.ProtoReflect.Descriptor instead.
func (*Oneof) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{28}
}

func (x *Oneof) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Oneof) GetFields() []*Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Oneof) GetOptions() []*FieldLiteral {
	if x != nil {
		return x.Options
	}
	return nil
}

// Field provides information for the documentation of a message field.
type Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// comments is derived from the leading comments of a given message field.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string `protobuf:"bytes,2,opt,name=comments,proto3" json:"comments,omitempty"`
	Label    string `protobuf:"bytes,3,opt,name=label,proto3" json:"label,omitempty"`
	// string representation of the nested name of the field type, which includes nested definitions.
	NestedType string `protobuf:"bytes,4,opt,name=nested_type,json=nestedType,proto3" json:"nested_type,omitempty"`
	// string representation of the full name of the field type, which includes package name
	// and nested definitions.
	FullType string `protobuf:"bytes,5,opt,name=full_type,json=fullType,proto3" json:"full_type,omitempty"`
	Tag      uint32 `protobuf:"varint,6,opt,name=tag,proto3" json:"tag,omitempty"`
	// MapEntry is present if the field is a map type.
	MapEntry *MapEntry `protobuf:"bytes,7,opt,name=map_entry,json=mapEntry,proto3" json:"map_entry,omitempty"`
	// import_module_ref is included if the field is an imported type.
	// It contains all the metadata for the import.
	ImportModuleRef *ImportModuleRef `protobuf:"bytes,8,opt,name=import_module_ref,json=importModuleRef,proto3" json:"import_module_ref,omitempty"`
	// Extendee is the name of the type that is being ext if the field is an extension.
	// This is an empty string for fields that are not extenions.
	Extendee string `protobuf:"bytes,9,opt,name=extendee,proto3" json:"extendee,omitempty"`
	// All options that are present on the field. This is a super-set of
	// field_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// This supersedes field_options.
	Options []*FieldLiteral `protobuf:"bytes,11,rep,name=options,proto3" json:"options,omitempty"`
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	FieldOptions *FieldOptions `protobuf:"bytes,10,opt,name=field_options,json=fieldOptions,proto3" json:"field_options,omitempty"`
}

func (x *Field) Reset() {
	*x = Field{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field) ProtoMessage() {}

func (x *Field) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Field.ProtoReflect.Descriptor instead.
func (*Field) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{29}
}

func (x *Field) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Field) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

func (x *Field) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *Field) GetNestedType() string {
	if x != nil {
		return x.NestedType
	}
	return ""
}

func (x *Field) GetFullType() string {
	if x != nil {
		return x.FullType
	}
	return ""
}

func (x *Field) GetTag() uint32 {
	if x != nil {
		return x.Tag
	}
	return 0
}

func (x *Field) GetMapEntry() *MapEntry {
	if x != nil {
		return x.MapEntry
	}
	return nil
}

func (x *Field) GetImportModuleRef() *ImportModuleRef {
	if x != nil {
		return x.ImportModuleRef
	}
	return nil
}

func (x *Field) GetExtendee() string {
	if x != nil {
		return x.Extendee
	}
	return ""
}

func (x *Field) GetOptions() []*FieldLiteral {
	if x != nil {
		return x.Options
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Field) GetFieldOptions() *FieldOptions {
	if x != nil {
		return x.FieldOptions
	}
	return nil
}

// FieldOptions provides information for the documentation of options for a field.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type FieldOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Deprecated bool  `protobuf:"varint,1,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	Packed     *bool `protobuf:"varint,2,opt,name=packed,proto3,oneof" json:"packed,omitempty"`
	// ctype holds a value of the enumeration `google.protobuf.FieldOptions.CType.
	Ctype int32 `protobuf:"varint,3,opt,name=ctype,proto3" json:"ctype,omitempty"`
	// jstype holds a value of the enumeration `google.protobuf.FieldOptions.JSType.
	Jstype int32 `protobuf:"varint,4,opt,name=jstype,proto3" json:"jstype,omitempty"`
}

func (x *FieldOptions) Reset() {
	*x = FieldOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldOptions) ProtoMessage() {}

func (x *FieldOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldOptions.ProtoReflect.Descriptor instead.
func (*FieldOptions) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{30}
}

func (x *FieldOptions) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *FieldOptions) GetPacked() bool {
	if x != nil && x.Packed != nil {
		return *x.Packed
	}
	return false
}

func (x *FieldOptions) GetCtype() int32 {
	if x != nil {
		return x.Ctype
	}
	return 0
}

func (x *FieldOptions) GetJstype() int32 {
	if x != nil {
		return x.Jstype
	}
	return 0
}

// FieldLiteral represents a field and its value. It can be used to model descriptor options.
type FieldLiteral struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When is_extension is true, name is the fully-qualified name of the
	// extension. Otherwise, it is the simple name of the field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique field number associated with the field.
	Tag int32 `protobuf:"varint,2,opt,name=tag,proto3" json:"tag,omitempty"`
	// Indicates whether this is an extension or not.
	FieldType FieldType `protobuf:"varint,3,opt,name=field_type,json=fieldType,proto3,enum=buf.alpha.registry.v1alpha1.FieldType" json:"field_type,omitempty"`
	// The field's value.
	Value *LiteralValue `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	// This is the module where the extension is defined if the field type
	// is extension or the module where the messages is defined for field type any.
	ImportModuleRef *ImportModuleRef `protobuf:"bytes,5,opt,name=import_module_ref,json=importModuleRef,proto3" json:"import_module_ref,omitempty"`
}

func (x *FieldLiteral) Reset() {
	*x = FieldLiteral{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldLiteral) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldLiteral) ProtoMessage() {}

func (x *FieldLiteral) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldLiteral.ProtoReflect.Descriptor instead.
func (*FieldLiteral) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{31}
}

func (x *FieldLiteral) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FieldLiteral) GetTag() int32 {
	if x != nil {
		return x.Tag
	}
	return 0
}

func (x *FieldLiteral) GetFieldType() FieldType {
	if x != nil {
		return x.FieldType
	}
	return FieldType_FIELD_TYPE_UNSPECIFIED
}

func (x *FieldLiteral) GetValue() *LiteralValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *FieldLiteral) GetImportModuleRef() *ImportModuleRef {
	if x != nil {
		return x.ImportModuleRef
	}
	return nil
}

// MessageLiteral represents an option value for a type that is a message.
type MessageLiteral struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of field names to value. Extension field names will be in the form:
	// [fully.qualified.extension.Name].
	Fields []*FieldLiteral `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *MessageLiteral) Reset() {
	*x = MessageLiteral{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageLiteral) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageLiteral) ProtoMessage() {}

func (x *MessageLiteral) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageLiteral.ProtoReflect.Descriptor instead.
func (*MessageLiteral) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{32}
}

func (x *MessageLiteral) GetFields() []*FieldLiteral {
	if x != nil {
		return x.Fields
	}
	return nil
}

// ArrayLiteral represents an option value for a type that is a repeated field.
// Maps are also represented using an ArrayLiteral, where each map entry is a MessageLiteral
// that contains a key and value field.
type ArrayLiteral struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Elements []*LiteralValue `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
}

func (x *ArrayLiteral) Reset() {
	*x = ArrayLiteral{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArrayLiteral) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArrayLiteral) ProtoMessage() {}

func (x *ArrayLiteral) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArrayLiteral.ProtoReflect.Descriptor instead.
func (*ArrayLiteral) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{33}
}

func (x *ArrayLiteral) GetElements() []*LiteralValue {
	if x != nil {
		return x.Elements
	}
	return nil
}

// LiteralValue represents the actual value of the extension.
type LiteralValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*LiteralValue_StringValue
	//	*LiteralValue_IntValue
	//	*LiteralValue_UintValue
	//	*LiteralValue_DoubleValue
	//	*LiteralValue_BoolValue
	//	*LiteralValue_EnumValueNameValue
	//	*LiteralValue_ArrayValue
	//	*LiteralValue_MessageValue
	Value    isLiteralValue_Value `protobuf_oneof:"value"`
	Comments string               `protobuf:"bytes,10,opt,name=comments,proto3" json:"comments,omitempty"`
}

func (x *LiteralValue) Reset() {
	*x = LiteralValue{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LiteralValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LiteralValue) ProtoMessage() {}

func (x *LiteralValue) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LiteralValue.ProtoReflect.Descriptor instead.
func (*LiteralValue) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{34}
}

func (m *LiteralValue) GetValue() isLiteralValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *LiteralValue) GetStringValue() string {
	if x, ok := x.GetValue().(*LiteralValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *LiteralValue) GetIntValue() int64 {
	if x, ok := x.GetValue().(*LiteralValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *LiteralValue) GetUintValue() uint64 {
	if x, ok := x.GetValue().(*LiteralValue_UintValue); ok {
		return x.UintValue
	}
	return 0
}

func (x *LiteralValue) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*LiteralValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *LiteralValue) GetBoolValue() bool {
	if x, ok := x.GetValue().(*LiteralValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *LiteralValue) GetEnumValueNameValue() string {
	if x, ok := x.GetValue().(*LiteralValue_EnumValueNameValue); ok {
		return x.EnumValueNameValue
	}
	return ""
}

func (x *LiteralValue) GetArrayValue() *ArrayLiteral {
	if x, ok := x.GetValue().(*LiteralValue_ArrayValue); ok {
		return x.ArrayValue
	}
	return nil
}

func (x *LiteralValue) GetMessageValue() *MessageLiteral {
	if x, ok := x.GetValue().(*LiteralValue_MessageValue); ok {
		return x.MessageValue
	}
	return nil
}

func (x *LiteralValue) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

type isLiteralValue_Value interface {
	isLiteralValue_Value()
}

type LiteralValue_StringValue struct {
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type LiteralValue_IntValue struct {
	IntValue int64 `protobuf:"varint,3,opt,name=int_value,json=intValue,proto3,oneof"`
}

type LiteralValue_UintValue struct {
	UintValue uint64 `protobuf:"varint,4,opt,name=uint_value,json=uintValue,proto3,oneof"`
}

type LiteralValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,5,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type LiteralValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,6,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type LiteralValue_EnumValueNameValue struct {
	EnumValueNameValue string `protobuf:"bytes,7,opt,name=enum_value_name_value,json=enumValueNameValue,proto3,oneof"`
}

type LiteralValue_ArrayValue struct {
	ArrayValue *ArrayLiteral `protobuf:"bytes,8,opt,name=array_value,json=arrayValue,proto3,oneof"`
}

type LiteralValue_MessageValue struct {
	MessageValue *MessageLiteral `protobuf:"bytes,9,opt,name=message_value,json=messageValue,proto3,oneof"`
}

func (*LiteralValue_StringValue) isLiteralValue_Value() {}

func (*LiteralValue_IntValue) isLiteralValue_Value() {}

func (*LiteralValue_UintValue) isLiteralValue_Value() {}

func (*LiteralValue_DoubleValue) isLiteralValue_Value() {}

func (*LiteralValue_BoolValue) isLiteralValue_Value() {}

func (*LiteralValue_EnumValueNameValue) isLiteralValue_Value() {}

func (*LiteralValue_ArrayValue) isLiteralValue_Value() {}

func (*LiteralValue_MessageValue) isLiteralValue_Value() {}

// MapEntry provides the key and value types for the MapEntry type for a map field.
type MapEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// string representation of the full name of the type for the map key. keys can only be
	// scalar types: https://developers.google.com/protocol-buffers/docs/overview#maps
	KeyFullType string `protobuf:"bytes,1,opt,name=key_full_type,json=keyFullType,proto3" json:"key_full_type,omitempty"`
	// string representation of the nested name of the type for the map value.
	ValueNestedType string `protobuf:"bytes,2,opt,name=value_nested_type,json=valueNestedType,proto3" json:"value_nested_type,omitempty"`
	// string representation of the full name of the type for the map value.
	ValueFullType string `protobuf:"bytes,3,opt,name=value_full_type,json=valueFullType,proto3" json:"value_full_type,omitempty"`
	// if the value is an imported type, this is the import module ref
	ValueImportModuleRef *ImportModuleRef `protobuf:"bytes,4,opt,name=value_import_module_ref,json=valueImportModuleRef,proto3" json:"value_import_module_ref,omitempty"`
}

func (x *MapEntry) Reset() {
	*x = MapEntry{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapEntry) ProtoMessage() {}

func (x *MapEntry) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapEntry.ProtoReflect.Descriptor instead.
func (*MapEntry) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{35}
}

func (x *MapEntry) GetKeyFullType() string {
	if x != nil {
		return x.KeyFullType
	}
	return ""
}

func (x *MapEntry) GetValueNestedType() string {
	if x != nil {
		return x.ValueNestedType
	}
	return ""
}

func (x *MapEntry) GetValueFullType() string {
	if x != nil {
		return x.ValueFullType
	}
	return ""
}

func (x *MapEntry) GetValueImportModuleRef() *ImportModuleRef {
	if x != nil {
		return x.ValueImportModuleRef
	}
	return nil
}

// FileExtension provides the information for the documentation of a file extension.
type FileExtension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// extension_type is the string representation of the type being extended.
	ExtensionType string `protobuf:"bytes,1,opt,name=extension_type,json=extensionType,proto3" json:"extension_type,omitempty"`
	// comments is derived from the leading comments of a given message field.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string `protobuf:"bytes,2,opt,name=comments,proto3" json:"comments,omitempty"`
	// file_path is the normalized path of the file containing the message.
	FilePath string    `protobuf:"bytes,3,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	Location *Location `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// fields are all the fields that are associated with the extension.
	Fields []*Field `protobuf:"bytes,5,rep,name=fields,proto3" json:"fields,omitempty"`
	// implicitly_deprecated is true if its enclosing file or parent element is deprecated.
	ImplicitlyDeprecated bool `protobuf:"varint,6,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3" json:"implicitly_deprecated,omitempty"`
}

func (x *FileExtension) Reset() {
	*x = FileExtension{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileExtension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileExtension) ProtoMessage() {}

func (x *FileExtension) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileExtension.ProtoReflect.Descriptor instead.
func (*FileExtension) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP(), []int{36}
}

func (x *FileExtension) GetExtensionType() string {
	if x != nil {
		return x.ExtensionType
	}
	return ""
}

func (x *FileExtension) GetComments() string {
	if x != nil {
		return x.Comments
	}
	return ""
}

func (x *FileExtension) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

func (x *FileExtension) GetLocation() *Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *FileExtension) GetFields() []*Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *FileExtension) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.ImplicitlyDeprecated
	}
	return false
}

var File_buf_alpha_registry_v1alpha1_doc_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_doc_proto_rawDesc = []byte{
	0x0a, 0x25, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x64, 0x6f,
	0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x22, 0x73, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x5b, 0x0a, 0x1e, 0x47, 0x65, 0x74,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x72,
	0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x22, 0x78, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x15, 0x0a, 0x06, 0x69, 0x73, 0x5f, 0x64, 0x69, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x69, 0x73, 0x44, 0x69, 0x72, 0x12, 0x41, 0x0a,
	0x08, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69,
	0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e,
	0x22, 0x7e, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c,
	0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x22, 0x31, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x22, 0x6e, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x22, 0x45, 0x0a, 0x0d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x73, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x63, 0x0a, 0x14, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98,
	0x01, 0x0a, 0x13, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x22, 0x97, 0x01, 0x0a, 0x1e, 0x47, 0x65,
	0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x89, 0x01, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x15, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xd8, 0x02, 0x0a, 0x14, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x05, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x05, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x12, 0x40, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x86, 0x01, 0x0a, 0x08, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x4c, 0x69, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x22, 0xea, 0x03, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a,
	0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x33, 0x0a, 0x15,
	0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6d, 0x70,
	0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x34, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xa7, 0x03, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x4c, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x33, 0x0a, 0x15, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14,
	0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c,
	0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0e, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x60, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x69, 0x64,
	0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x3a, 0x02,
	0x18, 0x01, 0x22, 0x8d, 0x02, 0x0a, 0x15, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x3e, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x58, 0x0a, 0x11, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65,
	0x66, 0x52, 0x0f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x66, 0x22, 0xdf, 0x03, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69,
	0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x69, 0x6d, 0x70,
	0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63,
	0x69, 0x74, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x43,
	0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x0c, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x52, 0x0a, 0x0b, 0x45, 0x6e, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6c, 0x69,
	0x61, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41,
	0x6c, 0x69, 0x61, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xf9, 0x01, 0x0a, 0x09, 0x45, 0x6e, 0x75,
	0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x43,
	0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x12, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e,
	0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x36, 0x0a, 0x10, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x9a, 0x01, 0x0a,
	0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66,
	0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x16,
	0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xe3, 0x04, 0x0a, 0x07, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66,
	0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x20, 0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x41, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x12, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x69,
	0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6c,
	0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x97, 0x01, 0x0a, 0x0c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x3a, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x48, 0x00, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x0a, 0x05,
	0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x6e, 0x65, 0x6f, 0x66, 0x48,
	0x00, 0x52, 0x05, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x42, 0x0f, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x34, 0x0a, 0x0e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x3a, 0x02, 0x18, 0x01, 0x22,
	0x9c, 0x01, 0x0a, 0x05, 0x4f, 0x6e, 0x65, 0x6f, 0x66, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69,
	0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf0,
	0x03, 0x0a, 0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1f,
	0x0a, 0x0b, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x74, 0x61, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x42,
	0x0a, 0x09, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x58, 0x0a, 0x11, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x52, 0x0f, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x12, 0x1a, 0x0a, 0x08,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52, 0x0a,
	0x0d, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0x88, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x14, 0x0a, 0x05, 0x63, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x63, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6a, 0x73, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6a, 0x73, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x02, 0x18,
	0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x22, 0x96, 0x02, 0x0a,
	0x0c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03,
	0x74, 0x61, 0x67, 0x12, 0x45, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x58, 0x0a, 0x11, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x52, 0x0f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x66, 0x22, 0x53, 0x0a, 0x0e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x41, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0x55, 0x0a, 0x0c, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x45, 0x0a, 0x08, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x22, 0xb5, 0x03, 0x0a, 0x0c, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x75, 0x69, 0x6e, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x48, 0x00, 0x52, 0x09, 0x75, 0x69,
	0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52,
	0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a,
	0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x33, 0x0a,
	0x15, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x12,
	0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x52, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe7, 0x01, 0x0a, 0x08, 0x4d, 0x61,
	0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6b,
	0x65, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x5f, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x4e, 0x65, 0x73, 0x74,
	0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x63,
	0x0a, 0x17, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x52, 0x14, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x66, 0x22, 0xa3, 0x02, 0x0a, 0x0d, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74,
	0x6c, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x44,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x2a, 0x6c, 0x0a, 0x09, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x45,
	0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x4e, 0x53, 0x49, 0x4f,
	0x4e, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x41, 0x4e, 0x59, 0x10, 0x03, 0x32, 0xe1, 0x05, 0x0a, 0x0a, 0x44, 0x6f, 0x63, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x96, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12,
	0x7b, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x87, 0x01, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x96, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12,
	0x99, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x95, 0x02, 0x0a, 0x1f,
	0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42,
	0x08, 0x44, 0x6f, 0x63, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42,
	0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66,
	0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41,
	0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a,
	0x3a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_doc_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_doc_proto_rawDescData = file_buf_alpha_registry_v1alpha1_doc_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_doc_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_doc_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_doc_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_doc_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_doc_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_doc_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_buf_alpha_registry_v1alpha1_doc_proto_goTypes = []any{
	(FieldType)(0),                          // 0: buf.alpha.registry.v1alpha1.FieldType
	(*GetSourceDirectoryInfoRequest)(nil),   // 1: buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoRequest
	(*GetSourceDirectoryInfoResponse)(nil),  // 2: buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoResponse
	(*FileInfo)(nil),                        // 3: buf.alpha.registry.v1alpha1.FileInfo
	(*GetSourceFileRequest)(nil),            // 4: buf.alpha.registry.v1alpha1.GetSourceFileRequest
	(*GetSourceFileResponse)(nil),           // 5: buf.alpha.registry.v1alpha1.GetSourceFileResponse
	(*GetModulePackagesRequest)(nil),        // 6: buf.alpha.registry.v1alpha1.GetModulePackagesRequest
	(*GetModulePackagesResponse)(nil),       // 7: buf.alpha.registry.v1alpha1.GetModulePackagesResponse
	(*ModulePackage)(nil),                   // 8: buf.alpha.registry.v1alpha1.ModulePackage
	(*GetModuleDocumentationRequest)(nil),   // 9: buf.alpha.registry.v1alpha1.GetModuleDocumentationRequest
	(*GetModuleDocumentationResponse)(nil),  // 10: buf.alpha.registry.v1alpha1.GetModuleDocumentationResponse
	(*ModuleDocumentation)(nil),             // 11: buf.alpha.registry.v1alpha1.ModuleDocumentation
	(*GetPackageDocumentationRequest)(nil),  // 12: buf.alpha.registry.v1alpha1.GetPackageDocumentationRequest
	(*GetPackageDocumentationResponse)(nil), // 13: buf.alpha.registry.v1alpha1.GetPackageDocumentationResponse
	(*PackageDocumentation)(nil),            // 14: buf.alpha.registry.v1alpha1.PackageDocumentation
	(*Location)(nil),                        // 15: buf.alpha.registry.v1alpha1.Location
	(*Service)(nil),                         // 16: buf.alpha.registry.v1alpha1.Service
	(*ServiceOptions)(nil),                  // 17: buf.alpha.registry.v1alpha1.ServiceOptions
	(*Method)(nil),                          // 18: buf.alpha.registry.v1alpha1.Method
	(*MethodOptions)(nil),                   // 19: buf.alpha.registry.v1alpha1.MethodOptions
	(*MethodRequestResponse)(nil),           // 20: buf.alpha.registry.v1alpha1.MethodRequestResponse
	(*Enum)(nil),                            // 21: buf.alpha.registry.v1alpha1.Enum
	(*EnumOptions)(nil),                     // 22: buf.alpha.registry.v1alpha1.EnumOptions
	(*EnumValue)(nil),                       // 23: buf.alpha.registry.v1alpha1.EnumValue
	(*EnumValueOptions)(nil),                // 24: buf.alpha.registry.v1alpha1.EnumValueOptions
	(*ImportModuleRef)(nil),                 // 25: buf.alpha.registry.v1alpha1.ImportModuleRef
	(*Message)(nil),                         // 26: buf.alpha.registry.v1alpha1.Message
	(*MessageField)(nil),                    // 27: buf.alpha.registry.v1alpha1.MessageField
	(*MessageOptions)(nil),                  // 28: buf.alpha.registry.v1alpha1.MessageOptions
	(*Oneof)(nil),                           // 29: buf.alpha.registry.v1alpha1.Oneof
	(*Field)(nil),                           // 30: buf.alpha.registry.v1alpha1.Field
	(*FieldOptions)(nil),                    // 31: buf.alpha.registry.v1alpha1.FieldOptions
	(*FieldLiteral)(nil),                    // 32: buf.alpha.registry.v1alpha1.FieldLiteral
	(*MessageLiteral)(nil),                  // 33: buf.alpha.registry.v1alpha1.MessageLiteral
	(*ArrayLiteral)(nil),                    // 34: buf.alpha.registry.v1alpha1.ArrayLiteral
	(*LiteralValue)(nil),                    // 35: buf.alpha.registry.v1alpha1.LiteralValue
	(*MapEntry)(nil),                        // 36: buf.alpha.registry.v1alpha1.MapEntry
	(*FileExtension)(nil),                   // 37: buf.alpha.registry.v1alpha1.FileExtension
}
var file_buf_alpha_registry_v1alpha1_doc_proto_depIdxs = []int32{
	3,  // 0: buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoResponse.root:type_name -> buf.alpha.registry.v1alpha1.FileInfo
	3,  // 1: buf.alpha.registry.v1alpha1.FileInfo.children:type_name -> buf.alpha.registry.v1alpha1.FileInfo
	8,  // 2: buf.alpha.registry.v1alpha1.GetModulePackagesResponse.module_packages:type_name -> buf.alpha.registry.v1alpha1.ModulePackage
	11, // 3: buf.alpha.registry.v1alpha1.GetModuleDocumentationResponse.module_documentation:type_name -> buf.alpha.registry.v1alpha1.ModuleDocumentation
	14, // 4: buf.alpha.registry.v1alpha1.GetPackageDocumentationResponse.package_documentation:type_name -> buf.alpha.registry.v1alpha1.PackageDocumentation
	16, // 5: buf.alpha.registry.v1alpha1.PackageDocumentation.services:type_name -> buf.alpha.registry.v1alpha1.Service
	21, // 6: buf.alpha.registry.v1alpha1.PackageDocumentation.enums:type_name -> buf.alpha.registry.v1alpha1.Enum
	26, // 7: buf.alpha.registry.v1alpha1.PackageDocumentation.messages:type_name -> buf.alpha.registry.v1alpha1.Message
	37, // 8: buf.alpha.registry.v1alpha1.PackageDocumentation.file_extensions:type_name -> buf.alpha.registry.v1alpha1.FileExtension
	15, // 9: buf.alpha.registry.v1alpha1.Service.location:type_name -> buf.alpha.registry.v1alpha1.Location
	18, // 10: buf.alpha.registry.v1alpha1.Service.methods:type_name -> buf.alpha.registry.v1alpha1.Method
	32, // 11: buf.alpha.registry.v1alpha1.Service.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	17, // 12: buf.alpha.registry.v1alpha1.Service.service_options:type_name -> buf.alpha.registry.v1alpha1.ServiceOptions
	20, // 13: buf.alpha.registry.v1alpha1.Method.request:type_name -> buf.alpha.registry.v1alpha1.MethodRequestResponse
	20, // 14: buf.alpha.registry.v1alpha1.Method.response:type_name -> buf.alpha.registry.v1alpha1.MethodRequestResponse
	32, // 15: buf.alpha.registry.v1alpha1.Method.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	19, // 16: buf.alpha.registry.v1alpha1.Method.method_options:type_name -> buf.alpha.registry.v1alpha1.MethodOptions
	26, // 17: buf.alpha.registry.v1alpha1.MethodRequestResponse.message:type_name -> buf.alpha.registry.v1alpha1.Message
	25, // 18: buf.alpha.registry.v1alpha1.MethodRequestResponse.import_module_ref:type_name -> buf.alpha.registry.v1alpha1.ImportModuleRef
	15, // 19: buf.alpha.registry.v1alpha1.Enum.location:type_name -> buf.alpha.registry.v1alpha1.Location
	23, // 20: buf.alpha.registry.v1alpha1.Enum.values:type_name -> buf.alpha.registry.v1alpha1.EnumValue
	32, // 21: buf.alpha.registry.v1alpha1.Enum.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	22, // 22: buf.alpha.registry.v1alpha1.Enum.enum_options:type_name -> buf.alpha.registry.v1alpha1.EnumOptions
	32, // 23: buf.alpha.registry.v1alpha1.EnumValue.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	24, // 24: buf.alpha.registry.v1alpha1.EnumValue.enum_value_options:type_name -> buf.alpha.registry.v1alpha1.EnumValueOptions
	27, // 25: buf.alpha.registry.v1alpha1.Message.fields:type_name -> buf.alpha.registry.v1alpha1.MessageField
	15, // 26: buf.alpha.registry.v1alpha1.Message.location:type_name -> buf.alpha.registry.v1alpha1.Location
	30, // 27: buf.alpha.registry.v1alpha1.Message.message_extensions:type_name -> buf.alpha.registry.v1alpha1.Field
	32, // 28: buf.alpha.registry.v1alpha1.Message.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	28, // 29: buf.alpha.registry.v1alpha1.Message.message_options:type_name -> buf.alpha.registry.v1alpha1.MessageOptions
	30, // 30: buf.alpha.registry.v1alpha1.MessageField.field:type_name -> buf.alpha.registry.v1alpha1.Field
	29, // 31: buf.alpha.registry.v1alpha1.MessageField.oneof:type_name -> buf.alpha.registry.v1alpha1.Oneof
	30, // 32: buf.alpha.registry.v1alpha1.Oneof.fields:type_name -> buf.alpha.registry.v1alpha1.Field
	32, // 33: buf.alpha.registry.v1alpha1.Oneof.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	36, // 34: buf.alpha.registry.v1alpha1.Field.map_entry:type_name -> buf.alpha.registry.v1alpha1.MapEntry
	25, // 35: buf.alpha.registry.v1alpha1.Field.import_module_ref:type_name -> buf.alpha.registry.v1alpha1.ImportModuleRef
	32, // 36: buf.alpha.registry.v1alpha1.Field.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	31, // 37: buf.alpha.registry.v1alpha1.Field.field_options:type_name -> buf.alpha.registry.v1alpha1.FieldOptions
	0,  // 38: buf.alpha.registry.v1alpha1.FieldLiteral.field_type:type_name -> buf.alpha.registry.v1alpha1.FieldType
	35, // 39: buf.alpha.registry.v1alpha1.FieldLiteral.value:type_name -> buf.alpha.registry.v1alpha1.LiteralValue
	25, // 40: buf.alpha.registry.v1alpha1.FieldLiteral.import_module_ref:type_name -> buf.alpha.registry.v1alpha1.ImportModuleRef
	32, // 41: buf.alpha.registry.v1alpha1.MessageLiteral.fields:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	35, // 42: buf.alpha.registry.v1alpha1.ArrayLiteral.elements:type_name -> buf.alpha.registry.v1alpha1.LiteralValue
	34, // 43: buf.alpha.registry.v1alpha1.LiteralValue.array_value:type_name -> buf.alpha.registry.v1alpha1.ArrayLiteral
	33, // 44: buf.alpha.registry.v1alpha1.LiteralValue.message_value:type_name -> buf.alpha.registry.v1alpha1.MessageLiteral
	25, // 45: buf.alpha.registry.v1alpha1.MapEntry.value_import_module_ref:type_name -> buf.alpha.registry.v1alpha1.ImportModuleRef
	15, // 46: buf.alpha.registry.v1alpha1.FileExtension.location:type_name -> buf.alpha.registry.v1alpha1.Location
	30, // 47: buf.alpha.registry.v1alpha1.FileExtension.fields:type_name -> buf.alpha.registry.v1alpha1.Field
	1,  // 48: buf.alpha.registry.v1alpha1.DocService.GetSourceDirectoryInfo:input_type -> buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoRequest
	4,  // 49: buf.alpha.registry.v1alpha1.DocService.GetSourceFile:input_type -> buf.alpha.registry.v1alpha1.GetSourceFileRequest
	6,  // 50: buf.alpha.registry.v1alpha1.DocService.GetModulePackages:input_type -> buf.alpha.registry.v1alpha1.GetModulePackagesRequest
	9,  // 51: buf.alpha.registry.v1alpha1.DocService.GetModuleDocumentation:input_type -> buf.alpha.registry.v1alpha1.GetModuleDocumentationRequest
	12, // 52: buf.alpha.registry.v1alpha1.DocService.GetPackageDocumentation:input_type -> buf.alpha.registry.v1alpha1.GetPackageDocumentationRequest
	2,  // 53: buf.alpha.registry.v1alpha1.DocService.GetSourceDirectoryInfo:output_type -> buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoResponse
	5,  // 54: buf.alpha.registry.v1alpha1.DocService.GetSourceFile:output_type -> buf.alpha.registry.v1alpha1.GetSourceFileResponse
	7,  // 55: buf.alpha.registry.v1alpha1.DocService.GetModulePackages:output_type -> buf.alpha.registry.v1alpha1.GetModulePackagesResponse
	10, // 56: buf.alpha.registry.v1alpha1.DocService.GetModuleDocumentation:output_type -> buf.alpha.registry.v1alpha1.GetModuleDocumentationResponse
	13, // 57: buf.alpha.registry.v1alpha1.DocService.GetPackageDocumentation:output_type -> buf.alpha.registry.v1alpha1.GetPackageDocumentationResponse
	53, // [53:58] is the sub-list for method output_type
	48, // [48:53] is the sub-list for method input_type
	48, // [48:48] is the sub-list for extension type_name
	48, // [48:48] is the sub-list for extension extendee
	0,  // [0:48] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_doc_proto_init() }
func file_buf_alpha_registry_v1alpha1_doc_proto_init() {
	if File_buf_alpha_registry_v1alpha1_doc_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[26].OneofWrappers = []any{
		(*MessageField_Field)(nil),
		(*MessageField_Oneof)(nil),
	}
	file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[30].OneofWrappers = []any{}
	file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[34].OneofWrappers = []any{
		(*LiteralValue_StringValue)(nil),
		(*LiteralValue_IntValue)(nil),
		(*LiteralValue_UintValue)(nil),
		(*LiteralValue_DoubleValue)(nil),
		(*LiteralValue_BoolValue)(nil),
		(*LiteralValue_EnumValueNameValue)(nil),
		(*LiteralValue_ArrayValue)(nil),
		(*LiteralValue_MessageValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_doc_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_doc_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_doc_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_doc_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_doc_proto = out.File
	file_buf_alpha_registry_v1alpha1_doc_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_doc_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_doc_proto_depIdxs = nil
}
