// Copyright (c) 2008-2010 Andreas Gustafsson.  All rights reserved.
// Please refer to the file COPYRIGHT for detailed copyright information.

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "fatal.h"

void
fatal(const char *fmt, ...) {
    va_list args;
    va_start(args, fmt);
    fprintf(stderr, "error: ");
    vfprintf(stderr, fmt, args);
    va_end(args);
    fprintf(stderr, "\n");
    exit(1);
}
