class Inspector < Borges::Component

  def can_inspect(obj)
    case obj
    when Numeric, NilClass, TrueClass, FalseClass then
      true
    else
      false
    end
  end

  def choose(obj, name)
    @path.push obj, name
  end

  def initialize(obj = nil)
    @path = Path.new
    self.object = obj
  end

  def object
    @path.current_segment
  end

  def object=(obj)
    @path.push obj, obj.to_s
  end

  def self.on(obj)
    self.new(obj)
  end

  def render_content_on(r)
    super
    r.render @path
    r.heading object.inspect[0..50]
    render_members_on r
  end

  def render_members_on(r)
    members = object = inspector_fields
    return if members.empty?
    r.bold 'Members: '
    r.attributes[:border] = 1
    r.table do
      members.each do |k, v|
        render_row_for v, k, r
      end
    end
  end

  def render_row_for(obj, name, r)
    r.table_row do
      r.table_data do 
        if can_inspect obj then
          r.text name
        else
          r.anchor(name) do
            choose obj, name
          end
        end
      end

      r.table_data do
        r.text obj.inspect[0..100]
      end
    end
  end

end

