#ifndef _MAC_H_
#define _MAC_H_


#include <mac/All.h>
#include <mac/MACLib.h>

#ifdef __cplusplus
extern "C"{
#endif

#include <bmp/plugin.h>

#ifdef __cplusplus
}
#endif

#include <pthread.h>

#include <glib.h>

#include "common.h"
#include "version.h"

typedef struct
{
    gint playing, eof;

    gchar *title;
    AFormat sample_format;
    unsigned int bits_per_sample;
    unsigned int channels;
    unsigned int sample_rate;
    unsigned int length_in_ms;
    unsigned int block_align;
    

    int seek_to;

    IAPEDecompress *pAPEDecompress;

    pthread_t decoder_thread_id;
    
} PlayerInfo;

#ifdef __cplusplus
extern "C"{
#endif

static void mac_init();

static void mac_about();

static void mac_configure();

static int mac_is_our_file(char *filename);

static void mac_play_file(char *filename);

static void mac_stop();

static void mac_pause(short paused);

static void mac_seek(int time);

static int mac_get_time();

static void mac_cleanup();

static void mac_get_song_info(char *filename, char **title, int *length);

void mac_file_info_box(char *filename);

#ifdef __cplusplus
}
#endif

#endif
